/* SPDX-License-Identifier: BSD-3-Clause */
/*
 * Altera SoCFPGA SDRAM configuration
 *
 */

#ifndef __SOCFPGA_SDRAM_CONFIG_H__
#define __SOCFPGA_SDRAM_CONFIG_H__

/* SDRAM configuration */
#define CONFIG_HPS_SDR_CTRLCFG_CPORTRDWR_CPORTRDWR		0x5A56A
#define CONFIG_HPS_SDR_CTRLCFG_CPORTRMAP_CPORTRMAP		0xB00088
#define CONFIG_HPS_SDR_CTRLCFG_CPORTWIDTH_CPORTWIDTH		0x44555
#define CONFIG_HPS_SDR_CTRLCFG_CPORTWMAP_CPORTWMAP		0x2C011000
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_ADDRORDER		0
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_DQSTRKEN			0
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_ECCCORREN		0
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_ECCEN			0
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_MEMBL			8
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_MEMTYPE			1
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_NODMPINS			0
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_REORDEREN		1
#define CONFIG_HPS_SDR_CTRLCFG_CTRLCFG_STARVELIMIT		10
#define CONFIG_HPS_SDR_CTRLCFG_CTRLWIDTH_CTRLWIDTH		2
#define CONFIG_HPS_SDR_CTRLCFG_DRAMADDRW_BANKBITS		3
#define CONFIG_HPS_SDR_CTRLCFG_DRAMADDRW_COLBITS		10
#define CONFIG_HPS_SDR_CTRLCFG_DRAMADDRW_CSBITS			1
#define CONFIG_HPS_SDR_CTRLCFG_DRAMADDRW_ROWBITS		14
#define CONFIG_HPS_SDR_CTRLCFG_DRAMDEVWIDTH_DEVWIDTH		8
#define CONFIG_HPS_SDR_CTRLCFG_DRAMIFWIDTH_IFWIDTH		32
#define CONFIG_HPS_SDR_CTRLCFG_DRAMINTR_INTREN			0
#define CONFIG_HPS_SDR_CTRLCFG_DRAMODT_READ			0
#define CONFIG_HPS_SDR_CTRLCFG_DRAMODT_WRITE			1
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING1_AL			0
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING1_TCL			5
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING1_TCWL			4
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING1_TFAW			16
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING1_TRFC			60
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING1_TRRD			4
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING2_IF_TRCD		5
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING2_IF_TREFI		2341
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING2_IF_TRP		5
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING2_IF_TWR		5
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING2_IF_TWTR		2
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING3_TCCD			4
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING3_TMRD			2
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING3_TRAS			13
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING3_TRC			17
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING3_TRTP			3
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING4_PWRDOWNEXIT		3
#define CONFIG_HPS_SDR_CTRLCFG_DRAMTIMING4_SELFRFSHEXIT		200
#define CONFIG_HPS_SDR_CTRLCFG_EXTRATIME1_CFG_EXTRA_CTL_CLK_RD_TO_WR 3
#define CONFIG_HPS_SDR_CTRLCFG_EXTRATIME1_CFG_EXTRA_CTL_CLK_RD_TO_WR_BC 3
#define CONFIG_HPS_SDR_CTRLCFG_EXTRATIME1_CFG_EXTRA_CTL_CLK_RD_TO_WR_DIFF_CHIP 3
#define CONFIG_HPS_SDR_CTRLCFG_FIFOCFG_INCSYNC			0
#define CONFIG_HPS_SDR_CTRLCFG_FIFOCFG_SYNCMODE			0
#define CONFIG_HPS_SDR_CTRLCFG_FPGAPORTRST			0x0
#define CONFIG_HPS_SDR_CTRLCFG_LOWPWREQ_SELFRFSHMASK		3
#define CONFIG_HPS_SDR_CTRLCFG_LOWPWRTIMING_AUTOPDCYCLES	0
#define CONFIG_HPS_SDR_CTRLCFG_LOWPWRTIMING_CLKDISABLECYCLES	8
#define CONFIG_HPS_SDR_CTRLCFG_MPPACING_0_THRESHOLD1_31_0	0x20820820
#define CONFIG_HPS_SDR_CTRLCFG_MPPACING_1_THRESHOLD1_59_32	0x8208208
#define CONFIG_HPS_SDR_CTRLCFG_MPPACING_1_THRESHOLD2_3_0	0
#define CONFIG_HPS_SDR_CTRLCFG_MPPACING_2_THRESHOLD2_35_4	0x41041041
#define CONFIG_HPS_SDR_CTRLCFG_MPPACING_3_THRESHOLD2_59_36	0x410410
#define CONFIG_HPS_SDR_CTRLCFG_MPPRIORITY_USERPRIORITY		0x0
#define CONFIG_HPS_SDR_CTRLCFG_MPTHRESHOLDRST_0_THRESHOLDRSTCYCLES_31_0 0x01010101
#define CONFIG_HPS_SDR_CTRLCFG_MPTHRESHOLDRST_1_THRESHOLDRSTCYCLES_63_32 0x01010101
#define CONFIG_HPS_SDR_CTRLCFG_MPTHRESHOLDRST_2_THRESHOLDRSTCYCLES_79_64 0x0101
#define CONFIG_HPS_SDR_CTRLCFG_MPWIEIGHT_0_STATICWEIGHT_31_0	0x21084210
#define CONFIG_HPS_SDR_CTRLCFG_MPWIEIGHT_1_STATICWEIGHT_49_32	0x10441
#define CONFIG_HPS_SDR_CTRLCFG_MPWIEIGHT_1_SUMOFWEIGHT_13_0	0x78
#define CONFIG_HPS_SDR_CTRLCFG_MPWIEIGHT_2_SUMOFWEIGHT_45_14	0x0
#define CONFIG_HPS_SDR_CTRLCFG_MPWIEIGHT_3_SUMOFWEIGHT_63_46	0x0
#define CONFIG_HPS_SDR_CTRLCFG_PHYCTRL_PHYCTRL_0		0x200
#define CONFIG_HPS_SDR_CTRLCFG_PORTCFG_AUTOPCHEN		0
#define CONFIG_HPS_SDR_CTRLCFG_RFIFOCMAP_RFIFOCMAP		0x760210
#define CONFIG_HPS_SDR_CTRLCFG_STATICCFG_MEMBL			2
#define CONFIG_HPS_SDR_CTRLCFG_STATICCFG_USEECCASDATA		0
#define CONFIG_HPS_SDR_CTRLCFG_WFIFOCMAP_WFIFOCMAP		0x980543

/* Sequencer auto configuration */
#define RW_MGR_ACTIVATE_0_AND_1	0x11
#define RW_MGR_ACTIVATE_0_AND_1_WAIT1	0x12
#define RW_MGR_ACTIVATE_0_AND_1_WAIT2	0x14
#define RW_MGR_CLEAR_DQS_ENABLE	0x4B
#define RW_MGR_EMR	0x09
#define RW_MGR_EMR2	0x0D
#define RW_MGR_EMR3	0x0F
#define RW_MGR_EMR_OCD_ENABLE	0x0B
#define RW_MGR_GUARANTEED_READ	0x4E
#define RW_MGR_GUARANTEED_READ_CONT	0x56
#define RW_MGR_GUARANTEED_WRITE	0x1A
#define RW_MGR_GUARANTEED_WRITE_WAIT0	0x1D
#define RW_MGR_GUARANTEED_WRITE_WAIT1	0x21
#define RW_MGR_GUARANTEED_WRITE_WAIT2	0x1B
#define RW_MGR_GUARANTEED_WRITE_WAIT3	0x1F
#define RW_MGR_IDLE	0x00
#define RW_MGR_IDLE_LOOP1	0x77
#define RW_MGR_IDLE_LOOP2	0x76
#define RW_MGR_INIT_CKE_0	0x71
#define RW_MGR_LFSR_WR_RD_BANK_0	0x24
#define RW_MGR_LFSR_WR_RD_BANK_0_DATA	0x27
#define RW_MGR_LFSR_WR_RD_BANK_0_DQS	0x26
#define RW_MGR_LFSR_WR_RD_BANK_0_NOP	0x25
#define RW_MGR_LFSR_WR_RD_BANK_0_WAIT	0x34
#define RW_MGR_LFSR_WR_RD_BANK_0_WL_1	0x23
#define RW_MGR_LFSR_WR_RD_DM_BANK_0	0x38
#define RW_MGR_LFSR_WR_RD_DM_BANK_0_DATA	0x3B
#define RW_MGR_LFSR_WR_RD_DM_BANK_0_DQS	0x3A
#define RW_MGR_LFSR_WR_RD_DM_BANK_0_NOP	0x39
#define RW_MGR_LFSR_WR_RD_DM_BANK_0_WAIT	0x48
#define RW_MGR_LFSR_WR_RD_DM_BANK_0_WL_1	0x37
#define RW_MGR_MR_CALIB	0x05
#define RW_MGR_MR_DLL_RESET	0x07
#define RW_MGR_MR_USER	0x03
#define RW_MGR_NOP	0x01
#define RW_MGR_PRECHARGE_ALL	0x16
#define RW_MGR_READ_B2B	0x5B
#define RW_MGR_READ_B2B_WAIT1	0x63
#define RW_MGR_READ_B2B_WAIT2	0x6D
#define RW_MGR_REFRESH	0x18

/* Sequencer defines configuration */
#define AFI_CLK_FREQ	301
#define AFI_RATE_RATIO	1
#define CALIB_LFIFO_OFFSET	6
#define CALIB_VFIFO_OFFSET	4
#define ENABLE_SUPER_QUICK_CALIBRATION	0
#define IO_DELAY_PER_DCHAIN_TAP	25
#define IO_DELAY_PER_DQS_EN_DCHAIN_TAP	25
#define IO_DELAY_PER_OPA_TAP	416
#define IO_DLL_CHAIN_LENGTH	8
#define IO_DQDQS_OUT_PHASE_MAX	0
#define IO_DQS_EN_DELAY_MAX	31
#define IO_DQS_EN_DELAY_OFFSET	0
#define IO_DQS_EN_PHASE_MAX	7
#define IO_DQS_IN_DELAY_MAX	31
#define IO_DQS_IN_RESERVE	4
#define IO_DQS_OUT_RESERVE	4
#define IO_IO_IN_DELAY_MAX	31
#define IO_IO_OUT1_DELAY_MAX	31
#define IO_IO_OUT2_DELAY_MAX	0
#define IO_SHIFT_DQS_EN_WHEN_SHIFT_DQS	0
#define MAX_LATENCY_COUNT_WIDTH	5
#define READ_VALID_FIFO_SIZE	16
#define REG_FILE_INIT_SEQ_SIGNATURE	0x555504bf
#define RW_MGR_MEM_ADDRESS_MIRRORING	0
#define RW_MGR_MEM_DATA_MASK_WIDTH	4
#define RW_MGR_MEM_DATA_WIDTH	32
#define RW_MGR_MEM_DQ_PER_READ_DQS	8
#define RW_MGR_MEM_DQ_PER_WRITE_DQS	8
#define RW_MGR_MEM_IF_READ_DQS_WIDTH	4
#define RW_MGR_MEM_IF_WRITE_DQS_WIDTH	4
#define RW_MGR_MEM_NUMBER_OF_CS_PER_DIMM	1
#define RW_MGR_MEM_NUMBER_OF_RANKS	1
#define RW_MGR_MEM_VIRTUAL_GROUPS_PER_READ_DQS	1
#define RW_MGR_MEM_VIRTUAL_GROUPS_PER_WRITE_DQS	1
#define RW_MGR_TRUE_MEM_DATA_MASK_WIDTH	4
#define TINIT_CNTR0_VAL	74
#define TINIT_CNTR1_VAL	20
#define TINIT_CNTR2_VAL	20
#define TRESET_CNTR0_VAL	74
#define TRESET_CNTR1_VAL	99
#define TRESET_CNTR2_VAL	10

/* Sequencer ac_rom_init configuration */
const u32 ac_rom_init[] = {
	0x30700000,
	0x38700000,
	0x30700000,
	0x20700000,
	0x10000853,
	0x10000853,
	0x10000953,
	0x10010000,
	0x10010380,
	0x10020000,
	0x10030000,
	0x10300400,
	0x10600000,
	0x10620000,
	0x10200400,
	0x10400000,
	0x1c900000,
	0x1c920000,
	0x1c900008,
	0x1c920008,
	0x38f00000,
	0x3cf00000,
	0x38700000,
	0x10100000,
	0x18900000,
	0x13500000,
	0x13520000,
	0x13500008,
	0x13520008,
	0x33700000,
	0x10500008
};

/* Sequencer inst_rom_init configuration */
const u32 inst_rom_init[] = {
	0x80180,
	0x100,
	0x80000,
	0x200,
	0x80000,
	0x280,
	0x80000,
	0x300,
	0x80000,
	0x380,
	0x80000,
	0x400,
	0x80000,
	0x480,
	0x80000,
	0x500,
	0x80000,
	0x600,
	0x8000,
	0x680,
	0xa000,
	0x80000,
	0x700,
	0x80000,
	0x780,
	0x80000,
	0x968,
	0xcae8,
	0x8e8,
	0x8ae8,
	0x988,
	0xea88,
	0x808,
	0xaa88,
	0x80000,
	0xcc00,
	0xcb80,
	0xe080,
	0xa00,
	0x20ae0,
	0x20ae0,
	0x20ae0,
	0x20ae0,
	0xb00,
	0x0,
	0x0,
	0x0,
	0x0,
	0x60c80,
	0x60e80,
	0x60e80,
	0x60e80,
	0xa000,
	0x8000,
	0x80000,
	0xcc00,
	0xcb80,
	0xe080,
	0xa00,
	0x30ae0,
	0x30ae0,
	0x30ae0,
	0x30ae0,
	0xb00,
	0x0,
	0x0,
	0x0,
	0x0,
	0x70c80,
	0x70e80,
	0x70e80,
	0x70e80,
	0xa000,
	0x8000,
	0x80000,
	0xf58,
	0x58,
	0x80000,
	0xf68,
	0x168,
	0x168,
	0x8168,
	0x40de8,
	0x40ee8,
	0x40ee8,
	0x40ee8,
	0xf68,
	0x168,
	0x168,
	0xa168,
	0x80000,
	0x40c88,
	0x40e88,
	0x40e88,
	0x40e88,
	0x40d68,
	0x40ee8,
	0x40ee8,
	0x40ee8,
	0xa000,
	0x40de8,
	0x40ee8,
	0x40ee8,
	0x40ee8,
	0x40e08,
	0x40e88,
	0x40e88,
	0x40e88,
	0xf00,
	0xc000,
	0x8000,
	0xe000,
	0x80000,
	0x180,
	0x8180,
	0xa180,
	0xc180,
	0x80180,
	0x8000,
	0xa000,
	0x80000
};

#endif /* __SOCFPGA_SDRAM_CONFIG_H__ */
