/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.Cell;
import SharpTools.CellPoint;
import SharpTools.CellRange;
import SharpTools.Config;
import SharpTools.Debug;
import SharpTools.EditOp;
import SharpTools.FileOp;
import SharpTools.Formula;
import SharpTools.HelpOp;
import SharpTools.Histogram;
import SharpTools.History;
import SharpTools.MainApplet;
import SharpTools.SharpCellEditor;
import SharpTools.SharpCellRenderer;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTableModel;
import SharpTools.TableOp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class SharpTools
extends JFrame
implements ListSelectionListener {
    public URL backurl;
    public String reply_url;
    SharpTools spreadsheet;
    static boolean inapplet = false;
    static String language = "en";
    public static Properties translation = new Properties();
    protected int maxNumPage = 1;
    private Container container;
    private JTable table;
    private JScrollPane scrollPane;
    private JToolBar toolBar;
    private JMenuBar menuBar;
    private JPanel barPanel;
    private History history;
    private Histogram histogram;
    public SharpOptionPane sharpoptionpane;
    private static Config config;
    private ListSelectionModel rowSelectionModel;
    private ListSelectionModel columnSelectionModel;
    private URL url;
    private FileOp fileOp;
    private EditOp editOp;
    private TableOp tableOp;
    private SharpTableModel tableModel;
    private JMenu fileMenu;
    private JMenu openMenu;
    private JMenu recentMenu;
    private JMenu editMenu;
    private JMenu tableMenu;
    private JMenu chartMenu;
    private JMenu helpMenu;
    private JMenu insertMenu;
    private JMenu deleteMenu;
    private JMenu sortMenu;
    private JMenuItem saveMenuItem;
    private JCheckBoxMenuItem saveOnExitMenuItem;
    private JMenuItem undoMenuItem;
    private JMenuItem redoMenuItem;
    private JMenuItem findNextMenuItem;
    private JCheckBoxMenuItem showHistogramMenuItem;
    private JCheckBoxMenuItem showFunctionsMenuItem;
    private JButton exitButton;
    private JButton saveButton;
    private JButton passwordButton;
    private JButton undoButton;
    private JButton redoButton;
    private JComponent funcList;
    ImageIcon newIcon = new ImageIcon(this.getClass().getResource("/images/new.gif"));
    ImageIcon openIcon = new ImageIcon(this.getClass().getResource("/images/open.gif"));
    ImageIcon saveIcon = new ImageIcon(this.getClass().getResource("/images/save.gif"));
    ImageIcon unlockedIcon = new ImageIcon(this.getClass().getResource("/images/unlocked.gif"));
    ImageIcon lockedIcon = new ImageIcon(this.getClass().getResource("/images/locked.gif"));
    ImageIcon printIcon = new ImageIcon(this.getClass().getResource("/images/print.gif"));
    ImageIcon undoIcon = new ImageIcon(this.getClass().getResource("/images/undo.gif"));
    ImageIcon redoIcon = new ImageIcon(this.getClass().getResource("/images/redo.gif"));
    ImageIcon cutIcon = new ImageIcon(this.getClass().getResource("/images/cut.gif"));
    ImageIcon copyIcon = new ImageIcon(this.getClass().getResource("/images/copy.gif"));
    ImageIcon pasteIcon = new ImageIcon(this.getClass().getResource("/images/paste.gif"));
    ImageIcon findIcon = new ImageIcon(this.getClass().getResource("/images/find.gif"));
    ImageIcon insertRowIcon = new ImageIcon(this.getClass().getResource("/images/insertrow.gif"));
    ImageIcon insertColumnIcon = new ImageIcon(this.getClass().getResource("/images/insertcolumn.gif"));
    ImageIcon deleteRowIcon = new ImageIcon(this.getClass().getResource("/images/deleterow.gif"));
    ImageIcon deleteColumnIcon = new ImageIcon(this.getClass().getResource("/images/deletecolumn.gif"));
    ImageIcon sortIcon = new ImageIcon(this.getClass().getResource("/images/sort.gif"));
    ImageIcon chartIcon = new ImageIcon(this.getClass().getResource("/images/chart.gif"));
    ImageIcon helpIcon = new ImageIcon(this.getClass().getResource("/images/help.gif"));
    ImageIcon exitIcon = new ImageIcon(this.getClass().getResource("/images/no.gif"));
    ImageIcon WIMSIcon = new ImageIcon(this.getClass().getResource("/images/send.gif"));
    public static int baseRow;
    public static int baseCol;
    public int firstColWidth;
    private CellRange cellrange;

    public static Config getConfig() {
        return config;
    }

    public History getHistory() {
        return this.history;
    }

    public JTable getTable() {
        return this.table;
    }

    public SharpTableModel getTableModel() {
        return this.tableModel;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public SharpTools(boolean is_this_the_applet, String lang) {
        super("Sharp_Tools_Spreadsheet");
        int h;
        int w;
        int y;
        int x;
        language = lang;
        System.out.println("in Sharptools.java the language=" + language);
        if (is_this_the_applet) {
            inapplet = true;
            x = MainApplet.Xlocation;
            y = MainApplet.Ylocation;
            this.backurl = MainApplet.backurl;
            this.reply_url = MainApplet.reply_url;
        } else {
            inapplet = false;
            x = config.getInt("X");
            y = config.getInt("Y");
        }
        this.setLocation(x, y);
        translation = this.loadProperties(language);
        this.setDefaultCloseOperation(2);
        this.container = this.getContentPane();
        this.container.setLayout(new BorderLayout());
        this.table = new JTable();
        this.funcList = HelpOp.createFunctionListComponent(this, this.table);
        this.fileMenu = new JMenu("File", true);
        this.fileMenu.setMnemonic(70);
        JMenuItem menuItem = new JMenuItem(translation.getProperty("New"));
        menuItem.setMnemonic(78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!inapplet) {
                    SharpTools.this.fileOp.newFile();
                } else {
                    SharpTools.this.ReStart();
                }
            }
        });
        if (!inapplet) {
            this.fileMenu.add(menuItem);
            this.openMenu = new JMenu(translation.getProperty("Open"));
            this.openMenu.setMnemonic(79);
            menuItem = new JMenuItem(translation.getProperty("File"));
            menuItem.setMnemonic(70);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.openFile();
                }
            });
            this.openMenu.add(menuItem);
            menuItem = new JMenuItem(translation.getProperty("Database"));
            menuItem.setMnemonic(68);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.openDb();
                }
            });
            this.openMenu.add(menuItem);
            this.fileMenu.add(this.openMenu);
            this.saveMenuItem = new JMenuItem(translation.getProperty("Save"));
            this.saveMenuItem.setMnemonic(83);
            this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.saveMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.saveFile();
                }
            });
            this.fileMenu.add(this.saveMenuItem);
            menuItem = new JMenuItem(translation.getProperty("Save_As"));
            menuItem.setMnemonic(65);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.saveAsFile();
                }
            });
            this.fileMenu.add(menuItem);
            menuItem = new JMenuItem(translation.getProperty("Set_Password"));
            menuItem.setMnemonic(69);
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.setPassword();
                    SharpTools.this.checkPasswordState();
                }
            });
            this.fileMenu.add(menuItem);
            this.fileMenu.addSeparator();
            menuItem = new JMenuItem(translation.getProperty("Print"));
            menuItem.setMnemonic(80);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Thread runner = new Thread(){

                        public void run() {
                            SharpTools.this.fileOp.printData();
                        }
                    };
                    runner.start();
                }
            });
            this.fileMenu.add(menuItem);
            this.fileMenu.addSeparator();
            this.recentMenu = new JMenu(translation.getProperty("Recent_Files"));
            this.recentMenu.setMnemonic(82);
            this.recentMenu.addMenuListener(new MenuListener(){

                public void menuCanceled(MenuEvent e) {
                }

                public void menuDeselected(MenuEvent e) {
                }

                public void menuSelected(MenuEvent e) {
                    SharpTools.this.fileOp.createRecentFilesMenu(SharpTools.this.recentMenu);
                }
            });
            this.fileMenu.add(this.recentMenu);
            this.fileMenu.addSeparator();
            this.saveOnExitMenuItem = new JCheckBoxMenuItem(translation.getProperty("Save_Window_on_Exit"));
            this.saveOnExitMenuItem.setMnemonic(87);
            this.saveOnExitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    config.setBoolean("SAVEWINDOW", SharpTools.this.saveOnExitMenuItem.isSelected());
                }
            });
            this.saveOnExitMenuItem.setSelected(config.getBoolean("SAVEWINDOW"));
            this.fileMenu.add(this.saveOnExitMenuItem);
            this.fileMenu.addSeparator();
            menuItem = new JMenuItem(translation.getProperty("Exit"));
            menuItem.setMnemonic(88);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.exit();
                }
            });
            this.fileMenu.add(menuItem);
        }
        this.editMenu = new JMenu(translation.getProperty("Edit"), true);
        this.editMenu.setMnemonic(69);
        this.undoMenuItem = new JMenuItem(translation.getProperty("Undo"));
        this.undoMenuItem.setMnemonic(85);
        this.undoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.undo(SharpTools.this.tableModel);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.redoMenuItem = new JMenuItem(translation.getProperty("Redo"));
        this.redoMenuItem.setMnemonic(82);
        this.redoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.redo(SharpTools.this.tableModel);
            }
        });
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.addSeparator();
        menuItem = new JMenuItem(translation.getProperty("Cut"));
        menuItem.setMnemonic(84);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.cut();
            }
        });
        this.editMenu.add(menuItem);
        menuItem = new JMenuItem(translation.getProperty("Copy"));
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.copy();
            }
        });
        this.editMenu.add(menuItem);
        menuItem = new JMenuItem(translation.getProperty("Paste"));
        menuItem.setMnemonic(80);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.paste();
            }
        });
        this.editMenu.add(menuItem);
        this.editMenu.addSeparator();
        menuItem = new JMenuItem(translation.getProperty("Fill"));
        menuItem.setMnemonic(70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.fill();
            }
        });
        this.editMenu.add(menuItem);
        menuItem = new JMenuItem(translation.getProperty("Clear"));
        menuItem.setMnemonic(76);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0, true));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.clear();
            }
        });
        this.editMenu.add(menuItem);
        this.editMenu.addSeparator();
        menuItem = new JMenuItem(translation.getProperty("Find"));
        menuItem.setMnemonic(70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.find(true);
            }
        });
        this.editMenu.add(menuItem);
        this.findNextMenuItem = new JMenuItem(translation.getProperty("Find_Next"));
        this.findNextMenuItem.setMnemonic(78);
        this.findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.findNextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.find(false);
            }
        });
        this.editMenu.add(this.findNextMenuItem);
        this.tableMenu = new JMenu(translation.getProperty("Table"), true);
        this.tableMenu.setMnemonic(84);
        this.insertMenu = new JMenu(translation.getProperty("Insert"));
        this.insertMenu.setMnemonic(73);
        menuItem = new JMenuItem(translation.getProperty("Row"));
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(155, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(true);
            }
        });
        this.insertMenu.add(menuItem);
        menuItem = new JMenuItem(translation.getProperty("Column"));
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(155, 3));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(false);
            }
        });
        this.insertMenu.add(menuItem);
        this.tableMenu.add(this.insertMenu);
        this.deleteMenu = new JMenu(translation.getProperty("Delete"));
        this.deleteMenu.setMnemonic(68);
        menuItem = new JMenuItem(translation.getProperty("Row"));
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(true);
            }
        });
        this.deleteMenu.add(menuItem);
        menuItem = new JMenuItem(translation.getProperty("Column"));
        menuItem.setMnemonic(67);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 3));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(false);
            }
        });
        this.deleteMenu.add(menuItem);
        this.tableMenu.add(this.deleteMenu);
        this.tableMenu.addSeparator();
        this.sortMenu = new JMenu(translation.getProperty("Sort"));
        this.sortMenu.setMnemonic(83);
        menuItem = new JMenuItem(translation.getProperty("Row"));
        menuItem.setMnemonic(82);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.sort(true);
            }
        });
        this.sortMenu.add(menuItem);
        menuItem = new JMenuItem(translation.getProperty("Column"));
        menuItem.setMnemonic(67);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.sort(false);
            }
        });
        this.sortMenu.add(menuItem);
        this.tableMenu.add(this.sortMenu);
        this.tableMenu.addSeparator();
        menuItem = new JMenuItem(translation.getProperty("Set_Column_Width"));
        menuItem.setMnemonic(87);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.setColumnWidth();
            }
        });
        this.tableMenu.add(menuItem);
        menuItem = new JMenuItem(translation.getProperty("Set_First_Column_Width"));
        menuItem.setMnemonic(87);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.setFirstColumnWidth();
            }
        });
        this.tableMenu.add(menuItem);
        this.chartMenu = new JMenu(translation.getProperty("Chart"), true);
        this.chartMenu.setMnemonic(67);
        this.chartMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                SharpTools.this.checkShowHistogramState();
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuCanceled(MenuEvent e) {
            }
        });
        this.showHistogramMenuItem = new JCheckBoxMenuItem(translation.getProperty("Show"));
        this.showHistogramMenuItem.setMnemonic(83);
        this.showHistogramMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        this.showHistogramMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.histogram.toggle();
            }
        });
        this.chartMenu.add(this.showHistogramMenuItem);
        menuItem = new JMenuItem(translation.getProperty("Histogram"));
        menuItem.setMnemonic(72);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.histogram.addHistogram();
            }
        });
        this.chartMenu.add(menuItem);
        this.tableMenu.add(this.chartMenu);
        this.helpMenu = new JMenu(translation.getProperty("Help"), true);
        this.helpMenu.setMnemonic(72);
        menuItem = new JMenuItem(translation.getProperty("Help_Topics"));
        menuItem.setMnemonic(72);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    URL url = new URL("http://localhost/sharptools/");
                    new HelpOp(url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        this.helpMenu.add(menuItem);
        this.showFunctionsMenuItem = new JCheckBoxMenuItem(translation.getProperty("Show_Functions"));
        this.showFunctionsMenuItem.setMnemonic(83);
        if (inapplet) {
            this.showFunctionsMenuItem.setSelected(MainApplet.TOOLBAR_FUNCTIONS);
        } else {
            this.showFunctionsMenuItem.setSelected(config.getBoolean("TOOLBAR_FUNCTIONS"));
        }
        this.showFunctionsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean showFunc = SharpTools.this.showFunctionsMenuItem.isSelected();
                if (!inapplet) {
                    config.setBoolean("TOOLBAR_FUNCTIONS", showFunc);
                }
                SharpTools.this.funcList.setVisible(showFunc);
            }
        });
        this.helpMenu.add(this.showFunctionsMenuItem);
        this.helpMenu.addSeparator();
        menuItem = new JMenuItem(translation.getProperty("About_SharpTools"));
        menuItem.setMnemonic(65);
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HelpOp.showAboutBox(SharpTools.this);
                SharpTools.this.table.requestFocus();
            }
        });
        this.helpMenu.add(menuItem);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.tableMenu);
        this.menuBar.add(this.chartMenu);
        this.menuBar.add(this.helpMenu);
        JButton WIMSButton = new JButton(this.WIMSIcon);
        JButton newButton = new JButton(this.newIcon);
        JButton exitButton = new JButton(this.exitIcon);
        JButton openButton = new JButton(this.openIcon);
        JButton printButton = new JButton(this.printIcon);
        this.passwordButton = new JButton(this.unlockedIcon);
        this.saveButton = new JButton(this.saveIcon);
        if (!inapplet) {
            newButton.setToolTipText(translation.getProperty("New"));
            newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.newFile();
                    SharpTools.this.table.requestFocus();
                }
            });
            openButton.setToolTipText(translation.getProperty("Open"));
            openButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.openFile();
                    SharpTools.this.table.requestFocus();
                }
            });
            this.saveButton.setToolTipText(translation.getProperty("Save"));
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.saveFile();
                    SharpTools.this.table.requestFocus();
                }
            });
            this.passwordButton.setToolTipText(translation.getProperty("Set_Password"));
            this.passwordButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SharpTools.this.fileOp.setPassword();
                    SharpTools.this.table.requestFocus();
                }
            });
            printButton.setToolTipText(translation.getProperty("Print"));
            printButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Thread runner = new Thread(){

                        public void run() {
                            SharpTools.this.fileOp.printData();
                        }
                    };
                    runner.start();
                    SharpTools.this.table.requestFocus();
                }
            });
        }
        WIMSButton.setToolTipText(translation.getProperty("WIMS"));
        WIMSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (HelpOp.are_you_sure(SharpTools.this) == 0 && inapplet) {
                    SharpTools.this.send_to_wims();
                }
            }
        });
        this.undoButton = new JButton(this.undoIcon);
        this.undoButton.setToolTipText(translation.getProperty("Undo"));
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.undo(SharpTools.this.tableModel);
                SharpTools.this.table.requestFocus();
            }
        });
        this.redoButton = new JButton(this.redoIcon);
        this.redoButton.setToolTipText(translation.getProperty("Redo"));
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.history.redo(SharpTools.this.tableModel);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton cutButton = new JButton(this.cutIcon);
        cutButton.setToolTipText(translation.getProperty("Cut"));
        cutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.cut();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton copyButton = new JButton(this.copyIcon);
        copyButton.setToolTipText(translation.getProperty("Copy"));
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.copy();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton pasteButton = new JButton(this.pasteIcon);
        pasteButton.setToolTipText(translation.getProperty("Paste"));
        pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.paste();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton findButton = new JButton(this.findIcon);
        findButton.setToolTipText(translation.getProperty("Find"));
        findButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.editOp.find(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton sortButton = new JButton(this.sortIcon);
        sortButton.setToolTipText(translation.getProperty("Sort_by_Column"));
        sortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.sort(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton insertRowButton = new JButton(this.insertRowIcon);
        insertRowButton.setToolTipText(translation.getProperty("Insert_Row"));
        insertRowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton insertColumnButton = new JButton(this.insertColumnIcon);
        insertColumnButton.setToolTipText(translation.getProperty("Insert_Column"));
        insertColumnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.insert(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton deleteRowButton = new JButton(this.deleteRowIcon);
        deleteRowButton.setToolTipText(translation.getProperty("Delete_Row"));
        deleteRowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(true);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton deleteColumnButton = new JButton(this.deleteColumnIcon);
        deleteColumnButton.setToolTipText(translation.getProperty("Delete_Column"));
        deleteColumnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.tableOp.remove(false);
                SharpTools.this.table.requestFocus();
            }
        });
        JButton chartButton = new JButton(this.chartIcon);
        chartButton.setToolTipText(translation.getProperty("Histogram"));
        chartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SharpTools.this.histogram.addHistogram();
                SharpTools.this.table.requestFocus();
            }
        });
        JButton helpButton = new JButton(this.helpIcon);
        helpButton.setToolTipText(translation.getProperty("Help"));
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!inapplet) {
                        String basePath = System.getProperty("user.dir");
                    }
                    SharpTools.this.url = new URL("http://localhost/sharptools/");
                    new HelpOp(SharpTools.this.url);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
                SharpTools.this.table.requestFocus();
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        if (!inapplet) {
            this.toolBar.add(newButton);
            this.toolBar.add(openButton);
            this.toolBar.add(this.saveButton);
            this.toolBar.addSeparator();
            this.toolBar.add(this.passwordButton);
            this.toolBar.add(printButton);
            this.toolBar.addSeparator();
            this.toolBar.add(this.undoButton);
            this.toolBar.add(this.redoButton);
            this.toolBar.add(cutButton);
            this.toolBar.add(copyButton);
            this.toolBar.add(pasteButton);
            this.toolBar.add(findButton);
            this.toolBar.addSeparator();
            this.toolBar.add(insertRowButton);
            this.toolBar.add(insertColumnButton);
            this.toolBar.add(deleteRowButton);
            this.toolBar.add(deleteColumnButton);
            this.toolBar.add(sortButton);
            this.toolBar.addSeparator();
            this.toolBar.add(chartButton);
            this.toolBar.addSeparator();
            this.toolBar.add(helpButton);
            this.toolBar.addSeparator();
            this.toolBar.add(this.funcList);
            this.funcList.setVisible(true);
            this.newTableModel(config.getInt("ROWS"), config.getInt("COLUMNS"));
            w = config.getInt("WIDTH");
            h = config.getInt("HEIGHT");
        } else {
            if (MainApplet.TOOLBAR_UNDO) {
                this.toolBar.add(this.undoButton);
            }
            if (MainApplet.TOOLBAR_REDO) {
                this.toolBar.add(this.redoButton);
            }
            if (MainApplet.TOOLBAR_CUT) {
                this.toolBar.add(cutButton);
            }
            if (MainApplet.TOOLBAR_COPY) {
                this.toolBar.add(copyButton);
            }
            if (MainApplet.TOOLBAR_PASTE) {
                this.toolBar.add(pasteButton);
            }
            if (MainApplet.TOOLBAR_FIND) {
                this.toolBar.add(findButton);
            }
            this.toolBar.addSeparator();
            if (MainApplet.TOOLBAR_INSERTROW) {
                this.toolBar.add(insertRowButton);
            }
            if (MainApplet.TOOLBAR_INSERTCOLUMN) {
                this.toolBar.add(insertColumnButton);
            }
            if (MainApplet.TOOLBAR_DELETEROW) {
                this.toolBar.add(deleteRowButton);
            }
            if (MainApplet.TOOLBAR_DELETECOLUMN) {
                this.toolBar.add(deleteColumnButton);
            }
            if (MainApplet.TOOLBAR_SORTCOLUMN) {
                this.toolBar.add(sortButton);
            }
            this.toolBar.addSeparator();
            if (MainApplet.TOOLBAR_HISTOGRAM) {
                this.toolBar.add(chartButton);
                this.toolBar.addSeparator();
            }
            if (MainApplet.TOOLBAR_HELP) {
                this.toolBar.add(helpButton);
            }
            this.toolBar.addSeparator();
            this.toolBar.add(this.funcList);
            this.funcList.setVisible(MainApplet.TOOLBAR_FUNCTIONS);
            this.toolBar.addSeparator();
            this.toolBar.add(WIMSButton);
            this.newTableModel(MainApplet.ROWS, MainApplet.COLUMNS);
            w = MainApplet.window_width;
            h = MainApplet.window_height;
        }
        if (w >= 0 && h >= 0) {
            this.table.setPreferredScrollableViewportSize(new Dimension(w, h));
        }
        if (!inapplet) {
            this.fileOp = new FileOp(this);
        }
        this.table.setAutoResizeMode(3);
        this.table.setDefaultRenderer(Cell.class, new SharpCellRenderer());
        this.table.setDefaultEditor(Cell.class, new SharpCellEditor(new JTextField()));
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().addMouseListener(new HeaderMouseAdapter());
        this.rowSelectionModel = this.table.getSelectionModel();
        this.columnSelectionModel = this.table.getColumnModel().getSelectionModel();
        this.rowSelectionModel.addListSelectionListener(this);
        this.columnSelectionModel.addListSelectionListener(this);
        this.setJMenuBar(this.menuBar);
        this.container.add((Component)this.toolBar, "North");
        this.scrollPane = new JScrollPane(this.table, 22, 32);
        this.container.add((Component)this.scrollPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                SharpTools.this.table.requestFocus();
            }

            public void windowClosing(WindowEvent evt) {
                SharpTools.this.exit();
            }
        });
        this.resetSelection();
        this.table.setRequestFocusEnabled(true);
        this.menuBar.setRequestFocusEnabled(false);
        this.toolBar.setRequestFocusEnabled(false);
        this.table.requestFocus();
        this.pack();
        this.show();
    }

    public void setColumnWidth(int colWidth) {
        if (colWidth > 0) {
            for (int i = baseCol; i < this.tableModel.getColumnCount(); ++i) {
                TableColumn column = this.table.getColumnModel().getColumn(i);
                column.setMinWidth(colWidth);
                column.setPreferredWidth(colWidth);
            }
        }
    }

    public void newTableModel(int rows, int cols) {
        this.tableModel = new SharpTableModel(this, rows, cols);
        this.table.setModel(this.tableModel);
        this.setBaseColumnWidth(0);
        if (!inapplet) {
            this.setColumnWidth(config.getInt("COLUMNWIDTH"));
        } else {
            this.setColumnWidth(MainApplet.COLUMNWIDTH);
        }
        this.history = new History(this);
        this.tableModel.setHistory(this.history);
        this.tableModel.setPasswordModified(false);
        this.tableModel.setModified(false);
        if (this.editOp == null) {
            this.editOp = new EditOp(this);
        } else {
            this.editOp.init(this);
        }
        this.tableOp = new TableOp(this);
        this.histogram = !inapplet ? new Histogram(this, "Histograms", config.getInt("HISTOGRAMWIDTH"), config.getInt("HISTOGRAMHEIGHT")) : new Histogram(this, "Histograms", MainApplet.HISTOGRAMWIDTH, MainApplet.HISTOGRAMHEIGHT);
        this.tableModel.setModified(false);
        this.resetSelection();
        this.checkUndoRedoState();
        this.table.requestFocus();
    }

    public void noCellsSelected(String s) {
        SharpOptionPane.showMessageDialog(this, s + ": No cells selected", "Error", 0, null);
    }

    private void notYetImplemented() {
        SharpOptionPane.showMessageDialog(this, "Sorry, this function \nis not yet implemented!\nsharp@cs.columbia.edu", "Sharp Tools Spreadsheet", 2, null);
    }

    public void exit() {
        if (!inapplet) {
            if (this.fileOp.closeFile()) {
                if (config.getBoolean("SAVEWINDOW")) {
                    config.setInt("X", this.getX());
                    config.setInt("Y", this.getY());
                    Dimension dim = this.scrollPane.getViewport().getExtentSize();
                    config.setInt("WIDTH", (int)dim.getWidth());
                    config.setInt("HEIGHT", (int)dim.getHeight());
                }
                config.save();
                System.exit(0);
            }
        } else {
            this.setVisible(false);
        }
    }

    private void openInitFile(String filename) {
        if (!inapplet) {
            this.fileOp.openTableModel(new File(filename));
        }
    }

    public void checkSaveState() {
        boolean modified = this.tableModel.isModified();
        if (!inapplet) {
            this.saveMenuItem.setEnabled(modified);
            this.saveButton.setEnabled(modified);
        }
    }

    public void checkPasswordState() {
        if (!inapplet) {
            if (this.fileOp.hasPassword()) {
                this.passwordButton.setIcon(this.lockedIcon);
            } else {
                this.passwordButton.setIcon(this.unlockedIcon);
            }
        }
    }

    public void checkUndoRedoState() {
        boolean enable = this.history.isUndoable();
        this.undoMenuItem.setEnabled(enable);
        this.undoButton.setEnabled(enable);
        enable = this.history.isRedoable();
        this.redoMenuItem.setEnabled(enable);
        this.redoButton.setEnabled(enable);
    }

    public void checkFindNextState() {
        this.findNextMenuItem.setEnabled(this.editOp.hasFindValue());
    }

    public void checkShowHistogramState() {
        this.showHistogramMenuItem.setState(this.histogram.isVisible());
        this.showHistogramMenuItem.setEnabled(this.histogram.hasChart());
    }

    public void setBaseColumnWidth(int width) {
        if (width == 0) {
            if (baseCol > 0) {
                TableColumn firstColumn = this.table.getColumnModel().getColumn(baseCol - 1);
                int firstColWidth = !inapplet ? config.getInt("FIRSTCOLUMNWIDTH") : MainApplet.FIRSTCOLUMNWIDTH;
                if (firstColWidth > 0) {
                    firstColumn.setMinWidth(firstColWidth);
                    firstColumn.setPreferredWidth(firstColWidth);
                }
            }
        } else if (width > 0) {
            TableColumn firstColumn = this.table.getColumnModel().getColumn(baseCol - 1);
            firstColumn.setMinWidth(width);
            firstColumn.setPreferredWidth(width);
        }
    }

    public static void main(String[] args) {
        if (!inapplet) {
            config = new Config("sharptools.ini");
            config.setInt("ROWS", 20);
            config.setInt("COLUMNS", 10);
            config.setInt("HISTOGRAMWIDTH", 600);
            config.setInt("HISTOGRAMHEIGHT", 400);
            config.load();
            if (config.get("DEBUG") != null) {
                Debug.setDebug(config.getBoolean("DEBUG"));
            }
        }
        Formula.registerFunctions();
        SharpTools spreadsheet = new SharpTools(inapplet, language);
        spreadsheet.show();
        if (args.length > 0) {
            spreadsheet.openInitFile(args[0]);
        }
    }

    public static ImageIcon getImageIcon(String name) {
        URL imgurl = ClassLoader.getSystemResource(name);
        if (imgurl == null) {
            System.out.println("image " + name + " not found");
            return null;
        }
        return new ImageIcon(imgurl);
    }

    public void valueChanged(ListSelectionEvent e) {
        this.table.requestFocus();
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty() && this.table.getColumnCount() > baseCol && this.table.getRowCount() > baseRow) {
            this.table.setRowSelectionInterval(baseRow, baseRow);
            this.table.setColumnSelectionInterval(baseCol, baseCol);
        }
    }

    public void resetSelection() {
        this.table.setRowSelectionInterval(baseRow, baseRow);
        this.table.setColumnSelectionInterval(baseCol, baseCol);
    }

    public void openFileString(String sp) {
        StringBuffer textBuf = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(new StringReader(sp));
            String line = in.readLine();
            textBuf.append(line);
            textBuf.append("\n");
            while ((line = in.readLine()) != null) {
                textBuf.append(line);
                textBuf.append("\n");
            }
            String text = textBuf.toString();
            CellPoint size = SharpTableModel.getSize(text);
            this.newTableModel(size.getRow(), size.getCol());
            this.tableModel = this.getTableModel();
            this.tableModel.fromString(text, 0, 0, new CellRange(baseRow, size.getRow(), baseCol, size.getCol()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("in FileOp.java string = " + sp);
        }
    }

    public void ReStart() {
        this.setVisible(false);
        SharpTools spreadsheet = new SharpTools(inapplet, language);
        spreadsheet.show();
    }

    public String ReadRawSpreadSheet() {
        String reply = this.tableModel.toString();
        return reply;
    }

    public String ReadSpreadSheet(int type) {
        String reply = this.tableModel.toWIMS(type);
        return reply;
    }

    public void send_to_wims() {
        String reply = this.ReadSpreadSheet(MainApplet.type);
        if (MainApplet.convert_initial_tsv_to_matrix) {
            reply = reply + "\n" + MainApplet.initial_tsv_matrix;
        }
        reply = URLEncoder.encode(reply);
        try {
            this.backurl = new URL(this.reply_url + reply);
            MainApplet.applet_context.showDocument(this.backurl, "_self");
            this.dispose();
        }
        catch (MalformedURLException e) {
            this.backurl = null;
            System.out.println("could not send spreadsheet to wims " + this.reply_url);
        }
    }

    public Properties loadProperties(String lang) {
        Properties P = new Properties();
        try {
            InputStream in = this.getClass().getResourceAsStream("/lang/SharpToolsProperties_" + lang + ".properties");
            P.load(in);
            in.close();
            return P;
        }
        catch (Exception e) {
            System.out.println("error reading lang/SharpToolsProperties_" + lang + ".properties\n" + e);
            return null;
        }
    }

    static {
        baseRow = 0;
        baseCol = 1;
    }

    class HeaderMouseAdapter
    extends MouseAdapter {
        HeaderMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel colModel = SharpTools.this.table.getColumnModel();
            int col = colModel.getColumn(colModel.getColumnIndexAtX(e.getX())).getModelIndex();
            int rowCount = SharpTools.this.table.getRowCount();
            SharpTools.this.table.setRowSelectionInterval(baseRow, rowCount - 1);
            if (col < baseCol) {
                SharpTools.this.table.setColumnSelectionInterval(baseCol, SharpTools.this.table.getColumnCount() - 1);
            } else {
                SharpTools.this.table.setColumnSelectionInterval(col, col);
            }
        }
    }
}

