#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

#@PydevCodeAnalysisIgnore

import os
import sys

from winswitch.util.simple_logger import Logger
from winswitch.util.paths import ICON_DIR
from winswitch.util.icon_util import get_icon_from_data, HAS_PIXBUFLOADER
from winswitch.util.common import load_binary_file, get_platform_detail

ALL_BUILTIN = ["winswitch", "winswitch_logo", "winswitch-about-logo",
				"winswitch-warning", "winswitch_grey", "winswitch_indicator", "winswitch-dock", "winswitch_applet", "empty",
				"run", "desktop", "raise",
				"close", "user", "group", "laptop", "workstation", "server",
				"edit", "command-prompt",
				"ticked", "ticked-small", "unticked", "unticked-small",
				"open_file", "browse", "retry", "remove", "arrow-small-green", "configure", "servers",
				"unknown", "pause", "play", "stop", "connect", "disconnected", "delete", "remove", "plus", "minus", "copy", "shadow", "unavailable",
				"bsd", "linux", "fat_penguin", "baby_penguin", "osx", "solaris", "opensolaris", "openbsd",
				"windows", "bender", "cheguevara",
				"gun", "lock", "hammer", "passport", "lightbulb", "quit", "information", "star", "message",
				"speaker-on", "speaker-off", "microphone-on", "microphone-off", "clone-sound-on", "clone-sound-off",
				"clone-remote-sound-on", "clone-remote-sound-off", "clone-local-sound-on", "clone-local-sound-off",
				"nx", "xpra", "ssh", "vnc", "X11", "screen", "libvirt", "rdp", "gstvideo", "virtualbox",
				"download"]


logger=Logger("icons", log_colour=Logger.HIGHLIGHTED_BLUE)

init_done = False

def init_icons():
	if not HAS_PIXBUFLOADER:
		return
	for image in ALL_BUILTIN:
		filename = "%s.png" % image
		attr_name = image.replace("-", "_")
		full_path = os.path.join(ICON_DIR, filename)
		raw_data = load_binary_file(full_path)
		if raw_data:
			data = get_icon_from_data(raw_data)
			if not data:
				raise Exception("cannot load our default icons - missing gdk-pixbuf.loaders?")
			data.full_path_to_icon_file = full_path
			globals()[attr_name] = data
			globals()[attr_name+"_icon"] = data
		else:
			logger.serror("missing %s" % filename)
			sys.exit(1)

def try_get(name):
	if name in globals():
		return	globals()[name]
	return	None

def get(name):
	i = try_get(name)
	if i:
		return	i
	logger.serror("missing! icon_dir=%s" % ICON_DIR, name)
	raise Exception("Missing icon '%s', icon_dir=%s" % (name, ICON_DIR))


def get_raw_icondata_for_platform():
	return	do_get_raw_icondata_for_platform(get_platform_detail())

def do_get_raw_icondata_for_platform(platform, default="user"):
	logger.sdebug(None, platform, default)
	if platform:
		if platform.startswith("win"):
			return	getraw("windows")
		if platform.find("darwin")>=0:
			return	getraw("osx")
		if platform.find("openbsd")>=0:
			return	getraw("openbsd")
		if platform.find("bsd")>=0:
			return	getraw("bsd")
		if platform.find("linux")>=0:
			return	getraw("linux")
		if platform.find("opensolaris")>=0:
			return	getraw("opensolaris")
		if platform.find("solaris")>=0:
			return	getraw("solaris")
	if not default:
		return	None
	return	getraw(default)

raw_cache = {}
def getraw(name):
	assert name in ALL_BUILTIN
	global raw_cache
	attr_name = name.replace("-", "_")
	if attr_name in raw_cache:
		return	raw_cache[attr_name]
	filename = "%s.png" % name
	full_path = os.path.join(ICON_DIR, filename)
	raw_data = load_binary_file(full_path)
	if raw_data:
		raw_cache[attr_name]=raw_data
	return	raw_data


if not init_done:
	init_icons()
	init_done = True
