// Interface part of WManager
//
// Copyright (C) 1999  M. Tessmer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef Interface_H
#define Interface_H


// SYSTEM INCLUDES ////////////////////////////////////////////////////////////


// PROJECT INCLUDES ///////////////////////////////////////////////////////////


// LOCAL INCLUDES /////////////////////////////////////////////////////////////
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Browser.H>

//: WManager interface class
// This class implements the interface of wmanager.
class Interface {
public:
  
  //: Constructor
  Interface();
  
  //: Destructor
  ~Interface();

  //: Initialize the interface
  void 
  Init();

  //: Add one item to Hold_Browser widget
  //
  //! param: name - Window manager name
  //! param: path - Path to executable
  void
  AddToBrowser(const char* name,
	       const char* path);

  
  //: Enter the Fltk run loop
  //
  //! param: argc - No. of arguments
  //! param: argv - Array of arguments
  void
  Run(int    argc,
      char** argv);
  
  
private:
  Fl_Window*  _WMWindow;
  Fl_Button*  _ExitButton;
  Fl_Button*  _StartButton;
  Fl_Button*  _AboutButton;
  Fl_Browser* _ListBrowser;

  inline void
  _ExitButtonCb_i(Fl_Button*,
		  void*);
  static void
  _ExitButtonCb(Fl_Button*,
		void*);
  
  inline void
  _StartButtonCb_i(Fl_Button*,
		   void*);
  static void
  _StartButtonCb(Fl_Button*,
		 void*);
  
  inline void
  _AboutButtonCb_i(Fl_Button*,
		   void*);
  static void
  _AboutButtonCb(Fl_Button*,
		 void*);
  
  inline void
  _ListBrowserCb_i(Fl_Browser*,
		   void*);
  static void
  _ListBrowserCb(Fl_Browser*,
		 void*);
};

#endif // Interface_H
