/*  Common code for zcmp and zdiff
    Copyright (C) 2010-2015 Antonio Diaz Diaz.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef O_BINARY
#define O_BINARY 0
#endif


int open_instream( const std::string & input_filename )
  {
  const int infd = open( input_filename.c_str(), O_RDONLY | O_BINARY );
  if( infd < 0 )
    show_error2( "Can't open input file", input_filename.c_str() );
  return infd;
  }


int open_other_instream( std::string & name )
  {
  const int eindex = extension_index( name );
  if( eindex >= 0 && enabled_format( -1 ) )
    {					// open uncompressed version
    name.resize( name.size() - std::strlen( extension_from( eindex ) ) );
    name += extension_to( eindex );
    return open( name.c_str(), O_RDONLY | O_BINARY );
    }
  if( eindex < 0 )
    for( int i = 0; i < num_formats; ++i )
      if( enabled_format( format_order[i] ) )
        {				// search compressed version
        const std::string s( name + simple_extensions[format_order[i]] );
        const int infd = open( s.c_str(), O_RDONLY | O_BINARY );
        if( infd >= 0 ) { name = s; return infd; }
        }
  return -1;
  }


void parse_format_types2( const std::string & arg, int format_types[2] )
  {
  const unsigned i = std::min( arg.find( ',' ), arg.size() );
  if( i > 0 ) format_types[0] = parse_format_type( arg.substr( 0, i ) );
  else format_types[0] = -1;
  if( i + 1 < arg.size() ) format_types[1] =
    parse_format_type( arg.substr( i + 1 ) );
  else format_types[1] = -1;
  }


bool check_identical( const char * const name1, const char * const name2 )
  {
  if( !std::strcmp( name1, name2 ) ) return true;
  struct stat stat1, stat2;
  if( stat( name1, &stat1 ) || stat( name2, &stat2 ) ) return false;
  return ( stat1.st_ino == stat2.st_ino && stat1.st_dev == stat2.st_dev );
  }
