/*
 *  Stress test for case insensitive regexp normalization, a set of
 *  random ranges.
 */

/*@include util-regexp.js@*/

/*---
{
    "slow": true
}
---*/

// Last updated for Unicode 12.1.
/*===
[\u325e-\uceff] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F5327 T40098 F12544
[\u2ca8-\u50a2] F4256 T38 F1 T1 F5 T1 F7130 T9211 F44893
[\u1a4d-\u757e] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F3132 T38 F1 T1 F5 T1 F2 T43 F2 T3 F2381 T23346 F12491 T2 F305 T1 F72 T1 F22585
[\u2a8b-\u968a] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F3618 T38 F1 T1 F5 T1 F3247 T1 F3341 T27648 F26997
[\u6bc7-\uf7ea] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F20024 T35876 F2069
[\u1aa4-\udfff] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F166 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F3132 T38 F1 T1 F5 T1 F2 T43 F2 T3 F672 T80 F1716 T50524 F8192
[\u93d2-\ua21e] F37842 T3661 F24033
[\u94e4-\ua8ea] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F6633 T1 F240 T1 F20 T1 F30549 T5127 F616 T1 F21676
[\ue39e-\uefa5] F58270 T3080 F4186
[\u6381-\u7bd6] F25473 T6230 F33833
[\u7762-\ubc07] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F22995 T17574 F17400
[\udc16-\uf14b] F56342 T5430 F3764
[\u5c2b-\ubf3a] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F16028 T25360 F16581
[\u144e-\uc9b6] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F166 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F3132 T38 F1 T1 F5 T1 F2 T43 F2 T3 F672 T80 F94 T46441 F13897
[\u99db-\ue30c] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F31820 T18738 F7411
[\u5ff8-\uaf5c] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F17001 T20325 F20643
[\ubcb2-\uc4b9] F48306 T2056 F15174
[\u2bd9-\ufd35] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F3585 T38 F1 T1 F5 T1 F722 T80 F2200 T1 F240 T1 F3 T1 F16 T1 F3658 T53597 F714
[\u87ec-\uc788] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F27229 T16285 F14455
[\u5a25-\ua42f] F23077 T18955 F23504
[\ud53f-\ue3c5] F54591 T3719 F7226
[\u582f-\u98ef] F22575 T16577 F26384
[\u5c7a-\u74a4] F23674 T6187 F35675
[\uba14-\ue730] F47636 T11549 F6351
[\u8e88-\u9ab8] F36488 T3121 F25927
[\u8b66-\ub435] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F28119 T10448 F19402
[\u7d4d-\u8cad] F32077 T3937 F29522
[\u0782-\ua7eb] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F166 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F798 T41066 F871 T1 F28 T80 F21568
[\ud9ca-\uf2c3] F55754 T6394 F3388
[\u9979-\uff8c] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F31722 T26132 F115
[\u1ba8-\u3343] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F3132 T38 F1 T1 F5 T1 F2 T43 F2 T3 F2728 T6044 F29446 T2 F305 T1 F72 T1 F22585
[\u3999-\uda03] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F7178 T41067 F9724
[\u75fe-\uda79] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F22639 T25724 F9606
[\u70e8-\ube6b] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F21337 T19844 F16788
[\u0d9c-\u78e6] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F2360 T27467 F11619 T2 F305 T1 F72 T1 F937 T80 F21568
[\u7081-\uc724] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F21234 T22180 F14555
[\u3ab4-\ufa24] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F7461 T49009 F1499
[\uc727-\ucd81] F50983 T1627 F12926
[\u3793-\ufb88] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F6660 T50166 F1143
[\u35a7-\u6bd2] F13735 T13868 F37933
[\u28a1-\u8104] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F3618 T38 F1 T1 F5 T1 F3247 T1 F2851 T22628 F32507
[\u6dea-\u9497] F28138 T9902 F27496
[\u1226-\uac22] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F166 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F3132 T38 F1 T1 F5 T1 F2 T43 F2 T3 F294 T39421 F21469
[\u237e-\u3784] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F3618 T38 F1 T1 F5 T1 F3247 T1 F1536 T5127 F51323
[\u3054-\u9334] F12372 T25313 F27851
[\ub287-\ue25e] F45703 T12248 F7585
[\u3ec1-\u52b0] F16065 T5104 F44367
[\u30e5-\uc311] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F4950 T37421 F15598
[\u8665-\ubc1e] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F26838 T13754 F17377
[\u8305-\ub47c] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F25974 T12664 F19331
[\u1cbe-\u5ba9] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F3302 T38 F1 T1 F5 T1 F48 T2 F3006 T16108 F19411 T1 F72 T1 F22585
[\u69d3-\ue758] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F19524 T32134 F6311
[\uba6a-\ufdb6] F47722 T17229 F585
[\u1d0e-\u2e7e] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F3302 T38 F1 T1 F5 T1 F3136 T4465 F30974 T1 F72 T1 F22585
[\u63eb-\u8f95] F25579 T11179 F28778
[\u025b-\u21db] F181 T1 F218 T1 F2 T2 F1 T2 F4 T2 F1 T1 F6 T1 F2 T1 F4 T1 F2 T2 F4 T1 F140 T2 F21 T8065 F2694 T3 F9 T1 F145 T38 F1 T1 F5 T1 F31004 T2 F305 T1 F15 T1 F28 T5 F1 T3 F18 T2 F937 T80 F21568
[\ua1f7-\ubc4f] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F33896 T6745 F17328
[\u27a2-\uf06b] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F3585 T38 F1 T1 F5 T1 F722 T80 F2200 T1 F240 T1 F3 T1 F16 T1 F2579 T51402 F3988
[\u0776-\u9c7c] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F786 T38151 F2509 T2 F305 T1 F72 T1 F937 T80 F21568
[\u2e44-\u68fc] F11844 T15033 F38659
[\u0278-\ue618] F181 T1 F240 T1 F2 T1 F4 T1 F2 T2 F4 T1 F130 T1 F3 T3 F3 T2 F10 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F6 T58273 F6631
[\u7095-\uf136] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F21254 T32930 F3785
[\ubd57-\uf9c1] F48471 T15467 F1598
[\ub287-\uff9d] F45703 T19735 F98
[\u4419-\u5bfe] F17433 T6118 F41985
[\u18d8-\ub354] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F166 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F3132 T38 F1 T1 F5 T1 F2 T43 F2 T3 F672 T80 F1256 T39549 F19627
[\u3764-\ub304] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F6613 T31649 F19707
[\ud635-\uf629] F54837 T8181 F2518
[\u2fb4-\uf268] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F4645 T49845 F3479
[\u21b8-\u502d] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F3618 T38 F1 T1 F5 T1 F3247 T1 F1082 T11894 F45010
[\u28ea-\u5179] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F3618 T38 F1 T1 F5 T1 F3247 T1 F2924 T10384 F44678
[\u704e-\u9f46] F28750 T12025 F24761
[\ua521-\ue99d] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F34706 T17533 F5730
[\u8b3e-\ua990] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F6633 T1 F240 T1 F20 T1 F28079 T7763 F450 T1 F21676
[\u4b2e-\u88a4] F19246 T15735 F30555
[\uceb5-\ufeb5] F52917 T12289 F330
[\u0555-\u2a59] F837 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F205 T9513 F521 T1 F156 T38 F1 T1 F5 T1 F31004 T2 F305 T1 F72 T1 F937 T80 F21568
[\u35cc-\u940c] F13772 T24129 F27635
[\u0769-\u21f3] F837 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F773 T6795 F2671 T1 F156 T38 F1 T1 F5 T1 F31004 T2 F305 T1 F72 T1 F937 T80 F21568
[\u5739-\u8565] F22329 T11821 F31386
[\u08bc-\ufd36] F570 T1 F3 T3 F15 T3 F9 T1 F4 T1 F3 T2 F3 T3 F4 T1 F11 T1 F4 T1 F4 T1 F21 T2 F166 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F1112 T62587 F713
[\u737a-\u7f96] F29562 T3101 F32873
[\u6453-\uc68a] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F18116 T25144 F14709
[\ua645-\ub578] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F34997 T3893 F19079
[\ucff4-\ud49c] F53236 T1193 F11107
[\u0742-\u41d6] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F734 T14997 F25715 T2 F305 T1 F72 T1 F937 T80 F21568
[\uc1d4-\uf198] F49620 T12229 F3687
[\u2c7d-\u33ca] F575 T2 F3679 T38 F1 T1 F5 T1 F7087 T1870 F52277
[\u1d6a-\u270f] F837 T1 F83 T1 F31 T1 F6576 T2470 F1363 T1 F31513 T1 F72 T1 F22585
[\uc907-\ue032] F51463 T5932 F8141
[\u87c8-\uf396] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F27193 T27599 F3177
[\u143c-\u4cd2] F570 T1 F3 T3 F15 T3 F24 T1 F5 T1 F11 T1 F199 T1 F83 T1 F31 T1 F88 T1 F1 T1 F9 T1 F2 T2 F7 T1 F7 T1 F1 T1 F9 T1 F2 T2 F7 T1 F23 T2 F3132 T38 F1 T1 F5 T1 F2 T43 F2 T3 F828 T14487 F22903 T2 F305 T1 F72 T1 F22585
[\ua75d-\uad1e] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2441 T1 F20 T1 F35277 T1475 F21217
[\u68f9-\uacb1] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F19306 T17337 F21326
[\u35b8-\u4116] F13752 T2911 F48873
[\u006c-\u58eb] F76 T15 F17 T22656 F19806 T2 F305 T1 F15 T1 F28 T5 F1 T3 F18 T2 F937 T80 F21568
[\u8361-\ua3e6] F33633 T8326 F23577
[\u6c08-\ud5bd] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F20089 T27062 F10818
[\u4fc1-\u8dc5] F20417 T15877 F29242
[\u5f3d-\udd40] F604 T1 F4 T1 F3 T2 F3 T1 F1 T1 F21 T1 F4 T1 F21 T2 F4353 T80 F2200 T1 F240 T1 F20 T1 F16814 T32260 F8895
===*/

function test() {
    var re;
    var i;

    [
        [ 12894, 52991 ],
        [ 11432, 20642 ],
        [ 6733, 30078 ],
        [ 10891, 38538 ],
        [ 27591, 63466 ],
        [ 6820, 57343 ],
        [ 37842, 41502 ],
        [ 38116, 43242 ],
        [ 58270, 61349 ],
        [ 25473, 31702 ],
        [ 30562, 48135 ],
        [ 56342, 61771 ],
        [ 23595, 48954 ],
        [ 5198, 51638 ],
        [ 39387, 58124 ],
        [ 24568, 44892 ],
        [ 48306, 50361 ],
        [ 11225, 64821 ],
        [ 34796, 51080 ],
        [ 23077, 42031 ],
        [ 54591, 58309 ],
        [ 22575, 39151 ],
        [ 23674, 29860 ],
        [ 47636, 59184 ],
        [ 36488, 39608 ],
        [ 35686, 46133 ],
        [ 32077, 36013 ],
        [ 1922, 42987 ],
        [ 55754, 62147 ],
        [ 39289, 65420 ],
        [ 7080, 13123 ],
        [ 14745, 55811 ],
        [ 30206, 55929 ],
        [ 28904, 48747 ],
        [ 3484, 30950 ],
        [ 28801, 50980 ],
        [ 15028, 64036 ],
        [ 50983, 52609 ],
        [ 14227, 64392 ],
        [ 13735, 27602 ],
        [ 10401, 33028 ],
        [ 28138, 38039 ],
        [ 4646, 44066 ],
        [ 9086, 14212 ],
        [ 12372, 37684 ],
        [ 45703, 57950 ],
        [ 16065, 21168 ],
        [ 12517, 49937 ],
        [ 34405, 48158 ],
        [ 33541, 46204 ],
        [ 7358, 23465 ],
        [ 27091, 59224 ],
        [ 47722, 64950 ],
        [ 7438, 11902 ],
        [ 25579, 36757 ],
        [ 603, 8667 ],
        [ 41463, 48207 ],
        [ 10146, 61547 ],
        [ 1910, 40060 ],
        [ 11844, 26876 ],
        [ 632, 58904 ],
        [ 28821, 61750 ],
        [ 48471, 63937 ],
        [ 45703, 65437 ],
        [ 17433, 23550 ],
        [ 6360, 45908 ],
        [ 14180, 45828 ],
        [ 54837, 63017 ],
        [ 12212, 62056 ],
        [ 8632, 20525 ],
        [ 10474, 20857 ],
        [ 28750, 40774 ],
        [ 42273, 59805 ],
        [ 35646, 43408 ],
        [ 19246, 34980 ],
        [ 52917, 65205 ],
        [ 1365, 10841 ],
        [ 13772, 37900 ],
        [ 1897, 8691 ],
        [ 22329, 34149 ],
        [ 2236, 64822 ],
        [ 29562, 32662 ],
        [ 25683, 50826 ],
        [ 42565, 46456 ],
        [ 53236, 54428 ],
        [ 1858, 16854 ],
        [ 49620, 61848 ],
        [ 11389, 13258 ],
        [ 7530, 9999 ],
        [ 51463, 57394 ],
        [ 34760, 62358 ],
        [ 5180, 19666 ],
        [ 42845, 44318 ],
        [ 26873, 44209 ],
        [ 13752, 16662 ],
        [ 108, 22763 ],
        [ 33633, 41958 ],
        [ 27656, 54717 ],
        [ 20417, 36293 ],
        [ 24381, 56640 ]
    ].forEach(function (v) {
        re = RegExpUtil.makeCaseInsensitiveCharClassRegExp(v[0], v[1]);
        print(re.source, RegExpUtil.getRegExpSingleCharMatches(re));
    });
}

try {
    test();
} catch (e) {
    print(e.stack || e);
}

/*
var count = 0;
while (count < 100) {
    var lower = Math.floor(Math.random() * 65536);
    var upper = Math.floor(Math.random() * 65536);
    if (upper >= lower) {
        print(lower, upper);
        count++
    }
}
*/
