/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.attributes.LineNumberTableEntry;

public class LineNumberTableAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "LineNumberTable";
    private static final int INITIAL_LENGTH = 2;
    private LineNumberTableEntry[] lineNumberTable;

    public LineNumberTableEntry[] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public void setLineNumberTable(LineNumberTableEntry[] lineNumberTableEntryArray) {
        this.lineNumberTable = lineNumberTableEntryArray;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        this.lineNumberTable = new LineNumberTableEntry[n];
        for (int i = 0; i < n; ++i) {
            this.lineNumberTable[i] = LineNumberTableEntry.create(dataInput, this.classFile);
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        int n = this.getLength(this.lineNumberTable);
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.lineNumberTable[i].write(dataOutput);
        }
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public int getAttributeLength() {
        return 2 + this.getLength(this.lineNumberTable) * 4;
    }

    protected void debug(String string) {
        super.debug(string + "LineNumberTable attribute with " + this.getLength(this.lineNumberTable) + " entries");
    }
}

