/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#include <rtl/ustring.hxx>
#include <svl/sharedstring.hxx>
#include "PropertyIds.hxx"
#include <unordered_map>

namespace writerfilter::dmapper{

const OUString & getPropertyName( PropertyIds eId )
{
    static const std::unordered_map<PropertyIds, OUString> constPropertyMap {
        { PROP_CHAR_WEIGHT, u"CharWeight"_ustr},
        { PROP_CHAR_POSTURE, u"CharPosture"_ustr},
        { PROP_CHAR_STRIKEOUT, u"CharStrikeout"_ustr},
        { PROP_CHAR_CONTOURED, u"CharContoured"_ustr},
        { PROP_CHAR_SHADOWED, u"CharShadowed"_ustr},
        { PROP_CHAR_CASE_MAP, u"CharCaseMap"_ustr},
        { PROP_CHAR_COLOR, u"CharColor"_ustr},
        { PROP_CHAR_COMPLEX_COLOR, u"CharComplexColor"_ustr},
        { PROP_CHAR_RELIEF, u"CharRelief"_ustr},
        { PROP_CHAR_UNDERLINE, u"CharUnderline"_ustr},
        { PROP_CHAR_UNDERLINE_COLOR, u"CharUnderlineColor"_ustr},
        { PROP_CHAR_UNDERLINE_COMPLEX_COLOR, u"CharUnderlineComplexColor"_ustr},
        { PROP_CHAR_UNDERLINE_HAS_COLOR, u"CharUnderlineHasColor"_ustr},
        { PROP_CHAR_WORD_MODE, u"CharWordMode"_ustr},
        { PROP_CHAR_ESCAPEMENT, u"CharEscapement"_ustr},
        { PROP_CHAR_ESCAPEMENT_HEIGHT, u"CharEscapementHeight"_ustr},
        { PROP_CHAR_HEIGHT, u"CharHeight"_ustr},
        { PROP_CHAR_HEIGHT_COMPLEX, u"CharHeightComplex"_ustr},
        { PROP_CHAR_LOCALE, u"CharLocale"_ustr},
        { PROP_CHAR_LOCALE_ASIAN, u"CharLocaleAsian"_ustr},
        { PROP_CHAR_LOCALE_COMPLEX, u"CharLocaleComplex"_ustr},
        { PROP_CHAR_WEIGHT_COMPLEX, u"CharWeightComplex"_ustr},
        { PROP_CHAR_POSTURE_COMPLEX, u"CharPostureComplex"_ustr},
        { PROP_CHAR_CHAR_KERNING, u"CharKerning"_ustr},
        { PROP_CHAR_AUTO_KERNING, u"CharAutoKerning"_ustr},
        { PROP_CHAR_SCALE_WIDTH, u"CharScaleWidth"_ustr},
        { PROP_CHAR_STYLE_NAME, u"CharStyleName"_ustr},
        { PROP_CHAR_FONT_NAME, u"CharFontName"_ustr},
        { PROP_CHAR_FONT_CHAR_SET, u"CharFontCharSet"_ustr},
        { PROP_CHAR_FONT_NAME_ASIAN, u"CharFontNameAsian"_ustr},
        { PROP_CHAR_HEIGHT_ASIAN, u"CharHeightAsian"_ustr},
        { PROP_CHAR_FONT_NAME_COMPLEX, u"CharFontNameComplex"_ustr},
        { PROP_CHAR_HIDDEN, u"CharHidden"_ustr},
        { PROP_CHAR_WEIGHT_ASIAN, u"CharWeightAsian"_ustr},
        { PROP_CHAR_POSTURE_ASIAN, u"CharPostureAsian"_ustr},
        { PROP_CHAR_BACK_COLOR, u"CharBackColor"_ustr},
        { PROP_CHAR_BACKGROUND_COMPLEX_COLOR, u"CharBackgroundComplexColor"_ustr},
        { PROP_CHAR_EMPHASIS, u"CharEmphasis"_ustr},
        { PROP_CHAR_COMBINE_IS_ON, u"CharCombineIsOn"_ustr},
        { PROP_CHAR_COMBINE_PREFIX, u"CharCombinePrefix"_ustr},
        { PROP_CHAR_COMBINE_SUFFIX, u"CharCombineSuffix"_ustr},
        { PROP_CHAR_ROTATION, u"CharRotation"_ustr},
        { PROP_CHAR_ROTATION_IS_FIT_TO_LINE, u"CharRotationIsFitToLine"_ustr},
        { PROP_CHAR_FLASH, u"CharFlash"_ustr},
        { PROP_CHAR_LEFT_BORDER, u"CharLeftBorder"_ustr},
        { PROP_CHAR_RIGHT_BORDER, u"CharRightBorder"_ustr},
        { PROP_CHAR_TOP_BORDER, u"CharTopBorder"_ustr},
        { PROP_CHAR_BOTTOM_BORDER, u"CharBottomBorder"_ustr},
        { PROP_CHAR_LEFT_BORDER_DISTANCE, u"CharLeftBorderDistance"_ustr},
        { PROP_CHAR_RIGHT_BORDER_DISTANCE, u"CharRightBorderDistance"_ustr},
        { PROP_CHAR_TOP_BORDER_DISTANCE, u"CharTopBorderDistance"_ustr},
        { PROP_CHAR_BOTTOM_BORDER_DISTANCE, u"CharBottomBorderDistance"_ustr},
        { PROP_CHAR_BORDER_LEFT_COMPLEX_COLOR, u"CharLeftBorderComplexColor"_ustr},
        { PROP_CHAR_BORDER_RIGHT_COMPLEX_COLOR, u"CharRightBorderComplexColor"_ustr},
        { PROP_CHAR_BORDER_TOP_COMPLEX_COLOR, u"CharTopBorderComplexColor"_ustr},
        { PROP_CHAR_BORDER_BOTTOM_COMPLEX_COLOR, u"CharBottomBorderComplexColor"_ustr},
        { PROP_CHAR_SHADOW_FORMAT, u"CharShadowFormat"_ustr},
        { PROP_CHAR_HIGHLIGHT, u"CharHighlight"_ustr},
        { PROP_PARA_STYLE_NAME, u"ParaStyleName"_ustr},
        { PROP_PARA_ADJUST, u"ParaAdjust"_ustr},
        { PROP_PARA_VERT_ALIGNMENT, u"ParaVertAlignment"_ustr},
        { PROP_PARA_LAST_LINE_ADJUST, u"ParaLastLineAdjust"_ustr},
        { PROP_PARA_RIGHT_MARGIN, u"ParaRightMargin"_ustr},
        { PROP_PARA_RIGHT_MARGIN_UNIT, u"ParaRightMarginUnit"_ustr},
        { PROP_PARA_LEFT_MARGIN, u"ParaLeftMargin"_ustr},
        { PROP_PARA_LEFT_MARGIN_UNIT, u"ParaLeftMarginUnit"_ustr},
        { PROP_PARA_FIRST_LINE_INDENT, u"ParaFirstLineIndent"_ustr},
        { PROP_PARA_FIRST_LINE_INDENT_UNIT, u"ParaFirstLineIndentUnit"_ustr},
        { PROP_PARA_KEEP_TOGETHER, u"ParaKeepTogether"_ustr},
        { PROP_PARA_TOP_MARGIN, u"ParaTopMargin"_ustr},
        { PROP_PARA_TOP_MARGIN_BEFORE_AUTO_SPACING, u"ParaTopMarginBeforeAutoSpacing"_ustr},
        { PROP_PARA_BOTTOM_MARGIN_AFTER_AUTO_SPACING, u"ParaBottomMarginAfterAutoSpacing"_ustr},
        { PROP_PARA_CONTEXT_MARGIN, u"ParaContextMargin"_ustr},
        { PROP_PARA_BOTTOM_MARGIN, u"ParaBottomMargin"_ustr},
        { PROP_PARA_IS_HYPHENATION, u"ParaIsHyphenation"_ustr},
        { PROP_PARA_HYPHENATION_NO_CAPS, u"ParaHyphenationNoCaps"_ustr},
        { PROP_PARA_HYPHENATION_ZONE, u"ParaHyphenationZone"_ustr},
        { PROP_PARA_HYPHENATION_KEEP, u"ParaHyphenationKeep"_ustr},
        { PROP_PARA_HYPHENATION_KEEP_TYPE, u"ParaHyphenationKeepType"_ustr},
        { PROP_PARA_HYPHENATION_KEEP_LINE, u"ParaHyphenationKeepLine"_ustr},
        { PROP_PARA_LINE_NUMBER_COUNT, u"ParaLineNumberCount"_ustr},
        { PROP_PARA_IS_HANGING_PUNCTUATION, u"ParaIsHangingPunctuation"_ustr},
        { PROP_PARA_LINE_SPACING, u"ParaLineSpacing"_ustr},
        { PROP_PARA_TAB_STOPS, u"ParaTabStops"_ustr},
        { PROP_PARA_TOP_BORDER, u"ParaTopBorder"_ustr},
        { PROP_PARA_TOP_BORDER_DISTANCE, u"ParaTopBorderDistance"_ustr},
        { PROP_PARA_BORDER_TOP_COMPLEX_COLOR, u"ParaTopBorderComplexColor"_ustr},
        { PROP_PARA_LEFT_BORDER, u"ParaLeftBorder"_ustr},
        { PROP_PARA_LEFT_BORDER_DISTANCE, u"ParaLeftBorderDistance"_ustr},
        { PROP_PARA_BORDER_LEFT_COMPLEX_COLOR, u"ParaLeftBorderComplexColor"_ustr},
        { PROP_PARA_BOTTOM_BORDER, u"ParaBottomBorder"_ustr},
        { PROP_PARA_BOTTOM_BORDER_DISTANCE, u"ParaBottomBorderDistance"_ustr},
        { PROP_PARA_BORDER_BOTTOM_COMPLEX_COLOR, u"ParaBottomBorderComplexColor"_ustr},
        { PROP_PARA_RIGHT_BORDER, u"ParaRightBorder"_ustr},
        { PROP_PARA_RIGHT_BORDER_DISTANCE, u"ParaRightBorderDistance"_ustr},
        { PROP_PARA_BORDER_RIGHT_COMPLEX_COLOR, u"ParaRightBorderComplexColor"_ustr},
        { PROP_PARA_WIDOWS, u"ParaWidows"_ustr},
        { PROP_PARA_WORD_SPACING, u"ParaWordSpacing"_ustr},
        { PROP_PARA_WORD_SPACING_MAXIMUM, u"ParaWordSpacingMaximum"_ustr},
        { PROP_PARA_WORD_SPACING_MINIMUM, u"ParaWordSpacingMinimum"_ustr},
        { PROP_PARA_ORPHANS, u"ParaOrphans"_ustr},
        { PROP_PARA_LINE_NUMBER_START_VALUE, u"ParaLineNumberStartValue"_ustr},
        { PROP_NUMBERING_LEVEL, u"NumberingLevel"_ustr},
        { PROP_NUMBERING_RULES, u"NumberingRules"_ustr},
        { PROP_NUMBERING_TYPE, u"NumberingType"_ustr},
        { PROP_START_WITH, u"StartWith"_ustr},
        { PROP_ADJUST, u"Adjust"_ustr},
        { PROP_PARENT_NUMBERING, u"ParentNumbering"_ustr},
        { PROP_RIGHT_MARGIN, u"RightMargin"_ustr},
        { PROP_LEFT_MARGIN, u"LeftMargin"_ustr},
        { PROP_TOP_MARGIN, u"TopMargin"_ustr},
        { PROP_BOTTOM_MARGIN, u"BottomMargin"_ustr},
        { PROP_FIRST_LINE_OFFSET, u"FirstLineOffset"_ustr},
        { PROP_LEFT_BORDER, u"LeftBorder"_ustr},
        { PROP_RIGHT_BORDER, u"RightBorder"_ustr},
        { PROP_TOP_BORDER, u"TopBorder"_ustr},
        { PROP_BOTTOM_BORDER, u"BottomBorder"_ustr},
        { PROP_BORDER_LEFT_COMPLEX_COLOR, u"LeftBorderComplexColor"_ustr},
        { PROP_BORDER_RIGHT_COMPLEX_COLOR, u"RightBorderComplexColor"_ustr},
        { PROP_BORDER_TOP_COMPLEX_COLOR, u"TopBorderComplexColor"_ustr},
        { PROP_BORDER_BOTTOM_COMPLEX_COLOR, u"BottomBorderComplexColor"_ustr},
        { PROP_TABLE_BORDER, u"TableBorder"_ustr},
        { PROP_TABLE_ROW_DELETE, u"TableRowDelete"_ustr},
        { PROP_TABLE_ROW_INSERT, u"TableRowInsert"_ustr},
        { PROP_TABLE_CELL_DELETE, u"TableCellDelete"_ustr},
        { PROP_TABLE_CELL_INSERT, u"TableCellInsert"_ustr},
        { PROP_LEFT_BORDER_DISTANCE, u"LeftBorderDistance"_ustr},
        { PROP_RIGHT_BORDER_DISTANCE, u"RightBorderDistance"_ustr},
        { PROP_TOP_BORDER_DISTANCE, u"TopBorderDistance"_ustr},
        { PROP_BOTTOM_BORDER_DISTANCE, u"BottomBorderDistance"_ustr},
        { PROP_CURRENT_PRESENTATION, u"CurrentPresentation"_ustr},
        { PROP_IS_FIXED, u"IsFixed"_ustr},
        { PROP_SUB_TYPE, u"SubType"_ustr},
        { PROP_FILE_FORMAT, u"FileFormat"_ustr},
        { PROP_HYPER_LINK_U_R_L, u"HyperLinkURL"_ustr},
        { PROP_HYPERLINK, u"Hyperlink"_ustr},
        { PROP_NUMBER_FORMAT, u"NumberFormat"_ustr},
        { PROP_NAME, u"Name"_ustr},
        { PROP_IS_INPUT, u"IsInput"_ustr},
        { PROP_HINT, u"Hint"_ustr},
        { PROP_FULL_NAME, u"FullName"_ustr},
        { PROP_DESCRIPTION, u"Description"_ustr},
        { PROP_MACRO_NAME, u"MacroName"_ustr},
        { PROP_TITLE, u"Title"_ustr},
        { PROP_CONTENT, u"Content"_ustr},
        { PROP_INPUT_STREAM, u"InputStream"_ustr},
        { PROP_GRAPHIC, u"Graphic"_ustr},
        { PROP_ANCHOR_TYPE, u"AnchorType"_ustr},
        { PROP_SIZE, u"Size"_ustr},
        { PROP_HORI_ORIENT, u"HoriOrient"_ustr},
        { PROP_HORI_ORIENT_POSITION, u"HoriOrientPosition"_ustr},
        { PROP_HORI_ORIENT_RELATION, u"HoriOrientRelation"_ustr},
        { PROP_VERT_ORIENT, u"VertOrient"_ustr},
        { PROP_VERT_ORIENT_POSITION, u"VertOrientPosition"_ustr},
        { PROP_VERT_ORIENT_RELATION, u"VertOrientRelation"_ustr},
        { PROP_SIZE100th_M_M, u"Size100thMM"_ustr},
        { PROP_SIZE_PIXEL, u"SizePixel"_ustr},
        { PROP_SURROUND, u"Surround"_ustr},
        { PROP_SURROUND_CONTOUR, u"SurroundContour"_ustr},
        { PROP_ADJUST_CONTRAST, u"AdjustContrast"_ustr},
        { PROP_ADJUST_LUMINANCE, u"AdjustLuminance"_ustr},
        { PROP_GRAPHIC_COLOR_MODE, u"GraphicColorMode"_ustr},
        { PROP_CONTOUR_OUTSIDE, u"ContourOutside"_ustr},
        { PROP_CONTOUR_POLY_POLYGON, u"ContourPolyPolygon"_ustr},
        { PROP_PAGE_TOGGLE, u"PageToggle"_ustr},
        { PROP_BACK_COLOR, u"BackColor"_ustr},
        { PROP_BACK_COMPLEX_COLOR, u"BackComplexColor"_ustr},
        { PROP_BACK_COLOR_TRANSPARENCY, u"BackColorTransparency"_ustr},
        { PROP_ALLOW_OVERLAP, u"AllowOverlap"_ustr},
        { PROP_ALTERNATIVE_TEXT, u"AlternativeText"_ustr},
        { PROP_HEADER_TEXT_LEFT, u"HeaderTextLeft"_ustr},
        { PROP_HEADER_TEXT_FIRST, u"HeaderTextFirst"_ustr},
        { PROP_HEADER_TEXT, u"HeaderText"_ustr},
        { PROP_HEADER_IS_SHARED, u"HeaderIsShared"_ustr},
        { PROP_HEADER_IS_ON, u"HeaderIsOn"_ustr},
        { PROP_FIRST_IS_SHARED, u"FirstIsShared"_ustr},
        { PROP_FOOTER_TEXT_LEFT, u"FooterTextLeft"_ustr},
        { PROP_FOOTER_TEXT_FIRST, u"FooterTextFirst"_ustr},
        { PROP_FOOTER_TEXT, u"FooterText"_ustr},
        { PROP_FOOTER_IS_SHARED, u"FooterIsShared"_ustr},
        { PROP_FOOTER_IS_ON, u"FooterIsOn"_ustr},
        { PROP_FOOTNOTE_COUNTING, u"FootnoteCounting"_ustr},
        { PROP_FOOTNOTE_LINE_ADJUST, u"FootnoteLineAdjust"_ustr},
        { PROP_WIDTH, u"Width"_ustr},
        { PROP_HEIGHT, u"Height"_ustr},
        { PROP_TEXT_COLUMNS, u"TextColumns"_ustr},
        { PROP_AUTOMATIC_DISTANCE, u"AutomaticDistance"_ustr},
        { PROP_IS_LANDSCAPE, u"IsLandscape"_ustr},
        { PROP_FIRST_PAGE, u"First Page"_ustr},
        { PROP_PAGE_DESC_NAME, u"PageDescName"_ustr},
        { PROP_PAGE_NUMBER_OFFSET, u"PageNumberOffset"_ustr},
        { PROP_BREAK_TYPE, u"BreakType"_ustr},
        { PROP_FOOTER_IS_DYNAMIC_HEIGHT, u"FooterIsDynamicHeight"_ustr},
        { PROP_FOOTER_DYNAMIC_SPACING, u"FooterDynamicSpacing"_ustr},
        { PROP_FOOTER_HEIGHT, u"FooterHeight"_ustr},
        { PROP_FOOTER_BODY_DISTANCE, u"FooterBodyDistance"_ustr},
        { PROP_HEADER_IS_DYNAMIC_HEIGHT, u"HeaderIsDynamicHeight"_ustr},
        { PROP_HEADER_DYNAMIC_SPACING, u"HeaderDynamicSpacing"_ustr},
        { PROP_HEADER_HEIGHT, u"HeaderHeight"_ustr},
        { PROP_HEADER_BODY_DISTANCE, u"HeaderBodyDistance"_ustr},
        { PROP_WRITING_MODE, u"WritingMode"_ustr},
        { PROP_GRID_MODE, u"GridMode"_ustr},
        { PROP_GRID_DISPLAY, u"GridDisplay"_ustr},
        { PROP_GRID_PRINT, u"GridPrint"_ustr},
        { PROP_GRID_LINES, u"GridLines"_ustr},
        { PROP_GRID_BASE_HEIGHT, u"GridBaseHeight"_ustr},
        { PROP_GRID_BASE_WIDTH, u"GridBaseWidth"_ustr},
        { PROP_GRID_RUBY_HEIGHT, u"GridRubyHeight"_ustr},
        { PROP_GRID_STANDARD_MODE, u"StandardPageMode"_ustr},
        { PROP_IS_ON, u"IsOn"_ustr},
        { PROP_RESTART_AT_EACH_PAGE, u"RestartAtEachPage"_ustr},
        { PROP_COUNT_EMPTY_LINES, u"CountEmptyLines"_ustr},
        { PROP_COUNT_LINES_IN_FRAMES, u"CountLinesInFrames"_ustr},
        { PROP_INTERVAL, u"Interval"_ustr},
        { PROP_DISTANCE, u"Distance"_ustr},
        { PROP_NUMBER_POSITION, u"NumberPosition"_ustr},
        { PROP_LEVEL, u"Level"_ustr},
        { PROP_LEVEL_FOLLOW, u"LabelFollowedBy"_ustr},
        { PROP_LEVEL_PARAGRAPH_STYLES, u"LevelParagraphStyles"_ustr},
        { PROP_LEVEL_FORMAT, u"LevelFormat"_ustr},
        { PROP_LEVEL_IS_LEGAL, u"IsLegal"_ustr},
        { PROP_LIST_FORMAT, u"ListFormat"_ustr},
        { PROP_TOKEN_TYPE, u"TokenType"_ustr},
        { PROP_TOKEN_HYPERLINK_START, u"TokenHyperlinkStart"_ustr},
        { PROP_TOKEN_HYPERLINK_END, u"TokenHyperlinkEnd"_ustr},
        { PROP_TOKEN_CHAPTER_INFO, u"TokenChapterInfo"_ustr},
        { PROP_CHAPTER_FORMAT, u"ChapterFormat"_ustr},
        { PROP_TOKEN_TEXT, u"TokenText"_ustr},
        { PROP_TEXT, u"Text"_ustr},
        { PROP_CREATE_FROM_OUTLINE, u"CreateFromOutline"_ustr},
        { PROP_CREATE_FROM_MARKS, u"CreateFromMarks"_ustr},
        { PROP_STANDARD, u"Standard"_ustr},
        { PROP_SPLIT, u"Split"_ustr},
        { PROP_IS_SPLIT_ALLOWED, u"IsSplitAllowed"_ustr},
        { META_PROP_VERTICAL_BORDER, u"VerticalBorder"_ustr},
        { META_PROP_HORIZONTAL_BORDER, u"HorizontalBorder"_ustr},
        { PROP_HEADER_ROW_COUNT, u"HeaderRowCount"_ustr},
        { PROP_SIZE_TYPE, u"SizeType"_ustr},
        { PROP_TABLE_COLUMN_SEPARATORS, u"TableColumnSeparators"_ustr},
        { META_PROP_TABLE_STYLE_NAME, u"TableStyleName"_ustr},
        { PROP_TABLE_REDLINE_PARAMS, u"TableRedlineParams"_ustr},
        { PROP_REDLINE_AUTHOR, u"RedlineAuthor"_ustr},
        { PROP_REDLINE_DATE_TIME, u"RedlineDateTime"_ustr},
        { PROP_REDLINE_TYPE, u"RedlineType"_ustr},
        { PROP_REDLINE_REVERT_PROPERTIES, u"RedlineRevertProperties"_ustr},
        { PROP_IS_PROTECTED, u"IsProtected"_ustr},
        { PROP_SIZE_PROTECTED, u"SizeProtected"_ustr},
        { PROP_POSITION_PROTECTED, u"PositionProtected"_ustr},
        { PROP_OPAQUE, u"Opaque"_ustr},
        { PROP_VERTICAL_MERGE, u"VerticalMerge"_ustr},
        { PROP_BULLET_CHAR, u"BulletChar"_ustr},
        { PROP_BULLET_FONT_NAME, u"BulletFontName"_ustr},
        { PROP_TABS_RELATIVE_TO_INDENT, u"TabsRelativeToIndent"_ustr},
        { PROP_CREATE_FROM_LEVEL_PARAGRAPH_STYLES, u"CreateFromLevelParagraphStyles"_ustr},
        { PROP_DROP_CAP_FORMAT, u"DropCapFormat"_ustr},
        { PROP_REFERENCE_FIELD_FLAGS, u"ReferenceFieldFlags"_ustr},
        { PROP_REFERENCE_FIELD_PART, u"ReferenceFieldPart"_ustr},
        { PROP_SOURCE_NAME, u"SourceName"_ustr},
        { PROP_REFERENCE_FIELD_SOURCE, u"ReferenceFieldSource"_ustr},
        { PROP_WIDTH_TYPE, u"WidthType"_ustr},
        { PROP_TBL_LOOK, u"TblLook"_ustr},
        { PROP_TEXT_RANGE, u"TextRange"_ustr},
        { PROP_TEXT_VERTICAL_ADJUST, u"TextVerticalAdjust"_ustr},
        { PROP_SERVICE_CHAR_STYLE, u"com.sun.star.style.CharacterStyle"_ustr},
        { PROP_SERVICE_PARA_STYLE, u"com.sun.star.style.ParagraphStyle"_ustr},
        { PROP_CHARACTER_STYLES, u"CharacterStyles"_ustr},
        { PROP_PARAGRAPH_STYLES, u"ParagraphStyles"_ustr},
        { PROP_TABLE_BORDER_DISTANCES, u"TableBorderDistances"_ustr},
        { META_PROP_CELL_MAR_TOP, u"MetaPropCellMarTop"_ustr},
        { META_PROP_CELL_MAR_BOTTOM, u"MetaPropCellMarBottom"_ustr},
        { META_PROP_CELL_MAR_LEFT, u"MetaPropCellMarLeft"_ustr},
        { META_PROP_CELL_MAR_RIGHT, u"MetaPropCellMarRight"_ustr},
        { PROP_START_AT, u"StartAt"_ustr},
        { PROP_CHAR_PROP_HEIGHT, u"CharPropHeight"_ustr},
        { PROP_CHAR_PROP_HEIGHT_ASIAN, u"CharPropHeightAsian"_ustr},
        { PROP_CHAR_PROP_HEIGHT_COMPLEX, u"CharPropHeightComplex"_ustr},
        { PROP_FORMAT, u"Format"_ustr},
        { PROP_INSERT, u"Insert"_ustr},
        { PROP_DELETE, u"Delete"_ustr},
        { PROP_PARAGRAPH_FORMAT, u"ParagraphFormat"_ustr},
        { PROP_STREAM_NAME, u"StreamName"_ustr},
        { PROP_BITMAP, u"Bitmap"_ustr},
        { PROP_IS_DATE, u"IsDate"_ustr},
        { PROP_TAB_STOP_DISTANCE, u"TabStopDistance"_ustr},
        { PROP_INDENT_AT, u"IndentAt"_ustr},
        { PROP_FIRST_LINE_INDENT, u"FirstLineIndent"_ustr},
        { PROP_NUMBERING_STYLE_NAME, u"NumberingStyleName"_ustr},
        { PROP_OUTLINE_LEVEL, u"OutlineLevel"_ustr},
        { PROP_LISTTAB_STOP_POSITION, u"ListtabStopPosition"_ustr},
        { PROP_POSITION_AND_SPACE_MODE, u"PositionAndSpaceMode"_ustr},
        { PROP_PARA_SPLIT, u"ParaSplit"_ustr},
        { PROP_HELP, u"Help"_ustr},
        { PROP_HEADING_STYLE_NAME, u"HeadingStyleName"_ustr},
        { PROP_FRM_DIRECTION, u"FRMDirection"_ustr},
        { PROP_EMBEDDED_OBJECT, u"EmbeddedObject"_ustr},
        { PROP_IS_VISIBLE, u"IsVisible"_ustr},
        { PROP_PAGE_STYLE_LAYOUT, u"PageStyleLayout"_ustr},
        { PROP_Z_ORDER, u"ZOrder"_ustr},
        { PROP_EMBED_FONTS, u"EmbedFonts"_ustr},
        { PROP_EMBED_SYSTEM_FONTS, u"EmbedSystemFonts"_ustr},
        { PROP_SHADOW_FORMAT, u"ShadowFormat"_ustr},
        { PROP_RELATIVE_WIDTH, u"RelativeWidth"_ustr},
        { PROP_IS_WIDTH_RELATIVE, u"IsWidthRelative"_ustr},
        { PROP_GRAPHIC_BITMAP, u"GraphicBitmap"_ustr},
        { PROP_GRAPHIC_SIZE, u"GraphicSize"_ustr},
        { PROP_CHAR_SHADING_VALUE, u"CharShadingValue"_ustr},
        { PROP_CHAR_SHADING_MARKER, u"CharShadingMarker"_ustr},
        { PROP_LABEL_CATEGORY, u"LabelCategory"_ustr},
        { PROP_MIRROR_INDENTS, u"MirrorIndents"_ustr},
        { PROP_SURROUND_TEXT_WRAP_SMALL, u"SurroundTextWrapSmall"_ustr},
        { PROP_PARA_SHADOW_FORMAT, u"ParaShadowFormat"_ustr},
        { PROP_FOOTNOTE_LINE_RELATIVE_WIDTH, u"FootnoteLineRelativeWidth"_ustr},
        { PROP_TBL_HEADER, u"TblHeader"_ustr},
        { PROP_CHAR_THEME_NAME_ASCII, u"CharThemeNameAscii"_ustr},
        { PROP_CHAR_THEME_NAME_CS, u"CharThemeNameCs"_ustr},
        { PROP_CHAR_THEME_NAME_H_ANSI, u"CharThemeNameHAnsi"_ustr},
        { PROP_CHAR_THEME_NAME_EAST_ASIA, u"CharThemeNameEastAsia"_ustr},
        { PROP_CHAR_THEME_FONT_NAME_ASCII, u"CharThemeFontNameAscii"_ustr},
        { PROP_CHAR_THEME_FONT_NAME_CS, u"CharThemeFontNameCs"_ustr},
        { PROP_CHAR_THEME_FONT_NAME_EAST_ASIA, u"CharThemeFontNameEastAsia"_ustr},
        { PROP_CHAR_THEME_COLOR, u"CharThemeColor"_ustr},
        { PROP_CHAR_THEME_ORIGINAL_COLOR, u"CharThemeOriginalColor"_ustr},
        { PROP_CHAR_THEME_COLOR_SHADE, u"CharThemeColorShade"_ustr},
        { PROP_CHAR_THEME_FILL, u"CharThemeFill"_ustr},
        { PROP_HORIZONTAL_MERGE, u"HorizontalMerge"_ustr},
        { PROP_HIDE_TAB_LEADER_AND_PAGE_NUMBERS, u"HideTabLeaderAndPageNumber"_ustr},
        { PROP_TAB_IN_TOC, u"TabInTOC"_ustr},
        { PROP_TOC_BOOKMARK, u"TOCBookmark"_ustr},
        { PROP_TOC_NEW_LINE, u"TOCNewLine"_ustr},
        { PROP_TOC_PARAGRAPH_OUTLINE_LEVEL, u"TOCParagraphOutlineLevel"_ustr},
        { PROP_CHAR_THEME_COLOR_TINT, u"CharThemeColorTint"_ustr},
        { PROP_CHAR_GLOW_TEXT_EFFECT, u"CharGlowTextEffect"_ustr},
        { PROP_CHAR_SHADOW_TEXT_EFFECT, u"CharShadowTextEffect"_ustr},
        { PROP_CHAR_REFLECTION_TEXT_EFFECT, u"CharReflectionTextEffect"_ustr},
        { PROP_CHAR_TEXTOUTLINE_TEXT_EFFECT, u"CharTextOutlineTextEffect"_ustr},
        { PROP_CHAR_TEXTFILL_TEXT_EFFECT, u"CharTextFillTextEffect"_ustr},
        { PROP_CHAR_SCENE3D_TEXT_EFFECT, u"CharScene3DTextEffect"_ustr},
        { PROP_CHAR_PROPS3D_TEXT_EFFECT, u"CharProps3DTextEffect"_ustr},
        { PROP_CHAR_LIGATURES_TEXT_EFFECT, u"CharLigaturesTextEffect"_ustr},
        { PROP_CHAR_NUMFORM_TEXT_EFFECT, u"CharNumFormTextEffect"_ustr},
        { PROP_CHAR_NUMSPACING_TEXT_EFFECT, u"CharNumSpacingTextEffect"_ustr},
        { PROP_CHAR_STYLISTICSETS_TEXT_EFFECT, u"CharStylisticSetsTextEffect"_ustr},
        { PROP_CHAR_CNTXTALTS_TEXT_EFFECT, u"CharCntxtAltsTextEffect"_ustr},
        { PROP_CHAR_SCRIPT_HINT, u"CharScriptHint"_ustr},
        { PROP_SDTPR, u"SdtPr"_ustr},
        { PROP_CELL_INTEROP_GRAB_BAG, u"CellInteropGrabBag"_ustr},
        { PROP_TABLE_INTEROP_GRAB_BAG, u"TableInteropGrabBag"_ustr},
        { PROP_APPLY_PARAGRAPH_MARK_FORMAT_TO_NUMBERING, u"ApplyParagraphMarkFormatToNumbering"_ustr},
        { PROP_SDT_END_BEFORE, u"SdtEndBefore"_ustr},
        { PROP_PARA_SDT_END_BEFORE, u"ParaSdtEndBefore"_ustr},
        { META_PROP_TABLE_LOOK, u"TableStyleLook"_ustr},
        { PROP_PARA_CNF_STYLE, u"ParaCnfStyle"_ustr},
        { PROP_CELL_CNF_STYLE, u"CellCnfStyle"_ustr},
        { PROP_ROW_CNF_STYLE, u"RowCnfStyle"_ustr},
        { PROP_CELL_HIDE_MARK, u"CellHideMark"_ustr},
        { PROP_FOLLOW_TEXT_FLOW, u"IsFollowingTextFlow"_ustr},
        { PROP_FILL_STYLE, u"FillStyle"_ustr},
        { PROP_FILL_COLOR, u"FillColor"_ustr},
        { PROP_FILL_COMPLEX_COLOR, u"FillComplexColor"_ustr},
        { PROP_SNAP_TO_GRID, u"SnapToGrid"_ustr},
        { PROP_GRID_SNAP_TO_CHARS, u"GridSnapToChars"_ustr},
        { PROP_RUBY_STYLE, u"RubyCharStyleName"_ustr},
        { PROP_RUBY_TEXT, u"RubyText"_ustr},
        { PROP_RUBY_ADJUST, u"RubyAdjust"_ustr},
        { PROP_RUBY_POSITION, u"RubyPosition"_ustr},
        { PROP_DATABASE_NAME, u"DataBaseName"_ustr},
        { PROP_COMMAND_TYPE, u"DataCommandType"_ustr},
        { PROP_DATATABLE_NAME, u"DataTableName"_ustr},
        { PROP_DATACOLUMN_NAME, u"DataColumnName"_ustr},
        { PROP_CHAR_TRANSPARENCE, u"CharTransparence"_ustr},
        { PROP_CELL_FORMULA, u"CellFormula"_ustr},
        { PROP_CELL_FORMULA_CONVERTED, u"CellFormulaConverted"_ustr},
        { PROP_GUTTER_MARGIN, u"GutterMargin"_ustr},
        { PROP_RTL_GUTTER, u"RtlGutter"_ustr},
        { PROP_CURSOR_NOT_IGNORE_TABLES_IN_HF, u"CursorNotIgnoreTables"_ustr},
        { PROP_PARA_CONNECT_BORDERS, u"ParaIsConnectBorder"_ustr},
        { PROP_DECORATIVE, u"Decorative"_ustr},
        { PROP_PAPER_TRAY, u"PrinterPaperTray"_ustr},
        { PROP_CHAR_FONT_FAMILY, u"CharFontFamily"_ustr},
        { PROP_INLINE_HEADING, u"ParaInlineHeading"_ustr},
    };
    auto iterator = constPropertyMap.find(eId);
    if (iterator != constPropertyMap.end())
        return iterator->second;

    return svl::SharedString::EMPTY_STRING;
}

bool isCharacterProperty( const PropertyIds eId )
{
    return eId > PROP_CHARACTER_STYLES && eId < PROP_CHARACTER_END;
}

bool isParagraphProperty( const PropertyIds eId )
{
    return (eId >= PROP_PARA_ADJUST && eId <= PROP_PARA_WIDOWS)
        || eId == PROP_FILL_COLOR
        || eId == PROP_FILL_COMPLEX_COLOR;
}

} //namespace writerfilter

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
