/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.google.java.contract.Ensures;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.MongoVariantContext;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.PolymorphicStatus;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.TruthStatus;

public class ConsensusSummarizer {
    private static final String CONSENSUS = "Consensus";
    int nSites = 0;
    int totalPolyTPSites = 0;
    final Map<String, CallSetSummary> callSetSummaries = new HashMap<String, CallSetSummary>();

    @Ensures(value={"result != null"})
    private CallSetSummary getSummary(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (!this.callSetSummaries.containsKey(name)) {
            this.callSetSummaries.put(name, new CallSetSummary(name));
        }
        return this.callSetSummaries.get(name);
    }

    public void add(MongoVariantContext consensus) {
        if (consensus == null) {
            throw new IllegalArgumentException("Consensus cannot be null");
        }
        ++this.nSites;
        if (consensus.getType() == TruthStatus.TRUE_POSITIVE && consensus.isPolymorphic()) {
            ++this.totalPolyTPSites;
        }
        for (String callset : consensus.getSupportingCallSets()) {
            CallSetSummary summary = this.getSummary(callset);
            summary.update(consensus);
        }
        this.getSummary(CONSENSUS).update(consensus);
    }

    @Ensures(value={"result != null"})
    public GATKReport summaryGATKReport(boolean detailed) {
        GATKReport report = GATKReport.newSimpleReportWithDescription((String)"ConsensusSummary", (String)("Date " + new Date()), (String[])new String[]{"CallSet", "Variable", "Value"});
        for (CallSetSummary summary : this.callSetSummaries.values()) {
            String name = summary.getCallSetName();
            report.addRow(new Object[]{name, "total.sites", summary.getNSites()});
            report.addRow(new Object[]{name, "percent.of.all.tp.poly.sites", summary.getPercentOfAllSites(this.totalPolyTPSites)});
            report.addRow(new Object[]{name, "n.SNPs", summary.getnSNPs()});
            report.addRow(new Object[]{name, "n.Indels", summary.getnIndels()});
            report.addRow(new Object[]{name, "poly.nonsingleton.count", summary.getnNonSingletonTPPoly()});
            report.addRow(new Object[]{name, "poly.nonsingleton.percent", summary.percent(summary.getnNonSingletonTPPoly())});
            report.addRow(new Object[]{name, "poly.singletons.count", summary.getnSingletonTPPoly()});
            report.addRow(new Object[]{name, "poly.singletons.percent", summary.percent(summary.getnSingletonTPPoly())});
            report.addRow(new Object[]{name, "singletons.count", summary.getnSingletons()});
            report.addRow(new Object[]{name, "singletons.percent", summary.percent(summary.getnSingletons())});
            if (!detailed) continue;
            for (PolymorphicStatus polymorphicStatus : PolymorphicStatus.values()) {
                summary.addRow(report, polymorphicStatus);
            }
            for (Enum enum_ : TruthStatus.values()) {
                summary.addRow(report, (TruthStatus)enum_);
            }
        }
        return report;
    }

    @Ensures(value={"result >= 0"})
    public int getTotalPolyTPSites() {
        return this.totalPolyTPSites;
    }

    @Ensures(value={"result >= 0"})
    public int getnSites() {
        return this.nSites;
    }

    static final class CallSetSummary {
        final String callSetName;
        final EnumMap<TruthStatus, Integer> countsByTruth = new EnumMap(TruthStatus.class);
        final EnumMap<PolymorphicStatus, Integer> countsByPoly = new EnumMap(PolymorphicStatus.class);
        int nTPPoly = 0;
        int nNonSingletonTPPoly = 0;
        int nSingletonTPPoly = 0;
        int nSingletons = 0;
        int nSNPs = 0;
        int nIndels = 0;

        CallSetSummary(String callSetName) {
            if (callSetName == null) {
                throw new IllegalArgumentException("callSetName cannot be null");
            }
            this.callSetName = callSetName;
            for (PolymorphicStatus polymorphicStatus : PolymorphicStatus.values()) {
                this.countsByPoly.put(polymorphicStatus, 0);
            }
            for (Enum enum_ : TruthStatus.values()) {
                this.countsByTruth.put((TruthStatus)enum_, 0);
            }
        }

        final void update(MongoVariantContext mvc) {
            if (mvc == null) {
                throw new IllegalArgumentException("mvc cannot be null");
            }
            if (!mvc.getSupportingCallSets().contains(this.callSetName) && !this.callSetName.equals(ConsensusSummarizer.CONSENSUS)) {
                throw new IllegalArgumentException("Trying to include MVC from the wrong callset " + mvc + " into summary for " + this.callSetName);
            }
            this.countsByTruth.put(mvc.getType(), this.countsByTruth.get((Object)mvc.getType()) + 1);
            this.countsByPoly.put(mvc.getPolymorphicStatus(), this.countsByPoly.get((Object)mvc.getPolymorphicStatus()) + 1);
            if (mvc.isPolymorphic() && mvc.getType() == TruthStatus.TRUE_POSITIVE) {
                ++this.nTPPoly;
                if (mvc.isSingleCallset()) {
                    ++this.nSingletonTPPoly;
                } else {
                    ++this.nNonSingletonTPPoly;
                }
            }
            if (mvc.isSingleCallset()) {
                ++this.nSingletons;
            }
            if (mvc.getVariantContext().isSNP()) {
                ++this.nSNPs;
            } else {
                ++this.nIndels;
            }
        }

        @Ensures(value={"result != null"})
        public String getCallSetName() {
            return this.callSetName;
        }

        public void addRow(GATKReport report, PolymorphicStatus status) {
            report.addRow(new Object[]{this.callSetName, "polymorphic." + (Object)((Object)status) + ".count", this.getN(status)});
            report.addRow(new Object[]{this.callSetName, "polymorphic." + (Object)((Object)status) + ".percent", this.getPercent(status)});
        }

        public void addRow(GATKReport report, TruthStatus status) {
            report.addRow(new Object[]{this.callSetName, "polymorphic." + (Object)((Object)status) + ".count", this.getN(status)});
            report.addRow(new Object[]{this.callSetName, "polymorphic." + (Object)((Object)status) + ".percent", this.getPercent(status)});
        }

        @Ensures(value={"result >= 0"})
        public int getN(PolymorphicStatus status) {
            return this.countsByPoly.get((Object)status);
        }

        @Ensures(value={"result >= 0"})
        public int getN(TruthStatus status) {
            return this.countsByTruth.get((Object)status);
        }

        @Ensures(value={"result != null"})
        public String getPercent(PolymorphicStatus status) {
            return this.percent(this.countsByPoly.get((Object)status));
        }

        @Ensures(value={"result != null"})
        public String getPercent(TruthStatus status) {
            return this.percent(this.countsByTruth.get((Object)status));
        }

        @Ensures(value={"result != null"})
        public String getPercentOfAllSites(int nTotalTPPoly) {
            return this.percent(this.nTPPoly, nTotalTPPoly);
        }

        @Ensures(value={"result >= 0"})
        public int getNSites() {
            int c = 0;
            for (PolymorphicStatus status : PolymorphicStatus.values()) {
                c += this.countsByPoly.get((Object)status).intValue();
            }
            return c;
        }

        @Ensures(value={"result != null"})
        public String percent(int n) {
            return this.percent(n, this.getNSites());
        }

        @Ensures(value={"result != null"})
        public String percent(int n, int d) {
            return d == 0 ? "NA" : String.format("%.2f", (double)n / ((double)d * 0.01));
        }

        @Ensures(value={"result >= 0"})
        public int getnSingletonTPPoly() {
            return this.nSingletonTPPoly;
        }

        @Ensures(value={"result >= 0"})
        public int getnSingletons() {
            return this.nSingletons;
        }

        @Ensures(value={"result >= 0"})
        public int getnSNPs() {
            return this.nSNPs;
        }

        @Ensures(value={"result >= 0"})
        public int getnIndels() {
            return this.nIndels;
        }

        @Ensures(value={"result >= 0"})
        public int getnTPPoly() {
            return this.nTPPoly;
        }

        @Ensures(value={"result >= 0"})
        public int getnNonSingletonTPPoly() {
            return this.nNonSingletonTPPoly;
        }
    }
}

