/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import javax.swing.JLabel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelMatcher
extends AbstractComponentMatcher {
    private final String label;
    private final Class<? extends Component> type;

    public LabelMatcher(String label) {
        this(label, false);
    }

    public LabelMatcher(String label, boolean requireShowing) {
        this(label, Component.class, requireShowing);
    }

    public LabelMatcher(String label, Class<? extends Component> type) {
        this(label, type, false);
    }

    public LabelMatcher(String label, Class<? extends Component> type, boolean requireShowing) {
        super(requireShowing);
        if (label == null) {
            throw new NullPointerException("The text of the label associated to the component to find should not be null");
        }
        if (Strings.isEmpty((String)label)) {
            throw new IllegalArgumentException("The text of the label associated to the component to find should not be empty");
        }
        if (type == null) {
            throw new NullPointerException("The type of component to find should not be null");
        }
        this.label = label;
        this.type = type;
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(Component c) {
        if (!(c instanceof JLabel)) {
            return false;
        }
        JLabel labelForComponent = (JLabel)c;
        if (!Objects.areEqual((Object)labelForComponent.getText(), (Object)this.label)) {
            return false;
        }
        Component labeled = labelForComponent.getLabelFor();
        return this.type.isInstance(labeled) && this.requireShowingMatches(labeled);
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "label=", Strings.quote((String)this.label), ", ", "type=", this.type.getName(), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]"});
    }
}

