/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.format.ComponentFormatter;
import org.fest.swing.format.IntrospectionComponentFormatter;
import org.fest.swing.format.JComboBoxFormatter;
import org.fest.swing.format.JFileChooserFormatter;
import org.fest.swing.format.JListFormatter;
import org.fest.swing.format.JOptionPaneFormatter;
import org.fest.swing.format.JTabbedPaneFormatter;
import org.fest.swing.format.JTableFormatter;
import org.fest.swing.format.JTreeFormatter;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatting {
    private static final String MAXIMUM = "maximum";
    private static final String MINIMUM = "minimum";
    private static final String NULL_COMPONENT_MESSAGE = "Null Component";
    private static final String ENABLED = "enabled";
    private static final String NAME = "name";
    private static final String SHOWING = "showing";
    private static final String TEXT = "text";
    private static final String TITLE = "title";
    private static final String VALUE = "value";
    private static final String VISIBLE = "visible";
    private static final ConcurrentMap<Class<?>, ComponentFormatter> FORMATTERS = new ConcurrentHashMap();
    private static Logger logger = Logger.getLogger(Formatting.class.getName());

    private static ComponentFormatter instrospect(Class<? extends Component> targetType, String ... propertyNames) {
        return new IntrospectionComponentFormatter(targetType, propertyNames);
    }

    private static ComponentFormatter empty(Class<? extends Component> targetType) {
        return new IntrospectionComponentFormatter(targetType, new String[0]);
    }

    private static ComponentFormatter nameOnly(Class<? extends Component> targetType) {
        return new IntrospectionComponentFormatter(targetType, NAME);
    }

    public static void register(ComponentFormatter formatter) {
        Class<? extends Component> key = formatter.targetType();
        ComponentFormatter previous = FORMATTERS.put(key, formatter);
        if (previous != null) {
            logger.info(Strings.concat((Object[])new Object[]{"Replaced formatter ", previous, " with ", formatter, " for the type ", key.getName()}));
        }
    }

    @VisibleForTesting
    static ComponentFormatter formatter(Class<?> type) {
        return (ComponentFormatter)FORMATTERS.get(type);
    }

    @RunsInEDT
    public static String inEdtFormat(final Component c) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                return Formatting.format(c);
            }
        });
    }

    @RunsInCurrentThread
    public static String format(Component c) {
        if (c == null) {
            return NULL_COMPONENT_MESSAGE;
        }
        ComponentFormatter formatter = Formatting.formatterFor(c.getClass());
        if (formatter != null) {
            return formatter.format(c);
        }
        String name = c.getName();
        if (Strings.isEmpty((String)name)) {
            return c.toString();
        }
        return Strings.concat((Object[])new Object[]{c.getClass().getName(), "[name=", Strings.quote((String)name), "]"});
    }

    private static ComponentFormatter formatterFor(Class<?> type) {
        ComponentFormatter formatter = (ComponentFormatter)FORMATTERS.get(type);
        if (formatter != null) {
            return formatter;
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null) {
            return Formatting.formatterFor(superType);
        }
        return null;
    }

    private Formatting() {
    }

    static {
        Formatting.register(Formatting.instrospect(AbstractButton.class, NAME, TEXT, "selected", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(Dialog.class, NAME, TITLE, ENABLED, "modal", VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(Frame.class, NAME, TITLE, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JComboBoxFormatter());
        Formatting.register(Formatting.instrospect(JButton.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JFileChooserFormatter());
        Formatting.register(Formatting.instrospect(JLabel.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.empty(JLayeredPane.class));
        Formatting.register(new JListFormatter());
        Formatting.register(Formatting.empty(JMenuBar.class));
        Formatting.register(new JOptionPaneFormatter());
        Formatting.register(Formatting.nameOnly(JPanel.class));
        Formatting.register(Formatting.instrospect(JPopupMenu.class, NAME, "label", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JProgressBar.class, NAME, VALUE, MINIMUM, MAXIMUM, "string", "stringPainted", ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.empty(JRootPane.class));
        Formatting.register(Formatting.instrospect(JScrollBar.class, NAME, VALUE, "blockIncrement", MINIMUM, MAXIMUM, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JScrollPane.class, NAME, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JSlider.class, NAME, VALUE, MINIMUM, MAXIMUM, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JSpinner.class, NAME, VALUE, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JTabbedPaneFormatter());
        Formatting.register(new JTableFormatter());
        Formatting.register(Formatting.nameOnly(JToolBar.class));
        Formatting.register(Formatting.instrospect(JPasswordField.class, NAME, ENABLED, VISIBLE, SHOWING));
        Formatting.register(Formatting.instrospect(JTextComponent.class, NAME, TEXT, ENABLED, VISIBLE, SHOWING));
        Formatting.register(new JTreeFormatter());
    }
}

