/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyLoader {
    private static final int SNAPPY_BLOCK_SIZE = 32768;
    private static final Log logger = Log.getInstance(SnappyLoader.class);
    private final boolean snappyAvailable;

    public SnappyLoader() {
        this(Defaults.DISABLE_SNAPPY_COMPRESSOR);
    }

    SnappyLoader(boolean disableSnappy) {
        if (disableSnappy) {
            logger.debug("Snappy is disabled via system property.");
            this.snappyAvailable = false;
        } else {
            boolean tmpSnappyAvailable = false;
            try (SnappyOutputStream test = new SnappyOutputStream((OutputStream)new ByteArrayOutputStream(1000));){
                test.write("Hello World!".getBytes());
                tmpSnappyAvailable = true;
                logger.debug("Snappy successfully loaded.");
            }
            catch (IOException | ExceptionInInitializerError | IllegalStateException | SnappyError e) {
                logger.warn(e, "Snappy native library failed to load.");
            }
            this.snappyAvailable = tmpSnappyAvailable;
        }
    }

    public boolean isSnappyAvailable() {
        return this.snappyAvailable;
    }

    public InputStream wrapInputStream(InputStream inputStream) {
        return (InputStream)this.wrapWithSnappyOrThrow(inputStream, SnappyInputStream::new);
    }

    public OutputStream wrapOutputStream(OutputStream outputStream) {
        return (OutputStream)this.wrapWithSnappyOrThrow(outputStream, stream -> new SnappyOutputStream(stream, 32768));
    }

    private <T, R> R wrapWithSnappyOrThrow(T stream, IOFunction<T, R> wrapper) {
        if (this.isSnappyAvailable()) {
            try {
                return wrapper.apply(stream);
            }
            catch (Exception e) {
                throw new SAMException("Error wrapping stream with snappy", e);
            }
        }
        String errorMessage = Defaults.DISABLE_SNAPPY_COMPRESSOR ? "Cannot wrap stream with snappy compressor because snappy was disabled via the snappy.disable system property." : "Cannot wrap stream with snappy compressor because we could not load the snappy library.";
        throw new SAMException(errorMessage);
    }

    private static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

