/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.Runner;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class RunAnalysisStageAction
extends Action {
    private Session session;
    private Collection<AnalysisStage> stages;
    private DataCollection dataCollection;

    public RunAnalysisStageAction(Session session, AnalysisStage[] stages, DataCollection dataCollection) {
        super(ViperMessages.RunAnalysisStage_Label, null);
        this.session = session;
        this.stages = new ArrayList<AnalysisStage>(Arrays.asList(stages));
        this.dataCollection = dataCollection;
        this.setToolTipText(ViperMessages.RunAnalysisStage_Tooltip);
        this.setId("com.nvidia.viper.runanalysisstage");
    }

    public void analysisCompleted(IStatus status) {
    }

    private static void handleException(AnalysisStage stage, ViperException e) {
        ViperExceptionHandler.handle("Analysis Failed", String.valueOf(stage.getLabel()) + " analysis failed", e);
    }

    private boolean shouldAnalyzeLater(AnalysisStage stage) {
        boolean rc;
        try {
            rc = stage.analyze(this.session);
        }
        catch (ViperException e) {
            RunAnalysisStageAction.handleException(stage, e);
            return false;
        }
        if (this.dataCollection == DataCollection.FORCE) {
            return true;
        }
        return this.dataCollection == DataCollection.IFNEEDED && !rc;
    }

    private Collection<AnalysisStage> analyzeStages(Collection<AnalysisStage> stages) {
        HashSet<AnalysisStage> rc = new HashSet<AnalysisStage>();
        for (AnalysisStage stage : stages) {
            if (!this.shouldAnalyzeLater(stage)) continue;
            rc.add(stage);
        }
        return rc;
    }

    final FileSystem getFileSystem() throws ConnectionNotFoundException {
        Executable exe = this.session != null ? this.session.getExecutable() : null;
        String conName = exe != null ? exe.getConnectionName() : null;
        return FileSystem.getFilesystem(conName);
    }

    private Runner getRunner(Collection<AnalysisStage> stages) throws AbortRoutineException {
        try {
            FileSystem system = this.getFileSystem();
            IDevicesData data = system.getDeviceData(true);
            Analysis analysis = this.session.getAnalysis();
            return analysis.collectData(data, this.session, stages);
        }
        catch (ViperException e) {
            ViperExceptionHandler.handle("Analysis Data Collection Failed", "Data collection for " + stages.size() + " analysis stages failed", e);
            throw new AbortRoutineException();
        }
        catch (DeviceListNotReadyException deviceListNotReadyException) {
            throw new AbortRoutineException();
        }
    }

    private void regenerateTimeline() {
        if (this.session.needToGenerateTimeline()) {
            new RunAnalysisAction(this.session, true, RunAnalysisAction.ShowMode.GUIDED).run();
        }
    }

    private boolean getTimelineStage() {
        if (this.stages != null) {
            for (AnalysisStage stage : this.stages) {
                if (!AnalysisStage.TIMELINE.equals((Object)stage)) continue;
                AnalysisStage[] tlStage = new AnalysisStage[]{AnalysisStage.TIMELINE};
                this.stages = new ArrayList<AnalysisStage>(Arrays.asList(tlStage));
                return true;
            }
        }
        return false;
    }

    public void run() {
        Runner runner;
        if ((this.session.getNumTimelinePdms() > 1 || this.session.isProfileAllProcesses()) && !this.getTimelineStage()) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.LoadExpertEvents_Fail_Title, "Analysis is not supported for multi-process application");
                }
            });
            return;
        }
        final Collection<AnalysisStage> collectStages = this.analyzeStages(this.stages);
        if (CoreUtil.isNullOrEmpty(collectStages)) {
            this.analysisCompleted(Status.OK_STATUS);
            return;
        }
        try {
            runner = this.getRunner(collectStages);
        }
        catch (AbortRoutineException abortRoutineException) {
            return;
        }
        if (runner == null) {
            this.regenerateTimeline();
            this.analysisCompleted(Status.OK_STATUS);
            return;
        }
        if (!Runner.checkRunnable(this.session, true)) {
            this.analysisCompleted(Status.CANCEL_STATUS);
            return;
        }
        final boolean ret = runner.runWithJob();
        new Thread("Analysis Completion Waiter"){

            @Override
            public void run() {
                final IStatus status = runner.waitForCompletion();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (status != Status.OK_STATUS && status != Status.CANCEL_STATUS) {
                            Exception e = (Exception)CoreUtil.safeCast((Object)status.getException(), Exception.class);
                            ViperExceptionHandler.handle(ViperMessages.Launch_Fail_Title, status.getMessage(), e);
                        } else if (ret) {
                            RunAnalysisStageAction.this.analyzeStages(collectStages);
                        } else {
                            RunAnalysisStageAction.this.regenerateTimeline();
                        }
                        RunAnalysisStageAction.this.analysisCompleted(status);
                    }
                });
            }
        }.start();
    }

    private class AbortRoutineException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AbortRoutineException() {
        }
    }

    public static enum DataCollection {
        FORCE,
        IFNEEDED,
        NONE;

    }
}

