/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.analysis.AnalysisResultKernelUnitBusy;
import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;

public final class KernelBoundsAnalysisChart
implements IViperChart {
    private final double memoryUtilization;
    private final AnalysisResultKernelBounds.MemBound memBound;
    private final double arith;
    private final double controlFlow;
    private final double loadStore;
    private final double fuUtilization;
    private final AnalysisResultKernelUnitBusy.FunctionUnit fuBound;

    public KernelBoundsAnalysisChart(double memoryUtilization, AnalysisResultKernelBounds.MemBound memBound, double arith, double controlFlow, double loadStore) {
        this.memoryUtilization = memoryUtilization * 100.0;
        this.memBound = memBound;
        this.arith = arith * 100.0;
        this.controlFlow = controlFlow * 100.0;
        this.loadStore = loadStore * 100.0;
        this.fuUtilization = 0.0;
        this.fuBound = null;
    }

    public KernelBoundsAnalysisChart(double memoryUtilization, AnalysisResultKernelBounds.MemBound memBound, double fuUtilization, AnalysisResultKernelUnitBusy.FunctionUnit fuBound) {
        this.memoryUtilization = memoryUtilization * 100.0;
        this.memBound = memBound;
        this.fuUtilization = fuUtilization * 100.0;
        this.fuBound = fuBound;
        this.arith = 0.0;
        this.controlFlow = 0.0;
        this.loadStore = 0.0;
    }

    public ViperChartSeries[] getSeries() {
        if (this.fuBound == null) {
            return new ViperChartSeries[]{new ViperChartSeries(new Double[]{0.0, this.memoryUtilization}, ViperChartSeries.Type.STACKED_BAR, "Memory " + this.memBound.getLegendName()), new ViperChartSeries(new Double[]{this.arith, 0.0}, ViperChartSeries.Type.STACKED_BAR, "Arithmetic operations"), new ViperChartSeries(new Double[]{this.controlFlow, 0.0}, ViperChartSeries.Type.STACKED_BAR, "Control-flow operations"), new ViperChartSeries(new Double[]{this.loadStore, 0.0}, ViperChartSeries.Type.STACKED_BAR, "Memory operations")};
        }
        return new ViperChartSeries[]{new ViperChartSeries(new Double[]{0.0, this.memoryUtilization}, ViperChartSeries.Type.STACKED_BAR, "Memory " + this.memBound.getLegendName()), new ViperChartSeries(new Double[]{this.fuUtilization, 0.0}, ViperChartSeries.Type.STACKED_BAR, "Function Unit " + this.fuBound.getLegendName())};
    }

    public String getTitle() {
        return null;
    }

    public boolean isHighlighted() {
        return false;
    }

    public boolean showLegend() {
        return this.fuBound == null;
    }

    public int getHeight() {
        return 300;
    }

    public int getWidth() {
        return 1000;
    }

    public AxesConfiguration getAxesConfiguration() {
        return new AxesConfiguration(null, "Utilization", true, Integer.valueOf(100), Integer.valueOf(10), null, Integer.valueOf(10), true, new String[]{"10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"}, false);
    }

    public String[] getLabels() {
        if (this.fuBound == null) {
            return new String[]{"Compute", "Memory " + this.memBound.getLegendName()};
        }
        return new String[]{"Function Unit " + this.fuBound.getLegendName(), "Memory " + this.memBound.getLegendName()};
    }

    public boolean colorBySeries() {
        return true;
    }
}

