/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.service.control;

import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;

public class StepIntoSelectionActiveOperation {
    private final IFunctionDeclaration fTargetFunction;
    private final IMIExecutionDMContext fThreadContext;
    private String fBaseFileLocation = null;
    private int fBaseLine = 0;
    private int fOriginalStackDepth = 0;
    private String fFunctionSignature = null;
    private MIFrame fRunToLineFrame = null;

    public StepIntoSelectionActiveOperation(IMIExecutionDMContext threadContext, int line, IFunctionDeclaration targetFunction, int stackDepth, MIFrame runToLineFrame) {
        this.fThreadContext = threadContext;
        this.fBaseLine = line;
        this.fTargetFunction = targetFunction;
        this.fOriginalStackDepth = stackDepth;
        this.fRunToLineFrame = runToLineFrame;
        this.init();
    }

    private void init() {
        if (this.fRunToLineFrame == null) {
            return;
        }
        this.fBaseFileLocation = String.valueOf(this.fRunToLineFrame.getFile()) + ":" + this.fBaseLine;
    }

    public IFunctionDeclaration getTargetFunctionDeclaration() {
        return this.fTargetFunction;
    }

    public IMIExecutionDMContext getThreadContext() {
        return this.fThreadContext;
    }

    public String getFileLocation() {
        return this.fBaseFileLocation;
    }

    public int getLine() {
        return this.fBaseLine;
    }

    public int getOriginalStackDepth() {
        return this.fOriginalStackDepth;
    }

    public void setOriginalStackDepth(Integer originalStackDepth) {
        this.fOriginalStackDepth = originalStackDepth;
    }

    public MIFrame getRunToLineFrame() {
        return this.fRunToLineFrame;
    }

    public void setRunToLineFrame(MIFrame runToLineFrame) {
        if (runToLineFrame != null) {
            this.fRunToLineFrame = runToLineFrame;
            this.init();
        }
    }

    public String getTargetFunctionSignature() {
        if (this.fFunctionSignature != null) {
            return this.fFunctionSignature;
        }
        if (this.fTargetFunction != null) {
            StringBuilder sb = null;
            sb = new StringBuilder();
            if (this.fTargetFunction.getParent() != null) {
                sb.append(String.valueOf(this.fTargetFunction.getParent().getElementName()) + "::");
            }
            sb.append(this.fTargetFunction.getElementName());
            this.fFunctionSignature = sb.toString();
        }
        return this.fFunctionSignature;
    }
}

