/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.internal.ui.refactoring.CreateFileChange;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class DeleteFileChange
extends Change {
    private final IPath path;
    private String source;

    public DeleteFileChange(IPath path) {
        this.path = path;
    }

    public Object getModifiedElement() {
        return this.path;
    }

    public String getName() {
        return String.valueOf(Messages.DeleteFileChange_0) + this.path.toOSString();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
        if (!file.exists()) {
            status.addFatalError(String.valueOf(Messages.DeleteFileChange_1) + this.path.toString());
        }
        return status;
    }

    private String getSource(IFile file) throws CoreException {
        String encoding = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {}
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        InputStream in = null;
        try {
            in = file.getContents();
            br = encoding != null ? new BufferedReader(new InputStreamReader(in, encoding)) : new BufferedReader(new InputStreamReader(in));
            int read = 0;
            while ((read = br.read()) != -1) {
                sb.append((char)read);
            }
            br.close();
        }
        catch (IOException iOException) {}
        return sb.toString();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
        this.source = this.getSource(file);
        CreateFileChange undo = new CreateFileChange(file.getFullPath(), this.source, file.getCharset());
        file.delete(true, true, pm);
        return undo;
    }
}

