#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifdef __clang__
#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif
#else
#if defined(__BPF__)
#define ATTR_PRESERVE_ACCESS_INDEX __attribute__((preserve_access_index))
#endif
#endif

#ifndef ATTR_PRESERVE_ACCESS_INDEX
#define ATTR_PRESERVE_ACCESS_INDEX
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	ACPI_BATTERY_ALARM_PRESENT = 0,
	ACPI_BATTERY_XINFO_PRESENT = 1,
	ACPI_BATTERY_QUIRK_PERCENTAGE_CAPACITY = 2,
	ACPI_BATTERY_QUIRK_THINKPAD_MAH = 3,
	ACPI_BATTERY_QUIRK_DEGRADED_FULL_CHARGE = 4,
};

enum {
	ACPI_GENL_ATTR_UNSPEC = 0,
	ACPI_GENL_ATTR_EVENT = 1,
	__ACPI_GENL_ATTR_MAX = 2,
};

enum {
	ACPI_GENL_CMD_UNSPEC = 0,
	ACPI_GENL_CMD_EVENT = 1,
	__ACPI_GENL_CMD_MAX = 2,
};

enum {
	ACPI_REFCLASS_LOCAL = 0,
	ACPI_REFCLASS_ARG = 1,
	ACPI_REFCLASS_REFOF = 2,
	ACPI_REFCLASS_INDEX = 3,
	ACPI_REFCLASS_TABLE = 4,
	ACPI_REFCLASS_NAME = 5,
	ACPI_REFCLASS_DEBUG = 6,
	ACPI_REFCLASS_MAX = 6,
};

enum {
	ACPI_RSC_INITGET = 0,
	ACPI_RSC_INITSET = 1,
	ACPI_RSC_FLAGINIT = 2,
	ACPI_RSC_1BITFLAG = 3,
	ACPI_RSC_2BITFLAG = 4,
	ACPI_RSC_3BITFLAG = 5,
	ACPI_RSC_6BITFLAG = 6,
	ACPI_RSC_ADDRESS = 7,
	ACPI_RSC_BITMASK = 8,
	ACPI_RSC_BITMASK16 = 9,
	ACPI_RSC_COUNT = 10,
	ACPI_RSC_COUNT16 = 11,
	ACPI_RSC_COUNT_GPIO_PIN = 12,
	ACPI_RSC_COUNT_GPIO_RES = 13,
	ACPI_RSC_COUNT_GPIO_VEN = 14,
	ACPI_RSC_COUNT_SERIAL_RES = 15,
	ACPI_RSC_COUNT_SERIAL_VEN = 16,
	ACPI_RSC_DATA8 = 17,
	ACPI_RSC_EXIT_EQ = 18,
	ACPI_RSC_EXIT_LE = 19,
	ACPI_RSC_EXIT_NE = 20,
	ACPI_RSC_LENGTH = 21,
	ACPI_RSC_MOVE_GPIO_PIN = 22,
	ACPI_RSC_MOVE_GPIO_RES = 23,
	ACPI_RSC_MOVE_SERIAL_RES = 24,
	ACPI_RSC_MOVE_SERIAL_VEN = 25,
	ACPI_RSC_MOVE8 = 26,
	ACPI_RSC_MOVE16 = 27,
	ACPI_RSC_MOVE32 = 28,
	ACPI_RSC_MOVE64 = 29,
	ACPI_RSC_SET8 = 30,
	ACPI_RSC_SOURCE = 31,
	ACPI_RSC_SOURCEX = 32,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	AML_FIELD_ACCESS_ANY = 0,
	AML_FIELD_ACCESS_BYTE = 1,
	AML_FIELD_ACCESS_WORD = 2,
	AML_FIELD_ACCESS_DWORD = 3,
	AML_FIELD_ACCESS_QWORD = 4,
	AML_FIELD_ACCESS_BUFFER = 5,
};

enum {
	AML_FIELD_ATTRIB_QUICK = 2,
	AML_FIELD_ATTRIB_SEND_RECEIVE = 4,
	AML_FIELD_ATTRIB_BYTE = 6,
	AML_FIELD_ATTRIB_WORD = 8,
	AML_FIELD_ATTRIB_BLOCK = 10,
	AML_FIELD_ATTRIB_BYTES = 11,
	AML_FIELD_ATTRIB_PROCESS_CALL = 12,
	AML_FIELD_ATTRIB_BLOCK_PROCESS_CALL = 13,
	AML_FIELD_ATTRIB_RAW_BYTES = 14,
	AML_FIELD_ATTRIB_RAW_PROCESS_BYTES = 15,
};

enum {
	AML_FIELD_UPDATE_PRESERVE = 0,
	AML_FIELD_UPDATE_WRITE_AS_ONES = 32,
	AML_FIELD_UPDATE_WRITE_AS_ZEROS = 64,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_MAX_VALUES = 13,
};

enum {
	AXP152_IRQ_LDO0IN_CONNECT = 1,
	AXP152_IRQ_LDO0IN_REMOVAL = 2,
	AXP152_IRQ_ALDO0IN_CONNECT = 3,
	AXP152_IRQ_ALDO0IN_REMOVAL = 4,
	AXP152_IRQ_DCDC1_V_LOW = 5,
	AXP152_IRQ_DCDC2_V_LOW = 6,
	AXP152_IRQ_DCDC3_V_LOW = 7,
	AXP152_IRQ_DCDC4_V_LOW = 8,
	AXP152_IRQ_PEK_SHORT = 9,
	AXP152_IRQ_PEK_LONG = 10,
	AXP152_IRQ_TIMER = 11,
	AXP152_IRQ_PEK_FAL_EDGE = 12,
	AXP152_IRQ_PEK_RIS_EDGE = 13,
	AXP152_IRQ_GPIO3_INPUT = 14,
	AXP152_IRQ_GPIO2_INPUT = 15,
	AXP152_IRQ_GPIO1_INPUT = 16,
	AXP152_IRQ_GPIO0_INPUT = 17,
};

enum {
	AXP20X_IRQ_ACIN_OVER_V = 1,
	AXP20X_IRQ_ACIN_PLUGIN = 2,
	AXP20X_IRQ_ACIN_REMOVAL = 3,
	AXP20X_IRQ_VBUS_OVER_V = 4,
	AXP20X_IRQ_VBUS_PLUGIN = 5,
	AXP20X_IRQ_VBUS_REMOVAL = 6,
	AXP20X_IRQ_VBUS_V_LOW = 7,
	AXP20X_IRQ_BATT_PLUGIN = 8,
	AXP20X_IRQ_BATT_REMOVAL = 9,
	AXP20X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP20X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP20X_IRQ_CHARG = 12,
	AXP20X_IRQ_CHARG_DONE = 13,
	AXP20X_IRQ_BATT_TEMP_HIGH = 14,
	AXP20X_IRQ_BATT_TEMP_LOW = 15,
	AXP20X_IRQ_DIE_TEMP_HIGH = 16,
	AXP20X_IRQ_CHARG_I_LOW = 17,
	AXP20X_IRQ_DCDC1_V_LONG = 18,
	AXP20X_IRQ_DCDC2_V_LONG = 19,
	AXP20X_IRQ_DCDC3_V_LONG = 20,
	AXP20X_IRQ_PEK_SHORT = 22,
	AXP20X_IRQ_PEK_LONG = 23,
	AXP20X_IRQ_N_OE_PWR_ON = 24,
	AXP20X_IRQ_N_OE_PWR_OFF = 25,
	AXP20X_IRQ_VBUS_VALID = 26,
	AXP20X_IRQ_VBUS_NOT_VALID = 27,
	AXP20X_IRQ_VBUS_SESS_VALID = 28,
	AXP20X_IRQ_VBUS_SESS_END = 29,
	AXP20X_IRQ_LOW_PWR_LVL1 = 30,
	AXP20X_IRQ_LOW_PWR_LVL2 = 31,
	AXP20X_IRQ_TIMER = 32,
	AXP20X_IRQ_PEK_FAL_EDGE = 33,
	AXP20X_IRQ_PEK_RIS_EDGE = 34,
	AXP20X_IRQ_GPIO3_INPUT = 35,
	AXP20X_IRQ_GPIO2_INPUT = 36,
	AXP20X_IRQ_GPIO1_INPUT = 37,
	AXP20X_IRQ_GPIO0_INPUT = 38,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	BAD_STACK = -1,
	NOT_STACK = 0,
	GOOD_FRAME = 1,
	GOOD_STACK = 2,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_BOUNCED = 2,
	BIO_QUIET = 3,
	BIO_CHAIN = 4,
	BIO_REFFED = 5,
	BIO_BPS_THROTTLED = 6,
	BIO_TRACE_COMPLETION = 7,
	BIO_CGROUP_ACCT = 8,
	BIO_QOS_THROTTLED = 9,
	BIO_QOS_MERGED = 10,
	BIO_REMAPPED = 11,
	BIO_ZONE_WRITE_PLUGGING = 12,
	BIO_EMULATES_ZONE_APPEND = 13,
	BIO_FLAG_LAST = 14,
};

enum {
	BLK_MQ_F_SHOULD_MERGE = 1,
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_NO_SCHED = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_ALLOC_POLICY_START_BIT = 7,
	BLK_MQ_F_ALLOC_POLICY_BITS = 1,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLK_TAG_ALLOC_FIFO = 0,
	BLK_TAG_ALLOC_RR = 1,
	BLK_TAG_ALLOC_MAX = 2,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_BPRM_SECUREEXEC = 1,
};

enum {
	BPF_F_CURRENT_NETNS = -1,
};

enum {
	BPF_F_GET_BRANCH_RECORDS_SIZE = 1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_UPROBE_MULTI_RETURN = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BPF_XFRM_STATE_OPTS_SZ = 36,
};

enum {
	BRIDGE_QUERIER_UNSPEC = 0,
	BRIDGE_QUERIER_IP_ADDRESS = 1,
	BRIDGE_QUERIER_IP_PORT = 2,
	BRIDGE_QUERIER_IP_OTHER_TIMER = 3,
	BRIDGE_QUERIER_PAD = 4,
	BRIDGE_QUERIER_IPV6_ADDRESS = 5,
	BRIDGE_QUERIER_IPV6_PORT = 6,
	BRIDGE_QUERIER_IPV6_OTHER_TIMER = 7,
	__BRIDGE_QUERIER_MAX = 8,
};

enum {
	BRIDGE_VLANDB_DUMP_UNSPEC = 0,
	BRIDGE_VLANDB_DUMP_FLAGS = 1,
	__BRIDGE_VLANDB_DUMP_MAX = 2,
};

enum {
	BRIDGE_VLANDB_ENTRY_UNSPEC = 0,
	BRIDGE_VLANDB_ENTRY_INFO = 1,
	BRIDGE_VLANDB_ENTRY_RANGE = 2,
	BRIDGE_VLANDB_ENTRY_STATE = 3,
	BRIDGE_VLANDB_ENTRY_TUNNEL_INFO = 4,
	BRIDGE_VLANDB_ENTRY_STATS = 5,
	BRIDGE_VLANDB_ENTRY_MCAST_ROUTER = 6,
	BRIDGE_VLANDB_ENTRY_MCAST_N_GROUPS = 7,
	BRIDGE_VLANDB_ENTRY_MCAST_MAX_GROUPS = 8,
	BRIDGE_VLANDB_ENTRY_NEIGH_SUPPRESS = 9,
	__BRIDGE_VLANDB_ENTRY_MAX = 10,
};

enum {
	BRIDGE_VLANDB_GOPTS_UNSPEC = 0,
	BRIDGE_VLANDB_GOPTS_ID = 1,
	BRIDGE_VLANDB_GOPTS_RANGE = 2,
	BRIDGE_VLANDB_GOPTS_MCAST_SNOOPING = 3,
	BRIDGE_VLANDB_GOPTS_MCAST_IGMP_VERSION = 4,
	BRIDGE_VLANDB_GOPTS_MCAST_MLD_VERSION = 5,
	BRIDGE_VLANDB_GOPTS_MCAST_LAST_MEMBER_CNT = 6,
	BRIDGE_VLANDB_GOPTS_MCAST_STARTUP_QUERY_CNT = 7,
	BRIDGE_VLANDB_GOPTS_MCAST_LAST_MEMBER_INTVL = 8,
	BRIDGE_VLANDB_GOPTS_PAD = 9,
	BRIDGE_VLANDB_GOPTS_MCAST_MEMBERSHIP_INTVL = 10,
	BRIDGE_VLANDB_GOPTS_MCAST_QUERIER_INTVL = 11,
	BRIDGE_VLANDB_GOPTS_MCAST_QUERY_INTVL = 12,
	BRIDGE_VLANDB_GOPTS_MCAST_QUERY_RESPONSE_INTVL = 13,
	BRIDGE_VLANDB_GOPTS_MCAST_STARTUP_QUERY_INTVL = 14,
	BRIDGE_VLANDB_GOPTS_MCAST_QUERIER = 15,
	BRIDGE_VLANDB_GOPTS_MCAST_ROUTER_PORTS = 16,
	BRIDGE_VLANDB_GOPTS_MCAST_QUERIER_STATE = 17,
	BRIDGE_VLANDB_GOPTS_MSTI = 18,
	__BRIDGE_VLANDB_GOPTS_MAX = 19,
};

enum {
	BRIDGE_VLANDB_STATS_UNSPEC = 0,
	BRIDGE_VLANDB_STATS_RX_BYTES = 1,
	BRIDGE_VLANDB_STATS_RX_PACKETS = 2,
	BRIDGE_VLANDB_STATS_TX_BYTES = 3,
	BRIDGE_VLANDB_STATS_TX_PACKETS = 4,
	BRIDGE_VLANDB_STATS_PAD = 5,
	__BRIDGE_VLANDB_STATS_MAX = 6,
};

enum {
	BRIDGE_VLANDB_TINFO_UNSPEC = 0,
	BRIDGE_VLANDB_TINFO_ID = 1,
	BRIDGE_VLANDB_TINFO_CMD = 2,
	__BRIDGE_VLANDB_TINFO_MAX = 3,
};

enum {
	BRIDGE_VLANDB_UNSPEC = 0,
	BRIDGE_VLANDB_ENTRY = 1,
	BRIDGE_VLANDB_GLOBAL_OPTIONS = 2,
	__BRIDGE_VLANDB_MAX = 3,
};

enum {
	BRIDGE_XSTATS_UNSPEC = 0,
	BRIDGE_XSTATS_VLAN = 1,
	BRIDGE_XSTATS_MCAST = 2,
	BRIDGE_XSTATS_PAD = 3,
	BRIDGE_XSTATS_STP = 4,
	__BRIDGE_XSTATS_MAX = 5,
};

enum {
	BR_FDB_LOCAL = 0,
	BR_FDB_STATIC = 1,
	BR_FDB_STICKY = 2,
	BR_FDB_ADDED_BY_USER = 3,
	BR_FDB_ADDED_BY_EXT_LEARN = 4,
	BR_FDB_OFFLOADED = 5,
	BR_FDB_NOTIFY = 6,
	BR_FDB_NOTIFY_INACTIVE = 7,
	BR_FDB_LOCKED = 8,
	BR_FDB_DYNAMIC_LEARNED = 9,
};

enum {
	BR_GROUPFWD_STP = 1,
	BR_GROUPFWD_MACPAUSE = 2,
	BR_GROUPFWD_LACP = 4,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BR_VLFLAG_PER_PORT_STATS = 1,
	BR_VLFLAG_ADDED_BY_SWITCHDEV = 2,
	BR_VLFLAG_MCAST_ENABLED = 4,
	BR_VLFLAG_GLOBAL_MCAST_ENABLED = 8,
	BR_VLFLAG_NEIGH_SUPPRESS_ENABLED = 16,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BTREE_INSERT_STATUS_NO_INSERT = 0,
	BTREE_INSERT_STATUS_INSERT = 1,
	BTREE_INSERT_STATUS_BACK_MERGE = 2,
	BTREE_INSERT_STATUS_OVERWROTE = 3,
	BTREE_INSERT_STATUS_FRONT_MERGE = 4,
};

enum {
	Blktrace_setup = 1,
	Blktrace_running = 2,
	Blktrace_stopped = 3,
};

enum {
	CAP_HWCAP = 1,
	CAP_COMPAT_HWCAP = 2,
	CAP_COMPAT_HWCAP2 = 3,
};

enum {
	CCI_IF_SLAVE = 0,
	CCI_IF_MASTER = 1,
	CCI_IF_GLOBAL = 2,
	CCI_IF_MAX = 3,
};

enum {
	CEL_UUID = 0,
	VENDOR_DEBUG_UUID = 1,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
	CGRP_KILL = 4,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CMD_CLK_GET_RATE = 1,
	CMD_CLK_SET_RATE = 2,
	CMD_CLK_ROUND_RATE = 3,
	CMD_CLK_GET_PARENT = 4,
	CMD_CLK_SET_PARENT = 5,
	CMD_CLK_IS_ENABLED = 6,
	CMD_CLK_ENABLE = 7,
	CMD_CLK_DISABLE = 8,
	CMD_CLK_PROPERTIES = 9,
	CMD_CLK_POSSIBLE_PARENTS = 10,
	CMD_CLK_NUM_POSSIBLE_PARENTS = 11,
	CMD_CLK_GET_POSSIBLE_PARENT = 12,
	CMD_CLK_RESET_REFCOUNTS = 13,
	CMD_CLK_GET_ALL_INFO = 14,
	CMD_CLK_GET_MAX_CLK_ID = 15,
	CMD_CLK_GET_FMAX_AT_VMIN = 16,
	CMD_CLK_MAX = 17,
};

enum {
	CMD_I2C_XFER = 1,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	CP110_CLK_TYPE_CORE = 0,
	CP110_CLK_TYPE_GATABLE = 1,
};

enum {
	CPER_SEV_RECOVERABLE = 0,
	CPER_SEV_FATAL = 1,
	CPER_SEV_CORRECTED = 2,
	CPER_SEV_INFORMATIONAL = 3,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 250,
	CRNG_RESEED_INTERVAL = 15000,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_KPP_SECRET_TYPE_UNKNOWN = 0,
	CRYPTO_KPP_SECRET_TYPE_DH = 1,
	CRYPTO_KPP_SECRET_TYPE_ECDH = 2,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	CXL_MBOX_CMD_RC_SUCCESS = 0,
	CXL_MBOX_CMD_RC_BACKGROUND = 1,
	CXL_MBOX_CMD_RC_INPUT = 2,
	CXL_MBOX_CMD_RC_UNSUPPORTED = 3,
	CXL_MBOX_CMD_RC_INTERNAL = 4,
	CXL_MBOX_CMD_RC_RETRY = 5,
	CXL_MBOX_CMD_RC_BUSY = 6,
	CXL_MBOX_CMD_RC_MEDIADISABLED = 7,
	CXL_MBOX_CMD_RC_FWINPROGRESS = 8,
	CXL_MBOX_CMD_RC_FWOOO = 9,
	CXL_MBOX_CMD_RC_FWAUTH = 10,
	CXL_MBOX_CMD_RC_FWSLOT = 11,
	CXL_MBOX_CMD_RC_FWROLLBACK = 12,
	CXL_MBOX_CMD_RC_FWRESET = 13,
	CXL_MBOX_CMD_RC_HANDLE = 14,
	CXL_MBOX_CMD_RC_PADDR = 15,
	CXL_MBOX_CMD_RC_POISONLMT = 16,
	CXL_MBOX_CMD_RC_MEDIAFAILURE = 17,
	CXL_MBOX_CMD_RC_ABORT = 18,
	CXL_MBOX_CMD_RC_SECURITY = 19,
	CXL_MBOX_CMD_RC_PASSPHRASE = 20,
	CXL_MBOX_CMD_RC_MBUNSUPPORTED = 21,
	CXL_MBOX_CMD_RC_PAYLOADLEN = 22,
	CXL_MBOX_CMD_RC_LOG = 23,
	CXL_MBOX_CMD_RC_INTERRUPTED = 24,
	CXL_MBOX_CMD_RC_FEATUREVERSION = 25,
	CXL_MBOX_CMD_RC_FEATURESELVALUE = 26,
	CXL_MBOX_CMD_RC_FEATURETRANSFERIP = 27,
	CXL_MBOX_CMD_RC_FEATURETRANSFEROOO = 28,
	CXL_MBOX_CMD_RC_RESOURCEEXHAUSTED = 29,
	CXL_MBOX_CMD_RC_EXTLIST = 30,
};

enum {
	CXL_MEM_COMMAND_ID_INVALID = 0,
	CXL_MEM_COMMAND_ID_IDENTIFY = 1,
	CXL_MEM_COMMAND_ID_RAW = 2,
	CXL_MEM_COMMAND_ID_GET_SUPPORTED_LOGS = 3,
	CXL_MEM_COMMAND_ID_GET_FW_INFO = 4,
	CXL_MEM_COMMAND_ID_GET_PARTITION_INFO = 5,
	CXL_MEM_COMMAND_ID_GET_LSA = 6,
	CXL_MEM_COMMAND_ID_GET_HEALTH_INFO = 7,
	CXL_MEM_COMMAND_ID_GET_LOG = 8,
	CXL_MEM_COMMAND_ID_SET_PARTITION_INFO = 9,
	CXL_MEM_COMMAND_ID_SET_LSA = 10,
	CXL_MEM_COMMAND_ID_GET_ALERT_CONFIG = 11,
	CXL_MEM_COMMAND_ID_SET_ALERT_CONFIG = 12,
	CXL_MEM_COMMAND_ID_GET_SHUTDOWN_STATE = 13,
	CXL_MEM_COMMAND_ID_SET_SHUTDOWN_STATE = 14,
	CXL_MEM_DEPRECATED_ID_GET_POISON = 15,
	CXL_MEM_DEPRECATED_ID_INJECT_POISON = 16,
	CXL_MEM_DEPRECATED_ID_CLEAR_POISON = 17,
	CXL_MEM_COMMAND_ID_GET_SCAN_MEDIA_CAPS = 18,
	CXL_MEM_DEPRECATED_ID_SCAN_MEDIA = 19,
	CXL_MEM_DEPRECATED_ID_GET_SCAN_MEDIA = 20,
	CXL_MEM_COMMAND_ID_GET_TIMESTAMP = 21,
	CXL_MEM_COMMAND_ID_GET_LOG_CAPS = 22,
	CXL_MEM_COMMAND_ID_CLEAR_LOG = 23,
	CXL_MEM_COMMAND_ID_GET_SUP_LOG_SUBLIST = 24,
	CXL_MEM_COMMAND_ID_MAX = 25,
};

enum {
	DAD_PROCESS = 0,
	DAD_BEGIN = 1,
	DAD_ABORT = 2,
};

enum {
	DCCPO_PADDING = 0,
	DCCPO_MANDATORY = 1,
	DCCPO_MIN_RESERVED = 3,
	DCCPO_MAX_RESERVED = 31,
	DCCPO_CHANGE_L = 32,
	DCCPO_CONFIRM_L = 33,
	DCCPO_CHANGE_R = 34,
	DCCPO_CONFIRM_R = 35,
	DCCPO_NDP_COUNT = 37,
	DCCPO_ACK_VECTOR_0 = 38,
	DCCPO_ACK_VECTOR_1 = 39,
	DCCPO_TIMESTAMP = 41,
	DCCPO_TIMESTAMP_ECHO = 42,
	DCCPO_ELAPSED_TIME = 43,
	DCCPO_MAX = 45,
	DCCPO_MIN_RX_CCID_SPECIFIC = 128,
	DCCPO_MAX_RX_CCID_SPECIFIC = 191,
	DCCPO_MIN_TX_CCID_SPECIFIC = 192,
	DCCPO_MAX_TX_CCID_SPECIFIC = 255,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEVCONF_FORWARDING = 0,
	DEVCONF_HOPLIMIT = 1,
	DEVCONF_MTU6 = 2,
	DEVCONF_ACCEPT_RA = 3,
	DEVCONF_ACCEPT_REDIRECTS = 4,
	DEVCONF_AUTOCONF = 5,
	DEVCONF_DAD_TRANSMITS = 6,
	DEVCONF_RTR_SOLICITS = 7,
	DEVCONF_RTR_SOLICIT_INTERVAL = 8,
	DEVCONF_RTR_SOLICIT_DELAY = 9,
	DEVCONF_USE_TEMPADDR = 10,
	DEVCONF_TEMP_VALID_LFT = 11,
	DEVCONF_TEMP_PREFERED_LFT = 12,
	DEVCONF_REGEN_MAX_RETRY = 13,
	DEVCONF_MAX_DESYNC_FACTOR = 14,
	DEVCONF_MAX_ADDRESSES = 15,
	DEVCONF_FORCE_MLD_VERSION = 16,
	DEVCONF_ACCEPT_RA_DEFRTR = 17,
	DEVCONF_ACCEPT_RA_PINFO = 18,
	DEVCONF_ACCEPT_RA_RTR_PREF = 19,
	DEVCONF_RTR_PROBE_INTERVAL = 20,
	DEVCONF_ACCEPT_RA_RT_INFO_MAX_PLEN = 21,
	DEVCONF_PROXY_NDP = 22,
	DEVCONF_OPTIMISTIC_DAD = 23,
	DEVCONF_ACCEPT_SOURCE_ROUTE = 24,
	DEVCONF_MC_FORWARDING = 25,
	DEVCONF_DISABLE_IPV6 = 26,
	DEVCONF_ACCEPT_DAD = 27,
	DEVCONF_FORCE_TLLAO = 28,
	DEVCONF_NDISC_NOTIFY = 29,
	DEVCONF_MLDV1_UNSOLICITED_REPORT_INTERVAL = 30,
	DEVCONF_MLDV2_UNSOLICITED_REPORT_INTERVAL = 31,
	DEVCONF_SUPPRESS_FRAG_NDISC = 32,
	DEVCONF_ACCEPT_RA_FROM_LOCAL = 33,
	DEVCONF_USE_OPTIMISTIC = 34,
	DEVCONF_ACCEPT_RA_MTU = 35,
	DEVCONF_STABLE_SECRET = 36,
	DEVCONF_USE_OIF_ADDRS_ONLY = 37,
	DEVCONF_ACCEPT_RA_MIN_HOP_LIMIT = 38,
	DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 39,
	DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 40,
	DEVCONF_DROP_UNSOLICITED_NA = 41,
	DEVCONF_KEEP_ADDR_ON_DOWN = 42,
	DEVCONF_RTR_SOLICIT_MAX_INTERVAL = 43,
	DEVCONF_SEG6_ENABLED = 44,
	DEVCONF_SEG6_REQUIRE_HMAC = 45,
	DEVCONF_ENHANCED_DAD = 46,
	DEVCONF_ADDR_GEN_MODE = 47,
	DEVCONF_DISABLE_POLICY = 48,
	DEVCONF_ACCEPT_RA_RT_INFO_MIN_PLEN = 49,
	DEVCONF_NDISC_TCLASS = 50,
	DEVCONF_RPL_SEG_ENABLED = 51,
	DEVCONF_RA_DEFRTR_METRIC = 52,
	DEVCONF_IOAM6_ENABLED = 53,
	DEVCONF_IOAM6_ID = 54,
	DEVCONF_IOAM6_ID_WIDE = 55,
	DEVCONF_NDISC_EVICT_NOCARRIER = 56,
	DEVCONF_ACCEPT_UNTRACKED_NA = 57,
	DEVCONF_ACCEPT_RA_MIN_LFT = 58,
	DEVCONF_MAX = 59,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIR_OFFSET_MIN = 2,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DM_IO_ACCOUNTED = 0,
	DM_IO_WAS_SPLIT = 1,
	DM_IO_BLK_STAT = 2,
};

enum {
	DM_TIO_INSIDE_DM_IO = 0,
	DM_TIO_IS_DUPLICATE_BIO = 1,
};

enum {
	DM_VERSION_CMD = 0,
	DM_REMOVE_ALL_CMD = 1,
	DM_LIST_DEVICES_CMD = 2,
	DM_DEV_CREATE_CMD = 3,
	DM_DEV_REMOVE_CMD = 4,
	DM_DEV_RENAME_CMD = 5,
	DM_DEV_SUSPEND_CMD = 6,
	DM_DEV_STATUS_CMD = 7,
	DM_DEV_WAIT_CMD = 8,
	DM_TABLE_LOAD_CMD = 9,
	DM_TABLE_CLEAR_CMD = 10,
	DM_TABLE_DEPS_CMD = 11,
	DM_TABLE_STATUS_CMD = 12,
	DM_LIST_VERSIONS_CMD = 13,
	DM_TARGET_MSG_CMD = 14,
	DM_DEV_SET_GEOMETRY_CMD = 15,
	DM_DEV_ARM_POLL_CMD = 16,
	DM_GET_TARGET_VERSION_CMD = 17,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DOWN = 0,
	UP = 1,
};

enum {
	DPLL_NLGRP_MONITOR = 0,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DRV_FIXED = 0,
	DRV_GRP0 = 1,
	DRV_GRP1 = 2,
	DRV_GRP2 = 3,
	DRV_GRP3 = 4,
	DRV_GRP4 = 5,
	DRV_GRP_MAX = 6,
};

enum {
	DSA_NOTIFIER_AGEING_TIME = 0,
	DSA_NOTIFIER_BRIDGE_JOIN = 1,
	DSA_NOTIFIER_BRIDGE_LEAVE = 2,
	DSA_NOTIFIER_FDB_ADD = 3,
	DSA_NOTIFIER_FDB_DEL = 4,
	DSA_NOTIFIER_HOST_FDB_ADD = 5,
	DSA_NOTIFIER_HOST_FDB_DEL = 6,
	DSA_NOTIFIER_LAG_FDB_ADD = 7,
	DSA_NOTIFIER_LAG_FDB_DEL = 8,
	DSA_NOTIFIER_LAG_CHANGE = 9,
	DSA_NOTIFIER_LAG_JOIN = 10,
	DSA_NOTIFIER_LAG_LEAVE = 11,
	DSA_NOTIFIER_MDB_ADD = 12,
	DSA_NOTIFIER_MDB_DEL = 13,
	DSA_NOTIFIER_HOST_MDB_ADD = 14,
	DSA_NOTIFIER_HOST_MDB_DEL = 15,
	DSA_NOTIFIER_VLAN_ADD = 16,
	DSA_NOTIFIER_VLAN_DEL = 17,
	DSA_NOTIFIER_HOST_VLAN_ADD = 18,
	DSA_NOTIFIER_HOST_VLAN_DEL = 19,
	DSA_NOTIFIER_MTU = 20,
	DSA_NOTIFIER_TAG_PROTO = 21,
	DSA_NOTIFIER_TAG_PROTO_CONNECT = 22,
	DSA_NOTIFIER_TAG_PROTO_DISCONNECT = 23,
	DSA_NOTIFIER_TAG_8021Q_VLAN_ADD = 24,
	DSA_NOTIFIER_TAG_8021Q_VLAN_DEL = 25,
	DSA_NOTIFIER_CONDUIT_STATE_CHANGE = 26,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	EC_MSG_TX_HEADER_BYTES = 3,
	EC_MSG_TX_TRAILER_BYTES = 1,
	EC_MSG_TX_PROTO_BYTES = 4,
	EC_MSG_RX_PROTO_BYTES = 3,
	EC_PROTO2_MSG_BYTES = 256,
	EC_MAX_MSG_BYTES = 65536,
};

enum {
	EI_ETYPE_NULL = 0,
	EI_ETYPE_ERRNO = 1,
	EI_ETYPE_ERRNO_NULL = 2,
	EI_ETYPE_TRUE = 3,
};

enum {
	ELANTECH_SMBUS_NOT_SET = -1,
	ELANTECH_SMBUS_OFF = 0,
	ELANTECH_SMBUS_ON = 1,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	__ETHTOOL_A_RINGS_CNT = 17,
	ETHTOOL_A_RINGS_MAX = 16,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	__ETHTOOL_A_TSINFO_CNT = 7,
	ETHTOOL_A_TSINFO_MAX = 6,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	__ETHTOOL_A_TS_STAT_CNT = 4,
	ETHTOOL_A_TS_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	__ETHTOOL_MSG_KERNEL_CNT = 47,
	ETHTOOL_MSG_KERNEL_MAX = 46,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	__ETHTOOL_MSG_USER_CNT = 46,
	ETHTOOL_MSG_USER_MAX = 45,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	__ETHTOOL_STATS_CNT = 4,
};

enum {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENTFS_SAVE_MODE = 65536,
	EVENTFS_SAVE_UID = 131072,
	EVENTFS_SAVE_GID = 262144,
};

enum {
	EVENT_FILE_FL_ENABLED = 1,
	EVENT_FILE_FL_RECORDED_CMD = 2,
	EVENT_FILE_FL_RECORDED_TGID = 4,
	EVENT_FILE_FL_FILTERED = 8,
	EVENT_FILE_FL_NO_SET_FILTER = 16,
	EVENT_FILE_FL_SOFT_MODE = 32,
	EVENT_FILE_FL_SOFT_DISABLED = 64,
	EVENT_FILE_FL_TRIGGER_MODE = 128,
	EVENT_FILE_FL_TRIGGER_COND = 256,
	EVENT_FILE_FL_PID_FILTER = 512,
	EVENT_FILE_FL_WAS_ENABLED = 1024,
	EVENT_FILE_FL_FREED = 2048,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EVENT_TRIGGER_FL_PROBE = 1,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_ORPHAN_FILE = 11,
};

enum {
	FAN53526_CHIP_ID_01 = 1,
};

enum {
	FAN53526_CHIP_REV_08 = 8,
};

enum {
	FAN53555_CHIP_ID_00 = 0,
	FAN53555_CHIP_ID_01 = 1,
	FAN53555_CHIP_ID_02 = 2,
	FAN53555_CHIP_ID_03 = 3,
	FAN53555_CHIP_ID_04 = 4,
	FAN53555_CHIP_ID_05 = 5,
	FAN53555_CHIP_ID_08 = 8,
};

enum {
	FAN53555_CHIP_REV_00 = 3,
	FAN53555_CHIP_REV_13 = 15,
};

enum {
	FAN53555_VSEL_ID_0 = 0,
	FAN53555_VSEL_ID_1 = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FDB_NOTIFY_BIT = 1,
	FDB_NOTIFY_INACTIVE_BIT = 2,
};

enum {
	FGRAPH_TYPE_RESERVED = 0,
	FGRAPH_TYPE_BITMAP = 1,
	FGRAPH_TYPE_DATA = 2,
};

enum {
	FIB6_NO_SERNUM_CHANGE = 0,
};

enum {
	FILTER_OTHER = 0,
	FILTER_STATIC_STRING = 1,
	FILTER_DYN_STRING = 2,
	FILTER_RDYN_STRING = 3,
	FILTER_PTR_STRING = 4,
	FILTER_TRACE_FN = 5,
	FILTER_CPUMASK = 6,
	FILTER_COMM = 7,
	FILTER_CPU = 8,
	FILTER_STACKTRACE = 9,
};

enum {
	FILT_ERR_NONE = 0,
	FILT_ERR_INVALID_OP = 1,
	FILT_ERR_TOO_MANY_OPEN = 2,
	FILT_ERR_TOO_MANY_CLOSE = 3,
	FILT_ERR_MISSING_QUOTE = 4,
	FILT_ERR_MISSING_BRACE_OPEN = 5,
	FILT_ERR_MISSING_BRACE_CLOSE = 6,
	FILT_ERR_OPERAND_TOO_LONG = 7,
	FILT_ERR_EXPECT_STRING = 8,
	FILT_ERR_EXPECT_DIGIT = 9,
	FILT_ERR_ILLEGAL_FIELD_OP = 10,
	FILT_ERR_FIELD_NOT_FOUND = 11,
	FILT_ERR_ILLEGAL_INTVAL = 12,
	FILT_ERR_BAD_SUBSYS_FILTER = 13,
	FILT_ERR_TOO_MANY_PREDS = 14,
	FILT_ERR_INVALID_FILTER = 15,
	FILT_ERR_INVALID_CPULIST = 16,
	FILT_ERR_IP_FIELD_ONLY = 17,
	FILT_ERR_INVALID_VALUE = 18,
	FILT_ERR_NO_FUNCTION = 19,
	FILT_ERR_ERRNO = 20,
	FILT_ERR_NO_FILTER = 21,
};

enum {
	FLAGS_FILL_FULL = 268435456,
	FLAGS_FILL_START = 536870912,
	FLAGS_FILL_END = 805306368,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FORMAT_HEADER = 1,
	FORMAT_FIELD_SEPERATOR = 2,
	FORMAT_PRINTFMT = 3,
};

enum {
	FRACTION_DENOM = 128,
};

enum {
	FRA_UNSPEC = 0,
	FRA_DST = 1,
	FRA_SRC = 2,
	FRA_IIFNAME = 3,
	FRA_GOTO = 4,
	FRA_UNUSED2 = 5,
	FRA_PRIORITY = 6,
	FRA_UNUSED3 = 7,
	FRA_UNUSED4 = 8,
	FRA_UNUSED5 = 9,
	FRA_FWMARK = 10,
	FRA_FLOW = 11,
	FRA_TUN_ID = 12,
	FRA_SUPPRESS_IFGROUP = 13,
	FRA_SUPPRESS_PREFIXLEN = 14,
	FRA_TABLE = 15,
	FRA_FWMASK = 16,
	FRA_OIFNAME = 17,
	FRA_PAD = 18,
	FRA_L3MDEV = 19,
	FRA_UID_RANGE = 20,
	FRA_PROTOCOL = 21,
	FRA_IP_PROTO = 22,
	FRA_SPORT_RANGE = 23,
	FRA_DPORT_RANGE = 24,
	FRA_DSCP = 25,
	__FRA_MAX = 26,
};

enum {
	FR_ACT_UNSPEC = 0,
	FR_ACT_TO_TBL = 1,
	FR_ACT_GOTO = 2,
	FR_ACT_NOP = 3,
	FR_ACT_RES3 = 4,
	FR_ACT_RES4 = 5,
	FR_ACT_BLACKHOLE = 6,
	FR_ACT_UNREACHABLE = 7,
	FR_ACT_PROHIBIT = 8,
	__FR_ACT_MAX = 9,
};

enum {
	FTRACE_FL_ENABLED = 2147483648,
	FTRACE_FL_REGS = 1073741824,
	FTRACE_FL_REGS_EN = 536870912,
	FTRACE_FL_TRAMP = 268435456,
	FTRACE_FL_TRAMP_EN = 134217728,
	FTRACE_FL_IPMODIFY = 67108864,
	FTRACE_FL_DISABLED = 33554432,
	FTRACE_FL_DIRECT = 16777216,
	FTRACE_FL_DIRECT_EN = 8388608,
	FTRACE_FL_CALL_OPS = 4194304,
	FTRACE_FL_CALL_OPS_EN = 2097152,
	FTRACE_FL_TOUCHED = 1048576,
	FTRACE_FL_MODIFIED = 524288,
};

enum {
	FTRACE_HASH_FL_MOD = 1,
};

enum {
	FTRACE_ITER_FILTER = 1,
	FTRACE_ITER_NOTRACE = 2,
	FTRACE_ITER_PRINTALL = 4,
	FTRACE_ITER_DO_PROBES = 8,
	FTRACE_ITER_PROBE = 16,
	FTRACE_ITER_MOD = 32,
	FTRACE_ITER_ENABLED = 64,
	FTRACE_ITER_TOUCHED = 128,
	FTRACE_ITER_ADDRS = 256,
};

enum {
	FTRACE_MODIFY_ENABLE_FL = 1,
	FTRACE_MODIFY_MAY_SLEEP_FL = 2,
};

enum {
	FTRACE_OPS_FL_ENABLED = 1,
	FTRACE_OPS_FL_DYNAMIC = 2,
	FTRACE_OPS_FL_SAVE_REGS = 4,
	FTRACE_OPS_FL_SAVE_REGS_IF_SUPPORTED = 8,
	FTRACE_OPS_FL_RECURSION = 16,
	FTRACE_OPS_FL_STUB = 32,
	FTRACE_OPS_FL_INITIALIZED = 64,
	FTRACE_OPS_FL_DELETED = 128,
	FTRACE_OPS_FL_ADDING = 256,
	FTRACE_OPS_FL_REMOVING = 512,
	FTRACE_OPS_FL_MODIFYING = 1024,
	FTRACE_OPS_FL_ALLOC_TRAMP = 2048,
	FTRACE_OPS_FL_IPMODIFY = 4096,
	FTRACE_OPS_FL_PID = 8192,
	FTRACE_OPS_FL_RCU = 16384,
	FTRACE_OPS_FL_TRACE_ARRAY = 32768,
	FTRACE_OPS_FL_PERMANENT = 65536,
	FTRACE_OPS_FL_DIRECT = 131072,
	FTRACE_OPS_FL_SUBOP = 262144,
};

enum {
	FTRACE_UPDATE_CALLS = 1,
	FTRACE_DISABLE_CALLS = 2,
	FTRACE_UPDATE_TRACE_FUNC = 4,
	FTRACE_START_FUNC_RET = 8,
	FTRACE_STOP_FUNC_RET = 16,
	FTRACE_MAY_SLEEP = 32,
};

enum {
	FTRACE_UPDATE_IGNORE = 0,
	FTRACE_UPDATE_MAKE_CALL = 1,
	FTRACE_UPDATE_MODIFY_CALL = 2,
	FTRACE_UPDATE_MAKE_NOP = 3,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GHES_SEV_NO = 0,
	GHES_SEV_CORRECTED = 1,
	GHES_SEV_RECOVERABLE = 2,
	GHES_SEV_PANIC = 3,
};

enum {
	GPIO_BASE = 0,
	IOCFG_RT_BASE = 1,
	IOCFG_RB_BASE = 2,
	IOCFG_LT_BASE = 3,
	IOCFG_LB_BASE = 4,
	IOCFG_TR_BASE = 5,
	IOCFG_TL_BASE = 6,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HIST_ERR_NONE = 0,
	HIST_ERR_DUPLICATE_VAR = 1,
	HIST_ERR_VAR_NOT_UNIQUE = 2,
	HIST_ERR_TOO_MANY_VARS = 3,
	HIST_ERR_MALFORMED_ASSIGNMENT = 4,
	HIST_ERR_NAMED_MISMATCH = 5,
	HIST_ERR_TRIGGER_EEXIST = 6,
	HIST_ERR_TRIGGER_ENOENT_CLEAR = 7,
	HIST_ERR_SET_CLOCK_FAIL = 8,
	HIST_ERR_BAD_FIELD_MODIFIER = 9,
	HIST_ERR_TOO_MANY_SUBEXPR = 10,
	HIST_ERR_TIMESTAMP_MISMATCH = 11,
	HIST_ERR_TOO_MANY_FIELD_VARS = 12,
	HIST_ERR_EVENT_FILE_NOT_FOUND = 13,
	HIST_ERR_HIST_NOT_FOUND = 14,
	HIST_ERR_HIST_CREATE_FAIL = 15,
	HIST_ERR_SYNTH_VAR_NOT_FOUND = 16,
	HIST_ERR_SYNTH_EVENT_NOT_FOUND = 17,
	HIST_ERR_SYNTH_TYPE_MISMATCH = 18,
	HIST_ERR_SYNTH_COUNT_MISMATCH = 19,
	HIST_ERR_FIELD_VAR_PARSE_FAIL = 20,
	HIST_ERR_VAR_CREATE_FIND_FAIL = 21,
	HIST_ERR_ONX_NOT_VAR = 22,
	HIST_ERR_ONX_VAR_NOT_FOUND = 23,
	HIST_ERR_ONX_VAR_CREATE_FAIL = 24,
	HIST_ERR_FIELD_VAR_CREATE_FAIL = 25,
	HIST_ERR_TOO_MANY_PARAMS = 26,
	HIST_ERR_PARAM_NOT_FOUND = 27,
	HIST_ERR_INVALID_PARAM = 28,
	HIST_ERR_ACTION_NOT_FOUND = 29,
	HIST_ERR_NO_SAVE_PARAMS = 30,
	HIST_ERR_TOO_MANY_SAVE_ACTIONS = 31,
	HIST_ERR_ACTION_MISMATCH = 32,
	HIST_ERR_NO_CLOSING_PAREN = 33,
	HIST_ERR_SUBSYS_NOT_FOUND = 34,
	HIST_ERR_INVALID_SUBSYS_EVENT = 35,
	HIST_ERR_INVALID_REF_KEY = 36,
	HIST_ERR_VAR_NOT_FOUND = 37,
	HIST_ERR_FIELD_NOT_FOUND = 38,
	HIST_ERR_EMPTY_ASSIGNMENT = 39,
	HIST_ERR_INVALID_SORT_MODIFIER = 40,
	HIST_ERR_EMPTY_SORT_FIELD = 41,
	HIST_ERR_TOO_MANY_SORT_FIELDS = 42,
	HIST_ERR_INVALID_SORT_FIELD = 43,
	HIST_ERR_INVALID_STR_OPERAND = 44,
	HIST_ERR_EXPECT_NUMBER = 45,
	HIST_ERR_UNARY_MINUS_SUBEXPR = 46,
	HIST_ERR_DIVISION_BY_ZERO = 47,
	HIST_ERR_NEED_NOHC_VAL = 48,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HMM_NEED_FAULT = 1,
	HMM_NEED_WRITE_FAULT = 2,
	HMM_NEED_ALL_BITS = 3,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HSR_A_UNSPEC = 0,
	HSR_A_NODE_ADDR = 1,
	HSR_A_IFINDEX = 2,
	HSR_A_IF1_AGE = 3,
	HSR_A_IF2_AGE = 4,
	HSR_A_NODE_ADDR_B = 5,
	HSR_A_IF1_SEQ = 6,
	HSR_A_IF2_SEQ = 7,
	HSR_A_IF1_IFINDEX = 8,
	HSR_A_IF2_IFINDEX = 9,
	HSR_A_ADDR_B_IFINDEX = 10,
	__HSR_A_MAX = 11,
};

enum {
	HSR_C_UNSPEC = 0,
	HSR_C_RING_ERROR = 1,
	HSR_C_NODE_DOWN = 2,
	HSR_C_GET_NODE_STATUS = 3,
	HSR_C_SET_NODE_STATUS = 4,
	HSR_C_GET_NODE_LIST = 5,
	HSR_C_SET_NODE_LIST = 6,
	__HSR_C_MAX = 7,
};

enum {
	HSR_PROTOCOL_HSR = 0,
	HSR_PROTOCOL_PRP = 1,
	HSR_PROTOCOL_MAX = 2,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFAL_ADDRESS = 1,
	IFAL_LABEL = 2,
	__IFAL_MAX = 3,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRIDGE_MST_ENTRY_UNSPEC = 0,
	IFLA_BRIDGE_MST_ENTRY_MSTI = 1,
	IFLA_BRIDGE_MST_ENTRY_STATE = 2,
	__IFLA_BRIDGE_MST_ENTRY_MAX = 3,
};

enum {
	IFLA_BRIDGE_MST_UNSPEC = 0,
	IFLA_BRIDGE_MST_ENTRY = 1,
	__IFLA_BRIDGE_MST_MAX = 2,
};

enum {
	IFLA_BRIDGE_VLAN_TUNNEL_UNSPEC = 0,
	IFLA_BRIDGE_VLAN_TUNNEL_ID = 1,
	IFLA_BRIDGE_VLAN_TUNNEL_VID = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_FLAGS = 3,
	__IFLA_BRIDGE_VLAN_TUNNEL_MAX = 4,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_BR_UNSPEC = 0,
	IFLA_BR_FORWARD_DELAY = 1,
	IFLA_BR_HELLO_TIME = 2,
	IFLA_BR_MAX_AGE = 3,
	IFLA_BR_AGEING_TIME = 4,
	IFLA_BR_STP_STATE = 5,
	IFLA_BR_PRIORITY = 6,
	IFLA_BR_VLAN_FILTERING = 7,
	IFLA_BR_VLAN_PROTOCOL = 8,
	IFLA_BR_GROUP_FWD_MASK = 9,
	IFLA_BR_ROOT_ID = 10,
	IFLA_BR_BRIDGE_ID = 11,
	IFLA_BR_ROOT_PORT = 12,
	IFLA_BR_ROOT_PATH_COST = 13,
	IFLA_BR_TOPOLOGY_CHANGE = 14,
	IFLA_BR_TOPOLOGY_CHANGE_DETECTED = 15,
	IFLA_BR_HELLO_TIMER = 16,
	IFLA_BR_TCN_TIMER = 17,
	IFLA_BR_TOPOLOGY_CHANGE_TIMER = 18,
	IFLA_BR_GC_TIMER = 19,
	IFLA_BR_GROUP_ADDR = 20,
	IFLA_BR_FDB_FLUSH = 21,
	IFLA_BR_MCAST_ROUTER = 22,
	IFLA_BR_MCAST_SNOOPING = 23,
	IFLA_BR_MCAST_QUERY_USE_IFADDR = 24,
	IFLA_BR_MCAST_QUERIER = 25,
	IFLA_BR_MCAST_HASH_ELASTICITY = 26,
	IFLA_BR_MCAST_HASH_MAX = 27,
	IFLA_BR_MCAST_LAST_MEMBER_CNT = 28,
	IFLA_BR_MCAST_STARTUP_QUERY_CNT = 29,
	IFLA_BR_MCAST_LAST_MEMBER_INTVL = 30,
	IFLA_BR_MCAST_MEMBERSHIP_INTVL = 31,
	IFLA_BR_MCAST_QUERIER_INTVL = 32,
	IFLA_BR_MCAST_QUERY_INTVL = 33,
	IFLA_BR_MCAST_QUERY_RESPONSE_INTVL = 34,
	IFLA_BR_MCAST_STARTUP_QUERY_INTVL = 35,
	IFLA_BR_NF_CALL_IPTABLES = 36,
	IFLA_BR_NF_CALL_IP6TABLES = 37,
	IFLA_BR_NF_CALL_ARPTABLES = 38,
	IFLA_BR_VLAN_DEFAULT_PVID = 39,
	IFLA_BR_PAD = 40,
	IFLA_BR_VLAN_STATS_ENABLED = 41,
	IFLA_BR_MCAST_STATS_ENABLED = 42,
	IFLA_BR_MCAST_IGMP_VERSION = 43,
	IFLA_BR_MCAST_MLD_VERSION = 44,
	IFLA_BR_VLAN_STATS_PER_PORT = 45,
	IFLA_BR_MULTI_BOOLOPT = 46,
	IFLA_BR_MCAST_QUERIER_STATE = 47,
	IFLA_BR_FDB_N_LEARNED = 48,
	IFLA_BR_FDB_MAX_LEARNED = 49,
	__IFLA_BR_MAX = 50,
};

enum {
	IFLA_DSA_UNSPEC = 0,
	IFLA_DSA_CONDUIT = 1,
	IFLA_DSA_MASTER = 1,
	__IFLA_DSA_MAX = 2,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_HSR_UNSPEC = 0,
	IFLA_HSR_SLAVE1 = 1,
	IFLA_HSR_SLAVE2 = 2,
	IFLA_HSR_MULTICAST_SPEC = 3,
	IFLA_HSR_SUPERVISION_ADDR = 4,
	IFLA_HSR_SEQ_NR = 5,
	IFLA_HSR_VERSION = 6,
	IFLA_HSR_PROTOCOL = 7,
	IFLA_HSR_INTERLINK = 8,
	__IFLA_HSR_MAX = 9,
};

enum {
	IFLA_INET6_UNSPEC = 0,
	IFLA_INET6_FLAGS = 1,
	IFLA_INET6_CONF = 2,
	IFLA_INET6_STATS = 3,
	IFLA_INET6_MCAST = 4,
	IFLA_INET6_CACHEINFO = 5,
	IFLA_INET6_ICMP6STATS = 6,
	IFLA_INET6_TOKEN = 7,
	IFLA_INET6_ADDR_GEN_MODE = 8,
	IFLA_INET6_RA_MTU = 9,
	__IFLA_INET6_MAX = 10,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_NETKIT_UNSPEC = 0,
	IFLA_NETKIT_PEER_INFO = 1,
	IFLA_NETKIT_PRIMARY = 2,
	IFLA_NETKIT_POLICY = 3,
	IFLA_NETKIT_PEER_POLICY = 4,
	IFLA_NETKIT_MODE = 5,
	IFLA_NETKIT_SCRUB = 6,
	IFLA_NETKIT_PEER_SCRUB = 7,
	__IFLA_NETKIT_MAX = 8,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	__IFLA_MAX = 67,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	INET6_IFADDR_STATE_PREDAD = 0,
	INET6_IFADDR_STATE_DAD = 1,
	INET6_IFADDR_STATE_POSTDAD = 2,
	INET6_IFADDR_STATE_ERRDAD = 3,
	INET6_IFADDR_STATE_DEAD = 4,
};

enum {
	INET_DIAG_BC_NOP = 0,
	INET_DIAG_BC_JMP = 1,
	INET_DIAG_BC_S_GE = 2,
	INET_DIAG_BC_S_LE = 3,
	INET_DIAG_BC_D_GE = 4,
	INET_DIAG_BC_D_LE = 5,
	INET_DIAG_BC_AUTO = 6,
	INET_DIAG_BC_S_COND = 7,
	INET_DIAG_BC_D_COND = 8,
	INET_DIAG_BC_DEV_COND = 9,
	INET_DIAG_BC_MARK_COND = 10,
	INET_DIAG_BC_S_EQ = 11,
	INET_DIAG_BC_D_EQ = 12,
	INET_DIAG_BC_CGROUP_COND = 13,
};

enum {
	INET_DIAG_NONE = 0,
	INET_DIAG_MEMINFO = 1,
	INET_DIAG_INFO = 2,
	INET_DIAG_VEGASINFO = 3,
	INET_DIAG_CONG = 4,
	INET_DIAG_TOS = 5,
	INET_DIAG_TCLASS = 6,
	INET_DIAG_SKMEMINFO = 7,
	INET_DIAG_SHUTDOWN = 8,
	INET_DIAG_DCTCPINFO = 9,
	INET_DIAG_PROTOCOL = 10,
	INET_DIAG_SKV6ONLY = 11,
	INET_DIAG_LOCALS = 12,
	INET_DIAG_PEERS = 13,
	INET_DIAG_PAD = 14,
	INET_DIAG_MARK = 15,
	INET_DIAG_BBRINFO = 16,
	INET_DIAG_CLASS_ID = 17,
	INET_DIAG_MD5SIG = 18,
	INET_DIAG_ULP_INFO = 19,
	INET_DIAG_SK_BPF_STORAGES = 20,
	INET_DIAG_CGROUP_ID = 21,
	INET_DIAG_SOCKOPT = 22,
	__INET_DIAG_MAX = 23,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
};

enum {
	INVERT = 1,
	PROCESS_AND = 2,
	PROCESS_OR = 4,
};

enum {
	IOAM6_ATTR_UNSPEC = 0,
	IOAM6_ATTR_NS_ID = 1,
	IOAM6_ATTR_NS_DATA = 2,
	IOAM6_ATTR_NS_DATA_WIDE = 3,
	IOAM6_ATTR_SC_ID = 4,
	IOAM6_ATTR_SC_DATA = 5,
	IOAM6_ATTR_SC_NONE = 6,
	IOAM6_ATTR_PAD = 7,
	__IOAM6_ATTR_MAX = 8,
};

enum {
	IOAM6_CMD_UNSPEC = 0,
	IOAM6_CMD_ADD_NAMESPACE = 1,
	IOAM6_CMD_DEL_NAMESPACE = 2,
	IOAM6_CMD_DUMP_NAMESPACES = 3,
	IOAM6_CMD_ADD_SCHEMA = 4,
	IOAM6_CMD_DEL_SCHEMA = 5,
	IOAM6_CMD_DUMP_SCHEMAS = 6,
	IOAM6_CMD_NS_SET_SCHEMA = 7,
	__IOAM6_CMD_MAX = 8,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_MMAP = 2,
	IOBL_INC = 4,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMUFD_ACCESS_RW_READ = 0,
	IOMMUFD_ACCESS_RW_WRITE = 1,
	IOMMUFD_ACCESS_RW_KTHREAD = 2,
	__IOMMUFD_ACCESS_RW_SLOW_PATH = 4,
};

enum {
	IOMMUFD_CMD_BASE = 128,
	IOMMUFD_CMD_DESTROY = 128,
	IOMMUFD_CMD_IOAS_ALLOC = 129,
	IOMMUFD_CMD_IOAS_ALLOW_IOVAS = 130,
	IOMMUFD_CMD_IOAS_COPY = 131,
	IOMMUFD_CMD_IOAS_IOVA_RANGES = 132,
	IOMMUFD_CMD_IOAS_MAP = 133,
	IOMMUFD_CMD_IOAS_UNMAP = 134,
	IOMMUFD_CMD_OPTION = 135,
	IOMMUFD_CMD_VFIO_IOAS = 136,
	IOMMUFD_CMD_HWPT_ALLOC = 137,
	IOMMUFD_CMD_GET_HW_INFO = 138,
	IOMMUFD_CMD_HWPT_SET_DIRTY_TRACKING = 139,
	IOMMUFD_CMD_HWPT_GET_DIRTY_BITMAP = 140,
	IOMMUFD_CMD_HWPT_INVALIDATE = 141,
	IOMMUFD_CMD_FAULT_QUEUE_ALLOC = 142,
	IOMMUFD_CMD_IOAS_MAP_FILE = 143,
	IOMMUFD_CMD_VIOMMU_ALLOC = 144,
	IOMMUFD_CMD_VDEVICE_ALLOC = 145,
	IOMMUFD_CMD_IOAS_CHANGE_PROCESS = 146,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IOPT_ALLOC_IOVA = 1,
};

enum {
	IOPT_PAGES_ACCOUNT_NONE = 0,
	IOPT_PAGES_ACCOUNT_USER = 1,
	IOPT_PAGES_ACCOUNT_MM = 2,
	IOPT_PAGES_ACCOUNT_MODE_NUM = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_OK = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_REQUEUE = -3072,
	IOU_STOP_MULTISHOT = -125,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
	IO_WORKER_F_BOUND = 3,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6MRA_CREPORT_UNSPEC = 0,
	IP6MRA_CREPORT_MSGTYPE = 1,
	IP6MRA_CREPORT_MIF_ID = 2,
	IP6MRA_CREPORT_SRC_ADDR = 3,
	IP6MRA_CREPORT_DST_ADDR = 4,
	IP6MRA_CREPORT_PKT = 5,
	__IP6MRA_CREPORT_MAX = 6,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPMRA_CREPORT_UNSPEC = 0,
	IPMRA_CREPORT_MSGTYPE = 1,
	IPMRA_CREPORT_VIF_ID = 2,
	IPMRA_CREPORT_SRC_ADDR = 3,
	IPMRA_CREPORT_DST_ADDR = 4,
	IPMRA_CREPORT_PKT = 5,
	IPMRA_CREPORT_TABLE = 6,
	__IPMRA_CREPORT_MAX = 7,
};

enum {
	IPMRA_TABLE_UNSPEC = 0,
	IPMRA_TABLE_ID = 1,
	IPMRA_TABLE_CACHE_RES_QUEUE_LEN = 2,
	IPMRA_TABLE_MROUTE_REG_VIF_NUM = 3,
	IPMRA_TABLE_MROUTE_DO_ASSERT = 4,
	IPMRA_TABLE_MROUTE_DO_PIM = 5,
	IPMRA_TABLE_VIFS = 6,
	IPMRA_TABLE_MROUTE_DO_WRVIFWHOLE = 7,
	__IPMRA_TABLE_MAX = 8,
};

enum {
	IPMRA_VIFA_UNSPEC = 0,
	IPMRA_VIFA_IFINDEX = 1,
	IPMRA_VIFA_VIF_ID = 2,
	IPMRA_VIFA_FLAGS = 3,
	IPMRA_VIFA_BYTES_IN = 4,
	IPMRA_VIFA_BYTES_OUT = 5,
	IPMRA_VIFA_PACKETS_IN = 6,
	IPMRA_VIFA_PACKETS_OUT = 7,
	IPMRA_VIFA_LOCAL_ADDR = 8,
	IPMRA_VIFA_REMOTE_ADDR = 9,
	IPMRA_VIFA_PAD = 10,
	__IPMRA_VIFA_MAX = 11,
};

enum {
	IPMRA_VIF_UNSPEC = 0,
	IPMRA_VIF = 1,
	__IPMRA_VIF_MAX = 2,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 4,
	IPSTATS_MIB_OUTREQUESTS = 5,
	IPSTATS_MIB_OUTOCTETS = 6,
	IPSTATS_MIB_INHDRERRORS = 7,
	IPSTATS_MIB_INTOOBIGERRORS = 8,
	IPSTATS_MIB_INNOROUTES = 9,
	IPSTATS_MIB_INADDRERRORS = 10,
	IPSTATS_MIB_INUNKNOWNPROTOS = 11,
	IPSTATS_MIB_INTRUNCATEDPKTS = 12,
	IPSTATS_MIB_INDISCARDS = 13,
	IPSTATS_MIB_OUTDISCARDS = 14,
	IPSTATS_MIB_OUTNOROUTES = 15,
	IPSTATS_MIB_REASMTIMEOUT = 16,
	IPSTATS_MIB_REASMREQDS = 17,
	IPSTATS_MIB_REASMOKS = 18,
	IPSTATS_MIB_REASMFAILS = 19,
	IPSTATS_MIB_FRAGOKS = 20,
	IPSTATS_MIB_FRAGFAILS = 21,
	IPSTATS_MIB_FRAGCREATES = 22,
	IPSTATS_MIB_INMCASTPKTS = 23,
	IPSTATS_MIB_OUTMCASTPKTS = 24,
	IPSTATS_MIB_INBCASTPKTS = 25,
	IPSTATS_MIB_OUTBCASTPKTS = 26,
	IPSTATS_MIB_INMCASTOCTETS = 27,
	IPSTATS_MIB_OUTMCASTOCTETS = 28,
	IPSTATS_MIB_INBCASTOCTETS = 29,
	IPSTATS_MIB_OUTBCASTOCTETS = 30,
	IPSTATS_MIB_CSUMERRORS = 31,
	IPSTATS_MIB_NOECTPKTS = 32,
	IPSTATS_MIB_ECT1PKTS = 33,
	IPSTATS_MIB_ECT0PKTS = 34,
	IPSTATS_MIB_CEPKTS = 35,
	IPSTATS_MIB_REASM_OVERLAPS = 36,
	IPSTATS_MIB_OUTPKTS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IPV6_SADDR_RULE_INIT = 0,
	IPV6_SADDR_RULE_LOCAL = 1,
	IPV6_SADDR_RULE_SCOPE = 2,
	IPV6_SADDR_RULE_PREFERRED = 3,
	IPV6_SADDR_RULE_OIF = 4,
	IPV6_SADDR_RULE_LABEL = 5,
	IPV6_SADDR_RULE_PRIVACY = 6,
	IPV6_SADDR_RULE_ORCHID = 7,
	IPV6_SADDR_RULE_PREFIX = 8,
	IPV6_SADDR_RULE_NOT_OPTIMISTIC = 9,
	IPV6_SADDR_RULE_MAX = 10,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_MOVE_PCNTXT = 32768,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_MOVE_PCNTXT = 16384,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KDB_NOT_INITIALIZED = 0,
	KDB_INIT_EARLY = 1,
	KDB_INIT_FULL = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KVM_REG_ARM_STD_BIT_TRNG_V1_0 = 0,
	KVM_REG_ARM_STD_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_STD_HYP_BIT_PV_TIME = 0,
	KVM_REG_ARM_STD_HYP_BMAP_BIT_COUNT = 1,
};

enum {
	KVM_REG_ARM_VENDOR_HYP_BIT_FUNC_FEAT = 0,
	KVM_REG_ARM_VENDOR_HYP_BIT_PTP = 1,
	KVM_REG_ARM_VENDOR_HYP_BMAP_BIT_COUNT = 2,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LAT_OK = 1,
	LAT_UNKNOWN = 2,
	LAT_UNKNOWN_WRITES = 3,
	LAT_EXCEEDED = 4,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_ID_DEV_LOG = 134217728,
	ATA_QUIRK_NO_LOG_DIR = 268435456,
	ATA_QUIRK_NO_FUA = 536870912,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINK_XSTATS_TYPE_UNSPEC = 0,
	LINK_XSTATS_TYPE_BRIDGE = 1,
	LINK_XSTATS_TYPE_BOND = 2,
	__LINK_XSTATS_TYPE_MAX = 3,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_DELAYEDACKS = 16,
	LINUX_MIB_DELAYEDACKLOCKED = 17,
	LINUX_MIB_DELAYEDACKLOST = 18,
	LINUX_MIB_LISTENOVERFLOWS = 19,
	LINUX_MIB_LISTENDROPS = 20,
	LINUX_MIB_TCPHPHITS = 21,
	LINUX_MIB_TCPPUREACKS = 22,
	LINUX_MIB_TCPHPACKS = 23,
	LINUX_MIB_TCPRENORECOVERY = 24,
	LINUX_MIB_TCPSACKRECOVERY = 25,
	LINUX_MIB_TCPSACKRENEGING = 26,
	LINUX_MIB_TCPSACKREORDER = 27,
	LINUX_MIB_TCPRENOREORDER = 28,
	LINUX_MIB_TCPTSREORDER = 29,
	LINUX_MIB_TCPFULLUNDO = 30,
	LINUX_MIB_TCPPARTIALUNDO = 31,
	LINUX_MIB_TCPDSACKUNDO = 32,
	LINUX_MIB_TCPLOSSUNDO = 33,
	LINUX_MIB_TCPLOSTRETRANSMIT = 34,
	LINUX_MIB_TCPRENOFAILURES = 35,
	LINUX_MIB_TCPSACKFAILURES = 36,
	LINUX_MIB_TCPLOSSFAILURES = 37,
	LINUX_MIB_TCPFASTRETRANS = 38,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 39,
	LINUX_MIB_TCPTIMEOUTS = 40,
	LINUX_MIB_TCPLOSSPROBES = 41,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 42,
	LINUX_MIB_TCPRENORECOVERYFAIL = 43,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 44,
	LINUX_MIB_TCPRCVCOLLAPSED = 45,
	LINUX_MIB_TCPDSACKOLDSENT = 46,
	LINUX_MIB_TCPDSACKOFOSENT = 47,
	LINUX_MIB_TCPDSACKRECV = 48,
	LINUX_MIB_TCPDSACKOFORECV = 49,
	LINUX_MIB_TCPABORTONDATA = 50,
	LINUX_MIB_TCPABORTONCLOSE = 51,
	LINUX_MIB_TCPABORTONMEMORY = 52,
	LINUX_MIB_TCPABORTONTIMEOUT = 53,
	LINUX_MIB_TCPABORTONLINGER = 54,
	LINUX_MIB_TCPABORTFAILED = 55,
	LINUX_MIB_TCPMEMORYPRESSURES = 56,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 57,
	LINUX_MIB_TCPSACKDISCARD = 58,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 59,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 60,
	LINUX_MIB_TCPSPURIOUSRTOS = 61,
	LINUX_MIB_TCPMD5NOTFOUND = 62,
	LINUX_MIB_TCPMD5UNEXPECTED = 63,
	LINUX_MIB_TCPMD5FAILURE = 64,
	LINUX_MIB_SACKSHIFTED = 65,
	LINUX_MIB_SACKMERGED = 66,
	LINUX_MIB_SACKSHIFTFALLBACK = 67,
	LINUX_MIB_TCPBACKLOGDROP = 68,
	LINUX_MIB_PFMEMALLOCDROP = 69,
	LINUX_MIB_TCPMINTTLDROP = 70,
	LINUX_MIB_TCPDEFERACCEPTDROP = 71,
	LINUX_MIB_IPRPFILTER = 72,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 73,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 74,
	LINUX_MIB_TCPREQQFULLDROP = 75,
	LINUX_MIB_TCPRETRANSFAIL = 76,
	LINUX_MIB_TCPRCVCOALESCE = 77,
	LINUX_MIB_TCPBACKLOGCOALESCE = 78,
	LINUX_MIB_TCPOFOQUEUE = 79,
	LINUX_MIB_TCPOFODROP = 80,
	LINUX_MIB_TCPOFOMERGE = 81,
	LINUX_MIB_TCPCHALLENGEACK = 82,
	LINUX_MIB_TCPSYNCHALLENGE = 83,
	LINUX_MIB_TCPFASTOPENACTIVE = 84,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 85,
	LINUX_MIB_TCPFASTOPENPASSIVE = 86,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 87,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 88,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 89,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 90,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 91,
	LINUX_MIB_BUSYPOLLRXPACKETS = 92,
	LINUX_MIB_TCPAUTOCORKING = 93,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 94,
	LINUX_MIB_TCPTOZEROWINDOWADV = 95,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 96,
	LINUX_MIB_TCPSYNRETRANS = 97,
	LINUX_MIB_TCPORIGDATASENT = 98,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 99,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 100,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 101,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 102,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 103,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 104,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 105,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 106,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 107,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 108,
	LINUX_MIB_TCPWINPROBE = 109,
	LINUX_MIB_TCPKEEPALIVE = 110,
	LINUX_MIB_TCPMTUPFAIL = 111,
	LINUX_MIB_TCPMTUPSUCCESS = 112,
	LINUX_MIB_TCPDELIVERED = 113,
	LINUX_MIB_TCPDELIVEREDCE = 114,
	LINUX_MIB_TCPACKCOMPRESSED = 115,
	LINUX_MIB_TCPZEROWINDOWDROP = 116,
	LINUX_MIB_TCPRCVQDROP = 117,
	LINUX_MIB_TCPWQUEUETOOBIG = 118,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 119,
	LINUX_MIB_TCPTIMEOUTREHASH = 120,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 121,
	LINUX_MIB_TCPDSACKRECVSEGS = 122,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 123,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 124,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 125,
	LINUX_MIB_TCPPLBREHASH = 126,
	LINUX_MIB_TCPAOREQUIRED = 127,
	LINUX_MIB_TCPAOBAD = 128,
	LINUX_MIB_TCPAOKEYNOTFOUND = 129,
	LINUX_MIB_TCPAOGOOD = 130,
	LINUX_MIB_TCPAODROPPEDICMPS = 131,
	__LINUX_MIB_MAX = 132,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	__LINUX_MIB_TLSMAX = 13,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	__LINUX_MIB_XFRMMAX = 31,
};

enum {
	LINUX_RAID_PARTITION = 253,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LRU_GEN_ANON = 0,
	LRU_GEN_FILE = 1,
};

enum {
	LRU_GEN_CORE = 0,
	LRU_GEN_MM_WALK = 1,
	LRU_GEN_NONLEAF_YOUNG = 2,
	NR_LRU_GEN_CAPS = 3,
};

enum {
	LTSSM_DETECT_QUIET = 0,
	LTSSM_DETECT_ACTIVE = 1,
	LTSSM_POLLING_ACTIVE = 2,
	LTSSM_POLLING_COMPLIANCE = 3,
	LTSSM_POLLING_CONFIGURATION = 4,
	LTSSM_CONFIG_LINKWIDTH_START = 5,
	LTSSM_CONFIG_LINKWIDTH_ACCEPT = 6,
	LTSSM_CONFIG_LANENUM_ACCEPT = 7,
	LTSSM_CONFIG_LANENUM_WAIT = 8,
	LTSSM_CONFIG_COMPLETE = 9,
	LTSSM_CONFIG_IDLE = 10,
	LTSSM_RECOVERY_RCVR_LOCK = 11,
	LTSSM_RECOVERY_SPEED = 12,
	LTSSM_RECOVERY_RCVR_CFG = 13,
	LTSSM_RECOVERY_IDLE = 14,
	LTSSM_L0 = 16,
	LTSSM_RX_L0S_ENTRY = 17,
	LTSSM_RX_L0S_IDLE = 18,
	LTSSM_RX_L0S_FTS = 19,
	LTSSM_TX_L0S_ENTRY = 20,
	LTSSM_TX_L0S_IDLE = 21,
	LTSSM_TX_L0S_FTS = 22,
	LTSSM_L1_ENTRY = 23,
	LTSSM_L1_IDLE = 24,
	LTSSM_L2_IDLE = 25,
	LTSSM_L2_TRANSMIT_WAKE = 26,
	LTSSM_DISABLED = 32,
	LTSSM_LOOPBACK_ENTRY_MASTER = 33,
	LTSSM_LOOPBACK_ACTIVE_MASTER = 34,
	LTSSM_LOOPBACK_EXIT_MASTER = 35,
	LTSSM_LOOPBACK_ENTRY_SLAVE = 36,
	LTSSM_LOOPBACK_ACTIVE_SLAVE = 37,
	LTSSM_LOOPBACK_EXIT_SLAVE = 38,
	LTSSM_HOT_RESET = 39,
	LTSSM_RECOVERY_EQUALIZATION_PHASE0 = 40,
	LTSSM_RECOVERY_EQUALIZATION_PHASE1 = 41,
	LTSSM_RECOVERY_EQUALIZATION_PHASE2 = 42,
	LTSSM_RECOVERY_EQUALIZATION_PHASE3 = 43,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	LWT_BPF_PROG_UNSPEC = 0,
	LWT_BPF_PROG_FD = 1,
	LWT_BPF_PROG_NAME = 2,
	__LWT_BPF_PROG_MAX = 3,
};

enum {
	LWT_BPF_UNSPEC = 0,
	LWT_BPF_IN = 1,
	LWT_BPF_OUT = 2,
	LWT_BPF_XMIT = 3,
	LWT_BPF_XMIT_HEADROOM = 4,
	__LWT_BPF_MAX = 5,
};

enum {
	MATCH_MTR = 0,
	MATCH_MEQ = 1,
	MATCH_MLE = 2,
	MATCH_MLT = 3,
	MATCH_MGE = 4,
	MATCH_MGT = 5,
};

enum {
	MAX77620_IRQ_TOP_GLBL = 0,
	MAX77620_IRQ_TOP_SD = 1,
	MAX77620_IRQ_TOP_LDO = 2,
	MAX77620_IRQ_TOP_GPIO = 3,
	MAX77620_IRQ_TOP_RTC = 4,
	MAX77620_IRQ_TOP_32K = 5,
	MAX77620_IRQ_TOP_ONOFF = 6,
	MAX77620_IRQ_LBT_MBATLOW = 7,
	MAX77620_IRQ_LBT_TJALRM1 = 8,
	MAX77620_IRQ_LBT_TJALRM2 = 9,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MCT_INT_SPI = 0,
	MCT_INT_PPI = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_MDB_EATTR_UNSPEC = 0,
	MDBA_MDB_EATTR_TIMER = 1,
	MDBA_MDB_EATTR_SRC_LIST = 2,
	MDBA_MDB_EATTR_GROUP_MODE = 3,
	MDBA_MDB_EATTR_SOURCE = 4,
	MDBA_MDB_EATTR_RTPROT = 5,
	MDBA_MDB_EATTR_DST = 6,
	MDBA_MDB_EATTR_DST_PORT = 7,
	MDBA_MDB_EATTR_VNI = 8,
	MDBA_MDB_EATTR_IFINDEX = 9,
	MDBA_MDB_EATTR_SRC_VNI = 10,
	__MDBA_MDB_EATTR_MAX = 11,
};

enum {
	MDBA_MDB_ENTRY_UNSPEC = 0,
	MDBA_MDB_ENTRY_INFO = 1,
	__MDBA_MDB_ENTRY_MAX = 2,
};

enum {
	MDBA_MDB_SRCATTR_UNSPEC = 0,
	MDBA_MDB_SRCATTR_ADDRESS = 1,
	MDBA_MDB_SRCATTR_TIMER = 2,
	__MDBA_MDB_SRCATTR_MAX = 3,
};

enum {
	MDBA_MDB_SRCLIST_UNSPEC = 0,
	MDBA_MDB_SRCLIST_ENTRY = 1,
	__MDBA_MDB_SRCLIST_MAX = 2,
};

enum {
	MDBA_MDB_UNSPEC = 0,
	MDBA_MDB_ENTRY = 1,
	__MDBA_MDB_MAX = 2,
};

enum {
	MDBA_ROUTER_PATTR_UNSPEC = 0,
	MDBA_ROUTER_PATTR_TIMER = 1,
	MDBA_ROUTER_PATTR_TYPE = 2,
	MDBA_ROUTER_PATTR_INET_TIMER = 3,
	MDBA_ROUTER_PATTR_INET6_TIMER = 4,
	MDBA_ROUTER_PATTR_VID = 5,
	__MDBA_ROUTER_PATTR_MAX = 6,
};

enum {
	MDBA_ROUTER_UNSPEC = 0,
	MDBA_ROUTER_PORT = 1,
	__MDBA_ROUTER_MAX = 2,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MDBA_UNSPEC = 0,
	MDBA_MDB = 1,
	MDBA_ROUTER = 2,
	__MDBA_MAX = 3,
};

enum {
	MDBE_ATTR_UNSPEC = 0,
	MDBE_ATTR_SOURCE = 1,
	MDBE_ATTR_SRC_LIST = 2,
	MDBE_ATTR_GROUP_MODE = 3,
	MDBE_ATTR_RTPROT = 4,
	MDBE_ATTR_DST = 5,
	MDBE_ATTR_DST_PORT = 6,
	MDBE_ATTR_VNI = 7,
	MDBE_ATTR_IFINDEX = 8,
	MDBE_ATTR_SRC_VNI = 9,
	MDBE_ATTR_STATE_MASK = 10,
	__MDBE_ATTR_MAX = 11,
};

enum {
	MDBE_SRCATTR_UNSPEC = 0,
	MDBE_SRCATTR_ADDRESS = 1,
	__MDBE_SRCATTR_MAX = 2,
};

enum {
	MDBE_SRC_LIST_UNSPEC = 0,
	MDBE_SRC_LIST_ENTRY = 1,
	__MDBE_SRC_LIST_MAX = 2,
};

enum {
	MDB_RTR_TYPE_DISABLED = 0,
	MDB_RTR_TYPE_TEMP_QUERY = 1,
	MDB_RTR_TYPE_PERM = 2,
	MDB_RTR_TYPE_TEMP = 3,
};

enum {
	MD_RESYNC_NONE = 0,
	MD_RESYNC_YIELDED = 1,
	MD_RESYNC_DELAYED = 2,
	MD_RESYNC_ACTIVE = 3,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMCG_LRU_NOP = 0,
	MEMCG_LRU_HEAD = 1,
	MEMCG_LRU_TAIL = 2,
	MEMCG_LRU_OLD = 3,
	MEMCG_LRU_YOUNG = 4,
};

enum {
	MEMMAP_ON_MEMORY_DISABLE = 0,
	MEMMAP_ON_MEMORY_ENABLE = 1,
	MEMMAP_ON_MEMORY_FORCE = 2,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_NULL = 1,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	MFC_STATIC = 1,
	MFC_OFFLOAD = 2,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLO_PAUSE_NONE = 0,
	MLO_PAUSE_RX = 1,
	MLO_PAUSE_TX = 2,
	MLO_PAUSE_TXRX_MASK = 3,
	MLO_PAUSE_AN = 4,
	MLO_AN_PHY = 0,
	MLO_AN_FIXED = 1,
	MLO_AN_INBAND = 2,
	PHYLINK_PCS_NEG_NONE = 0,
	PHYLINK_PCS_NEG_ENABLED = 16,
	PHYLINK_PCS_NEG_OUTBAND = 32,
	PHYLINK_PCS_NEG_INBAND = 64,
	PHYLINK_PCS_NEG_INBAND_DISABLED = 64,
	PHYLINK_PCS_NEG_INBAND_ENABLED = 80,
	MAC_SYM_PAUSE = 1,
	MAC_ASYM_PAUSE = 2,
	MAC_10HD = 4,
	MAC_10FD = 8,
	MAC_10 = 12,
	MAC_100HD = 16,
	MAC_100FD = 32,
	MAC_100 = 48,
	MAC_1000HD = 64,
	MAC_1000FD = 128,
	MAC_1000 = 192,
	MAC_2500FD = 256,
	MAC_5000FD = 512,
	MAC_10000FD = 1024,
	MAC_20000FD = 2048,
	MAC_25000FD = 4096,
	MAC_40000FD = 8192,
	MAC_50000FD = 16384,
	MAC_56000FD = 32768,
	MAC_100000FD = 65536,
	MAC_200000FD = 131072,
	MAC_400000FD = 262144,
};

enum {
	MMOP_OFFLINE = 0,
	MMOP_ONLINE = 1,
	MMOP_ONLINE_KERNEL = 2,
	MMOP_ONLINE_MOVABLE = 3,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MM_LEAF_TOTAL = 0,
	MM_LEAF_YOUNG = 1,
	MM_NONLEAF_FOUND = 2,
	MM_NONLEAF_ADDED = 3,
	NR_MM_STATS = 4,
};

enum {
	MODE_NONE = 0,
	MODE_ROUND_ROBIN = 1,
	MODE_PER_CPU = 2,
	MODE_MAX = 3,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPOL_DEFAULT = 0,
	MPOL_PREFERRED = 1,
	MPOL_BIND = 2,
	MPOL_INTERLEAVE = 3,
	MPOL_LOCAL = 4,
	MPOL_PREFERRED_MANY = 5,
	MPOL_WEIGHTED_INTERLEAVE = 6,
	MPOL_MAX = 7,
};

enum {
	MPTCP_CMSG_TS = 1,
	MPTCP_CMSG_INQ = 2,
};

enum {
	MPTCP_PM_ADDR_ATTR_UNSPEC = 0,
	MPTCP_PM_ADDR_ATTR_FAMILY = 1,
	MPTCP_PM_ADDR_ATTR_ID = 2,
	MPTCP_PM_ADDR_ATTR_ADDR4 = 3,
	MPTCP_PM_ADDR_ATTR_ADDR6 = 4,
	MPTCP_PM_ADDR_ATTR_PORT = 5,
	MPTCP_PM_ADDR_ATTR_FLAGS = 6,
	MPTCP_PM_ADDR_ATTR_IF_IDX = 7,
	__MPTCP_PM_ADDR_ATTR_MAX = 8,
};

enum {
	MPTCP_PM_ATTR_UNSPEC = 0,
	MPTCP_PM_ATTR_ADDR = 1,
	MPTCP_PM_ATTR_RCV_ADD_ADDRS = 2,
	MPTCP_PM_ATTR_SUBFLOWS = 3,
	MPTCP_PM_ATTR_TOKEN = 4,
	MPTCP_PM_ATTR_LOC_ID = 5,
	MPTCP_PM_ATTR_ADDR_REMOTE = 6,
	__MPTCP_ATTR_AFTER_LAST = 7,
};

enum {
	MPTCP_PM_CMD_UNSPEC = 0,
	MPTCP_PM_CMD_ADD_ADDR = 1,
	MPTCP_PM_CMD_DEL_ADDR = 2,
	MPTCP_PM_CMD_GET_ADDR = 3,
	MPTCP_PM_CMD_FLUSH_ADDRS = 4,
	MPTCP_PM_CMD_SET_LIMITS = 5,
	MPTCP_PM_CMD_GET_LIMITS = 6,
	MPTCP_PM_CMD_SET_FLAGS = 7,
	MPTCP_PM_CMD_ANNOUNCE = 8,
	MPTCP_PM_CMD_REMOVE = 9,
	MPTCP_PM_CMD_SUBFLOW_CREATE = 10,
	MPTCP_PM_CMD_SUBFLOW_DESTROY = 11,
	__MPTCP_PM_CMD_AFTER_LAST = 12,
};

enum {
	MPTCP_PM_ENDPOINT_ADDR = 1,
	__MPTCP_PM_ENDPOINT_MAX = 2,
};

enum {
	MPTCP_SUBFLOW_ATTR_UNSPEC = 0,
	MPTCP_SUBFLOW_ATTR_TOKEN_REM = 1,
	MPTCP_SUBFLOW_ATTR_TOKEN_LOC = 2,
	MPTCP_SUBFLOW_ATTR_RELWRITE_SEQ = 3,
	MPTCP_SUBFLOW_ATTR_MAP_SEQ = 4,
	MPTCP_SUBFLOW_ATTR_MAP_SFSEQ = 5,
	MPTCP_SUBFLOW_ATTR_SSN_OFFSET = 6,
	MPTCP_SUBFLOW_ATTR_MAP_DATALEN = 7,
	MPTCP_SUBFLOW_ATTR_FLAGS = 8,
	MPTCP_SUBFLOW_ATTR_ID_REM = 9,
	MPTCP_SUBFLOW_ATTR_ID_LOC = 10,
	MPTCP_SUBFLOW_ATTR_PAD = 11,
	__MPTCP_SUBFLOW_ATTR_MAX = 12,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
};

enum {
	MSPI_DONE = 1,
	BSPI_DONE = 2,
	BSPI_ERR = 4,
	MSPI_BSPI_DONE = 7,
};

enum {
	MTK_UART_FC_NONE = 0,
	MTK_UART_FC_SW = 1,
	MTK_UART_FC_HW = 2,
};

enum {
	MTTG_TRAV_INIT = 0,
	MTTG_TRAV_NFP_UNSPEC = 1,
	MTTG_TRAV_NFP_SPEC = 2,
	MTTG_TRAV_DONE = 3,
};

enum {
	M_I17 = 0,
	M_I20 = 1,
	M_I20_SR = 2,
	M_I24 = 3,
	M_I24_8_1 = 4,
	M_I24_10_1 = 5,
	M_I27_11_1 = 6,
	M_MINI = 7,
	M_MINI_3_1 = 8,
	M_MINI_4_1 = 9,
	M_MB = 10,
	M_MB_2 = 11,
	M_MB_3 = 12,
	M_MB_5_1 = 13,
	M_MB_6_1 = 14,
	M_MB_7_1 = 15,
	M_MB_SR = 16,
	M_MBA = 17,
	M_MBA_3 = 18,
	M_MBP = 19,
	M_MBP_2 = 20,
	M_MBP_2_2 = 21,
	M_MBP_SR = 22,
	M_MBP_4 = 23,
	M_MBP_5_1 = 24,
	M_MBP_5_2 = 25,
	M_MBP_5_3 = 26,
	M_MBP_6_1 = 27,
	M_MBP_6_2 = 28,
	M_MBP_7_1 = 29,
	M_MBP_8_2 = 30,
	M_UNKNOWN = 31,
};

enum {
	NAMESZ = 12,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDD_UNARMED = 1,
	NDD_LOCKED = 2,
	NDD_SECURITY_OVERWRITE = 3,
	NDD_WORK_PENDING = 4,
	NDD_LABELING = 6,
	NDD_INCOHERENT = 7,
	NDD_REGISTER_SYNC = 8,
	ND_IOCTL_MAX_BUFLEN = 4194304,
	ND_CMD_MAX_ELEM = 5,
	ND_CMD_MAX_ENVELOPE = 256,
	ND_MAX_MAPPINGS = 32,
	ND_REGION_PAGEMAP = 0,
	ND_REGION_PERSIST_CACHE = 1,
	ND_REGION_PERSIST_MEMCTRL = 2,
	ND_REGION_ASYNC = 3,
	ND_REGION_CXL = 4,
	DPA_RESOURCE_ADJUSTED = 1,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NDUSEROPT_UNSPEC = 0,
	NDUSEROPT_SRCADDR = 1,
	__NDUSEROPT_MAX = 2,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	__NETDEV_A_NAPI_MAX = 8,
	NETDEV_A_NAPI_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	__NETDEV_A_PAGE_POOL_MAX = 8,
	NETDEV_A_PAGE_POOL_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	__NETDEV_A_QUEUE_MAX = 6,
	NETDEV_A_QUEUE_MAX = 5,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	__NETDEV_CMD_MAX = 15,
	NETDEV_CMD_MAX = 14,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_LAST = 34,
	NETIF_F_FCOE_CRC_BIT = 35,
	NETIF_F_SCTP_CRC_BIT = 36,
	__UNUSED_NETIF_F_37 = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_DIAG_MEMINFO = 0,
	NETLINK_DIAG_GROUPS = 1,
	NETLINK_DIAG_RX_RING = 2,
	NETLINK_DIAG_TX_RING = 3,
	NETLINK_DIAG_FLAGS = 4,
	__NETLINK_DIAG_MAX = 5,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_DM_ATTR_PORT_NETDEV_IFINDEX = 0,
	NET_DM_ATTR_PORT_NETDEV_NAME = 1,
	__NET_DM_ATTR_PORT_MAX = 2,
	NET_DM_ATTR_PORT_MAX = 1,
};

enum {
	NET_DM_ATTR_STATS_DROPPED = 0,
	__NET_DM_ATTR_STATS_MAX = 1,
	NET_DM_ATTR_STATS_MAX = 0,
};

enum {
	NET_DM_CMD_UNSPEC = 0,
	NET_DM_CMD_ALERT = 1,
	NET_DM_CMD_CONFIG = 2,
	NET_DM_CMD_START = 3,
	NET_DM_CMD_STOP = 4,
	NET_DM_CMD_PACKET_ALERT = 5,
	NET_DM_CMD_CONFIG_GET = 6,
	NET_DM_CMD_CONFIG_NEW = 7,
	NET_DM_CMD_STATS_GET = 8,
	NET_DM_CMD_STATS_NEW = 9,
	_NET_DM_CMD_MAX = 10,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NET_SHAPER_A_CAPS_IFINDEX = 1,
	NET_SHAPER_A_CAPS_SCOPE = 2,
	NET_SHAPER_A_CAPS_SUPPORT_METRIC_BPS = 3,
	NET_SHAPER_A_CAPS_SUPPORT_METRIC_PPS = 4,
	NET_SHAPER_A_CAPS_SUPPORT_NESTING = 5,
	NET_SHAPER_A_CAPS_SUPPORT_BW_MIN = 6,
	NET_SHAPER_A_CAPS_SUPPORT_BW_MAX = 7,
	NET_SHAPER_A_CAPS_SUPPORT_BURST = 8,
	NET_SHAPER_A_CAPS_SUPPORT_PRIORITY = 9,
	NET_SHAPER_A_CAPS_SUPPORT_WEIGHT = 10,
	__NET_SHAPER_A_CAPS_MAX = 11,
	NET_SHAPER_A_CAPS_MAX = 10,
};

enum {
	NET_SHAPER_A_HANDLE = 1,
	NET_SHAPER_A_METRIC = 2,
	NET_SHAPER_A_BW_MIN = 3,
	NET_SHAPER_A_BW_MAX = 4,
	NET_SHAPER_A_BURST = 5,
	NET_SHAPER_A_PRIORITY = 6,
	NET_SHAPER_A_WEIGHT = 7,
	NET_SHAPER_A_IFINDEX = 8,
	NET_SHAPER_A_PARENT = 9,
	NET_SHAPER_A_LEAVES = 10,
	__NET_SHAPER_A_MAX = 11,
	NET_SHAPER_A_MAX = 10,
};

enum {
	NET_SHAPER_A_HANDLE_SCOPE = 1,
	NET_SHAPER_A_HANDLE_ID = 2,
	__NET_SHAPER_A_HANDLE_MAX = 3,
	NET_SHAPER_A_HANDLE_MAX = 2,
};

enum {
	NET_SHAPER_CMD_GET = 1,
	NET_SHAPER_CMD_SET = 2,
	NET_SHAPER_CMD_DELETE = 3,
	NET_SHAPER_CMD_GROUP = 4,
	NET_SHAPER_CMD_CAP_GET = 5,
	__NET_SHAPER_CMD_MAX = 6,
	NET_SHAPER_CMD_MAX = 5,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFEA_UNSPEC = 0,
	NFEA_ACTIVITY_NOTIFY = 1,
	NFEA_DONT_REFRESH = 2,
	__NFEA_MAX = 3,
};

enum {
	NFNL_BATCH_FAILURE = 1,
	NFNL_BATCH_DONE = 2,
	NFNL_BATCH_REPLAY = 4,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFT_INNER_EXPR_PAYLOAD = 0,
	NFT_INNER_EXPR_META = 1,
};

enum {
	NFT_PAYLOAD_CTX_INNER_TUN = 1,
	NFT_PAYLOAD_CTX_INNER_LL = 2,
	NFT_PAYLOAD_CTX_INNER_NH = 4,
	NFT_PAYLOAD_CTX_INNER_TH = 8,
};

enum {
	NFT_PKTINFO_L4PROTO = 1,
	NFT_PKTINFO_INNER = 2,
	NFT_PKTINFO_INNER_FULL = 4,
};

enum {
	NFT_VALIDATE_SKIP = 0,
	NFT_VALIDATE_NEED = 1,
	NFT_VALIDATE_DO = 2,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLBL_CALIPSO_A_UNSPEC = 0,
	NLBL_CALIPSO_A_DOI = 1,
	NLBL_CALIPSO_A_MTYPE = 2,
	__NLBL_CALIPSO_A_MAX = 3,
};

enum {
	NLBL_CALIPSO_C_UNSPEC = 0,
	NLBL_CALIPSO_C_ADD = 1,
	NLBL_CALIPSO_C_REMOVE = 2,
	NLBL_CALIPSO_C_LIST = 3,
	NLBL_CALIPSO_C_LISTALL = 4,
	__NLBL_CALIPSO_C_MAX = 5,
};

enum {
	NLBL_CIPSOV4_A_UNSPEC = 0,
	NLBL_CIPSOV4_A_DOI = 1,
	NLBL_CIPSOV4_A_MTYPE = 2,
	NLBL_CIPSOV4_A_TAG = 3,
	NLBL_CIPSOV4_A_TAGLST = 4,
	NLBL_CIPSOV4_A_MLSLVLLOC = 5,
	NLBL_CIPSOV4_A_MLSLVLREM = 6,
	NLBL_CIPSOV4_A_MLSLVL = 7,
	NLBL_CIPSOV4_A_MLSLVLLST = 8,
	NLBL_CIPSOV4_A_MLSCATLOC = 9,
	NLBL_CIPSOV4_A_MLSCATREM = 10,
	NLBL_CIPSOV4_A_MLSCAT = 11,
	NLBL_CIPSOV4_A_MLSCATLST = 12,
	__NLBL_CIPSOV4_A_MAX = 13,
};

enum {
	NLBL_CIPSOV4_C_UNSPEC = 0,
	NLBL_CIPSOV4_C_ADD = 1,
	NLBL_CIPSOV4_C_REMOVE = 2,
	NLBL_CIPSOV4_C_LIST = 3,
	NLBL_CIPSOV4_C_LISTALL = 4,
	__NLBL_CIPSOV4_C_MAX = 5,
};

enum {
	NLBL_MGMT_A_UNSPEC = 0,
	NLBL_MGMT_A_DOMAIN = 1,
	NLBL_MGMT_A_PROTOCOL = 2,
	NLBL_MGMT_A_VERSION = 3,
	NLBL_MGMT_A_CV4DOI = 4,
	NLBL_MGMT_A_IPV6ADDR = 5,
	NLBL_MGMT_A_IPV6MASK = 6,
	NLBL_MGMT_A_IPV4ADDR = 7,
	NLBL_MGMT_A_IPV4MASK = 8,
	NLBL_MGMT_A_ADDRSELECTOR = 9,
	NLBL_MGMT_A_SELECTORLIST = 10,
	NLBL_MGMT_A_FAMILY = 11,
	NLBL_MGMT_A_CLPDOI = 12,
	__NLBL_MGMT_A_MAX = 13,
};

enum {
	NLBL_MGMT_C_UNSPEC = 0,
	NLBL_MGMT_C_ADD = 1,
	NLBL_MGMT_C_REMOVE = 2,
	NLBL_MGMT_C_LISTALL = 3,
	NLBL_MGMT_C_ADDDEF = 4,
	NLBL_MGMT_C_REMOVEDEF = 5,
	NLBL_MGMT_C_LISTDEF = 6,
	NLBL_MGMT_C_PROTOCOLS = 7,
	NLBL_MGMT_C_VERSION = 8,
	__NLBL_MGMT_C_MAX = 9,
};

enum {
	NLBL_UNLABEL_A_UNSPEC = 0,
	NLBL_UNLABEL_A_ACPTFLG = 1,
	NLBL_UNLABEL_A_IPV6ADDR = 2,
	NLBL_UNLABEL_A_IPV6MASK = 3,
	NLBL_UNLABEL_A_IPV4ADDR = 4,
	NLBL_UNLABEL_A_IPV4MASK = 5,
	NLBL_UNLABEL_A_IFACE = 6,
	NLBL_UNLABEL_A_SECCTX = 7,
	__NLBL_UNLABEL_A_MAX = 8,
};

enum {
	NLBL_UNLABEL_C_UNSPEC = 0,
	NLBL_UNLABEL_C_ACCEPT = 1,
	NLBL_UNLABEL_C_LIST = 2,
	NLBL_UNLABEL_C_STATICADD = 3,
	NLBL_UNLABEL_C_STATICREMOVE = 4,
	NLBL_UNLABEL_C_STATICLIST = 5,
	NLBL_UNLABEL_C_STATICADDDEF = 6,
	NLBL_UNLABEL_C_STATICREMOVEDEF = 7,
	NLBL_UNLABEL_C_STATICLISTDEF = 8,
	__NLBL_UNLABEL_C_MAX = 9,
};

enum {
	NODE_ACCESS_CLASS_GENPORT_SINK_LOCAL = 2,
	NODE_ACCESS_CLASS_GENPORT_SINK_CPU = 3,
	NODE_ACCESS_CLASS_MAX = 4,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 16,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_AEN_BIT_NS_ATTR = 8,
	NVME_AEN_BIT_FW_ACT = 9,
	NVME_AEN_BIT_ANA_CHANGE = 11,
	NVME_AEN_BIT_DISC_CHANGE = 31,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	ONLINE_POLICY_CONTIG_ZONES = 0,
	ONLINE_POLICY_AUTO_MOVABLE = 1,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	OUTSIDE_GUEST_MODE = 0,
	IN_GUEST_MODE = 1,
	EXITING_GUEST_MODE = 2,
	READING_SHADOW_PAGE_TABLES = 3,
};

enum {
	OVERRIDE_NONE = 0,
	OVERRIDE_BASE = 1,
	OVERRIDE_STRIDE = 2,
	OVERRIDE_HEIGHT = 4,
	OVERRIDE_WIDTH = 8,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier = 34,
	Opt_nobarrier = 35,
	Opt_err = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_default = 0,
	Opt_ecryptfs = 1,
	Opt_enc32 = 2,
	Opt_error = 3,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid = 10,
};

enum {
	Opt_err___2 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_error___2 = -1,
	Opt_context = 0,
	Opt_defcontext = 1,
	Opt_fscontext = 2,
	Opt_rootcontext = 3,
	Opt_seclabel = 4,
};

enum {
	Opt_errors___2 = 0,
	Opt_explicit_open = 1,
};

enum {
	Opt_kmsg_bytes = 0,
	Opt_err___3 = 1,
};

enum {
	Opt_new = 0,
	Opt_load = 1,
	Opt_update = 2,
	Opt_err___4 = 3,
};

enum {
	Opt_uid___2 = 0,
	Opt_gid___2 = 1,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
	Opt_mode = 2,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode___2 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___5 = 0,
	Opt_gid___5 = 1,
	Opt_mode___3 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___5 = 6,
};

enum {
	PACKET_DIAG_INFO = 0,
	PACKET_DIAG_MCLIST = 1,
	PACKET_DIAG_RX_RING = 2,
	PACKET_DIAG_TX_RING = 3,
	PACKET_DIAG_FANOUT = 4,
	PACKET_DIAG_UID = 5,
	PACKET_DIAG_MEMINFO = 6,
	PACKET_DIAG_FILTER = 7,
	__PACKET_DIAG_MAX = 8,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PCI_BRIDGE_EMUL_NO_PREFMEM_FORWARD = 1,
	PCI_BRIDGE_EMUL_NO_IO_FORWARD = 2,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_IOV_RESOURCES = 7,
	PCI_IOV_RESOURCE_END = 12,
	PCI_BRIDGE_RESOURCES = 13,
	PCI_BRIDGE_RESOURCE_END = 16,
	PCI_NUM_RESOURCES = 17,
	DEVICE_COUNT_RESOURCE = 17,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PHYLINK_DISABLE_STOPPED = 0,
	PHYLINK_DISABLE_LINK = 1,
	PHYLINK_DISABLE_MAC_WOL = 2,
	PCS_STATE_DOWN = 0,
	PCS_STATE_STARTING = 1,
	PCS_STATE_STARTED = 2,
};

enum {
	PIIX_IOCFG = 84,
	ICH5_PMR = 144,
	ICH5_PCS = 146,
	PIIX_SIDPR_BAR = 5,
	PIIX_SIDPR_LEN = 16,
	PIIX_SIDPR_IDX = 0,
	PIIX_SIDPR_DATA = 4,
	PIIX_FLAG_CHECKINTR = 268435456,
	PIIX_FLAG_SIDPR = 536870912,
	PIIX_PATA_FLAGS = 1,
	PIIX_SATA_FLAGS = 268435458,
	PIIX_FLAG_PIO16 = 1073741824,
	PIIX_80C_PRI = 48,
	PIIX_80C_SEC = 192,
	P0 = 0,
	P1 = 1,
	P2 = 2,
	P3 = 3,
	IDE = -1,
	NA = -2,
	RV = -3,
	PIIX_AHCI_DEVICE = 6,
	PIIX_HOST_BROKEN_SUSPEND = 16777216,
};

enum {
	PIM_TYPE_HELLO = 0,
	PIM_TYPE_REGISTER = 1,
	PIM_TYPE_REGISTER_STOP = 2,
	PIM_TYPE_JOIN_PRUNE = 3,
	PIM_TYPE_BOOTSTRAP = 4,
	PIM_TYPE_ASSERT = 5,
	PIM_TYPE_GRAFT = 6,
	PIM_TYPE_GRAFT_ACK = 7,
	PIM_TYPE_CANDIDATE_RP_ADV = 8,
};

enum {
	PINCTRL_PIN_REG_MODE = 0,
	PINCTRL_PIN_REG_DIR = 1,
	PINCTRL_PIN_REG_DI = 2,
	PINCTRL_PIN_REG_DO = 3,
	PINCTRL_PIN_REG_SR = 4,
	PINCTRL_PIN_REG_SMT = 5,
	PINCTRL_PIN_REG_PD = 6,
	PINCTRL_PIN_REG_PU = 7,
	PINCTRL_PIN_REG_E4 = 8,
	PINCTRL_PIN_REG_E8 = 9,
	PINCTRL_PIN_REG_TDSEL = 10,
	PINCTRL_PIN_REG_RDSEL = 11,
	PINCTRL_PIN_REG_DRV = 12,
	PINCTRL_PIN_REG_PUPD = 13,
	PINCTRL_PIN_REG_R0 = 14,
	PINCTRL_PIN_REG_R1 = 15,
	PINCTRL_PIN_REG_IES = 16,
	PINCTRL_PIN_REG_PULLEN = 17,
	PINCTRL_PIN_REG_PULLSEL = 18,
	PINCTRL_PIN_REG_DRV_EN = 19,
	PINCTRL_PIN_REG_DRV_E0 = 20,
	PINCTRL_PIN_REG_DRV_E1 = 21,
	PINCTRL_PIN_REG_DRV_ADV = 22,
	PINCTRL_PIN_REG_RSEL = 23,
	PINCTRL_PIN_REG_MAX = 24,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	PLL_LOCK_DONE = 0,
	PLL_DIV_S = 1,
	PLL_MOD_EN = 2,
	PLL_SDM_EN = 3,
	PLL_REFIN = 4,
	PLL_IBIAS = 5,
	PLL_N = 6,
	PLL_NINT = 7,
	PLL_KINT = 8,
	PLL_PREDIV = 9,
	PLL_POSTDIV = 10,
	PLL_FACT_MAX = 11,
};

enum {
	POLICYDB_CAP_NETPEER = 0,
	POLICYDB_CAP_OPENPERM = 1,
	POLICYDB_CAP_EXTSOCKCLASS = 2,
	POLICYDB_CAP_ALWAYSNETWORK = 3,
	POLICYDB_CAP_CGROUPSECLABEL = 4,
	POLICYDB_CAP_NNP_NOSUID_TRANSITION = 5,
	POLICYDB_CAP_GENFS_SECLABEL_SYMLINKS = 6,
	POLICYDB_CAP_IOCTL_SKIP_CLOEXEC = 7,
	POLICYDB_CAP_USERSPACE_INITIAL_CONTEXT = 8,
	POLICYDB_CAP_NETLINK_XPERM = 9,
	__POLICYDB_CAP_MAX = 10,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 5,
	POWER_SUPPLY_HEALTH_COLD = 6,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 7,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 9,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 10,
	POWER_SUPPLY_HEALTH_WARM = 11,
	POWER_SUPPLY_HEALTH_COOL = 12,
	POWER_SUPPLY_HEALTH_HOT = 13,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 14,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREFIX_UNSPEC = 0,
	PREFIX_ADDRESS = 1,
	PREFIX_CACHEINFO = 2,
	__PREFIX_MAX = 3,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_MAX = 13,
};

enum {
	QUOTA_NL_A_UNSPEC = 0,
	QUOTA_NL_A_QTYPE = 1,
	QUOTA_NL_A_EXCESS_ID = 2,
	QUOTA_NL_A_WARNING = 3,
	QUOTA_NL_A_DEV_MAJOR = 4,
	QUOTA_NL_A_DEV_MINOR = 5,
	QUOTA_NL_A_CAUSED_ID = 6,
	QUOTA_NL_A_PAD = 7,
	__QUOTA_NL_A_MAX = 8,
};

enum {
	QUOTA_NL_C_UNSPEC = 0,
	QUOTA_NL_C_WARNING = 1,
	__QUOTA_NL_C_MAX = 2,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RB_ADD_STAMP_NONE = 0,
	RB_ADD_STAMP_EXTEND = 2,
	RB_ADD_STAMP_ABSOLUTE = 4,
	RB_ADD_STAMP_FORCE = 8,
};

enum {
	RB_CTX_TRANSITION = 0,
	RB_CTX_NMI = 1,
	RB_CTX_IRQ = 2,
	RB_CTX_SOFTIRQ = 3,
	RB_CTX_NORMAL = 4,
	RB_CTX_MAX = 5,
};

enum {
	RB_LEN_TIME_EXTEND = 8,
	RB_LEN_TIME_STAMP = 8,
};

enum {
	RCAR_PCI_ACCESS_READ = 0,
	RCAR_PCI_ACCESS_WRITE = 1,
};

enum {
	RCD = 0,
	RCH_DP = 1,
	DEVICE = 2,
	LD = 3,
	FMLD = 4,
	RP = 5,
	DSP = 6,
	USP = 7,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CON_MOD_TX = 0,
	REG_CON_MOD_REGISTER_TX = 1,
	REG_CON_MOD_RX = 2,
	REG_CON_MOD_REGISTER_RX = 3,
};

enum {
	REG_DR = 0,
	REG_ST_DMAWM = 1,
	REG_ST_TIMEOUT = 2,
	REG_FR = 3,
	REG_LCRH_RX = 4,
	REG_LCRH_TX = 5,
	REG_IBRD = 6,
	REG_FBRD = 7,
	REG_CR = 8,
	REG_IFLS = 9,
	REG_IMSC = 10,
	REG_RIS = 11,
	REG_MIS = 12,
	REG_ICR = 13,
	REG_DMACR = 14,
	REG_ST_XFCR = 15,
	REG_ST_XON1 = 16,
	REG_ST_XON2 = 17,
	REG_ST_XOFF1 = 18,
	REG_ST_XOFF2 = 19,
	REG_ST_ITCR = 20,
	REG_ST_ITIP = 21,
	REG_ST_ABCR = 22,
	REG_ST_ABIMSC = 23,
	REG_ARRAY_SIZE = 24,
};

enum {
	REMOVE_WAIT_SHORTTERM = 1,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 1250,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 268435456ULL,
	REQ_F_ISREG = 536870912ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_APOLL_MULTISHOT = 67108864ULL,
	REQ_F_CLEAR_POLLIN = 134217728ULL,
	REQ_F_POLL_NO_LAZY = 1073741824ULL,
	REQ_F_CAN_POLL = 2147483648ULL,
	REQ_F_BL_EMPTY = 4294967296ULL,
	REQ_F_BL_NO_RECYCLE = 8589934592ULL,
	REQ_F_BUFFERS_COMMIT = 17179869184ULL,
	REQ_F_BUF_NODE = 34359738368ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_APOLL_MULTISHOT_BIT = 26,
	REQ_F_CLEAR_POLLIN_BIT = 27,
	REQ_F_SUPPORT_NOWAIT_BIT = 28,
	REQ_F_ISREG_BIT = 29,
	REQ_F_POLL_NO_LAZY_BIT = 30,
	REQ_F_CAN_POLL_BIT = 31,
	REQ_F_BL_EMPTY_BIT = 32,
	REQ_F_BL_NO_RECYCLE_BIT = 33,
	REQ_F_BUFFERS_COMMIT_BIT = 34,
	REQ_F_BUF_NODE_BIT = 35,
	__REQ_F_LAST_BIT = 36,
};

enum {
	RES_USAGE = 0,
	RES_RSVD_USAGE = 1,
	RES_LIMIT = 2,
	RES_RSVD_LIMIT = 3,
	RES_MAX_USAGE = 4,
	RES_RSVD_MAX_USAGE = 5,
	RES_FAILCNT = 6,
	RES_RSVD_FAILCNT = 7,
};

enum {
	RES_USAGE___2 = 0,
	RES_LIMIT___2 = 1,
	RES_MAX_USAGE___2 = 2,
	RES_FAILCNT___2 = 3,
	RES_SOFT_LIMIT = 4,
};

enum {
	RK8600_CHIP_ID_08 = 8,
};

enum {
	RK8602_CHIP_ID_10 = 10,
};

enum {
	RNG_OUTPUT_0_REG = 0,
	RNG_OUTPUT_1_REG = 1,
	RNG_OUTPUT_2_REG = 2,
	RNG_OUTPUT_3_REG = 3,
	RNG_STATUS_REG = 4,
	RNG_INTMASK_REG = 5,
	RNG_INTACK_REG = 6,
	RNG_CONTROL_REG = 7,
	RNG_CONFIG_REG = 8,
	RNG_ALARMCNT_REG = 9,
	RNG_FROENABLE_REG = 10,
	RNG_FRODETUNE_REG = 11,
	RNG_ALARMMASK_REG = 12,
	RNG_ALARMSTOP_REG = 13,
	RNG_REV_REG = 14,
	RNG_SYSCONFIG_REG = 15,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_GETMULTICAST = 58,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RWB_DEF_DEPTH = 16,
	RWB_WINDOW_NSEC = 100000000,
	RWB_MIN_WRITE_SAMPLES = 3,
	RWB_UNKNOWN_BUMP = 5,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
};

enum {
	SCSI_DH_OK = 0,
	SCSI_DH_DEV_FAILED = 1,
	SCSI_DH_DEV_TEMP_BUSY = 2,
	SCSI_DH_DEV_UNSUPP = 3,
	SCSI_DH_DEVICE_MAX = 4,
	SCSI_DH_NOTCONN = 5,
	SCSI_DH_CONN_FAILURE = 6,
	SCSI_DH_TRANSPORT_MAX = 7,
	SCSI_DH_IO = 8,
	SCSI_DH_INVALID_IO = 9,
	SCSI_DH_RETRY = 10,
	SCSI_DH_IMM_RETRY = 11,
	SCSI_DH_TIMED_OUT = 12,
	SCSI_DH_RES_TEMP_UNAVAIL = 13,
	SCSI_DH_DEV_OFFLINED = 14,
	SCSI_DH_NOMEM = 15,
	SCSI_DH_NOSYS = 16,
	SCSI_DH_DRIVER_MAX = 17,
};

enum {
	SCTP_AUTH_HMAC_ID_RESERVED_0 = 0,
	SCTP_AUTH_HMAC_ID_SHA1 = 1,
	SCTP_AUTH_HMAC_ID_RESERVED_2 = 2,
	SCTP_AUTH_HMAC_ID_SHA256 = 3,
	__SCTP_AUTH_HMAC_MAX = 4,
};

enum {
	SCTP_MAX_DUP_TSNS = 16,
};

enum {
	SCTP_MAX_STREAM = 65535,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SECTION_MARKED_PRESENT_BIT = 0,
	SECTION_HAS_MEM_MAP_BIT = 1,
	SECTION_IS_ONLINE_BIT = 2,
	SECTION_IS_EARLY_BIT = 3,
	SECTION_TAINT_ZONE_DEVICE_BIT = 4,
	SECTION_MAP_LAST_BIT = 5,
};

enum {
	SEG6_ATTR_UNSPEC = 0,
	SEG6_ATTR_DST = 1,
	SEG6_ATTR_DSTLEN = 2,
	SEG6_ATTR_HMACKEYID = 3,
	SEG6_ATTR_SECRET = 4,
	SEG6_ATTR_SECRETLEN = 5,
	SEG6_ATTR_ALGID = 6,
	SEG6_ATTR_HMACINFO = 7,
	__SEG6_ATTR_MAX = 8,
};

enum {
	SEG6_CMD_UNSPEC = 0,
	SEG6_CMD_SETHMAC = 1,
	SEG6_CMD_DUMPHMAC = 2,
	SEG6_CMD_SET_TUNSRC = 3,
	SEG6_CMD_GET_TUNSRC = 4,
	__SEG6_CMD_MAX = 5,
};

enum {
	SEG6_IPTUNNEL_UNSPEC = 0,
	SEG6_IPTUNNEL_SRH = 1,
	__SEG6_IPTUNNEL_MAX = 2,
};

enum {
	SEG6_IPTUN_MODE_INLINE = 0,
	SEG6_IPTUN_MODE_ENCAP = 1,
	SEG6_IPTUN_MODE_L2ENCAP = 2,
	SEG6_IPTUN_MODE_ENCAP_RED = 3,
	SEG6_IPTUN_MODE_L2ENCAP_RED = 4,
};

enum {
	SEG6_LOCAL_ACTION_UNSPEC = 0,
	SEG6_LOCAL_ACTION_END = 1,
	SEG6_LOCAL_ACTION_END_X = 2,
	SEG6_LOCAL_ACTION_END_T = 3,
	SEG6_LOCAL_ACTION_END_DX2 = 4,
	SEG6_LOCAL_ACTION_END_DX6 = 5,
	SEG6_LOCAL_ACTION_END_DX4 = 6,
	SEG6_LOCAL_ACTION_END_DT6 = 7,
	SEG6_LOCAL_ACTION_END_DT4 = 8,
	SEG6_LOCAL_ACTION_END_B6 = 9,
	SEG6_LOCAL_ACTION_END_B6_ENCAP = 10,
	SEG6_LOCAL_ACTION_END_BM = 11,
	SEG6_LOCAL_ACTION_END_S = 12,
	SEG6_LOCAL_ACTION_END_AS = 13,
	SEG6_LOCAL_ACTION_END_AM = 14,
	SEG6_LOCAL_ACTION_END_BPF = 15,
	SEG6_LOCAL_ACTION_END_DT46 = 16,
	__SEG6_LOCAL_ACTION_MAX = 17,
};

enum {
	SEG6_LOCAL_BPF_PROG_UNSPEC = 0,
	SEG6_LOCAL_BPF_PROG = 1,
	SEG6_LOCAL_BPF_PROG_NAME = 2,
	__SEG6_LOCAL_BPF_PROG_MAX = 3,
};

enum {
	SEG6_LOCAL_CNT_UNSPEC = 0,
	SEG6_LOCAL_CNT_PAD = 1,
	SEG6_LOCAL_CNT_PACKETS = 2,
	SEG6_LOCAL_CNT_BYTES = 3,
	SEG6_LOCAL_CNT_ERRORS = 4,
	__SEG6_LOCAL_CNT_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_OP_UNSPEC = 0,
	SEG6_LOCAL_FLV_OP_PSP = 1,
	SEG6_LOCAL_FLV_OP_USP = 2,
	SEG6_LOCAL_FLV_OP_USD = 3,
	SEG6_LOCAL_FLV_OP_NEXT_CSID = 4,
	__SEG6_LOCAL_FLV_OP_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_UNSPEC = 0,
	SEG6_LOCAL_FLV_OPERATION = 1,
	SEG6_LOCAL_FLV_LCBLOCK_BITS = 2,
	SEG6_LOCAL_FLV_LCNODE_FN_BITS = 3,
	__SEG6_LOCAL_FLV_MAX = 4,
};

enum {
	SEG6_LOCAL_UNSPEC = 0,
	SEG6_LOCAL_ACTION = 1,
	SEG6_LOCAL_SRH = 2,
	SEG6_LOCAL_TABLE = 3,
	SEG6_LOCAL_NH4 = 4,
	SEG6_LOCAL_NH6 = 5,
	SEG6_LOCAL_IIF = 6,
	SEG6_LOCAL_OIF = 7,
	SEG6_LOCAL_BPF = 8,
	SEG6_LOCAL_VRFTABLE = 9,
	SEG6_LOCAL_COUNTERS = 10,
	SEG6_LOCAL_FLAVORS = 11,
	__SEG6_LOCAL_MAX = 12,
};

enum {
	SELNL_MSG_SETENFORCE = 16,
	SELNL_MSG_POLICYLOAD = 17,
	SELNL_MSG_MAX = 18,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SILERGY_SYR82X = 8,
	SILERGY_SYR83X = 9,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_HW_TSTAMP_USE_CYCLES = 8,
	SKBTX_WIFI_STATUS = 16,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
};

enum {
	SKCIPHER_WALK_PHYS = 1,
	SKCIPHER_WALK_SLOW = 2,
	SKCIPHER_WALK_COPY = 4,
	SKCIPHER_WALK_DIFF = 8,
	SKCIPHER_WALK_SLEEP = 16,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SM_EFUSE_READ = 0,
	SM_EFUSE_WRITE = 1,
	SM_EFUSE_USER_MAX = 2,
	SM_GET_CHIP_ID = 3,
	SM_A1_PWRC_SET = 4,
	SM_A1_PWRC_GET = 5,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_LAST = 131072,
	SOF_TIMESTAMPING_MASK = 262143,
};

enum {
	SUNXI_SRC_TYPE_LEVEL_LOW = 0,
	SUNXI_SRC_TYPE_EDGE_FALLING = 1,
	SUNXI_SRC_TYPE_LEVEL_HIGH = 2,
	SUNXI_SRC_TYPE_EDGE_RISING = 3,
};

enum {
	SUN_WHOLE_DISK = 5,
	LINUX_RAID_PARTITION___2 = 253,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
	SWP_SCANNING = 16384,
};

enum {
	SYNAPTICS_INTERTOUCH_NOT_SET = -1,
	SYNAPTICS_INTERTOUCH_OFF = 0,
	SYNAPTICS_INTERTOUCH_ON = 1,
};

enum {
	SYNTH_ERR_BAD_NAME = 0,
	SYNTH_ERR_INVALID_CMD = 1,
	SYNTH_ERR_INVALID_DYN_CMD = 2,
	SYNTH_ERR_EVENT_EXISTS = 3,
	SYNTH_ERR_TOO_MANY_FIELDS = 4,
	SYNTH_ERR_INCOMPLETE_TYPE = 5,
	SYNTH_ERR_INVALID_TYPE = 6,
	SYNTH_ERR_INVALID_FIELD = 7,
	SYNTH_ERR_INVALID_ARRAY_SPEC = 8,
};

enum {
	SYSTAB = 0,
	MMBASE = 1,
	MMSIZE = 2,
	DCSIZE = 3,
	DCVERS = 4,
	PARAMCOUNT = 5,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_CGROUP_UNSPEC = 0,
	TCA_CGROUP_ACT = 1,
	TCA_CGROUP_POLICE = 2,
	TCA_CGROUP_EMATCHES = 3,
	__TCA_CGROUP_MAX = 4,
};

enum {
	TCA_EMATCH_TREE_UNSPEC = 0,
	TCA_EMATCH_TREE_HDR = 1,
	TCA_EMATCH_TREE_LIST = 2,
	__TCA_EMATCH_TREE_MAX = 3,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_FQ_CODEL_UNSPEC = 0,
	TCA_FQ_CODEL_TARGET = 1,
	TCA_FQ_CODEL_LIMIT = 2,
	TCA_FQ_CODEL_INTERVAL = 3,
	TCA_FQ_CODEL_ECN = 4,
	TCA_FQ_CODEL_FLOWS = 5,
	TCA_FQ_CODEL_QUANTUM = 6,
	TCA_FQ_CODEL_CE_THRESHOLD = 7,
	TCA_FQ_CODEL_DROP_BATCH_SIZE = 8,
	TCA_FQ_CODEL_MEMORY_LIMIT = 9,
	TCA_FQ_CODEL_CE_THRESHOLD_SELECTOR = 10,
	TCA_FQ_CODEL_CE_THRESHOLD_MASK = 11,
	__TCA_FQ_CODEL_MAX = 12,
};

enum {
	TCA_FQ_CODEL_XSTATS_QDISC = 0,
	TCA_FQ_CODEL_XSTATS_CLASS = 1,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCG_SECP_00 = 0,
	TCG_SECP_01 = 1,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 15,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCS4525_CHIP_ID_12 = 12,
};

enum {
	TCS4526_CHIP_ID_00 = 0,
};

enum {
	TEST_ALIGNMENT = 16,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	THRESHOLD_INDEX_0 = 0,
	THRESHOLD_INDEX_1 = 1,
	THRESHOLD_INDEX_COUNT = 2,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TOO_MANY_CLOSE = -1,
	TOO_MANY_OPEN = -2,
	MISSING_QUOTE = -3,
};

enum {
	TP_ERR_FILE_NOT_FOUND = 0,
	TP_ERR_NO_REGULAR_FILE = 1,
	TP_ERR_BAD_REFCNT = 2,
	TP_ERR_REFCNT_OPEN_BRACE = 3,
	TP_ERR_BAD_REFCNT_SUFFIX = 4,
	TP_ERR_BAD_UPROBE_OFFS = 5,
	TP_ERR_BAD_MAXACT_TYPE = 6,
	TP_ERR_BAD_MAXACT = 7,
	TP_ERR_MAXACT_TOO_BIG = 8,
	TP_ERR_BAD_PROBE_ADDR = 9,
	TP_ERR_NON_UNIQ_SYMBOL = 10,
	TP_ERR_BAD_RETPROBE = 11,
	TP_ERR_NO_TRACEPOINT = 12,
	TP_ERR_BAD_ADDR_SUFFIX = 13,
	TP_ERR_NO_GROUP_NAME = 14,
	TP_ERR_GROUP_TOO_LONG = 15,
	TP_ERR_BAD_GROUP_NAME = 16,
	TP_ERR_NO_EVENT_NAME = 17,
	TP_ERR_EVENT_TOO_LONG = 18,
	TP_ERR_BAD_EVENT_NAME = 19,
	TP_ERR_EVENT_EXIST = 20,
	TP_ERR_RETVAL_ON_PROBE = 21,
	TP_ERR_NO_RETVAL = 22,
	TP_ERR_BAD_STACK_NUM = 23,
	TP_ERR_BAD_ARG_NUM = 24,
	TP_ERR_BAD_VAR = 25,
	TP_ERR_BAD_REG_NAME = 26,
	TP_ERR_BAD_MEM_ADDR = 27,
	TP_ERR_BAD_IMM = 28,
	TP_ERR_IMMSTR_NO_CLOSE = 29,
	TP_ERR_FILE_ON_KPROBE = 30,
	TP_ERR_BAD_FILE_OFFS = 31,
	TP_ERR_SYM_ON_UPROBE = 32,
	TP_ERR_TOO_MANY_OPS = 33,
	TP_ERR_DEREF_NEED_BRACE = 34,
	TP_ERR_BAD_DEREF_OFFS = 35,
	TP_ERR_DEREF_OPEN_BRACE = 36,
	TP_ERR_COMM_CANT_DEREF = 37,
	TP_ERR_BAD_FETCH_ARG = 38,
	TP_ERR_ARRAY_NO_CLOSE = 39,
	TP_ERR_BAD_ARRAY_SUFFIX = 40,
	TP_ERR_BAD_ARRAY_NUM = 41,
	TP_ERR_ARRAY_TOO_BIG = 42,
	TP_ERR_BAD_TYPE = 43,
	TP_ERR_BAD_STRING = 44,
	TP_ERR_BAD_SYMSTRING = 45,
	TP_ERR_BAD_BITFIELD = 46,
	TP_ERR_ARG_NAME_TOO_LONG = 47,
	TP_ERR_NO_ARG_NAME = 48,
	TP_ERR_BAD_ARG_NAME = 49,
	TP_ERR_USED_ARG_NAME = 50,
	TP_ERR_ARG_TOO_LONG = 51,
	TP_ERR_NO_ARG_BODY = 52,
	TP_ERR_BAD_INSN_BNDRY = 53,
	TP_ERR_FAIL_REG_PROBE = 54,
	TP_ERR_DIFF_PROBE_TYPE = 55,
	TP_ERR_DIFF_ARG_TYPE = 56,
	TP_ERR_SAME_PROBE = 57,
	TP_ERR_NO_EVENT_INFO = 58,
	TP_ERR_BAD_ATTACH_EVENT = 59,
	TP_ERR_BAD_ATTACH_ARG = 60,
	TP_ERR_NO_EP_FILTER = 61,
	TP_ERR_NOSUP_BTFARG = 62,
	TP_ERR_NO_BTFARG = 63,
	TP_ERR_NO_BTF_ENTRY = 64,
	TP_ERR_BAD_VAR_ARGS = 65,
	TP_ERR_NOFENTRY_ARGS = 66,
	TP_ERR_DOUBLE_ARGS = 67,
	TP_ERR_ARGS_2LONG = 68,
	TP_ERR_ARGIDX_2BIG = 69,
	TP_ERR_NO_PTR_STRCT = 70,
	TP_ERR_NOSUP_DAT_ARG = 71,
	TP_ERR_BAD_HYPHEN = 72,
	TP_ERR_NO_BTF_FIELD = 73,
	TP_ERR_BAD_BTF_TID = 74,
	TP_ERR_BAD_TYPE4STR = 75,
	TP_ERR_NEED_STRING_TYPE = 76,
};

enum {
	TRACEFS_EVENT_INODE = 2,
	TRACEFS_GID_PERM_SET = 4,
	TRACEFS_UID_PERM_SET = 8,
	TRACEFS_INSTANCE_INODE = 16,
};

enum {
	TRACE_ARRAY_FL_GLOBAL = 1,
	TRACE_ARRAY_FL_BOOT = 2,
};

enum {
	TRACE_CTX_NMI = 0,
	TRACE_CTX_IRQ = 1,
	TRACE_CTX_SOFTIRQ = 2,
	TRACE_CTX_NORMAL = 3,
	TRACE_CTX_TRANSITION = 4,
};

enum {
	TRACE_EVENT_FL_CAP_ANY = 1,
	TRACE_EVENT_FL_NO_SET_FILTER = 2,
	TRACE_EVENT_FL_IGNORE_ENABLE = 4,
	TRACE_EVENT_FL_TRACEPOINT = 8,
	TRACE_EVENT_FL_DYNAMIC = 16,
	TRACE_EVENT_FL_KPROBE = 32,
	TRACE_EVENT_FL_UPROBE = 64,
	TRACE_EVENT_FL_EPROBE = 128,
	TRACE_EVENT_FL_FPROBE = 256,
	TRACE_EVENT_FL_CUSTOM = 512,
};

enum {
	TRACE_EVENT_FL_CAP_ANY_BIT = 0,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 1,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 2,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 3,
	TRACE_EVENT_FL_DYNAMIC_BIT = 4,
	TRACE_EVENT_FL_KPROBE_BIT = 5,
	TRACE_EVENT_FL_UPROBE_BIT = 6,
	TRACE_EVENT_FL_EPROBE_BIT = 7,
	TRACE_EVENT_FL_FPROBE_BIT = 8,
	TRACE_EVENT_FL_CUSTOM_BIT = 9,
};

enum {
	TRACE_FTRACE_BIT = 0,
	TRACE_FTRACE_NMI_BIT = 1,
	TRACE_FTRACE_IRQ_BIT = 2,
	TRACE_FTRACE_SIRQ_BIT = 3,
	TRACE_FTRACE_TRANSITION_BIT = 4,
	TRACE_INTERNAL_BIT = 5,
	TRACE_INTERNAL_NMI_BIT = 6,
	TRACE_INTERNAL_IRQ_BIT = 7,
	TRACE_INTERNAL_SIRQ_BIT = 8,
	TRACE_INTERNAL_TRANSITION_BIT = 9,
	TRACE_BRANCH_BIT = 10,
	TRACE_IRQ_BIT = 11,
	TRACE_RECORD_RECURSION_BIT = 12,
};

enum {
	TRACE_FUNC_NO_OPTS = 0,
	TRACE_FUNC_OPT_STACK = 1,
	TRACE_FUNC_OPT_NO_REPEATS = 2,
	TRACE_FUNC_OPT_HIGHEST_BIT = 4,
};

enum {
	TRACE_GRAPH_FL = 1,
	TRACE_GRAPH_DEPTH_START_BIT = 2,
	TRACE_GRAPH_DEPTH_END_BIT = 3,
	TRACE_GRAPH_NOTRACE_BIT = 4,
};

enum {
	TRACE_NOP_OPT_ACCEPT = 1,
	TRACE_NOP_OPT_REFUSE = 2,
};

enum {
	TRACE_PIDS = 1,
	TRACE_NO_PIDS = 2,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	UARTDM_1P1 = 1,
	UARTDM_1P2 = 2,
	UARTDM_1P3 = 3,
	UARTDM_1P4 = 4,
};

enum {
	UART_IRQ_SUM = 0,
	UART_RX_IRQ = 0,
	UART_TX_IRQ = 1,
	UART_IRQ_COUNT = 2,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	UNIX_DIAG_NAME = 0,
	UNIX_DIAG_VFS = 1,
	UNIX_DIAG_PEER = 2,
	UNIX_DIAG_ICONS = 3,
	UNIX_DIAG_RQLEN = 4,
	UNIX_DIAG_MEMINFO = 5,
	UNIX_DIAG_SHUTDOWN = 6,
	UNIX_DIAG_UID = 7,
	__UNIX_DIAG_MAX = 8,
};

enum {
	USB_CTRL_SETUP_SCB1_EN_SELECTOR = 0,
	USB_CTRL_SETUP_SCB2_EN_SELECTOR = 1,
	USB_CTRL_SETUP_SS_EHCI64BIT_EN_SELECTOR = 2,
	USB_CTRL_SETUP_STRAP_IPP_SEL_SELECTOR = 3,
	USB_CTRL_SETUP_OC3_DISABLE_PORT0_SELECTOR = 4,
	USB_CTRL_SETUP_OC3_DISABLE_PORT1_SELECTOR = 5,
	USB_CTRL_SETUP_OC3_DISABLE_SELECTOR = 6,
	USB_CTRL_PLL_CTL_PLL_IDDQ_PWRDN_SELECTOR = 7,
	USB_CTRL_USB_PM_BDC_SOFT_RESETB_SELECTOR = 8,
	USB_CTRL_USB_PM_XHC_SOFT_RESETB_SELECTOR = 9,
	USB_CTRL_USB_PM_USB_PWRDN_SELECTOR = 10,
	USB_CTRL_USB30_CTL1_XHC_SOFT_RESETB_SELECTOR = 11,
	USB_CTRL_USB30_CTL1_USB3_IOC_SELECTOR = 12,
	USB_CTRL_USB30_CTL1_USB3_IPP_SELECTOR = 13,
	USB_CTRL_USB_DEVICE_CTL1_PORT_MODE_SELECTOR = 14,
	USB_CTRL_USB_PM_SOFT_RESET_SELECTOR = 15,
	USB_CTRL_SETUP_CC_DRD_MODE_ENABLE_SELECTOR = 16,
	USB_CTRL_SETUP_STRAP_CC_DRD_MODE_ENABLE_SEL_SELECTOR = 17,
	USB_CTRL_USB_PM_USB20_HC_RESETB_SELECTOR = 18,
	USB_CTRL_SETUP_ENDIAN_SELECTOR = 19,
	USB_CTRL_SELECTOR_COUNT = 20,
};

enum {
	VFIO_DEVICE_NUM_STATES = 8,
};

enum {
	VMGENID_SIZE = 16,
};

enum {
	V_ARMADA_7K = 1,
	V_ARMADA_8K_CPM = 2,
	V_ARMADA_8K_CPS = 4,
	V_CP115_STANDALONE = 8,
	V_ARMADA_7K_8K_CPM = 3,
	V_ARMADA_7K_8K_CPS = 5,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WBT_RWQ_BG = 0,
	WBT_RWQ_SWAP = 1,
	WBT_RWQ_DISCARD = 2,
	WBT_NUM_RWQ = 3,
};

enum {
	WBT_STATE_ON_DEFAULT = 1,
	WBT_STATE_ON_MANUAL = 2,
	WBT_STATE_OFF_DEFAULT = 3,
	WBT_STATE_OFF_MANUAL = 4,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_DEV_OFFLOAD_FLAG_ACQ = 1,
};

enum {
	XFRM_DEV_OFFLOAD_IN = 1,
	XFRM_DEV_OFFLOAD_OUT = 2,
	XFRM_DEV_OFFLOAD_FWD = 3,
};

enum {
	XFRM_DEV_OFFLOAD_UNSPECIFIED = 0,
	XFRM_DEV_OFFLOAD_CRYPTO = 1,
	XFRM_DEV_OFFLOAD_PACKET = 2,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MODE_FLAG_TUNNEL = 1,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_SHARE_ANY = 0,
	XFRM_SHARE_SESSION = 1,
	XFRM_SHARE_USER = 2,
	XFRM_SHARE_UNIQUE = 3,
};

enum {
	XFRM_STATE_VOID = 0,
	XFRM_STATE_ACQ = 1,
	XFRM_STATE_VALID = 2,
	XFRM_STATE_ERROR = 3,
	XFRM_STATE_EXPIRED = 4,
	XFRM_STATE_DEAD = 5,
};

enum {
	ZONELIST_FALLBACK = 0,
	ZONELIST_NOFALLBACK = 1,
	MAX_ZONELISTS = 2,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 0,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_MOVE_PCNTXT = 16384,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2096911,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 6,
	__SCHED_FEAT_DELAY_DEQUEUE = 7,
	__SCHED_FEAT_DELAY_ZERO = 8,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 9,
	__SCHED_FEAT_HRTICK = 10,
	__SCHED_FEAT_HRTICK_DL = 11,
	__SCHED_FEAT_NONTASK_CAPACITY = 12,
	__SCHED_FEAT_TTWU_QUEUE = 13,
	__SCHED_FEAT_SIS_UTIL = 14,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 15,
	__SCHED_FEAT_RT_PUSH_IPI = 16,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 17,
	__SCHED_FEAT_LB_MIN = 18,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 19,
	__SCHED_FEAT_WA_IDLE = 20,
	__SCHED_FEAT_WA_WEIGHT = 21,
	__SCHED_FEAT_WA_BIAS = 22,
	__SCHED_FEAT_UTIL_EST = 23,
	__SCHED_FEAT_LATENCY_WARN = 24,
	__SCHED_FEAT_NR = 25,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_KPROBE = 15,
	__ctx_convertBPF_PROG_TYPE_TRACEPOINT = 16,
	__ctx_convertBPF_PROG_TYPE_PERF_EVENT = 17,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT = 18,
	__ctx_convertBPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 19,
	__ctx_convertBPF_PROG_TYPE_TRACING = 20,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 21,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 22,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 23,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 24,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 25,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 26,
	__ctx_convertBPF_PROG_TYPE_EXT = 27,
	__ctx_convertBPF_PROG_TYPE_LSM = 28,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 29,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 30,
	__ctx_convert_unused = 31,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	false = 0,
	true = 1,
};

enum {
	kvm_ioeventfd_flag_nr_datamatch = 0,
	kvm_ioeventfd_flag_nr_pio = 1,
	kvm_ioeventfd_flag_nr_deassign = 2,
	kvm_ioeventfd_flag_nr_virtio_ccw_notify = 3,
	kvm_ioeventfd_flag_nr_fast_mmio = 4,
	kvm_ioeventfd_flag_nr_max = 5,
};

enum {
	mask_exec = 0,
	mask_write = 1,
	mask_read = 2,
	mask_append = 3,
};

enum {
	mechtype_caddy = 0,
	mechtype_tray = 1,
	mechtype_popup = 2,
	mechtype_individual_changer = 4,
	mechtype_cartridge_changer = 5,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	EfiPciIoWidthUint8 = 0,
	EfiPciIoWidthUint16 = 1,
	EfiPciIoWidthUint32 = 2,
	EfiPciIoWidthUint64 = 3,
	EfiPciIoWidthFifoUint8 = 4,
	EfiPciIoWidthFifoUint16 = 5,
	EfiPciIoWidthFifoUint32 = 6,
	EfiPciIoWidthFifoUint64 = 7,
	EfiPciIoWidthFillUint8 = 8,
	EfiPciIoWidthFillUint16 = 9,
	EfiPciIoWidthFillUint32 = 10,
	EfiPciIoWidthFillUint64 = 11,
	EfiPciIoWidthMaximum = 12,
} EFI_PCI_IO_PROTOCOL_WIDTH;

typedef enum {
	EfiTimerCancel = 0,
	EfiTimerPeriodic = 1,
	EfiTimerRelative = 2,
} EFI_TIMER_DELAY;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_frameType_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	OSL_GLOBAL_LOCK_HANDLER = 0,
	OSL_NOTIFY_HANDLER = 1,
	OSL_GPE_HANDLER = 2,
	OSL_DEBUGGER_MAIN_THREAD = 3,
	OSL_DEBUGGER_EXEC_THREAD = 4,
	OSL_EC_POLL_HANDLER = 5,
	OSL_EC_BURST_HANDLER = 6,
} acpi_execute_type;

typedef enum {
	ACPI_IMODE_LOAD_PASS1 = 1,
	ACPI_IMODE_LOAD_PASS2 = 2,
	ACPI_IMODE_EXECUTE = 3,
} acpi_interpreter_mode;

typedef enum {
	ACPI_TRACE_AML_METHOD = 0,
	ACPI_TRACE_AML_OPCODE = 1,
	ACPI_TRACE_AML_REGION = 2,
} acpi_trace_event_type;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FS_DECRYPT = 0,
	FS_ENCRYPT = 1,
} fscrypt_direction_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PCI_BRIDGE_EMUL_HANDLED = 0,
	PCI_BRIDGE_EMUL_NOT_HANDLED = 1,
} pci_bridge_emul_read_status_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	PSMOUSE_BAD_DATA = 0,
	PSMOUSE_GOOD_DATA = 1,
	PSMOUSE_FULL_PACKET = 2,
} psmouse_ret_t;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	STATUSTYPE_INFO = 0,
	STATUSTYPE_TABLE = 1,
	STATUSTYPE_IMA = 2,
} status_type_t;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} symbolEncodingType_e;

typedef ZSTD_ErrorCode zstd_error_code;

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum S2MPU02_reg {
	S2MPU02_REG_ID = 0,
	S2MPU02_REG_INT1 = 1,
	S2MPU02_REG_INT2 = 2,
	S2MPU02_REG_INT3 = 3,
	S2MPU02_REG_INT1M = 4,
	S2MPU02_REG_INT2M = 5,
	S2MPU02_REG_INT3M = 6,
	S2MPU02_REG_ST1 = 7,
	S2MPU02_REG_ST2 = 8,
	S2MPU02_REG_PWRONSRC = 9,
	S2MPU02_REG_OFFSRC = 10,
	S2MPU02_REG_BU_CHG = 11,
	S2MPU02_REG_RTCCTRL = 12,
	S2MPU02_REG_PMCTRL1 = 13,
	S2MPU02_REG_RSVD1 = 14,
	S2MPU02_REG_RSVD2 = 15,
	S2MPU02_REG_RSVD3 = 16,
	S2MPU02_REG_RSVD4 = 17,
	S2MPU02_REG_RSVD5 = 18,
	S2MPU02_REG_RSVD6 = 19,
	S2MPU02_REG_RSVD7 = 20,
	S2MPU02_REG_WRSTEN = 21,
	S2MPU02_REG_RSVD8 = 22,
	S2MPU02_REG_RSVD9 = 23,
	S2MPU02_REG_RSVD10 = 24,
	S2MPU02_REG_B1CTRL1 = 25,
	S2MPU02_REG_B1CTRL2 = 26,
	S2MPU02_REG_B2CTRL1 = 27,
	S2MPU02_REG_B2CTRL2 = 28,
	S2MPU02_REG_B3CTRL1 = 29,
	S2MPU02_REG_B3CTRL2 = 30,
	S2MPU02_REG_B4CTRL1 = 31,
	S2MPU02_REG_B4CTRL2 = 32,
	S2MPU02_REG_B5CTRL1 = 33,
	S2MPU02_REG_B5CTRL2 = 34,
	S2MPU02_REG_B5CTRL3 = 35,
	S2MPU02_REG_B5CTRL4 = 36,
	S2MPU02_REG_B5CTRL5 = 37,
	S2MPU02_REG_B6CTRL1 = 38,
	S2MPU02_REG_B6CTRL2 = 39,
	S2MPU02_REG_B7CTRL1 = 40,
	S2MPU02_REG_B7CTRL2 = 41,
	S2MPU02_REG_RAMP1 = 42,
	S2MPU02_REG_RAMP2 = 43,
	S2MPU02_REG_L1CTRL = 44,
	S2MPU02_REG_L2CTRL1 = 45,
	S2MPU02_REG_L2CTRL2 = 46,
	S2MPU02_REG_L2CTRL3 = 47,
	S2MPU02_REG_L2CTRL4 = 48,
	S2MPU02_REG_L3CTRL = 49,
	S2MPU02_REG_L4CTRL = 50,
	S2MPU02_REG_L5CTRL = 51,
	S2MPU02_REG_L6CTRL = 52,
	S2MPU02_REG_L7CTRL = 53,
	S2MPU02_REG_L8CTRL = 54,
	S2MPU02_REG_L9CTRL = 55,
	S2MPU02_REG_L10CTRL = 56,
	S2MPU02_REG_L11CTRL = 57,
	S2MPU02_REG_L12CTRL = 58,
	S2MPU02_REG_L13CTRL = 59,
	S2MPU02_REG_L14CTRL = 60,
	S2MPU02_REG_L15CTRL = 61,
	S2MPU02_REG_L16CTRL = 62,
	S2MPU02_REG_L17CTRL = 63,
	S2MPU02_REG_L18CTRL = 64,
	S2MPU02_REG_L19CTRL = 65,
	S2MPU02_REG_L20CTRL = 66,
	S2MPU02_REG_L21CTRL = 67,
	S2MPU02_REG_L22CTRL = 68,
	S2MPU02_REG_L23CTRL = 69,
	S2MPU02_REG_L24CTRL = 70,
	S2MPU02_REG_L25CTRL = 71,
	S2MPU02_REG_L26CTRL = 72,
	S2MPU02_REG_L27CTRL = 73,
	S2MPU02_REG_L28CTRL = 74,
	S2MPU02_REG_LDODSCH1 = 75,
	S2MPU02_REG_LDODSCH2 = 76,
	S2MPU02_REG_LDODSCH3 = 77,
	S2MPU02_REG_LDODSCH4 = 78,
	S2MPU02_REG_SELMIF = 79,
	S2MPU02_REG_RSVD11 = 80,
	S2MPU02_REG_RSVD12 = 81,
	S2MPU02_REG_RSVD13 = 82,
	S2MPU02_REG_DVSSEL = 83,
	S2MPU02_REG_DVSPTR = 84,
	S2MPU02_REG_DVSDATA = 85,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum SS4_PACKET_ID {
	SS4_PACKET_ID_IDLE = 0,
	SS4_PACKET_ID_ONE = 1,
	SS4_PACKET_ID_TWO = 2,
	SS4_PACKET_ID_MULTI = 3,
	SS4_PACKET_ID_STICK = 4,
};

enum TPM_OPS_FLAGS {
	TPM_OPS_AUTO_STARTUP = 1,
};

enum UART_TX_FLAGS {
	UART_TX_NOSTOP = 1,
};

enum V7_PACKET_ID {
	V7_PACKET_ID_IDLE = 0,
	V7_PACKET_ID_TWO = 1,
	V7_PACKET_ID_MULTI = 2,
	V7_PACKET_ID_NEW = 3,
	V7_PACKET_ID_UNKNOWN = 4,
};

enum __kvm_host_smccc_func {
	__KVM_HOST_SMCCC_FUNC___kvm_get_mdcr_el2 = 1,
	__KVM_HOST_SMCCC_FUNC___pkvm_init = 2,
	__KVM_HOST_SMCCC_FUNC___pkvm_create_private_mapping = 3,
	__KVM_HOST_SMCCC_FUNC___pkvm_cpu_set_vector = 4,
	__KVM_HOST_SMCCC_FUNC___kvm_enable_ssbs = 5,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_init_lrs = 6,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_get_gic_config = 7,
	__KVM_HOST_SMCCC_FUNC___pkvm_prot_finalize = 8,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_share_hyp = 9,
	__KVM_HOST_SMCCC_FUNC___pkvm_host_unshare_hyp = 10,
	__KVM_HOST_SMCCC_FUNC___kvm_adjust_pc = 11,
	__KVM_HOST_SMCCC_FUNC___kvm_vcpu_run = 12,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_vm_context = 13,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa = 14,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_ipa_nsh = 15,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid = 16,
	__KVM_HOST_SMCCC_FUNC___kvm_tlb_flush_vmid_range = 17,
	__KVM_HOST_SMCCC_FUNC___kvm_flush_cpu_context = 18,
	__KVM_HOST_SMCCC_FUNC___kvm_timer_set_cntvoff = 19,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_save_vmcr_aprs = 20,
	__KVM_HOST_SMCCC_FUNC___vgic_v3_restore_vmcr_aprs = 21,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vm = 22,
	__KVM_HOST_SMCCC_FUNC___pkvm_init_vcpu = 23,
	__KVM_HOST_SMCCC_FUNC___pkvm_teardown_vm = 24,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_SKIP_KFENCE = 15,
	_SLAB_RECLAIM_ACCOUNT = 16,
	_SLAB_OBJECT_POISON = 17,
	_SLAB_CMPXCHG_DOUBLE = 18,
	_SLAB_NO_OBJ_EXT = 19,
	_SLAB_FLAGS_LAST_BIT = 20,
};

enum aarch32_map {
	AA32_MAP_VECTORS = 0,
	AA32_MAP_SIGPAGE = 1,
	AA32_MAP_VDSO = 2,
};

enum aarch64_insn_adr_type {
	AARCH64_INSN_ADR_TYPE_ADRP = 0,
	AARCH64_INSN_ADR_TYPE_ADR = 1,
};

enum aarch64_insn_adsb_type {
	AARCH64_INSN_ADSB_ADD = 0,
	AARCH64_INSN_ADSB_SUB = 1,
	AARCH64_INSN_ADSB_ADD_SETFLAGS = 2,
	AARCH64_INSN_ADSB_SUB_SETFLAGS = 3,
};

enum aarch64_insn_bitfield_type {
	AARCH64_INSN_BITFIELD_MOVE = 0,
	AARCH64_INSN_BITFIELD_MOVE_UNSIGNED = 1,
	AARCH64_INSN_BITFIELD_MOVE_SIGNED = 2,
};

enum aarch64_insn_branch_type {
	AARCH64_INSN_BRANCH_NOLINK = 0,
	AARCH64_INSN_BRANCH_LINK = 1,
	AARCH64_INSN_BRANCH_RETURN = 2,
	AARCH64_INSN_BRANCH_COMP_ZERO = 3,
	AARCH64_INSN_BRANCH_COMP_NONZERO = 4,
};

enum aarch64_insn_condition {
	AARCH64_INSN_COND_EQ = 0,
	AARCH64_INSN_COND_NE = 1,
	AARCH64_INSN_COND_CS = 2,
	AARCH64_INSN_COND_CC = 3,
	AARCH64_INSN_COND_MI = 4,
	AARCH64_INSN_COND_PL = 5,
	AARCH64_INSN_COND_VS = 6,
	AARCH64_INSN_COND_VC = 7,
	AARCH64_INSN_COND_HI = 8,
	AARCH64_INSN_COND_LS = 9,
	AARCH64_INSN_COND_GE = 10,
	AARCH64_INSN_COND_LT = 11,
	AARCH64_INSN_COND_GT = 12,
	AARCH64_INSN_COND_LE = 13,
	AARCH64_INSN_COND_AL = 14,
};

enum aarch64_insn_data1_type {
	AARCH64_INSN_DATA1_REVERSE_16 = 0,
	AARCH64_INSN_DATA1_REVERSE_32 = 1,
	AARCH64_INSN_DATA1_REVERSE_64 = 2,
};

enum aarch64_insn_data2_type {
	AARCH64_INSN_DATA2_UDIV = 0,
	AARCH64_INSN_DATA2_SDIV = 1,
	AARCH64_INSN_DATA2_LSLV = 2,
	AARCH64_INSN_DATA2_LSRV = 3,
	AARCH64_INSN_DATA2_ASRV = 4,
	AARCH64_INSN_DATA2_RORV = 5,
};

enum aarch64_insn_data3_type {
	AARCH64_INSN_DATA3_MADD = 0,
	AARCH64_INSN_DATA3_MSUB = 1,
};

enum aarch64_insn_hint_cr_op {
	AARCH64_INSN_HINT_NOP = 0,
	AARCH64_INSN_HINT_YIELD = 32,
	AARCH64_INSN_HINT_WFE = 64,
	AARCH64_INSN_HINT_WFI = 96,
	AARCH64_INSN_HINT_SEV = 128,
	AARCH64_INSN_HINT_SEVL = 160,
	AARCH64_INSN_HINT_XPACLRI = 224,
	AARCH64_INSN_HINT_PACIA_1716 = 256,
	AARCH64_INSN_HINT_PACIB_1716 = 320,
	AARCH64_INSN_HINT_AUTIA_1716 = 384,
	AARCH64_INSN_HINT_AUTIB_1716 = 448,
	AARCH64_INSN_HINT_PACIAZ = 768,
	AARCH64_INSN_HINT_PACIASP = 800,
	AARCH64_INSN_HINT_PACIBZ = 832,
	AARCH64_INSN_HINT_PACIBSP = 864,
	AARCH64_INSN_HINT_AUTIAZ = 896,
	AARCH64_INSN_HINT_AUTIASP = 928,
	AARCH64_INSN_HINT_AUTIBZ = 960,
	AARCH64_INSN_HINT_AUTIBSP = 992,
	AARCH64_INSN_HINT_ESB = 512,
	AARCH64_INSN_HINT_PSB = 544,
	AARCH64_INSN_HINT_TSB = 576,
	AARCH64_INSN_HINT_CSDB = 640,
	AARCH64_INSN_HINT_CLEARBHB = 704,
	AARCH64_INSN_HINT_BTI = 1024,
	AARCH64_INSN_HINT_BTIC = 1088,
	AARCH64_INSN_HINT_BTIJ = 1152,
	AARCH64_INSN_HINT_BTIJC = 1216,
};

enum aarch64_insn_imm_type {
	AARCH64_INSN_IMM_ADR = 0,
	AARCH64_INSN_IMM_26 = 1,
	AARCH64_INSN_IMM_19 = 2,
	AARCH64_INSN_IMM_16 = 3,
	AARCH64_INSN_IMM_14 = 4,
	AARCH64_INSN_IMM_12 = 5,
	AARCH64_INSN_IMM_9 = 6,
	AARCH64_INSN_IMM_7 = 7,
	AARCH64_INSN_IMM_6 = 8,
	AARCH64_INSN_IMM_S = 9,
	AARCH64_INSN_IMM_R = 10,
	AARCH64_INSN_IMM_N = 11,
	AARCH64_INSN_IMM_MAX = 12,
};

enum aarch64_insn_ldst_type {
	AARCH64_INSN_LDST_LOAD_REG_OFFSET = 0,
	AARCH64_INSN_LDST_STORE_REG_OFFSET = 1,
	AARCH64_INSN_LDST_LOAD_IMM_OFFSET = 2,
	AARCH64_INSN_LDST_STORE_IMM_OFFSET = 3,
	AARCH64_INSN_LDST_LOAD_PAIR_PRE_INDEX = 4,
	AARCH64_INSN_LDST_STORE_PAIR_PRE_INDEX = 5,
	AARCH64_INSN_LDST_LOAD_PAIR_POST_INDEX = 6,
	AARCH64_INSN_LDST_STORE_PAIR_POST_INDEX = 7,
	AARCH64_INSN_LDST_LOAD_EX = 8,
	AARCH64_INSN_LDST_LOAD_ACQ_EX = 9,
	AARCH64_INSN_LDST_STORE_EX = 10,
	AARCH64_INSN_LDST_STORE_REL_EX = 11,
	AARCH64_INSN_LDST_SIGNED_LOAD_IMM_OFFSET = 12,
	AARCH64_INSN_LDST_SIGNED_LOAD_REG_OFFSET = 13,
};

enum aarch64_insn_logic_type {
	AARCH64_INSN_LOGIC_AND = 0,
	AARCH64_INSN_LOGIC_BIC = 1,
	AARCH64_INSN_LOGIC_ORR = 2,
	AARCH64_INSN_LOGIC_ORN = 3,
	AARCH64_INSN_LOGIC_EOR = 4,
	AARCH64_INSN_LOGIC_EON = 5,
	AARCH64_INSN_LOGIC_AND_SETFLAGS = 6,
	AARCH64_INSN_LOGIC_BIC_SETFLAGS = 7,
};

enum aarch64_insn_mb_type {
	AARCH64_INSN_MB_SY = 0,
	AARCH64_INSN_MB_ST = 1,
	AARCH64_INSN_MB_LD = 2,
	AARCH64_INSN_MB_ISH = 3,
	AARCH64_INSN_MB_ISHST = 4,
	AARCH64_INSN_MB_ISHLD = 5,
	AARCH64_INSN_MB_NSH = 6,
	AARCH64_INSN_MB_NSHST = 7,
	AARCH64_INSN_MB_NSHLD = 8,
	AARCH64_INSN_MB_OSH = 9,
	AARCH64_INSN_MB_OSHST = 10,
	AARCH64_INSN_MB_OSHLD = 11,
};

enum aarch64_insn_mem_atomic_op {
	AARCH64_INSN_MEM_ATOMIC_ADD = 0,
	AARCH64_INSN_MEM_ATOMIC_CLR = 1,
	AARCH64_INSN_MEM_ATOMIC_EOR = 2,
	AARCH64_INSN_MEM_ATOMIC_SET = 3,
	AARCH64_INSN_MEM_ATOMIC_SWP = 4,
};

enum aarch64_insn_mem_order_type {
	AARCH64_INSN_MEM_ORDER_NONE = 0,
	AARCH64_INSN_MEM_ORDER_ACQ = 1,
	AARCH64_INSN_MEM_ORDER_REL = 2,
	AARCH64_INSN_MEM_ORDER_ACQREL = 3,
};

enum aarch64_insn_movewide_type {
	AARCH64_INSN_MOVEWIDE_ZERO = 0,
	AARCH64_INSN_MOVEWIDE_KEEP = 1,
	AARCH64_INSN_MOVEWIDE_INVERSE = 2,
};

enum aarch64_insn_movw_imm_type {
	AARCH64_INSN_IMM_MOVNZ = 0,
	AARCH64_INSN_IMM_MOVKZ = 1,
};

enum aarch64_insn_register {
	AARCH64_INSN_REG_0 = 0,
	AARCH64_INSN_REG_1 = 1,
	AARCH64_INSN_REG_2 = 2,
	AARCH64_INSN_REG_3 = 3,
	AARCH64_INSN_REG_4 = 4,
	AARCH64_INSN_REG_5 = 5,
	AARCH64_INSN_REG_6 = 6,
	AARCH64_INSN_REG_7 = 7,
	AARCH64_INSN_REG_8 = 8,
	AARCH64_INSN_REG_9 = 9,
	AARCH64_INSN_REG_10 = 10,
	AARCH64_INSN_REG_11 = 11,
	AARCH64_INSN_REG_12 = 12,
	AARCH64_INSN_REG_13 = 13,
	AARCH64_INSN_REG_14 = 14,
	AARCH64_INSN_REG_15 = 15,
	AARCH64_INSN_REG_16 = 16,
	AARCH64_INSN_REG_17 = 17,
	AARCH64_INSN_REG_18 = 18,
	AARCH64_INSN_REG_19 = 19,
	AARCH64_INSN_REG_20 = 20,
	AARCH64_INSN_REG_21 = 21,
	AARCH64_INSN_REG_22 = 22,
	AARCH64_INSN_REG_23 = 23,
	AARCH64_INSN_REG_24 = 24,
	AARCH64_INSN_REG_25 = 25,
	AARCH64_INSN_REG_26 = 26,
	AARCH64_INSN_REG_27 = 27,
	AARCH64_INSN_REG_28 = 28,
	AARCH64_INSN_REG_29 = 29,
	AARCH64_INSN_REG_FP = 29,
	AARCH64_INSN_REG_30 = 30,
	AARCH64_INSN_REG_LR = 30,
	AARCH64_INSN_REG_ZR = 31,
	AARCH64_INSN_REG_SP = 31,
};

enum aarch64_insn_register_type {
	AARCH64_INSN_REGTYPE_RT = 0,
	AARCH64_INSN_REGTYPE_RN = 1,
	AARCH64_INSN_REGTYPE_RT2 = 2,
	AARCH64_INSN_REGTYPE_RM = 3,
	AARCH64_INSN_REGTYPE_RD = 4,
	AARCH64_INSN_REGTYPE_RA = 5,
	AARCH64_INSN_REGTYPE_RS = 6,
};

enum aarch64_insn_size_type {
	AARCH64_INSN_SIZE_8 = 0,
	AARCH64_INSN_SIZE_16 = 1,
	AARCH64_INSN_SIZE_32 = 2,
	AARCH64_INSN_SIZE_64 = 3,
};

enum aarch64_insn_special_register {
	AARCH64_INSN_SPCLREG_SPSR_EL1 = 49664,
	AARCH64_INSN_SPCLREG_ELR_EL1 = 49665,
	AARCH64_INSN_SPCLREG_SP_EL0 = 49672,
	AARCH64_INSN_SPCLREG_SPSEL = 49680,
	AARCH64_INSN_SPCLREG_CURRENTEL = 49682,
	AARCH64_INSN_SPCLREG_DAIF = 55825,
	AARCH64_INSN_SPCLREG_NZCV = 55824,
	AARCH64_INSN_SPCLREG_FPCR = 55840,
	AARCH64_INSN_SPCLREG_DSPSR_EL0 = 55848,
	AARCH64_INSN_SPCLREG_DLR_EL0 = 55849,
	AARCH64_INSN_SPCLREG_SPSR_EL2 = 57856,
	AARCH64_INSN_SPCLREG_ELR_EL2 = 57857,
	AARCH64_INSN_SPCLREG_SP_EL1 = 57864,
	AARCH64_INSN_SPCLREG_SPSR_INQ = 57880,
	AARCH64_INSN_SPCLREG_SPSR_ABT = 57881,
	AARCH64_INSN_SPCLREG_SPSR_UND = 57882,
	AARCH64_INSN_SPCLREG_SPSR_FIQ = 57883,
	AARCH64_INSN_SPCLREG_SPSR_EL3 = 61952,
	AARCH64_INSN_SPCLREG_ELR_EL3 = 61953,
	AARCH64_INSN_SPCLREG_SP_EL2 = 61968,
};

enum aarch64_insn_system_register {
	AARCH64_INSN_SYSREG_TPIDR_EL1 = 18052,
	AARCH64_INSN_SYSREG_TPIDR_EL2 = 26242,
	AARCH64_INSN_SYSREG_SP_EL0 = 16904,
};

enum aarch64_insn_variant {
	AARCH64_INSN_VARIANT_32BIT = 0,
	AARCH64_INSN_VARIANT_64BIT = 1,
};

enum aarch64_regset {
	REGSET_GPR = 0,
	REGSET_FPR = 1,
	REGSET_TLS = 2,
	REGSET_HW_BREAK = 3,
	REGSET_HW_WATCH = 4,
	REGSET_FPMR = 5,
	REGSET_SYSTEM_CALL = 6,
	REGSET_SVE = 7,
	REGSET_PAC_MASK = 8,
	REGSET_PAC_ENABLED_KEYS = 9,
	REGSET_PACA_KEYS = 10,
	REGSET_PACG_KEYS = 11,
	REGSET_TAGGED_ADDR_CTRL = 12,
	REGSET_POE = 13,
};

enum aarch64_reloc_op {
	RELOC_OP_NONE = 0,
	RELOC_OP_ABS = 1,
	RELOC_OP_PREL = 2,
	RELOC_OP_PAGE = 3,
};

enum access_coordinate_class {
	ACCESS_COORDINATE_LOCAL = 0,
	ACCESS_COORDINATE_CPU = 1,
	ACCESS_COORDINATE_MAX = 2,
};

enum acpi_attr_enum {
	ACPI_ATTR_LABEL_SHOW = 0,
	ACPI_ATTR_INDEX_SHOW = 1,
};

enum acpi_bridge_type {
	ACPI_BRIDGE_TYPE_PCIE = 1,
	ACPI_BRIDGE_TYPE_CXL = 2,
};

enum acpi_bus_device_type {
	ACPI_BUS_TYPE_DEVICE = 0,
	ACPI_BUS_TYPE_POWER = 1,
	ACPI_BUS_TYPE_PROCESSOR = 2,
	ACPI_BUS_TYPE_THERMAL = 3,
	ACPI_BUS_TYPE_POWER_BUTTON = 4,
	ACPI_BUS_TYPE_SLEEP_BUTTON = 5,
	ACPI_BUS_TYPE_ECDT_EC = 6,
	ACPI_BUS_DEVICE_TYPE_COUNT = 7,
};

enum acpi_cdat_type {
	ACPI_CDAT_TYPE_DSMAS = 0,
	ACPI_CDAT_TYPE_DSLBIS = 1,
	ACPI_CDAT_TYPE_DSMSCIS = 2,
	ACPI_CDAT_TYPE_DSIS = 3,
	ACPI_CDAT_TYPE_DSEMTS = 4,
	ACPI_CDAT_TYPE_SSLBIS = 5,
	ACPI_CDAT_TYPE_RESERVED = 6,
};

enum acpi_cedt_type {
	ACPI_CEDT_TYPE_CHBS = 0,
	ACPI_CEDT_TYPE_CFMWS = 1,
	ACPI_CEDT_TYPE_CXIMS = 2,
	ACPI_CEDT_TYPE_RDPAS = 3,
	ACPI_CEDT_TYPE_RESERVED = 4,
};

enum acpi_device_swnode_dev_props {
	ACPI_DEVICE_SWNODE_DEV_ROTATION = 0,
	ACPI_DEVICE_SWNODE_DEV_CLOCK_FREQUENCY = 1,
	ACPI_DEVICE_SWNODE_DEV_LED_MAX_MICROAMP = 2,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_MICROAMP = 3,
	ACPI_DEVICE_SWNODE_DEV_FLASH_MAX_TIMEOUT_US = 4,
	ACPI_DEVICE_SWNODE_DEV_NUM_OF = 5,
	ACPI_DEVICE_SWNODE_DEV_NUM_ENTRIES = 6,
};

enum acpi_device_swnode_ep_props {
	ACPI_DEVICE_SWNODE_EP_REMOTE_EP = 0,
	ACPI_DEVICE_SWNODE_EP_BUS_TYPE = 1,
	ACPI_DEVICE_SWNODE_EP_REG = 2,
	ACPI_DEVICE_SWNODE_EP_CLOCK_LANES = 3,
	ACPI_DEVICE_SWNODE_EP_DATA_LANES = 4,
	ACPI_DEVICE_SWNODE_EP_LANE_POLARITIES = 5,
	ACPI_DEVICE_SWNODE_EP_LINK_FREQUENCIES = 6,
	ACPI_DEVICE_SWNODE_EP_NUM_OF = 7,
	ACPI_DEVICE_SWNODE_EP_NUM_ENTRIES = 8,
};

enum acpi_device_swnode_port_props {
	ACPI_DEVICE_SWNODE_PORT_REG = 0,
	ACPI_DEVICE_SWNODE_PORT_NUM_OF = 1,
	ACPI_DEVICE_SWNODE_PORT_NUM_ENTRIES = 2,
};

enum acpi_erst_actions {
	ACPI_ERST_BEGIN_WRITE = 0,
	ACPI_ERST_BEGIN_READ = 1,
	ACPI_ERST_BEGIN_CLEAR = 2,
	ACPI_ERST_END = 3,
	ACPI_ERST_SET_RECORD_OFFSET = 4,
	ACPI_ERST_EXECUTE_OPERATION = 5,
	ACPI_ERST_CHECK_BUSY_STATUS = 6,
	ACPI_ERST_GET_COMMAND_STATUS = 7,
	ACPI_ERST_GET_RECORD_ID = 8,
	ACPI_ERST_SET_RECORD_ID = 9,
	ACPI_ERST_GET_RECORD_COUNT = 10,
	ACPI_ERST_BEGIN_DUMMY_WRIITE = 11,
	ACPI_ERST_NOT_USED = 12,
	ACPI_ERST_GET_ERROR_RANGE = 13,
	ACPI_ERST_GET_ERROR_LENGTH = 14,
	ACPI_ERST_GET_ERROR_ATTRIBUTES = 15,
	ACPI_ERST_EXECUTE_TIMINGS = 16,
	ACPI_ERST_ACTION_RESERVED = 17,
};

enum acpi_erst_instructions {
	ACPI_ERST_READ_REGISTER = 0,
	ACPI_ERST_READ_REGISTER_VALUE = 1,
	ACPI_ERST_WRITE_REGISTER = 2,
	ACPI_ERST_WRITE_REGISTER_VALUE = 3,
	ACPI_ERST_NOOP = 4,
	ACPI_ERST_LOAD_VAR1 = 5,
	ACPI_ERST_LOAD_VAR2 = 6,
	ACPI_ERST_STORE_VAR1 = 7,
	ACPI_ERST_ADD = 8,
	ACPI_ERST_SUBTRACT = 9,
	ACPI_ERST_ADD_VALUE = 10,
	ACPI_ERST_SUBTRACT_VALUE = 11,
	ACPI_ERST_STALL = 12,
	ACPI_ERST_STALL_WHILE_TRUE = 13,
	ACPI_ERST_SKIP_NEXT_IF_TRUE = 14,
	ACPI_ERST_GOTO = 15,
	ACPI_ERST_SET_SRC_ADDRESS_BASE = 16,
	ACPI_ERST_SET_DST_ADDRESS_BASE = 17,
	ACPI_ERST_MOVE_DATA = 18,
	ACPI_ERST_INSTRUCTION_RESERVED = 19,
};

enum acpi_gtdt_type {
	ACPI_GTDT_TYPE_TIMER_BLOCK = 0,
	ACPI_GTDT_TYPE_WATCHDOG = 1,
	ACPI_GTDT_TYPE_RESERVED = 2,
};

enum acpi_hest_notify_types {
	ACPI_HEST_NOTIFY_POLLED = 0,
	ACPI_HEST_NOTIFY_EXTERNAL = 1,
	ACPI_HEST_NOTIFY_LOCAL = 2,
	ACPI_HEST_NOTIFY_SCI = 3,
	ACPI_HEST_NOTIFY_NMI = 4,
	ACPI_HEST_NOTIFY_CMCI = 5,
	ACPI_HEST_NOTIFY_MCE = 6,
	ACPI_HEST_NOTIFY_GPIO = 7,
	ACPI_HEST_NOTIFY_SEA = 8,
	ACPI_HEST_NOTIFY_SEI = 9,
	ACPI_HEST_NOTIFY_GSIV = 10,
	ACPI_HEST_NOTIFY_SOFTWARE_DELEGATED = 11,
	ACPI_HEST_NOTIFY_RESERVED = 12,
};

enum acpi_hest_types {
	ACPI_HEST_TYPE_IA32_CHECK = 0,
	ACPI_HEST_TYPE_IA32_CORRECTED_CHECK = 1,
	ACPI_HEST_TYPE_IA32_NMI = 2,
	ACPI_HEST_TYPE_NOT_USED3 = 3,
	ACPI_HEST_TYPE_NOT_USED4 = 4,
	ACPI_HEST_TYPE_NOT_USED5 = 5,
	ACPI_HEST_TYPE_AER_ROOT_PORT = 6,
	ACPI_HEST_TYPE_AER_ENDPOINT = 7,
	ACPI_HEST_TYPE_AER_BRIDGE = 8,
	ACPI_HEST_TYPE_GENERIC_ERROR = 9,
	ACPI_HEST_TYPE_GENERIC_ERROR_V2 = 10,
	ACPI_HEST_TYPE_IA32_DEFERRED_CHECK = 11,
	ACPI_HEST_TYPE_RESERVED = 12,
};

enum acpi_hmat_type {
	ACPI_HMAT_TYPE_PROXIMITY = 0,
	ACPI_HMAT_TYPE_LOCALITY = 1,
	ACPI_HMAT_TYPE_CACHE = 2,
	ACPI_HMAT_TYPE_RESERVED = 3,
};

enum acpi_iort_node_type {
	ACPI_IORT_NODE_ITS_GROUP = 0,
	ACPI_IORT_NODE_NAMED_COMPONENT = 1,
	ACPI_IORT_NODE_PCI_ROOT_COMPLEX = 2,
	ACPI_IORT_NODE_SMMU = 3,
	ACPI_IORT_NODE_SMMU_V3 = 4,
	ACPI_IORT_NODE_PMCG = 5,
	ACPI_IORT_NODE_RMR = 6,
};

enum acpi_irq_model_id {
	ACPI_IRQ_MODEL_PIC = 0,
	ACPI_IRQ_MODEL_IOAPIC = 1,
	ACPI_IRQ_MODEL_IOSAPIC = 2,
	ACPI_IRQ_MODEL_PLATFORM = 3,
	ACPI_IRQ_MODEL_GIC = 4,
	ACPI_IRQ_MODEL_LPIC = 5,
	ACPI_IRQ_MODEL_RINTC = 6,
	ACPI_IRQ_MODEL_COUNT = 7,
};

enum acpi_madt_gic_version {
	ACPI_MADT_GIC_VERSION_NONE = 0,
	ACPI_MADT_GIC_VERSION_V1 = 1,
	ACPI_MADT_GIC_VERSION_V2 = 2,
	ACPI_MADT_GIC_VERSION_V3 = 3,
	ACPI_MADT_GIC_VERSION_V4 = 4,
	ACPI_MADT_GIC_VERSION_RESERVED = 5,
};

enum acpi_madt_multiproc_wakeup_version {
	ACPI_MADT_MP_WAKEUP_VERSION_NONE = 0,
	ACPI_MADT_MP_WAKEUP_VERSION_V1 = 1,
	ACPI_MADT_MP_WAKEUP_VERSION_RESERVED = 2,
};

enum acpi_madt_type {
	ACPI_MADT_TYPE_LOCAL_APIC = 0,
	ACPI_MADT_TYPE_IO_APIC = 1,
	ACPI_MADT_TYPE_INTERRUPT_OVERRIDE = 2,
	ACPI_MADT_TYPE_NMI_SOURCE = 3,
	ACPI_MADT_TYPE_LOCAL_APIC_NMI = 4,
	ACPI_MADT_TYPE_LOCAL_APIC_OVERRIDE = 5,
	ACPI_MADT_TYPE_IO_SAPIC = 6,
	ACPI_MADT_TYPE_LOCAL_SAPIC = 7,
	ACPI_MADT_TYPE_INTERRUPT_SOURCE = 8,
	ACPI_MADT_TYPE_LOCAL_X2APIC = 9,
	ACPI_MADT_TYPE_LOCAL_X2APIC_NMI = 10,
	ACPI_MADT_TYPE_GENERIC_INTERRUPT = 11,
	ACPI_MADT_TYPE_GENERIC_DISTRIBUTOR = 12,
	ACPI_MADT_TYPE_GENERIC_MSI_FRAME = 13,
	ACPI_MADT_TYPE_GENERIC_REDISTRIBUTOR = 14,
	ACPI_MADT_TYPE_GENERIC_TRANSLATOR = 15,
	ACPI_MADT_TYPE_MULTIPROC_WAKEUP = 16,
	ACPI_MADT_TYPE_CORE_PIC = 17,
	ACPI_MADT_TYPE_LIO_PIC = 18,
	ACPI_MADT_TYPE_HT_PIC = 19,
	ACPI_MADT_TYPE_EIO_PIC = 20,
	ACPI_MADT_TYPE_MSI_PIC = 21,
	ACPI_MADT_TYPE_BIO_PIC = 22,
	ACPI_MADT_TYPE_LPC_PIC = 23,
	ACPI_MADT_TYPE_RINTC = 24,
	ACPI_MADT_TYPE_IMSIC = 25,
	ACPI_MADT_TYPE_APLIC = 26,
	ACPI_MADT_TYPE_PLIC = 27,
	ACPI_MADT_TYPE_RESERVED = 28,
	ACPI_MADT_TYPE_OEM_RESERVED = 128,
};

enum acpi_pcct_type {
	ACPI_PCCT_TYPE_GENERIC_SUBSPACE = 0,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE = 1,
	ACPI_PCCT_TYPE_HW_REDUCED_SUBSPACE_TYPE2 = 2,
	ACPI_PCCT_TYPE_EXT_PCC_MASTER_SUBSPACE = 3,
	ACPI_PCCT_TYPE_EXT_PCC_SLAVE_SUBSPACE = 4,
	ACPI_PCCT_TYPE_HW_REG_COMM_SUBSPACE = 5,
	ACPI_PCCT_TYPE_RESERVED = 6,
};

enum acpi_pptt_type {
	ACPI_PPTT_TYPE_PROCESSOR = 0,
	ACPI_PPTT_TYPE_CACHE = 1,
	ACPI_PPTT_TYPE_ID = 2,
	ACPI_PPTT_TYPE_RESERVED = 3,
};

enum acpi_predicate {
	all_versions = 0,
	less_than_or_equal = 1,
	equal = 2,
	greater_than_or_equal = 3,
};

enum acpi_reconfig_event {
	ACPI_RECONFIG_DEVICE_ADD = 0,
	ACPI_RECONFIG_DEVICE_REMOVE = 1,
};

enum acpi_return_package_types {
	ACPI_PTYPE1_FIXED = 1,
	ACPI_PTYPE1_VAR = 2,
	ACPI_PTYPE1_OPTION = 3,
	ACPI_PTYPE2 = 4,
	ACPI_PTYPE2_COUNT = 5,
	ACPI_PTYPE2_PKG_COUNT = 6,
	ACPI_PTYPE2_FIXED = 7,
	ACPI_PTYPE2_MIN = 8,
	ACPI_PTYPE2_REV_FIXED = 9,
	ACPI_PTYPE2_FIX_VAR = 10,
	ACPI_PTYPE2_VAR_VAR = 11,
	ACPI_PTYPE2_UUID_PAIR = 12,
	ACPI_PTYPE_CUSTOM = 13,
};

enum acpi_srat_type {
	ACPI_SRAT_TYPE_CPU_AFFINITY = 0,
	ACPI_SRAT_TYPE_MEMORY_AFFINITY = 1,
	ACPI_SRAT_TYPE_X2APIC_CPU_AFFINITY = 2,
	ACPI_SRAT_TYPE_GICC_AFFINITY = 3,
	ACPI_SRAT_TYPE_GIC_ITS_AFFINITY = 4,
	ACPI_SRAT_TYPE_GENERIC_AFFINITY = 5,
	ACPI_SRAT_TYPE_GENERIC_PORT_AFFINITY = 6,
	ACPI_SRAT_TYPE_RINTC_AFFINITY = 7,
	ACPI_SRAT_TYPE_RESERVED = 8,
};

enum acpi_subtable_type {
	ACPI_SUBTABLE_COMMON = 0,
	ACPI_SUBTABLE_HMAT = 1,
	ACPI_SUBTABLE_PRMT = 2,
	ACPI_SUBTABLE_CEDT = 3,
	CDAT_SUBTABLE = 4,
};

enum acpi_viot_node_type {
	ACPI_VIOT_NODE_PCI_RANGE = 1,
	ACPI_VIOT_NODE_MMIO = 2,
	ACPI_VIOT_NODE_VIRTIO_IOMMU_PCI = 3,
	ACPI_VIOT_NODE_VIRTIO_IOMMU_MMIO = 4,
	ACPI_VIOT_RESERVED = 5,
};

enum action_id {
	ACTION_SAVE = 1,
	ACTION_TRACE = 2,
	ACTION_SNAPSHOT = 3,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum addr_type_t {
	UNICAST_ADDR = 0,
	MULTICAST_ADDR = 1,
	ANYCAST_ADDR = 2,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum alloc_reserve {
	RESERVE_BTREE = 0,
	RESERVE_PRIO = 1,
	RESERVE_MOVINGGC = 2,
	RESERVE_NONE = 3,
	RESERVE_NR = 4,
};

enum amd_functions {
	IMX_F0_GPIO0 = 0,
	IMX_F1_GPIO0 = 1,
	IMX_F2_GPIO0 = 2,
	IMX_F3_GPIO0 = 3,
	IMX_F0_GPIO1 = 4,
	IMX_F1_GPIO1 = 5,
	IMX_F2_GPIO1 = 6,
	IMX_F3_GPIO1 = 7,
	IMX_F0_GPIO2 = 8,
	IMX_F1_GPIO2 = 9,
	IMX_F2_GPIO2 = 10,
	IMX_F3_GPIO2 = 11,
	IMX_F0_GPIO3 = 12,
	IMX_F1_GPIO3 = 13,
	IMX_F2_GPIO3 = 14,
	IMX_F3_GPIO3 = 15,
	IMX_F0_GPIO4 = 16,
	IMX_F1_GPIO4 = 17,
	IMX_F2_GPIO4 = 18,
	IMX_F3_GPIO4 = 19,
	IMX_F0_GPIO5 = 20,
	IMX_F1_GPIO5 = 21,
	IMX_F2_GPIO5 = 22,
	IMX_F3_GPIO5 = 23,
	IMX_F0_GPIO6 = 24,
	IMX_F1_GPIO6 = 25,
	IMX_F2_GPIO6 = 26,
	IMX_F3_GPIO6 = 27,
	IMX_F0_GPIO7 = 28,
	IMX_F1_GPIO7 = 29,
	IMX_F2_GPIO7 = 30,
	IMX_F3_GPIO7 = 31,
	IMX_F0_GPIO8 = 32,
	IMX_F1_GPIO8 = 33,
	IMX_F2_GPIO8 = 34,
	IMX_F3_GPIO8 = 35,
	IMX_F0_GPIO9 = 36,
	IMX_F1_GPIO9 = 37,
	IMX_F2_GPIO9 = 38,
	IMX_F3_GPIO9 = 39,
	IMX_F0_GPIO10 = 40,
	IMX_F1_GPIO10 = 41,
	IMX_F2_GPIO10 = 42,
	IMX_F3_GPIO10 = 43,
	IMX_F0_GPIO11 = 44,
	IMX_F1_GPIO11 = 45,
	IMX_F2_GPIO11 = 46,
	IMX_F3_GPIO11 = 47,
	IMX_F0_GPIO12 = 48,
	IMX_F1_GPIO12 = 49,
	IMX_F2_GPIO12 = 50,
	IMX_F3_GPIO12 = 51,
	IMX_F0_GPIO13 = 52,
	IMX_F1_GPIO13 = 53,
	IMX_F2_GPIO13 = 54,
	IMX_F3_GPIO13 = 55,
	IMX_F0_GPIO14 = 56,
	IMX_F1_GPIO14 = 57,
	IMX_F2_GPIO14 = 58,
	IMX_F3_GPIO14 = 59,
	IMX_F0_GPIO15 = 60,
	IMX_F1_GPIO15 = 61,
	IMX_F2_GPIO15 = 62,
	IMX_F3_GPIO15 = 63,
	IMX_F0_GPIO16 = 64,
	IMX_F1_GPIO16 = 65,
	IMX_F2_GPIO16 = 66,
	IMX_F3_GPIO16 = 67,
	IMX_F0_GPIO17 = 68,
	IMX_F1_GPIO17 = 69,
	IMX_F2_GPIO17 = 70,
	IMX_F3_GPIO17 = 71,
	IMX_F0_GPIO18 = 72,
	IMX_F1_GPIO18 = 73,
	IMX_F2_GPIO18 = 74,
	IMX_F3_GPIO18 = 75,
	IMX_F0_GPIO19 = 76,
	IMX_F1_GPIO19 = 77,
	IMX_F2_GPIO19 = 78,
	IMX_F3_GPIO19 = 79,
	IMX_F0_GPIO20 = 80,
	IMX_F1_GPIO20 = 81,
	IMX_F2_GPIO20 = 82,
	IMX_F3_GPIO20 = 83,
	IMX_F0_GPIO21 = 84,
	IMX_F1_GPIO21 = 85,
	IMX_F2_GPIO21 = 86,
	IMX_F3_GPIO21 = 87,
	IMX_F0_GPIO22 = 88,
	IMX_F1_GPIO22 = 89,
	IMX_F2_GPIO22 = 90,
	IMX_F3_GPIO22 = 91,
	IMX_F0_GPIO23 = 92,
	IMX_F1_GPIO23 = 93,
	IMX_F2_GPIO23 = 94,
	IMX_F3_GPIO23 = 95,
	IMX_F0_GPIO24 = 96,
	IMX_F1_GPIO24 = 97,
	IMX_F2_GPIO24 = 98,
	IMX_F3_GPIO24 = 99,
	IMX_F0_GPIO25 = 100,
	IMX_F1_GPIO25 = 101,
	IMX_F2_GPIO25 = 102,
	IMX_F3_GPIO25 = 103,
	IMX_F0_GPIO26 = 104,
	IMX_F1_GPIO26 = 105,
	IMX_F2_GPIO26 = 106,
	IMX_F3_GPIO26 = 107,
	IMX_F0_GPIO27 = 108,
	IMX_F1_GPIO27 = 109,
	IMX_F2_GPIO27 = 110,
	IMX_F3_GPIO27 = 111,
	IMX_F0_GPIO28 = 112,
	IMX_F1_GPIO28 = 113,
	IMX_F2_GPIO28 = 114,
	IMX_F3_GPIO28 = 115,
	IMX_F0_GPIO29 = 116,
	IMX_F1_GPIO29 = 117,
	IMX_F2_GPIO29 = 118,
	IMX_F3_GPIO29 = 119,
	IMX_F0_GPIO30 = 120,
	IMX_F1_GPIO30 = 121,
	IMX_F2_GPIO30 = 122,
	IMX_F3_GPIO30 = 123,
	IMX_F0_GPIO31 = 124,
	IMX_F1_GPIO31 = 125,
	IMX_F2_GPIO31 = 126,
	IMX_F3_GPIO31 = 127,
	IMX_F0_GPIO32 = 128,
	IMX_F1_GPIO32 = 129,
	IMX_F2_GPIO32 = 130,
	IMX_F3_GPIO32 = 131,
	IMX_F0_GPIO33 = 132,
	IMX_F1_GPIO33 = 133,
	IMX_F2_GPIO33 = 134,
	IMX_F3_GPIO33 = 135,
	IMX_F0_GPIO34 = 136,
	IMX_F1_GPIO34 = 137,
	IMX_F2_GPIO34 = 138,
	IMX_F3_GPIO34 = 139,
	IMX_F0_GPIO35 = 140,
	IMX_F1_GPIO35 = 141,
	IMX_F2_GPIO35 = 142,
	IMX_F3_GPIO35 = 143,
	IMX_F0_GPIO36 = 144,
	IMX_F1_GPIO36 = 145,
	IMX_F2_GPIO36 = 146,
	IMX_F3_GPIO36 = 147,
	IMX_F0_GPIO37 = 148,
	IMX_F1_GPIO37 = 149,
	IMX_F2_GPIO37 = 150,
	IMX_F3_GPIO37 = 151,
	IMX_F0_GPIO38 = 152,
	IMX_F1_GPIO38 = 153,
	IMX_F2_GPIO38 = 154,
	IMX_F3_GPIO38 = 155,
	IMX_F0_GPIO39 = 156,
	IMX_F1_GPIO39 = 157,
	IMX_F2_GPIO39 = 158,
	IMX_F3_GPIO39 = 159,
	IMX_F0_GPIO40 = 160,
	IMX_F1_GPIO40 = 161,
	IMX_F2_GPIO40 = 162,
	IMX_F3_GPIO40 = 163,
	IMX_F0_GPIO41 = 164,
	IMX_F1_GPIO41 = 165,
	IMX_F2_GPIO41 = 166,
	IMX_F3_GPIO41 = 167,
	IMX_F0_GPIO42 = 168,
	IMX_F1_GPIO42 = 169,
	IMX_F2_GPIO42 = 170,
	IMX_F3_GPIO42 = 171,
	IMX_F0_GPIO43 = 172,
	IMX_F1_GPIO43 = 173,
	IMX_F2_GPIO43 = 174,
	IMX_F3_GPIO43 = 175,
	IMX_F0_GPIO44 = 176,
	IMX_F1_GPIO44 = 177,
	IMX_F2_GPIO44 = 178,
	IMX_F3_GPIO44 = 179,
	IMX_F0_GPIO45 = 180,
	IMX_F1_GPIO45 = 181,
	IMX_F2_GPIO45 = 182,
	IMX_F3_GPIO45 = 183,
	IMX_F0_GPIO46 = 184,
	IMX_F1_GPIO46 = 185,
	IMX_F2_GPIO46 = 186,
	IMX_F3_GPIO46 = 187,
	IMX_F0_GPIO47 = 188,
	IMX_F1_GPIO47 = 189,
	IMX_F2_GPIO47 = 190,
	IMX_F3_GPIO47 = 191,
	IMX_F0_GPIO48 = 192,
	IMX_F1_GPIO48 = 193,
	IMX_F2_GPIO48 = 194,
	IMX_F3_GPIO48 = 195,
	IMX_F0_GPIO49 = 196,
	IMX_F1_GPIO49 = 197,
	IMX_F2_GPIO49 = 198,
	IMX_F3_GPIO49 = 199,
	IMX_F0_GPIO50 = 200,
	IMX_F1_GPIO50 = 201,
	IMX_F2_GPIO50 = 202,
	IMX_F3_GPIO50 = 203,
	IMX_F0_GPIO51 = 204,
	IMX_F1_GPIO51 = 205,
	IMX_F2_GPIO51 = 206,
	IMX_F3_GPIO51 = 207,
	IMX_F0_GPIO52 = 208,
	IMX_F1_GPIO52 = 209,
	IMX_F2_GPIO52 = 210,
	IMX_F3_GPIO52 = 211,
	IMX_F0_GPIO53 = 212,
	IMX_F1_GPIO53 = 213,
	IMX_F2_GPIO53 = 214,
	IMX_F3_GPIO53 = 215,
	IMX_F0_GPIO54 = 216,
	IMX_F1_GPIO54 = 217,
	IMX_F2_GPIO54 = 218,
	IMX_F3_GPIO54 = 219,
	IMX_F0_GPIO55 = 220,
	IMX_F1_GPIO55 = 221,
	IMX_F2_GPIO55 = 222,
	IMX_F3_GPIO55 = 223,
	IMX_F0_GPIO56 = 224,
	IMX_F1_GPIO56 = 225,
	IMX_F2_GPIO56 = 226,
	IMX_F3_GPIO56 = 227,
	IMX_F0_GPIO57 = 228,
	IMX_F1_GPIO57 = 229,
	IMX_F2_GPIO57 = 230,
	IMX_F3_GPIO57 = 231,
	IMX_F0_GPIO58 = 232,
	IMX_F1_GPIO58 = 233,
	IMX_F2_GPIO58 = 234,
	IMX_F3_GPIO58 = 235,
	IMX_F0_GPIO59 = 236,
	IMX_F1_GPIO59 = 237,
	IMX_F2_GPIO59 = 238,
	IMX_F3_GPIO59 = 239,
	IMX_F0_GPIO60 = 240,
	IMX_F1_GPIO60 = 241,
	IMX_F2_GPIO60 = 242,
	IMX_F3_GPIO60 = 243,
	IMX_F0_GPIO61 = 244,
	IMX_F1_GPIO61 = 245,
	IMX_F2_GPIO61 = 246,
	IMX_F3_GPIO61 = 247,
	IMX_F0_GPIO62 = 248,
	IMX_F1_GPIO62 = 249,
	IMX_F2_GPIO62 = 250,
	IMX_F3_GPIO62 = 251,
	IMX_F0_GPIO64 = 252,
	IMX_F1_GPIO64 = 253,
	IMX_F2_GPIO64 = 254,
	IMX_F3_GPIO64 = 255,
	IMX_F0_GPIO65 = 256,
	IMX_F1_GPIO65 = 257,
	IMX_F2_GPIO65 = 258,
	IMX_F3_GPIO65 = 259,
	IMX_F0_GPIO66 = 260,
	IMX_F1_GPIO66 = 261,
	IMX_F2_GPIO66 = 262,
	IMX_F3_GPIO66 = 263,
	IMX_F0_GPIO67 = 264,
	IMX_F1_GPIO67 = 265,
	IMX_F2_GPIO67 = 266,
	IMX_F3_GPIO67 = 267,
	IMX_F0_GPIO68 = 268,
	IMX_F1_GPIO68 = 269,
	IMX_F2_GPIO68 = 270,
	IMX_F3_GPIO68 = 271,
	IMX_F0_GPIO69 = 272,
	IMX_F1_GPIO69 = 273,
	IMX_F2_GPIO69 = 274,
	IMX_F3_GPIO69 = 275,
	IMX_F0_GPIO70 = 276,
	IMX_F1_GPIO70 = 277,
	IMX_F2_GPIO70 = 278,
	IMX_F3_GPIO70 = 279,
	IMX_F0_GPIO71 = 280,
	IMX_F1_GPIO71 = 281,
	IMX_F2_GPIO71 = 282,
	IMX_F3_GPIO71 = 283,
	IMX_F0_GPIO72 = 284,
	IMX_F1_GPIO72 = 285,
	IMX_F2_GPIO72 = 286,
	IMX_F3_GPIO72 = 287,
	IMX_F0_GPIO73 = 288,
	IMX_F1_GPIO73 = 289,
	IMX_F2_GPIO73 = 290,
	IMX_F3_GPIO73 = 291,
	IMX_F0_GPIO74 = 292,
	IMX_F1_GPIO74 = 293,
	IMX_F2_GPIO74 = 294,
	IMX_F3_GPIO74 = 295,
	IMX_F0_GPIO75 = 296,
	IMX_F1_GPIO75 = 297,
	IMX_F2_GPIO75 = 298,
	IMX_F3_GPIO75 = 299,
	IMX_F0_GPIO76 = 300,
	IMX_F1_GPIO76 = 301,
	IMX_F2_GPIO76 = 302,
	IMX_F3_GPIO76 = 303,
	IMX_F0_GPIO77 = 304,
	IMX_F1_GPIO77 = 305,
	IMX_F2_GPIO77 = 306,
	IMX_F3_GPIO77 = 307,
	IMX_F0_GPIO78 = 308,
	IMX_F1_GPIO78 = 309,
	IMX_F2_GPIO78 = 310,
	IMX_F3_GPIO78 = 311,
	IMX_F0_GPIO79 = 312,
	IMX_F1_GPIO79 = 313,
	IMX_F2_GPIO79 = 314,
	IMX_F3_GPIO79 = 315,
	IMX_F0_GPIO80 = 316,
	IMX_F1_GPIO80 = 317,
	IMX_F2_GPIO80 = 318,
	IMX_F3_GPIO80 = 319,
	IMX_F0_GPIO81 = 320,
	IMX_F1_GPIO81 = 321,
	IMX_F2_GPIO81 = 322,
	IMX_F3_GPIO81 = 323,
	IMX_F0_GPIO82 = 324,
	IMX_F1_GPIO82 = 325,
	IMX_F2_GPIO82 = 326,
	IMX_F3_GPIO82 = 327,
	IMX_F0_GPIO83 = 328,
	IMX_F1_GPIO83 = 329,
	IMX_F2_GPIO83 = 330,
	IMX_F3_GPIO83 = 331,
	IMX_F0_GPIO84 = 332,
	IMX_F1_GPIO84 = 333,
	IMX_F2_GPIO84 = 334,
	IMX_F3_GPIO84 = 335,
	IMX_F0_GPIO85 = 336,
	IMX_F1_GPIO85 = 337,
	IMX_F2_GPIO85 = 338,
	IMX_F3_GPIO85 = 339,
	IMX_F0_GPIO86 = 340,
	IMX_F1_GPIO86 = 341,
	IMX_F2_GPIO86 = 342,
	IMX_F3_GPIO86 = 343,
	IMX_F0_GPIO87 = 344,
	IMX_F1_GPIO87 = 345,
	IMX_F2_GPIO87 = 346,
	IMX_F3_GPIO87 = 347,
	IMX_F0_GPIO88 = 348,
	IMX_F1_GPIO88 = 349,
	IMX_F2_GPIO88 = 350,
	IMX_F3_GPIO88 = 351,
	IMX_F0_GPIO89 = 352,
	IMX_F1_GPIO89 = 353,
	IMX_F2_GPIO89 = 354,
	IMX_F3_GPIO89 = 355,
	IMX_F0_GPIO90 = 356,
	IMX_F1_GPIO90 = 357,
	IMX_F2_GPIO90 = 358,
	IMX_F3_GPIO90 = 359,
	IMX_F0_GPIO91 = 360,
	IMX_F1_GPIO91 = 361,
	IMX_F2_GPIO91 = 362,
	IMX_F3_GPIO91 = 363,
	IMX_F0_GPIO92 = 364,
	IMX_F1_GPIO92 = 365,
	IMX_F2_GPIO92 = 366,
	IMX_F3_GPIO92 = 367,
	IMX_F0_GPIO93 = 368,
	IMX_F1_GPIO93 = 369,
	IMX_F2_GPIO93 = 370,
	IMX_F3_GPIO93 = 371,
	IMX_F0_GPIO94 = 372,
	IMX_F1_GPIO94 = 373,
	IMX_F2_GPIO94 = 374,
	IMX_F3_GPIO94 = 375,
	IMX_F0_GPIO95 = 376,
	IMX_F1_GPIO95 = 377,
	IMX_F2_GPIO95 = 378,
	IMX_F3_GPIO95 = 379,
	IMX_F0_GPIO96 = 380,
	IMX_F1_GPIO96 = 381,
	IMX_F2_GPIO96 = 382,
	IMX_F3_GPIO96 = 383,
	IMX_F0_GPIO97 = 384,
	IMX_F1_GPIO97 = 385,
	IMX_F2_GPIO97 = 386,
	IMX_F3_GPIO97 = 387,
	IMX_F0_GPIO98 = 388,
	IMX_F1_GPIO98 = 389,
	IMX_F2_GPIO98 = 390,
	IMX_F3_GPIO98 = 391,
	IMX_F0_GPIO99 = 392,
	IMX_F1_GPIO99 = 393,
	IMX_F2_GPIO99 = 394,
	IMX_F3_GPIO99 = 395,
	IMX_F0_GPIO100 = 396,
	IMX_F1_GPIO100 = 397,
	IMX_F2_GPIO100 = 398,
	IMX_F3_GPIO100 = 399,
	IMX_F0_GPIO101 = 400,
	IMX_F1_GPIO101 = 401,
	IMX_F2_GPIO101 = 402,
	IMX_F3_GPIO101 = 403,
	IMX_F0_GPIO102 = 404,
	IMX_F1_GPIO102 = 405,
	IMX_F2_GPIO102 = 406,
	IMX_F3_GPIO102 = 407,
	IMX_F0_GPIO103 = 408,
	IMX_F1_GPIO103 = 409,
	IMX_F2_GPIO103 = 410,
	IMX_F3_GPIO103 = 411,
	IMX_F0_GPIO104 = 412,
	IMX_F1_GPIO104 = 413,
	IMX_F2_GPIO104 = 414,
	IMX_F3_GPIO104 = 415,
	IMX_F0_GPIO105 = 416,
	IMX_F1_GPIO105 = 417,
	IMX_F2_GPIO105 = 418,
	IMX_F3_GPIO105 = 419,
	IMX_F0_GPIO106 = 420,
	IMX_F1_GPIO106 = 421,
	IMX_F2_GPIO106 = 422,
	IMX_F3_GPIO106 = 423,
	IMX_F0_GPIO107 = 424,
	IMX_F1_GPIO107 = 425,
	IMX_F2_GPIO107 = 426,
	IMX_F3_GPIO107 = 427,
	IMX_F0_GPIO108 = 428,
	IMX_F1_GPIO108 = 429,
	IMX_F2_GPIO108 = 430,
	IMX_F3_GPIO108 = 431,
	IMX_F0_GPIO109 = 432,
	IMX_F1_GPIO109 = 433,
	IMX_F2_GPIO109 = 434,
	IMX_F3_GPIO109 = 435,
	IMX_F0_GPIO110 = 436,
	IMX_F1_GPIO110 = 437,
	IMX_F2_GPIO110 = 438,
	IMX_F3_GPIO110 = 439,
	IMX_F0_GPIO111 = 440,
	IMX_F1_GPIO111 = 441,
	IMX_F2_GPIO111 = 442,
	IMX_F3_GPIO111 = 443,
	IMX_F0_GPIO112 = 444,
	IMX_F1_GPIO112 = 445,
	IMX_F2_GPIO112 = 446,
	IMX_F3_GPIO112 = 447,
	IMX_F0_GPIO113 = 448,
	IMX_F1_GPIO113 = 449,
	IMX_F2_GPIO113 = 450,
	IMX_F3_GPIO113 = 451,
	IMX_F0_GPIO114 = 452,
	IMX_F1_GPIO114 = 453,
	IMX_F2_GPIO114 = 454,
	IMX_F3_GPIO114 = 455,
	IMX_F0_GPIO115 = 456,
	IMX_F1_GPIO115 = 457,
	IMX_F2_GPIO115 = 458,
	IMX_F3_GPIO115 = 459,
	IMX_F0_GPIO116 = 460,
	IMX_F1_GPIO116 = 461,
	IMX_F2_GPIO116 = 462,
	IMX_F3_GPIO116 = 463,
	IMX_F0_GPIO117 = 464,
	IMX_F1_GPIO117 = 465,
	IMX_F2_GPIO117 = 466,
	IMX_F3_GPIO117 = 467,
	IMX_F0_GPIO118 = 468,
	IMX_F1_GPIO118 = 469,
	IMX_F2_GPIO118 = 470,
	IMX_F3_GPIO118 = 471,
	IMX_F0_GPIO119 = 472,
	IMX_F1_GPIO119 = 473,
	IMX_F2_GPIO119 = 474,
	IMX_F3_GPIO119 = 475,
	IMX_F0_GPIO120 = 476,
	IMX_F1_GPIO120 = 477,
	IMX_F2_GPIO120 = 478,
	IMX_F3_GPIO120 = 479,
	IMX_F0_GPIO121 = 480,
	IMX_F1_GPIO121 = 481,
	IMX_F2_GPIO121 = 482,
	IMX_F3_GPIO121 = 483,
	IMX_F0_GPIO122 = 484,
	IMX_F1_GPIO122 = 485,
	IMX_F2_GPIO122 = 486,
	IMX_F3_GPIO122 = 487,
	IMX_F0_GPIO123 = 488,
	IMX_F1_GPIO123 = 489,
	IMX_F2_GPIO123 = 490,
	IMX_F3_GPIO123 = 491,
	IMX_F0_GPIO124 = 492,
	IMX_F1_GPIO124 = 493,
	IMX_F2_GPIO124 = 494,
	IMX_F3_GPIO124 = 495,
	IMX_F0_GPIO125 = 496,
	IMX_F1_GPIO125 = 497,
	IMX_F2_GPIO125 = 498,
	IMX_F3_GPIO125 = 499,
	IMX_F0_GPIO126 = 500,
	IMX_F1_GPIO126 = 501,
	IMX_F2_GPIO126 = 502,
	IMX_F3_GPIO126 = 503,
	IMX_F0_GPIO127 = 504,
	IMX_F1_GPIO127 = 505,
	IMX_F2_GPIO127 = 506,
	IMX_F3_GPIO127 = 507,
	IMX_F0_GPIO128 = 508,
	IMX_F1_GPIO128 = 509,
	IMX_F2_GPIO128 = 510,
	IMX_F3_GPIO128 = 511,
	IMX_F0_GPIO129 = 512,
	IMX_F1_GPIO129 = 513,
	IMX_F2_GPIO129 = 514,
	IMX_F3_GPIO129 = 515,
	IMX_F0_GPIO130 = 516,
	IMX_F1_GPIO130 = 517,
	IMX_F2_GPIO130 = 518,
	IMX_F3_GPIO130 = 519,
	IMX_F0_GPIO131 = 520,
	IMX_F1_GPIO131 = 521,
	IMX_F2_GPIO131 = 522,
	IMX_F3_GPIO131 = 523,
	IMX_F0_GPIO132 = 524,
	IMX_F1_GPIO132 = 525,
	IMX_F2_GPIO132 = 526,
	IMX_F3_GPIO132 = 527,
	IMX_F0_GPIO133 = 528,
	IMX_F1_GPIO133 = 529,
	IMX_F2_GPIO133 = 530,
	IMX_F3_GPIO133 = 531,
	IMX_F0_GPIO134 = 532,
	IMX_F1_GPIO134 = 533,
	IMX_F2_GPIO134 = 534,
	IMX_F3_GPIO134 = 535,
	IMX_F0_GPIO135 = 536,
	IMX_F1_GPIO135 = 537,
	IMX_F2_GPIO135 = 538,
	IMX_F3_GPIO135 = 539,
	IMX_F0_GPIO136 = 540,
	IMX_F1_GPIO136 = 541,
	IMX_F2_GPIO136 = 542,
	IMX_F3_GPIO136 = 543,
	IMX_F0_GPIO137 = 544,
	IMX_F1_GPIO137 = 545,
	IMX_F2_GPIO137 = 546,
	IMX_F3_GPIO137 = 547,
	IMX_F0_GPIO138 = 548,
	IMX_F1_GPIO138 = 549,
	IMX_F2_GPIO138 = 550,
	IMX_F3_GPIO138 = 551,
	IMX_F0_GPIO139 = 552,
	IMX_F1_GPIO139 = 553,
	IMX_F2_GPIO139 = 554,
	IMX_F3_GPIO139 = 555,
	IMX_F0_GPIO140 = 556,
	IMX_F1_GPIO140 = 557,
	IMX_F2_GPIO140 = 558,
	IMX_F3_GPIO140 = 559,
	IMX_F0_GPIO141 = 560,
	IMX_F1_GPIO141 = 561,
	IMX_F2_GPIO141 = 562,
	IMX_F3_GPIO141 = 563,
	IMX_F0_GPIO142 = 564,
	IMX_F1_GPIO142 = 565,
	IMX_F2_GPIO142 = 566,
	IMX_F3_GPIO142 = 567,
	IMX_F0_GPIO143 = 568,
	IMX_F1_GPIO143 = 569,
	IMX_F2_GPIO143 = 570,
	IMX_F3_GPIO143 = 571,
	IMX_F0_GPIO144 = 572,
	IMX_F1_GPIO144 = 573,
	IMX_F2_GPIO144 = 574,
	IMX_F3_GPIO144 = 575,
};

enum arch_timer_erratum_match_type {
	ate_match_dt = 0,
	ate_match_local_cap_id = 1,
	ate_match_acpi_oem_info = 2,
};

enum arch_timer_ppi_nr {
	ARCH_TIMER_PHYS_SECURE_PPI = 0,
	ARCH_TIMER_PHYS_NONSECURE_PPI = 1,
	ARCH_TIMER_VIRT_PPI = 2,
	ARCH_TIMER_HYP_PPI = 3,
	ARCH_TIMER_HYP_VIRT_PPI = 4,
	ARCH_TIMER_MAX_TIMER_PPI = 5,
};

enum arch_timer_reg {
	ARCH_TIMER_REG_CTRL = 0,
	ARCH_TIMER_REG_CVAL = 1,
};

enum arch_timer_spi_nr {
	ARCH_TIMER_PHYS_SPI = 0,
	ARCH_TIMER_VIRT_SPI = 1,
	ARCH_TIMER_MAX_TIMER_SPI = 2,
};

enum arm64_bp_harden_el1_vectors {
	EL1_VECTOR_BHB_LOOP = 0,
	EL1_VECTOR_BHB_FW = 1,
	EL1_VECTOR_BHB_CLEAR_INSN = 2,
	EL1_VECTOR_KPTI = 3,
};

enum arm64_hyp_spectre_vector {
	HYP_VECTOR_DIRECT = 0,
	HYP_VECTOR_SPECTRE_DIRECT = 1,
	HYP_VECTOR_INDIRECT = 2,
	HYP_VECTOR_SPECTRE_INDIRECT = 3,
};

enum arm_smccc_conduit {
	SMCCC_CONDUIT_NONE = 0,
	SMCCC_CONDUIT_SMC = 1,
	SMCCC_CONDUIT_HVC = 2,
};

enum arm_smmu_arch_version {
	ARM_SMMU_V1 = 0,
	ARM_SMMU_V1_64K = 1,
	ARM_SMMU_V2 = 2,
};

enum arm_smmu_cbar_type {
	CBAR_TYPE_S2_TRANS = 0,
	CBAR_TYPE_S1_TRANS_S2_BYPASS = 1,
	CBAR_TYPE_S1_TRANS_S2_FAULT = 2,
	CBAR_TYPE_S1_TRANS_S2_TRANS = 3,
};

enum arm_smmu_context_fmt {
	ARM_SMMU_CTX_FMT_NONE = 0,
	ARM_SMMU_CTX_FMT_AARCH64 = 1,
	ARM_SMMU_CTX_FMT_AARCH32_L = 2,
	ARM_SMMU_CTX_FMT_AARCH32_S = 3,
};

enum arm_smmu_domain_stage {
	ARM_SMMU_DOMAIN_S1 = 0,
	ARM_SMMU_DOMAIN_S2 = 1,
};

enum arm_smmu_domain_stage___2 {
	ARM_SMMU_DOMAIN_S1___2 = 0,
	ARM_SMMU_DOMAIN_S2___2 = 1,
	ARM_SMMU_DOMAIN_NESTED = 2,
};

enum arm_smmu_implementation {
	GENERIC_SMMU = 0,
	ARM_MMU500 = 1,
	CAVIUM_SMMUV2 = 2,
	QCOM_SMMUV2 = 3,
};

enum arm_smmu_msi_index {
	EVTQ_MSI_INDEX = 0,
	GERROR_MSI_INDEX = 1,
	PRIQ_MSI_INDEX = 2,
	ARM_SMMU_MAX_MSIS = 3,
};

enum arm_smmu_s2cr_privcfg {
	S2CR_PRIVCFG_DEFAULT = 0,
	S2CR_PRIVCFG_DIPAN = 1,
	S2CR_PRIVCFG_UNPRIV = 2,
	S2CR_PRIVCFG_PRIV = 3,
};

enum arm_smmu_s2cr_type {
	S2CR_TYPE_TRANS = 0,
	S2CR_TYPE_BYPASS = 1,
	S2CR_TYPE_FAULT = 2,
};

enum armpmu_attr_groups {
	ARMPMU_ATTR_GROUP_COMMON = 0,
	ARMPMU_ATTR_GROUP_EVENTS = 1,
	ARMPMU_ATTR_GROUP_FORMATS = 2,
	ARMPMU_ATTR_GROUP_CAPS = 3,
	ARMPMU_NR_ATTR_GROUPS = 4,
};

enum array_state {
	clear = 0,
	inactive = 1,
	suspended = 2,
	readonly = 3,
	read_auto = 4,
	clean = 5,
	active = 6,
	write_pending = 7,
	active_idle = 8,
	broken = 9,
	bad_word = 10,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum asp_netfilt_reg_type {
	ASP_NETFILT_MATCH = 0,
	ASP_NETFILT_MASK = 1,
	ASP_NETFILT_MAX = 2,
};

enum asp_rx_filter_id {
	ASP_RX_FILTER_MDA_PROMISC = 0,
	ASP_RX_FILTER_MDA_ALLMULTI = 1,
	ASP_RX_FILTER_MDA_BROADCAST = 2,
	ASP_RX_FILTER_MDA_OWN_ADDR = 3,
	ASP_RX_FILTER_MDA_RES_MAX = 4,
};

enum asp_rx_net_filter_block {
	ASP_RX_FILTER_NET_L2 = 0,
	ASP_RX_FILTER_NET_L3_0 = 1,
	ASP_RX_FILTER_NET_L3_1 = 2,
	ASP_RX_FILTER_NET_L4 = 3,
	ASP_RX_FILTER_NET_BLOCK_MAX = 4,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_ID_DEV_LOG = 27,
	__ATA_QUIRK_NO_LOG_DIR = 28,
	__ATA_QUIRK_NO_FUA = 29,
	__ATA_QUIRK_MAX = 30,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp15060_irqs {
	AXP15060_IRQ_DIE_TEMP_HIGH_LV1 = 1,
	AXP15060_IRQ_DIE_TEMP_HIGH_LV2 = 2,
	AXP15060_IRQ_DCDC1_V_LOW = 3,
	AXP15060_IRQ_DCDC2_V_LOW = 4,
	AXP15060_IRQ_DCDC3_V_LOW = 5,
	AXP15060_IRQ_DCDC4_V_LOW = 6,
	AXP15060_IRQ_DCDC5_V_LOW = 7,
	AXP15060_IRQ_DCDC6_V_LOW = 8,
	AXP15060_IRQ_PEK_LONG = 9,
	AXP15060_IRQ_PEK_SHORT = 10,
	AXP15060_IRQ_GPIO1_INPUT = 11,
	AXP15060_IRQ_PEK_FAL_EDGE = 12,
	AXP15060_IRQ_PEK_RIS_EDGE = 13,
	AXP15060_IRQ_GPIO2_INPUT = 14,
};

enum axp192_irqs {
	AXP192_IRQ_ACIN_OVER_V = 1,
	AXP192_IRQ_ACIN_PLUGIN = 2,
	AXP192_IRQ_ACIN_REMOVAL = 3,
	AXP192_IRQ_VBUS_OVER_V = 4,
	AXP192_IRQ_VBUS_PLUGIN = 5,
	AXP192_IRQ_VBUS_REMOVAL = 6,
	AXP192_IRQ_VBUS_V_LOW = 7,
	AXP192_IRQ_BATT_PLUGIN = 8,
	AXP192_IRQ_BATT_REMOVAL = 9,
	AXP192_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP192_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP192_IRQ_CHARG = 12,
	AXP192_IRQ_CHARG_DONE = 13,
	AXP192_IRQ_BATT_TEMP_HIGH = 14,
	AXP192_IRQ_BATT_TEMP_LOW = 15,
	AXP192_IRQ_DIE_TEMP_HIGH = 16,
	AXP192_IRQ_CHARG_I_LOW = 17,
	AXP192_IRQ_DCDC1_V_LONG = 18,
	AXP192_IRQ_DCDC2_V_LONG = 19,
	AXP192_IRQ_DCDC3_V_LONG = 20,
	AXP192_IRQ_PEK_SHORT = 22,
	AXP192_IRQ_PEK_LONG = 23,
	AXP192_IRQ_N_OE_PWR_ON = 24,
	AXP192_IRQ_N_OE_PWR_OFF = 25,
	AXP192_IRQ_VBUS_VALID = 26,
	AXP192_IRQ_VBUS_NOT_VALID = 27,
	AXP192_IRQ_VBUS_SESS_VALID = 28,
	AXP192_IRQ_VBUS_SESS_END = 29,
	AXP192_IRQ_LOW_PWR_LVL = 31,
	AXP192_IRQ_TIMER = 32,
	AXP192_IRQ_GPIO2_INPUT = 37,
	AXP192_IRQ_GPIO1_INPUT = 38,
	AXP192_IRQ_GPIO0_INPUT = 39,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP323_ID = 8,
	AXP717_ID = 9,
	AXP803_ID = 10,
	AXP806_ID = 11,
	AXP809_ID = 12,
	AXP813_ID = 13,
	AXP15060_ID = 14,
	NR_AXP20X_VARIANTS = 15,
};

enum axp22x_irqs {
	AXP22X_IRQ_ACIN_OVER_V = 1,
	AXP22X_IRQ_ACIN_PLUGIN = 2,
	AXP22X_IRQ_ACIN_REMOVAL = 3,
	AXP22X_IRQ_VBUS_OVER_V = 4,
	AXP22X_IRQ_VBUS_PLUGIN = 5,
	AXP22X_IRQ_VBUS_REMOVAL = 6,
	AXP22X_IRQ_VBUS_V_LOW = 7,
	AXP22X_IRQ_BATT_PLUGIN = 8,
	AXP22X_IRQ_BATT_REMOVAL = 9,
	AXP22X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP22X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP22X_IRQ_CHARG = 12,
	AXP22X_IRQ_CHARG_DONE = 13,
	AXP22X_IRQ_BATT_TEMP_HIGH = 14,
	AXP22X_IRQ_BATT_TEMP_LOW = 15,
	AXP22X_IRQ_DIE_TEMP_HIGH = 16,
	AXP22X_IRQ_PEK_SHORT = 17,
	AXP22X_IRQ_PEK_LONG = 18,
	AXP22X_IRQ_LOW_PWR_LVL1 = 19,
	AXP22X_IRQ_LOW_PWR_LVL2 = 20,
	AXP22X_IRQ_TIMER = 21,
	AXP22X_IRQ_PEK_FAL_EDGE = 22,
	AXP22X_IRQ_PEK_RIS_EDGE = 23,
	AXP22X_IRQ_GPIO1_INPUT = 24,
	AXP22X_IRQ_GPIO0_INPUT = 25,
};

enum axp288_irqs {
	AXP288_IRQ_VBUS_FALL = 2,
	AXP288_IRQ_VBUS_RISE = 3,
	AXP288_IRQ_OV = 4,
	AXP288_IRQ_FALLING_ALT = 5,
	AXP288_IRQ_RISING_ALT = 6,
	AXP288_IRQ_OV_ALT = 7,
	AXP288_IRQ_DONE = 10,
	AXP288_IRQ_CHARGING = 11,
	AXP288_IRQ_SAFE_QUIT = 12,
	AXP288_IRQ_SAFE_ENTER = 13,
	AXP288_IRQ_ABSENT = 14,
	AXP288_IRQ_APPEND = 15,
	AXP288_IRQ_QWBTU = 16,
	AXP288_IRQ_WBTU = 17,
	AXP288_IRQ_QWBTO = 18,
	AXP288_IRQ_WBTO = 19,
	AXP288_IRQ_QCBTU = 20,
	AXP288_IRQ_CBTU = 21,
	AXP288_IRQ_QCBTO = 22,
	AXP288_IRQ_CBTO = 23,
	AXP288_IRQ_WL2 = 24,
	AXP288_IRQ_WL1 = 25,
	AXP288_IRQ_GPADC = 26,
	AXP288_IRQ_OT = 31,
	AXP288_IRQ_GPIO0 = 32,
	AXP288_IRQ_GPIO1 = 33,
	AXP288_IRQ_POKO = 34,
	AXP288_IRQ_POKL = 35,
	AXP288_IRQ_POKS = 36,
	AXP288_IRQ_POKN = 37,
	AXP288_IRQ_POKP = 38,
	AXP288_IRQ_TIMER = 39,
	AXP288_IRQ_MV_CHNG = 40,
	AXP288_IRQ_BC_USB_CHNG = 41,
};

enum axp313a_irqs {
	AXP313A_IRQ_DIE_TEMP_HIGH = 0,
	AXP313A_IRQ_DCDC2_V_LOW = 2,
	AXP313A_IRQ_DCDC3_V_LOW = 3,
	AXP313A_IRQ_PEK_LONG = 4,
	AXP313A_IRQ_PEK_SHORT = 5,
	AXP313A_IRQ_PEK_FAL_EDGE = 6,
	AXP313A_IRQ_PEK_RIS_EDGE = 7,
};

enum axp717_irqs {
	AXP717_IRQ_VBUS_FAULT = 0,
	AXP717_IRQ_VBUS_OVER_V = 1,
	AXP717_IRQ_BOOST_OVER_V = 2,
	AXP717_IRQ_GAUGE_NEW_SOC = 4,
	AXP717_IRQ_SOC_DROP_LVL1 = 6,
	AXP717_IRQ_SOC_DROP_LVL2 = 7,
	AXP717_IRQ_PEK_RIS_EDGE = 8,
	AXP717_IRQ_PEK_FAL_EDGE = 9,
	AXP717_IRQ_PEK_LONG = 10,
	AXP717_IRQ_PEK_SHORT = 11,
	AXP717_IRQ_BATT_REMOVAL = 12,
	AXP717_IRQ_BATT_PLUGIN = 13,
	AXP717_IRQ_VBUS_REMOVAL = 14,
	AXP717_IRQ_VBUS_PLUGIN = 15,
	AXP717_IRQ_BATT_OVER_V = 16,
	AXP717_IRQ_CHARG_TIMER = 17,
	AXP717_IRQ_DIE_TEMP_HIGH = 18,
	AXP717_IRQ_CHARG = 19,
	AXP717_IRQ_CHARG_DONE = 20,
	AXP717_IRQ_BATT_OVER_CURR = 21,
	AXP717_IRQ_LDO_OVER_CURR = 22,
	AXP717_IRQ_WDOG_EXPIRE = 23,
	AXP717_IRQ_BATT_ACT_TEMP_LOW = 24,
	AXP717_IRQ_BATT_ACT_TEMP_HIGH = 25,
	AXP717_IRQ_BATT_CHG_TEMP_LOW = 26,
	AXP717_IRQ_BATT_CHG_TEMP_HIGH = 27,
	AXP717_IRQ_BATT_QUIT_TEMP_HIGH = 28,
	AXP717_IRQ_BC_USB_CHNG = 30,
	AXP717_IRQ_BC_USB_DONE = 31,
	AXP717_IRQ_TYPEC_PLUGIN = 37,
	AXP717_IRQ_TYPEC_REMOVE = 38,
};

enum axp803_irqs {
	AXP803_IRQ_ACIN_OVER_V = 1,
	AXP803_IRQ_ACIN_PLUGIN = 2,
	AXP803_IRQ_ACIN_REMOVAL = 3,
	AXP803_IRQ_VBUS_OVER_V = 4,
	AXP803_IRQ_VBUS_PLUGIN = 5,
	AXP803_IRQ_VBUS_REMOVAL = 6,
	AXP803_IRQ_BATT_PLUGIN = 7,
	AXP803_IRQ_BATT_REMOVAL = 8,
	AXP803_IRQ_BATT_ENT_ACT_MODE = 9,
	AXP803_IRQ_BATT_EXIT_ACT_MODE = 10,
	AXP803_IRQ_CHARG = 11,
	AXP803_IRQ_CHARG_DONE = 12,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH = 13,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH_END = 14,
	AXP803_IRQ_BATT_CHG_TEMP_LOW = 15,
	AXP803_IRQ_BATT_CHG_TEMP_LOW_END = 16,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH = 17,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH_END = 18,
	AXP803_IRQ_BATT_ACT_TEMP_LOW = 19,
	AXP803_IRQ_BATT_ACT_TEMP_LOW_END = 20,
	AXP803_IRQ_DIE_TEMP_HIGH = 21,
	AXP803_IRQ_GPADC = 22,
	AXP803_IRQ_LOW_PWR_LVL1 = 23,
	AXP803_IRQ_LOW_PWR_LVL2 = 24,
	AXP803_IRQ_TIMER = 25,
	AXP803_IRQ_PEK_FAL_EDGE = 26,
	AXP803_IRQ_PEK_RIS_EDGE = 27,
	AXP803_IRQ_PEK_SHORT = 28,
	AXP803_IRQ_PEK_LONG = 29,
	AXP803_IRQ_PEK_OVER_OFF = 30,
	AXP803_IRQ_GPIO1_INPUT = 31,
	AXP803_IRQ_GPIO0_INPUT = 32,
	AXP803_IRQ_BC_USB_CHNG = 33,
	AXP803_IRQ_MV_CHNG = 34,
};

enum axp806_irqs {
	AXP806_IRQ_DIE_TEMP_HIGH_LV1 = 0,
	AXP806_IRQ_DIE_TEMP_HIGH_LV2 = 1,
	AXP806_IRQ_DCDCA_V_LOW = 2,
	AXP806_IRQ_DCDCB_V_LOW = 3,
	AXP806_IRQ_DCDCC_V_LOW = 4,
	AXP806_IRQ_DCDCD_V_LOW = 5,
	AXP806_IRQ_DCDCE_V_LOW = 6,
	AXP806_IRQ_POK_LONG = 7,
	AXP806_IRQ_POK_SHORT = 8,
	AXP806_IRQ_WAKEUP = 9,
	AXP806_IRQ_POK_FALL = 10,
	AXP806_IRQ_POK_RISE = 11,
};

enum axp809_irqs {
	AXP809_IRQ_ACIN_OVER_V = 1,
	AXP809_IRQ_ACIN_PLUGIN = 2,
	AXP809_IRQ_ACIN_REMOVAL = 3,
	AXP809_IRQ_VBUS_OVER_V = 4,
	AXP809_IRQ_VBUS_PLUGIN = 5,
	AXP809_IRQ_VBUS_REMOVAL = 6,
	AXP809_IRQ_VBUS_V_LOW = 7,
	AXP809_IRQ_BATT_PLUGIN = 8,
	AXP809_IRQ_BATT_REMOVAL = 9,
	AXP809_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP809_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP809_IRQ_CHARG = 12,
	AXP809_IRQ_CHARG_DONE = 13,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH = 14,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH_END = 15,
	AXP809_IRQ_BATT_CHG_TEMP_LOW = 16,
	AXP809_IRQ_BATT_CHG_TEMP_LOW_END = 17,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH = 18,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH_END = 19,
	AXP809_IRQ_BATT_ACT_TEMP_LOW = 20,
	AXP809_IRQ_BATT_ACT_TEMP_LOW_END = 21,
	AXP809_IRQ_DIE_TEMP_HIGH = 22,
	AXP809_IRQ_LOW_PWR_LVL1 = 23,
	AXP809_IRQ_LOW_PWR_LVL2 = 24,
	AXP809_IRQ_TIMER = 25,
	AXP809_IRQ_PEK_FAL_EDGE = 26,
	AXP809_IRQ_PEK_RIS_EDGE = 27,
	AXP809_IRQ_PEK_SHORT = 28,
	AXP809_IRQ_PEK_LONG = 29,
	AXP809_IRQ_PEK_OVER_OFF = 30,
	AXP809_IRQ_GPIO1_INPUT = 31,
	AXP809_IRQ_GPIO0_INPUT = 32,
};

enum base_type {
	MSPI = 0,
	BSPI = 1,
	CHIP_SELECT = 2,
	BASEMAX = 3,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bbr_mode {
	BBR_STARTUP = 0,
	BBR_DRAIN = 1,
	BBR_PROBE_BW = 2,
	BBR_PROBE_RTT = 3,
};

enum bcm2835_fsel {
	BCM2835_FSEL_COUNT = 8,
	BCM2835_FSEL_MASK = 7,
};

enum bcm_iproc_i2c_type {
	IPROC_I2C = 0,
	IPROC_I2C_NIC = 1,
};

enum bcm_usb_phy_ctrl_bits {
	CORERDY = 0,
	PHY_RESETB = 1,
	PHY_PCTL = 2,
};

enum bcm_usb_phy_reg {
	PLL_CTRL = 0,
	PHY_CTRL = 1,
	PHY_PLL_CTRL = 2,
};

enum bcm_usb_phy_type {
	USB_HS_PHY = 0,
	USB_SS_PHY = 1,
};

enum bcm_usb_phy_version {
	BCM_SR_USB_COMBO_PHY = 0,
	BCM_SR_USB_HS_PHY = 1,
};

enum bcma_hosttype {
	BCMA_HOSTTYPE_PCI = 0,
	BCMA_HOSTTYPE_SDIO = 1,
	BCMA_HOSTTYPE_SOC = 2,
};

enum bcmasp_stat_type {
	BCMASP_STAT_RX_EDPKT = 0,
	BCMASP_STAT_RX_CTRL = 1,
	BCMASP_STAT_RX_CTRL_PER_INTF = 2,
	BCMASP_STAT_SOFT = 3,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqg_stats_flags {
	BFQG_stats_waiting = 0,
	BFQG_stats_idling = 1,
	BFQG_stats_empty = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bgmac_dma_ring_type {
	BGMAC_DMA_RING_TX = 0,
	BGMAC_DMA_RING_RX = 1,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_PrivateStart = 16,
};

enum bhb_mitigation_bits {
	BHB_LOOP = 0,
	BHB_FW = 1,
	BHB_HW = 2,
	BHB_INSN = 3,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_INITIAL = 0,
	STEP_DECRYPT = 1,
	STEP_VERITY = 2,
	STEP_MAX = 3,
};

enum bios_platform_class {
	BIOS_CLIENT = 0,
	BIOS_SERVER = 1,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_CTRL_NOCHECK = 4,
	BIP_DISK_NOCHECK = 8,
	BIP_IP_CHECKSUM = 16,
	BIP_COPY_USER = 32,
};

enum bitmap_page_attr {
	BITMAP_PAGE_DIRTY = 0,
	BITMAP_PAGE_PENDING = 1,
	BITMAP_PAGE_NEEDWRITE = 2,
};

enum bitmap_state {
	BITMAP_STALE = 1,
	BITMAP_WRITE_ERROR = 2,
	BITMAP_HOSTENDIAN = 15,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blk_zone_cond {
	BLK_ZONE_COND_NOT_WP = 0,
	BLK_ZONE_COND_EMPTY = 1,
	BLK_ZONE_COND_IMP_OPEN = 2,
	BLK_ZONE_COND_EXP_OPEN = 3,
	BLK_ZONE_COND_CLOSED = 4,
	BLK_ZONE_COND_READONLY = 13,
	BLK_ZONE_COND_FULL = 14,
	BLK_ZONE_COND_OFFLINE = 15,
};

enum blk_zone_report_flags {
	BLK_ZONE_REP_CAPACITY = 1,
};

enum blk_zone_type {
	BLK_ZONE_TYPE_CONVENTIONAL = 1,
	BLK_ZONE_TYPE_SEQWRITE_REQ = 2,
	BLK_ZONE_TYPE_SEQWRITE_PREF = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum blktrace_cat {
	BLK_TC_READ = 1,
	BLK_TC_WRITE = 2,
	BLK_TC_FLUSH = 4,
	BLK_TC_SYNC = 8,
	BLK_TC_SYNCIO = 8,
	BLK_TC_QUEUE = 16,
	BLK_TC_REQUEUE = 32,
	BLK_TC_ISSUE = 64,
	BLK_TC_COMPLETE = 128,
	BLK_TC_FS = 256,
	BLK_TC_PC = 512,
	BLK_TC_NOTIFY = 1024,
	BLK_TC_AHEAD = 2048,
	BLK_TC_META = 4096,
	BLK_TC_DISCARD = 8192,
	BLK_TC_DRV_DATA = 16384,
	BLK_TC_FUA = 32768,
	BLK_TC_END = 32768,
};

enum blktrace_notify {
	__BLK_TN_PROCESS = 0,
	__BLK_TN_TIMESTAMP = 1,
	__BLK_TN_MESSAGE = 2,
	__BLK_TN_CGROUP = 256,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_al = 9,
	board_ahci_avn = 10,
	board_ahci_mcp65 = 11,
	board_ahci_mcp77 = 12,
	board_ahci_mcp89 = 13,
	board_ahci_mv = 14,
	board_ahci_sb600 = 15,
	board_ahci_sb700 = 16,
	board_ahci_vt8251 = 17,
	board_ahci_mcp_linux = 11,
	board_ahci_mcp67 = 11,
	board_ahci_mcp73 = 11,
	board_ahci_mcp79 = 12,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_lwt_encap_mode {
	BPF_LWT_ENCAP_SEG6 = 0,
	BPF_LWT_ENCAP_SEG6_INLINE = 1,
	BPF_LWT_ENCAP_IP = 2,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum br_boolopt_id {
	BR_BOOLOPT_NO_LL_LEARN = 0,
	BR_BOOLOPT_MCAST_VLAN_SNOOPING = 1,
	BR_BOOLOPT_MST_ENABLE = 2,
	BR_BOOLOPT_MAX = 3,
};

enum br_pkt_type {
	BR_PKT_UNICAST = 0,
	BR_PKT_MULTICAST = 1,
	BR_PKT_BROADCAST = 2,
};

enum brcm_family_type {
	BRCM_FAMILY_3390A0 = 0,
	BRCM_FAMILY_4908 = 1,
	BRCM_FAMILY_7250B0 = 2,
	BRCM_FAMILY_7271A0 = 3,
	BRCM_FAMILY_7364A0 = 4,
	BRCM_FAMILY_7366C0 = 5,
	BRCM_FAMILY_74371A0 = 6,
	BRCM_FAMILY_7439B0 = 7,
	BRCM_FAMILY_7445D0 = 8,
	BRCM_FAMILY_7260A0 = 9,
	BRCM_FAMILY_7278A0 = 10,
	BRCM_FAMILY_COUNT = 11,
};

enum brcm_sata_phy_rxaeq_mode {
	RXAEQ_MODE_OFF = 0,
	RXAEQ_MODE_AUTO = 1,
	RXAEQ_MODE_MANUAL = 2,
};

enum brcm_sata_phy_version {
	BRCM_SATA_PHY_STB_16NM = 0,
	BRCM_SATA_PHY_STB_28NM = 1,
	BRCM_SATA_PHY_STB_40NM = 2,
	BRCM_SATA_PHY_IPROC_NS2 = 3,
	BRCM_SATA_PHY_IPROC_NSP = 4,
	BRCM_SATA_PHY_IPROC_SR = 5,
	BRCM_SATA_PHY_DSL_28NM = 6,
};

enum brcm_usb_phy_id {
	BRCM_USB_PHY_2_0 = 0,
	BRCM_USB_PHY_3_0 = 1,
	BRCM_USB_PHY_ID_MAX = 2,
};

enum brcmstb_memc_hwtype {
	BRCMSTB_MEMC_V21 = 0,
	BRCMSTB_MEMC_V20 = 1,
	BRCMSTB_MEMC_V1X = 2,
};

enum brcmusb_reg_sel {
	BRCM_REGS_CTRL = 0,
	BRCM_REGS_XHCI_EC = 1,
	BRCM_REGS_XHCI_GBL = 2,
	BRCM_REGS_USB_PHY = 3,
	BRCM_REGS_USB_MDIO = 4,
	BRCM_REGS_BDC_EC = 5,
	BRCM_REGS_MAX = 6,
};

enum bsc_xfer_cmd {
	CMD_WR = 0,
	CMD_RD = 1,
	CMD_WR_NOACK = 2,
	CMD_RD_NOACK = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum btree_flags {
	BTREE_NODE_io_error = 0,
	BTREE_NODE_dirty = 1,
	BTREE_NODE_write_idx = 2,
	BTREE_NODE_journal_flush = 3,
};

enum buddy {
	FIRST = 0,
	LAST = 1,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum bus_speeds {
	SPD_375K = 0,
	SPD_390K = 1,
	SPD_187K = 2,
	SPD_200K = 3,
	SPD_93K = 4,
	SPD_97K = 5,
	SPD_46K = 6,
	SPD_50K = 7,
};

enum cache_indexing {
	NODE_CACHE_DIRECT_MAP = 0,
	NODE_CACHE_INDEXED = 1,
	NODE_CACHE_OTHER = 2,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cache_write_policy {
	NODE_CACHE_WRITE_BACK = 0,
	NODE_CACHE_WRITE_THROUGH = 1,
	NODE_CACHE_WRITE_OTHER = 2,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_HOST_SEV_SNP = 6,
};

enum cci400_perf_events {
	CCI400_PMU_CYCLES = 255,
};

enum cci_models {
	CCI400_R0 = 0,
	CCI400_R1 = 1,
	CCI500_R0 = 2,
	CCI550_R0 = 3,
	CCI_MODEL_MAX = 4,
};

enum cdrom_print_option {
	CTL_NAME = 0,
	CTL_SPEED = 1,
	CTL_SLOTS = 2,
	CTL_CAPABILITY = 3,
};

enum cee_attrs {
	DCB_ATTR_CEE_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_PG = 1,
	DCB_ATTR_CEE_PEER_PFC = 2,
	DCB_ATTR_CEE_PEER_APP_TABLE = 3,
	DCB_ATTR_CEE_TX_PG = 4,
	DCB_ATTR_CEE_RX_PG = 5,
	DCB_ATTR_CEE_PFC = 6,
	DCB_ATTR_CEE_APP_TABLE = 7,
	DCB_ATTR_CEE_FEAT = 8,
	__DCB_ATTR_CEE_MAX = 9,
};

enum cfg80211_signal_type {
	CFG80211_SIGNAL_TYPE_NONE = 0,
	CFG80211_SIGNAL_TYPE_MBM = 1,
	CFG80211_SIGNAL_TYPE_UNSPEC = 2,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 37,
	MAX_CGROUP_BPF_ATTACH_TYPE = 38,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_PRESSURE = 0,
	OPT_FEATURE_COUNT = 1,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	net_prio_cgrp_id = 9,
	hugetlb_cgrp_id = 10,
	pids_cgrp_id = 11,
	rdma_cgrp_id = 12,
	misc_cgrp_id = 13,
	CGROUP_SUBSYS_COUNT = 14,
};

enum cgt_group_id {
	__RESERVED__ = 0,
	CGT_HCR_TID1 = 1,
	CGT_HCR_TID2 = 2,
	CGT_HCR_TID3 = 3,
	CGT_HCR_IMO = 4,
	CGT_HCR_FMO = 5,
	CGT_HCR_TIDCP = 6,
	CGT_HCR_TACR = 7,
	CGT_HCR_TSW = 8,
	CGT_HCR_TPC = 9,
	CGT_HCR_TPU = 10,
	CGT_HCR_TTLB = 11,
	CGT_HCR_TVM = 12,
	CGT_HCR_TDZ = 13,
	CGT_HCR_TRVM = 14,
	CGT_HCR_TLOR = 15,
	CGT_HCR_TERR = 16,
	CGT_HCR_APK = 17,
	CGT_HCR_NV = 18,
	CGT_HCR_NV_nNV2 = 19,
	CGT_HCR_NV1_nNV2 = 20,
	CGT_HCR_AT = 21,
	CGT_HCR_nFIEN = 22,
	CGT_HCR_TID4 = 23,
	CGT_HCR_TICAB = 24,
	CGT_HCR_TOCU = 25,
	CGT_HCR_ENSCXT = 26,
	CGT_HCR_TTLBIS = 27,
	CGT_HCR_TTLBOS = 28,
	CGT_MDCR_TPMCR = 29,
	CGT_MDCR_TPM = 30,
	CGT_MDCR_TDE = 31,
	CGT_MDCR_TDA = 32,
	CGT_MDCR_TDOSA = 33,
	CGT_MDCR_TDRA = 34,
	CGT_MDCR_E2PB = 35,
	CGT_MDCR_TPMS = 36,
	CGT_MDCR_TTRF = 37,
	CGT_MDCR_E2TB = 38,
	CGT_MDCR_TDCC = 39,
	CGT_CPTR_TAM = 40,
	CGT_CPTR_TCPAC = 41,
	CGT_HCRX_EnFPM = 42,
	CGT_HCRX_TCR2En = 43,
	CGT_ICH_HCR_TC = 44,
	CGT_ICH_HCR_TALL0 = 45,
	CGT_ICH_HCR_TALL1 = 46,
	CGT_ICH_HCR_TDIR = 47,
	__MULTIPLE_CONTROL_BITS__ = 48,
	CGT_HCR_IMO_FMO_ICH_HCR_TC = 48,
	CGT_HCR_TID2_TID4 = 49,
	CGT_HCR_TTLB_TTLBIS = 50,
	CGT_HCR_TTLB_TTLBOS = 51,
	CGT_HCR_TVM_TRVM = 52,
	CGT_HCR_TVM_TRVM_HCRX_TCR2En = 53,
	CGT_HCR_TPU_TICAB = 54,
	CGT_HCR_TPU_TOCU = 55,
	CGT_HCR_NV1_nNV2_ENSCXT = 56,
	CGT_MDCR_TPM_TPMCR = 57,
	CGT_MDCR_TPM_HPMN = 58,
	CGT_MDCR_TDE_TDA = 59,
	CGT_MDCR_TDE_TDOSA = 60,
	CGT_MDCR_TDE_TDRA = 61,
	CGT_MDCR_TDCC_TDE_TDA = 62,
	CGT_ICH_HCR_TC_TDIR = 63,
	__COMPLEX_CONDITIONS__ = 64,
	CGT_CNTHCTL_EL1PCTEN = 64,
	CGT_CNTHCTL_EL1PTEN = 65,
	CGT_CPTR_TTA = 66,
	CGT_MDCR_HPMN = 67,
	__NR_CGT_GROUP_IDS__ = 68,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum class_map_type {
	DD_CLASS_TYPE_DISJOINT_BITS = 0,
	DD_CLASS_TYPE_LEVEL_NUM = 1,
	DD_CLASS_TYPE_DISJOINT_NAMES = 2,
	DD_CLASS_TYPE_LEVEL_NAMES = 3,
};

enum class_stat_type {
	ZS_OBJS_ALLOCATED = 12,
	ZS_OBJS_INUSE = 13,
	NR_CLASS_STAT_TYPES = 14,
};

enum cleanup_prefix_rt_t {
	CLEANUP_PREFIX_RT_NOP = 0,
	CLEANUP_PREFIX_RT_DEL = 1,
	CLEANUP_PREFIX_RT_EXPIRE = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_id {
	tegra_clk_actmon = 0,
	tegra_clk_adx = 1,
	tegra_clk_adx1 = 2,
	tegra_clk_afi = 3,
	tegra_clk_amx = 4,
	tegra_clk_amx1 = 5,
	tegra_clk_apb2ape = 6,
	tegra_clk_ahbdma = 7,
	tegra_clk_apbdma = 8,
	tegra_clk_apbif = 9,
	tegra_clk_ape = 10,
	tegra_clk_audio0 = 11,
	tegra_clk_audio0_2x = 12,
	tegra_clk_audio0_mux = 13,
	tegra_clk_audio1 = 14,
	tegra_clk_audio1_2x = 15,
	tegra_clk_audio1_mux = 16,
	tegra_clk_audio2 = 17,
	tegra_clk_audio2_2x = 18,
	tegra_clk_audio2_mux = 19,
	tegra_clk_audio3 = 20,
	tegra_clk_audio3_2x = 21,
	tegra_clk_audio3_mux = 22,
	tegra_clk_audio4 = 23,
	tegra_clk_audio4_2x = 24,
	tegra_clk_audio4_mux = 25,
	tegra_clk_bsea = 26,
	tegra_clk_bsev = 27,
	tegra_clk_cclk_g = 28,
	tegra_clk_cclk_lp = 29,
	tegra_clk_cilab = 30,
	tegra_clk_cilcd = 31,
	tegra_clk_cile = 32,
	tegra_clk_clk_32k = 33,
	tegra_clk_clk72Mhz = 34,
	tegra_clk_clk72Mhz_8 = 35,
	tegra_clk_clk_m = 36,
	tegra_clk_osc = 37,
	tegra_clk_osc_div2 = 38,
	tegra_clk_osc_div4 = 39,
	tegra_clk_cml0 = 40,
	tegra_clk_cml1 = 41,
	tegra_clk_csi = 42,
	tegra_clk_csite = 43,
	tegra_clk_csite_8 = 44,
	tegra_clk_csus = 45,
	tegra_clk_cve = 46,
	tegra_clk_dam0 = 47,
	tegra_clk_dam1 = 48,
	tegra_clk_dam2 = 49,
	tegra_clk_d_audio = 50,
	tegra_clk_dbgapb = 51,
	tegra_clk_dds = 52,
	tegra_clk_dfll_ref = 53,
	tegra_clk_dfll_soc = 54,
	tegra_clk_disp1 = 55,
	tegra_clk_disp1_8 = 56,
	tegra_clk_disp2 = 57,
	tegra_clk_disp2_8 = 58,
	tegra_clk_dp2 = 59,
	tegra_clk_dpaux = 60,
	tegra_clk_dpaux1 = 61,
	tegra_clk_dsialp = 62,
	tegra_clk_dsia_mux = 63,
	tegra_clk_dsiblp = 64,
	tegra_clk_dsib_mux = 65,
	tegra_clk_dtv = 66,
	tegra_clk_emc = 67,
	tegra_clk_entropy = 68,
	tegra_clk_entropy_8 = 69,
	tegra_clk_epp = 70,
	tegra_clk_epp_8 = 71,
	tegra_clk_extern1 = 72,
	tegra_clk_extern2 = 73,
	tegra_clk_extern3 = 74,
	tegra_clk_fuse = 75,
	tegra_clk_fuse_burn = 76,
	tegra_clk_gpu = 77,
	tegra_clk_gr2d = 78,
	tegra_clk_gr2d_8 = 79,
	tegra_clk_gr3d = 80,
	tegra_clk_gr3d_8 = 81,
	tegra_clk_hclk = 82,
	tegra_clk_hda = 83,
	tegra_clk_hda_8 = 84,
	tegra_clk_hda2codec_2x = 85,
	tegra_clk_hda2codec_2x_8 = 86,
	tegra_clk_hda2hdmi = 87,
	tegra_clk_hdmi = 88,
	tegra_clk_hdmi_audio = 89,
	tegra_clk_host1x = 90,
	tegra_clk_host1x_8 = 91,
	tegra_clk_host1x_9 = 92,
	tegra_clk_hsic_trk = 93,
	tegra_clk_i2c1 = 94,
	tegra_clk_i2c2 = 95,
	tegra_clk_i2c3 = 96,
	tegra_clk_i2c4 = 97,
	tegra_clk_i2c5 = 98,
	tegra_clk_i2c6 = 99,
	tegra_clk_i2cslow = 100,
	tegra_clk_i2s0 = 101,
	tegra_clk_i2s0_sync = 102,
	tegra_clk_i2s1 = 103,
	tegra_clk_i2s1_sync = 104,
	tegra_clk_i2s2 = 105,
	tegra_clk_i2s2_sync = 106,
	tegra_clk_i2s3 = 107,
	tegra_clk_i2s3_sync = 108,
	tegra_clk_i2s4 = 109,
	tegra_clk_i2s4_sync = 110,
	tegra_clk_isp = 111,
	tegra_clk_isp_8 = 112,
	tegra_clk_isp_9 = 113,
	tegra_clk_ispb = 114,
	tegra_clk_kbc = 115,
	tegra_clk_kfuse = 116,
	tegra_clk_la = 117,
	tegra_clk_maud = 118,
	tegra_clk_mipi = 119,
	tegra_clk_mipibif = 120,
	tegra_clk_mipi_cal = 121,
	tegra_clk_mpe = 122,
	tegra_clk_mselect = 123,
	tegra_clk_msenc = 124,
	tegra_clk_ndflash = 125,
	tegra_clk_ndflash_8 = 126,
	tegra_clk_ndspeed = 127,
	tegra_clk_ndspeed_8 = 128,
	tegra_clk_nor = 129,
	tegra_clk_nvdec = 130,
	tegra_clk_nvenc = 131,
	tegra_clk_nvjpg = 132,
	tegra_clk_owr = 133,
	tegra_clk_owr_8 = 134,
	tegra_clk_pcie = 135,
	tegra_clk_pclk = 136,
	tegra_clk_pll_a = 137,
	tegra_clk_pll_a_out0 = 138,
	tegra_clk_pll_a1 = 139,
	tegra_clk_pll_c = 140,
	tegra_clk_pll_c2 = 141,
	tegra_clk_pll_c3 = 142,
	tegra_clk_pll_c4 = 143,
	tegra_clk_pll_c4_out0 = 144,
	tegra_clk_pll_c4_out1 = 145,
	tegra_clk_pll_c4_out2 = 146,
	tegra_clk_pll_c4_out3 = 147,
	tegra_clk_pll_c_out1 = 148,
	tegra_clk_pll_d = 149,
	tegra_clk_pll_d2 = 150,
	tegra_clk_pll_d2_out0 = 151,
	tegra_clk_pll_d_out0 = 152,
	tegra_clk_pll_dp = 153,
	tegra_clk_pll_e_out0 = 154,
	tegra_clk_pll_g_ref = 155,
	tegra_clk_pll_m = 156,
	tegra_clk_pll_m_out1 = 157,
	tegra_clk_pll_mb = 158,
	tegra_clk_pll_p = 159,
	tegra_clk_pll_p_out1 = 160,
	tegra_clk_pll_p_out2 = 161,
	tegra_clk_pll_p_out2_int = 162,
	tegra_clk_pll_p_out3 = 163,
	tegra_clk_pll_p_out4 = 164,
	tegra_clk_pll_p_out4_cpu = 165,
	tegra_clk_pll_p_out5 = 166,
	tegra_clk_pll_p_out_hsio = 167,
	tegra_clk_pll_p_out_xusb = 168,
	tegra_clk_pll_p_out_cpu = 169,
	tegra_clk_pll_p_out_adsp = 170,
	tegra_clk_pll_ref = 171,
	tegra_clk_pll_re_out = 172,
	tegra_clk_pll_re_vco = 173,
	tegra_clk_pll_u = 174,
	tegra_clk_pll_u_out = 175,
	tegra_clk_pll_u_out1 = 176,
	tegra_clk_pll_u_out2 = 177,
	tegra_clk_pll_u_12m = 178,
	tegra_clk_pll_u_480m = 179,
	tegra_clk_pll_u_48m = 180,
	tegra_clk_pll_u_60m = 181,
	tegra_clk_pll_x = 182,
	tegra_clk_pll_x_out0 = 183,
	tegra_clk_pwm = 184,
	tegra_clk_qspi = 185,
	tegra_clk_rtc = 186,
	tegra_clk_sata = 187,
	tegra_clk_sata_8 = 188,
	tegra_clk_sata_cold = 189,
	tegra_clk_sata_oob = 190,
	tegra_clk_sata_oob_8 = 191,
	tegra_clk_sbc1 = 192,
	tegra_clk_sbc1_8 = 193,
	tegra_clk_sbc1_9 = 194,
	tegra_clk_sbc2 = 195,
	tegra_clk_sbc2_8 = 196,
	tegra_clk_sbc2_9 = 197,
	tegra_clk_sbc3 = 198,
	tegra_clk_sbc3_8 = 199,
	tegra_clk_sbc3_9 = 200,
	tegra_clk_sbc4 = 201,
	tegra_clk_sbc4_8 = 202,
	tegra_clk_sbc4_9 = 203,
	tegra_clk_sbc5 = 204,
	tegra_clk_sbc5_8 = 205,
	tegra_clk_sbc6 = 206,
	tegra_clk_sbc6_8 = 207,
	tegra_clk_sclk = 208,
	tegra_clk_sdmmc_legacy = 209,
	tegra_clk_sdmmc1 = 210,
	tegra_clk_sdmmc1_8 = 211,
	tegra_clk_sdmmc1_9 = 212,
	tegra_clk_sdmmc2 = 213,
	tegra_clk_sdmmc2_8 = 214,
	tegra_clk_sdmmc3 = 215,
	tegra_clk_sdmmc3_8 = 216,
	tegra_clk_sdmmc3_9 = 217,
	tegra_clk_sdmmc4 = 218,
	tegra_clk_sdmmc4_8 = 219,
	tegra_clk_se = 220,
	tegra_clk_se_10 = 221,
	tegra_clk_soc_therm = 222,
	tegra_clk_soc_therm_8 = 223,
	tegra_clk_sor0 = 224,
	tegra_clk_sor0_out = 225,
	tegra_clk_sor1 = 226,
	tegra_clk_sor1_out = 227,
	tegra_clk_spdif = 228,
	tegra_clk_spdif_2x = 229,
	tegra_clk_spdif_in = 230,
	tegra_clk_spdif_in_8 = 231,
	tegra_clk_spdif_in_sync = 232,
	tegra_clk_spdif_mux = 233,
	tegra_clk_spdif_out = 234,
	tegra_clk_timer = 235,
	tegra_clk_trace = 236,
	tegra_clk_tsec = 237,
	tegra_clk_tsec_8 = 238,
	tegra_clk_tsecb = 239,
	tegra_clk_tsensor = 240,
	tegra_clk_tvdac = 241,
	tegra_clk_tvo = 242,
	tegra_clk_uarta = 243,
	tegra_clk_uarta_8 = 244,
	tegra_clk_uartb = 245,
	tegra_clk_uartb_8 = 246,
	tegra_clk_uartc = 247,
	tegra_clk_uartc_8 = 248,
	tegra_clk_uartd = 249,
	tegra_clk_uartd_8 = 250,
	tegra_clk_uarte = 251,
	tegra_clk_uarte_8 = 252,
	tegra_clk_uartape = 253,
	tegra_clk_usb2 = 254,
	tegra_clk_usb2_hsic_trk = 255,
	tegra_clk_usb2_trk = 256,
	tegra_clk_usb3 = 257,
	tegra_clk_usbd = 258,
	tegra_clk_vcp = 259,
	tegra_clk_vde = 260,
	tegra_clk_vde_8 = 261,
	tegra_clk_vfir = 262,
	tegra_clk_vi = 263,
	tegra_clk_vi_8 = 264,
	tegra_clk_vi_9 = 265,
	tegra_clk_vi_10 = 266,
	tegra_clk_vi_i2c = 267,
	tegra_clk_vic03 = 268,
	tegra_clk_vic03_8 = 269,
	tegra_clk_vim2_clk = 270,
	tegra_clk_vimclk_sync = 271,
	tegra_clk_vi_sensor = 272,
	tegra_clk_vi_sensor_8 = 273,
	tegra_clk_vi_sensor_9 = 274,
	tegra_clk_vi_sensor2 = 275,
	tegra_clk_vi_sensor2_8 = 276,
	tegra_clk_xusb_dev = 277,
	tegra_clk_xusb_dev_src = 278,
	tegra_clk_xusb_dev_src_8 = 279,
	tegra_clk_xusb_falcon_src = 280,
	tegra_clk_xusb_falcon_src_8 = 281,
	tegra_clk_xusb_fs_src = 282,
	tegra_clk_xusb_gate = 283,
	tegra_clk_xusb_host = 284,
	tegra_clk_xusb_host_src = 285,
	tegra_clk_xusb_host_src_8 = 286,
	tegra_clk_xusb_hs_src = 287,
	tegra_clk_xusb_hs_src_4 = 288,
	tegra_clk_xusb_ss = 289,
	tegra_clk_xusb_ss_src = 290,
	tegra_clk_xusb_ss_src_8 = 291,
	tegra_clk_xusb_ss_div2 = 292,
	tegra_clk_xusb_ssp_src = 293,
	tegra_clk_sclk_mux = 294,
	tegra_clk_sor_safe = 295,
	tegra_clk_cec = 296,
	tegra_clk_ispa = 297,
	tegra_clk_dmic1 = 298,
	tegra_clk_dmic2 = 299,
	tegra_clk_dmic3 = 300,
	tegra_clk_dmic1_sync_clk = 301,
	tegra_clk_dmic2_sync_clk = 302,
	tegra_clk_dmic3_sync_clk = 303,
	tegra_clk_dmic1_sync_clk_mux = 304,
	tegra_clk_dmic2_sync_clk_mux = 305,
	tegra_clk_dmic3_sync_clk_mux = 306,
	tegra_clk_iqc1 = 307,
	tegra_clk_iqc2 = 308,
	tegra_clk_pll_a_out_adsp = 309,
	tegra_clk_pll_a_out0_out_adsp = 310,
	tegra_clk_adsp = 311,
	tegra_clk_adsp_neon = 312,
	tegra_clk_max = 313,
};

enum clk_id___2 {
	CLK_NONE = 0,
	CLK_MM = 1,
	CLK_MFG = 2,
	CLK_VENC = 3,
	CLK_VENC_LT = 4,
	CLK_ETHIF = 5,
	CLK_VDEC = 6,
	CLK_HIFSEL = 7,
	CLK_JPGDEC = 8,
	CLK_AUDIO = 9,
	CLK_MAX = 10,
};

enum clk_type_t {
	CLK_EXT_DIFF = 0,
	CLK_INT_DIFF = 1,
	CLK_INT_SING = 2,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum closure_state {
	CLOSURE_BITS_START = 67108864,
	CLOSURE_DESTRUCTOR = 67108864,
	CLOSURE_WAITING = 268435456,
	CLOSURE_RUNNING = 1073741824,
};

enum cmd_db_hw_type {
	CMD_DB_HW_INVALID = 0,
	CMD_DB_HW_MIN = 3,
	CMD_DB_HW_ARC = 3,
	CMD_DB_HW_VRM = 4,
	CMD_DB_HW_BCM = 5,
	CMD_DB_HW_MAX = 5,
	CMD_DB_HW_ALL = 255,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum cmn_filter_select {
	SEL_NONE = -1,
	SEL_OCCUP1ID = 0,
	SEL_CLASS_OCCUP_ID = 1,
	SEL_CBUSY_SNTHROTTLE_SEL = 2,
	SEL_HBT_LBT_SEL = 3,
	SEL_SN_HOME_SEL = 4,
	SEL_MAX = 5,
};

enum cmn_model {
	CMN600 = 1,
	CMN650 = 2,
	CMN700 = 4,
	CI700 = 8,
	CMNS3 = 16,
	CMN_ANY = -1,
	NOT_CMN600 = -2,
	CMN_650ON = 22,
};

enum cmn_node_type {
	CMN_TYPE_INVALID = 0,
	CMN_TYPE_DVM = 1,
	CMN_TYPE_CFG = 2,
	CMN_TYPE_DTC = 3,
	CMN_TYPE_HNI = 4,
	CMN_TYPE_HNF = 5,
	CMN_TYPE_XP = 6,
	CMN_TYPE_SBSX = 7,
	CMN_TYPE_MPAM_S = 8,
	CMN_TYPE_MPAM_NS = 9,
	CMN_TYPE_RNI = 10,
	CMN_TYPE_RND = 13,
	CMN_TYPE_RNSAM = 15,
	CMN_TYPE_MTSX = 16,
	CMN_TYPE_HNP = 17,
	CMN_TYPE_CXRA = 256,
	CMN_TYPE_CXHA = 257,
	CMN_TYPE_CXLA = 258,
	CMN_TYPE_CCRA = 259,
	CMN_TYPE_CCHA = 260,
	CMN_TYPE_CCLA = 261,
	CMN_TYPE_CCLA_RNI = 262,
	CMN_TYPE_HNS = 512,
	CMN_TYPE_HNS_MPAM_S = 513,
	CMN_TYPE_HNS_MPAM_NS = 514,
	CMN_TYPE_APB = 4096,
	CMN_TYPE_WP = 30576,
};

enum cmn_part {
	PART_CMN600 = 1076,
	PART_CMN650 = 1078,
	PART_CMN700 = 1084,
	PART_CI700 = 1082,
	PART_CMN_S3 = 1086,
};

enum cmn_revision {
	REV_CMN600_R1P0 = 0,
	REV_CMN600_R1P1 = 1,
	REV_CMN600_R1P2 = 2,
	REV_CMN600_R1P3 = 3,
	REV_CMN600_R2P0 = 4,
	REV_CMN600_R3P0 = 5,
	REV_CMN600_R3P1 = 6,
	REV_CMN650_R0P0 = 0,
	REV_CMN650_R1P0 = 1,
	REV_CMN650_R1P1 = 2,
	REV_CMN650_R2P0 = 3,
	REV_CMN650_R1P2 = 4,
	REV_CMN700_R0P0 = 0,
	REV_CMN700_R1P0 = 1,
	REV_CMN700_R2P0 = 2,
	REV_CMN700_R3P0 = 3,
	REV_CI700_R0P0 = 0,
	REV_CI700_R1P0 = 1,
	REV_CI700_R2P0 = 2,
};

enum cmu_type_t {
	REF_CMU = 0,
	PHY_CMU = 1,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum compat_regset {
	REGSET_COMPAT_GPR = 0,
	REGSET_COMPAT_VFP = 1,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cppc_regs {
	HIGHEST_PERF = 0,
	NOMINAL_PERF = 1,
	LOW_NON_LINEAR_PERF = 2,
	LOWEST_PERF = 3,
	GUARANTEED_PERF = 4,
	DESIRED_PERF = 5,
	MIN_PERF = 6,
	MAX_PERF = 7,
	PERF_REDUC_TOLERANCE = 8,
	TIME_WINDOW = 9,
	CTR_WRAP_TIME = 10,
	REFERENCE_CTR = 11,
	DELIVERED_CTR = 12,
	PERF_LIMITED = 13,
	ENABLE = 14,
	AUTO_SEL_ENABLE = 15,
	AUTO_ACT_WINDOW = 16,
	ENERGY_PERF = 17,
	REFERENCE_PERF = 18,
	LOWEST_FREQ = 19,
	NOMINAL_FREQ = 20,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_pm_event {
	CPU_PM_ENTER = 0,
	CPU_PM_ENTER_FAILED = 1,
	CPU_PM_EXIT = 2,
	CPU_CLUSTER_PM_ENTER = 3,
	CPU_CLUSTER_PM_ENTER_FAILED = 4,
	CPU_CLUSTER_PM_EXIT = 5,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	CPUTIME_FORCEIDLE = 10,
	NR_STATS = 11,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpubiuctrl_regs {
	CPU_CREDIT_REG = 0,
	CPU_MCP_FLOW_REG = 1,
	CPU_WRITEBACK_CTRL_REG = 2,
	RAC_CONFIG0_REG = 3,
	RAC_CONFIG1_REG = 4,
	NUM_CPU_BIUCTRL_REGS = 5,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_PREPARE = 2,
	CPUHP_PERF_X86_PREPARE = 3,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 4,
	CPUHP_PERF_POWER = 5,
	CPUHP_PERF_SUPERH = 6,
	CPUHP_X86_HPET_DEAD = 7,
	CPUHP_X86_MCE_DEAD = 8,
	CPUHP_VIRT_NET_DEAD = 9,
	CPUHP_IBMVNIC_DEAD = 10,
	CPUHP_SLUB_DEAD = 11,
	CPUHP_DEBUG_OBJ_DEAD = 12,
	CPUHP_MM_WRITEBACK_DEAD = 13,
	CPUHP_MM_VMSTAT_DEAD = 14,
	CPUHP_SOFTIRQ_DEAD = 15,
	CPUHP_NET_MVNETA_DEAD = 16,
	CPUHP_CPUIDLE_DEAD = 17,
	CPUHP_ARM64_FPSIMD_DEAD = 18,
	CPUHP_ARM_OMAP_WAKE_DEAD = 19,
	CPUHP_IRQ_POLL_DEAD = 20,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 21,
	CPUHP_BIO_DEAD = 22,
	CPUHP_ACPI_CPUDRV_DEAD = 23,
	CPUHP_S390_PFAULT_DEAD = 24,
	CPUHP_BLK_MQ_DEAD = 25,
	CPUHP_FS_BUFF_DEAD = 26,
	CPUHP_PRINTK_DEAD = 27,
	CPUHP_MM_MEMCQ_DEAD = 28,
	CPUHP_PERCPU_CNT_DEAD = 29,
	CPUHP_RADIX_DEAD = 30,
	CPUHP_PAGE_ALLOC = 31,
	CPUHP_NET_DEV_DEAD = 32,
	CPUHP_PCI_XGENE_DEAD = 33,
	CPUHP_IOMMU_IOVA_DEAD = 34,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 35,
	CPUHP_PADATA_DEAD = 36,
	CPUHP_AP_DTPM_CPU_DEAD = 37,
	CPUHP_RANDOM_PREPARE = 38,
	CPUHP_WORKQUEUE_PREP = 39,
	CPUHP_POWER_NUMA_PREPARE = 40,
	CPUHP_HRTIMERS_PREPARE = 41,
	CPUHP_X2APIC_PREPARE = 42,
	CPUHP_SMPCFD_PREPARE = 43,
	CPUHP_RELAY_PREPARE = 44,
	CPUHP_MD_RAID5_PREPARE = 45,
	CPUHP_RCUTREE_PREP = 46,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 47,
	CPUHP_POWERPC_PMAC_PREPARE = 48,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 49,
	CPUHP_XEN_PREPARE = 50,
	CPUHP_XEN_EVTCHN_PREPARE = 51,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 52,
	CPUHP_SH_SH3X_PREPARE = 53,
	CPUHP_TOPOLOGY_PREPARE = 54,
	CPUHP_NET_IUCV_PREPARE = 55,
	CPUHP_ARM_BL_PREPARE = 56,
	CPUHP_TRACE_RB_PREPARE = 57,
	CPUHP_MM_ZS_PREPARE = 58,
	CPUHP_MM_ZSWP_POOL_PREPARE = 59,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 60,
	CPUHP_ZCOMP_PREPARE = 61,
	CPUHP_TIMERS_PREPARE = 62,
	CPUHP_TMIGR_PREPARE = 63,
	CPUHP_MIPS_SOC_PREPARE = 64,
	CPUHP_BP_PREPARE_DYN = 65,
	CPUHP_BP_PREPARE_DYN_END = 85,
	CPUHP_BP_KICK_AP = 86,
	CPUHP_BRINGUP_CPU = 87,
	CPUHP_AP_IDLE_DEAD = 88,
	CPUHP_AP_OFFLINE = 89,
	CPUHP_AP_CACHECTRL_STARTING = 90,
	CPUHP_AP_SCHED_STARTING = 91,
	CPUHP_AP_RCUTREE_DYING = 92,
	CPUHP_AP_CPU_PM_STARTING = 93,
	CPUHP_AP_IRQ_GIC_STARTING = 94,
	CPUHP_AP_IRQ_HIP04_STARTING = 95,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 96,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 97,
	CPUHP_AP_IRQ_BCM2836_STARTING = 98,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 99,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 100,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 101,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 102,
	CPUHP_AP_IRQ_THEAD_ACLINT_SSWI_STARTING = 103,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 104,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 105,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 106,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 107,
	CPUHP_AP_PERF_X86_STARTING = 108,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 109,
	CPUHP_AP_PERF_XTENSA_STARTING = 110,
	CPUHP_AP_ARM_VFP_STARTING = 111,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 112,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 113,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 114,
	CPUHP_AP_PERF_ARM_STARTING = 115,
	CPUHP_AP_PERF_RISCV_STARTING = 116,
	CPUHP_AP_ARM_L2X0_STARTING = 117,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 118,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 119,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 120,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 121,
	CPUHP_AP_JCORE_TIMER_STARTING = 122,
	CPUHP_AP_ARM_TWD_STARTING = 123,
	CPUHP_AP_QCOM_TIMER_STARTING = 124,
	CPUHP_AP_TEGRA_TIMER_STARTING = 125,
	CPUHP_AP_ARMADA_TIMER_STARTING = 126,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 127,
	CPUHP_AP_ARC_TIMER_STARTING = 128,
	CPUHP_AP_REALTEK_TIMER_STARTING = 129,
	CPUHP_AP_RISCV_TIMER_STARTING = 130,
	CPUHP_AP_CLINT_TIMER_STARTING = 131,
	CPUHP_AP_CSKY_TIMER_STARTING = 132,
	CPUHP_AP_TI_GP_TIMER_STARTING = 133,
	CPUHP_AP_HYPERV_TIMER_STARTING = 134,
	CPUHP_AP_DUMMY_TIMER_STARTING = 135,
	CPUHP_AP_ARM_XEN_STARTING = 136,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 137,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 138,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 139,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 140,
	CPUHP_AP_SMPCFD_DYING = 141,
	CPUHP_AP_HRTIMERS_DYING = 142,
	CPUHP_AP_TICK_DYING = 143,
	CPUHP_AP_X86_TBOOT_DYING = 144,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 145,
	CPUHP_AP_ONLINE = 146,
	CPUHP_TEARDOWN_CPU = 147,
	CPUHP_AP_ONLINE_IDLE = 148,
	CPUHP_AP_HYPERV_ONLINE = 149,
	CPUHP_AP_KVM_ONLINE = 150,
	CPUHP_AP_SCHED_WAIT_EMPTY = 151,
	CPUHP_AP_SMPBOOT_THREADS = 152,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 153,
	CPUHP_AP_BLK_MQ_ONLINE = 154,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 155,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 156,
	CPUHP_AP_PERF_ONLINE = 157,
	CPUHP_AP_PERF_X86_ONLINE = 158,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 159,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 160,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 161,
	CPUHP_AP_PERF_S390_CF_ONLINE = 162,
	CPUHP_AP_PERF_S390_SF_ONLINE = 163,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 164,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 171,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 172,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 173,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 174,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 175,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 176,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 177,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 178,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 179,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 184,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 185,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 186,
	CPUHP_AP_PERF_CSKY_ONLINE = 187,
	CPUHP_AP_TMIGR_ONLINE = 188,
	CPUHP_AP_WATCHDOG_ONLINE = 189,
	CPUHP_AP_WORKQUEUE_ONLINE = 190,
	CPUHP_AP_RANDOM_ONLINE = 191,
	CPUHP_AP_RCUTREE_ONLINE = 192,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 193,
	CPUHP_AP_ONLINE_DYN = 194,
	CPUHP_AP_ONLINE_DYN_END = 234,
	CPUHP_AP_X86_HPET_ONLINE = 235,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 236,
	CPUHP_AP_ACTIVE = 237,
	CPUHP_ONLINE = 238,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum crb_cancel {
	CRB_CANCEL_INVOKE = 1,
};

enum crb_ctrl_req {
	CRB_CTRL_REQ_CMD_READY = 1,
	CRB_CTRL_REQ_GO_IDLE = 2,
};

enum crb_ctrl_sts {
	CRB_CTRL_STS_ERROR = 1,
	CRB_CTRL_STS_TPM_IDLE = 2,
};

enum crb_defaults {
	CRB_ACPI_START_REVISION_ID = 1,
	CRB_ACPI_START_INDEX = 1,
};

enum crb_loc_ctrl {
	CRB_LOC_CTRL_REQUEST_ACCESS = 1,
	CRB_LOC_CTRL_RELINQUISH = 2,
};

enum crb_loc_state {
	CRB_LOC_STATE_LOC_ASSIGNED = 2,
	CRB_LOC_STATE_TPM_REG_VALID_STS = 128,
};

enum crb_start {
	CRB_START_INVOKE = 1,
};

enum crb_status {
	CRB_DRV_STS_COMPLETE = 1,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	CRYPTOCFGA_REPORT_SIG = 22,
	__CRYPTOCFGA_MAX = 23,
};

enum ct_dccp_states {
	CT_DCCP_NONE = 0,
	CT_DCCP_REQUEST = 1,
	CT_DCCP_RESPOND = 2,
	CT_DCCP_PARTOPEN = 3,
	CT_DCCP_OPEN = 4,
	CT_DCCP_CLOSEREQ = 5,
	CT_DCCP_CLOSING = 6,
	CT_DCCP_TIMEWAIT = 7,
	CT_DCCP_IGNORE = 8,
	CT_DCCP_INVALID = 9,
	__CT_DCCP_MAX = 10,
};

enum ctrl_offsets {
	BASE_OFFSET = 0,
	SLOT_AVAIL1 = 4,
	SLOT_AVAIL2 = 8,
	SLOT_CONFIG = 12,
	SEC_BUS_CONFIG = 16,
	MSI_CTRL = 18,
	PROG_INTERFACE = 19,
	CMD = 20,
	CMD_STATUS = 22,
	INTR_LOC = 24,
	SERR_LOC = 28,
	SERR_INTR_ENABLE = 32,
	SLOT1 = 36,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cxl_config_state {
	CXL_CONFIG_IDLE = 0,
	CXL_CONFIG_INTERLEAVE_ACTIVE = 1,
	CXL_CONFIG_ACTIVE = 2,
	CXL_CONFIG_RESET_PENDING = 3,
	CXL_CONFIG_COMMIT = 4,
};

enum cxl_decoder_mode {
	CXL_DECODER_NONE = 0,
	CXL_DECODER_RAM = 1,
	CXL_DECODER_PMEM = 2,
	CXL_DECODER_MIXED = 3,
	CXL_DECODER_DEAD = 4,
};

enum cxl_decoder_state {
	CXL_DECODER_STATE_MANUAL = 0,
	CXL_DECODER_STATE_AUTO = 1,
};

enum cxl_decoder_type {
	CXL_DECODER_DEVMEM = 2,
	CXL_DECODER_HOSTONLYMEM = 3,
};

enum cxl_devtype {
	CXL_DEVTYPE_DEVMEM = 0,
	CXL_DEVTYPE_CLASSMEM = 1,
};

enum cxl_event_int_mode {
	CXL_INT_NONE = 0,
	CXL_INT_MSI_MSIX = 1,
	CXL_INT_FW = 2,
};

enum cxl_event_log_type {
	CXL_EVENT_TYPE_INFO = 0,
	CXL_EVENT_TYPE_WARN = 1,
	CXL_EVENT_TYPE_FAIL = 2,
	CXL_EVENT_TYPE_FATAL = 3,
	CXL_EVENT_TYPE_MAX = 4,
};

enum cxl_event_type {
	CXL_CPER_EVENT_GENERIC = 0,
	CXL_CPER_EVENT_GEN_MEDIA = 1,
	CXL_CPER_EVENT_DRAM = 2,
	CXL_CPER_EVENT_MEM_MODULE = 3,
};

enum cxl_opcode {
	CXL_MBOX_OP_INVALID = 0,
	CXL_MBOX_OP_RAW = 0,
	CXL_MBOX_OP_GET_EVENT_RECORD = 256,
	CXL_MBOX_OP_CLEAR_EVENT_RECORD = 257,
	CXL_MBOX_OP_GET_EVT_INT_POLICY = 258,
	CXL_MBOX_OP_SET_EVT_INT_POLICY = 259,
	CXL_MBOX_OP_GET_FW_INFO = 512,
	CXL_MBOX_OP_TRANSFER_FW = 513,
	CXL_MBOX_OP_ACTIVATE_FW = 514,
	CXL_MBOX_OP_GET_TIMESTAMP = 768,
	CXL_MBOX_OP_SET_TIMESTAMP = 769,
	CXL_MBOX_OP_GET_SUPPORTED_LOGS = 1024,
	CXL_MBOX_OP_GET_LOG = 1025,
	CXL_MBOX_OP_GET_LOG_CAPS = 1026,
	CXL_MBOX_OP_CLEAR_LOG = 1027,
	CXL_MBOX_OP_GET_SUP_LOG_SUBLIST = 1029,
	CXL_MBOX_OP_IDENTIFY = 16384,
	CXL_MBOX_OP_GET_PARTITION_INFO = 16640,
	CXL_MBOX_OP_SET_PARTITION_INFO = 16641,
	CXL_MBOX_OP_GET_LSA = 16642,
	CXL_MBOX_OP_SET_LSA = 16643,
	CXL_MBOX_OP_GET_HEALTH_INFO = 16896,
	CXL_MBOX_OP_GET_ALERT_CONFIG = 16897,
	CXL_MBOX_OP_SET_ALERT_CONFIG = 16898,
	CXL_MBOX_OP_GET_SHUTDOWN_STATE = 16899,
	CXL_MBOX_OP_SET_SHUTDOWN_STATE = 16900,
	CXL_MBOX_OP_GET_POISON = 17152,
	CXL_MBOX_OP_INJECT_POISON = 17153,
	CXL_MBOX_OP_CLEAR_POISON = 17154,
	CXL_MBOX_OP_GET_SCAN_MEDIA_CAPS = 17155,
	CXL_MBOX_OP_SCAN_MEDIA = 17156,
	CXL_MBOX_OP_GET_SCAN_MEDIA = 17157,
	CXL_MBOX_OP_SANITIZE = 17408,
	CXL_MBOX_OP_SECURE_ERASE = 17409,
	CXL_MBOX_OP_GET_SECURITY_STATE = 17664,
	CXL_MBOX_OP_SET_PASSPHRASE = 17665,
	CXL_MBOX_OP_DISABLE_PASSPHRASE = 17666,
	CXL_MBOX_OP_UNLOCK = 17667,
	CXL_MBOX_OP_FREEZE_SECURITY = 17668,
	CXL_MBOX_OP_PASSPHRASE_SECURE_ERASE = 17669,
	CXL_MBOX_OP_MAX = 65536,
};

enum cxl_pmu_type {
	CXL_PMU_MEMDEV = 0,
};

enum cxl_poison_trace_type {
	CXL_POISON_TRACE_LIST = 0,
	CXL_POISON_TRACE_INJECT = 1,
	CXL_POISON_TRACE_CLEAR = 2,
};

enum cxl_rcrb {
	CXL_RCRB_DOWNSTREAM = 0,
	CXL_RCRB_UPSTREAM = 1,
};

enum cxl_regloc_type {
	CXL_REGLOC_RBI_EMPTY = 0,
	CXL_REGLOC_RBI_COMPONENT = 1,
	CXL_REGLOC_RBI_VIRT = 2,
	CXL_REGLOC_RBI_MEMDEV = 3,
	CXL_REGLOC_RBI_PMU = 4,
	CXL_REGLOC_RBI_TYPES = 5,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum damon_ops_id {
	DAMON_OPS_VADDR = 0,
	DAMON_OPS_FVADDR = 1,
	DAMON_OPS_PADDR = 2,
	NR_DAMON_OPS = 3,
};

enum damon_sysfs_cmd {
	DAMON_SYSFS_CMD_ON = 0,
	DAMON_SYSFS_CMD_OFF = 1,
	DAMON_SYSFS_CMD_COMMIT = 2,
	DAMON_SYSFS_CMD_COMMIT_SCHEMES_QUOTA_GOALS = 3,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_STATS = 4,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_BYTES = 5,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_TRIED_REGIONS = 6,
	DAMON_SYSFS_CMD_CLEAR_SCHEMES_TRIED_REGIONS = 7,
	DAMON_SYSFS_CMD_UPDATE_SCHEMES_EFFECTIVE_QUOTAS = 8,
	NR_DAMON_SYSFS_CMDS = 9,
};

enum damos_action {
	DAMOS_WILLNEED = 0,
	DAMOS_COLD = 1,
	DAMOS_PAGEOUT = 2,
	DAMOS_HUGEPAGE = 3,
	DAMOS_NOHUGEPAGE = 4,
	DAMOS_LRU_PRIO = 5,
	DAMOS_LRU_DEPRIO = 6,
	DAMOS_MIGRATE_HOT = 7,
	DAMOS_MIGRATE_COLD = 8,
	DAMOS_STAT = 9,
	NR_DAMOS_ACTIONS = 10,
};

enum damos_filter_type {
	DAMOS_FILTER_TYPE_ANON = 0,
	DAMOS_FILTER_TYPE_MEMCG = 1,
	DAMOS_FILTER_TYPE_YOUNG = 2,
	DAMOS_FILTER_TYPE_ADDR = 3,
	DAMOS_FILTER_TYPE_TARGET = 4,
	NR_DAMOS_FILTER_TYPES = 5,
};

enum damos_quota_goal_metric {
	DAMOS_QUOTA_USER_INPUT = 0,
	DAMOS_QUOTA_SOME_MEM_PSI_US = 1,
	NR_DAMOS_QUOTA_GOAL_METRICS = 2,
};

enum damos_sysfs_regions_upd_status {
	DAMOS_TRIED_REGIONS_UPD_IDLE = 0,
	DAMOS_TRIED_REGIONS_UPD_STARTED = 1,
	DAMOS_TRIED_REGIONS_UPD_FINISHED = 2,
};

enum damos_wmark_metric {
	DAMOS_WMARK_NONE = 0,
	DAMOS_WMARK_FREE_MEM_RATE = 1,
	NR_DAMOS_WMARK_METRICS = 2,
};

enum data_formats {
	DATA_FMT_DIGEST = 0,
	DATA_FMT_DIGEST_WITH_ALGO = 1,
	DATA_FMT_DIGEST_WITH_TYPE_AND_ALGO = 2,
	DATA_FMT_STRING = 3,
	DATA_FMT_HEX = 4,
	DATA_FMT_UINT = 5,
};

enum dax_access_mode {
	DAX_ACCESS = 0,
	DAX_RECOVERY_WRITE = 1,
};

enum dax_device_flags {
	DAXDEV_ALIVE = 0,
	DAXDEV_WRITE_CACHE = 1,
	DAXDEV_SYNC = 2,
	DAXDEV_NOCACHE = 3,
	DAXDEV_NOMC = 4,
};

enum dax_driver_type {
	DAXDRV_KMEM_TYPE = 0,
	DAXDRV_DEVICE_TYPE = 1,
};

enum dax_wake_mode {
	WAKE_ALL = 0,
	WAKE_NEXT = 1,
};

enum dbc_state {
	DS_DISABLED = 0,
	DS_INITIALIZED = 1,
	DS_ENABLED = 2,
	DS_CONNECTED = 3,
	DS_CONFIGURED = 4,
	DS_MAX = 5,
};

enum dbg_active_el {
	DBG_ACTIVE_EL0 = 0,
	DBG_ACTIVE_EL1 = 1,
};

enum dcb_general_attr_values {
	DCB_ATTR_VALUE_UNDEFINED = 255,
};

enum dcbevent_notif_type {
	DCB_APP_EVENT = 1,
};

enum dcbnl_app_attrs {
	DCB_APP_ATTR_UNDEFINED = 0,
	DCB_APP_ATTR_IDTYPE = 1,
	DCB_APP_ATTR_ID = 2,
	DCB_APP_ATTR_PRIORITY = 3,
	__DCB_APP_ATTR_ENUM_MAX = 4,
	DCB_APP_ATTR_MAX = 3,
};

enum dcbnl_attrs {
	DCB_ATTR_UNDEFINED = 0,
	DCB_ATTR_IFNAME = 1,
	DCB_ATTR_STATE = 2,
	DCB_ATTR_PFC_STATE = 3,
	DCB_ATTR_PFC_CFG = 4,
	DCB_ATTR_NUM_TC = 5,
	DCB_ATTR_PG_CFG = 6,
	DCB_ATTR_SET_ALL = 7,
	DCB_ATTR_PERM_HWADDR = 8,
	DCB_ATTR_CAP = 9,
	DCB_ATTR_NUMTCS = 10,
	DCB_ATTR_BCN = 11,
	DCB_ATTR_APP = 12,
	DCB_ATTR_IEEE = 13,
	DCB_ATTR_DCBX = 14,
	DCB_ATTR_FEATCFG = 15,
	DCB_ATTR_CEE = 16,
	__DCB_ATTR_ENUM_MAX = 17,
	DCB_ATTR_MAX = 16,
};

enum dcbnl_bcn_attrs {
	DCB_BCN_ATTR_UNDEFINED = 0,
	DCB_BCN_ATTR_RP_0 = 1,
	DCB_BCN_ATTR_RP_1 = 2,
	DCB_BCN_ATTR_RP_2 = 3,
	DCB_BCN_ATTR_RP_3 = 4,
	DCB_BCN_ATTR_RP_4 = 5,
	DCB_BCN_ATTR_RP_5 = 6,
	DCB_BCN_ATTR_RP_6 = 7,
	DCB_BCN_ATTR_RP_7 = 8,
	DCB_BCN_ATTR_RP_ALL = 9,
	DCB_BCN_ATTR_BCNA_0 = 10,
	DCB_BCN_ATTR_BCNA_1 = 11,
	DCB_BCN_ATTR_ALPHA = 12,
	DCB_BCN_ATTR_BETA = 13,
	DCB_BCN_ATTR_GD = 14,
	DCB_BCN_ATTR_GI = 15,
	DCB_BCN_ATTR_TMAX = 16,
	DCB_BCN_ATTR_TD = 17,
	DCB_BCN_ATTR_RMIN = 18,
	DCB_BCN_ATTR_W = 19,
	DCB_BCN_ATTR_RD = 20,
	DCB_BCN_ATTR_RU = 21,
	DCB_BCN_ATTR_WRTT = 22,
	DCB_BCN_ATTR_RI = 23,
	DCB_BCN_ATTR_C = 24,
	DCB_BCN_ATTR_ALL = 25,
	__DCB_BCN_ATTR_ENUM_MAX = 26,
	DCB_BCN_ATTR_MAX = 25,
};

enum dcbnl_cap_attrs {
	DCB_CAP_ATTR_UNDEFINED = 0,
	DCB_CAP_ATTR_ALL = 1,
	DCB_CAP_ATTR_PG = 2,
	DCB_CAP_ATTR_PFC = 3,
	DCB_CAP_ATTR_UP2TC = 4,
	DCB_CAP_ATTR_PG_TCS = 5,
	DCB_CAP_ATTR_PFC_TCS = 6,
	DCB_CAP_ATTR_GSP = 7,
	DCB_CAP_ATTR_BCN = 8,
	DCB_CAP_ATTR_DCBX = 9,
	__DCB_CAP_ATTR_ENUM_MAX = 10,
	DCB_CAP_ATTR_MAX = 9,
};

enum dcbnl_commands {
	DCB_CMD_UNDEFINED = 0,
	DCB_CMD_GSTATE = 1,
	DCB_CMD_SSTATE = 2,
	DCB_CMD_PGTX_GCFG = 3,
	DCB_CMD_PGTX_SCFG = 4,
	DCB_CMD_PGRX_GCFG = 5,
	DCB_CMD_PGRX_SCFG = 6,
	DCB_CMD_PFC_GCFG = 7,
	DCB_CMD_PFC_SCFG = 8,
	DCB_CMD_SET_ALL = 9,
	DCB_CMD_GPERM_HWADDR = 10,
	DCB_CMD_GCAP = 11,
	DCB_CMD_GNUMTCS = 12,
	DCB_CMD_SNUMTCS = 13,
	DCB_CMD_PFC_GSTATE = 14,
	DCB_CMD_PFC_SSTATE = 15,
	DCB_CMD_BCN_GCFG = 16,
	DCB_CMD_BCN_SCFG = 17,
	DCB_CMD_GAPP = 18,
	DCB_CMD_SAPP = 19,
	DCB_CMD_IEEE_SET = 20,
	DCB_CMD_IEEE_GET = 21,
	DCB_CMD_GDCBX = 22,
	DCB_CMD_SDCBX = 23,
	DCB_CMD_GFEATCFG = 24,
	DCB_CMD_SFEATCFG = 25,
	DCB_CMD_CEE_GET = 26,
	DCB_CMD_IEEE_DEL = 27,
	__DCB_CMD_ENUM_MAX = 28,
	DCB_CMD_MAX = 27,
};

enum dcbnl_featcfg_attrs {
	DCB_FEATCFG_ATTR_UNDEFINED = 0,
	DCB_FEATCFG_ATTR_ALL = 1,
	DCB_FEATCFG_ATTR_PG = 2,
	DCB_FEATCFG_ATTR_PFC = 3,
	DCB_FEATCFG_ATTR_APP = 4,
	__DCB_FEATCFG_ATTR_ENUM_MAX = 5,
	DCB_FEATCFG_ATTR_MAX = 4,
};

enum dcbnl_numtcs_attrs {
	DCB_NUMTCS_ATTR_UNDEFINED = 0,
	DCB_NUMTCS_ATTR_ALL = 1,
	DCB_NUMTCS_ATTR_PG = 2,
	DCB_NUMTCS_ATTR_PFC = 3,
	__DCB_NUMTCS_ATTR_ENUM_MAX = 4,
	DCB_NUMTCS_ATTR_MAX = 3,
};

enum dcbnl_pfc_up_attrs {
	DCB_PFC_UP_ATTR_UNDEFINED = 0,
	DCB_PFC_UP_ATTR_0 = 1,
	DCB_PFC_UP_ATTR_1 = 2,
	DCB_PFC_UP_ATTR_2 = 3,
	DCB_PFC_UP_ATTR_3 = 4,
	DCB_PFC_UP_ATTR_4 = 5,
	DCB_PFC_UP_ATTR_5 = 6,
	DCB_PFC_UP_ATTR_6 = 7,
	DCB_PFC_UP_ATTR_7 = 8,
	DCB_PFC_UP_ATTR_ALL = 9,
	__DCB_PFC_UP_ATTR_ENUM_MAX = 10,
	DCB_PFC_UP_ATTR_MAX = 9,
};

enum dcbnl_pg_attrs {
	DCB_PG_ATTR_UNDEFINED = 0,
	DCB_PG_ATTR_TC_0 = 1,
	DCB_PG_ATTR_TC_1 = 2,
	DCB_PG_ATTR_TC_2 = 3,
	DCB_PG_ATTR_TC_3 = 4,
	DCB_PG_ATTR_TC_4 = 5,
	DCB_PG_ATTR_TC_5 = 6,
	DCB_PG_ATTR_TC_6 = 7,
	DCB_PG_ATTR_TC_7 = 8,
	DCB_PG_ATTR_TC_MAX = 9,
	DCB_PG_ATTR_TC_ALL = 10,
	DCB_PG_ATTR_BW_ID_0 = 11,
	DCB_PG_ATTR_BW_ID_1 = 12,
	DCB_PG_ATTR_BW_ID_2 = 13,
	DCB_PG_ATTR_BW_ID_3 = 14,
	DCB_PG_ATTR_BW_ID_4 = 15,
	DCB_PG_ATTR_BW_ID_5 = 16,
	DCB_PG_ATTR_BW_ID_6 = 17,
	DCB_PG_ATTR_BW_ID_7 = 18,
	DCB_PG_ATTR_BW_ID_MAX = 19,
	DCB_PG_ATTR_BW_ID_ALL = 20,
	__DCB_PG_ATTR_ENUM_MAX = 21,
	DCB_PG_ATTR_MAX = 20,
};

enum dcbnl_tc_attrs {
	DCB_TC_ATTR_PARAM_UNDEFINED = 0,
	DCB_TC_ATTR_PARAM_PGID = 1,
	DCB_TC_ATTR_PARAM_UP_MAPPING = 2,
	DCB_TC_ATTR_PARAM_STRICT_PRIO = 3,
	DCB_TC_ATTR_PARAM_BW_PCT = 4,
	DCB_TC_ATTR_PARAM_ALL = 5,
	__DCB_TC_ATTR_PARAM_ENUM_MAX = 6,
	DCB_TC_ATTR_PARAM_MAX = 5,
};

enum dccp_pkt_type {
	DCCP_PKT_REQUEST = 0,
	DCCP_PKT_RESPONSE = 1,
	DCCP_PKT_DATA = 2,
	DCCP_PKT_ACK = 3,
	DCCP_PKT_DATAACK = 4,
	DCCP_PKT_CLOSEREQ = 5,
	DCCP_PKT_CLOSE = 6,
	DCCP_PKT_RESET = 7,
	DCCP_PKT_SYNC = 8,
	DCCP_PKT_SYNCACK = 9,
	DCCP_PKT_INVALID = 10,
};

enum dccp_state {
	DCCP_OPEN = 1,
	DCCP_REQUESTING = 2,
	DCCP_LISTEN = 10,
	DCCP_RESPOND = 3,
	DCCP_ACTIVE_CLOSEREQ = 4,
	DCCP_PASSIVE_CLOSE = 8,
	DCCP_CLOSING = 11,
	DCCP_TIME_WAIT = 6,
	DCCP_CLOSED = 7,
	DCCP_NEW_SYN_RECV = 12,
	DCCP_PARTOPEN = 14,
	DCCP_PASSIVE_CLOSEREQ = 15,
	DCCP_MAX_STATES = 16,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum depot_counter_id {
	DEPOT_COUNTER_REFD_ALLOCS = 0,
	DEPOT_COUNTER_REFD_FREES = 1,
	DEPOT_COUNTER_REFD_INUSE = 2,
	DEPOT_COUNTER_FREELIST_SIZE = 3,
	DEPOT_COUNTER_PERSIST_COUNT = 4,
	DEPOT_COUNTER_PERSIST_BYTES = 5,
	DEPOT_COUNTER_COUNT = 6,
};

enum derived_key_type {
	ENC_KEY = 0,
	AUTH_KEY = 1,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_type {
	DEV_UNKNOWN = 0,
	DEV_X1 = 1,
	DEV_X2 = 2,
	DEV_X4 = 3,
	DEV_X8 = 4,
	DEV_X16 = 5,
	DEV_X32 = 6,
	DEV_X64 = 7,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	__DEVLINK_ATTR_MAX = 180,
	DEVLINK_ATTR_MAX = 179,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_ethernet_id {
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC = 0,
};

enum devlink_dpipe_field_ipv4_id {
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP = 0,
};

enum devlink_dpipe_field_ipv6_id {
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_header_id {
	DEVLINK_DPIPE_HEADER_ETHERNET = 0,
	DEVLINK_DPIPE_HEADER_IPV4 = 1,
	DEVLINK_DPIPE_HEADER_IPV6 = 2,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 17,
	DEVLINK_PARAM_GENERIC_ID_MAX = 16,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 0,
	DEVLINK_PARAM_TYPE_U16 = 1,
	DEVLINK_PARAM_TYPE_U32 = 2,
	DEVLINK_PARAM_TYPE_STRING = 3,
	DEVLINK_PARAM_TYPE_BOOL = 4,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum dfll_ctrl_mode {
	DFLL_UNINITIALIZED = 0,
	DFLL_DISABLED = 1,
	DFLL_OPEN_LOOP = 2,
	DFLL_CLOSED_LOOP = 3,
};

enum dfll_tune_range {
	DFLL_TUNE_UNINITIALIZED = 0,
	DFLL_TUNE_LOW = 1,
};

enum die_val {
	DIE_UNUSED = 0,
	DIE_OOPS = 1,
};

enum digest_type {
	DIGEST_TYPE_IMA = 0,
	DIGEST_TYPE_VERITY = 1,
	DIGEST_TYPE__LAST = 2,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum dl_bw_request {
	dl_bw_req_check_overflow = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dm_io_mem_type {
	DM_IO_PAGE_LIST = 0,
	DM_IO_BIO = 1,
	DM_IO_VMA = 2,
	DM_IO_KMEM = 3,
};

enum dm_queue_mode {
	DM_TYPE_NONE = 0,
	DM_TYPE_BIO_BASED = 1,
	DM_TYPE_REQUEST_BASED = 2,
	DM_TYPE_DAX_BIO_BASED = 3,
};

enum dm_uevent_type {
	DM_UEVENT_PATH_FAILED = 0,
	DM_UEVENT_PATH_REINSTATED = 1,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_rx_status {
	DMA_RX_START = 0,
	DMA_RX_RUNNING = 1,
	DMA_RX_SHUTDOWN = 2,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmi_device_type {
	DMI_DEV_TYPE_ANY = 0,
	DMI_DEV_TYPE_OTHER = 1,
	DMI_DEV_TYPE_UNKNOWN = 2,
	DMI_DEV_TYPE_VIDEO = 3,
	DMI_DEV_TYPE_SCSI = 4,
	DMI_DEV_TYPE_ETHERNET = 5,
	DMI_DEV_TYPE_TOKENRING = 6,
	DMI_DEV_TYPE_SOUND = 7,
	DMI_DEV_TYPE_PATA = 8,
	DMI_DEV_TYPE_SATA = 9,
	DMI_DEV_TYPE_SAS = 10,
	DMI_DEV_TYPE_IPMI = -1,
	DMI_DEV_TYPE_OEM_STRING = -2,
	DMI_DEV_TYPE_DEV_ONBOARD = -3,
	DMI_DEV_TYPE_DEV_SLOT = -4,
};

enum dmi_entry_type {
	DMI_ENTRY_BIOS = 0,
	DMI_ENTRY_SYSTEM = 1,
	DMI_ENTRY_BASEBOARD = 2,
	DMI_ENTRY_CHASSIS = 3,
	DMI_ENTRY_PROCESSOR = 4,
	DMI_ENTRY_MEM_CONTROLLER = 5,
	DMI_ENTRY_MEM_MODULE = 6,
	DMI_ENTRY_CACHE = 7,
	DMI_ENTRY_PORT_CONNECTOR = 8,
	DMI_ENTRY_SYSTEM_SLOT = 9,
	DMI_ENTRY_ONBOARD_DEVICE = 10,
	DMI_ENTRY_OEMSTRINGS = 11,
	DMI_ENTRY_SYSCONF = 12,
	DMI_ENTRY_BIOS_LANG = 13,
	DMI_ENTRY_GROUP_ASSOC = 14,
	DMI_ENTRY_SYSTEM_EVENT_LOG = 15,
	DMI_ENTRY_PHYS_MEM_ARRAY = 16,
	DMI_ENTRY_MEM_DEVICE = 17,
	DMI_ENTRY_32_MEM_ERROR = 18,
	DMI_ENTRY_MEM_ARRAY_MAPPED_ADDR = 19,
	DMI_ENTRY_MEM_DEV_MAPPED_ADDR = 20,
	DMI_ENTRY_BUILTIN_POINTING_DEV = 21,
	DMI_ENTRY_PORTABLE_BATTERY = 22,
	DMI_ENTRY_SYSTEM_RESET = 23,
	DMI_ENTRY_HW_SECURITY = 24,
	DMI_ENTRY_SYSTEM_POWER_CONTROLS = 25,
	DMI_ENTRY_VOLTAGE_PROBE = 26,
	DMI_ENTRY_COOLING_DEV = 27,
	DMI_ENTRY_TEMP_PROBE = 28,
	DMI_ENTRY_ELECTRICAL_CURRENT_PROBE = 29,
	DMI_ENTRY_OOB_REMOTE_ACCESS = 30,
	DMI_ENTRY_BIS_ENTRY = 31,
	DMI_ENTRY_SYSTEM_BOOT = 32,
	DMI_ENTRY_MGMT_DEV = 33,
	DMI_ENTRY_MGMT_DEV_COMPONENT = 34,
	DMI_ENTRY_MGMT_DEV_THRES = 35,
	DMI_ENTRY_MEM_CHANNEL = 36,
	DMI_ENTRY_IPMI_DEV = 37,
	DMI_ENTRY_SYS_POWER_SUPPLY = 38,
	DMI_ENTRY_ADDITIONAL = 39,
	DMI_ENTRY_ONBOARD_DEV_EXT = 40,
	DMI_ENTRY_MGMT_CONTROLLER_HOST = 41,
	DMI_ENTRY_INACTIVE = 126,
	DMI_ENTRY_END_OF_TABLE = 127,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dock_callback_type {
	DOCK_CALL_HANDLER = 0,
	DOCK_CALL_FIXUP = 1,
	DOCK_CALL_UEVENT = 2,
};

enum dpfe_commands {
	DPFE_CMD_GET_INFO = 0,
	DPFE_CMD_GET_REFRESH = 1,
	DPFE_CMD_GET_VENDOR = 2,
	DPFE_CMD_MAX = 3,
};

enum dpfe_msg_fields {
	MSG_HEADER = 0,
	MSG_COMMAND = 1,
	MSG_ARG_COUNT = 2,
	MSG_ARG0 = 3,
	MSG_FIELD_MAX = 16,
};

enum dpll_a {
	DPLL_A_ID = 1,
	DPLL_A_MODULE_NAME = 2,
	DPLL_A_PAD = 3,
	DPLL_A_CLOCK_ID = 4,
	DPLL_A_MODE = 5,
	DPLL_A_MODE_SUPPORTED = 6,
	DPLL_A_LOCK_STATUS = 7,
	DPLL_A_TEMP = 8,
	DPLL_A_TYPE = 9,
	DPLL_A_LOCK_STATUS_ERROR = 10,
	DPLL_A_CLOCK_QUALITY_LEVEL = 11,
	__DPLL_A_MAX = 12,
	DPLL_A_MAX = 11,
};

enum dpll_a_pin {
	DPLL_A_PIN_ID = 1,
	DPLL_A_PIN_PARENT_ID = 2,
	DPLL_A_PIN_MODULE_NAME = 3,
	DPLL_A_PIN_PAD = 4,
	DPLL_A_PIN_CLOCK_ID = 5,
	DPLL_A_PIN_BOARD_LABEL = 6,
	DPLL_A_PIN_PANEL_LABEL = 7,
	DPLL_A_PIN_PACKAGE_LABEL = 8,
	DPLL_A_PIN_TYPE = 9,
	DPLL_A_PIN_DIRECTION = 10,
	DPLL_A_PIN_FREQUENCY = 11,
	DPLL_A_PIN_FREQUENCY_SUPPORTED = 12,
	DPLL_A_PIN_FREQUENCY_MIN = 13,
	DPLL_A_PIN_FREQUENCY_MAX = 14,
	DPLL_A_PIN_PRIO = 15,
	DPLL_A_PIN_STATE = 16,
	DPLL_A_PIN_CAPABILITIES = 17,
	DPLL_A_PIN_PARENT_DEVICE = 18,
	DPLL_A_PIN_PARENT_PIN = 19,
	DPLL_A_PIN_PHASE_ADJUST_MIN = 20,
	DPLL_A_PIN_PHASE_ADJUST_MAX = 21,
	DPLL_A_PIN_PHASE_ADJUST = 22,
	DPLL_A_PIN_PHASE_OFFSET = 23,
	DPLL_A_PIN_FRACTIONAL_FREQUENCY_OFFSET = 24,
	DPLL_A_PIN_ESYNC_FREQUENCY = 25,
	DPLL_A_PIN_ESYNC_FREQUENCY_SUPPORTED = 26,
	DPLL_A_PIN_ESYNC_PULSE = 27,
	__DPLL_A_PIN_MAX = 28,
	DPLL_A_PIN_MAX = 27,
};

enum dpll_clock_quality_level {
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_PRC = 1,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_SSU_A = 2,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_SSU_B = 3,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EEC1 = 4,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_PRTC = 5,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EPRTC = 6,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EEEC = 7,
	DPLL_CLOCK_QUALITY_LEVEL_ITU_OPT1_EPRC = 8,
	__DPLL_CLOCK_QUALITY_LEVEL_MAX = 9,
	DPLL_CLOCK_QUALITY_LEVEL_MAX = 8,
};

enum dpll_cmd {
	DPLL_CMD_DEVICE_ID_GET = 1,
	DPLL_CMD_DEVICE_GET = 2,
	DPLL_CMD_DEVICE_SET = 3,
	DPLL_CMD_DEVICE_CREATE_NTF = 4,
	DPLL_CMD_DEVICE_DELETE_NTF = 5,
	DPLL_CMD_DEVICE_CHANGE_NTF = 6,
	DPLL_CMD_PIN_ID_GET = 7,
	DPLL_CMD_PIN_GET = 8,
	DPLL_CMD_PIN_SET = 9,
	DPLL_CMD_PIN_CREATE_NTF = 10,
	DPLL_CMD_PIN_DELETE_NTF = 11,
	DPLL_CMD_PIN_CHANGE_NTF = 12,
	__DPLL_CMD_MAX = 13,
	DPLL_CMD_MAX = 12,
};

enum dpll_lock_status {
	DPLL_LOCK_STATUS_UNLOCKED = 1,
	DPLL_LOCK_STATUS_LOCKED = 2,
	DPLL_LOCK_STATUS_LOCKED_HO_ACQ = 3,
	DPLL_LOCK_STATUS_HOLDOVER = 4,
	__DPLL_LOCK_STATUS_MAX = 5,
	DPLL_LOCK_STATUS_MAX = 4,
};

enum dpll_lock_status_error {
	DPLL_LOCK_STATUS_ERROR_NONE = 1,
	DPLL_LOCK_STATUS_ERROR_UNDEFINED = 2,
	DPLL_LOCK_STATUS_ERROR_MEDIA_DOWN = 3,
	DPLL_LOCK_STATUS_ERROR_FRACTIONAL_FREQUENCY_OFFSET_TOO_HIGH = 4,
	__DPLL_LOCK_STATUS_ERROR_MAX = 5,
	DPLL_LOCK_STATUS_ERROR_MAX = 4,
};

enum dpll_mode {
	DPLL_MODE_MANUAL = 1,
	DPLL_MODE_AUTOMATIC = 2,
	__DPLL_MODE_MAX = 3,
	DPLL_MODE_MAX = 2,
};

enum dpll_pin_capabilities {
	DPLL_PIN_CAPABILITIES_DIRECTION_CAN_CHANGE = 1,
	DPLL_PIN_CAPABILITIES_PRIORITY_CAN_CHANGE = 2,
	DPLL_PIN_CAPABILITIES_STATE_CAN_CHANGE = 4,
};

enum dpll_pin_direction {
	DPLL_PIN_DIRECTION_INPUT = 1,
	DPLL_PIN_DIRECTION_OUTPUT = 2,
	__DPLL_PIN_DIRECTION_MAX = 3,
	DPLL_PIN_DIRECTION_MAX = 2,
};

enum dpll_pin_state {
	DPLL_PIN_STATE_CONNECTED = 1,
	DPLL_PIN_STATE_DISCONNECTED = 2,
	DPLL_PIN_STATE_SELECTABLE = 3,
	__DPLL_PIN_STATE_MAX = 4,
	DPLL_PIN_STATE_MAX = 3,
};

enum dpll_pin_type {
	DPLL_PIN_TYPE_MUX = 1,
	DPLL_PIN_TYPE_EXT = 2,
	DPLL_PIN_TYPE_SYNCE_ETH_PORT = 3,
	DPLL_PIN_TYPE_INT_OSCILLATOR = 4,
	DPLL_PIN_TYPE_GNSS = 5,
	__DPLL_PIN_TYPE_MAX = 6,
	DPLL_PIN_TYPE_MAX = 5,
};

enum dpll_type {
	DPLL_TYPE_PPS = 1,
	DPLL_TYPE_EEC = 2,
	__DPLL_TYPE_MAX = 3,
	DPLL_TYPE_MAX = 2,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_port_mall_action_type {
	DSA_PORT_MALL_MIRROR = 0,
	DSA_PORT_MALL_POLICER = 1,
};

enum dsa_standalone_event {
	DSA_UC_ADD = 0,
	DSA_UC_DEL = 1,
	DSA_MC_ADD = 2,
	DSA_MC_DEL = 3,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
	DSA_TAG_PROTO_VSC73XX_8021Q = 28,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dynevent_type {
	DYNEVENT_TYPE_SYNTH = 1,
	DYNEVENT_TYPE_KPROBE = 2,
	DYNEVENT_TYPE_NONE = 3,
};

enum ec_comms_status {
	EC_COMMS_STATUS_PROCESSING = 1,
};

enum ec_led_colors {
	EC_LED_COLOR_RED = 0,
	EC_LED_COLOR_GREEN = 1,
	EC_LED_COLOR_BLUE = 2,
	EC_LED_COLOR_YELLOW = 3,
	EC_LED_COLOR_WHITE = 4,
	EC_LED_COLOR_AMBER = 5,
	EC_LED_COLOR_COUNT = 6,
};

enum ec_mkbp_event {
	EC_MKBP_EVENT_KEY_MATRIX = 0,
	EC_MKBP_EVENT_HOST_EVENT = 1,
	EC_MKBP_EVENT_SENSOR_FIFO = 2,
	EC_MKBP_EVENT_BUTTON = 3,
	EC_MKBP_EVENT_SWITCH = 4,
	EC_MKBP_EVENT_FINGERPRINT = 5,
	EC_MKBP_EVENT_SYSRQ = 6,
	EC_MKBP_EVENT_HOST_EVENT64 = 7,
	EC_MKBP_EVENT_CEC_EVENT = 8,
	EC_MKBP_EVENT_CEC_MESSAGE = 9,
	EC_MKBP_EVENT_PCHG = 12,
	EC_MKBP_EVENT_COUNT = 13,
};

enum ec_status {
	EC_RES_SUCCESS = 0,
	EC_RES_INVALID_COMMAND = 1,
	EC_RES_ERROR = 2,
	EC_RES_INVALID_PARAM = 3,
	EC_RES_ACCESS_DENIED = 4,
	EC_RES_INVALID_RESPONSE = 5,
	EC_RES_INVALID_VERSION = 6,
	EC_RES_INVALID_CHECKSUM = 7,
	EC_RES_IN_PROGRESS = 8,
	EC_RES_UNAVAILABLE = 9,
	EC_RES_TIMEOUT = 10,
	EC_RES_OVERFLOW = 11,
	EC_RES_INVALID_HEADER = 12,
	EC_RES_REQUEST_TRUNCATED = 13,
	EC_RES_RESPONSE_TOO_BIG = 14,
	EC_RES_BUS_ERROR = 15,
	EC_RES_BUSY = 16,
	EC_RES_INVALID_HEADER_VERSION = 17,
	EC_RES_INVALID_HEADER_CRC = 18,
	EC_RES_INVALID_DATA_CRC = 19,
	EC_RES_DUP_UNAVAILABLE = 20,
};

enum ec_temp_thresholds {
	EC_TEMP_THRESH_WARN = 0,
	EC_TEMP_THRESH_HIGH = 1,
	EC_TEMP_THRESH_HALT = 2,
	EC_TEMP_THRESH_COUNT = 3,
};

enum ecdsasignature_actions {
	ACT_ecdsa_get_signature_r = 0,
	ACT_ecdsa_get_signature_s = 1,
	NR__ecdsasignature_actions = 2,
};

enum ecryptfs_token_types {
	ECRYPTFS_PASSWORD = 0,
	ECRYPTFS_PRIVATE_KEY = 1,
};

enum edac_mc_layer_type {
	EDAC_MC_LAYER_BRANCH = 0,
	EDAC_MC_LAYER_CHANNEL = 1,
	EDAC_MC_LAYER_SLOT = 2,
	EDAC_MC_LAYER_CHIP_SELECT = 3,
	EDAC_MC_LAYER_ALL_MEM = 4,
};

enum edac_type {
	EDAC_UNKNOWN = 0,
	EDAC_NONE = 1,
	EDAC_RESERVED = 2,
	EDAC_PARITY = 3,
	EDAC_EC = 4,
	EDAC_SECDED = 5,
	EDAC_S2ECD2ED = 6,
	EDAC_S4ECD4ED = 7,
	EDAC_S8ECD8ED = 8,
	EDAC_S16ECD16ED = 9,
};

enum efi_cmdline_option {
	EFI_CMDLINE_NONE = 0,
	EFI_CMDLINE_MODE_NUM = 1,
	EFI_CMDLINE_RES = 2,
	EFI_CMDLINE_AUTO = 3,
	EFI_CMDLINE_LIST = 4,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum efi_secureboot_mode {
	efi_secureboot_mode_unset = 0,
	efi_secureboot_mode_unknown = 1,
	efi_secureboot_mode_disabled = 2,
	efi_secureboot_mode_enabled = 3,
};

enum efistub_event_type {
	EFISTUB_EVT_INITRD = 0,
	EFISTUB_EVT_LOAD_OPTIONS = 1,
	EFISTUB_EVT_COUNT = 2,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum eint_type {
	EINT_TYPE_NONE = 0,
	EINT_TYPE_GPIO = 1,
	EINT_TYPE_WKUP = 2,
	EINT_TYPE_WKUP_MUX = 3,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum environment_cap {
	ENVIRON_ANY = 0,
	ENVIRON_INDOOR = 1,
	ENVIRON_OUTDOOR = 2,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 103,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_COUNT = 21,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_command_flags {
	EVENT_CMD_FL_POST_TRIGGER = 1,
	EVENT_CMD_FL_NEEDS_REC = 2,
};

enum event_trigger_type {
	ETT_NONE = 0,
	ETT_TRACE_ONOFF = 1,
	ETT_SNAPSHOT = 2,
	ETT_STACKTRACE = 4,
	ETT_EVENT_ENABLE = 8,
	ETT_EVENT_HIST = 16,
	ETT_HIST_ENABLE = 32,
	ETT_EVENT_EPROBE = 64,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum evm_ima_xattr_type {
	IMA_XATTR_DIGEST = 1,
	EVM_XATTR_HMAC = 2,
	EVM_IMA_XATTR_DIGSIG = 3,
	IMA_XATTR_DIGEST_NG = 4,
	EVM_XATTR_PORTABLE_DIGSIG = 5,
	IMA_VERITY_DIGSIG = 6,
	IMA_XATTR_LAST = 7,
};

enum evtreturn {
	EVT_ERR = -1,
	EVT_DONE = 0,
	EVT_GSER = 1,
	EVT_DISC = 2,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum exception_type {
	except_type_sync = 0,
	except_type_irq = 128,
	except_type_fiq = 256,
	except_type_serror = 384,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum exynos_cpuclk_layout {
	CPUCLK_LAYOUT_E4210 = 0,
	CPUCLK_LAYOUT_E5433 = 1,
	CPUCLK_LAYOUT_E850_CL0 = 2,
	CPUCLK_LAYOUT_E850_CL1 = 3,
};

enum exynos_mipi_phy_id {
	EXYNOS_MIPI_PHY_ID_NONE = -1,
	EXYNOS_MIPI_PHY_ID_CSIS0 = 0,
	EXYNOS_MIPI_PHY_ID_DSIM0 = 1,
	EXYNOS_MIPI_PHY_ID_CSIS1 = 2,
	EXYNOS_MIPI_PHY_ID_DSIM1 = 3,
	EXYNOS_MIPI_PHY_ID_CSIS2 = 4,
	EXYNOS_MIPI_PHYS_NUM = 5,
};

enum exynos_mipi_phy_regmap_id {
	EXYNOS_MIPI_REGMAP_PMU = 0,
	EXYNOS_MIPI_REGMAP_DISP = 1,
	EXYNOS_MIPI_REGMAP_CAM0 = 2,
	EXYNOS_MIPI_REGMAP_CAM1 = 3,
	EXYNOS_MIPI_REGMAPS_NUM = 4,
};

enum exynos_usi_ver {
	USI_VER2 = 2,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fan53555_vendor {
	FAN53526_VENDOR_FAIRCHILD = 0,
	FAN53555_VENDOR_FAIRCHILD = 1,
	FAN53555_VENDOR_ROCKCHIP = 2,
	RK8602_VENDOR_ROCKCHIP = 3,
	FAN53555_VENDOR_SILERGY = 4,
	FAN53526_VENDOR_TCS = 5,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	__FANOTIFY_EVENT_TYPE_NUM = 6,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fetch_op {
	FETCH_OP_NOP = 0,
	FETCH_OP_REG = 1,
	FETCH_OP_STACK = 2,
	FETCH_OP_STACKP = 3,
	FETCH_OP_RETVAL = 4,
	FETCH_OP_IMM = 5,
	FETCH_OP_COMM = 6,
	FETCH_OP_ARG = 7,
	FETCH_OP_FOFFS = 8,
	FETCH_OP_DATA = 9,
	FETCH_OP_EDATA = 10,
	FETCH_OP_DEREF = 11,
	FETCH_OP_UDEREF = 12,
	FETCH_OP_ST_RAW = 13,
	FETCH_OP_ST_MEM = 14,
	FETCH_OP_ST_UMEM = 15,
	FETCH_OP_ST_STRING = 16,
	FETCH_OP_ST_USTRING = 17,
	FETCH_OP_ST_SYMSTR = 18,
	FETCH_OP_ST_EDATA = 19,
	FETCH_OP_MOD_BF = 20,
	FETCH_OP_LP_ARRAY = 21,
	FETCH_OP_TP_ARG = 22,
	FETCH_OP_END = 23,
	FETCH_NOP_SYMBOL = 24,
};

enum fg_filter_id {
	__NO_FGF__ = 0,
	HCRX_FGTnXS = 1,
	__NR_FG_FILTER_IDS__ = 2,
};

enum fgt_group_id {
	__NO_FGT_GROUP__ = 0,
	HFGxTR_GROUP = 1,
	HDFGRTR_GROUP = 2,
	HDFGWTR_GROUP = 2,
	HFGITR_GROUP = 3,
	HAFGRTR_GROUP = 4,
	__NR_FGT_GROUP_IDS__ = 5,
};

enum fh_pll_id {
	FH_ARMCA7PLL = 0,
	FH_ARMCA15PLL = 1,
	FH_MAINPLL = 2,
	FH_MPLL = 3,
	FH_MSDCPLL = 4,
	FH_MMPLL = 5,
	FH_VENCPLL = 6,
	FH_TVDPLL = 7,
	FH_VCODECPLL = 8,
	FH_LVDSPLL = 9,
	FH_MSDC2PLL = 10,
	FH_NR_FH = 11,
};

enum fh_pll_id___2 {
	FH_CA53PLL_LL = 0,
	FH_CA53PLL_BL = 1,
	FH_MAINPLL___2 = 2,
	FH_MPLL___2 = 3,
	FH_MSDCPLL___2 = 4,
	FH_MMPLL___2 = 5,
	FH_VENCPLL___2 = 6,
	FH_TVDPLL___2 = 7,
	FH_VCODECPLL___2 = 8,
	FH_NR_FH___2 = 9,
};

enum fh_pll_id___3 {
	FH_ARMPLL_LL = 0,
	FH_ARMPLL_BL = 1,
	FH_MEMPLL = 2,
	FH_ADSPPLL = 3,
	FH_NNAPLL = 4,
	FH_CCIPLL = 5,
	FH_MFGPLL = 6,
	FH_TVDPLL2 = 7,
	FH_MPLL___3 = 8,
	FH_MMPLL___3 = 9,
	FH_MAINPLL___3 = 10,
	FH_MSDCPLL___3 = 11,
	FH_IMGPLL = 12,
	FH_VDECPLL = 13,
	FH_TVDPLL1 = 14,
	FH_NR_FH___3 = 15,
};

enum fh_pll_id___4 {
	FH_ARMPLL_LL___2 = 0,
	FH_ARMPLL_BL0 = 1,
	FH_ARMPLL_BL1 = 2,
	FH_ARMPLL_BL2 = 3,
	FH_ARMPLL_BL3 = 4,
	FH_CCIPLL___2 = 5,
	FH_MFGPLL___2 = 6,
	FH_MEMPLL___2 = 7,
	FH_MPLL___4 = 8,
	FH_MMPLL___4 = 9,
	FH_MAINPLL___4 = 10,
	FH_MSDCPLL___4 = 11,
	FH_ADSPPLL___2 = 12,
	FH_APUPLL = 13,
	FH_TVDPLL___3 = 14,
	FH_NR_FH___4 = 15,
};

enum fh_pll_id___5 {
	FH_ARMPLL_LL___3 = 0,
	FH_ARMPLL_BL___2 = 1,
	FH_CCIPLL___3 = 2,
	FH_MAINPLL___5 = 3,
	FH_MMPLL___5 = 4,
	FH_TVDPLL___4 = 5,
	FH_RESERVE6 = 6,
	FH_ADSPPLL___3 = 7,
	FH_MFGPLL___3 = 8,
	FH_NNAPLL___2 = 9,
	FH_NNA2PLL = 10,
	FH_MSDCPLL___5 = 11,
	FH_RESERVE12 = 12,
	FH_NR_FH___5 = 13,
};

enum fhctl_variant {
	FHCTL_PLLFH_V1 = 0,
	FHCTL_PLLFH_V2 = 1,
};

enum fib6_walk_state {
	FWS_L = 0,
	FWS_R = 1,
	FWS_C = 2,
	FWS_U = 3,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum field_op_id {
	FIELD_OP_NONE = 0,
	FIELD_OP_PLUS = 1,
	FIELD_OP_MINUS = 2,
	FIELD_OP_UNARY_MINUS = 3,
	FIELD_OP_DIV = 4,
	FIELD_OP_MULT = 5,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum filter_op_ids {
	OP_GLOB = 0,
	OP_NE = 1,
	OP_EQ = 2,
	OP_LE = 3,
	OP_LT = 4,
	OP_GE = 5,
	OP_GT = 6,
	OP_BAND = 7,
	OP_MAX = 8,
};

enum filter_pred_fn {
	FILTER_PRED_FN_NOP = 0,
	FILTER_PRED_FN_64 = 1,
	FILTER_PRED_FN_64_CPUMASK = 2,
	FILTER_PRED_FN_S64 = 3,
	FILTER_PRED_FN_U64 = 4,
	FILTER_PRED_FN_32 = 5,
	FILTER_PRED_FN_32_CPUMASK = 6,
	FILTER_PRED_FN_S32 = 7,
	FILTER_PRED_FN_U32 = 8,
	FILTER_PRED_FN_16 = 9,
	FILTER_PRED_FN_16_CPUMASK = 10,
	FILTER_PRED_FN_S16 = 11,
	FILTER_PRED_FN_U16 = 12,
	FILTER_PRED_FN_8 = 13,
	FILTER_PRED_FN_8_CPUMASK = 14,
	FILTER_PRED_FN_S8 = 15,
	FILTER_PRED_FN_U8 = 16,
	FILTER_PRED_FN_COMM = 17,
	FILTER_PRED_FN_STRING = 18,
	FILTER_PRED_FN_STRLOC = 19,
	FILTER_PRED_FN_STRRELLOC = 20,
	FILTER_PRED_FN_PCHAR_USER = 21,
	FILTER_PRED_FN_PCHAR = 22,
	FILTER_PRED_FN_CPU = 23,
	FILTER_PRED_FN_CPU_CPUMASK = 24,
	FILTER_PRED_FN_CPUMASK = 25,
	FILTER_PRED_FN_CPUMASK_CPU = 26,
	FILTER_PRED_FN_FUNCTION = 27,
	FILTER_PRED_FN_ = 28,
	FILTER_PRED_TEST_VISITED = 29,
};

enum finalization_type {
	FINALIZATION_TYPE_FINAL = 0,
	FINALIZATION_TYPE_FINUP = 1,
	FINALIZATION_TYPE_DIGEST = 2,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_HOLE = 0,
	FIX_FDT_END = 1,
	FIX_FDT = 514,
	FIX_EARLYCON_MEM_BASE = 515,
	FIX_TEXT_POKE0 = 516,
	FIX_APEI_GHES_IRQ = 517,
	FIX_APEI_GHES_SEA = 518,
	FIX_APEI_GHES_SDEI_NORMAL = 519,
	FIX_APEI_GHES_SDEI_CRITICAL = 520,
	FIX_ENTRY_TRAMP_TEXT4 = 521,
	FIX_ENTRY_TRAMP_TEXT3 = 522,
	FIX_ENTRY_TRAMP_TEXT2 = 523,
	FIX_ENTRY_TRAMP_TEXT1 = 524,
	__end_of_permanent_fixed_addresses = 525,
	FIX_BTMAP_END = 525,
	FIX_BTMAP_BEGIN = 972,
	FIX_PTE = 973,
	FIX_PMD = 974,
	FIX_PUD = 975,
	FIX_P4D = 976,
	FIX_PGD = 977,
	__end_of_fixed_addresses = 978,
};

enum flag_bits {
	Faulty = 0,
	In_sync = 1,
	Bitmap_sync = 2,
	WriteMostly = 3,
	AutoDetected = 4,
	Blocked = 5,
	WriteErrorSeen = 6,
	FaultRecorded = 7,
	BlockedBadBlocks = 8,
	WantReplacement = 9,
	Replacement = 10,
	Candidate = 11,
	Journal = 12,
	ClusterRemove = 13,
	ExternalBbl = 14,
	FailFast = 15,
	LastDev = 16,
	CollisionCheck = 17,
	Nonrot = 18,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum flow_offload_tuple_dir {
	FLOW_OFFLOAD_DIR_ORIGINAL = 0,
	FLOW_OFFLOAD_DIR_REPLY = 1,
};

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

enum flush_type {
	FLUSH_TYPE_NONE = 0,
	FLUSH_TYPE_FLUSH = 1,
	FLUSH_TYPE_REIMPORT = 2,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_type {
	FORMAT_TYPE_NONE = 0,
	FORMAT_TYPE_WIDTH = 1,
	FORMAT_TYPE_PRECISION = 2,
	FORMAT_TYPE_CHAR = 3,
	FORMAT_TYPE_STR = 4,
	FORMAT_TYPE_PTR = 5,
	FORMAT_TYPE_PERCENT_CHAR = 6,
	FORMAT_TYPE_INVALID = 7,
	FORMAT_TYPE_LONG_LONG = 8,
	FORMAT_TYPE_ULONG = 9,
	FORMAT_TYPE_LONG = 10,
	FORMAT_TYPE_UBYTE = 11,
	FORMAT_TYPE_BYTE = 12,
	FORMAT_TYPE_USHORT = 13,
	FORMAT_TYPE_SHORT = 14,
	FORMAT_TYPE_UINT = 15,
	FORMAT_TYPE_INT = 16,
	FORMAT_TYPE_SIZE_T = 17,
	FORMAT_TYPE_PTRDIFF = 18,
};

enum fortify_func {
	FORTIFY_FUNC_strncpy = 0,
	FORTIFY_FUNC_strnlen = 1,
	FORTIFY_FUNC_strlen = 2,
	FORTIFY_FUNC_strscpy = 3,
	FORTIFY_FUNC_strlcat = 4,
	FORTIFY_FUNC_strcat = 5,
	FORTIFY_FUNC_strncat = 6,
	FORTIFY_FUNC_memset = 7,
	FORTIFY_FUNC_memcpy = 8,
	FORTIFY_FUNC_memmove = 9,
	FORTIFY_FUNC_memscan = 10,
	FORTIFY_FUNC_memcmp = 11,
	FORTIFY_FUNC_memchr = 12,
	FORTIFY_FUNC_memchr_inv = 13,
	FORTIFY_FUNC_kmemdup = 14,
	FORTIFY_FUNC_strcpy = 15,
	FORTIFY_FUNC_UNKNOWN = 16,
};

enum fp_type {
	FP_STATE_CURRENT = 0,
	FP_STATE_FPSIMD = 1,
	FP_STATE_SVE = 2,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_PATH = 1,
	FSNOTIFY_EVENT_INODE = 2,
	FSNOTIFY_EVENT_DENTRY = 3,
	FSNOTIFY_EVENT_ERROR = 4,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_COUNT = 5,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_COUNT = 3,
	FSNOTIFY_OBJ_TYPE_DETACHED = 3,
};

enum ftr_type {
	FTR_EXACT = 0,
	FTR_LOWER_SAFE = 1,
	FTR_HIGHER_SAFE = 2,
	FTR_HIGHER_OR_ZERO_SAFE = 3,
};

enum ftrace_bug_type {
	FTRACE_BUG_UNKNOWN = 0,
	FTRACE_BUG_INIT = 1,
	FTRACE_BUG_NOP = 2,
	FTRACE_BUG_CALL = 3,
	FTRACE_BUG_UPDATE = 4,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum ftrace_ops_cmd {
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_SELF = 0,
	FTRACE_OPS_CMD_ENABLE_SHARE_IPMODIFY_PEER = 1,
	FTRACE_OPS_CMD_DISABLE_SHARE_IPMODIFY_PEER = 2,
};

enum fullness_group {
	ZS_INUSE_RATIO_0 = 0,
	ZS_INUSE_RATIO_10 = 1,
	ZS_INUSE_RATIO_99 = 10,
	ZS_INUSE_RATIO_100 = 11,
	NR_FULLNESS_GROUPS = 12,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_resource_type {
	RSC_CARVEOUT = 0,
	RSC_DEVMEM = 1,
	RSC_TRACE = 2,
	RSC_VDEV = 3,
	RSC_LAST = 4,
	RSC_VENDOR_START = 128,
	RSC_VENDOR_END = 512,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fw_upload_err {
	FW_UPLOAD_ERR_NONE = 0,
	FW_UPLOAD_ERR_HW_ERROR = 1,
	FW_UPLOAD_ERR_TIMEOUT = 2,
	FW_UPLOAD_ERR_CANCELED = 3,
	FW_UPLOAD_ERR_BUSY = 4,
	FW_UPLOAD_ERR_INVALID_SIZE = 5,
	FW_UPLOAD_ERR_RW_ERROR = 6,
	FW_UPLOAD_ERR_WEAROUT = 7,
	FW_UPLOAD_ERR_FW_INVALID = 8,
	FW_UPLOAD_ERR_MAX = 9,
};

enum fw_upload_prog {
	FW_UPLOAD_PROG_IDLE = 0,
	FW_UPLOAD_PROG_RECEIVING = 1,
	FW_UPLOAD_PROG_PREPARING = 2,
	FW_UPLOAD_PROG_TRANSFERRING = 3,
	FW_UPLOAD_PROG_PROGRAMMING = 4,
	FW_UPLOAD_PROG_MAX = 5,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum genpd_notication {
	GENPD_NOTIFY_PRE_OFF = 0,
	GENPD_NOTIFY_OFF = 1,
	GENPD_NOTIFY_PRE_ON = 2,
	GENPD_NOTIFY_ON = 3,
};

enum gic_intid_range {
	SGI_RANGE = 0,
	PPI_RANGE = 1,
	SPI_RANGE = 2,
	EPPI_RANGE = 3,
	ESPI_RANGE = 4,
	LPI_RANGE = 5,
	__INVALID_RANGE__ = 6,
};

enum gic_type {
	GIC_V2 = 0,
	GIC_V3 = 1,
};

enum gio_reg_index {
	GIO_REG_ODEN = 0,
	GIO_REG_DATA = 1,
	GIO_REG_IODIR = 2,
	GIO_REG_EC = 3,
	GIO_REG_EI = 4,
	GIO_REG_MASK = 5,
	GIO_REG_LEVEL = 6,
	GIO_REG_STAT = 7,
	NUMBER_OF_GIO_REGISTERS = 8,
};

enum gpd_status {
	GENPD_STATE_ON = 0,
	GENPD_STATE_OFF = 1,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum graph_filter_type {
	GRAPH_FILTER_NOTRACE = 0,
	GRAPH_FILTER_FUNCTION = 1,
};

enum gre_conntrack {
	GRE_CT_UNREPLIED = 0,
	GRE_CT_REPLIED = 1,
	GRE_CT_MAX = 2,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handler_id {
	HANDLER_ONMATCH = 1,
	HANDLER_ONMAX = 2,
	HANDLER_ONCHANGE = 3,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum header_fields {
	HDR_PCR = 0,
	HDR_DIGEST = 1,
	HDR_TEMPLATE_NAME = 2,
	HDR_TEMPLATE_DATA = 3,
	HDR__LAST = 4,
};

enum hest_status {
	HEST_ENABLED = 0,
	HEST_DISABLED = 1,
	HEST_NOT_FOUND = 2,
};

enum hi6220_reset_ctrl_type {
	PERIPHERAL = 0,
	MEDIA = 1,
	AO = 2,
};

enum hid_battery_status {
	HID_BATTERY_UNKNOWN = 0,
	HID_BATTERY_QUERIED = 1,
	HID_BATTERY_REPORTED = 2,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hist_field_flags {
	HIST_FIELD_FL_HITCOUNT = 1,
	HIST_FIELD_FL_KEY = 2,
	HIST_FIELD_FL_STRING = 4,
	HIST_FIELD_FL_HEX = 8,
	HIST_FIELD_FL_SYM = 16,
	HIST_FIELD_FL_SYM_OFFSET = 32,
	HIST_FIELD_FL_EXECNAME = 64,
	HIST_FIELD_FL_SYSCALL = 128,
	HIST_FIELD_FL_STACKTRACE = 256,
	HIST_FIELD_FL_LOG2 = 512,
	HIST_FIELD_FL_TIMESTAMP = 1024,
	HIST_FIELD_FL_TIMESTAMP_USECS = 2048,
	HIST_FIELD_FL_VAR = 4096,
	HIST_FIELD_FL_EXPR = 8192,
	HIST_FIELD_FL_VAR_REF = 16384,
	HIST_FIELD_FL_CPU = 32768,
	HIST_FIELD_FL_ALIAS = 65536,
	HIST_FIELD_FL_BUCKET = 131072,
	HIST_FIELD_FL_CONST = 262144,
	HIST_FIELD_FL_PERCENT = 524288,
	HIST_FIELD_FL_GRAPH = 1048576,
};

enum hist_field_fn {
	HIST_FIELD_FN_NOP = 0,
	HIST_FIELD_FN_VAR_REF = 1,
	HIST_FIELD_FN_COUNTER = 2,
	HIST_FIELD_FN_CONST = 3,
	HIST_FIELD_FN_LOG2 = 4,
	HIST_FIELD_FN_BUCKET = 5,
	HIST_FIELD_FN_TIMESTAMP = 6,
	HIST_FIELD_FN_CPU = 7,
	HIST_FIELD_FN_STRING = 8,
	HIST_FIELD_FN_DYNSTRING = 9,
	HIST_FIELD_FN_RELDYNSTRING = 10,
	HIST_FIELD_FN_PSTRING = 11,
	HIST_FIELD_FN_S64 = 12,
	HIST_FIELD_FN_U64 = 13,
	HIST_FIELD_FN_S32 = 14,
	HIST_FIELD_FN_U32 = 15,
	HIST_FIELD_FN_S16 = 16,
	HIST_FIELD_FN_U16 = 17,
	HIST_FIELD_FN_S8 = 18,
	HIST_FIELD_FN_U8 = 19,
	HIST_FIELD_FN_UMINUS = 20,
	HIST_FIELD_FN_MINUS = 21,
	HIST_FIELD_FN_PLUS = 22,
	HIST_FIELD_FN_DIV = 23,
	HIST_FIELD_FN_MULT = 24,
	HIST_FIELD_FN_DIV_POWER2 = 25,
	HIST_FIELD_FN_DIV_NOT_POWER2 = 26,
	HIST_FIELD_FN_DIV_MULT_SHIFT = 27,
	HIST_FIELD_FN_EXECNAME = 28,
	HIST_FIELD_FN_STACK = 29,
};

enum hk_flags {
	HK_FLAG_TIMER = 1,
	HK_FLAG_RCU = 2,
	HK_FLAG_MISC = 4,
	HK_FLAG_SCHED = 8,
	HK_FLAG_TICK = 16,
	HK_FLAG_DOMAIN = 32,
	HK_FLAG_WQ = 64,
	HK_FLAG_MANAGED_IRQ = 128,
	HK_FLAG_KTHREAD = 256,
};

enum hk_type {
	HK_TYPE_TIMER = 0,
	HK_TYPE_RCU = 1,
	HK_TYPE_MISC = 2,
	HK_TYPE_SCHED = 3,
	HK_TYPE_TICK = 4,
	HK_TYPE_DOMAIN = 5,
	HK_TYPE_WQ = 6,
	HK_TYPE_MANAGED_IRQ = 7,
	HK_TYPE_KTHREAD = 8,
	HK_TYPE_MAX = 9,
};

enum hmm_pfn_flags {
	HMM_PFN_VALID = 9223372036854775808ULL,
	HMM_PFN_WRITE = 4611686018427387904ULL,
	HMM_PFN_ERROR = 2305843009213693952ULL,
	HMM_PFN_ORDER_SHIFT = 56ULL,
	HMM_PFN_REQ_FAULT = 9223372036854775808ULL,
	HMM_PFN_REQ_WRITE = 4611686018427387904ULL,
	HMM_PFN_FLAGS = 18374686479671623680ULL,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum host_event_code {
	EC_HOST_EVENT_LID_CLOSED = 1,
	EC_HOST_EVENT_LID_OPEN = 2,
	EC_HOST_EVENT_POWER_BUTTON = 3,
	EC_HOST_EVENT_AC_CONNECTED = 4,
	EC_HOST_EVENT_AC_DISCONNECTED = 5,
	EC_HOST_EVENT_BATTERY_LOW = 6,
	EC_HOST_EVENT_BATTERY_CRITICAL = 7,
	EC_HOST_EVENT_BATTERY = 8,
	EC_HOST_EVENT_THERMAL_THRESHOLD = 9,
	EC_HOST_EVENT_DEVICE = 10,
	EC_HOST_EVENT_THERMAL = 11,
	EC_HOST_EVENT_USB_CHARGER = 12,
	EC_HOST_EVENT_KEY_PRESSED = 13,
	EC_HOST_EVENT_INTERFACE_READY = 14,
	EC_HOST_EVENT_KEYBOARD_RECOVERY = 15,
	EC_HOST_EVENT_THERMAL_SHUTDOWN = 16,
	EC_HOST_EVENT_BATTERY_SHUTDOWN = 17,
	EC_HOST_EVENT_THROTTLE_START = 18,
	EC_HOST_EVENT_THROTTLE_STOP = 19,
	EC_HOST_EVENT_HANG_DETECT = 20,
	EC_HOST_EVENT_HANG_REBOOT = 21,
	EC_HOST_EVENT_PD_MCU = 22,
	EC_HOST_EVENT_BATTERY_STATUS = 23,
	EC_HOST_EVENT_PANIC = 24,
	EC_HOST_EVENT_KEYBOARD_FASTBOOT = 25,
	EC_HOST_EVENT_RTC = 26,
	EC_HOST_EVENT_MKBP = 27,
	EC_HOST_EVENT_USB_MUX = 28,
	EC_HOST_EVENT_MODE_CHANGE = 29,
	EC_HOST_EVENT_KEYBOARD_RECOVERY_HW_REINIT = 30,
	EC_HOST_EVENT_WOV = 31,
	EC_HOST_EVENT_INVALID = 32,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hprobe_state {
	HPROBE_LEASED = 0,
	HPROBE_STABLE = 1,
	HPROBE_GONE = 2,
	HPROBE_CONSUMED = 3,
};

enum hpx_type3_cfg_loc {
	HPX_CFG_PCICFG = 0,
	HPX_CFG_PCIE_CAP = 1,
	HPX_CFG_PCIE_CAP_EXT = 2,
	HPX_CFG_VEND_CAP = 3,
	HPX_CFG_DVSEC = 4,
	HPX_CFG_MAX = 5,
};

enum hpx_type3_dev_type {
	HPX_TYPE_ENDPOINT = 1,
	HPX_TYPE_LEG_END = 2,
	HPX_TYPE_RC_END = 4,
	HPX_TYPE_RC_EC = 8,
	HPX_TYPE_ROOT_PORT = 16,
	HPX_TYPE_UPSTREAM = 32,
	HPX_TYPE_DOWNSTREAM = 64,
	HPX_TYPE_PCI_BRIDGE = 128,
	HPX_TYPE_PCIE_BRIDGE = 256,
};

enum hpx_type3_fn_type {
	HPX_FN_NORMAL = 1,
	HPX_FN_SRIOV_PHYS = 2,
	HPX_FN_SRIOV_VIRT = 4,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hsr_port_type {
	HSR_PT_NONE = 0,
	HSR_PT_SLAVE_A = 1,
	HSR_PT_SLAVE_B = 2,
	HSR_PT_INTERLINK = 3,
	HSR_PT_MASTER = 4,
	HSR_PT_PORTS = 5,
};

enum hsr_version {
	HSR_V0 = 0,
	HSR_V1 = 1,
	PRP_V1 = 2,
};

enum hte_edge {
	HTE_EDGE_NO_SETUP = 1,
	HTE_RISING_EDGE_TS = 2,
	HTE_FALLING_EDGE_TS = 4,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hugetlb_memory_event {
	HUGETLB_MAX = 0,
	HUGETLB_NR_MEMORY_EVENTS = 1,
};

enum hugetlb_page_flags {
	HPG_restore_reserve = 0,
	HPG_migratable = 1,
	HPG_temporary = 2,
	HPG_freed = 3,
	HPG_vmemmap_optimized = 4,
	HPG_raw_hwp_unreliable = 5,
	__NR_HPAGEFLAGS = 6,
};

enum hugetlb_param {
	Opt_gid___6 = 0,
	Opt_min_size = 1,
	Opt_mode___4 = 2,
	Opt_nr_inodes = 3,
	Opt_pagesize = 4,
	Opt_size = 5,
	Opt_uid___6 = 6,
};

enum hugetlbfs_size_type {
	NO_SIZE = 0,
	SIZE_STD = 1,
	SIZE_PERCENT = 2,
};

enum hw_breakpoint_ops {
	HW_BREAKPOINT_INSTALL = 0,
	HW_BREAKPOINT_UNINSTALL = 1,
	HW_BREAKPOINT_RESTORE = 2,
};

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_intrusion_attributes {
	hwmon_intrusion_alarm = 0,
	hwmon_intrusion_beep = 1,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_UNSPEC = 0,
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_driver_flags {
	I2C_DRV_ACPI_WAIVE_D0_PROBE = 1,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum i2c_slave_read_status {
	I2C_SLAVE_RX_FIFO_EMPTY = 0,
	I2C_SLAVE_RX_START = 1,
	I2C_SLAVE_RX_DATA = 2,
	I2C_SLAVE_RX_END = 3,
};

enum i2c_type_exynos {
	I2C_TYPE_EXYNOS5 = 0,
	I2C_TYPE_EXYNOS7 = 1,
	I2C_TYPE_EXYNOSAUTOV9 = 2,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum id_action {
	ID_REMOVE = 0,
	ID_ADD = 1,
};

enum ieee80211_bss_type {
	IEEE80211_BSS_TYPE_ESS = 0,
	IEEE80211_BSS_TYPE_PBSS = 1,
	IEEE80211_BSS_TYPE_IBSS = 2,
	IEEE80211_BSS_TYPE_MBSS = 3,
	IEEE80211_BSS_TYPE_ANY = 4,
};

enum ieee80211_edmg_bw_config {
	IEEE80211_EDMG_BW_CONFIG_4 = 4,
	IEEE80211_EDMG_BW_CONFIG_5 = 5,
	IEEE80211_EDMG_BW_CONFIG_6 = 6,
	IEEE80211_EDMG_BW_CONFIG_7 = 7,
	IEEE80211_EDMG_BW_CONFIG_8 = 8,
	IEEE80211_EDMG_BW_CONFIG_9 = 9,
	IEEE80211_EDMG_BW_CONFIG_10 = 10,
	IEEE80211_EDMG_BW_CONFIG_11 = 11,
	IEEE80211_EDMG_BW_CONFIG_12 = 12,
	IEEE80211_EDMG_BW_CONFIG_13 = 13,
	IEEE80211_EDMG_BW_CONFIG_14 = 14,
	IEEE80211_EDMG_BW_CONFIG_15 = 15,
};

enum ieee802154_filtering_level {
	IEEE802154_FILTERING_NONE = 0,
	IEEE802154_FILTERING_1_FCS = 1,
	IEEE802154_FILTERING_2_PROMISCUOUS = 2,
	IEEE802154_FILTERING_3_SCAN = 3,
	IEEE802154_FILTERING_4_FRAME_FIELDS = 4,
};

enum ieee_attrs {
	DCB_ATTR_IEEE_UNSPEC = 0,
	DCB_ATTR_IEEE_ETS = 1,
	DCB_ATTR_IEEE_PFC = 2,
	DCB_ATTR_IEEE_APP_TABLE = 3,
	DCB_ATTR_IEEE_PEER_ETS = 4,
	DCB_ATTR_IEEE_PEER_PFC = 5,
	DCB_ATTR_IEEE_PEER_APP = 6,
	DCB_ATTR_IEEE_MAXRATE = 7,
	DCB_ATTR_IEEE_QCN = 8,
	DCB_ATTR_IEEE_QCN_STATS = 9,
	DCB_ATTR_DCB_BUFFER = 10,
	DCB_ATTR_DCB_APP_TRUST_TABLE = 11,
	DCB_ATTR_DCB_REWR_TABLE = 12,
	__DCB_ATTR_IEEE_MAX = 13,
};

enum ieee_attrs_app {
	DCB_ATTR_IEEE_APP_UNSPEC = 0,
	DCB_ATTR_IEEE_APP = 1,
	DCB_ATTR_DCB_APP = 2,
	__DCB_ATTR_IEEE_APP_MAX = 3,
};

enum ima_fs_flags {
	IMA_FS_BUSY = 0,
};

enum ima_hooks {
	NONE = 0,
	FILE_CHECK = 1,
	MMAP_CHECK = 2,
	MMAP_CHECK_REQPROT = 3,
	BPRM_CHECK = 4,
	CREDS_CHECK = 5,
	POST_SETATTR = 6,
	MODULE_CHECK = 7,
	FIRMWARE_CHECK = 8,
	KEXEC_KERNEL_CHECK = 9,
	KEXEC_INITRAMFS_CHECK = 10,
	POLICY_CHECK = 11,
	KEXEC_CMDLINE = 12,
	KEY_CHECK = 13,
	CRITICAL_DATA = 14,
	SETXATTR_CHECK = 15,
	MAX_CHECK = 16,
};

enum ima_show_type {
	IMA_SHOW_BINARY = 0,
	IMA_SHOW_BINARY_NO_FIELD_LEN = 1,
	IMA_SHOW_BINARY_OLD_STRING_FMT = 2,
	IMA_SHOW_ASCII = 3,
};

enum in6_addr_gen_mode {
	IN6_ADDR_GEN_MODE_EUI64 = 0,
	IN6_ADDR_GEN_MODE_NONE = 1,
	IN6_ADDR_GEN_MODE_STABLE_PRIVACY = 2,
	IN6_ADDR_GEN_MODE_RANDOM = 3,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum inplace_mode {
	OUT_OF_PLACE = 0,
	INPLACE_ONE_SGLIST = 1,
	INPLACE_TWO_SGLISTS = 2,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum integrity_status {
	INTEGRITY_PASS = 0,
	INTEGRITY_PASS_IMMUTABLE = 1,
	INTEGRITY_FAIL = 2,
	INTEGRITY_FAIL_IMMUTABLE = 3,
	INTEGRITY_NOLABEL = 4,
	INTEGRITY_NOXATTRS = 5,
	INTEGRITY_UNKNOWN = 6,
};

enum io_pgtable_caps {
	IO_PGTABLE_CAP_CUSTOM_ALLOCATOR = 1,
};

enum io_pgtable_fmt {
	ARM_32_LPAE_S1 = 0,
	ARM_32_LPAE_S2 = 1,
	ARM_64_LPAE_S1 = 2,
	ARM_64_LPAE_S2 = 3,
	ARM_V7S = 4,
	ARM_MALI_LPAE = 5,
	AMD_IOMMU_V1 = 6,
	AMD_IOMMU_V2 = 7,
	APPLE_DART = 8,
	APPLE_DART2 = 9,
	IO_PGTABLE_NUM_FMTS = 10,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
	IO_URING_F_TASK_DEAD = 8192,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_napi_op {
	IO_URING_NAPI_REGISTER_OP = 0,
	IO_URING_NAPI_STATIC_ADD_ID = 1,
	IO_URING_NAPI_STATIC_DEL_ID = 2,
};

enum io_uring_napi_tracking_strategy {
	IO_URING_NAPI_TRACKING_DYNAMIC = 0,
	IO_URING_NAPI_TRACKING_STATIC = 1,
	IO_URING_NAPI_TRACKING_INACTIVE = 255,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_LAST = 58,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_SEND_MSG_RING = 31,
	IORING_REGISTER_RESIZE_RINGS = 33,
	IORING_REGISTER_MEM_REGION = 34,
	IORING_REGISTER_LAST = 35,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum io_wq_type {
	IO_WQ_BOUND = 0,
	IO_WQ_UNBOUND = 1,
};

enum ioam6_event_attr {
	IOAM6_EVENT_ATTR_UNSPEC = 0,
	IOAM6_EVENT_ATTR_TRACE_NAMESPACE = 1,
	IOAM6_EVENT_ATTR_TRACE_NODELEN = 2,
	IOAM6_EVENT_ATTR_TRACE_TYPE = 3,
	IOAM6_EVENT_ATTR_TRACE_DATA = 4,
	__IOAM6_EVENT_ATTR_MAX = 5,
};

enum ioam6_event_type {
	IOAM6_EVENT_UNSPEC = 0,
	IOAM6_EVENT_TRACE = 1,
};

enum iodev_type {
	IODEV_CPUIF = 0,
	IODEV_DIST = 1,
	IODEV_REDIST = 2,
	IODEV_ITS = 3,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_dev_features {
	IOMMU_DEV_FEAT_SVA = 0,
	IOMMU_DEV_FEAT_IOPF = 1,
};

enum iommu_dma_cookie_type {
	IOMMU_DMA_IOVA_COOKIE = 0,
	IOMMU_DMA_MSI_COOKIE = 1,
};

enum iommu_dma_queue_type {
	IOMMU_DMA_OPTS_PER_CPU_QUEUE = 0,
	IOMMU_DMA_OPTS_SINGLE_QUEUE = 1,
};

enum iommu_fault_type {
	IOMMU_FAULT_PAGE_REQ = 1,
};

enum iommu_hw_info_type {
	IOMMU_HW_INFO_TYPE_NONE = 0,
	IOMMU_HW_INFO_TYPE_INTEL_VTD = 1,
	IOMMU_HW_INFO_TYPE_ARM_SMMUV3 = 2,
};

enum iommu_hwpt_data_type {
	IOMMU_HWPT_DATA_NONE = 0,
	IOMMU_HWPT_DATA_VTD_S1 = 1,
	IOMMU_HWPT_DATA_ARM_SMMUV3 = 2,
};

enum iommu_page_response_code {
	IOMMU_PAGE_RESP_SUCCESS = 0,
	IOMMU_PAGE_RESP_INVALID = 1,
	IOMMU_PAGE_RESP_FAILURE = 2,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum iommu_viommu_type {
	IOMMU_VIOMMU_TYPE_DEFAULT = 0,
	IOMMU_VIOMMU_TYPE_ARM_SMMUV3 = 1,
};

enum iommufd_hw_capabilities {
	IOMMU_HW_CAP_DIRTY_TRACKING = 1,
};

enum iommufd_hwpt_alloc_flags {
	IOMMU_HWPT_ALLOC_NEST_PARENT = 1,
	IOMMU_HWPT_ALLOC_DIRTY_TRACKING = 2,
	IOMMU_HWPT_FAULT_ID_VALID = 4,
	IOMMU_HWPT_ALLOC_PASID = 8,
};

enum iommufd_hwpt_get_dirty_bitmap_flags {
	IOMMU_HWPT_GET_DIRTY_BITMAP_NO_CLEAR = 1,
};

enum iommufd_hwpt_set_dirty_tracking_flags {
	IOMMU_HWPT_DIRTY_TRACKING_ENABLE = 1,
};

enum iommufd_ioas_map_flags {
	IOMMU_IOAS_MAP_FIXED_IOVA = 1,
	IOMMU_IOAS_MAP_WRITEABLE = 2,
	IOMMU_IOAS_MAP_READABLE = 4,
};

enum iommufd_object_type {
	IOMMUFD_OBJ_NONE = 0,
	IOMMUFD_OBJ_ANY = 0,
	IOMMUFD_OBJ_DEVICE = 1,
	IOMMUFD_OBJ_HWPT_PAGING = 2,
	IOMMUFD_OBJ_HWPT_NESTED = 3,
	IOMMUFD_OBJ_IOAS = 4,
	IOMMUFD_OBJ_ACCESS = 5,
	IOMMUFD_OBJ_FAULT = 6,
	IOMMUFD_OBJ_VIOMMU = 7,
	IOMMUFD_OBJ_VDEVICE = 8,
	IOMMUFD_OBJ_MAX = 9,
};

enum iommufd_option {
	IOMMU_OPTION_RLIMIT_MODE = 0,
	IOMMU_OPTION_HUGE_PAGES = 1,
};

enum iommufd_option_ops {
	IOMMU_OPTION_OP_SET = 0,
	IOMMU_OPTION_OP_GET = 1,
};

enum iommufd_page_response_code {
	IOMMUFD_PAGE_RESP_SUCCESS = 0,
	IOMMUFD_PAGE_RESP_INVALID = 1,
};

enum iommufd_vfio_ioas_op {
	IOMMU_VFIO_IOAS_GET = 0,
	IOMMU_VFIO_IOAS_SET = 1,
	IOMMU_VFIO_IOAS_CLEAR = 2,
};

enum iopt_address_type {
	IOPT_ADDRESS_USER = 0,
	IOPT_ADDRESS_FILE = 1,
};

enum ip6_defrag_users {
	IP6_DEFRAG_LOCAL_DELIVER = 0,
	IP6_DEFRAG_CONNTRACK_IN = 1,
	__IP6_DEFRAG_CONNTRACK_IN = 65536,
	IP6_DEFRAG_CONNTRACK_OUT = 65537,
	__IP6_DEFRAG_CONNTRACK_OUT = 131072,
	IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 131073,
	__IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 196608,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipi_msg_type {
	IPI_RESCHEDULE = 0,
	IPI_CALL_FUNC = 1,
	IPI_CPU_STOP = 2,
	IPI_CPU_STOP_NMI = 3,
	IPI_TIMER = 4,
	IPI_IRQ_WORK = 5,
	NR_IPI = 6,
	IPI_CPU_BACKTRACE = 6,
	IPI_KGDB_ROUNDUP = 7,
	MAX_IPI = 8,
};

enum ipmi_addr_space {
	IPMI_IO_ADDR_SPACE = 0,
	IPMI_MEM_ADDR_SPACE = 1,
};

enum ipmi_addr_src {
	SI_INVALID = 0,
	SI_HOTMOD = 1,
	SI_HARDCODED = 2,
	SI_SPMI = 3,
	SI_ACPI = 4,
	SI_SMBIOS = 5,
	SI_PCI = 6,
	SI_DEVICETREE = 7,
	SI_PLATFORM = 8,
	SI_LAST = 9,
};

enum ipmi_plat_interface_type {
	IPMI_PLAT_IF_SI = 0,
	IPMI_PLAT_IF_SSIF = 1,
};

enum iproc_arm_pll_fid {
	ARM_PLL_FID_CRYSTAL_CLK = 0,
	ARM_PLL_FID_SYS_CLK = 2,
	ARM_PLL_FID_CH0_SLOW_CLK = 6,
	ARM_PLL_FID_CH1_FAST_CLK = 7,
};

enum iproc_msi_reg {
	IPROC_MSI_EQ_PAGE = 0,
	IPROC_MSI_EQ_PAGE_UPPER = 1,
	IPROC_MSI_PAGE = 2,
	IPROC_MSI_PAGE_UPPER = 3,
	IPROC_MSI_CTRL = 4,
	IPROC_MSI_EQ_HEAD = 5,
	IPROC_MSI_EQ_TAIL = 6,
	IPROC_MSI_INTS_EN = 7,
	IPROC_MSI_REG_SIZE = 8,
};

enum iproc_pcie_ib_map_type {
	IPROC_PCIE_IB_MAP_MEM = 0,
	IPROC_PCIE_IB_MAP_IO = 1,
	IPROC_PCIE_IB_MAP_INVALID = 2,
};

enum iproc_pcie_reg {
	IPROC_PCIE_CLK_CTRL = 0,
	IPROC_PCIE_MSI_GIC_MODE = 1,
	IPROC_PCIE_MSI_BASE_ADDR = 2,
	IPROC_PCIE_MSI_WINDOW_SIZE = 3,
	IPROC_PCIE_MSI_ADDR_LO = 4,
	IPROC_PCIE_MSI_ADDR_HI = 5,
	IPROC_PCIE_MSI_EN_CFG = 6,
	IPROC_PCIE_CFG_IND_ADDR = 7,
	IPROC_PCIE_CFG_IND_DATA = 8,
	IPROC_PCIE_CFG_ADDR = 9,
	IPROC_PCIE_CFG_DATA = 10,
	IPROC_PCIE_INTX_EN = 11,
	IPROC_PCIE_OARR0 = 12,
	IPROC_PCIE_OMAP0 = 13,
	IPROC_PCIE_OARR1 = 14,
	IPROC_PCIE_OMAP1 = 15,
	IPROC_PCIE_OARR2 = 16,
	IPROC_PCIE_OMAP2 = 17,
	IPROC_PCIE_OARR3 = 18,
	IPROC_PCIE_OMAP3 = 19,
	IPROC_PCIE_IARR0 = 20,
	IPROC_PCIE_IMAP0 = 21,
	IPROC_PCIE_IARR1 = 22,
	IPROC_PCIE_IMAP1 = 23,
	IPROC_PCIE_IARR2 = 24,
	IPROC_PCIE_IMAP2 = 25,
	IPROC_PCIE_IARR3 = 26,
	IPROC_PCIE_IMAP3 = 27,
	IPROC_PCIE_IARR4 = 28,
	IPROC_PCIE_IMAP4 = 29,
	IPROC_PCIE_CFG_RD_STATUS = 30,
	IPROC_PCIE_LINK_STATUS = 31,
	IPROC_PCIE_APB_ERR_EN = 32,
	IPROC_PCIE_MAX_NUM_REG = 33,
};

enum iproc_pcie_type {
	IPROC_PCIE_PAXB_BCMA = 0,
	IPROC_PCIE_PAXB = 1,
	IPROC_PCIE_PAXB_V2 = 2,
	IPROC_PCIE_PAXC = 3,
	IPROC_PCIE_PAXC_V2 = 4,
};

enum iproc_pinconf_ctrl_type {
	IOCTRL_TYPE_AON = 1,
	IOCTRL_TYPE_CDRU = 2,
	IOCTRL_TYPE_INVALID = 3,
};

enum iproc_pinconf_param {
	IPROC_PINCONF_DRIVE_STRENGTH = 0,
	IPROC_PINCONF_BIAS_DISABLE = 1,
	IPROC_PINCONF_BIAS_PULL_UP = 2,
	IPROC_PINCONF_BIAS_PULL_DOWN = 3,
	IPROC_PINCON_MAX = 4,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irq_source {
	SINGLE_L2 = 0,
	MUXED_L1 = 1,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum its_vcpu_info_cmd_type {
	MAP_VLPI = 0,
	GET_VLPI = 1,
	PROP_UPDATE_VLPI = 2,
	PROP_UPDATE_AND_INV_VLPI = 3,
	SCHEDULE_VPE = 4,
	DESCHEDULE_VPE = 5,
	COMMIT_VPE = 6,
	INVALL_VPE = 7,
	PROP_UPDATE_VSGI = 8,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 16,
	BH_JWrite = 17,
	BH_Freed = 18,
	BH_Revoked = 19,
	BH_RevokeValid = 20,
	BH_JBDDirty = 21,
	BH_JournalHead = 22,
	BH_Shadow = 23,
	BH_Verified = 24,
	BH_JBDPrivateStart = 25,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kcore_type {
	KCORE_TEXT = 0,
	KCORE_VMALLOC = 1,
	KCORE_RAM = 2,
	KCORE_VMEMMAP = 3,
	KCORE_USER = 4,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfence_counter_id {
	KFENCE_COUNTER_ALLOCATED = 0,
	KFENCE_COUNTER_ALLOCS = 1,
	KFENCE_COUNTER_FREES = 2,
	KFENCE_COUNTER_ZOMBIES = 3,
	KFENCE_COUNTER_BUGS = 4,
	KFENCE_COUNTER_SKIP_INCOMPAT = 5,
	KFENCE_COUNTER_SKIP_CAPACITY = 6,
	KFENCE_COUNTER_SKIP_COVERED = 7,
	KFENCE_COUNTER_COUNT = 8,
};

enum kfence_error_type {
	KFENCE_ERROR_OOB = 0,
	KFENCE_ERROR_UAF = 1,
	KFENCE_ERROR_CORRUPTION = 2,
	KFENCE_ERROR_INVALID = 3,
	KFENCE_ERROR_INVALID_FREE = 4,
};

enum kfence_object_state {
	KFENCE_OBJECT_UNUSED = 0,
	KFENCE_OBJECT_ALLOCATED = 1,
	KFENCE_OBJECT_RCU_FREEING = 2,
	KFENCE_OBJECT_FREED = 3,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
	KF_ARG_PTR_TO_IRQ_FLAG = 17,
};

enum kgdb_bpstate {
	BP_UNDEFINED = 0,
	BP_REMOVED = 1,
	BP_SET = 2,
	BP_ACTIVE = 3,
};

enum kgdb_bptype {
	BP_BREAKPOINT = 0,
	BP_HARDWARE_BREAKPOINT = 1,
	BP_WRITE_WATCHPOINT = 2,
	BP_READ_WATCHPOINT = 3,
	BP_ACCESS_WATCHPOINT = 4,
	BP_POKE_BREAKPOINT = 5,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 15,
	KMALLOC_RECLAIM = 16,
	KMALLOC_DMA = 17,
	KMALLOC_CGROUP = 18,
	NR_KMALLOC_TYPES = 19,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kp_band {
	KP_BAND_MID = 0,
	KP_BAND_HIGH = 1,
	KP_BAND_HIGH_HIGH = 2,
};

enum kprobe_slot_state {
	SLOT_CLEAN = 0,
	SLOT_DIRTY = 1,
	SLOT_USED = 2,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum kunwind_source {
	KUNWIND_SOURCE_UNKNOWN = 0,
	KUNWIND_SOURCE_FRAME = 1,
	KUNWIND_SOURCE_CALLER = 2,
	KUNWIND_SOURCE_TASK = 3,
	KUNWIND_SOURCE_REGS_PC = 4,
};

enum kvm_arch_timer_regs {
	TIMER_REG_CNT = 0,
	TIMER_REG_CVAL = 1,
	TIMER_REG_TVAL = 2,
	TIMER_REG_CTL = 3,
	TIMER_REG_VOFF = 4,
};

enum kvm_arch_timers {
	TIMER_PTIMER = 0,
	TIMER_VTIMER = 1,
	NR_KVM_EL0_TIMERS = 2,
	TIMER_HVTIMER = 2,
	TIMER_HPTIMER = 3,
	NR_KVM_TIMERS = 4,
};

enum kvm_bus {
	KVM_MMIO_BUS = 0,
	KVM_PIO_BUS = 1,
	KVM_VIRTIO_CCW_NOTIFY_BUS = 2,
	KVM_FAST_MMIO_BUS = 3,
	KVM_IOCSR_BUS = 4,
	KVM_NR_BUSES = 5,
};

enum kvm_device_type {
	KVM_DEV_TYPE_FSL_MPIC_20 = 1,
	KVM_DEV_TYPE_FSL_MPIC_42 = 2,
	KVM_DEV_TYPE_XICS = 3,
	KVM_DEV_TYPE_VFIO = 4,
	KVM_DEV_TYPE_ARM_VGIC_V2 = 5,
	KVM_DEV_TYPE_FLIC = 6,
	KVM_DEV_TYPE_ARM_VGIC_V3 = 7,
	KVM_DEV_TYPE_ARM_VGIC_ITS = 8,
	KVM_DEV_TYPE_XIVE = 9,
	KVM_DEV_TYPE_ARM_PV_TIME = 10,
	KVM_DEV_TYPE_RISCV_AIA = 11,
	KVM_DEV_TYPE_LOONGARCH_IPI = 12,
	KVM_DEV_TYPE_LOONGARCH_EIOINTC = 13,
	KVM_DEV_TYPE_LOONGARCH_PCHPIC = 14,
	KVM_DEV_TYPE_MAX = 15,
};

enum kvm_mode {
	KVM_MODE_DEFAULT = 0,
	KVM_MODE_PROTECTED = 1,
	KVM_MODE_NV = 2,
	KVM_MODE_NONE = 3,
};

enum kvm_mr_change {
	KVM_MR_CREATE = 0,
	KVM_MR_DELETE = 1,
	KVM_MR_MOVE = 2,
	KVM_MR_FLAGS_ONLY = 3,
};

enum kvm_pgtable_prot {
	KVM_PGTABLE_PROT_X = 1ULL,
	KVM_PGTABLE_PROT_W = 2ULL,
	KVM_PGTABLE_PROT_R = 4ULL,
	KVM_PGTABLE_PROT_DEVICE = 8ULL,
	KVM_PGTABLE_PROT_NORMAL_NC = 16ULL,
	KVM_PGTABLE_PROT_SW0 = 36028797018963968ULL,
	KVM_PGTABLE_PROT_SW1 = 72057594037927936ULL,
	KVM_PGTABLE_PROT_SW2 = 144115188075855872ULL,
	KVM_PGTABLE_PROT_SW3 = 288230376151711744ULL,
};

enum kvm_pgtable_stage2_flags {
	KVM_PGTABLE_S2_NOFWB = 1,
	KVM_PGTABLE_S2_IDMAP = 2,
};

enum kvm_pgtable_walk_flags {
	KVM_PGTABLE_WALK_LEAF = 1,
	KVM_PGTABLE_WALK_TABLE_PRE = 2,
	KVM_PGTABLE_WALK_TABLE_POST = 4,
	KVM_PGTABLE_WALK_SHARED = 8,
	KVM_PGTABLE_WALK_HANDLE_FAULT = 16,
	KVM_PGTABLE_WALK_SKIP_BBM_TLBI = 32,
	KVM_PGTABLE_WALK_SKIP_CMO = 64,
};

enum kvm_smccc_filter_action {
	KVM_SMCCC_FILTER_HANDLE = 0,
	KVM_SMCCC_FILTER_DENY = 1,
	KVM_SMCCC_FILTER_FWD_TO_USER = 2,
	NR_SMCCC_FILTER_ACTIONS = 3,
};

enum kvm_stat_kind {
	KVM_STAT_VM = 0,
	KVM_STAT_VCPU = 1,
};

enum kvm_wfx_trap_policy {
	KVM_WFX_NOTRAP_SINGLE_TASK = 0,
	KVM_WFX_NOTRAP = 1,
	KVM_WFX_TRAP = 2,
};

enum l2tp_debug_flags {
	L2TP_MSG_DEBUG = 1,
	L2TP_MSG_CONTROL = 2,
	L2TP_MSG_SEQ = 4,
	L2TP_MSG_DATA = 8,
};

enum l3mdev_type {
	L3MDEV_TYPE_UNSPEC = 0,
	L3MDEV_TYPE_VRF = 1,
	__L3MDEV_TYPE_MAX = 2,
};

enum label_initialized {
	LABEL_INVALID = 0,
	LABEL_INITIALIZED = 1,
	LABEL_PENDING = 2,
};

enum landlock_key_type {
	LANDLOCK_KEY_INODE = 1,
	LANDLOCK_KEY_NET_PORT = 2,
};

enum landlock_rule_type {
	LANDLOCK_RULE_PATH_BENEATH = 1,
	LANDLOCK_RULE_NET_PORT = 2,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum linux_mptcp_mib_field {
	MPTCP_MIB_NUM = 0,
	MPTCP_MIB_MPCAPABLEPASSIVE = 1,
	MPTCP_MIB_MPCAPABLEACTIVE = 2,
	MPTCP_MIB_MPCAPABLEACTIVEACK = 3,
	MPTCP_MIB_MPCAPABLEPASSIVEACK = 4,
	MPTCP_MIB_MPCAPABLEPASSIVEFALLBACK = 5,
	MPTCP_MIB_MPCAPABLEACTIVEFALLBACK = 6,
	MPTCP_MIB_MPCAPABLEACTIVEDROP = 7,
	MPTCP_MIB_MPCAPABLEACTIVEDISABLED = 8,
	MPTCP_MIB_MPCAPABLEENDPATTEMPT = 9,
	MPTCP_MIB_TOKENFALLBACKINIT = 10,
	MPTCP_MIB_RETRANSSEGS = 11,
	MPTCP_MIB_JOINNOTOKEN = 12,
	MPTCP_MIB_JOINSYNRX = 13,
	MPTCP_MIB_JOINSYNBACKUPRX = 14,
	MPTCP_MIB_JOINSYNACKRX = 15,
	MPTCP_MIB_JOINSYNACKBACKUPRX = 16,
	MPTCP_MIB_JOINSYNACKMAC = 17,
	MPTCP_MIB_JOINACKRX = 18,
	MPTCP_MIB_JOINACKMAC = 19,
	MPTCP_MIB_JOINSYNTX = 20,
	MPTCP_MIB_JOINSYNTXCREATSKERR = 21,
	MPTCP_MIB_JOINSYNTXBINDERR = 22,
	MPTCP_MIB_JOINSYNTXCONNECTERR = 23,
	MPTCP_MIB_DSSNOMATCH = 24,
	MPTCP_MIB_DSSCORRUPTIONFALLBACK = 25,
	MPTCP_MIB_DSSCORRUPTIONRESET = 26,
	MPTCP_MIB_INFINITEMAPTX = 27,
	MPTCP_MIB_INFINITEMAPRX = 28,
	MPTCP_MIB_DSSTCPMISMATCH = 29,
	MPTCP_MIB_DATACSUMERR = 30,
	MPTCP_MIB_OFOQUEUETAIL = 31,
	MPTCP_MIB_OFOQUEUE = 32,
	MPTCP_MIB_OFOMERGE = 33,
	MPTCP_MIB_NODSSWINDOW = 34,
	MPTCP_MIB_DUPDATA = 35,
	MPTCP_MIB_ADDADDR = 36,
	MPTCP_MIB_ADDADDRTX = 37,
	MPTCP_MIB_ADDADDRTXDROP = 38,
	MPTCP_MIB_ECHOADD = 39,
	MPTCP_MIB_ECHOADDTX = 40,
	MPTCP_MIB_ECHOADDTXDROP = 41,
	MPTCP_MIB_PORTADD = 42,
	MPTCP_MIB_ADDADDRDROP = 43,
	MPTCP_MIB_JOINPORTSYNRX = 44,
	MPTCP_MIB_JOINPORTSYNACKRX = 45,
	MPTCP_MIB_JOINPORTACKRX = 46,
	MPTCP_MIB_MISMATCHPORTSYNRX = 47,
	MPTCP_MIB_MISMATCHPORTACKRX = 48,
	MPTCP_MIB_RMADDR = 49,
	MPTCP_MIB_RMADDRDROP = 50,
	MPTCP_MIB_RMADDRTX = 51,
	MPTCP_MIB_RMADDRTXDROP = 52,
	MPTCP_MIB_RMSUBFLOW = 53,
	MPTCP_MIB_MPPRIOTX = 54,
	MPTCP_MIB_MPPRIORX = 55,
	MPTCP_MIB_MPFAILTX = 56,
	MPTCP_MIB_MPFAILRX = 57,
	MPTCP_MIB_MPFASTCLOSETX = 58,
	MPTCP_MIB_MPFASTCLOSERX = 59,
	MPTCP_MIB_MPRSTTX = 60,
	MPTCP_MIB_MPRSTRX = 61,
	MPTCP_MIB_RCVPRUNED = 62,
	MPTCP_MIB_SUBFLOWSTALE = 63,
	MPTCP_MIB_SUBFLOWRECOVER = 64,
	MPTCP_MIB_SNDWNDSHARED = 65,
	MPTCP_MIB_RCVWNDSHARED = 66,
	MPTCP_MIB_RCVWNDCONFLICTUPDATE = 67,
	MPTCP_MIB_RCVWNDCONFLICT = 68,
	MPTCP_MIB_CURRESTAB = 69,
	MPTCP_MIB_BLACKHOLE = 70,
	__MPTCP_MIB_MAX = 71,
};

enum locality_types {
	WRITE_LATENCY = 0,
	READ_LATENCY = 1,
	WRITE_BANDWIDTH = 2,
	READ_BANDWIDTH = 3,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_integrity_type {
	LSM_INT_DMVERITY_SIG_VALID = 0,
	LSM_INT_DMVERITY_ROOTHASH = 1,
	LSM_INT_FSVERITY_BUILTINSIG_VALID = 2,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lsm_rule_types {
	LSM_OBJ_USER = 0,
	LSM_OBJ_ROLE = 1,
	LSM_OBJ_TYPE = 2,
	LSM_SUBJ_USER = 3,
	LSM_SUBJ_ROLE = 4,
	LSM_SUBJ_TYPE = 5,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum macsec_offload {
	MACSEC_OFFLOAD_OFF = 0,
	MACSEC_OFFLOAD_PHY = 1,
	MACSEC_OFFLOAD_MAC = 2,
	__MACSEC_OFFLOAD_END = 3,
	MACSEC_OFFLOAD_MAX = 2,
};

enum macsec_validation_type {
	MACSEC_VALIDATE_DISABLED = 0,
	MACSEC_VALIDATE_CHECK = 1,
	MACSEC_VALIDATE_STRICT = 2,
	__MACSEC_VALIDATE_END = 3,
	MACSEC_VALIDATE_MAX = 2,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum mapping_status {
	MAPPING_OK = 0,
	MAPPING_INVALID = 1,
	MAPPING_EMPTY = 2,
	MAPPING_DATA_FIN = 3,
	MAPPING_DUMMY = 4,
	MAPPING_BAD_CSUM = 5,
	MAPPING_NODSS = 6,
};

enum max77620_chip_id {
	MAX77620 = 0,
	MAX20024 = 1,
	MAX77663 = 2,
};

enum max77686_irq_source {
	PMIC_INT1 = 0,
	PMIC_INT2 = 1,
	RTC_INT = 2,
	MAX77686_IRQ_GROUP_NR = 3,
};

enum max77686_pmic_reg {
	MAX77686_REG_DEVICE_ID = 0,
	MAX77686_REG_INTSRC = 1,
	MAX77686_REG_INT1 = 2,
	MAX77686_REG_INT2 = 3,
	MAX77686_REG_INT1MSK = 4,
	MAX77686_REG_INT2MSK = 5,
	MAX77686_REG_STATUS1 = 6,
	MAX77686_REG_STATUS2 = 7,
	MAX77686_REG_PWRON = 8,
	MAX77686_REG_ONOFF_DELAY = 9,
	MAX77686_REG_MRSTB = 10,
	MAX77686_REG_BUCK1CTRL = 16,
	MAX77686_REG_BUCK1OUT = 17,
	MAX77686_REG_BUCK2CTRL1 = 18,
	MAX77686_REG_BUCK234FREQ = 19,
	MAX77686_REG_BUCK2DVS1 = 20,
	MAX77686_REG_BUCK2DVS2 = 21,
	MAX77686_REG_BUCK2DVS3 = 22,
	MAX77686_REG_BUCK2DVS4 = 23,
	MAX77686_REG_BUCK2DVS5 = 24,
	MAX77686_REG_BUCK2DVS6 = 25,
	MAX77686_REG_BUCK2DVS7 = 26,
	MAX77686_REG_BUCK2DVS8 = 27,
	MAX77686_REG_BUCK3CTRL1 = 28,
	MAX77686_REG_BUCK3DVS1 = 30,
	MAX77686_REG_BUCK3DVS2 = 31,
	MAX77686_REG_BUCK3DVS3 = 32,
	MAX77686_REG_BUCK3DVS4 = 33,
	MAX77686_REG_BUCK3DVS5 = 34,
	MAX77686_REG_BUCK3DVS6 = 35,
	MAX77686_REG_BUCK3DVS7 = 36,
	MAX77686_REG_BUCK3DVS8 = 37,
	MAX77686_REG_BUCK4CTRL1 = 38,
	MAX77686_REG_BUCK4DVS1 = 40,
	MAX77686_REG_BUCK4DVS2 = 41,
	MAX77686_REG_BUCK4DVS3 = 42,
	MAX77686_REG_BUCK4DVS4 = 43,
	MAX77686_REG_BUCK4DVS5 = 44,
	MAX77686_REG_BUCK4DVS6 = 45,
	MAX77686_REG_BUCK4DVS7 = 46,
	MAX77686_REG_BUCK4DVS8 = 47,
	MAX77686_REG_BUCK5CTRL = 48,
	MAX77686_REG_BUCK5OUT = 49,
	MAX77686_REG_BUCK6CTRL = 50,
	MAX77686_REG_BUCK6OUT = 51,
	MAX77686_REG_BUCK7CTRL = 52,
	MAX77686_REG_BUCK7OUT = 53,
	MAX77686_REG_BUCK8CTRL = 54,
	MAX77686_REG_BUCK8OUT = 55,
	MAX77686_REG_BUCK9CTRL = 56,
	MAX77686_REG_BUCK9OUT = 57,
	MAX77686_REG_LDO1CTRL1 = 64,
	MAX77686_REG_LDO2CTRL1 = 65,
	MAX77686_REG_LDO3CTRL1 = 66,
	MAX77686_REG_LDO4CTRL1 = 67,
	MAX77686_REG_LDO5CTRL1 = 68,
	MAX77686_REG_LDO6CTRL1 = 69,
	MAX77686_REG_LDO7CTRL1 = 70,
	MAX77686_REG_LDO8CTRL1 = 71,
	MAX77686_REG_LDO9CTRL1 = 72,
	MAX77686_REG_LDO10CTRL1 = 73,
	MAX77686_REG_LDO11CTRL1 = 74,
	MAX77686_REG_LDO12CTRL1 = 75,
	MAX77686_REG_LDO13CTRL1 = 76,
	MAX77686_REG_LDO14CTRL1 = 77,
	MAX77686_REG_LDO15CTRL1 = 78,
	MAX77686_REG_LDO16CTRL1 = 79,
	MAX77686_REG_LDO17CTRL1 = 80,
	MAX77686_REG_LDO18CTRL1 = 81,
	MAX77686_REG_LDO19CTRL1 = 82,
	MAX77686_REG_LDO20CTRL1 = 83,
	MAX77686_REG_LDO21CTRL1 = 84,
	MAX77686_REG_LDO22CTRL1 = 85,
	MAX77686_REG_LDO23CTRL1 = 86,
	MAX77686_REG_LDO24CTRL1 = 87,
	MAX77686_REG_LDO25CTRL1 = 88,
	MAX77686_REG_LDO26CTRL1 = 89,
	MAX77686_REG_LDO1CTRL2 = 96,
	MAX77686_REG_LDO2CTRL2 = 97,
	MAX77686_REG_LDO3CTRL2 = 98,
	MAX77686_REG_LDO4CTRL2 = 99,
	MAX77686_REG_LDO5CTRL2 = 100,
	MAX77686_REG_LDO6CTRL2 = 101,
	MAX77686_REG_LDO7CTRL2 = 102,
	MAX77686_REG_LDO8CTRL2 = 103,
	MAX77686_REG_LDO9CTRL2 = 104,
	MAX77686_REG_LDO10CTRL2 = 105,
	MAX77686_REG_LDO11CTRL2 = 106,
	MAX77686_REG_LDO12CTRL2 = 107,
	MAX77686_REG_LDO13CTRL2 = 108,
	MAX77686_REG_LDO14CTRL2 = 109,
	MAX77686_REG_LDO15CTRL2 = 110,
	MAX77686_REG_LDO16CTRL2 = 111,
	MAX77686_REG_LDO17CTRL2 = 112,
	MAX77686_REG_LDO18CTRL2 = 113,
	MAX77686_REG_LDO19CTRL2 = 114,
	MAX77686_REG_LDO20CTRL2 = 115,
	MAX77686_REG_LDO21CTRL2 = 116,
	MAX77686_REG_LDO22CTRL2 = 117,
	MAX77686_REG_LDO23CTRL2 = 118,
	MAX77686_REG_LDO24CTRL2 = 119,
	MAX77686_REG_LDO25CTRL2 = 120,
	MAX77686_REG_LDO26CTRL2 = 121,
	MAX77686_REG_BBAT_CHG = 126,
	MAX77686_REG_32KHZ = 127,
	MAX77686_REG_PMIC_END = 128,
};

enum max77686_types {
	TYPE_MAX77686 = 0,
	TYPE_MAX77802 = 1,
};

enum max77802_pmic_reg {
	MAX77802_REG_DEVICE_ID = 0,
	MAX77802_REG_INTSRC = 1,
	MAX77802_REG_INT1 = 2,
	MAX77802_REG_INT2 = 3,
	MAX77802_REG_INT1MSK = 4,
	MAX77802_REG_INT2MSK = 5,
	MAX77802_REG_STATUS1 = 6,
	MAX77802_REG_STATUS2 = 7,
	MAX77802_REG_PWRON = 8,
	MAX77802_REG_MRSTB = 10,
	MAX77802_REG_EPWRHOLD = 11,
	MAX77802_REG_BOOSTCTRL = 14,
	MAX77802_REG_BOOSTOUT = 15,
	MAX77802_REG_BUCK1CTRL = 16,
	MAX77802_REG_BUCK1DVS1 = 17,
	MAX77802_REG_BUCK1DVS2 = 18,
	MAX77802_REG_BUCK1DVS3 = 19,
	MAX77802_REG_BUCK1DVS4 = 20,
	MAX77802_REG_BUCK1DVS5 = 21,
	MAX77802_REG_BUCK1DVS6 = 22,
	MAX77802_REG_BUCK1DVS7 = 23,
	MAX77802_REG_BUCK1DVS8 = 24,
	MAX77802_REG_BUCK2CTRL1 = 26,
	MAX77802_REG_BUCK2CTRL2 = 27,
	MAX77802_REG_BUCK2PHTRAN = 28,
	MAX77802_REG_BUCK2DVS1 = 29,
	MAX77802_REG_BUCK2DVS2 = 30,
	MAX77802_REG_BUCK2DVS3 = 31,
	MAX77802_REG_BUCK2DVS4 = 32,
	MAX77802_REG_BUCK2DVS5 = 33,
	MAX77802_REG_BUCK2DVS6 = 34,
	MAX77802_REG_BUCK2DVS7 = 35,
	MAX77802_REG_BUCK2DVS8 = 36,
	MAX77802_REG_BUCK3CTRL1 = 39,
	MAX77802_REG_BUCK3DVS1 = 40,
	MAX77802_REG_BUCK3DVS2 = 41,
	MAX77802_REG_BUCK3DVS3 = 42,
	MAX77802_REG_BUCK3DVS4 = 43,
	MAX77802_REG_BUCK3DVS5 = 44,
	MAX77802_REG_BUCK3DVS6 = 45,
	MAX77802_REG_BUCK3DVS7 = 46,
	MAX77802_REG_BUCK3DVS8 = 47,
	MAX77802_REG_BUCK4CTRL1 = 55,
	MAX77802_REG_BUCK4DVS1 = 56,
	MAX77802_REG_BUCK4DVS2 = 57,
	MAX77802_REG_BUCK4DVS3 = 58,
	MAX77802_REG_BUCK4DVS4 = 59,
	MAX77802_REG_BUCK4DVS5 = 60,
	MAX77802_REG_BUCK4DVS6 = 61,
	MAX77802_REG_BUCK4DVS7 = 62,
	MAX77802_REG_BUCK4DVS8 = 63,
	MAX77802_REG_BUCK5CTRL = 65,
	MAX77802_REG_BUCK5OUT = 66,
	MAX77802_REG_BUCK6CTRL = 68,
	MAX77802_REG_BUCK6DVS1 = 69,
	MAX77802_REG_BUCK6DVS2 = 70,
	MAX77802_REG_BUCK6DVS3 = 71,
	MAX77802_REG_BUCK6DVS4 = 72,
	MAX77802_REG_BUCK6DVS5 = 73,
	MAX77802_REG_BUCK6DVS6 = 74,
	MAX77802_REG_BUCK6DVS7 = 75,
	MAX77802_REG_BUCK6DVS8 = 76,
	MAX77802_REG_BUCK7CTRL = 78,
	MAX77802_REG_BUCK7OUT = 79,
	MAX77802_REG_BUCK8CTRL = 81,
	MAX77802_REG_BUCK8OUT = 82,
	MAX77802_REG_BUCK9CTRL = 84,
	MAX77802_REG_BUCK9OUT = 85,
	MAX77802_REG_BUCK10CTRL = 87,
	MAX77802_REG_BUCK10OUT = 88,
	MAX77802_REG_LDO1CTRL1 = 96,
	MAX77802_REG_LDO2CTRL1 = 97,
	MAX77802_REG_LDO3CTRL1 = 98,
	MAX77802_REG_LDO4CTRL1 = 99,
	MAX77802_REG_LDO5CTRL1 = 100,
	MAX77802_REG_LDO6CTRL1 = 101,
	MAX77802_REG_LDO7CTRL1 = 102,
	MAX77802_REG_LDO8CTRL1 = 103,
	MAX77802_REG_LDO9CTRL1 = 104,
	MAX77802_REG_LDO10CTRL1 = 105,
	MAX77802_REG_LDO11CTRL1 = 106,
	MAX77802_REG_LDO12CTRL1 = 107,
	MAX77802_REG_LDO13CTRL1 = 108,
	MAX77802_REG_LDO14CTRL1 = 109,
	MAX77802_REG_LDO15CTRL1 = 110,
	MAX77802_REG_LDO17CTRL1 = 112,
	MAX77802_REG_LDO18CTRL1 = 113,
	MAX77802_REG_LDO19CTRL1 = 114,
	MAX77802_REG_LDO20CTRL1 = 115,
	MAX77802_REG_LDO21CTRL1 = 116,
	MAX77802_REG_LDO22CTRL1 = 117,
	MAX77802_REG_LDO23CTRL1 = 118,
	MAX77802_REG_LDO24CTRL1 = 119,
	MAX77802_REG_LDO25CTRL1 = 120,
	MAX77802_REG_LDO26CTRL1 = 121,
	MAX77802_REG_LDO27CTRL1 = 122,
	MAX77802_REG_LDO28CTRL1 = 123,
	MAX77802_REG_LDO29CTRL1 = 124,
	MAX77802_REG_LDO30CTRL1 = 125,
	MAX77802_REG_LDO32CTRL1 = 127,
	MAX77802_REG_LDO33CTRL1 = 128,
	MAX77802_REG_LDO34CTRL1 = 129,
	MAX77802_REG_LDO35CTRL1 = 130,
	MAX77802_REG_LDO1CTRL2 = 144,
	MAX77802_REG_LDO2CTRL2 = 145,
	MAX77802_REG_LDO3CTRL2 = 146,
	MAX77802_REG_LDO4CTRL2 = 147,
	MAX77802_REG_LDO5CTRL2 = 148,
	MAX77802_REG_LDO6CTRL2 = 149,
	MAX77802_REG_LDO7CTRL2 = 150,
	MAX77802_REG_LDO8CTRL2 = 151,
	MAX77802_REG_LDO9CTRL2 = 152,
	MAX77802_REG_LDO10CTRL2 = 153,
	MAX77802_REG_LDO11CTRL2 = 154,
	MAX77802_REG_LDO12CTRL2 = 155,
	MAX77802_REG_LDO13CTRL2 = 156,
	MAX77802_REG_LDO14CTRL2 = 157,
	MAX77802_REG_LDO15CTRL2 = 158,
	MAX77802_REG_LDO17CTRL2 = 160,
	MAX77802_REG_LDO18CTRL2 = 161,
	MAX77802_REG_LDO19CTRL2 = 162,
	MAX77802_REG_LDO20CTRL2 = 163,
	MAX77802_REG_LDO21CTRL2 = 164,
	MAX77802_REG_LDO22CTRL2 = 165,
	MAX77802_REG_LDO23CTRL2 = 166,
	MAX77802_REG_LDO24CTRL2 = 167,
	MAX77802_REG_LDO25CTRL2 = 168,
	MAX77802_REG_LDO26CTRL2 = 169,
	MAX77802_REG_LDO27CTRL2 = 170,
	MAX77802_REG_LDO28CTRL2 = 171,
	MAX77802_REG_LDO29CTRL2 = 172,
	MAX77802_REG_LDO30CTRL2 = 173,
	MAX77802_REG_LDO32CTRL2 = 175,
	MAX77802_REG_LDO33CTRL2 = 176,
	MAX77802_REG_LDO34CTRL2 = 177,
	MAX77802_REG_LDO35CTRL2 = 178,
	MAX77802_REG_BBAT_CHG = 180,
	MAX77802_REG_32KHZ = 181,
	MAX77802_REG_PMIC_END = 182,
};

enum max77802_rtc_reg {
	MAX77802_RTC_INT = 192,
	MAX77802_RTC_INTM = 193,
	MAX77802_RTC_CONTROLM = 194,
	MAX77802_RTC_CONTROL = 195,
	MAX77802_RTC_UPDATE0 = 196,
	MAX77802_RTC_UPDATE1 = 197,
	MAX77802_WTSR_SMPL_CNTL = 198,
	MAX77802_RTC_SEC = 199,
	MAX77802_RTC_MIN = 200,
	MAX77802_RTC_HOUR = 201,
	MAX77802_RTC_WEEKDAY = 202,
	MAX77802_RTC_MONTH = 203,
	MAX77802_RTC_YEAR = 204,
	MAX77802_RTC_MONTHDAY = 205,
	MAX77802_RTC_AE1 = 206,
	MAX77802_ALARM1_SEC = 207,
	MAX77802_ALARM1_MIN = 208,
	MAX77802_ALARM1_HOUR = 209,
	MAX77802_ALARM1_WEEKDAY = 210,
	MAX77802_ALARM1_MONTH = 211,
	MAX77802_ALARM1_YEAR = 212,
	MAX77802_ALARM1_DATE = 213,
	MAX77802_RTC_AE2 = 214,
	MAX77802_ALARM2_SEC = 215,
	MAX77802_ALARM2_MIN = 216,
	MAX77802_ALARM2_HOUR = 217,
	MAX77802_ALARM2_WEEKDAY = 218,
	MAX77802_ALARM2_MONTH = 219,
	MAX77802_ALARM2_YEAR = 220,
	MAX77802_ALARM2_DATE = 221,
	MAX77802_RTC_END = 223,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum md_ro_state {
	MD_RDWR = 0,
	MD_RDONLY = 1,
	MD_AUTO_READ = 2,
	MD_MAX_STATE = 3,
};

enum mddev_flags {
	MD_ARRAY_FIRST_USE = 0,
	MD_CLOSING = 1,
	MD_JOURNAL_CLEAN = 2,
	MD_HAS_JOURNAL = 3,
	MD_CLUSTER_RESYNC_LOCKED = 4,
	MD_FAILFAST_SUPPORTED = 5,
	MD_HAS_PPL = 6,
	MD_HAS_MULTIPLE_PPLS = 7,
	MD_NOT_READY = 8,
	MD_BROKEN = 9,
	MD_DELETED = 10,
};

enum mddev_sb_flags {
	MD_SB_CHANGE_DEVS = 0,
	MD_SB_CHANGE_CLEAN = 1,
	MD_SB_CHANGE_PENDING = 2,
	MD_SB_NEED_REWRITE = 3,
};

enum mem_cgroup_events_target {
	MEM_CGROUP_TARGET_THRESH = 0,
	MEM_CGROUP_TARGET_SOFTLIMIT = 1,
	MEM_CGROUP_NTARGETS = 2,
};

enum mem_type {
	MEM_EMPTY = 0,
	MEM_RESERVED = 1,
	MEM_UNKNOWN = 2,
	MEM_FPM = 3,
	MEM_EDO = 4,
	MEM_BEDO = 5,
	MEM_SDR = 6,
	MEM_RDR = 7,
	MEM_DDR = 8,
	MEM_RDDR = 9,
	MEM_RMBS = 10,
	MEM_DDR2 = 11,
	MEM_FB_DDR2 = 12,
	MEM_RDDR2 = 13,
	MEM_XDR = 14,
	MEM_DDR3 = 15,
	MEM_RDDR3 = 16,
	MEM_LRDDR3 = 17,
	MEM_LPDDR3 = 18,
	MEM_DDR4 = 19,
	MEM_RDDR4 = 20,
	MEM_LRDDR4 = 21,
	MEM_LPDDR4 = 22,
	MEM_DDR5 = 23,
	MEM_RDDR5 = 24,
	MEM_LRDDR5 = 25,
	MEM_NVDIMM = 26,
	MEM_WIO2 = 27,
	MEM_HBM2 = 28,
	MEM_HBM3 = 29,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 48,
	MEMCG_SOCK = 49,
	MEMCG_PERCPU_B = 50,
	MEMCG_VMALLOC = 51,
	MEMCG_KMEM = 52,
	MEMCG_ZSWAP_B = 53,
	MEMCG_ZSWAPPED = 54,
	MEMCG_NR_STAT = 55,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum meson_pinconf_drv {
	MESON_PINCONF_DRV_500UA = 0,
	MESON_PINCONF_DRV_2500UA = 1,
	MESON_PINCONF_DRV_3000UA = 2,
	MESON_PINCONF_DRV_4000UA = 3,
};

enum meson_reg_type {
	MESON_REG_PULLEN = 0,
	MESON_REG_PULL = 1,
	MESON_REG_DIR = 2,
	MESON_REG_OUT = 3,
	MESON_REG_IN = 4,
	MESON_REG_DS = 5,
	MESON_NUM_REG = 6,
};

enum meson_soc_id {
	MESON_SOC_G12A = 0,
	MESON_SOC_A1 = 1,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mf_action_page_type {
	MF_MSG_KERNEL = 0,
	MF_MSG_KERNEL_HIGH_ORDER = 1,
	MF_MSG_DIFFERENT_COMPOUND = 2,
	MF_MSG_HUGE = 3,
	MF_MSG_FREE_HUGE = 4,
	MF_MSG_GET_HWPOISON = 5,
	MF_MSG_UNMAP_FAILED = 6,
	MF_MSG_DIRTY_SWAPCACHE = 7,
	MF_MSG_CLEAN_SWAPCACHE = 8,
	MF_MSG_DIRTY_MLOCKED_LRU = 9,
	MF_MSG_CLEAN_MLOCKED_LRU = 10,
	MF_MSG_DIRTY_UNEVICTABLE_LRU = 11,
	MF_MSG_CLEAN_UNEVICTABLE_LRU = 12,
	MF_MSG_DIRTY_LRU = 13,
	MF_MSG_CLEAN_LRU = 14,
	MF_MSG_TRUNCATED_LRU = 15,
	MF_MSG_BUDDY = 16,
	MF_MSG_DAX = 17,
	MF_MSG_UNSPLIT_THP = 18,
	MF_MSG_ALREADY_POISONED = 19,
	MF_MSG_UNKNOWN = 20,
};

enum mf_flags {
	MF_COUNT_INCREASED = 1,
	MF_ACTION_REQUIRED = 2,
	MF_MUST_KILL = 4,
	MF_SOFT_OFFLINE = 8,
	MF_UNPOISON = 16,
	MF_SW_SIMULATED = 32,
	MF_NO_RETRY = 64,
	MF_MEM_PRE_REMOVE = 128,
};

enum mf_result {
	MF_IGNORED = 0,
	MF_FAILED = 1,
	MF_DELAYED = 2,
	MF_RECOVERED = 3,
};

enum mfill_atomic_mode {
	MFILL_ATOMIC_COPY = 0,
	MFILL_ATOMIC_ZEROPAGE = 1,
	MFILL_ATOMIC_CONTINUE = 2,
	MFILL_ATOMIC_POISON = 3,
	NR_MFILL_ATOMIC_MODES = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migrate_vma_direction {
	MIGRATE_VMA_SELECT_SYSTEM = 1,
	MIGRATE_VMA_SELECT_DEVICE_PRIVATE = 2,
	MIGRATE_VMA_SELECT_DEVICE_COHERENT = 4,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum mipi_dsi_compression_algo {
	MIPI_DSI_COMPRESSION_DSC = 0,
	MIPI_DSI_COMPRESSION_VENDOR = 3,
};

enum mipi_dsi_dcs_tear_mode {
	MIPI_DSI_DCS_TEAR_MODE_VBLANK = 0,
	MIPI_DSI_DCS_TEAR_MODE_VHBLANK = 1,
};

enum mipi_dsi_pixel_format {
	MIPI_DSI_FMT_RGB888 = 0,
	MIPI_DSI_FMT_RGB666 = 1,
	MIPI_DSI_FMT_RGB666_PACKED = 2,
	MIPI_DSI_FMT_RGB565 = 3,
};

enum misc_res_type {
	MISC_CG_RES_TYPES = 0,
};

enum mitigation_state {
	SPECTRE_UNAFFECTED = 0,
	SPECTRE_MITIGATED = 1,
	SPECTRE_VULNERABLE = 2,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mmc_busy_cmd {
	MMC_BUSY_CMD6 = 0,
	MMC_BUSY_ERASE = 1,
	MMC_BUSY_HPI = 2,
	MMC_BUSY_EXTR_SINGLE = 3,
	MMC_BUSY_IO = 4,
};

enum mmc_err_stat {
	MMC_ERR_CMD_TIMEOUT = 0,
	MMC_ERR_CMD_CRC = 1,
	MMC_ERR_DAT_TIMEOUT = 2,
	MMC_ERR_DAT_CRC = 3,
	MMC_ERR_AUTO_CMD = 4,
	MMC_ERR_ADMA = 5,
	MMC_ERR_TUNING = 6,
	MMC_ERR_CMDQ_RED = 7,
	MMC_ERR_CMDQ_GCE = 8,
	MMC_ERR_CMDQ_ICCE = 9,
	MMC_ERR_REQ_TIMEOUT = 10,
	MMC_ERR_CMDQ_REQ_TIMEOUT = 11,
	MMC_ERR_ICE_CFG = 12,
	MMC_ERR_CTRL_TIMEOUT = 13,
	MMC_ERR_UNEXPECTED_IRQ = 14,
	MMC_ERR_MAX = 15,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mmu_notifier_event {
	MMU_NOTIFY_UNMAP = 0,
	MMU_NOTIFY_CLEAR = 1,
	MMU_NOTIFY_PROTECTION_VMA = 2,
	MMU_NOTIFY_PROTECTION_PAGE = 3,
	MMU_NOTIFY_SOFT_DIRTY = 4,
	MMU_NOTIFY_RELEASE = 5,
	MMU_NOTIFY_MIGRATE = 6,
	MMU_NOTIFY_EXCLUSIVE = 7,
};

enum mnt_tree_flags_t {
	MNT_TREE_MOVE = 1,
	MNT_TREE_BENEATH = 2,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum motionsense_command {
	MOTIONSENSE_CMD_DUMP = 0,
	MOTIONSENSE_CMD_INFO = 1,
	MOTIONSENSE_CMD_EC_RATE = 2,
	MOTIONSENSE_CMD_SENSOR_ODR = 3,
	MOTIONSENSE_CMD_SENSOR_RANGE = 4,
	MOTIONSENSE_CMD_KB_WAKE_ANGLE = 5,
	MOTIONSENSE_CMD_DATA = 6,
	MOTIONSENSE_CMD_FIFO_INFO = 7,
	MOTIONSENSE_CMD_FIFO_FLUSH = 8,
	MOTIONSENSE_CMD_FIFO_READ = 9,
	MOTIONSENSE_CMD_PERFORM_CALIB = 10,
	MOTIONSENSE_CMD_SENSOR_OFFSET = 11,
	MOTIONSENSE_CMD_LIST_ACTIVITIES = 12,
	MOTIONSENSE_CMD_SET_ACTIVITY = 13,
	MOTIONSENSE_CMD_LID_ANGLE = 14,
	MOTIONSENSE_CMD_FIFO_INT_ENABLE = 15,
	MOTIONSENSE_CMD_SPOOF = 16,
	MOTIONSENSE_CMD_TABLET_MODE_LID_ANGLE = 17,
	MOTIONSENSE_CMD_SENSOR_SCALE = 18,
	MOTIONSENSE_NUM_CMDS = 19,
};

enum mousedev_emul {
	MOUSEDEV_EMUL_PS2 = 0,
	MOUSEDEV_EMUL_IMPS = 1,
	MOUSEDEV_EMUL_EXPS = 2,
};

enum mptcp_addr_signal_status {
	MPTCP_ADD_ADDR_SIGNAL = 0,
	MPTCP_ADD_ADDR_ECHO = 1,
	MPTCP_RM_ADDR_SIGNAL = 2,
};

enum mptcp_event_attr {
	MPTCP_ATTR_UNSPEC = 0,
	MPTCP_ATTR_TOKEN = 1,
	MPTCP_ATTR_FAMILY = 2,
	MPTCP_ATTR_LOC_ID = 3,
	MPTCP_ATTR_REM_ID = 4,
	MPTCP_ATTR_SADDR4 = 5,
	MPTCP_ATTR_SADDR6 = 6,
	MPTCP_ATTR_DADDR4 = 7,
	MPTCP_ATTR_DADDR6 = 8,
	MPTCP_ATTR_SPORT = 9,
	MPTCP_ATTR_DPORT = 10,
	MPTCP_ATTR_BACKUP = 11,
	MPTCP_ATTR_ERROR = 12,
	MPTCP_ATTR_FLAGS = 13,
	MPTCP_ATTR_TIMEOUT = 14,
	MPTCP_ATTR_IF_IDX = 15,
	MPTCP_ATTR_RESET_REASON = 16,
	MPTCP_ATTR_RESET_FLAGS = 17,
	MPTCP_ATTR_SERVER_SIDE = 18,
	__MPTCP_ATTR_MAX = 19,
};

enum mptcp_event_type {
	MPTCP_EVENT_UNSPEC = 0,
	MPTCP_EVENT_CREATED = 1,
	MPTCP_EVENT_ESTABLISHED = 2,
	MPTCP_EVENT_CLOSED = 3,
	MPTCP_EVENT_ANNOUNCED = 6,
	MPTCP_EVENT_REMOVED = 7,
	MPTCP_EVENT_SUB_ESTABLISHED = 10,
	MPTCP_EVENT_SUB_CLOSED = 11,
	MPTCP_EVENT_SUB_PRIORITY = 13,
	MPTCP_EVENT_LISTENER_CREATED = 15,
	MPTCP_EVENT_LISTENER_CLOSED = 16,
};

enum mptcp_pm_status {
	MPTCP_PM_ADD_ADDR_RECEIVED = 0,
	MPTCP_PM_ADD_ADDR_SEND_ACK = 1,
	MPTCP_PM_RM_ADDR_RECEIVED = 2,
	MPTCP_PM_ESTABLISHED = 3,
	MPTCP_PM_SUBFLOW_ESTABLISHED = 4,
	MPTCP_PM_ALREADY_ESTABLISHED = 5,
	MPTCP_PM_MPC_ENDPOINT_ACCOUNTED = 6,
};

enum mptcp_pm_type {
	MPTCP_PM_TYPE_KERNEL = 0,
	MPTCP_PM_TYPE_USERSPACE = 1,
	__MPTCP_PM_TYPE_NR = 2,
	__MPTCP_PM_TYPE_MAX = 1,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum mrq_debug_commands {
	CMD_DEBUG_OPEN_RO = 0,
	CMD_DEBUG_OPEN_WO = 1,
	CMD_DEBUG_READ = 2,
	CMD_DEBUG_WRITE = 3,
	CMD_DEBUG_CLOSE = 4,
	CMD_DEBUG_MAX = 5,
};

enum mrq_debugfs_commands {
	CMD_DEBUGFS_READ = 1,
	CMD_DEBUGFS_WRITE = 2,
	CMD_DEBUGFS_DUMPDIR = 3,
	CMD_DEBUGFS_MAX = 4,
};

enum mrq_pg_cmd {
	CMD_PG_QUERY_ABI = 0,
	CMD_PG_SET_STATE = 1,
	CMD_PG_GET_STATE = 2,
	CMD_PG_GET_NAME = 3,
	CMD_PG_GET_MAX_ID = 4,
};

enum mrq_reset_commands {
	CMD_RESET_ASSERT = 1,
	CMD_RESET_DEASSERT = 2,
	CMD_RESET_MODULE = 3,
	CMD_RESET_GET_MAX_ID = 4,
	CMD_RESET_MAX = 5,
};

enum mscode_actions {
	ACT_mscode_note_content_type = 0,
	ACT_mscode_note_digest = 1,
	ACT_mscode_note_digest_algo = 2,
	NR__mscode_actions = 3,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION___3 = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_ZSWPOUT = 3,
	MTHP_STAT_SWPIN = 4,
	MTHP_STAT_SWPOUT = 5,
	MTHP_STAT_SWPOUT_FALLBACK = 6,
	MTHP_STAT_SHMEM_ALLOC = 7,
	MTHP_STAT_SHMEM_FALLBACK = 8,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 9,
	MTHP_STAT_SPLIT = 10,
	MTHP_STAT_SPLIT_FAILED = 11,
	MTHP_STAT_SPLIT_DEFERRED = 12,
	MTHP_STAT_NR_ANON = 13,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 14,
	__MTHP_STAT_COUNT = 15,
};

enum mtk_cirq_regoffs_index {
	CIRQ_STA = 0,
	CIRQ_ACK = 1,
	CIRQ_MASK_SET = 2,
	CIRQ_MASK_CLR = 3,
	CIRQ_SENS_SET = 4,
	CIRQ_SENS_CLR = 5,
	CIRQ_POL_SET = 6,
	CIRQ_POL_CLR = 7,
	CIRQ_CONTROL = 8,
};

enum mtk_ddp_comp_id {
	DDP_COMPONENT_AAL0 = 0,
	DDP_COMPONENT_AAL1 = 1,
	DDP_COMPONENT_BLS = 2,
	DDP_COMPONENT_CCORR = 3,
	DDP_COMPONENT_COLOR0 = 4,
	DDP_COMPONENT_COLOR1 = 5,
	DDP_COMPONENT_DITHER0 = 6,
	DDP_COMPONENT_DITHER1 = 7,
	DDP_COMPONENT_DP_INTF0 = 8,
	DDP_COMPONENT_DP_INTF1 = 9,
	DDP_COMPONENT_DPI0 = 10,
	DDP_COMPONENT_DPI1 = 11,
	DDP_COMPONENT_DSC0 = 12,
	DDP_COMPONENT_DSC1 = 13,
	DDP_COMPONENT_DSI0 = 14,
	DDP_COMPONENT_DSI1 = 15,
	DDP_COMPONENT_DSI2 = 16,
	DDP_COMPONENT_DSI3 = 17,
	DDP_COMPONENT_ETHDR_MIXER = 18,
	DDP_COMPONENT_GAMMA = 19,
	DDP_COMPONENT_MDP_RDMA0 = 20,
	DDP_COMPONENT_MDP_RDMA1 = 21,
	DDP_COMPONENT_MDP_RDMA2 = 22,
	DDP_COMPONENT_MDP_RDMA3 = 23,
	DDP_COMPONENT_MDP_RDMA4 = 24,
	DDP_COMPONENT_MDP_RDMA5 = 25,
	DDP_COMPONENT_MDP_RDMA6 = 26,
	DDP_COMPONENT_MDP_RDMA7 = 27,
	DDP_COMPONENT_MERGE0 = 28,
	DDP_COMPONENT_MERGE1 = 29,
	DDP_COMPONENT_MERGE2 = 30,
	DDP_COMPONENT_MERGE3 = 31,
	DDP_COMPONENT_MERGE4 = 32,
	DDP_COMPONENT_MERGE5 = 33,
	DDP_COMPONENT_OD0 = 34,
	DDP_COMPONENT_OD1 = 35,
	DDP_COMPONENT_OVL0 = 36,
	DDP_COMPONENT_OVL_2L0 = 37,
	DDP_COMPONENT_OVL_2L1 = 38,
	DDP_COMPONENT_OVL_2L2 = 39,
	DDP_COMPONENT_OVL1 = 40,
	DDP_COMPONENT_PADDING0 = 41,
	DDP_COMPONENT_PADDING1 = 42,
	DDP_COMPONENT_PADDING2 = 43,
	DDP_COMPONENT_PADDING3 = 44,
	DDP_COMPONENT_PADDING4 = 45,
	DDP_COMPONENT_PADDING5 = 46,
	DDP_COMPONENT_PADDING6 = 47,
	DDP_COMPONENT_PADDING7 = 48,
	DDP_COMPONENT_POSTMASK0 = 49,
	DDP_COMPONENT_PWM0 = 50,
	DDP_COMPONENT_PWM1 = 51,
	DDP_COMPONENT_PWM2 = 52,
	DDP_COMPONENT_RDMA0 = 53,
	DDP_COMPONENT_RDMA1 = 54,
	DDP_COMPONENT_RDMA2 = 55,
	DDP_COMPONENT_RDMA4 = 56,
	DDP_COMPONENT_UFOE = 57,
	DDP_COMPONENT_WDMA0 = 58,
	DDP_COMPONENT_WDMA1 = 59,
	DDP_COMPONENT_ID_MAX = 60,
};

enum mtk_dpi_out_format_con {
	MTK_DPI_RGB888_SDR_CON = 0,
	MTK_DPI_RGB888_DDR_CON = 1,
	MTK_DPI_RGB565_SDR_CON = 2,
	MTK_DPI_RGB565_DDR_CON = 3,
};

enum mtk_mutex_mod_index {
	MUTEX_MOD_IDX_MDP_RDMA0 = 0,
	MUTEX_MOD_IDX_MDP_RSZ0 = 1,
	MUTEX_MOD_IDX_MDP_RSZ1 = 2,
	MUTEX_MOD_IDX_MDP_TDSHP0 = 3,
	MUTEX_MOD_IDX_MDP_WROT0 = 4,
	MUTEX_MOD_IDX_MDP_WDMA = 5,
	MUTEX_MOD_IDX_MDP_AAL0 = 6,
	MUTEX_MOD_IDX_MDP_CCORR0 = 7,
	MUTEX_MOD_IDX_MDP_HDR0 = 8,
	MUTEX_MOD_IDX_MDP_COLOR0 = 9,
	MUTEX_MOD_IDX_MDP_RDMA1 = 10,
	MUTEX_MOD_IDX_MDP_RDMA2 = 11,
	MUTEX_MOD_IDX_MDP_RDMA3 = 12,
	MUTEX_MOD_IDX_MDP_STITCH0 = 13,
	MUTEX_MOD_IDX_MDP_FG0 = 14,
	MUTEX_MOD_IDX_MDP_FG1 = 15,
	MUTEX_MOD_IDX_MDP_FG2 = 16,
	MUTEX_MOD_IDX_MDP_FG3 = 17,
	MUTEX_MOD_IDX_MDP_HDR1 = 18,
	MUTEX_MOD_IDX_MDP_HDR2 = 19,
	MUTEX_MOD_IDX_MDP_HDR3 = 20,
	MUTEX_MOD_IDX_MDP_AAL1 = 21,
	MUTEX_MOD_IDX_MDP_AAL2 = 22,
	MUTEX_MOD_IDX_MDP_AAL3 = 23,
	MUTEX_MOD_IDX_MDP_RSZ2 = 24,
	MUTEX_MOD_IDX_MDP_RSZ3 = 25,
	MUTEX_MOD_IDX_MDP_MERGE2 = 26,
	MUTEX_MOD_IDX_MDP_MERGE3 = 27,
	MUTEX_MOD_IDX_MDP_TDSHP1 = 28,
	MUTEX_MOD_IDX_MDP_TDSHP2 = 29,
	MUTEX_MOD_IDX_MDP_TDSHP3 = 30,
	MUTEX_MOD_IDX_MDP_COLOR1 = 31,
	MUTEX_MOD_IDX_MDP_COLOR2 = 32,
	MUTEX_MOD_IDX_MDP_COLOR3 = 33,
	MUTEX_MOD_IDX_MDP_OVL0 = 34,
	MUTEX_MOD_IDX_MDP_OVL1 = 35,
	MUTEX_MOD_IDX_MDP_PAD0 = 36,
	MUTEX_MOD_IDX_MDP_PAD1 = 37,
	MUTEX_MOD_IDX_MDP_PAD2 = 38,
	MUTEX_MOD_IDX_MDP_PAD3 = 39,
	MUTEX_MOD_IDX_MDP_TCC0 = 40,
	MUTEX_MOD_IDX_MDP_TCC1 = 41,
	MUTEX_MOD_IDX_MDP_WROT1 = 42,
	MUTEX_MOD_IDX_MDP_WROT2 = 43,
	MUTEX_MOD_IDX_MDP_WROT3 = 44,
	MUTEX_MOD_IDX_MAX = 45,
};

enum mtk_mutex_sof_id {
	MUTEX_SOF_SINGLE_MODE = 0,
	MUTEX_SOF_DSI0 = 1,
	MUTEX_SOF_DSI1 = 2,
	MUTEX_SOF_DPI0 = 3,
	MUTEX_SOF_DPI1 = 4,
	MUTEX_SOF_DSI2 = 5,
	MUTEX_SOF_DSI3 = 6,
	MUTEX_SOF_DP_INTF0 = 7,
	MUTEX_SOF_DP_INTF1 = 8,
	DDP_MUTEX_SOF_MAX = 9,
};

enum mtk_mutex_sof_index {
	MUTEX_SOF_IDX_SINGLE_MODE = 0,
	MUTEX_SOF_IDX_MAX = 1,
};

enum mtk_reset_version {
	MTK_RST_SIMPLE = 0,
	MTK_RST_SET_CLR = 1,
	MTK_RST_MAX = 2,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum ne_pci_dev_cmd_type {
	INVALID_CMD = 0,
	ENCLAVE_START = 1,
	ENCLAVE_GET_SLOT = 2,
	ENCLAVE_STOP = 3,
	SLOT_ALLOC = 4,
	SLOT_FREE = 5,
	SLOT_ADD_MEM = 6,
	SLOT_ADD_VCPU = 7,
	SLOT_COUNT = 8,
	NEXT_SLOT = 9,
	SLOT_INFO = 10,
	SLOT_ADD_BULK_VCPUS = 11,
	MAX_CMD = 12,
};

enum ne_state {
	NE_STATE_INIT = 0,
	NE_STATE_RUNNING = 2,
	NE_STATE_STOPPED = 65535,
};

enum net_bridge_opts {
	BROPT_VLAN_ENABLED = 0,
	BROPT_VLAN_STATS_ENABLED = 1,
	BROPT_NF_CALL_IPTABLES = 2,
	BROPT_NF_CALL_IP6TABLES = 3,
	BROPT_NF_CALL_ARPTABLES = 4,
	BROPT_GROUP_ADDR_SET = 5,
	BROPT_MULTICAST_ENABLED = 6,
	BROPT_MULTICAST_QUERY_USE_IFADDR = 7,
	BROPT_MULTICAST_STATS_ENABLED = 8,
	BROPT_HAS_IPV6_ADDR = 9,
	BROPT_NEIGH_SUPPRESS_ENABLED = 10,
	BROPT_MTU_SET_BY_USER = 11,
	BROPT_VLAN_STATS_PER_PORT = 12,
	BROPT_NO_LL_LEARN = 13,
	BROPT_VLAN_BRIDGE_BINDING = 14,
	BROPT_MCAST_VLAN_SNOOPING_ENABLED = 15,
	BROPT_MST_ENABLED = 16,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_dm_alert_mode {
	NET_DM_ALERT_MODE_SUMMARY = 0,
	NET_DM_ALERT_MODE_PACKET = 1,
};

enum net_dm_attr {
	NET_DM_ATTR_UNSPEC = 0,
	NET_DM_ATTR_ALERT_MODE = 1,
	NET_DM_ATTR_PC = 2,
	NET_DM_ATTR_SYMBOL = 3,
	NET_DM_ATTR_IN_PORT = 4,
	NET_DM_ATTR_TIMESTAMP = 5,
	NET_DM_ATTR_PROTO = 6,
	NET_DM_ATTR_PAYLOAD = 7,
	NET_DM_ATTR_PAD = 8,
	NET_DM_ATTR_TRUNC_LEN = 9,
	NET_DM_ATTR_ORIG_LEN = 10,
	NET_DM_ATTR_QUEUE_LEN = 11,
	NET_DM_ATTR_STATS = 12,
	NET_DM_ATTR_HW_STATS = 13,
	NET_DM_ATTR_ORIGIN = 14,
	NET_DM_ATTR_HW_TRAP_GROUP_NAME = 15,
	NET_DM_ATTR_HW_TRAP_NAME = 16,
	NET_DM_ATTR_HW_ENTRIES = 17,
	NET_DM_ATTR_HW_ENTRY = 18,
	NET_DM_ATTR_HW_TRAP_COUNT = 19,
	NET_DM_ATTR_SW_DROPS = 20,
	NET_DM_ATTR_HW_DROPS = 21,
	NET_DM_ATTR_FLOW_ACTION_COOKIE = 22,
	NET_DM_ATTR_REASON = 23,
	__NET_DM_ATTR_MAX = 24,
	NET_DM_ATTR_MAX = 23,
};

enum net_dm_origin {
	NET_DM_ORIGIN_SW = 0,
	NET_DM_ORIGIN_HW = 1,
};

enum net_shaper_binding_type {
	NET_SHAPER_BINDING_TYPE_NETDEV = 0,
};

enum net_shaper_metric {
	NET_SHAPER_METRIC_BPS = 0,
	NET_SHAPER_METRIC_PPS = 1,
};

enum net_shaper_scope {
	NET_SHAPER_SCOPE_UNSPEC = 0,
	NET_SHAPER_SCOPE_NETDEV = 1,
	NET_SHAPER_SCOPE_QUEUE = 2,
	NET_SHAPER_SCOPE_NODE = 3,
	__NET_SHAPER_SCOPE_MAX = 4,
	NET_SHAPER_SCOPE_MAX = 3,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netkit_action {
	NETKIT_NEXT = -1,
	NETKIT_PASS = 0,
	NETKIT_DROP = 2,
	NETKIT_REDIRECT = 7,
};

enum netkit_mode {
	NETKIT_L2 = 0,
	NETKIT_L3 = 1,
};

enum netkit_scrub {
	NETKIT_SCRUB_NONE = 0,
	NETKIT_SCRUB_DEFAULT = 1,
};

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_ECACHE = 4,
	NF_CT_EXT_TSTAMP = 5,
	NF_CT_EXT_TIMEOUT = 6,
	NF_CT_EXT_LABELS = 7,
	NF_CT_EXT_SYNPROXY = 8,
	NF_CT_EXT_ACT_CT = 9,
	NF_CT_EXT_NUM = 10,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip6_hook_priorities {
	NF_IP6_PRI_FIRST = -2147483648,
	NF_IP6_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP6_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP6_PRI_RAW = -300,
	NF_IP6_PRI_SELINUX_FIRST = -225,
	NF_IP6_PRI_CONNTRACK = -200,
	NF_IP6_PRI_MANGLE = -150,
	NF_IP6_PRI_NAT_DST = -100,
	NF_IP6_PRI_FILTER = 0,
	NF_IP6_PRI_SECURITY = 50,
	NF_IP6_PRI_NAT_SRC = 100,
	NF_IP6_PRI_SELINUX_LAST = 225,
	NF_IP6_PRI_CONNTRACK_HELPER = 300,
	NF_IP6_PRI_LAST = 2147483647,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nf_tables_msg_types {
	NFT_MSG_NEWTABLE = 0,
	NFT_MSG_GETTABLE = 1,
	NFT_MSG_DELTABLE = 2,
	NFT_MSG_NEWCHAIN = 3,
	NFT_MSG_GETCHAIN = 4,
	NFT_MSG_DELCHAIN = 5,
	NFT_MSG_NEWRULE = 6,
	NFT_MSG_GETRULE = 7,
	NFT_MSG_DELRULE = 8,
	NFT_MSG_NEWSET = 9,
	NFT_MSG_GETSET = 10,
	NFT_MSG_DELSET = 11,
	NFT_MSG_NEWSETELEM = 12,
	NFT_MSG_GETSETELEM = 13,
	NFT_MSG_DELSETELEM = 14,
	NFT_MSG_NEWGEN = 15,
	NFT_MSG_GETGEN = 16,
	NFT_MSG_TRACE = 17,
	NFT_MSG_NEWOBJ = 18,
	NFT_MSG_GETOBJ = 19,
	NFT_MSG_DELOBJ = 20,
	NFT_MSG_GETOBJ_RESET = 21,
	NFT_MSG_NEWFLOWTABLE = 22,
	NFT_MSG_GETFLOWTABLE = 23,
	NFT_MSG_DELFLOWTABLE = 24,
	NFT_MSG_GETRULE_RESET = 25,
	NFT_MSG_DESTROYTABLE = 26,
	NFT_MSG_DESTROYCHAIN = 27,
	NFT_MSG_DESTROYRULE = 28,
	NFT_MSG_DESTROYSET = 29,
	NFT_MSG_DESTROYSETELEM = 30,
	NFT_MSG_DESTROYOBJ = 31,
	NFT_MSG_DESTROYFLOWTABLE = 32,
	NFT_MSG_GETSETELEM_RESET = 33,
	NFT_MSG_MAX = 34,
};

enum nfnetlink_groups {
	NFNLGRP_NONE = 0,
	NFNLGRP_CONNTRACK_NEW = 1,
	NFNLGRP_CONNTRACK_UPDATE = 2,
	NFNLGRP_CONNTRACK_DESTROY = 3,
	NFNLGRP_CONNTRACK_EXP_NEW = 4,
	NFNLGRP_CONNTRACK_EXP_UPDATE = 5,
	NFNLGRP_CONNTRACK_EXP_DESTROY = 6,
	NFNLGRP_NFTABLES = 7,
	NFNLGRP_ACCT_QUOTA = 8,
	NFNLGRP_NFTRACE = 9,
	__NFNLGRP_MAX = 10,
};

enum nfnl_abort_action {
	NFNL_ABORT_NONE = 0,
	NFNL_ABORT_AUTOLOAD = 1,
	NFNL_ABORT_VALIDATE = 2,
};

enum nfnl_batch_attributes {
	NFNL_BATCH_UNSPEC = 0,
	NFNL_BATCH_GENID = 1,
	__NFNL_BATCH_MAX = 2,
};

enum nfnl_callback_type {
	NFNL_CB_UNSPEC = 0,
	NFNL_CB_MUTEX = 1,
	NFNL_CB_RCU = 2,
	NFNL_CB_BATCH = 3,
};

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
	NFS4ERR_FIRST_FREE = 10097,
};

enum nft_bitwise_attributes {
	NFTA_BITWISE_UNSPEC = 0,
	NFTA_BITWISE_SREG = 1,
	NFTA_BITWISE_DREG = 2,
	NFTA_BITWISE_LEN = 3,
	NFTA_BITWISE_MASK = 4,
	NFTA_BITWISE_XOR = 5,
	NFTA_BITWISE_OP = 6,
	NFTA_BITWISE_DATA = 7,
	NFTA_BITWISE_SREG2 = 8,
	__NFTA_BITWISE_MAX = 9,
};

enum nft_bitwise_ops {
	NFT_BITWISE_MASK_XOR = 0,
	NFT_BITWISE_LSHIFT = 1,
	NFT_BITWISE_RSHIFT = 2,
	NFT_BITWISE_AND = 3,
	NFT_BITWISE_OR = 4,
	NFT_BITWISE_XOR = 5,
};

enum nft_byteorder_attributes {
	NFTA_BYTEORDER_UNSPEC = 0,
	NFTA_BYTEORDER_SREG = 1,
	NFTA_BYTEORDER_DREG = 2,
	NFTA_BYTEORDER_OP = 3,
	NFTA_BYTEORDER_LEN = 4,
	NFTA_BYTEORDER_SIZE = 5,
	__NFTA_BYTEORDER_MAX = 6,
};

enum nft_byteorder_ops {
	NFT_BYTEORDER_NTOH = 0,
	NFT_BYTEORDER_HTON = 1,
};

enum nft_chain_attributes {
	NFTA_CHAIN_UNSPEC = 0,
	NFTA_CHAIN_TABLE = 1,
	NFTA_CHAIN_HANDLE = 2,
	NFTA_CHAIN_NAME = 3,
	NFTA_CHAIN_HOOK = 4,
	NFTA_CHAIN_POLICY = 5,
	NFTA_CHAIN_USE = 6,
	NFTA_CHAIN_TYPE = 7,
	NFTA_CHAIN_COUNTERS = 8,
	NFTA_CHAIN_PAD = 9,
	NFTA_CHAIN_FLAGS = 10,
	NFTA_CHAIN_ID = 11,
	NFTA_CHAIN_USERDATA = 12,
	__NFTA_CHAIN_MAX = 13,
};

enum nft_chain_flags {
	NFT_CHAIN_BASE = 1,
	NFT_CHAIN_HW_OFFLOAD = 2,
	NFT_CHAIN_BINDING = 4,
};

enum nft_chain_types {
	NFT_CHAIN_T_DEFAULT = 0,
	NFT_CHAIN_T_ROUTE = 1,
	NFT_CHAIN_T_NAT = 2,
	NFT_CHAIN_T_MAX = 3,
};

enum nft_cmp_attributes {
	NFTA_CMP_UNSPEC = 0,
	NFTA_CMP_SREG = 1,
	NFTA_CMP_OP = 2,
	NFTA_CMP_DATA = 3,
	__NFTA_CMP_MAX = 4,
};

enum nft_cmp_ops {
	NFT_CMP_EQ = 0,
	NFT_CMP_NEQ = 1,
	NFT_CMP_LT = 2,
	NFT_CMP_LTE = 3,
	NFT_CMP_GT = 4,
	NFT_CMP_GTE = 5,
};

enum nft_counter_attributes {
	NFTA_COUNTER_UNSPEC = 0,
	NFTA_COUNTER_BYTES = 1,
	NFTA_COUNTER_PACKETS = 2,
	NFTA_COUNTER_PAD = 3,
	__NFTA_COUNTER_MAX = 4,
};

enum nft_data_attributes {
	NFTA_DATA_UNSPEC = 0,
	NFTA_DATA_VALUE = 1,
	NFTA_DATA_VERDICT = 2,
	__NFTA_DATA_MAX = 3,
};

enum nft_data_desc_flags {
	NFT_DATA_DESC_SETELEM = 1,
};

enum nft_data_types {
	NFT_DATA_VALUE = 0,
	NFT_DATA_VERDICT = 4294967040,
};

enum nft_devices_attributes {
	NFTA_DEVICE_UNSPEC = 0,
	NFTA_DEVICE_NAME = 1,
	__NFTA_DEVICE_MAX = 2,
};

enum nft_dynset_attributes {
	NFTA_DYNSET_UNSPEC = 0,
	NFTA_DYNSET_SET_NAME = 1,
	NFTA_DYNSET_SET_ID = 2,
	NFTA_DYNSET_OP = 3,
	NFTA_DYNSET_SREG_KEY = 4,
	NFTA_DYNSET_SREG_DATA = 5,
	NFTA_DYNSET_TIMEOUT = 6,
	NFTA_DYNSET_EXPR = 7,
	NFTA_DYNSET_PAD = 8,
	NFTA_DYNSET_FLAGS = 9,
	NFTA_DYNSET_EXPRESSIONS = 10,
	__NFTA_DYNSET_MAX = 11,
};

enum nft_dynset_flags {
	NFT_DYNSET_F_INV = 1,
	NFT_DYNSET_F_EXPR = 2,
};

enum nft_dynset_ops {
	NFT_DYNSET_OP_ADD = 0,
	NFT_DYNSET_OP_UPDATE = 1,
	NFT_DYNSET_OP_DELETE = 2,
};

enum nft_expr_attributes {
	NFTA_EXPR_UNSPEC = 0,
	NFTA_EXPR_NAME = 1,
	NFTA_EXPR_DATA = 2,
	__NFTA_EXPR_MAX = 3,
};

enum nft_exthdr_attributes {
	NFTA_EXTHDR_UNSPEC = 0,
	NFTA_EXTHDR_DREG = 1,
	NFTA_EXTHDR_TYPE = 2,
	NFTA_EXTHDR_OFFSET = 3,
	NFTA_EXTHDR_LEN = 4,
	NFTA_EXTHDR_FLAGS = 5,
	NFTA_EXTHDR_OP = 6,
	NFTA_EXTHDR_SREG = 7,
	__NFTA_EXTHDR_MAX = 8,
};

enum nft_exthdr_flags {
	NFT_EXTHDR_F_PRESENT = 1,
};

enum nft_exthdr_op {
	NFT_EXTHDR_OP_IPV6 = 0,
	NFT_EXTHDR_OP_TCPOPT = 1,
	NFT_EXTHDR_OP_IPV4 = 2,
	NFT_EXTHDR_OP_SCTP = 3,
	NFT_EXTHDR_OP_DCCP = 4,
	__NFT_EXTHDR_OP_MAX = 5,
};

enum nft_flowtable_attributes {
	NFTA_FLOWTABLE_UNSPEC = 0,
	NFTA_FLOWTABLE_TABLE = 1,
	NFTA_FLOWTABLE_NAME = 2,
	NFTA_FLOWTABLE_HOOK = 3,
	NFTA_FLOWTABLE_USE = 4,
	NFTA_FLOWTABLE_HANDLE = 5,
	NFTA_FLOWTABLE_PAD = 6,
	NFTA_FLOWTABLE_FLAGS = 7,
	__NFTA_FLOWTABLE_MAX = 8,
};

enum nft_flowtable_flags {
	NFT_FLOWTABLE_HW_OFFLOAD = 1,
	NFT_FLOWTABLE_COUNTER = 2,
	NFT_FLOWTABLE_MASK = 3,
};

enum nft_flowtable_hook_attributes {
	NFTA_FLOWTABLE_HOOK_UNSPEC = 0,
	NFTA_FLOWTABLE_HOOK_NUM = 1,
	NFTA_FLOWTABLE_HOOK_PRIORITY = 2,
	NFTA_FLOWTABLE_HOOK_DEVS = 3,
	__NFTA_FLOWTABLE_HOOK_MAX = 4,
};

enum nft_gen_attributes {
	NFTA_GEN_UNSPEC = 0,
	NFTA_GEN_ID = 1,
	NFTA_GEN_PROC_PID = 2,
	NFTA_GEN_PROC_NAME = 3,
	__NFTA_GEN_MAX = 4,
};

enum nft_hook_attributes {
	NFTA_HOOK_UNSPEC = 0,
	NFTA_HOOK_HOOKNUM = 1,
	NFTA_HOOK_PRIORITY = 2,
	NFTA_HOOK_DEV = 3,
	NFTA_HOOK_DEVS = 4,
	__NFTA_HOOK_MAX = 5,
};

enum nft_immediate_attributes {
	NFTA_IMMEDIATE_UNSPEC = 0,
	NFTA_IMMEDIATE_DREG = 1,
	NFTA_IMMEDIATE_DATA = 2,
	__NFTA_IMMEDIATE_MAX = 3,
};

enum nft_inner_attributes {
	NFTA_INNER_UNSPEC = 0,
	NFTA_INNER_NUM = 1,
	NFTA_INNER_TYPE = 2,
	NFTA_INNER_FLAGS = 3,
	NFTA_INNER_HDRSIZE = 4,
	NFTA_INNER_EXPR = 5,
	__NFTA_INNER_MAX = 6,
};

enum nft_inner_flags {
	NFT_INNER_HDRSIZE = 1,
	NFT_INNER_LL = 2,
	NFT_INNER_NH = 4,
	NFT_INNER_TH = 8,
};

enum nft_inner_type {
	NFT_INNER_UNSPEC = 0,
	NFT_INNER_VXLAN = 1,
	NFT_INNER_GENEVE = 2,
};

enum nft_iter_type {
	NFT_ITER_UNSPEC = 0,
	NFT_ITER_READ = 1,
	NFT_ITER_UPDATE = 2,
};

enum nft_last_attributes {
	NFTA_LAST_UNSPEC = 0,
	NFTA_LAST_SET = 1,
	NFTA_LAST_MSECS = 2,
	NFTA_LAST_PAD = 3,
	__NFTA_LAST_MAX = 4,
};

enum nft_list_attributes {
	NFTA_LIST_UNSPEC = 0,
	NFTA_LIST_ELEM = 1,
	__NFTA_LIST_MAX = 2,
};

enum nft_lookup_attributes {
	NFTA_LOOKUP_UNSPEC = 0,
	NFTA_LOOKUP_SET = 1,
	NFTA_LOOKUP_SREG = 2,
	NFTA_LOOKUP_DREG = 3,
	NFTA_LOOKUP_SET_ID = 4,
	NFTA_LOOKUP_FLAGS = 5,
	__NFTA_LOOKUP_MAX = 6,
};

enum nft_lookup_flags {
	NFT_LOOKUP_F_INV = 1,
};

enum nft_meta_attributes {
	NFTA_META_UNSPEC = 0,
	NFTA_META_DREG = 1,
	NFTA_META_KEY = 2,
	NFTA_META_SREG = 3,
	__NFTA_META_MAX = 4,
};

enum nft_meta_keys {
	NFT_META_LEN = 0,
	NFT_META_PROTOCOL = 1,
	NFT_META_PRIORITY = 2,
	NFT_META_MARK = 3,
	NFT_META_IIF = 4,
	NFT_META_OIF = 5,
	NFT_META_IIFNAME = 6,
	NFT_META_OIFNAME = 7,
	NFT_META_IFTYPE = 8,
	NFT_META_OIFTYPE = 9,
	NFT_META_SKUID = 10,
	NFT_META_SKGID = 11,
	NFT_META_NFTRACE = 12,
	NFT_META_RTCLASSID = 13,
	NFT_META_SECMARK = 14,
	NFT_META_NFPROTO = 15,
	NFT_META_L4PROTO = 16,
	NFT_META_BRI_IIFNAME = 17,
	NFT_META_BRI_OIFNAME = 18,
	NFT_META_PKTTYPE = 19,
	NFT_META_CPU = 20,
	NFT_META_IIFGROUP = 21,
	NFT_META_OIFGROUP = 22,
	NFT_META_CGROUP = 23,
	NFT_META_PRANDOM = 24,
	NFT_META_SECPATH = 25,
	NFT_META_IIFKIND = 26,
	NFT_META_OIFKIND = 27,
	NFT_META_BRI_IIFPVID = 28,
	NFT_META_BRI_IIFVPROTO = 29,
	NFT_META_TIME_NS = 30,
	NFT_META_TIME_DAY = 31,
	NFT_META_TIME_HOUR = 32,
	NFT_META_SDIF = 33,
	NFT_META_SDIFNAME = 34,
	NFT_META_BRI_BROUTE = 35,
	__NFT_META_IIFTYPE = 36,
};

enum nft_object_attributes {
	NFTA_OBJ_UNSPEC = 0,
	NFTA_OBJ_TABLE = 1,
	NFTA_OBJ_NAME = 2,
	NFTA_OBJ_TYPE = 3,
	NFTA_OBJ_DATA = 4,
	NFTA_OBJ_USE = 5,
	NFTA_OBJ_HANDLE = 6,
	NFTA_OBJ_PAD = 7,
	NFTA_OBJ_USERDATA = 8,
	__NFTA_OBJ_MAX = 9,
};

enum nft_objref_attributes {
	NFTA_OBJREF_UNSPEC = 0,
	NFTA_OBJREF_IMM_TYPE = 1,
	NFTA_OBJREF_IMM_NAME = 2,
	NFTA_OBJREF_SET_SREG = 3,
	NFTA_OBJREF_SET_NAME = 4,
	NFTA_OBJREF_SET_ID = 5,
	__NFTA_OBJREF_MAX = 6,
};

enum nft_offload_dep_type {
	NFT_OFFLOAD_DEP_UNSPEC = 0,
	NFT_OFFLOAD_DEP_NETWORK = 1,
	NFT_OFFLOAD_DEP_TRANSPORT = 2,
};

enum nft_offload_reg_flags {
	NFT_OFFLOAD_F_NETWORK2HOST = 1,
};

enum nft_payload_attributes {
	NFTA_PAYLOAD_UNSPEC = 0,
	NFTA_PAYLOAD_DREG = 1,
	NFTA_PAYLOAD_BASE = 2,
	NFTA_PAYLOAD_OFFSET = 3,
	NFTA_PAYLOAD_LEN = 4,
	NFTA_PAYLOAD_SREG = 5,
	NFTA_PAYLOAD_CSUM_TYPE = 6,
	NFTA_PAYLOAD_CSUM_OFFSET = 7,
	NFTA_PAYLOAD_CSUM_FLAGS = 8,
	__NFTA_PAYLOAD_MAX = 9,
};

enum nft_payload_bases {
	NFT_PAYLOAD_LL_HEADER = 0,
	NFT_PAYLOAD_NETWORK_HEADER = 1,
	NFT_PAYLOAD_TRANSPORT_HEADER = 2,
	NFT_PAYLOAD_INNER_HEADER = 3,
	NFT_PAYLOAD_TUN_HEADER = 4,
};

enum nft_payload_csum_flags {
	NFT_PAYLOAD_L4CSUM_PSEUDOHDR = 1,
};

enum nft_payload_csum_types {
	NFT_PAYLOAD_CSUM_NONE = 0,
	NFT_PAYLOAD_CSUM_INET = 1,
	NFT_PAYLOAD_CSUM_SCTP = 2,
};

enum nft_range_attributes {
	NFTA_RANGE_UNSPEC = 0,
	NFTA_RANGE_SREG = 1,
	NFTA_RANGE_OP = 2,
	NFTA_RANGE_FROM_DATA = 3,
	NFTA_RANGE_TO_DATA = 4,
	__NFTA_RANGE_MAX = 5,
};

enum nft_range_ops {
	NFT_RANGE_EQ = 0,
	NFT_RANGE_NEQ = 1,
};

enum nft_registers {
	NFT_REG_VERDICT = 0,
	NFT_REG_1 = 1,
	NFT_REG_2 = 2,
	NFT_REG_3 = 3,
	NFT_REG_4 = 4,
	__NFT_REG_MAX = 5,
	NFT_REG32_00 = 8,
	NFT_REG32_01 = 9,
	NFT_REG32_02 = 10,
	NFT_REG32_03 = 11,
	NFT_REG32_04 = 12,
	NFT_REG32_05 = 13,
	NFT_REG32_06 = 14,
	NFT_REG32_07 = 15,
	NFT_REG32_08 = 16,
	NFT_REG32_09 = 17,
	NFT_REG32_10 = 18,
	NFT_REG32_11 = 19,
	NFT_REG32_12 = 20,
	NFT_REG32_13 = 21,
	NFT_REG32_14 = 22,
	NFT_REG32_15 = 23,
};

enum nft_rt_attributes {
	NFTA_RT_UNSPEC = 0,
	NFTA_RT_DREG = 1,
	NFTA_RT_KEY = 2,
	__NFTA_RT_MAX = 3,
};

enum nft_rt_keys {
	NFT_RT_CLASSID = 0,
	NFT_RT_NEXTHOP4 = 1,
	NFT_RT_NEXTHOP6 = 2,
	NFT_RT_TCPMSS = 3,
	NFT_RT_XFRM = 4,
	__NFT_RT_MAX = 5,
};

enum nft_rule_attributes {
	NFTA_RULE_UNSPEC = 0,
	NFTA_RULE_TABLE = 1,
	NFTA_RULE_CHAIN = 2,
	NFTA_RULE_HANDLE = 3,
	NFTA_RULE_EXPRESSIONS = 4,
	NFTA_RULE_COMPAT = 5,
	NFTA_RULE_POSITION = 6,
	NFTA_RULE_USERDATA = 7,
	NFTA_RULE_PAD = 8,
	NFTA_RULE_ID = 9,
	NFTA_RULE_POSITION_ID = 10,
	NFTA_RULE_CHAIN_ID = 11,
	__NFTA_RULE_MAX = 12,
};

enum nft_secmark_attributes {
	NFTA_SECMARK_UNSPEC = 0,
	NFTA_SECMARK_CTX = 1,
	__NFTA_SECMARK_MAX = 2,
};

enum nft_set_attributes {
	NFTA_SET_UNSPEC = 0,
	NFTA_SET_TABLE = 1,
	NFTA_SET_NAME = 2,
	NFTA_SET_FLAGS = 3,
	NFTA_SET_KEY_TYPE = 4,
	NFTA_SET_KEY_LEN = 5,
	NFTA_SET_DATA_TYPE = 6,
	NFTA_SET_DATA_LEN = 7,
	NFTA_SET_POLICY = 8,
	NFTA_SET_DESC = 9,
	NFTA_SET_ID = 10,
	NFTA_SET_TIMEOUT = 11,
	NFTA_SET_GC_INTERVAL = 12,
	NFTA_SET_USERDATA = 13,
	NFTA_SET_PAD = 14,
	NFTA_SET_OBJ_TYPE = 15,
	NFTA_SET_HANDLE = 16,
	NFTA_SET_EXPR = 17,
	NFTA_SET_EXPRESSIONS = 18,
	__NFTA_SET_MAX = 19,
};

enum nft_set_class {
	NFT_SET_CLASS_O_1 = 0,
	NFT_SET_CLASS_O_LOG_N = 1,
	NFT_SET_CLASS_O_N = 2,
};

enum nft_set_desc_attributes {
	NFTA_SET_DESC_UNSPEC = 0,
	NFTA_SET_DESC_SIZE = 1,
	NFTA_SET_DESC_CONCAT = 2,
	__NFTA_SET_DESC_MAX = 3,
};

enum nft_set_elem_attributes {
	NFTA_SET_ELEM_UNSPEC = 0,
	NFTA_SET_ELEM_KEY = 1,
	NFTA_SET_ELEM_DATA = 2,
	NFTA_SET_ELEM_FLAGS = 3,
	NFTA_SET_ELEM_TIMEOUT = 4,
	NFTA_SET_ELEM_EXPIRATION = 5,
	NFTA_SET_ELEM_USERDATA = 6,
	NFTA_SET_ELEM_EXPR = 7,
	NFTA_SET_ELEM_PAD = 8,
	NFTA_SET_ELEM_OBJREF = 9,
	NFTA_SET_ELEM_KEY_END = 10,
	NFTA_SET_ELEM_EXPRESSIONS = 11,
	__NFTA_SET_ELEM_MAX = 12,
};

enum nft_set_elem_flags {
	NFT_SET_ELEM_INTERVAL_END = 1,
	NFT_SET_ELEM_CATCHALL = 2,
};

enum nft_set_elem_list_attributes {
	NFTA_SET_ELEM_LIST_UNSPEC = 0,
	NFTA_SET_ELEM_LIST_TABLE = 1,
	NFTA_SET_ELEM_LIST_SET = 2,
	NFTA_SET_ELEM_LIST_ELEMENTS = 3,
	NFTA_SET_ELEM_LIST_SET_ID = 4,
	__NFTA_SET_ELEM_LIST_MAX = 5,
};

enum nft_set_extensions {
	NFT_SET_EXT_KEY = 0,
	NFT_SET_EXT_KEY_END = 1,
	NFT_SET_EXT_DATA = 2,
	NFT_SET_EXT_FLAGS = 3,
	NFT_SET_EXT_TIMEOUT = 4,
	NFT_SET_EXT_USERDATA = 5,
	NFT_SET_EXT_EXPRESSIONS = 6,
	NFT_SET_EXT_OBJREF = 7,
	NFT_SET_EXT_NUM = 8,
};

enum nft_set_field_attributes {
	NFTA_SET_FIELD_UNSPEC = 0,
	NFTA_SET_FIELD_LEN = 1,
	__NFTA_SET_FIELD_MAX = 2,
};

enum nft_set_flags {
	NFT_SET_ANONYMOUS = 1,
	NFT_SET_CONSTANT = 2,
	NFT_SET_INTERVAL = 4,
	NFT_SET_MAP = 8,
	NFT_SET_TIMEOUT = 16,
	NFT_SET_EVAL = 32,
	NFT_SET_OBJECT = 64,
	NFT_SET_CONCAT = 128,
	NFT_SET_EXPR = 256,
};

enum nft_set_policies {
	NFT_SET_POL_PERFORMANCE = 0,
	NFT_SET_POL_MEMORY = 1,
};

enum nft_table_attributes {
	NFTA_TABLE_UNSPEC = 0,
	NFTA_TABLE_NAME = 1,
	NFTA_TABLE_FLAGS = 2,
	NFTA_TABLE_USE = 3,
	NFTA_TABLE_HANDLE = 4,
	NFTA_TABLE_PAD = 5,
	NFTA_TABLE_USERDATA = 6,
	NFTA_TABLE_OWNER = 7,
	__NFTA_TABLE_MAX = 8,
};

enum nft_table_flags {
	NFT_TABLE_F_DORMANT = 1,
	NFT_TABLE_F_OWNER = 2,
	NFT_TABLE_F_PERSIST = 4,
};

enum nft_trace_attributes {
	NFTA_TRACE_UNSPEC = 0,
	NFTA_TRACE_TABLE = 1,
	NFTA_TRACE_CHAIN = 2,
	NFTA_TRACE_RULE_HANDLE = 3,
	NFTA_TRACE_TYPE = 4,
	NFTA_TRACE_VERDICT = 5,
	NFTA_TRACE_ID = 6,
	NFTA_TRACE_LL_HEADER = 7,
	NFTA_TRACE_NETWORK_HEADER = 8,
	NFTA_TRACE_TRANSPORT_HEADER = 9,
	NFTA_TRACE_IIF = 10,
	NFTA_TRACE_IIFTYPE = 11,
	NFTA_TRACE_OIF = 12,
	NFTA_TRACE_OIFTYPE = 13,
	NFTA_TRACE_MARK = 14,
	NFTA_TRACE_NFPROTO = 15,
	NFTA_TRACE_POLICY = 16,
	NFTA_TRACE_PAD = 17,
	__NFTA_TRACE_MAX = 18,
};

enum nft_trace_types {
	NFT_TRACETYPE_UNSPEC = 0,
	NFT_TRACETYPE_POLICY = 1,
	NFT_TRACETYPE_RETURN = 2,
	NFT_TRACETYPE_RULE = 3,
	__NFT_TRACETYPE_MAX = 4,
};

enum nft_trans_elem_flags {
	NFT_TRANS_UPD_TIMEOUT = 1,
	NFT_TRANS_UPD_EXPIRATION = 2,
};

enum nft_trans_phase {
	NFT_TRANS_PREPARE = 0,
	NFT_TRANS_PREPARE_ERROR = 1,
	NFT_TRANS_ABORT = 2,
	NFT_TRANS_COMMIT = 3,
	NFT_TRANS_RELEASE = 4,
};

enum nft_verdict_attributes {
	NFTA_VERDICT_UNSPEC = 0,
	NFTA_VERDICT_CODE = 1,
	NFTA_VERDICT_CHAIN = 2,
	NFTA_VERDICT_CHAIN_ID = 3,
	__NFTA_VERDICT_MAX = 4,
};

enum nft_verdicts {
	NFT_CONTINUE = -1,
	NFT_BREAK = -2,
	NFT_JUMP = -3,
	NFT_GOTO = -4,
	NFT_RETURN = -5,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nl80211_auth_type {
	NL80211_AUTHTYPE_OPEN_SYSTEM = 0,
	NL80211_AUTHTYPE_SHARED_KEY = 1,
	NL80211_AUTHTYPE_FT = 2,
	NL80211_AUTHTYPE_NETWORK_EAP = 3,
	NL80211_AUTHTYPE_SAE = 4,
	NL80211_AUTHTYPE_FILS_SK = 5,
	NL80211_AUTHTYPE_FILS_SK_PFS = 6,
	NL80211_AUTHTYPE_FILS_PK = 7,
	__NL80211_AUTHTYPE_NUM = 8,
	NL80211_AUTHTYPE_MAX = 7,
	NL80211_AUTHTYPE_AUTOMATIC = 8,
};

enum nl80211_band {
	NL80211_BAND_2GHZ = 0,
	NL80211_BAND_5GHZ = 1,
	NL80211_BAND_60GHZ = 2,
	NL80211_BAND_6GHZ = 3,
	NL80211_BAND_S1GHZ = 4,
	NL80211_BAND_LC = 5,
	NUM_NL80211_BANDS = 6,
};

enum nl80211_bss_select_attr {
	__NL80211_BSS_SELECT_ATTR_INVALID = 0,
	NL80211_BSS_SELECT_ATTR_RSSI = 1,
	NL80211_BSS_SELECT_ATTR_BAND_PREF = 2,
	NL80211_BSS_SELECT_ATTR_RSSI_ADJUST = 3,
	__NL80211_BSS_SELECT_ATTR_AFTER_LAST = 4,
	NL80211_BSS_SELECT_ATTR_MAX = 3,
};

enum nl80211_chan_width {
	NL80211_CHAN_WIDTH_20_NOHT = 0,
	NL80211_CHAN_WIDTH_20 = 1,
	NL80211_CHAN_WIDTH_40 = 2,
	NL80211_CHAN_WIDTH_80 = 3,
	NL80211_CHAN_WIDTH_80P80 = 4,
	NL80211_CHAN_WIDTH_160 = 5,
	NL80211_CHAN_WIDTH_5 = 6,
	NL80211_CHAN_WIDTH_10 = 7,
	NL80211_CHAN_WIDTH_1 = 8,
	NL80211_CHAN_WIDTH_2 = 9,
	NL80211_CHAN_WIDTH_4 = 10,
	NL80211_CHAN_WIDTH_8 = 11,
	NL80211_CHAN_WIDTH_16 = 12,
	NL80211_CHAN_WIDTH_320 = 13,
};

enum nl80211_dfs_regions {
	NL80211_DFS_UNSET = 0,
	NL80211_DFS_FCC = 1,
	NL80211_DFS_ETSI = 2,
	NL80211_DFS_JP = 3,
};

enum nl80211_dfs_state {
	NL80211_DFS_USABLE = 0,
	NL80211_DFS_UNAVAILABLE = 1,
	NL80211_DFS_AVAILABLE = 2,
};

enum nl80211_ext_feature_index {
	NL80211_EXT_FEATURE_VHT_IBSS = 0,
	NL80211_EXT_FEATURE_RRM = 1,
	NL80211_EXT_FEATURE_MU_MIMO_AIR_SNIFFER = 2,
	NL80211_EXT_FEATURE_SCAN_START_TIME = 3,
	NL80211_EXT_FEATURE_BSS_PARENT_TSF = 4,
	NL80211_EXT_FEATURE_SET_SCAN_DWELL = 5,
	NL80211_EXT_FEATURE_BEACON_RATE_LEGACY = 6,
	NL80211_EXT_FEATURE_BEACON_RATE_HT = 7,
	NL80211_EXT_FEATURE_BEACON_RATE_VHT = 8,
	NL80211_EXT_FEATURE_FILS_STA = 9,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA = 10,
	NL80211_EXT_FEATURE_MGMT_TX_RANDOM_TA_CONNECTED = 11,
	NL80211_EXT_FEATURE_SCHED_SCAN_RELATIVE_RSSI = 12,
	NL80211_EXT_FEATURE_CQM_RSSI_LIST = 13,
	NL80211_EXT_FEATURE_FILS_SK_OFFLOAD = 14,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_PSK = 15,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_STA_1X = 16,
	NL80211_EXT_FEATURE_FILS_MAX_CHANNEL_TIME = 17,
	NL80211_EXT_FEATURE_ACCEPT_BCAST_PROBE_RESP = 18,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_HIGH_TX_RATE = 19,
	NL80211_EXT_FEATURE_OCE_PROBE_REQ_DEFERRAL_SUPPRESSION = 20,
	NL80211_EXT_FEATURE_MFP_OPTIONAL = 21,
	NL80211_EXT_FEATURE_LOW_SPAN_SCAN = 22,
	NL80211_EXT_FEATURE_LOW_POWER_SCAN = 23,
	NL80211_EXT_FEATURE_HIGH_ACCURACY_SCAN = 24,
	NL80211_EXT_FEATURE_DFS_OFFLOAD = 25,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211 = 26,
	NL80211_EXT_FEATURE_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_DATA_ACK_SIGNAL_SUPPORT = 27,
	NL80211_EXT_FEATURE_TXQS = 28,
	NL80211_EXT_FEATURE_SCAN_RANDOM_SN = 29,
	NL80211_EXT_FEATURE_SCAN_MIN_PREQ_CONTENT = 30,
	NL80211_EXT_FEATURE_CAN_REPLACE_PTK0 = 31,
	NL80211_EXT_FEATURE_ENABLE_FTM_RESPONDER = 32,
	NL80211_EXT_FEATURE_AIRTIME_FAIRNESS = 33,
	NL80211_EXT_FEATURE_AP_PMKSA_CACHING = 34,
	NL80211_EXT_FEATURE_SCHED_SCAN_BAND_SPECIFIC_RSSI_THOLD = 35,
	NL80211_EXT_FEATURE_EXT_KEY_ID = 36,
	NL80211_EXT_FEATURE_STA_TX_PWR = 37,
	NL80211_EXT_FEATURE_SAE_OFFLOAD = 38,
	NL80211_EXT_FEATURE_VLAN_OFFLOAD = 39,
	NL80211_EXT_FEATURE_AQL = 40,
	NL80211_EXT_FEATURE_BEACON_PROTECTION = 41,
	NL80211_EXT_FEATURE_CONTROL_PORT_NO_PREAUTH = 42,
	NL80211_EXT_FEATURE_PROTECTED_TWT = 43,
	NL80211_EXT_FEATURE_DEL_IBSS_STA = 44,
	NL80211_EXT_FEATURE_MULTICAST_REGISTRATIONS = 45,
	NL80211_EXT_FEATURE_BEACON_PROTECTION_CLIENT = 46,
	NL80211_EXT_FEATURE_SCAN_FREQ_KHZ = 47,
	NL80211_EXT_FEATURE_CONTROL_PORT_OVER_NL80211_TX_STATUS = 48,
	NL80211_EXT_FEATURE_OPERATING_CHANNEL_VALIDATION = 49,
	NL80211_EXT_FEATURE_4WAY_HANDSHAKE_AP_PSK = 50,
	NL80211_EXT_FEATURE_SAE_OFFLOAD_AP = 51,
	NL80211_EXT_FEATURE_FILS_DISCOVERY = 52,
	NL80211_EXT_FEATURE_UNSOL_BCAST_PROBE_RESP = 53,
	NL80211_EXT_FEATURE_BEACON_RATE_HE = 54,
	NL80211_EXT_FEATURE_SECURE_LTF = 55,
	NL80211_EXT_FEATURE_SECURE_RTT = 56,
	NL80211_EXT_FEATURE_PROT_RANGE_NEGO_AND_MEASURE = 57,
	NL80211_EXT_FEATURE_BSS_COLOR = 58,
	NL80211_EXT_FEATURE_FILS_CRYPTO_OFFLOAD = 59,
	NL80211_EXT_FEATURE_RADAR_BACKGROUND = 60,
	NL80211_EXT_FEATURE_POWERED_ADDR_CHANGE = 61,
	NL80211_EXT_FEATURE_PUNCT = 62,
	NL80211_EXT_FEATURE_SECURE_NAN = 63,
	NL80211_EXT_FEATURE_AUTH_AND_DEAUTH_RANDOM_TA = 64,
	NL80211_EXT_FEATURE_OWE_OFFLOAD = 65,
	NL80211_EXT_FEATURE_OWE_OFFLOAD_AP = 66,
	NL80211_EXT_FEATURE_DFS_CONCURRENT = 67,
	NL80211_EXT_FEATURE_SPP_AMSDU_SUPPORT = 68,
	NUM_NL80211_EXT_FEATURES = 69,
	MAX_NL80211_EXT_FEATURES = 68,
};

enum nl80211_iftype {
	NL80211_IFTYPE_UNSPECIFIED = 0,
	NL80211_IFTYPE_ADHOC = 1,
	NL80211_IFTYPE_STATION = 2,
	NL80211_IFTYPE_AP = 3,
	NL80211_IFTYPE_AP_VLAN = 4,
	NL80211_IFTYPE_WDS = 5,
	NL80211_IFTYPE_MONITOR = 6,
	NL80211_IFTYPE_MESH_POINT = 7,
	NL80211_IFTYPE_P2P_CLIENT = 8,
	NL80211_IFTYPE_P2P_GO = 9,
	NL80211_IFTYPE_P2P_DEVICE = 10,
	NL80211_IFTYPE_OCB = 11,
	NL80211_IFTYPE_NAN = 12,
	NUM_NL80211_IFTYPES = 13,
	NL80211_IFTYPE_MAX = 12,
};

enum nl80211_key_mode {
	NL80211_KEY_RX_TX = 0,
	NL80211_KEY_NO_TX = 1,
	NL80211_KEY_SET_TX = 2,
};

enum nl80211_mfp {
	NL80211_MFP_NO = 0,
	NL80211_MFP_REQUIRED = 1,
	NL80211_MFP_OPTIONAL = 2,
};

enum nl80211_mntr_flags {
	__NL80211_MNTR_FLAG_INVALID = 0,
	NL80211_MNTR_FLAG_FCSFAIL = 1,
	NL80211_MNTR_FLAG_PLCPFAIL = 2,
	NL80211_MNTR_FLAG_CONTROL = 3,
	NL80211_MNTR_FLAG_OTHER_BSS = 4,
	NL80211_MNTR_FLAG_COOK_FRAMES = 5,
	NL80211_MNTR_FLAG_ACTIVE = 6,
	NL80211_MNTR_FLAG_SKIP_TX = 7,
	__NL80211_MNTR_FLAG_AFTER_LAST = 8,
	NL80211_MNTR_FLAG_MAX = 7,
};

enum nl80211_reg_initiator {
	NL80211_REGDOM_SET_BY_CORE = 0,
	NL80211_REGDOM_SET_BY_USER = 1,
	NL80211_REGDOM_SET_BY_DRIVER = 2,
	NL80211_REGDOM_SET_BY_COUNTRY_IE = 3,
};

enum nl80211_sae_pwe_mechanism {
	NL80211_SAE_PWE_UNSPECIFIED = 0,
	NL80211_SAE_PWE_HUNT_AND_PECK = 1,
	NL80211_SAE_PWE_HASH_TO_ELEMENT = 2,
	NL80211_SAE_PWE_BOTH = 3,
};

enum nl80211_sar_type {
	NL80211_SAR_TYPE_POWER = 0,
	NUM_NL80211_SAR_TYPE = 1,
};

enum nl80211_user_reg_hint_type {
	NL80211_USER_REG_HINT_USER = 0,
	NL80211_USER_REG_HINT_CELL_BASE = 1,
	NL80211_USER_REG_HINT_INDOOR = 2,
};

enum nl802154_cca_modes {
	__NL802154_CCA_INVALID = 0,
	NL802154_CCA_ENERGY = 1,
	NL802154_CCA_CARRIER = 2,
	NL802154_CCA_ENERGY_CARRIER = 3,
	NL802154_CCA_ALOHA = 4,
	NL802154_CCA_UWB_SHR = 5,
	NL802154_CCA_UWB_MULTIPLEXED = 6,
	__NL802154_CCA_ATTR_AFTER_LAST = 7,
	NL802154_CCA_ATTR_MAX = 6,
};

enum nl802154_cca_opts {
	NL802154_CCA_OPT_ENERGY_CARRIER_AND = 0,
	NL802154_CCA_OPT_ENERGY_CARRIER_OR = 1,
	__NL802154_CCA_OPT_ATTR_AFTER_LAST = 2,
	NL802154_CCA_OPT_ATTR_MAX = 1,
};

enum nl802154_supported_bool_states {
	NL802154_SUPPORTED_BOOL_FALSE = 0,
	NL802154_SUPPORTED_BOOL_TRUE = 1,
	__NL802154_SUPPORTED_BOOL_INVALD = 2,
	NL802154_SUPPORTED_BOOL_BOTH = 3,
	__NL802154_SUPPORTED_BOOL_AFTER_LAST = 4,
	NL802154_SUPPORTED_BOOL_MAX = 3,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_IOMMU_PAGES = 40,
	NR_SWAPCACHE = 41,
	PGPROMOTE_SUCCESS = 42,
	PGPROMOTE_CANDIDATE = 43,
	PGDEMOTE_KSWAPD = 44,
	PGDEMOTE_DIRECT = 45,
	PGDEMOTE_KHUGEPAGED = 46,
	NR_HUGETLB = 47,
	NR_VM_NODE_STAT_ITEMS = 48,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 2,
	N_MEMORY = 3,
	N_CPU = 4,
	N_GENERIC_INITIATOR = 5,
	NR_NODE_STATES = 6,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum numa_faults_stats {
	NUMA_MEM = 0,
	NUMA_CPU = 1,
	NUMA_MEMBUF = 2,
	NUMA_CPUBUF = 3,
};

enum numa_stat_item {
	NUMA_HIT = 0,
	NUMA_MISS = 1,
	NUMA_FOREIGN = 2,
	NUMA_INTERLEAVE_HIT = 3,
	NUMA_LOCAL = 4,
	NUMA_OTHER = 5,
	NR_VM_NUMA_EVENT_ITEMS = 6,
};

enum numa_topology_type {
	NUMA_DIRECT = 0,
	NUMA_GLUELESS_MESH = 1,
	NUMA_BACKPLANE = 2,
};

enum numa_type {
	node_has_spare = 0,
	node_fully_busy = 1,
	node_overloaded = 2,
};

enum numa_vmaskip_reason {
	NUMAB_SKIP_UNSUITABLE = 0,
	NUMAB_SKIP_SHARED_RO = 1,
	NUMAB_SKIP_INACCESSIBLE = 2,
	NUMAB_SKIP_SCAN_DELAY = 3,
	NUMAB_SKIP_PID_INACTIVE = 4,
	NUMAB_SKIP_IGNORE_PID = 5,
	NUMAB_SKIP_SEQ_COMPLETED = 6,
};

enum nvdimm_fwa_capability {
	NVDIMM_FWA_CAP_INVALID = 0,
	NVDIMM_FWA_CAP_NONE = 1,
	NVDIMM_FWA_CAP_QUIESCE = 2,
	NVDIMM_FWA_CAP_LIVE = 3,
};

enum nvdimm_fwa_state {
	NVDIMM_FWA_INVALID = 0,
	NVDIMM_FWA_IDLE = 1,
	NVDIMM_FWA_ARMED = 2,
	NVDIMM_FWA_BUSY = 3,
	NVDIMM_FWA_ARM_OVERFLOW = 4,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum of_gpio_flags {
	OF_GPIO_ACTIVE_LOW = 1,
	OF_GPIO_SINGLE_ENDED = 2,
	OF_GPIO_OPEN_DRAIN = 4,
	OF_GPIO_TRANSITORY = 8,
	OF_GPIO_PULL_UP = 16,
	OF_GPIO_PULL_DOWN = 32,
	OF_GPIO_PULL_DISABLE = 64,
};

enum of_overlay_notify_action {
	OF_OVERLAY_INIT = 0,
	OF_OVERLAY_PRE_APPLY = 1,
	OF_OVERLAY_POST_APPLY = 2,
	OF_OVERLAY_PRE_REMOVE = 3,
	OF_OVERLAY_POST_REMOVE = 4,
};

enum of_reconfig_change {
	OF_RECONFIG_NO_CHANGE = 0,
	OF_RECONFIG_CHANGE_ADD = 1,
	OF_RECONFIG_CHANGE_REMOVE = 2,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum ohci_rh_state {
	OHCI_RH_HALTED = 0,
	OHCI_RH_SUSPENDED = 1,
	OHCI_RH_RUNNING = 2,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum opal_atom_width {
	OPAL_WIDTH_TINY = 0,
	OPAL_WIDTH_SHORT = 1,
	OPAL_WIDTH_MEDIUM = 2,
	OPAL_WIDTH_LONG = 3,
	OPAL_WIDTH_TOKEN = 4,
};

enum opal_key_type {
	OPAL_INCLUDED = 0,
	OPAL_KEYRING = 1,
};

enum opal_lock_flags {
	OPAL_SAVE_FOR_LOCK = 1,
};

enum opal_lock_state {
	OPAL_RO = 1,
	OPAL_RW = 2,
	OPAL_LK = 4,
};

enum opal_mbr {
	OPAL_MBR_ENABLE = 0,
	OPAL_MBR_DISABLE = 1,
};

enum opal_mbr_done_flag {
	OPAL_MBR_NOT_DONE = 0,
	OPAL_MBR_DONE = 1,
};

enum opal_method {
	OPAL_PROPERTIES = 0,
	OPAL_STARTSESSION = 1,
	OPAL_REVERT = 2,
	OPAL_ACTIVATE = 3,
	OPAL_EGET = 4,
	OPAL_ESET = 5,
	OPAL_NEXT = 6,
	OPAL_EAUTHENTICATE = 7,
	OPAL_GETACL = 8,
	OPAL_GENKEY = 9,
	OPAL_REVERTSP = 10,
	OPAL_GET = 11,
	OPAL_SET = 12,
	OPAL_AUTHENTICATE = 13,
	OPAL_RANDOM = 14,
	OPAL_ERASE = 15,
};

enum opal_parameter {
	OPAL_SUM_SET_LIST = 393216,
};

enum opal_response_token {
	OPAL_DTA_TOKENID_BYTESTRING = 224,
	OPAL_DTA_TOKENID_SINT = 225,
	OPAL_DTA_TOKENID_UINT = 226,
	OPAL_DTA_TOKENID_TOKEN = 227,
	OPAL_DTA_TOKENID_INVALID = 0,
};

enum opal_revert_lsp_opts {
	OPAL_PRESERVE = 1,
};

enum opal_revertlsp {
	OPAL_KEEP_GLOBAL_RANGE_KEY = 393216,
};

enum opal_table_ops {
	OPAL_READ_TABLE = 0,
	OPAL_WRITE_TABLE = 1,
};

enum opal_token {
	OPAL_TRUE = 1,
	OPAL_FALSE = 0,
	OPAL_BOOLEAN_EXPR = 3,
	OPAL_TABLE = 0,
	OPAL_STARTROW = 1,
	OPAL_ENDROW = 2,
	OPAL_STARTCOLUMN = 3,
	OPAL_ENDCOLUMN = 4,
	OPAL_VALUES = 1,
	OPAL_TABLE_UID = 0,
	OPAL_TABLE_NAME = 1,
	OPAL_TABLE_COMMON = 2,
	OPAL_TABLE_TEMPLATE = 3,
	OPAL_TABLE_KIND = 4,
	OPAL_TABLE_COLUMN = 5,
	OPAL_TABLE_COLUMNS = 6,
	OPAL_TABLE_ROWS = 7,
	OPAL_TABLE_ROWS_FREE = 8,
	OPAL_TABLE_ROW_BYTES = 9,
	OPAL_TABLE_LASTID = 10,
	OPAL_TABLE_MIN = 11,
	OPAL_TABLE_MAX = 12,
	OPAL_PIN = 3,
	OPAL_RANGESTART = 3,
	OPAL_RANGELENGTH = 4,
	OPAL_READLOCKENABLED = 5,
	OPAL_WRITELOCKENABLED = 6,
	OPAL_READLOCKED = 7,
	OPAL_WRITELOCKED = 8,
	OPAL_ACTIVEKEY = 10,
	OPAL_LIFECYCLE = 6,
	OPAL_MAXRANGES = 4,
	OPAL_MBRENABLE = 1,
	OPAL_MBRDONE = 2,
	OPAL_HOSTPROPERTIES = 0,
	OPAL_STARTLIST = 240,
	OPAL_ENDLIST = 241,
	OPAL_STARTNAME = 242,
	OPAL_ENDNAME = 243,
	OPAL_CALL = 248,
	OPAL_ENDOFDATA = 249,
	OPAL_ENDOFSESSION = 250,
	OPAL_STARTTRANSACTON = 251,
	OPAL_ENDTRANSACTON = 252,
	OPAL_EMPTYATOM = 255,
	OPAL_WHERE = 0,
};

enum opal_uid {
	OPAL_SMUID_UID = 0,
	OPAL_THISSP_UID = 1,
	OPAL_ADMINSP_UID = 2,
	OPAL_LOCKINGSP_UID = 3,
	OPAL_ENTERPRISE_LOCKINGSP_UID = 4,
	OPAL_ANYBODY_UID = 5,
	OPAL_SID_UID = 6,
	OPAL_ADMIN1_UID = 7,
	OPAL_USER1_UID = 8,
	OPAL_USER2_UID = 9,
	OPAL_PSID_UID = 10,
	OPAL_ENTERPRISE_BANDMASTER0_UID = 11,
	OPAL_ENTERPRISE_ERASEMASTER_UID = 12,
	OPAL_TABLE_TABLE = 13,
	OPAL_LOCKINGRANGE_GLOBAL = 14,
	OPAL_LOCKINGRANGE_ACE_START_TO_KEY = 15,
	OPAL_LOCKINGRANGE_ACE_RDLOCKED = 16,
	OPAL_LOCKINGRANGE_ACE_WRLOCKED = 17,
	OPAL_MBRCONTROL = 18,
	OPAL_MBR = 19,
	OPAL_AUTHORITY_TABLE = 20,
	OPAL_C_PIN_TABLE = 21,
	OPAL_LOCKING_INFO_TABLE = 22,
	OPAL_ENTERPRISE_LOCKING_INFO_TABLE = 23,
	OPAL_DATASTORE = 24,
	OPAL_C_PIN_MSID = 25,
	OPAL_C_PIN_SID = 26,
	OPAL_C_PIN_ADMIN1 = 27,
	OPAL_HALF_UID_AUTHORITY_OBJ_REF = 28,
	OPAL_HALF_UID_BOOLEAN_ACE = 29,
	OPAL_UID_HEXFF = 30,
};

enum opal_user {
	OPAL_ADMIN1 = 0,
	OPAL_USER1 = 1,
	OPAL_USER2 = 2,
	OPAL_USER3 = 3,
	OPAL_USER4 = 4,
	OPAL_USER5 = 5,
	OPAL_USER6 = 6,
	OPAL_USER7 = 7,
	OPAL_USER8 = 8,
	OPAL_USER9 = 9,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum orion_ehci_phy_ver {
	EHCI_PHY_ORION = 0,
	EHCI_PHY_DD = 1,
	EHCI_PHY_KW = 2,
	EHCI_PHY_NA = 3,
};

enum osnoise_options_index {
	OSN_DEFAULTS = 0,
	OSN_WORKLOAD = 1,
	OSN_PANIC_ON_STOP = 2,
	OSN_PREEMPT_DISABLE = 3,
	OSN_IRQ_DISABLE = 4,
	OSN_MAX = 5,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 4096,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_mlocked = 19,
	PG_hwpoison = 20,
	PG_young = 21,
	PG_idle = 22,
	PG_arch_2 = 23,
	PG_arch_3 = 24,
	__NR_PAGEFLAGS = 25,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_isolated = 16,
	PG_reported = 3,
	PG_vmemmap_self_hosted = 10,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_mapcount_underflow = 255,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_barno {
	NO_BAR = -1,
	BAR_0 = 0,
	BAR_1 = 1,
	BAR_2 = 2,
	BAR_3 = 3,
	BAR_4 = 4,
	BAR_5 = 5,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
};

enum pci_epc_bar_type {
	BAR_PROGRAMMABLE = 0,
	BAR_FIXED = 1,
	BAR_RESERVED = 2,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_pin {
	PCI_INTERRUPT_UNKNOWN = 0,
	PCI_INTERRUPT_INTA = 1,
	PCI_INTERRUPT_INTB = 2,
	PCI_INTERRUPT_INTC = 3,
	PCI_INTERRUPT_INTD = 4,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 1,
	PCI_P2PDMA_MAP_BUS_ADDR = 2,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 3,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_kirin_phy_type {
	PCIE_KIRIN_INTERNAL_PHY = 0,
	PCIE_KIRIN_EXTERNAL_PHY = 1,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum peer_app_attr {
	DCB_ATTR_CEE_PEER_APP_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_APP_INFO = 1,
	DCB_ATTR_CEE_PEER_APP = 2,
	__DCB_ATTR_CEE_PEER_APP_MAX = 3,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_arm_regs {
	PERF_REG_ARM64_X0 = 0,
	PERF_REG_ARM64_X1 = 1,
	PERF_REG_ARM64_X2 = 2,
	PERF_REG_ARM64_X3 = 3,
	PERF_REG_ARM64_X4 = 4,
	PERF_REG_ARM64_X5 = 5,
	PERF_REG_ARM64_X6 = 6,
	PERF_REG_ARM64_X7 = 7,
	PERF_REG_ARM64_X8 = 8,
	PERF_REG_ARM64_X9 = 9,
	PERF_REG_ARM64_X10 = 10,
	PERF_REG_ARM64_X11 = 11,
	PERF_REG_ARM64_X12 = 12,
	PERF_REG_ARM64_X13 = 13,
	PERF_REG_ARM64_X14 = 14,
	PERF_REG_ARM64_X15 = 15,
	PERF_REG_ARM64_X16 = 16,
	PERF_REG_ARM64_X17 = 17,
	PERF_REG_ARM64_X18 = 18,
	PERF_REG_ARM64_X19 = 19,
	PERF_REG_ARM64_X20 = 20,
	PERF_REG_ARM64_X21 = 21,
	PERF_REG_ARM64_X22 = 22,
	PERF_REG_ARM64_X23 = 23,
	PERF_REG_ARM64_X24 = 24,
	PERF_REG_ARM64_X25 = 25,
	PERF_REG_ARM64_X26 = 26,
	PERF_REG_ARM64_X27 = 27,
	PERF_REG_ARM64_X28 = 28,
	PERF_REG_ARM64_X29 = 29,
	PERF_REG_ARM64_LR = 30,
	PERF_REG_ARM64_SP = 31,
	PERF_REG_ARM64_PC = 32,
	PERF_REG_ARM64_MAX = 33,
	PERF_REG_ARM64_VG = 46,
	PERF_REG_ARM64_EXTENDED_MAX = 47,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_probe_config {
	PERF_PROBE_CONFIG_IS_RETPROBE = 1,
	PERF_UPROBE_REF_CTR_OFFSET_BITS = 32,
	PERF_UPROBE_REF_CTR_OFFSET_SHIFT = 32,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pg_states {
	PG_STATE_OFF = 0,
	PG_STATE_ON = 1,
	PG_STATE_RUNNING = 2,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum phy_led_modes {
	PHY_LED_ACTIVE_HIGH = 0,
	PHY_LED_ACTIVE_LOW = 1,
	PHY_LED_INACTIVE_HIGH_IMPEDANCE = 2,
	__PHY_LED_MODES_NUM = 3,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_state_work {
	PHY_STATE_WORK_NONE = 0,
	PHY_STATE_WORK_ANEG = 1,
	PHY_STATE_WORK_SUSPEND = 2,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum piix_controller_ids {
	piix_pata_mwdma = 0,
	piix_pata_33 = 1,
	ich_pata_33 = 2,
	ich_pata_66 = 3,
	ich_pata_100 = 4,
	ich_pata_100_nomwdma1 = 5,
	ich5_sata = 6,
	ich6_sata = 7,
	ich6m_sata = 8,
	ich8_sata = 9,
	ich8_2port_sata = 10,
	ich8m_apple_sata = 11,
	tolapai_sata = 12,
	piix_pata_vmw = 13,
	ich8_sata_snb = 14,
	ich8_2port_sata_snb = 15,
	ich8_2port_sata_byt = 16,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_INPUT_SCHMITT_UV = 15,
	PIN_CONFIG_MODE_LOW_POWER = 16,
	PIN_CONFIG_MODE_PWM = 17,
	PIN_CONFIG_OUTPUT = 18,
	PIN_CONFIG_OUTPUT_ENABLE = 19,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 20,
	PIN_CONFIG_PERSIST_STATE = 21,
	PIN_CONFIG_POWER_SOURCE = 22,
	PIN_CONFIG_SKEW_DELAY = 23,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 24,
	PIN_CONFIG_SLEW_RATE = 25,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pincfg_type {
	PINCFG_TYPE_FUNC = 0,
	PINCFG_TYPE_DAT = 1,
	PINCFG_TYPE_PUD = 2,
	PINCFG_TYPE_DRV = 3,
	PINCFG_TYPE_CON_PDN = 4,
	PINCFG_TYPE_PUD_PDN = 5,
	PINCFG_TYPE_NUM = 6,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pkcs7_actions {
	ACT_pkcs7_check_content_type = 0,
	ACT_pkcs7_extract_cert = 1,
	ACT_pkcs7_note_OID = 2,
	ACT_pkcs7_note_certificate_list = 3,
	ACT_pkcs7_note_content = 4,
	ACT_pkcs7_note_data = 5,
	ACT_pkcs7_note_signed_info = 6,
	ACT_pkcs7_note_signeddata_version = 7,
	ACT_pkcs7_note_signerinfo_version = 8,
	ACT_pkcs7_sig_note_authenticated_attr = 9,
	ACT_pkcs7_sig_note_digest_algo = 10,
	ACT_pkcs7_sig_note_issuer = 11,
	ACT_pkcs7_sig_note_pkey_algo = 12,
	ACT_pkcs7_sig_note_serial = 13,
	ACT_pkcs7_sig_note_set_of_authattrs = 14,
	ACT_pkcs7_sig_note_signature = 15,
	ACT_pkcs7_sig_note_skid = 16,
	NR__pkcs7_actions = 17,
};

enum pkey_id_type {
	PKEY_ID_PGP = 0,
	PKEY_ID_X509 = 1,
	PKEY_ID_PKCS7 = 2,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pkvm_component_id {
	PKVM_ID_HOST = 0,
	PKVM_ID_HYP = 1,
	PKVM_ID_FFA = 2,
};

enum pkvm_page_state {
	PKVM_PAGE_OWNED = 0ULL,
	PKVM_PAGE_SHARED_OWNED = 36028797018963968ULL,
	PKVM_PAGE_SHARED_BORROWED = 72057594037927936ULL,
	__PKVM_PAGE_RESERVED = 108086391056891904ULL,
	PKVM_NOPAGE = 108086391056891905ULL,
};

enum pll_ctrl_bits {
	PLL_RESETB = 0,
	SSPLL_SUSPEND_EN = 1,
	PLL_SEQ_START = 2,
	PLL_LOCK = 3,
};

enum pm_api_cb_id {
	PM_INIT_SUSPEND_CB = 30,
	PM_ACKNOWLEDGE_CB = 31,
	PM_NOTIFY_CB = 32,
};

enum pm_api_id {
	PM_API_FEATURES = 0,
	PM_GET_API_VERSION = 1,
	PM_REGISTER_NOTIFIER = 5,
	PM_FORCE_POWERDOWN = 8,
	PM_REQUEST_WAKEUP = 10,
	PM_SYSTEM_SHUTDOWN = 12,
	PM_REQUEST_NODE = 13,
	PM_RELEASE_NODE = 14,
	PM_SET_REQUIREMENT = 15,
	PM_RESET_ASSERT = 17,
	PM_RESET_GET_STATUS = 18,
	PM_MMIO_WRITE = 19,
	PM_MMIO_READ = 20,
	PM_PM_INIT_FINALIZE = 21,
	PM_FPGA_LOAD = 22,
	PM_FPGA_GET_STATUS = 23,
	PM_GET_CHIPID = 24,
	PM_SECURE_SHA = 26,
	PM_PINCTRL_REQUEST = 28,
	PM_PINCTRL_RELEASE = 29,
	PM_PINCTRL_SET_FUNCTION = 31,
	PM_PINCTRL_CONFIG_PARAM_GET = 32,
	PM_PINCTRL_CONFIG_PARAM_SET = 33,
	PM_IOCTL = 34,
	PM_QUERY_DATA = 35,
	PM_CLOCK_ENABLE = 36,
	PM_CLOCK_DISABLE = 37,
	PM_CLOCK_GETSTATE = 38,
	PM_CLOCK_SETDIVIDER = 39,
	PM_CLOCK_GETDIVIDER = 40,
	PM_CLOCK_SETPARENT = 43,
	PM_CLOCK_GETPARENT = 44,
	PM_FPGA_READ = 46,
	PM_SECURE_AES = 47,
	PM_EFUSE_ACCESS = 53,
	PM_FEATURE_CHECK = 63,
};

enum pm_feature_config_id {
	PM_FEATURE_INVALID = 0,
	PM_FEATURE_OVERTEMP_STATUS = 1,
	PM_FEATURE_OVERTEMP_VALUE = 2,
	PM_FEATURE_EXTWDT_STATUS = 3,
	PM_FEATURE_EXTWDT_VALUE = 4,
};

enum pm_gem_config_type {
	GEM_CONFIG_SGMII_MODE = 1,
	GEM_CONFIG_FIXED = 2,
};

enum pm_ioctl_id {
	IOCTL_GET_RPU_OPER_MODE = 0,
	IOCTL_SET_RPU_OPER_MODE = 1,
	IOCTL_RPU_BOOT_ADDR_CONFIG = 2,
	IOCTL_TCM_COMB_CONFIG = 3,
	IOCTL_SET_TAPDELAY_BYPASS = 4,
	IOCTL_SD_DLL_RESET = 6,
	IOCTL_SET_SD_TAPDELAY = 7,
	IOCTL_SET_PLL_FRAC_MODE = 8,
	IOCTL_GET_PLL_FRAC_MODE = 9,
	IOCTL_SET_PLL_FRAC_DATA = 10,
	IOCTL_GET_PLL_FRAC_DATA = 11,
	IOCTL_WRITE_GGS = 12,
	IOCTL_READ_GGS = 13,
	IOCTL_WRITE_PGGS = 14,
	IOCTL_READ_PGGS = 15,
	IOCTL_SET_BOOT_HEALTH_STATUS = 17,
	IOCTL_OSPI_MUX_SELECT = 21,
	IOCTL_REGISTER_SGI = 25,
	IOCTL_SET_FEATURE_CONFIG = 26,
	IOCTL_GET_FEATURE_CONFIG = 27,
	IOCTL_READ_REG = 28,
	IOCTL_SET_SD_CONFIG = 30,
	IOCTL_SET_GEM_CONFIG = 31,
	IOCTL_GET_QOS = 34,
};

enum pm_module_id {
	PM_MODULE_ID = 0,
	XPM_MODULE_ID = 2,
	XSEM_MODULE_ID = 3,
	TF_A_MODULE_ID = 10,
};

enum pm_node_id {
	NODE_SD_0 = 39,
	NODE_SD_1 = 40,
};

enum pm_pinctrl_bias_status {
	PM_PINCTRL_BIAS_DISABLE = 0,
	PM_PINCTRL_BIAS_ENABLE = 1,
};

enum pm_pinctrl_config_param {
	PM_PINCTRL_CONFIG_SLEW_RATE = 0,
	PM_PINCTRL_CONFIG_BIAS_STATUS = 1,
	PM_PINCTRL_CONFIG_PULL_CTRL = 2,
	PM_PINCTRL_CONFIG_SCHMITT_CMOS = 3,
	PM_PINCTRL_CONFIG_DRIVE_STRENGTH = 4,
	PM_PINCTRL_CONFIG_VOLTAGE_STATUS = 5,
	PM_PINCTRL_CONFIG_TRI_STATE = 6,
	PM_PINCTRL_CONFIG_MAX = 7,
};

enum pm_pinctrl_drive_strength {
	PM_PINCTRL_DRIVE_STRENGTH_2MA = 0,
	PM_PINCTRL_DRIVE_STRENGTH_4MA = 1,
	PM_PINCTRL_DRIVE_STRENGTH_8MA = 2,
	PM_PINCTRL_DRIVE_STRENGTH_12MA = 3,
};

enum pm_pinctrl_pull_ctrl {
	PM_PINCTRL_BIAS_PULL_DOWN = 0,
	PM_PINCTRL_BIAS_PULL_UP = 1,
};

enum pm_pinctrl_tri_state {
	PM_PINCTRL_TRI_STATE_DISABLE = 0,
	PM_PINCTRL_TRI_STATE_ENABLE = 1,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pm_query_id {
	PM_QID_INVALID = 0,
	PM_QID_CLOCK_GET_NAME = 1,
	PM_QID_CLOCK_GET_TOPOLOGY = 2,
	PM_QID_CLOCK_GET_FIXEDFACTOR_PARAMS = 3,
	PM_QID_CLOCK_GET_PARENTS = 4,
	PM_QID_CLOCK_GET_ATTRIBUTES = 5,
	PM_QID_PINCTRL_GET_NUM_PINS = 6,
	PM_QID_PINCTRL_GET_NUM_FUNCTIONS = 7,
	PM_QID_PINCTRL_GET_NUM_FUNCTION_GROUPS = 8,
	PM_QID_PINCTRL_GET_FUNCTION_NAME = 9,
	PM_QID_PINCTRL_GET_FUNCTION_GROUPS = 10,
	PM_QID_PINCTRL_GET_PIN_GROUPS = 11,
	PM_QID_CLOCK_GET_NUM_CLOCKS = 12,
	PM_QID_CLOCK_GET_MAX_DIVISOR = 13,
	PM_QID_PINCTRL_GET_ATTRIBUTES = 15,
};

enum pm_ret_status {
	XST_PM_SUCCESS = 0,
	XST_PM_INVALID_VERSION = 4,
	XST_PM_NO_FEATURE = 19,
	XST_PM_INVALID_CRC = 301,
	XST_PM_INTERNAL = 2000,
	XST_PM_CONFLICT = 2001,
	XST_PM_NO_ACCESS = 2002,
	XST_PM_INVALID_NODE = 2003,
	XST_PM_DOUBLE_REQ = 2004,
	XST_PM_ABORT_SUSPEND = 2005,
	XST_PM_MULT_USER = 2008,
};

enum pm_sd_config_type {
	SD_CONFIG_EMMC_SEL = 1,
	SD_CONFIG_BASECLK = 2,
	SD_CONFIG_8BIT = 3,
	SD_CONFIG_FIXED = 4,
};

enum pm_suspend_mode {
	PM_SUSPEND_MODE_FIRST = 0,
	PM_SUSPEND_MODE_STD = 0,
	PM_SUSPEND_MODE_POWER_OFF = 1,
};

enum pmic_arb_channel {
	PMIC_ARB_CHANNEL_RW = 0,
	PMIC_ARB_CHANNEL_OBS = 1,
};

enum pmic_arb_chnl_status {
	PMIC_ARB_STATUS_DONE = 1,
	PMIC_ARB_STATUS_FAILURE = 2,
	PMIC_ARB_STATUS_DENIED = 4,
	PMIC_ARB_STATUS_DROPPED = 8,
};

enum pmic_arb_cmd_op_code {
	PMIC_ARB_OP_EXT_WRITEL = 0,
	PMIC_ARB_OP_EXT_READL = 1,
	PMIC_ARB_OP_EXT_WRITE = 2,
	PMIC_ARB_OP_RESET = 3,
	PMIC_ARB_OP_SLEEP = 4,
	PMIC_ARB_OP_SHUTDOWN = 5,
	PMIC_ARB_OP_WAKEUP = 6,
	PMIC_ARB_OP_AUTHENTICATE = 7,
	PMIC_ARB_OP_MSTR_READ = 8,
	PMIC_ARB_OP_MSTR_WRITE = 9,
	PMIC_ARB_OP_EXT_READ = 13,
	PMIC_ARB_OP_WRITE = 14,
	PMIC_ARB_OP_READ = 15,
	PMIC_ARB_OP_ZERO_WRITE = 16,
};

enum poison_cmd_enabled_bits {
	CXL_POISON_ENABLED_LIST = 0,
	CXL_POISON_ENABLED_INJECT = 1,
	CXL_POISON_ENABLED_CLEAR = 2,
	CXL_POISON_ENABLED_SCAN_CAPS = 3,
	CXL_POISON_ENABLED_SCAN_MEDIA = 4,
	CXL_POISON_ENABLED_SCAN_RESULTS = 5,
	CXL_POISON_ENABLED_MAX = 6,
};

enum policy_opt {
	Opt_measure = 0,
	Opt_dont_measure = 1,
	Opt_appraise = 2,
	Opt_dont_appraise = 3,
	Opt_audit = 4,
	Opt_hash___2 = 5,
	Opt_dont_hash = 6,
	Opt_obj_user = 7,
	Opt_obj_role = 8,
	Opt_obj_type = 9,
	Opt_subj_user = 10,
	Opt_subj_role = 11,
	Opt_subj_type = 12,
	Opt_func = 13,
	Opt_mask = 14,
	Opt_fsmagic = 15,
	Opt_fsname = 16,
	Opt_fsuuid = 17,
	Opt_uid_eq = 18,
	Opt_euid_eq = 19,
	Opt_gid_eq = 20,
	Opt_egid_eq = 21,
	Opt_fowner_eq = 22,
	Opt_fgroup_eq = 23,
	Opt_uid_gt = 24,
	Opt_euid_gt = 25,
	Opt_gid_gt = 26,
	Opt_egid_gt = 27,
	Opt_fowner_gt = 28,
	Opt_fgroup_gt = 29,
	Opt_uid_lt = 30,
	Opt_euid_lt = 31,
	Opt_gid_lt = 32,
	Opt_egid_lt = 33,
	Opt_fowner_lt = 34,
	Opt_fgroup_lt = 35,
	Opt_digest_type = 36,
	Opt_appraise_type = 37,
	Opt_appraise_flag = 38,
	Opt_appraise_algos = 39,
	Opt_permit_directio = 40,
	Opt_pcr = 41,
	Opt_template = 42,
	Opt_keyrings = 43,
	Opt_label = 44,
	Opt_err___6 = 45,
};

enum policy_rule_list {
	IMA_DEFAULT_POLICY = 1,
	IMA_CUSTOM_POLICY = 2,
};

enum policy_types {
	ORIGINAL_TCB = 1,
	DEFAULT_TCB = 2,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum posix_timer_state {
	POSIX_TIMER_DISARMED = 0,
	POSIX_TIMER_ARMED = 1,
	POSIX_TIMER_REQUEUE_PENDING = 2,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 2,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_HEALTH = 2,
	POWER_SUPPLY_PROP_PRESENT = 3,
	POWER_SUPPLY_PROP_ONLINE = 4,
	POWER_SUPPLY_PROP_AUTHENTIC = 5,
	POWER_SUPPLY_PROP_TECHNOLOGY = 6,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 7,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 12,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 13,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 14,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 15,
	POWER_SUPPLY_PROP_CURRENT_MAX = 16,
	POWER_SUPPLY_PROP_CURRENT_NOW = 17,
	POWER_SUPPLY_PROP_CURRENT_AVG = 18,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 19,
	POWER_SUPPLY_PROP_POWER_NOW = 20,
	POWER_SUPPLY_PROP_POWER_AVG = 21,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 22,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_FULL = 24,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 25,
	POWER_SUPPLY_PROP_CHARGE_NOW = 26,
	POWER_SUPPLY_PROP_CHARGE_AVG = 27,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 28,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 32,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 37,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 38,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 40,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 41,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_FULL = 43,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 44,
	POWER_SUPPLY_PROP_ENERGY_NOW = 45,
	POWER_SUPPLY_PROP_ENERGY_AVG = 46,
	POWER_SUPPLY_PROP_CAPACITY = 47,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 49,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 50,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 51,
	POWER_SUPPLY_PROP_TEMP = 52,
	POWER_SUPPLY_PROP_TEMP_MAX = 53,
	POWER_SUPPLY_PROP_TEMP_MIN = 54,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 56,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 59,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 61,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 63,
	POWER_SUPPLY_PROP_TYPE = 64,
	POWER_SUPPLY_PROP_USB_TYPE = 65,
	POWER_SUPPLY_PROP_SCOPE = 66,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 67,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 68,
	POWER_SUPPLY_PROP_CALIBRATE = 69,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 72,
	POWER_SUPPLY_PROP_MODEL_NAME = 73,
	POWER_SUPPLY_PROP_MANUFACTURER = 74,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 75,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum power_supply_usb_type {
	POWER_SUPPLY_USB_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_USB_TYPE_SDP = 1,
	POWER_SUPPLY_USB_TYPE_DCP = 2,
	POWER_SUPPLY_USB_TYPE_CDP = 3,
	POWER_SUPPLY_USB_TYPE_ACA = 4,
	POWER_SUPPLY_USB_TYPE_C = 5,
	POWER_SUPPLY_USB_TYPE_PD = 6,
	POWER_SUPPLY_USB_TYPE_PD_DRP = 7,
	POWER_SUPPLY_USB_TYPE_PD_PPS = 8,
	POWER_SUPPLY_USB_TYPE_APPLE_BRICK_ID = 9,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum pri_resp {
	PRI_RESP_DENY = 0,
	PRI_RESP_FAIL = 1,
	PRI_RESP_SUCC = 2,
};

enum print_line_t {
	TRACE_TYPE_PARTIAL_LINE = 0,
	TRACE_TYPE_HANDLED = 1,
	TRACE_TYPE_UNHANDLED = 2,
	TRACE_TYPE_NO_CONSUME = 3,
};

enum printk_info_flags {
	LOG_FORCE_CON = 1,
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum priv_stack_mode {
	PRIV_STACK_UNKNOWN = 0,
	NO_PRIV_STACK = 1,
	PRIV_STACK_ADAPTIVE = 2,
};

enum probe_insn {
	INSN_REJECTED = 0,
	INSN_GOOD_NO_SLOT = 1,
	INSN_GOOD = 2,
};

enum probe_print_type {
	PROBE_PRINT_NORMAL = 0,
	PROBE_PRINT_RETURN = 1,
	PROBE_PRINT_EVENT = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_cn_mcast_op {
	PROC_CN_MCAST_LISTEN = 1,
	PROC_CN_MCAST_IGNORE = 2,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___7 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
};

enum ps2_disposition {
	PS2_PROCESS = 0,
	PS2_IGNORE = 1,
	PS2_ERROR = 2,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	PSI_IRQ = 3,
	NR_PSI_RESOURCES = 4,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_IRQ_FULL = 6,
	PSI_NONIDLE = 7,
	NR_PSI_STATES = 8,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum psmouse_scale {
	PSMOUSE_SCALE11 = 0,
	PSMOUSE_SCALE21 = 1,
};

enum psmouse_state {
	PSMOUSE_IGNORE = 0,
	PSMOUSE_INITIALIZING = 1,
	PSMOUSE_RESYNCING = 2,
	PSMOUSE_CMD_MODE = 3,
	PSMOUSE_ACTIVATED = 4,
};

enum psmouse_type {
	PSMOUSE_NONE = 0,
	PSMOUSE_PS2 = 1,
	PSMOUSE_PS2PP = 2,
	PSMOUSE_THINKPS = 3,
	PSMOUSE_GENPS = 4,
	PSMOUSE_IMPS = 5,
	PSMOUSE_IMEX = 6,
	PSMOUSE_SYNAPTICS = 7,
	PSMOUSE_ALPS = 8,
	PSMOUSE_LIFEBOOK = 9,
	PSMOUSE_TRACKPOINT = 10,
	PSMOUSE_TOUCHKIT_PS2 = 11,
	PSMOUSE_CORTRON = 12,
	PSMOUSE_HGPK = 13,
	PSMOUSE_ELANTECH = 14,
	PSMOUSE_FSP = 15,
	PSMOUSE_SYNAPTICS_RELATIVE = 16,
	PSMOUSE_CYPRESS = 17,
	PSMOUSE_FOCALTECH = 18,
	PSMOUSE_VMMOUSE = 19,
	PSMOUSE_BYD = 20,
	PSMOUSE_SYNAPTICS_SMBUS = 21,
	PSMOUSE_ELANTECH_SMBUS = 22,
	PSMOUSE_AUTO = 23,
};

enum pstore_type_id {
	PSTORE_TYPE_DMESG = 0,
	PSTORE_TYPE_MCE = 1,
	PSTORE_TYPE_CONSOLE = 2,
	PSTORE_TYPE_FTRACE = 3,
	PSTORE_TYPE_PPC_RTAS = 4,
	PSTORE_TYPE_PPC_OF = 5,
	PSTORE_TYPE_PPC_COMMON = 6,
	PSTORE_TYPE_PMSG = 7,
	PSTORE_TYPE_PPC_OPAL = 8,
	PSTORE_TYPE_MAX = 9,
};

enum ptp_clock_events {
	PTP_CLOCK_ALARM = 0,
	PTP_CLOCK_EXTTS = 1,
	PTP_CLOCK_EXTOFF = 2,
	PTP_CLOCK_PPS = 3,
	PTP_CLOCK_PPSUSR = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum ptrace_syscall_dir {
	PTRACE_SYSCALL_ENTER = 0,
	PTRACE_SYSCALL_EXIT = 1,
};

enum pubkey_algo {
	PUBKEY_ALGO_RSA = 0,
	PUBKEY_ALGO_MAX = 1,
};

enum pud_index {
	PUD_PULL_DISABLE = 0,
	PUD_PULL_DOWN = 1,
	PUD_PULL_UP = 2,
	PUD_MAX = 3,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum px30_plls {
	apll = 0,
	dpll = 1,
	cpll = 2,
	npll = 3,
	apll_b_h = 4,
	apll_b_l = 5,
};

enum px30_pmu_plls {
	gpll = 0,
};

enum qcom_scm_arg_types {
	QCOM_SCM_VAL = 0,
	QCOM_SCM_RO = 1,
	QCOM_SCM_RW = 2,
	QCOM_SCM_BUFVAL = 3,
};

enum qcom_scm_convention {
	SMC_CONVENTION_UNKNOWN = 0,
	SMC_CONVENTION_LEGACY = 1,
	SMC_CONVENTION_ARM_32 = 2,
	SMC_CONVENTION_ARM_64 = 3,
};

enum qcom_scm_ice_cipher {
	QCOM_SCM_ICE_CIPHER_AES_128_XTS = 0,
	QCOM_SCM_ICE_CIPHER_AES_128_CBC = 1,
	QCOM_SCM_ICE_CIPHER_AES_256_XTS = 3,
	QCOM_SCM_ICE_CIPHER_AES_256_CBC = 4,
};

enum qcom_scm_ocmem_client {
	QCOM_SCM_OCMEM_UNUSED_ID = 0,
	QCOM_SCM_OCMEM_GRAPHICS_ID = 1,
	QCOM_SCM_OCMEM_VIDEO_ID = 2,
	QCOM_SCM_OCMEM_LP_AUDIO_ID = 3,
	QCOM_SCM_OCMEM_SENSORS_ID = 4,
	QCOM_SCM_OCMEM_OTHER_OS_ID = 5,
	QCOM_SCM_OCMEM_DEBUG_ID = 6,
};

enum qcom_smmu_impl_reg_offset {
	QCOM_SMMU_TBU_PWR_STATUS = 0,
	QCOM_SMMU_STATS_SYNC_INV_TBU_ACK = 1,
	QCOM_SMMU_MMU2QSS_AND_SAFE_WAIT_CNTR = 2,
};

enum qcom_tzmem_policy {
	QCOM_TZMEM_POLICY_STATIC = 1,
	QCOM_TZMEM_POLICY_MULTIPLIER = 2,
	QCOM_TZMEM_POLICY_ON_DEMAND = 3,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum qpnpint_regs {
	QPNPINT_REG_RT_STS = 16,
	QPNPINT_REG_SET_TYPE = 17,
	QPNPINT_REG_POLARITY_HIGH = 18,
	QPNPINT_REG_POLARITY_LOW = 19,
	QPNPINT_REG_LATCHED_CLR = 20,
	QPNPINT_REG_EN_SET = 21,
	QPNPINT_REG_EN_CLR = 22,
	QPNPINT_REG_LATCHED_STS = 24,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum ramfs_param {
	Opt_mode___5 = 0,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_dev_type {
	RDMA_DEVICE_TYPE_SMI = 1,
};

enum rdma_nl_name_assign_type {
	RDMA_NAME_ASSIGN_TYPE_UNKNOWN = 0,
	RDMA_NAME_ASSIGN_TYPE_USER = 1,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_MAX = 8,
};

enum rdmacg_file_type {
	RDMACG_RESOURCE_TYPE_MAX = 0,
	RDMACG_RESOURCE_TYPE_STAT = 1,
};

enum rdmacg_resource_type {
	RDMACG_RESOURCE_HCA_HANDLE = 0,
	RDMACG_RESOURCE_HCA_OBJECT = 1,
	RDMACG_RESOURCE_MAX = 2,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum recovery_flags {
	MD_RECOVERY_NEEDED = 0,
	MD_RECOVERY_RUNNING = 1,
	MD_RECOVERY_INTR = 2,
	MD_RECOVERY_DONE = 3,
	MD_RECOVERY_FROZEN = 4,
	MD_RECOVERY_WAIT = 5,
	MD_RECOVERY_ERROR = 6,
	MD_RECOVERY_SYNC = 7,
	MD_RECOVERY_REQUESTED = 8,
	MD_RECOVERY_CHECK = 9,
	MD_RECOVERY_RECOVER = 10,
	MD_RECOVERY_RESHAPE = 11,
	MD_RESYNCING_REMOTE = 12,
};

enum ref_state_type {
	REF_TYPE_PTR = 1,
	REF_TYPE_IRQ = 2,
	REF_TYPE_LOCK = 3,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regex_type {
	MATCH_FULL = 0,
	MATCH_FRONT_ONLY = 1,
	MATCH_MIDDLE_ONLY = 2,
	MATCH_END_ONLY = 3,
	MATCH_GLOB = 4,
	MATCH_INDEX = 5,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum regulator_active_discharge {
	REGULATOR_ACTIVE_DISCHARGE_DEFAULT = 0,
	REGULATOR_ACTIVE_DISCHARGE_DISABLE = 1,
	REGULATOR_ACTIVE_DISCHARGE_ENABLE = 2,
};

enum regulator_detection_severity {
	REGULATOR_SEVERITY_PROT = 0,
	REGULATOR_SEVERITY_ERR = 1,
	REGULATOR_SEVERITY_WARN = 2,
};

enum regulator_get_type {
	NORMAL_GET = 0,
	EXCLUSIVE_GET = 1,
	OPTIONAL_GET = 2,
	MAX_GET_TYPE = 3,
};

enum regulator_status {
	REGULATOR_STATUS_OFF = 0,
	REGULATOR_STATUS_ON = 1,
	REGULATOR_STATUS_ERROR = 2,
	REGULATOR_STATUS_FAST = 3,
	REGULATOR_STATUS_NORMAL = 4,
	REGULATOR_STATUS_IDLE = 5,
	REGULATOR_STATUS_STANDBY = 6,
	REGULATOR_STATUS_BYPASS = 7,
	REGULATOR_STATUS_UNDEFINED = 8,
};

enum regulator_type {
	REGULATOR_VOLTAGE = 0,
	REGULATOR_CURRENT = 1,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_NOUNMAP = 28,
	__REQ_NR_BITS = 29,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 12,
	REQ_OP_ZONE_RESET = 13,
	REQ_OP_ZONE_RESET_ALL = 15,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum res_type {
	_MEM = 0,
	_MEMSWAP = 1,
	_KMEM = 2,
	_TCP = 3,
};

enum resctrl_conf_type {
	CDP_NONE = 0,
	CDP_CODE = 1,
	CDP_DATA = 2,
};

enum reset_control_flags {
	RESET_CONTROL_EXCLUSIVE = 4,
	RESET_CONTROL_EXCLUSIVE_DEASSERTED = 12,
	RESET_CONTROL_EXCLUSIVE_RELEASED = 0,
	RESET_CONTROL_SHARED = 1,
	RESET_CONTROL_SHARED_DEASSERTED = 9,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE = 6,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_DEASSERTED = 14,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_RELEASED = 2,
	RESET_CONTROL_OPTIONAL_SHARED = 3,
	RESET_CONTROL_OPTIONAL_SHARED_DEASSERTED = 11,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum ring_buffer_flags {
	RB_FL_OVERWRITE = 1,
};

enum ring_buffer_type {
	RINGBUF_TYPE_DATA_TYPE_LEN_MAX = 28,
	RINGBUF_TYPE_PADDING = 29,
	RINGBUF_TYPE_TIME_EXTEND = 30,
	RINGBUF_TYPE_TIME_STAMP = 31,
};

enum ripas {
	RSI_RIPAS_EMPTY = 0,
	RSI_RIPAS_RAM = 1,
	RSI_RIPAS_DESTROYED = 2,
	RSI_RIPAS_DEV = 3,
};

enum rk3308_plls {
	apll___2 = 0,
	dpll___2 = 1,
	vpll0 = 2,
	vpll1 = 3,
};

enum rk3328_plls {
	apll___3 = 0,
	dpll___3 = 1,
	cpll___2 = 2,
	gpll___2 = 3,
	npll___2 = 4,
};

enum rk3368_plls {
	apllb = 0,
	aplll = 1,
	dpll___4 = 2,
	cpll___3 = 3,
	gpll___3 = 4,
	npll___3 = 5,
};

enum rk3399_plls {
	lpll = 0,
	bpll = 1,
	dpll___5 = 2,
	cpll___4 = 3,
	gpll___4 = 4,
	npll___4 = 5,
	vpll = 6,
};

enum rk3399_pmu_plls {
	ppll = 0,
};

enum rk3568_plls {
	apll___4 = 0,
	dpll___6 = 1,
	gpll___5 = 2,
	cpll___5 = 3,
	npll___5 = 4,
	vpll___2 = 5,
};

enum rk3568_pmu_plls {
	ppll___2 = 0,
	hpll = 1,
};

enum rk3576_plls {
	bpll___2 = 0,
	lpll___2 = 1,
	vpll___3 = 2,
	aupll = 3,
	cpll___6 = 4,
	gpll___6 = 5,
	ppll___3 = 6,
};

enum rk3588_plls {
	b0pll = 0,
	b1pll = 1,
	lpll___3 = 2,
	v0pll = 3,
	aupll___2 = 4,
	cpll___7 = 5,
	gpll___7 = 6,
	npll___6 = 7,
	ppll___4 = 8,
};

enum rk3x_i2c_state {
	STATE_IDLE = 0,
	STATE_START = 1,
	STATE_READ = 2,
	STATE_WRITE = 3,
	STATE_STOP = 4,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
};

enum rmi_reg_state {
	RMI_REG_STATE_DEFAULT = 0,
	RMI_REG_STATE_OFF = 1,
	RMI_REG_STATE_ON = 2,
};

enum rmi_sensor_type {
	rmi_sensor_default = 0,
	rmi_sensor_touchscreen = 1,
	rmi_sensor_touchpad = 2,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum rockchip_clk_branch_type {
	branch_composite = 0,
	branch_mux = 1,
	branch_muxgrf = 2,
	branch_divider = 3,
	branch_fraction_divider = 4,
	branch_gate = 5,
	branch_mmc = 6,
	branch_inverter = 7,
	branch_factor = 8,
	branch_ddrclk = 9,
	branch_half_divider = 10,
};

enum rockchip_mux_route_location {
	ROCKCHIP_ROUTE_SAME = 0,
	ROCKCHIP_ROUTE_PMU = 1,
	ROCKCHIP_ROUTE_GRF = 2,
};

enum rockchip_pin_drv_type {
	DRV_TYPE_IO_DEFAULT = 0,
	DRV_TYPE_IO_1V8_OR_3V0 = 1,
	DRV_TYPE_IO_1V8_ONLY = 2,
	DRV_TYPE_IO_1V8_3V0_AUTO = 3,
	DRV_TYPE_IO_3V3_ONLY = 4,
	DRV_TYPE_MAX = 5,
};

enum rockchip_pin_pull_type {
	PULL_TYPE_IO_DEFAULT = 0,
	PULL_TYPE_IO_1V8_ONLY = 1,
	PULL_TYPE_MAX = 2,
};

enum rockchip_pinctrl_type {
	PX30 = 0,
	RV1108 = 1,
	RV1126 = 2,
	RK2928 = 3,
	RK3066B = 4,
	RK3128 = 5,
	RK3188 = 6,
	RK3288 = 7,
	RK3308 = 8,
	RK3328 = 9,
	RK3368 = 10,
	RK3399 = 11,
	RK3568 = 12,
	RK3576 = 13,
	RK3588 = 14,
};

enum rockchip_pll_type {
	pll_rk3036 = 0,
	pll_rk3066 = 1,
	pll_rk3328 = 2,
	pll_rk3399 = 3,
	pll_rk3588 = 4,
	pll_rk3588_core = 5,
	pll_rk3588_ddr = 6,
};

enum rp_check {
	RP_CHECK_CALL = 0,
	RP_CHECK_CHAIN_CALL = 1,
	RP_CHECK_RET = 2,
};

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

enum rpi_firmware_clk_id {
	RPI_FIRMWARE_EMMC_CLK_ID = 1,
	RPI_FIRMWARE_UART_CLK_ID = 2,
	RPI_FIRMWARE_ARM_CLK_ID = 3,
	RPI_FIRMWARE_CORE_CLK_ID = 4,
	RPI_FIRMWARE_V3D_CLK_ID = 5,
	RPI_FIRMWARE_H264_CLK_ID = 6,
	RPI_FIRMWARE_ISP_CLK_ID = 7,
	RPI_FIRMWARE_SDRAM_CLK_ID = 8,
	RPI_FIRMWARE_PIXEL_CLK_ID = 9,
	RPI_FIRMWARE_PWM_CLK_ID = 10,
	RPI_FIRMWARE_HEVC_CLK_ID = 11,
	RPI_FIRMWARE_EMMC2_CLK_ID = 12,
	RPI_FIRMWARE_M2MC_CLK_ID = 13,
	RPI_FIRMWARE_PIXEL_BVB_CLK_ID = 14,
	RPI_FIRMWARE_VEC_CLK_ID = 15,
	RPI_FIRMWARE_NUM_CLK_ID = 16,
};

enum rpi_firmware_property_status {
	RPI_FIRMWARE_STATUS_REQUEST = 0,
	RPI_FIRMWARE_STATUS_SUCCESS = 2147483648,
	RPI_FIRMWARE_STATUS_ERROR = 2147483649,
};

enum rpi_firmware_property_tag {
	RPI_FIRMWARE_PROPERTY_END = 0,
	RPI_FIRMWARE_GET_FIRMWARE_REVISION = 1,
	RPI_FIRMWARE_SET_CURSOR_INFO = 32784,
	RPI_FIRMWARE_SET_CURSOR_STATE = 32785,
	RPI_FIRMWARE_GET_BOARD_MODEL = 65537,
	RPI_FIRMWARE_GET_BOARD_REVISION = 65538,
	RPI_FIRMWARE_GET_BOARD_MAC_ADDRESS = 65539,
	RPI_FIRMWARE_GET_BOARD_SERIAL = 65540,
	RPI_FIRMWARE_GET_ARM_MEMORY = 65541,
	RPI_FIRMWARE_GET_VC_MEMORY = 65542,
	RPI_FIRMWARE_GET_CLOCKS = 65543,
	RPI_FIRMWARE_GET_POWER_STATE = 131073,
	RPI_FIRMWARE_GET_TIMING = 131074,
	RPI_FIRMWARE_SET_POWER_STATE = 163841,
	RPI_FIRMWARE_GET_CLOCK_STATE = 196609,
	RPI_FIRMWARE_GET_CLOCK_RATE = 196610,
	RPI_FIRMWARE_GET_VOLTAGE = 196611,
	RPI_FIRMWARE_GET_MAX_CLOCK_RATE = 196612,
	RPI_FIRMWARE_GET_MAX_VOLTAGE = 196613,
	RPI_FIRMWARE_GET_TEMPERATURE = 196614,
	RPI_FIRMWARE_GET_MIN_CLOCK_RATE = 196615,
	RPI_FIRMWARE_GET_MIN_VOLTAGE = 196616,
	RPI_FIRMWARE_GET_TURBO = 196617,
	RPI_FIRMWARE_GET_MAX_TEMPERATURE = 196618,
	RPI_FIRMWARE_GET_STC = 196619,
	RPI_FIRMWARE_ALLOCATE_MEMORY = 196620,
	RPI_FIRMWARE_LOCK_MEMORY = 196621,
	RPI_FIRMWARE_UNLOCK_MEMORY = 196622,
	RPI_FIRMWARE_RELEASE_MEMORY = 196623,
	RPI_FIRMWARE_EXECUTE_CODE = 196624,
	RPI_FIRMWARE_EXECUTE_QPU = 196625,
	RPI_FIRMWARE_SET_ENABLE_QPU = 196626,
	RPI_FIRMWARE_GET_DISPMANX_RESOURCE_MEM_HANDLE = 196628,
	RPI_FIRMWARE_GET_EDID_BLOCK = 196640,
	RPI_FIRMWARE_GET_CUSTOMER_OTP = 196641,
	RPI_FIRMWARE_GET_DOMAIN_STATE = 196656,
	RPI_FIRMWARE_GET_THROTTLED = 196678,
	RPI_FIRMWARE_GET_CLOCK_MEASURED = 196679,
	RPI_FIRMWARE_NOTIFY_REBOOT = 196680,
	RPI_FIRMWARE_SET_CLOCK_STATE = 229377,
	RPI_FIRMWARE_SET_CLOCK_RATE = 229378,
	RPI_FIRMWARE_SET_VOLTAGE = 229379,
	RPI_FIRMWARE_SET_TURBO = 229385,
	RPI_FIRMWARE_SET_CUSTOMER_OTP = 229409,
	RPI_FIRMWARE_SET_DOMAIN_STATE = 229424,
	RPI_FIRMWARE_GET_GPIO_STATE = 196673,
	RPI_FIRMWARE_SET_GPIO_STATE = 229441,
	RPI_FIRMWARE_SET_SDHOST_CLOCK = 229442,
	RPI_FIRMWARE_GET_GPIO_CONFIG = 196675,
	RPI_FIRMWARE_SET_GPIO_CONFIG = 229443,
	RPI_FIRMWARE_GET_PERIPH_REG = 196677,
	RPI_FIRMWARE_SET_PERIPH_REG = 229445,
	RPI_FIRMWARE_GET_POE_HAT_VAL = 196681,
	RPI_FIRMWARE_SET_POE_HAT_VAL = 196688,
	RPI_FIRMWARE_NOTIFY_XHCI_RESET = 196696,
	RPI_FIRMWARE_NOTIFY_DISPLAY_DONE = 196710,
	RPI_FIRMWARE_FRAMEBUFFER_ALLOCATE = 262145,
	RPI_FIRMWARE_FRAMEBUFFER_BLANK = 262146,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PHYSICAL_WIDTH_HEIGHT = 262147,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_WIDTH_HEIGHT = 262148,
	RPI_FIRMWARE_FRAMEBUFFER_GET_DEPTH = 262149,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PIXEL_ORDER = 262150,
	RPI_FIRMWARE_FRAMEBUFFER_GET_ALPHA_MODE = 262151,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PITCH = 262152,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_OFFSET = 262153,
	RPI_FIRMWARE_FRAMEBUFFER_GET_OVERSCAN = 262154,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PALETTE = 262155,
	RPI_FIRMWARE_FRAMEBUFFER_GET_TOUCHBUF = 262159,
	RPI_FIRMWARE_FRAMEBUFFER_GET_GPIOVIRTBUF = 262160,
	RPI_FIRMWARE_FRAMEBUFFER_RELEASE = 294913,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PHYSICAL_WIDTH_HEIGHT = 278531,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_WIDTH_HEIGHT = 278532,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_DEPTH = 278533,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PIXEL_ORDER = 278534,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_ALPHA_MODE = 278535,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_OFFSET = 278537,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_OVERSCAN = 278538,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PALETTE = 278539,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VSYNC = 278542,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PHYSICAL_WIDTH_HEIGHT = 294915,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_WIDTH_HEIGHT = 294916,
	RPI_FIRMWARE_FRAMEBUFFER_SET_DEPTH = 294917,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PIXEL_ORDER = 294918,
	RPI_FIRMWARE_FRAMEBUFFER_SET_ALPHA_MODE = 294919,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_OFFSET = 294921,
	RPI_FIRMWARE_FRAMEBUFFER_SET_OVERSCAN = 294922,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PALETTE = 294923,
	RPI_FIRMWARE_FRAMEBUFFER_SET_TOUCHBUF = 294943,
	RPI_FIRMWARE_FRAMEBUFFER_SET_GPIOVIRTBUF = 294944,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VSYNC = 294926,
	RPI_FIRMWARE_FRAMEBUFFER_SET_BACKLIGHT = 294927,
	RPI_FIRMWARE_VCHIQ_INIT = 294928,
	RPI_FIRMWARE_GET_COMMAND_LINE = 327681,
	RPI_FIRMWARE_GET_DMA_CHANNELS = 393217,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
};

enum rproc_crash_type {
	RPROC_MMUFAULT = 0,
	RPROC_WATCHDOG = 1,
	RPROC_FATAL_ERROR = 2,
};

enum rproc_dump_mechanism {
	RPROC_COREDUMP_DISABLED = 0,
	RPROC_COREDUMP_ENABLED = 1,
	RPROC_COREDUMP_INLINE = 2,
};

enum rproc_features {
	RPROC_FEAT_ATTACH_ON_RECOVERY = 0,
	RPROC_MAX_FEATURES = 1,
};

enum rproc_state {
	RPROC_OFFLINE = 0,
	RPROC_SUSPENDED = 1,
	RPROC_RUNNING = 2,
	RPROC_CRASHED = 3,
	RPROC_DELETED = 4,
	RPROC_ATTACHED = 5,
	RPROC_DETACHED = 6,
	RPROC_LAST = 7,
};

enum rpu_oper_mode {
	PM_RPU_MODE_LOCKSTEP = 0,
	PM_RPU_MODE_SPLIT = 1,
};

enum rpu_tcm_comb {
	PM_RPU_TCM_SPLIT = 0,
	PM_RPU_TCM_COMB = 1,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rsaprivkey_actions {
	ACT_rsa_get_d = 0,
	ACT_rsa_get_dp = 1,
	ACT_rsa_get_dq = 2,
	ACT_rsa_get_e = 3,
	ACT_rsa_get_n = 4,
	ACT_rsa_get_p = 5,
	ACT_rsa_get_q = 6,
	ACT_rsa_get_qinv = 7,
	NR__rsaprivkey_actions = 8,
};

enum rsapubkey_actions {
	ACT_rsa_get_e___2 = 0,
	ACT_rsa_get_n___2 = 1,
	NR__rsapubkey_actions = 2,
};

enum rsc_handling_status {
	RSC_HANDLED = 0,
	RSC_IGNORED = 1,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt6_nud_state {
	RT6_NUD_FAIL_HARD = -3,
	RT6_NUD_FAIL_PROBE = -2,
	RT6_NUD_FAIL_DO_RR = -1,
	RT6_NUD_SUCCEED = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	__RTA_MAX = 31,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	__RTNLGRP_MAX = 37,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s2mpa01_reg {
	S2MPA01_REG_ID = 0,
	S2MPA01_REG_INT1 = 1,
	S2MPA01_REG_INT2 = 2,
	S2MPA01_REG_INT3 = 3,
	S2MPA01_REG_INT1M = 4,
	S2MPA01_REG_INT2M = 5,
	S2MPA01_REG_INT3M = 6,
	S2MPA01_REG_ST1 = 7,
	S2MPA01_REG_ST2 = 8,
	S2MPA01_REG_PWRONSRC = 9,
	S2MPA01_REG_OFFSRC = 10,
	S2MPA01_REG_RTC_BUF = 11,
	S2MPA01_REG_CTRL1 = 12,
	S2MPA01_REG_ETC_TEST = 13,
	S2MPA01_REG_RSVD1 = 14,
	S2MPA01_REG_BU_CHG = 15,
	S2MPA01_REG_RAMP1 = 16,
	S2MPA01_REG_RAMP2 = 17,
	S2MPA01_REG_LDO_DSCH1 = 18,
	S2MPA01_REG_LDO_DSCH2 = 19,
	S2MPA01_REG_LDO_DSCH3 = 20,
	S2MPA01_REG_LDO_DSCH4 = 21,
	S2MPA01_REG_OTP_ADRL = 22,
	S2MPA01_REG_OTP_ADRH = 23,
	S2MPA01_REG_OTP_DATA = 24,
	S2MPA01_REG_MON1SEL = 25,
	S2MPA01_REG_MON2SEL = 26,
	S2MPA01_REG_LEE = 27,
	S2MPA01_REG_RSVD2 = 28,
	S2MPA01_REG_RSVD3 = 29,
	S2MPA01_REG_RSVD4 = 30,
	S2MPA01_REG_RSVD5 = 31,
	S2MPA01_REG_RSVD6 = 32,
	S2MPA01_REG_TOP_RSVD = 33,
	S2MPA01_REG_DVS_SEL = 34,
	S2MPA01_REG_DVS_PTR = 35,
	S2MPA01_REG_DVS_DATA = 36,
	S2MPA01_REG_RSVD_NO = 37,
	S2MPA01_REG_UVLO = 38,
	S2MPA01_REG_LEE_NO = 39,
	S2MPA01_REG_B1CTRL1 = 40,
	S2MPA01_REG_B1CTRL2 = 41,
	S2MPA01_REG_B2CTRL1 = 42,
	S2MPA01_REG_B2CTRL2 = 43,
	S2MPA01_REG_B3CTRL1 = 44,
	S2MPA01_REG_B3CTRL2 = 45,
	S2MPA01_REG_B4CTRL1 = 46,
	S2MPA01_REG_B4CTRL2 = 47,
	S2MPA01_REG_B5CTRL1 = 48,
	S2MPA01_REG_B5CTRL2 = 49,
	S2MPA01_REG_B5CTRL3 = 50,
	S2MPA01_REG_B5CTRL4 = 51,
	S2MPA01_REG_B5CTRL5 = 52,
	S2MPA01_REG_B5CTRL6 = 53,
	S2MPA01_REG_B6CTRL1 = 54,
	S2MPA01_REG_B6CTRL2 = 55,
	S2MPA01_REG_B7CTRL1 = 56,
	S2MPA01_REG_B7CTRL2 = 57,
	S2MPA01_REG_B8CTRL1 = 58,
	S2MPA01_REG_B8CTRL2 = 59,
	S2MPA01_REG_B9CTRL1 = 60,
	S2MPA01_REG_B9CTRL2 = 61,
	S2MPA01_REG_B10CTRL1 = 62,
	S2MPA01_REG_B10CTRL2 = 63,
	S2MPA01_REG_L1CTRL = 64,
	S2MPA01_REG_L2CTRL = 65,
	S2MPA01_REG_L3CTRL = 66,
	S2MPA01_REG_L4CTRL = 67,
	S2MPA01_REG_L5CTRL = 68,
	S2MPA01_REG_L6CTRL = 69,
	S2MPA01_REG_L7CTRL = 70,
	S2MPA01_REG_L8CTRL = 71,
	S2MPA01_REG_L9CTRL = 72,
	S2MPA01_REG_L10CTRL = 73,
	S2MPA01_REG_L11CTRL = 74,
	S2MPA01_REG_L12CTRL = 75,
	S2MPA01_REG_L13CTRL = 76,
	S2MPA01_REG_L14CTRL = 77,
	S2MPA01_REG_L15CTRL = 78,
	S2MPA01_REG_L16CTRL = 79,
	S2MPA01_REG_L17CTRL = 80,
	S2MPA01_REG_L18CTRL = 81,
	S2MPA01_REG_L19CTRL = 82,
	S2MPA01_REG_L20CTRL = 83,
	S2MPA01_REG_L21CTRL = 84,
	S2MPA01_REG_L22CTRL = 85,
	S2MPA01_REG_L23CTRL = 86,
	S2MPA01_REG_L24CTRL = 87,
	S2MPA01_REG_L25CTRL = 88,
	S2MPA01_REG_L26CTRL = 89,
	S2MPA01_REG_LDO_OVCB1 = 90,
	S2MPA01_REG_LDO_OVCB2 = 91,
	S2MPA01_REG_LDO_OVCB3 = 92,
	S2MPA01_REG_LDO_OVCB4 = 93,
};

enum s2mps11_irq {
	S2MPS11_IRQ_PWRONF = 0,
	S2MPS11_IRQ_PWRONR = 1,
	S2MPS11_IRQ_JIGONBF = 2,
	S2MPS11_IRQ_JIGONBR = 3,
	S2MPS11_IRQ_ACOKBF = 4,
	S2MPS11_IRQ_ACOKBR = 5,
	S2MPS11_IRQ_PWRON1S = 6,
	S2MPS11_IRQ_MRB = 7,
	S2MPS11_IRQ_RTC60S = 8,
	S2MPS11_IRQ_RTCA1 = 9,
	S2MPS11_IRQ_RTCA0 = 10,
	S2MPS11_IRQ_SMPL = 11,
	S2MPS11_IRQ_RTC1S = 12,
	S2MPS11_IRQ_WTSR = 13,
	S2MPS11_IRQ_INT120C = 14,
	S2MPS11_IRQ_INT140C = 15,
	S2MPS11_IRQ_NR = 16,
};

enum s2mps11_reg {
	S2MPS11_REG_ID = 0,
	S2MPS11_REG_INT1 = 1,
	S2MPS11_REG_INT2 = 2,
	S2MPS11_REG_INT3 = 3,
	S2MPS11_REG_INT1M = 4,
	S2MPS11_REG_INT2M = 5,
	S2MPS11_REG_INT3M = 6,
	S2MPS11_REG_ST1 = 7,
	S2MPS11_REG_ST2 = 8,
	S2MPS11_REG_OFFSRC = 9,
	S2MPS11_REG_PWRONSRC = 10,
	S2MPS11_REG_RTC_CTRL = 11,
	S2MPS11_REG_CTRL1 = 12,
	S2MPS11_REG_ETC_TEST = 13,
	S2MPS11_REG_RSVD3 = 14,
	S2MPS11_REG_BU_CHG = 15,
	S2MPS11_REG_RAMP = 16,
	S2MPS11_REG_RAMP_BUCK = 17,
	S2MPS11_REG_LDO1_8 = 18,
	S2MPS11_REG_LDO9_16 = 19,
	S2MPS11_REG_LDO17_24 = 20,
	S2MPS11_REG_LDO25_32 = 21,
	S2MPS11_REG_LDO33_38 = 22,
	S2MPS11_REG_LDO1_8_1 = 23,
	S2MPS11_REG_LDO9_16_1 = 24,
	S2MPS11_REG_LDO17_24_1 = 25,
	S2MPS11_REG_LDO25_32_1 = 26,
	S2MPS11_REG_LDO33_38_1 = 27,
	S2MPS11_REG_OTP_ADRL = 28,
	S2MPS11_REG_OTP_ADRH = 29,
	S2MPS11_REG_OTP_DATA = 30,
	S2MPS11_REG_MON1SEL = 31,
	S2MPS11_REG_MON2SEL = 32,
	S2MPS11_REG_LEE = 33,
	S2MPS11_REG_RSVD_NO = 34,
	S2MPS11_REG_UVLO = 35,
	S2MPS11_REG_LEE_NO = 36,
	S2MPS11_REG_B1CTRL1 = 37,
	S2MPS11_REG_B1CTRL2 = 38,
	S2MPS11_REG_B2CTRL1 = 39,
	S2MPS11_REG_B2CTRL2 = 40,
	S2MPS11_REG_B3CTRL1 = 41,
	S2MPS11_REG_B3CTRL2 = 42,
	S2MPS11_REG_B4CTRL1 = 43,
	S2MPS11_REG_B4CTRL2 = 44,
	S2MPS11_REG_B5CTRL1 = 45,
	S2MPS11_REG_BUCK5_SW = 46,
	S2MPS11_REG_B5CTRL2 = 47,
	S2MPS11_REG_B5CTRL3 = 48,
	S2MPS11_REG_B5CTRL4 = 49,
	S2MPS11_REG_B5CTRL5 = 50,
	S2MPS11_REG_B6CTRL1 = 51,
	S2MPS11_REG_B6CTRL2 = 52,
	S2MPS11_REG_B7CTRL1 = 53,
	S2MPS11_REG_B7CTRL2 = 54,
	S2MPS11_REG_B8CTRL1 = 55,
	S2MPS11_REG_B8CTRL2 = 56,
	S2MPS11_REG_B9CTRL1 = 57,
	S2MPS11_REG_B9CTRL2 = 58,
	S2MPS11_REG_B10CTRL1 = 59,
	S2MPS11_REG_B10CTRL2 = 60,
	S2MPS11_REG_L1CTRL = 61,
	S2MPS11_REG_L2CTRL = 62,
	S2MPS11_REG_L3CTRL = 63,
	S2MPS11_REG_L4CTRL = 64,
	S2MPS11_REG_L5CTRL = 65,
	S2MPS11_REG_L6CTRL = 66,
	S2MPS11_REG_L7CTRL = 67,
	S2MPS11_REG_L8CTRL = 68,
	S2MPS11_REG_L9CTRL = 69,
	S2MPS11_REG_L10CTRL = 70,
	S2MPS11_REG_L11CTRL = 71,
	S2MPS11_REG_L12CTRL = 72,
	S2MPS11_REG_L13CTRL = 73,
	S2MPS11_REG_L14CTRL = 74,
	S2MPS11_REG_L15CTRL = 75,
	S2MPS11_REG_L16CTRL = 76,
	S2MPS11_REG_L17CTRL = 77,
	S2MPS11_REG_L18CTRL = 78,
	S2MPS11_REG_L19CTRL = 79,
	S2MPS11_REG_L20CTRL = 80,
	S2MPS11_REG_L21CTRL = 81,
	S2MPS11_REG_L22CTRL = 82,
	S2MPS11_REG_L23CTRL = 83,
	S2MPS11_REG_L24CTRL = 84,
	S2MPS11_REG_L25CTRL = 85,
	S2MPS11_REG_L26CTRL = 86,
	S2MPS11_REG_L27CTRL = 87,
	S2MPS11_REG_L28CTRL = 88,
	S2MPS11_REG_L29CTRL = 89,
	S2MPS11_REG_L30CTRL = 90,
	S2MPS11_REG_L31CTRL = 91,
	S2MPS11_REG_L32CTRL = 92,
	S2MPS11_REG_L33CTRL = 93,
	S2MPS11_REG_L34CTRL = 94,
	S2MPS11_REG_L35CTRL = 95,
	S2MPS11_REG_L36CTRL = 96,
	S2MPS11_REG_L37CTRL = 97,
	S2MPS11_REG_L38CTRL = 98,
};

enum s2mps13_reg {
	S2MPS13_REG_ID = 0,
	S2MPS13_REG_INT1 = 1,
	S2MPS13_REG_INT2 = 2,
	S2MPS13_REG_INT3 = 3,
	S2MPS13_REG_INT1M = 4,
	S2MPS13_REG_INT2M = 5,
	S2MPS13_REG_INT3M = 6,
	S2MPS13_REG_ST1 = 7,
	S2MPS13_REG_ST2 = 8,
	S2MPS13_REG_PWRONSRC = 9,
	S2MPS13_REG_OFFSRC = 10,
	S2MPS13_REG_BU_CHG = 11,
	S2MPS13_REG_RTCCTRL = 12,
	S2MPS13_REG_CTRL1 = 13,
	S2MPS13_REG_CTRL2 = 14,
	S2MPS13_REG_RSVD1 = 15,
	S2MPS13_REG_RSVD2 = 16,
	S2MPS13_REG_RSVD3 = 17,
	S2MPS13_REG_RSVD4 = 18,
	S2MPS13_REG_RSVD5 = 19,
	S2MPS13_REG_RSVD6 = 20,
	S2MPS13_REG_CTRL3 = 21,
	S2MPS13_REG_RSVD7 = 22,
	S2MPS13_REG_RSVD8 = 23,
	S2MPS13_REG_WRSTBI = 24,
	S2MPS13_REG_B1CTRL = 25,
	S2MPS13_REG_B1OUT = 26,
	S2MPS13_REG_B2CTRL = 27,
	S2MPS13_REG_B2OUT = 28,
	S2MPS13_REG_B3CTRL = 29,
	S2MPS13_REG_B3OUT = 30,
	S2MPS13_REG_B4CTRL = 31,
	S2MPS13_REG_B4OUT = 32,
	S2MPS13_REG_B5CTRL = 33,
	S2MPS13_REG_B5OUT = 34,
	S2MPS13_REG_B6CTRL = 35,
	S2MPS13_REG_B6OUT = 36,
	S2MPS13_REG_B7CTRL = 37,
	S2MPS13_REG_B7SW = 38,
	S2MPS13_REG_B7OUT = 39,
	S2MPS13_REG_B8CTRL = 40,
	S2MPS13_REG_B8OUT = 41,
	S2MPS13_REG_B9CTRL = 42,
	S2MPS13_REG_B9OUT = 43,
	S2MPS13_REG_B10CTRL = 44,
	S2MPS13_REG_B10OUT = 45,
	S2MPS13_REG_BB1CTRL = 46,
	S2MPS13_REG_BB1OUT = 47,
	S2MPS13_REG_BUCK_RAMP1 = 48,
	S2MPS13_REG_BUCK_RAMP2 = 49,
	S2MPS13_REG_LDO_DVS1 = 50,
	S2MPS13_REG_LDO_DVS2 = 51,
	S2MPS13_REG_LDO_DVS3 = 52,
	S2MPS13_REG_B6OUT2 = 53,
	S2MPS13_REG_L1CTRL = 54,
	S2MPS13_REG_L2CTRL = 55,
	S2MPS13_REG_L3CTRL = 56,
	S2MPS13_REG_L4CTRL = 57,
	S2MPS13_REG_L5CTRL = 58,
	S2MPS13_REG_L6CTRL = 59,
	S2MPS13_REG_L7CTRL = 60,
	S2MPS13_REG_L8CTRL = 61,
	S2MPS13_REG_L9CTRL = 62,
	S2MPS13_REG_L10CTRL = 63,
	S2MPS13_REG_L11CTRL = 64,
	S2MPS13_REG_L12CTRL = 65,
	S2MPS13_REG_L13CTRL = 66,
	S2MPS13_REG_L14CTRL = 67,
	S2MPS13_REG_L15CTRL = 68,
	S2MPS13_REG_L16CTRL = 69,
	S2MPS13_REG_L17CTRL = 70,
	S2MPS13_REG_L18CTRL = 71,
	S2MPS13_REG_L19CTRL = 72,
	S2MPS13_REG_L20CTRL = 73,
	S2MPS13_REG_L21CTRL = 74,
	S2MPS13_REG_L22CTRL = 75,
	S2MPS13_REG_L23CTRL = 76,
	S2MPS13_REG_L24CTRL = 77,
	S2MPS13_REG_L25CTRL = 78,
	S2MPS13_REG_L26CTRL = 79,
	S2MPS13_REG_L27CTRL = 80,
	S2MPS13_REG_L28CTRL = 81,
	S2MPS13_REG_L29CTRL = 82,
	S2MPS13_REG_L30CTRL = 83,
	S2MPS13_REG_L31CTRL = 84,
	S2MPS13_REG_L32CTRL = 85,
	S2MPS13_REG_L33CTRL = 86,
	S2MPS13_REG_L34CTRL = 87,
	S2MPS13_REG_L35CTRL = 88,
	S2MPS13_REG_L36CTRL = 89,
	S2MPS13_REG_L37CTRL = 90,
	S2MPS13_REG_L38CTRL = 91,
	S2MPS13_REG_L39CTRL = 92,
	S2MPS13_REG_L40CTRL = 93,
	S2MPS13_REG_LDODSCH1 = 94,
	S2MPS13_REG_LDODSCH2 = 95,
	S2MPS13_REG_LDODSCH3 = 96,
	S2MPS13_REG_LDODSCH4 = 97,
	S2MPS13_REG_LDODSCH5 = 98,
};

enum s2mps14_irq {
	S2MPS14_IRQ_PWRONF = 0,
	S2MPS14_IRQ_PWRONR = 1,
	S2MPS14_IRQ_JIGONBF = 2,
	S2MPS14_IRQ_JIGONBR = 3,
	S2MPS14_IRQ_ACOKBF = 4,
	S2MPS14_IRQ_ACOKBR = 5,
	S2MPS14_IRQ_PWRON1S = 6,
	S2MPS14_IRQ_MRB = 7,
	S2MPS14_IRQ_RTC60S = 8,
	S2MPS14_IRQ_RTCA1 = 9,
	S2MPS14_IRQ_RTCA0 = 10,
	S2MPS14_IRQ_SMPL = 11,
	S2MPS14_IRQ_RTC1S = 12,
	S2MPS14_IRQ_WTSR = 13,
	S2MPS14_IRQ_INT120C = 14,
	S2MPS14_IRQ_INT140C = 15,
	S2MPS14_IRQ_TSD = 16,
	S2MPS14_IRQ_NR = 17,
};

enum s2mps14_reg {
	S2MPS14_REG_ID = 0,
	S2MPS14_REG_INT1 = 1,
	S2MPS14_REG_INT2 = 2,
	S2MPS14_REG_INT3 = 3,
	S2MPS14_REG_INT1M = 4,
	S2MPS14_REG_INT2M = 5,
	S2MPS14_REG_INT3M = 6,
	S2MPS14_REG_ST1 = 7,
	S2MPS14_REG_ST2 = 8,
	S2MPS14_REG_PWRONSRC = 9,
	S2MPS14_REG_OFFSRC = 10,
	S2MPS14_REG_BU_CHG = 11,
	S2MPS14_REG_RTCCTRL = 12,
	S2MPS14_REG_CTRL1 = 13,
	S2MPS14_REG_CTRL2 = 14,
	S2MPS14_REG_RSVD1 = 15,
	S2MPS14_REG_RSVD2 = 16,
	S2MPS14_REG_RSVD3 = 17,
	S2MPS14_REG_RSVD4 = 18,
	S2MPS14_REG_RSVD5 = 19,
	S2MPS14_REG_RSVD6 = 20,
	S2MPS14_REG_CTRL3 = 21,
	S2MPS14_REG_RSVD7 = 22,
	S2MPS14_REG_RSVD8 = 23,
	S2MPS14_REG_WRSTBI = 24,
	S2MPS14_REG_B1CTRL1 = 25,
	S2MPS14_REG_B1CTRL2 = 26,
	S2MPS14_REG_B2CTRL1 = 27,
	S2MPS14_REG_B2CTRL2 = 28,
	S2MPS14_REG_B3CTRL1 = 29,
	S2MPS14_REG_B3CTRL2 = 30,
	S2MPS14_REG_B4CTRL1 = 31,
	S2MPS14_REG_B4CTRL2 = 32,
	S2MPS14_REG_B5CTRL1 = 33,
	S2MPS14_REG_B5CTRL2 = 34,
	S2MPS14_REG_L1CTRL = 35,
	S2MPS14_REG_L2CTRL = 36,
	S2MPS14_REG_L3CTRL = 37,
	S2MPS14_REG_L4CTRL = 38,
	S2MPS14_REG_L5CTRL = 39,
	S2MPS14_REG_L6CTRL = 40,
	S2MPS14_REG_L7CTRL = 41,
	S2MPS14_REG_L8CTRL = 42,
	S2MPS14_REG_L9CTRL = 43,
	S2MPS14_REG_L10CTRL = 44,
	S2MPS14_REG_L11CTRL = 45,
	S2MPS14_REG_L12CTRL = 46,
	S2MPS14_REG_L13CTRL = 47,
	S2MPS14_REG_L14CTRL = 48,
	S2MPS14_REG_L15CTRL = 49,
	S2MPS14_REG_L16CTRL = 50,
	S2MPS14_REG_L17CTRL = 51,
	S2MPS14_REG_L18CTRL = 52,
	S2MPS14_REG_L19CTRL = 53,
	S2MPS14_REG_L20CTRL = 54,
	S2MPS14_REG_L21CTRL = 55,
	S2MPS14_REG_L22CTRL = 56,
	S2MPS14_REG_L23CTRL = 57,
	S2MPS14_REG_L24CTRL = 58,
	S2MPS14_REG_L25CTRL = 59,
	S2MPS14_REG_LDODSCH1 = 60,
	S2MPS14_REG_LDODSCH2 = 61,
	S2MPS14_REG_LDODSCH3 = 62,
};

enum s2mps15_reg {
	S2MPS15_REG_ID = 0,
	S2MPS15_REG_INT1 = 1,
	S2MPS15_REG_INT2 = 2,
	S2MPS15_REG_INT3 = 3,
	S2MPS15_REG_INT1M = 4,
	S2MPS15_REG_INT2M = 5,
	S2MPS15_REG_INT3M = 6,
	S2MPS15_REG_ST1 = 7,
	S2MPS15_REG_ST2 = 8,
	S2MPS15_REG_PWRONSRC = 9,
	S2MPS15_REG_OFFSRC = 10,
	S2MPS15_REG_BU_CHG = 11,
	S2MPS15_REG_RTC_BUF = 12,
	S2MPS15_REG_CTRL1 = 13,
	S2MPS15_REG_CTRL2 = 14,
	S2MPS15_REG_RSVD1 = 15,
	S2MPS15_REG_RSVD2 = 16,
	S2MPS15_REG_RSVD3 = 17,
	S2MPS15_REG_RSVD4 = 18,
	S2MPS15_REG_RSVD5 = 19,
	S2MPS15_REG_RSVD6 = 20,
	S2MPS15_REG_CTRL3 = 21,
	S2MPS15_REG_RSVD7 = 22,
	S2MPS15_REG_RSVD8 = 23,
	S2MPS15_REG_RSVD9 = 24,
	S2MPS15_REG_B1CTRL1 = 25,
	S2MPS15_REG_B1CTRL2 = 26,
	S2MPS15_REG_B2CTRL1 = 27,
	S2MPS15_REG_B2CTRL2 = 28,
	S2MPS15_REG_B3CTRL1 = 29,
	S2MPS15_REG_B3CTRL2 = 30,
	S2MPS15_REG_B4CTRL1 = 31,
	S2MPS15_REG_B4CTRL2 = 32,
	S2MPS15_REG_B5CTRL1 = 33,
	S2MPS15_REG_B5CTRL2 = 34,
	S2MPS15_REG_B6CTRL1 = 35,
	S2MPS15_REG_B6CTRL2 = 36,
	S2MPS15_REG_B7CTRL1 = 37,
	S2MPS15_REG_B7CTRL2 = 38,
	S2MPS15_REG_B8CTRL1 = 39,
	S2MPS15_REG_B8CTRL2 = 40,
	S2MPS15_REG_B9CTRL1 = 41,
	S2MPS15_REG_B9CTRL2 = 42,
	S2MPS15_REG_B10CTRL1 = 43,
	S2MPS15_REG_B10CTRL2 = 44,
	S2MPS15_REG_BBCTRL1 = 45,
	S2MPS15_REG_BBCTRL2 = 46,
	S2MPS15_REG_BRAMP = 47,
	S2MPS15_REG_LDODVS1 = 48,
	S2MPS15_REG_LDODVS2 = 49,
	S2MPS15_REG_LDODVS3 = 50,
	S2MPS15_REG_LDODVS4 = 51,
	S2MPS15_REG_L1CTRL = 52,
	S2MPS15_REG_L2CTRL = 53,
	S2MPS15_REG_L3CTRL = 54,
	S2MPS15_REG_L4CTRL = 55,
	S2MPS15_REG_L5CTRL = 56,
	S2MPS15_REG_L6CTRL = 57,
	S2MPS15_REG_L7CTRL = 58,
	S2MPS15_REG_L8CTRL = 59,
	S2MPS15_REG_L9CTRL = 60,
	S2MPS15_REG_L10CTRL = 61,
	S2MPS15_REG_L11CTRL = 62,
	S2MPS15_REG_L12CTRL = 63,
	S2MPS15_REG_L13CTRL = 64,
	S2MPS15_REG_L14CTRL = 65,
	S2MPS15_REG_L15CTRL = 66,
	S2MPS15_REG_L16CTRL = 67,
	S2MPS15_REG_L17CTRL = 68,
	S2MPS15_REG_L18CTRL = 69,
	S2MPS15_REG_L19CTRL = 70,
	S2MPS15_REG_L20CTRL = 71,
	S2MPS15_REG_L21CTRL = 72,
	S2MPS15_REG_L22CTRL = 73,
	S2MPS15_REG_L23CTRL = 74,
	S2MPS15_REG_L24CTRL = 75,
	S2MPS15_REG_L25CTRL = 76,
	S2MPS15_REG_L26CTRL = 77,
	S2MPS15_REG_L27CTRL = 78,
	S2MPS15_REG_LDODSCH1 = 79,
	S2MPS15_REG_LDODSCH2 = 80,
	S2MPS15_REG_LDODSCH3 = 81,
	S2MPS15_REG_LDODSCH4 = 82,
};

enum s2mpu02_irq {
	S2MPU02_IRQ_PWRONF = 0,
	S2MPU02_IRQ_PWRONR = 1,
	S2MPU02_IRQ_JIGONBF = 2,
	S2MPU02_IRQ_JIGONBR = 3,
	S2MPU02_IRQ_ACOKBF = 4,
	S2MPU02_IRQ_ACOKBR = 5,
	S2MPU02_IRQ_PWRON1S = 6,
	S2MPU02_IRQ_MRB = 7,
	S2MPU02_IRQ_RTC60S = 8,
	S2MPU02_IRQ_RTCA1 = 9,
	S2MPU02_IRQ_RTCA0 = 10,
	S2MPU02_IRQ_SMPL = 11,
	S2MPU02_IRQ_RTC1S = 12,
	S2MPU02_IRQ_WTSR = 13,
	S2MPU02_IRQ_INT120C = 14,
	S2MPU02_IRQ_INT140C = 15,
	S2MPU02_IRQ_TSD = 16,
	S2MPU02_IRQ_NR = 17,
};

enum s3c24xx_port_type {
	TYPE_S3C6400 = 0,
	TYPE_APPLE_S5L = 1,
};

enum s5m8767_irq {
	S5M8767_IRQ_PWRR = 0,
	S5M8767_IRQ_PWRF = 1,
	S5M8767_IRQ_PWR1S = 2,
	S5M8767_IRQ_JIGR = 3,
	S5M8767_IRQ_JIGF = 4,
	S5M8767_IRQ_LOWBAT2 = 5,
	S5M8767_IRQ_LOWBAT1 = 6,
	S5M8767_IRQ_MRB = 7,
	S5M8767_IRQ_DVSOK2 = 8,
	S5M8767_IRQ_DVSOK3 = 9,
	S5M8767_IRQ_DVSOK4 = 10,
	S5M8767_IRQ_RTC60S = 11,
	S5M8767_IRQ_RTCA1 = 12,
	S5M8767_IRQ_RTCA2 = 13,
	S5M8767_IRQ_SMPL = 14,
	S5M8767_IRQ_RTC1S = 15,
	S5M8767_IRQ_WTSR = 16,
	S5M8767_IRQ_NR = 17,
};

enum s5m8767_reg {
	S5M8767_REG_ID = 0,
	S5M8767_REG_INT1 = 1,
	S5M8767_REG_INT2 = 2,
	S5M8767_REG_INT3 = 3,
	S5M8767_REG_INT1M = 4,
	S5M8767_REG_INT2M = 5,
	S5M8767_REG_INT3M = 6,
	S5M8767_REG_STATUS1 = 7,
	S5M8767_REG_STATUS2 = 8,
	S5M8767_REG_STATUS3 = 9,
	S5M8767_REG_CTRL1 = 10,
	S5M8767_REG_CTRL2 = 11,
	S5M8767_REG_LOWBAT1 = 12,
	S5M8767_REG_LOWBAT2 = 13,
	S5M8767_REG_BUCHG = 14,
	S5M8767_REG_DVSRAMP = 15,
	S5M8767_REG_DVSTIMER2 = 16,
	S5M8767_REG_DVSTIMER3 = 17,
	S5M8767_REG_DVSTIMER4 = 18,
	S5M8767_REG_LDO1 = 19,
	S5M8767_REG_LDO2 = 20,
	S5M8767_REG_LDO3 = 21,
	S5M8767_REG_LDO4 = 22,
	S5M8767_REG_LDO5 = 23,
	S5M8767_REG_LDO6 = 24,
	S5M8767_REG_LDO7 = 25,
	S5M8767_REG_LDO8 = 26,
	S5M8767_REG_LDO9 = 27,
	S5M8767_REG_LDO10 = 28,
	S5M8767_REG_LDO11 = 29,
	S5M8767_REG_LDO12 = 30,
	S5M8767_REG_LDO13 = 31,
	S5M8767_REG_LDO14 = 32,
	S5M8767_REG_LDO15 = 33,
	S5M8767_REG_LDO16 = 34,
	S5M8767_REG_LDO17 = 35,
	S5M8767_REG_LDO18 = 36,
	S5M8767_REG_LDO19 = 37,
	S5M8767_REG_LDO20 = 38,
	S5M8767_REG_LDO21 = 39,
	S5M8767_REG_LDO22 = 40,
	S5M8767_REG_LDO23 = 41,
	S5M8767_REG_LDO24 = 42,
	S5M8767_REG_LDO25 = 43,
	S5M8767_REG_LDO26 = 44,
	S5M8767_REG_LDO27 = 45,
	S5M8767_REG_LDO28 = 46,
	S5M8767_REG_UVLO = 49,
	S5M8767_REG_BUCK1CTRL1 = 50,
	S5M8767_REG_BUCK1CTRL2 = 51,
	S5M8767_REG_BUCK2CTRL = 52,
	S5M8767_REG_BUCK2DVS1 = 53,
	S5M8767_REG_BUCK2DVS2 = 54,
	S5M8767_REG_BUCK2DVS3 = 55,
	S5M8767_REG_BUCK2DVS4 = 56,
	S5M8767_REG_BUCK2DVS5 = 57,
	S5M8767_REG_BUCK2DVS6 = 58,
	S5M8767_REG_BUCK2DVS7 = 59,
	S5M8767_REG_BUCK2DVS8 = 60,
	S5M8767_REG_BUCK3CTRL = 61,
	S5M8767_REG_BUCK3DVS1 = 62,
	S5M8767_REG_BUCK3DVS2 = 63,
	S5M8767_REG_BUCK3DVS3 = 64,
	S5M8767_REG_BUCK3DVS4 = 65,
	S5M8767_REG_BUCK3DVS5 = 66,
	S5M8767_REG_BUCK3DVS6 = 67,
	S5M8767_REG_BUCK3DVS7 = 68,
	S5M8767_REG_BUCK3DVS8 = 69,
	S5M8767_REG_BUCK4CTRL = 70,
	S5M8767_REG_BUCK4DVS1 = 71,
	S5M8767_REG_BUCK4DVS2 = 72,
	S5M8767_REG_BUCK4DVS3 = 73,
	S5M8767_REG_BUCK4DVS4 = 74,
	S5M8767_REG_BUCK4DVS5 = 75,
	S5M8767_REG_BUCK4DVS6 = 76,
	S5M8767_REG_BUCK4DVS7 = 77,
	S5M8767_REG_BUCK4DVS8 = 78,
	S5M8767_REG_BUCK5CTRL1 = 79,
	S5M8767_REG_BUCK5CTRL2 = 80,
	S5M8767_REG_BUCK5CTRL3 = 81,
	S5M8767_REG_BUCK5CTRL4 = 82,
	S5M8767_REG_BUCK5CTRL5 = 83,
	S5M8767_REG_BUCK6CTRL1 = 84,
	S5M8767_REG_BUCK6CTRL2 = 85,
	S5M8767_REG_BUCK7CTRL1 = 86,
	S5M8767_REG_BUCK7CTRL2 = 87,
	S5M8767_REG_BUCK8CTRL1 = 88,
	S5M8767_REG_BUCK8CTRL2 = 89,
	S5M8767_REG_BUCK9CTRL1 = 90,
	S5M8767_REG_BUCK9CTRL2 = 91,
	S5M8767_REG_LDO1CTRL = 92,
	S5M8767_REG_LDO2_1CTRL = 93,
	S5M8767_REG_LDO2_2CTRL = 94,
	S5M8767_REG_LDO2_3CTRL = 95,
	S5M8767_REG_LDO2_4CTRL = 96,
	S5M8767_REG_LDO3CTRL = 97,
	S5M8767_REG_LDO4CTRL = 98,
	S5M8767_REG_LDO5CTRL = 99,
	S5M8767_REG_LDO6CTRL = 100,
	S5M8767_REG_LDO7CTRL = 101,
	S5M8767_REG_LDO8CTRL = 102,
	S5M8767_REG_LDO9CTRL = 103,
	S5M8767_REG_LDO10CTRL = 104,
	S5M8767_REG_LDO11CTRL = 105,
	S5M8767_REG_LDO12CTRL = 106,
	S5M8767_REG_LDO13CTRL = 107,
	S5M8767_REG_LDO14CTRL = 108,
	S5M8767_REG_LDO15CTRL = 109,
	S5M8767_REG_LDO16CTRL = 110,
	S5M8767_REG_LDO17CTRL = 111,
	S5M8767_REG_LDO18CTRL = 112,
	S5M8767_REG_LDO19CTRL = 113,
	S5M8767_REG_LDO20CTRL = 114,
	S5M8767_REG_LDO21CTRL = 115,
	S5M8767_REG_LDO22CTRL = 116,
	S5M8767_REG_LDO23CTRL = 117,
	S5M8767_REG_LDO24CTRL = 118,
	S5M8767_REG_LDO25CTRL = 119,
	S5M8767_REG_LDO26CTRL = 120,
	S5M8767_REG_LDO27CTRL = 121,
	S5M8767_REG_LDO28CTRL = 122,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum samsung_pll_type {
	pll_2126 = 0,
	pll_3000 = 1,
	pll_35xx = 2,
	pll_36xx = 3,
	pll_2550 = 4,
	pll_2650 = 5,
	pll_4500 = 6,
	pll_4502 = 7,
	pll_4508 = 8,
	pll_4600 = 9,
	pll_4650 = 10,
	pll_4650c = 11,
	pll_6552 = 12,
	pll_6552_s3c2416 = 13,
	pll_6553 = 14,
	pll_2550x = 15,
	pll_2550xx = 16,
	pll_2650x = 17,
	pll_2650xx = 18,
	pll_1417x = 19,
	pll_1418x = 20,
	pll_1450x = 21,
	pll_1451x = 22,
	pll_1452x = 23,
	pll_1460x = 24,
	pll_0818x = 25,
	pll_0822x = 26,
	pll_0831x = 27,
	pll_142xx = 28,
	pll_0516x = 29,
	pll_0517x = 30,
	pll_0518x = 31,
	pll_531x = 32,
	pll_1051x = 33,
	pll_1052x = 34,
};

enum sata_phy_ctrl_regs {
	PHY_CTRL_1 = 0,
	PHY_CTRL_1_RESET = 1,
};

enum sata_phy_regs {
	BLOCK0_REG_BANK = 0,
	BLOCK0_XGXSSTATUS = 129,
	BLOCK0_XGXSSTATUS_PLL_LOCK = 4096,
	BLOCK0_SPARE = 141,
	BLOCK0_SPARE_OOB_CLK_SEL_MASK = 3,
	BLOCK0_SPARE_OOB_CLK_SEL_REFBY2 = 1,
	BLOCK1_REG_BANK = 16,
	BLOCK1_TEST_TX = 131,
	BLOCK1_TEST_TX_AMP_SHIFT = 12,
	PLL_REG_BANK_0 = 80,
	PLL_REG_BANK_0_PLLCONTROL_0 = 129,
	PLLCONTROL_0_FREQ_DET_RESTART = 8192,
	PLLCONTROL_0_FREQ_MONITOR = 4096,
	PLLCONTROL_0_SEQ_START = 32768,
	PLL_CAP_CHARGE_TIME = 131,
	PLL_VCO_CAL_THRESH = 132,
	PLL_CAP_CONTROL = 133,
	PLL_FREQ_DET_TIME = 134,
	PLL_ACTRL2 = 139,
	PLL_ACTRL2_SELDIV_MASK = 31,
	PLL_ACTRL2_SELDIV_SHIFT = 9,
	PLL_ACTRL6 = 134,
	PLL1_REG_BANK = 96,
	PLL1_ACTRL2 = 130,
	PLL1_ACTRL3 = 131,
	PLL1_ACTRL4 = 132,
	PLL1_ACTRL5 = 133,
	PLL1_ACTRL6 = 134,
	PLL1_ACTRL7 = 135,
	PLL1_ACTRL8 = 136,
	TX_REG_BANK = 112,
	TX_ACTRL0 = 128,
	TX_ACTRL0_TXPOL_FLIP = 64,
	TX_ACTRL5 = 133,
	TX_ACTRL5_SSC_EN = 2048,
	AEQRX_REG_BANK_0 = 208,
	AEQ_CONTROL1 = 129,
	AEQ_CONTROL1_ENABLE = 4,
	AEQ_CONTROL1_FREEZE = 8,
	AEQ_FRC_EQ = 131,
	AEQ_FRC_EQ_FORCE = 1,
	AEQ_FRC_EQ_FORCE_VAL = 2,
	AEQ_RFZ_FRC_VAL = 256,
	AEQRX_REG_BANK_1 = 224,
	AEQRX_SLCAL0_CTRL0 = 130,
	AEQRX_SLCAL1_CTRL0 = 134,
	OOB_REG_BANK = 336,
	OOB1_REG_BANK = 352,
	OOB_CTRL1 = 128,
	OOB_CTRL1_BURST_MAX_MASK = 15,
	OOB_CTRL1_BURST_MAX_SHIFT = 12,
	OOB_CTRL1_BURST_MIN_MASK = 15,
	OOB_CTRL1_BURST_MIN_SHIFT = 8,
	OOB_CTRL1_WAKE_IDLE_MAX_MASK = 15,
	OOB_CTRL1_WAKE_IDLE_MAX_SHIFT = 4,
	OOB_CTRL1_WAKE_IDLE_MIN_MASK = 15,
	OOB_CTRL1_WAKE_IDLE_MIN_SHIFT = 0,
	OOB_CTRL2 = 129,
	OOB_CTRL2_SEL_ENA_SHIFT = 15,
	OOB_CTRL2_SEL_ENA_RC_SHIFT = 14,
	OOB_CTRL2_RESET_IDLE_MAX_MASK = 63,
	OOB_CTRL2_RESET_IDLE_MAX_SHIFT = 8,
	OOB_CTRL2_BURST_CNT_MASK = 3,
	OOB_CTRL2_BURST_CNT_SHIFT = 6,
	OOB_CTRL2_RESET_IDLE_MIN_MASK = 63,
	OOB_CTRL2_RESET_IDLE_MIN_SHIFT = 0,
	TXPMD_REG_BANK = 416,
	TXPMD_CONTROL1 = 129,
	TXPMD_CONTROL1_TX_SSC_EN_FRC = 1,
	TXPMD_CONTROL1_TX_SSC_EN_FRC_VAL = 2,
	TXPMD_TX_FREQ_CTRL_CONTROL1 = 130,
	TXPMD_TX_FREQ_CTRL_CONTROL2 = 131,
	TXPMD_TX_FREQ_CTRL_CONTROL2_FMIN_MASK = 1023,
	TXPMD_TX_FREQ_CTRL_CONTROL3 = 132,
	TXPMD_TX_FREQ_CTRL_CONTROL3_FMAX_MASK = 1023,
	RXPMD_REG_BANK = 448,
	RXPMD_RX_CDR_CONTROL1 = 129,
	RXPMD_RX_PPM_VAL_MASK = 511,
	RXPMD_RXPMD_EN_FRC = 4096,
	RXPMD_RXPMD_EN_FRC_VAL = 8192,
	RXPMD_RX_CDR_CDR_PROP_BW = 130,
	RXPMD_G_CDR_PROP_BW_MASK = 7,
	RXPMD_G1_CDR_PROP_BW_SHIFT = 0,
	RXPMD_G2_CDR_PROP_BW_SHIFT = 3,
	RXPMD_G3_CDR_PROB_BW_SHIFT = 6,
	RXPMD_RX_CDR_CDR_ACQ_INTEG_BW = 131,
	RXPMD_G_CDR_ACQ_INT_BW_MASK = 7,
	RXPMD_G1_CDR_ACQ_INT_BW_SHIFT = 0,
	RXPMD_G2_CDR_ACQ_INT_BW_SHIFT = 3,
	RXPMD_G3_CDR_ACQ_INT_BW_SHIFT = 6,
	RXPMD_RX_CDR_CDR_LOCK_INTEG_BW = 132,
	RXPMD_G_CDR_LOCK_INT_BW_MASK = 7,
	RXPMD_G1_CDR_LOCK_INT_BW_SHIFT = 0,
	RXPMD_G2_CDR_LOCK_INT_BW_SHIFT = 3,
	RXPMD_G3_CDR_LOCK_INT_BW_SHIFT = 6,
	RXPMD_RX_FREQ_MON_CONTROL1 = 135,
	RXPMD_MON_CORRECT_EN = 256,
	RXPMD_MON_MARGIN_VAL_MASK = 255,
};

enum scale_freq_source {
	SCALE_FREQ_SOURCE_CPUFREQ = 0,
	SCALE_FREQ_SOURCE_ARCH = 1,
	SCALE_FREQ_SOURCE_CPPC = 2,
	SCALE_FREQ_SOURCE_VIRT = 3,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum scan_result {
	SCAN_FAIL = 0,
	SCAN_SUCCEED = 1,
	SCAN_PMD_NULL = 2,
	SCAN_PMD_NONE = 3,
	SCAN_PMD_MAPPED = 4,
	SCAN_EXCEED_NONE_PTE = 5,
	SCAN_EXCEED_SWAP_PTE = 6,
	SCAN_EXCEED_SHARED_PTE = 7,
	SCAN_PTE_NON_PRESENT = 8,
	SCAN_PTE_UFFD_WP = 9,
	SCAN_PTE_MAPPED_HUGEPAGE = 10,
	SCAN_PAGE_RO = 11,
	SCAN_LACK_REFERENCED_PAGE = 12,
	SCAN_PAGE_NULL = 13,
	SCAN_SCAN_ABORT = 14,
	SCAN_PAGE_COUNT = 15,
	SCAN_PAGE_LRU = 16,
	SCAN_PAGE_LOCK = 17,
	SCAN_PAGE_ANON = 18,
	SCAN_PAGE_COMPOUND = 19,
	SCAN_ANY_PROCESS = 20,
	SCAN_VMA_NULL = 21,
	SCAN_VMA_CHECK = 22,
	SCAN_ADDRESS_RANGE = 23,
	SCAN_DEL_PAGE_LRU = 24,
	SCAN_ALLOC_HUGE_PAGE_FAIL = 25,
	SCAN_CGROUP_CHARGE_FAIL = 26,
	SCAN_TRUNCATED = 27,
	SCAN_PAGE_HAS_PRIVATE = 28,
	SCAN_STORE_FAILED = 29,
	SCAN_COPY_MC = 30,
	SCAN_PAGE_FILLED = 31,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scpsys_bus_prot_flags {
	BUS_PROT_REG_UPDATE = 2,
	BUS_PROT_IGNORE_CLR_ACK = 4,
	BUS_PROT_INVERTED = 8,
	BUS_PROT_COMPONENT_INFRA = 16,
	BUS_PROT_COMPONENT_SMI = 32,
	BUS_PROT_STA_COMPONENT_INFRA_NAO = 64,
};

enum scrub_type {
	SCRUB_UNKNOWN = 0,
	SCRUB_NONE = 1,
	SCRUB_SW_PROG = 2,
	SCRUB_SW_SRC = 3,
	SCRUB_SW_PROG_SRC = 4,
	SCRUB_SW_TUNABLE = 5,
	SCRUB_HW_PROG = 6,
	SCRUB_HW_SRC = 7,
	SCRUB_HW_PROG_SRC = 8,
	SCRUB_HW_TUNABLE = 9,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 2500,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_cid {
	SCTP_CID_DATA = 0,
	SCTP_CID_INIT = 1,
	SCTP_CID_INIT_ACK = 2,
	SCTP_CID_SACK = 3,
	SCTP_CID_HEARTBEAT = 4,
	SCTP_CID_HEARTBEAT_ACK = 5,
	SCTP_CID_ABORT = 6,
	SCTP_CID_SHUTDOWN = 7,
	SCTP_CID_SHUTDOWN_ACK = 8,
	SCTP_CID_ERROR = 9,
	SCTP_CID_COOKIE_ECHO = 10,
	SCTP_CID_COOKIE_ACK = 11,
	SCTP_CID_ECN_ECNE = 12,
	SCTP_CID_ECN_CWR = 13,
	SCTP_CID_SHUTDOWN_COMPLETE = 14,
	SCTP_CID_AUTH = 15,
	SCTP_CID_I_DATA = 64,
	SCTP_CID_FWD_TSN = 192,
	SCTP_CID_ASCONF = 193,
	SCTP_CID_I_FWD_TSN = 194,
	SCTP_CID_ASCONF_ACK = 128,
	SCTP_CID_RECONF = 130,
	SCTP_CID_PAD = 132,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sctp_endpoint_type {
	SCTP_EP_TYPE_SOCKET = 0,
	SCTP_EP_TYPE_ASSOCIATION = 1,
};

enum sctp_event_timeout {
	SCTP_EVENT_TIMEOUT_NONE = 0,
	SCTP_EVENT_TIMEOUT_T1_COOKIE = 1,
	SCTP_EVENT_TIMEOUT_T1_INIT = 2,
	SCTP_EVENT_TIMEOUT_T2_SHUTDOWN = 3,
	SCTP_EVENT_TIMEOUT_T3_RTX = 4,
	SCTP_EVENT_TIMEOUT_T4_RTO = 5,
	SCTP_EVENT_TIMEOUT_T5_SHUTDOWN_GUARD = 6,
	SCTP_EVENT_TIMEOUT_HEARTBEAT = 7,
	SCTP_EVENT_TIMEOUT_RECONF = 8,
	SCTP_EVENT_TIMEOUT_PROBE = 9,
	SCTP_EVENT_TIMEOUT_SACK = 10,
	SCTP_EVENT_TIMEOUT_AUTOCLOSE = 11,
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum sctp_param {
	SCTP_PARAM_HEARTBEAT_INFO = 256,
	SCTP_PARAM_IPV4_ADDRESS = 1280,
	SCTP_PARAM_IPV6_ADDRESS = 1536,
	SCTP_PARAM_STATE_COOKIE = 1792,
	SCTP_PARAM_UNRECOGNIZED_PARAMETERS = 2048,
	SCTP_PARAM_COOKIE_PRESERVATIVE = 2304,
	SCTP_PARAM_HOST_NAME_ADDRESS = 2816,
	SCTP_PARAM_SUPPORTED_ADDRESS_TYPES = 3072,
	SCTP_PARAM_ECN_CAPABLE = 128,
	SCTP_PARAM_RANDOM = 640,
	SCTP_PARAM_CHUNKS = 896,
	SCTP_PARAM_HMAC_ALGO = 1152,
	SCTP_PARAM_SUPPORTED_EXT = 2176,
	SCTP_PARAM_FWD_TSN_SUPPORT = 192,
	SCTP_PARAM_ADD_IP = 448,
	SCTP_PARAM_DEL_IP = 704,
	SCTP_PARAM_ERR_CAUSE = 960,
	SCTP_PARAM_SET_PRIMARY = 1216,
	SCTP_PARAM_SUCCESS_REPORT = 1472,
	SCTP_PARAM_ADAPTATION_LAYER_IND = 1728,
	SCTP_PARAM_RESET_OUT_REQUEST = 3328,
	SCTP_PARAM_RESET_IN_REQUEST = 3584,
	SCTP_PARAM_RESET_TSN_REQUEST = 3840,
	SCTP_PARAM_RESET_RESPONSE = 4096,
	SCTP_PARAM_RESET_ADD_OUT_STREAMS = 4352,
	SCTP_PARAM_RESET_ADD_IN_STREAMS = 4608,
};

enum sctp_scope {
	SCTP_SCOPE_GLOBAL = 0,
	SCTP_SCOPE_PRIVATE = 1,
	SCTP_SCOPE_LINK = 2,
	SCTP_SCOPE_LOOPBACK = 3,
	SCTP_SCOPE_UNUSABLE = 4,
};

enum sctp_socket_type {
	SCTP_SOCKET_UDP = 0,
	SCTP_SOCKET_UDP_HIGH_BANDWIDTH = 1,
	SCTP_SOCKET_TCP = 2,
};

enum sctp_state {
	SCTP_STATE_CLOSED = 0,
	SCTP_STATE_COOKIE_WAIT = 1,
	SCTP_STATE_COOKIE_ECHOED = 2,
	SCTP_STATE_ESTABLISHED = 3,
	SCTP_STATE_SHUTDOWN_PENDING = 4,
	SCTP_STATE_SHUTDOWN_SENT = 5,
	SCTP_STATE_SHUTDOWN_RECEIVED = 6,
	SCTP_STATE_SHUTDOWN_ACK_SENT = 7,
};

enum scx_consts {
	SCX_DSP_DFL_MAX_BATCH = 32,
	SCX_DSP_MAX_LOOPS = 32,
	SCX_WATCHDOG_MAX_TIMEOUT = 7500,
	SCX_EXIT_BT_LEN = 64,
	SCX_EXIT_MSG_LEN = 1024,
	SCX_EXIT_DUMP_DFL_LEN = 32768,
	SCX_CPUPERF_ONE = 1024,
	SCX_OPS_TASK_ITER_BATCH = 32,
};

enum scx_cpu_preempt_reason {
	SCX_CPU_PREEMPT_RT = 0,
	SCX_CPU_PREEMPT_DL = 1,
	SCX_CPU_PREEMPT_STOP = 2,
	SCX_CPU_PREEMPT_UNKNOWN = 3,
};

enum scx_deq_flags {
	SCX_DEQ_SLEEP = 1ULL,
	SCX_DEQ_CORE_SCHED_EXEC = 4294967296ULL,
};

enum scx_dsq_id_flags {
	SCX_DSQ_FLAG_BUILTIN = 9223372036854775808ULL,
	SCX_DSQ_FLAG_LOCAL_ON = 4611686018427387904ULL,
	SCX_DSQ_INVALID = 9223372036854775808ULL,
	SCX_DSQ_GLOBAL = 9223372036854775809ULL,
	SCX_DSQ_LOCAL = 9223372036854775810ULL,
	SCX_DSQ_LOCAL_ON = 13835058055282163712ULL,
	SCX_DSQ_LOCAL_CPU_MASK = 4294967295ULL,
};

enum scx_dsq_iter_flags {
	SCX_DSQ_ITER_REV = 65536,
	__SCX_DSQ_ITER_HAS_SLICE = 1073741824,
	__SCX_DSQ_ITER_HAS_VTIME = 2147483648,
	__SCX_DSQ_ITER_USER_FLAGS = 65536,
	__SCX_DSQ_ITER_ALL_FLAGS = 3221291008,
};

enum scx_dsq_lnode_flags {
	SCX_DSQ_LNODE_ITER_CURSOR = 1,
	__SCX_DSQ_LNODE_PRIV_SHIFT = 16,
};

enum scx_enq_flags {
	SCX_ENQ_WAKEUP = 1ULL,
	SCX_ENQ_HEAD = 16ULL,
	SCX_ENQ_CPU_SELECTED = 1024ULL,
	SCX_ENQ_PREEMPT = 4294967296ULL,
	SCX_ENQ_REENQ = 1099511627776ULL,
	SCX_ENQ_LAST = 2199023255552ULL,
	__SCX_ENQ_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_ENQ_CLEAR_OPSS = 72057594037927936ULL,
	SCX_ENQ_DSQ_PRIQ = 144115188075855872ULL,
};

enum scx_ent_dsq_flags {
	SCX_TASK_DSQ_ON_PRIQ = 1,
};

enum scx_ent_flags {
	SCX_TASK_QUEUED = 1,
	SCX_TASK_RESET_RUNNABLE_AT = 4,
	SCX_TASK_DEQD_FOR_SLEEP = 8,
	SCX_TASK_STATE_SHIFT = 8,
	SCX_TASK_STATE_BITS = 2,
	SCX_TASK_STATE_MASK = 768,
	SCX_TASK_CURSOR = -2147483648,
};

enum scx_exit_code {
	SCX_ECODE_RSN_HOTPLUG = 4294967296ULL,
	SCX_ECODE_ACT_RESTART = 281474976710656ULL,
};

enum scx_exit_kind {
	SCX_EXIT_NONE = 0,
	SCX_EXIT_DONE = 1,
	SCX_EXIT_UNREG = 64,
	SCX_EXIT_UNREG_BPF = 65,
	SCX_EXIT_UNREG_KERN = 66,
	SCX_EXIT_SYSRQ = 67,
	SCX_EXIT_ERROR = 1024,
	SCX_EXIT_ERROR_BPF = 1025,
	SCX_EXIT_ERROR_STALL = 1026,
};

enum scx_kf_mask {
	SCX_KF_UNLOCKED = 0,
	SCX_KF_CPU_RELEASE = 1,
	SCX_KF_DISPATCH = 2,
	SCX_KF_ENQUEUE = 4,
	SCX_KF_SELECT_CPU = 8,
	SCX_KF_REST = 16,
	__SCX_KF_RQ_LOCKED = 31,
	__SCX_KF_TERMINAL = 28,
};

enum scx_kick_flags {
	SCX_KICK_IDLE = 1,
	SCX_KICK_PREEMPT = 2,
	SCX_KICK_WAIT = 4,
};

enum scx_opi {
	SCX_OPI_BEGIN = 0,
	SCX_OPI_NORMAL_BEGIN = 0,
	SCX_OPI_NORMAL_END = 29,
	SCX_OPI_CPU_HOTPLUG_BEGIN = 29,
	SCX_OPI_CPU_HOTPLUG_END = 31,
	SCX_OPI_END = 31,
};

enum scx_ops_enable_state {
	SCX_OPS_ENABLING = 0,
	SCX_OPS_ENABLED = 1,
	SCX_OPS_DISABLING = 2,
	SCX_OPS_DISABLED = 3,
};

enum scx_ops_flags {
	SCX_OPS_KEEP_BUILTIN_IDLE = 1,
	SCX_OPS_ENQ_LAST = 2,
	SCX_OPS_ENQ_EXITING = 4,
	SCX_OPS_SWITCH_PARTIAL = 8,
	SCX_OPS_HAS_CGROUP_WEIGHT = 65536,
	SCX_OPS_ALL_FLAGS = 65551,
};

enum scx_ops_state {
	SCX_OPSS_NONE = 0,
	SCX_OPSS_QUEUEING = 1,
	SCX_OPSS_QUEUED = 2,
	SCX_OPSS_DISPATCHING = 3,
	SCX_OPSS_QSEQ_SHIFT = 2,
};

enum scx_pick_idle_cpu_flags {
	SCX_PICK_IDLE_CORE = 1,
};

enum scx_public_consts {
	SCX_OPS_NAME_LEN = 128ULL,
	SCX_SLICE_DFL = 20000000ULL,
	SCX_SLICE_INF = 18446744073709551615ULL,
};

enum scx_rq_flags {
	SCX_RQ_ONLINE = 1,
	SCX_RQ_CAN_STOP_TICK = 2,
	SCX_RQ_BAL_PENDING = 4,
	SCX_RQ_BAL_KEEP = 8,
	SCX_RQ_BYPASSING = 16,
	SCX_RQ_IN_WAKEUP = 65536,
	SCX_RQ_IN_BALANCE = 131072,
};

enum scx_task_state {
	SCX_TASK_NONE = 0,
	SCX_TASK_INIT = 1,
	SCX_TASK_READY = 2,
	SCX_TASK_ENABLED = 3,
	SCX_TASK_NR_STATES = 4,
};

enum scx_tg_flags {
	SCX_TG_ONLINE = 1,
	SCX_TG_INITED = 2,
};

enum scx_wake_flags {
	SCX_WAKE_FORK = 4,
	SCX_WAKE_TTWU = 8,
	SCX_WAKE_SYNC = 16,
};

enum sd_uhs2_operation {
	UHS2_PHY_INIT = 0,
	UHS2_SET_CONFIG = 1,
	UHS2_ENABLE_INT = 2,
	UHS2_DISABLE_INT = 3,
	UHS2_ENABLE_CLK = 4,
	UHS2_DISABLE_CLK = 5,
	UHS2_CHECK_DORMANT = 6,
	UHS2_SET_IOS = 7,
};

enum sec_device_type {
	S5M8767X = 0,
	S2DOS05 = 1,
	S2MPA01 = 2,
	S2MPS11X = 3,
	S2MPS13X = 4,
	S2MPS14X = 5,
	S2MPS15X = 6,
	S2MPU02 = 7,
};

enum security_cmd_enabled_bits {
	CXL_SEC_ENABLED_SANITIZE = 0,
	CXL_SEC_ENABLED_SECURE_ERASE = 1,
	CXL_SEC_ENABLED_GET_SECURITY_STATE = 2,
	CXL_SEC_ENABLED_SET_PASSPHRASE = 3,
	CXL_SEC_ENABLED_DISABLE_PASSPHRASE = 4,
	CXL_SEC_ENABLED_UNLOCK = 5,
	CXL_SEC_ENABLED_FREEZE_SECURITY = 6,
	CXL_SEC_ENABLED_PASSPHRASE_SECURE_ERASE = 7,
	CXL_SEC_ENABLED_MAX = 8,
};

enum seg6_end_dt_mode {
	DT_INVALID_MODE = -22,
	DT_LEGACY_MODE = 0,
	DT_VRF_MODE = 1,
};

enum seg6_local_flv_action {
	SEG6_LOCAL_FLV_ACT_UNSPEC = 0,
	SEG6_LOCAL_FLV_ACT_END = 1,
	SEG6_LOCAL_FLV_ACT_PSP = 2,
	SEG6_LOCAL_FLV_ACT_USP = 3,
	SEG6_LOCAL_FLV_ACT_USD = 4,
	__SEG6_LOCAL_FLV_ACT_MAX = 5,
};

enum seg6_local_pktinfo {
	SEG6_LOCAL_PKTINFO_NOHDR = 0,
	SEG6_LOCAL_PKTINFO_SL_ZERO = 1,
	SEG6_LOCAL_PKTINFO_SL_ONE = 2,
	SEG6_LOCAL_PKTINFO_SL_MORE = 3,
	__SEG6_LOCAL_PKTINFO_MAX = 4,
};

enum sel_inos {
	SEL_ROOT_INO = 2,
	SEL_LOAD = 3,
	SEL_ENFORCE = 4,
	SEL_CONTEXT = 5,
	SEL_ACCESS = 6,
	SEL_CREATE = 7,
	SEL_RELABEL = 8,
	SEL_USER = 9,
	SEL_POLICYVERS = 10,
	SEL_COMMIT_BOOLS = 11,
	SEL_MLS = 12,
	SEL_DISABLE = 13,
	SEL_MEMBER = 14,
	SEL_CHECKREQPROT = 15,
	SEL_COMPAT_NET = 16,
	SEL_REJECT_UNKNOWN = 17,
	SEL_DENY_UNKNOWN = 18,
	SEL_STATUS = 19,
	SEL_POLICY = 20,
	SEL_VALIDATE_TRANS = 21,
	SEL_INO_NEXT = 22,
};

enum selinux_nlgroups {
	SELNLGRP_NONE = 0,
	SELNLGRP_AVC = 1,
	__SELNLGRP_MAX = 2,
};

enum sensor_hub_read_flags {
	SENSOR_HUB_SYNC = 0,
	SENSOR_HUB_ASYNC = 1,
};

enum serdev_parity {
	SERDEV_PARITY_NONE = 0,
	SERDEV_PARITY_EVEN = 1,
	SERDEV_PARITY_ODD = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum shmem_param {
	Opt_gid___8 = 0,
	Opt_huge = 1,
	Opt_mode___6 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes___2 = 5,
	Opt_size___2 = 6,
	Opt_uid___7 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota___2 = 11,
	Opt_usrquota___2 = 12,
	Opt_grpquota___2 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
	Opt_casefold_version = 18,
	Opt_casefold = 19,
	Opt_strict_encoding = 20,
};

enum si_type {
	SI_TYPE_INVALID = 0,
	SI_KCS = 1,
	SI_SMIC = 2,
	SI_BT = 3,
	SI_TYPE_MAX = 4,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_PKT_TOO_SMALL = 4,
	SKB_DROP_REASON_TCP_CSUM = 5,
	SKB_DROP_REASON_SOCKET_FILTER = 6,
	SKB_DROP_REASON_UDP_CSUM = 7,
	SKB_DROP_REASON_NETFILTER_DROP = 8,
	SKB_DROP_REASON_OTHERHOST = 9,
	SKB_DROP_REASON_IP_CSUM = 10,
	SKB_DROP_REASON_IP_INHDR = 11,
	SKB_DROP_REASON_IP_RPFILTER = 12,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 13,
	SKB_DROP_REASON_XFRM_POLICY = 14,
	SKB_DROP_REASON_IP_NOPROTO = 15,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 16,
	SKB_DROP_REASON_PROTO_MEM = 17,
	SKB_DROP_REASON_TCP_AUTH_HDR = 18,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 19,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 20,
	SKB_DROP_REASON_TCP_MD5FAILURE = 21,
	SKB_DROP_REASON_TCP_AONOTFOUND = 22,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 23,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 24,
	SKB_DROP_REASON_TCP_AOFAILURE = 25,
	SKB_DROP_REASON_SOCKET_BACKLOG = 26,
	SKB_DROP_REASON_TCP_FLAGS = 27,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 28,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 29,
	SKB_DROP_REASON_TCP_OLD_DATA = 30,
	SKB_DROP_REASON_TCP_OVERWINDOW = 31,
	SKB_DROP_REASON_TCP_OFOMERGE = 32,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 33,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 34,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 35,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 36,
	SKB_DROP_REASON_TCP_RESET = 37,
	SKB_DROP_REASON_TCP_INVALID_SYN = 38,
	SKB_DROP_REASON_TCP_CLOSE = 39,
	SKB_DROP_REASON_TCP_FASTOPEN = 40,
	SKB_DROP_REASON_TCP_OLD_ACK = 41,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 42,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 43,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 44,
	SKB_DROP_REASON_TCP_OFO_DROP = 45,
	SKB_DROP_REASON_IP_OUTNOROUTES = 46,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 47,
	SKB_DROP_REASON_IPV6DISABLED = 48,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 49,
	SKB_DROP_REASON_NEIGH_FAILED = 50,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 51,
	SKB_DROP_REASON_NEIGH_DEAD = 52,
	SKB_DROP_REASON_TC_EGRESS = 53,
	SKB_DROP_REASON_SECURITY_HOOK = 54,
	SKB_DROP_REASON_QDISC_DROP = 55,
	SKB_DROP_REASON_CPU_BACKLOG = 56,
	SKB_DROP_REASON_XDP = 57,
	SKB_DROP_REASON_TC_INGRESS = 58,
	SKB_DROP_REASON_UNHANDLED_PROTO = 59,
	SKB_DROP_REASON_SKB_CSUM = 60,
	SKB_DROP_REASON_SKB_GSO_SEG = 61,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 62,
	SKB_DROP_REASON_DEV_HDR = 63,
	SKB_DROP_REASON_DEV_READY = 64,
	SKB_DROP_REASON_FULL_RING = 65,
	SKB_DROP_REASON_NOMEM = 66,
	SKB_DROP_REASON_HDR_TRUNC = 67,
	SKB_DROP_REASON_TAP_FILTER = 68,
	SKB_DROP_REASON_TAP_TXFILTER = 69,
	SKB_DROP_REASON_ICMP_CSUM = 70,
	SKB_DROP_REASON_INVALID_PROTO = 71,
	SKB_DROP_REASON_IP_INADDRERRORS = 72,
	SKB_DROP_REASON_IP_INNOROUTES = 73,
	SKB_DROP_REASON_IP_LOCAL_SOURCE = 74,
	SKB_DROP_REASON_IP_INVALID_SOURCE = 75,
	SKB_DROP_REASON_IP_LOCALNET = 76,
	SKB_DROP_REASON_IP_INVALID_DEST = 77,
	SKB_DROP_REASON_PKT_TOO_BIG = 78,
	SKB_DROP_REASON_DUP_FRAG = 79,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 80,
	SKB_DROP_REASON_FRAG_TOO_FAR = 81,
	SKB_DROP_REASON_TCP_MINTTL = 82,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 83,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 84,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 85,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 86,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 87,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 88,
	SKB_DROP_REASON_QUEUE_PURGE = 89,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 90,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 91,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 92,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 93,
	SKB_DROP_REASON_VXLAN_INVALID_HDR = 94,
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND = 95,
	SKB_DROP_REASON_MAC_INVALID_SOURCE = 96,
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS = 97,
	SKB_DROP_REASON_VXLAN_NO_REMOTE = 98,
	SKB_DROP_REASON_IP_TUNNEL_ECN = 99,
	SKB_DROP_REASON_TUNNEL_TXINFO = 100,
	SKB_DROP_REASON_LOCAL_MAC = 101,
	SKB_DROP_REASON_ARP_PVLAN_DISABLE = 102,
	SKB_DROP_REASON_MAX = 103,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_MAC80211_MONITOR = 2,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 3,
	SKB_DROP_REASON_SUBSYS_NUM = 4,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_SEC_PATH = 1,
	TC_SKB_EXT = 2,
	SKB_EXT_MPTCP = 3,
	SKB_EXT_NUM = 4,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN___2 = 0,
	PARTIAL = 1,
	UP___2 = 2,
	FULL = 3,
};

enum smbios_attr_enum {
	SMBIOS_ATTR_NONE = 0,
	SMBIOS_ATTR_LABEL_SHOW = 1,
	SMBIOS_ATTR_INSTANCE_SHOW = 2,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE = 1,
};

enum soc_type {
	SOC_ARCH_EXYNOS3250 = 1,
	SOC_ARCH_EXYNOS4210 = 2,
	SOC_ARCH_EXYNOS4412 = 3,
	SOC_ARCH_EXYNOS5250 = 4,
	SOC_ARCH_EXYNOS5260 = 5,
	SOC_ARCH_EXYNOS5420 = 6,
	SOC_ARCH_EXYNOS5420_TRIMINFO = 7,
	SOC_ARCH_EXYNOS5433 = 8,
	SOC_ARCH_EXYNOS7 = 9,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_cast_to_kern_ctx = 7,
	KF_bpf_rdonly_cast = 8,
	KF_bpf_rcu_read_lock = 9,
	KF_bpf_rcu_read_unlock = 10,
	KF_bpf_rbtree_remove = 11,
	KF_bpf_rbtree_add_impl = 12,
	KF_bpf_rbtree_first = 13,
	KF_bpf_dynptr_from_skb = 14,
	KF_bpf_dynptr_from_xdp = 15,
	KF_bpf_dynptr_slice = 16,
	KF_bpf_dynptr_slice_rdwr = 17,
	KF_bpf_dynptr_clone = 18,
	KF_bpf_percpu_obj_new_impl = 19,
	KF_bpf_percpu_obj_drop_impl = 20,
	KF_bpf_throw = 21,
	KF_bpf_wq_set_callback_impl = 22,
	KF_bpf_preempt_disable = 23,
	KF_bpf_preempt_enable = 24,
	KF_bpf_iter_css_task_new = 25,
	KF_bpf_session_cookie = 26,
	KF_bpf_get_kmem_cache = 27,
	KF_bpf_local_irq_save = 28,
	KF_bpf_local_irq_restore = 29,
	KF_bpf_iter_num_new = 30,
	KF_bpf_iter_num_next = 31,
	KF_bpf_iter_num_destroy = 32,
};

enum spectre_v4_policy {
	SPECTRE_V4_POLICY_MITIGATION_DYNAMIC = 0,
	SPECTRE_V4_POLICY_MITIGATION_ENABLED = 1,
	SPECTRE_V4_POLICY_MITIGATION_DISABLED = 2,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum stop_on_failure {
	BCH_CACHED_DEV_STOP_AUTO = 0,
	BCH_CACHED_DEV_STOP_ALWAYS = 1,
	BCH_CACHED_DEV_STOP_MODE_MAX = 2,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum sunxi_desc_bias_voltage {
	BIAS_VOLTAGE_NONE = 0,
	BIAS_VOLTAGE_GRP_CONFIG = 1,
	BIAS_VOLTAGE_PIO_POW_MODE_SEL = 2,
	BIAS_VOLTAGE_PIO_POW_MODE_CTL = 3,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum suspend_mode {
	PRESUSPEND = 0,
	PRESUSPEND_UNDO = 1,
	POSTSUSPEND = 2,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_SYSERR = 2,
	SVC_VALID = 3,
	SVC_NEGATIVE = 4,
	SVC_OK = 5,
	SVC_DROP = 6,
	SVC_CLOSE = 7,
	SVC_DENIED = 8,
	SVC_PENDING = 9,
	SVC_COMPLETE = 10,
};

enum sw_activity {
	OFF = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum switchdev_obj_id {
	SWITCHDEV_OBJ_ID_UNDEFINED = 0,
	SWITCHDEV_OBJ_ID_PORT_VLAN = 1,
	SWITCHDEV_OBJ_ID_PORT_MDB = 2,
	SWITCHDEV_OBJ_ID_HOST_MDB = 3,
	SWITCHDEV_OBJ_ID_MRP = 4,
	SWITCHDEV_OBJ_ID_RING_TEST_MRP = 5,
	SWITCHDEV_OBJ_ID_RING_ROLE_MRP = 6,
	SWITCHDEV_OBJ_ID_RING_STATE_MRP = 7,
	SWITCHDEV_OBJ_ID_IN_TEST_MRP = 8,
	SWITCHDEV_OBJ_ID_IN_ROLE_MRP = 9,
	SWITCHDEV_OBJ_ID_IN_STATE_MRP = 10,
};

enum synaptics_pkt_type {
	SYN_NEWABS = 0,
	SYN_NEWABS_STRICT = 1,
	SYN_NEWABS_RELAXED = 2,
	SYN_OLDABS = 3,
};

enum sync_action {
	ACTION_RESYNC = 0,
	ACTION_RECOVER = 1,
	ACTION_CHECK = 2,
	ACTION_REPAIR = 3,
	ACTION_RESHAPE = 4,
	ACTION_FROZEN = 5,
	ACTION_IDLE = 6,
	NR_SYNC_ACTIONS = 7,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum sys_powerdown {
	SYS_AFTR = 0,
	SYS_LPA = 1,
	SYS_SLEEP = 2,
	NUM_SYS_POWERDOWN = 3,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum tap_delay_type {
	PM_TAPDELAY_INPUT = 0,
	PM_TAPDELAY_OUTPUT = 1,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
	TWA_FLAGS = 65280,
	TWAF_NO_ALLOC = 256,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_matchall_command {
	TC_CLSMATCHALL_REPLACE = 0,
	TC_CLSMATCHALL_DESTROY = 1,
	TC_CLSMATCHALL_STATS = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcpa_pc_event_ids {
	SMBIOS = 1,
	BIS_CERT = 2,
	POST_BIOS_ROM = 3,
	ESCD = 4,
	CMOS = 5,
	NVRAM = 6,
	OPTION_ROM_EXEC = 7,
	OPTION_ROM_CONFIG = 8,
	OPTION_ROM_MICROCODE = 10,
	S_CRTM_VERSION = 11,
	S_CRTM_CONTENTS = 12,
	POST_CONTENTS = 13,
	HOST_TABLE_OF_DEVICES = 14,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tegra124_function {
	TEGRA124_FUNC_SNPS = 0,
	TEGRA124_FUNC_XUSB = 1,
	TEGRA124_FUNC_UART = 2,
	TEGRA124_FUNC_PCIE = 3,
	TEGRA124_FUNC_USB3 = 4,
	TEGRA124_FUNC_SATA = 5,
	TEGRA124_FUNC_RSVD = 6,
};

enum tegra_dfll_pmu_if {
	TEGRA_DFLL_PMU_I2C = 0,
	TEGRA_DFLL_PMU_PWM = 1,
};

enum tegra_icc_client_type {
	TEGRA_ICC_NONE = 0,
	TEGRA_ICC_NISO = 1,
	TEGRA_ICC_ISO_DISPLAY = 2,
	TEGRA_ICC_ISO_VI = 3,
	TEGRA_ICC_ISO_AUDIO = 4,
	TEGRA_ICC_ISO_VIFAL = 5,
};

enum tegra_io_pad {
	TEGRA_IO_PAD_AUDIO = 0,
	TEGRA_IO_PAD_AUDIO_HV = 1,
	TEGRA_IO_PAD_BB = 2,
	TEGRA_IO_PAD_CAM = 3,
	TEGRA_IO_PAD_COMP = 4,
	TEGRA_IO_PAD_CONN = 5,
	TEGRA_IO_PAD_CSIA = 6,
	TEGRA_IO_PAD_CSIB = 7,
	TEGRA_IO_PAD_CSIC = 8,
	TEGRA_IO_PAD_CSID = 9,
	TEGRA_IO_PAD_CSIE = 10,
	TEGRA_IO_PAD_CSIF = 11,
	TEGRA_IO_PAD_CSIG = 12,
	TEGRA_IO_PAD_CSIH = 13,
	TEGRA_IO_PAD_DAP3 = 14,
	TEGRA_IO_PAD_DAP5 = 15,
	TEGRA_IO_PAD_DBG = 16,
	TEGRA_IO_PAD_DEBUG_NONAO = 17,
	TEGRA_IO_PAD_DMIC = 18,
	TEGRA_IO_PAD_DMIC_HV = 19,
	TEGRA_IO_PAD_DP = 20,
	TEGRA_IO_PAD_DSI = 21,
	TEGRA_IO_PAD_DSIB = 22,
	TEGRA_IO_PAD_DSIC = 23,
	TEGRA_IO_PAD_DSID = 24,
	TEGRA_IO_PAD_EDP = 25,
	TEGRA_IO_PAD_EMMC = 26,
	TEGRA_IO_PAD_EMMC2 = 27,
	TEGRA_IO_PAD_EQOS = 28,
	TEGRA_IO_PAD_GPIO = 29,
	TEGRA_IO_PAD_GP_PWM2 = 30,
	TEGRA_IO_PAD_GP_PWM3 = 31,
	TEGRA_IO_PAD_HDMI = 32,
	TEGRA_IO_PAD_HDMI_DP0 = 33,
	TEGRA_IO_PAD_HDMI_DP1 = 34,
	TEGRA_IO_PAD_HDMI_DP2 = 35,
	TEGRA_IO_PAD_HDMI_DP3 = 36,
	TEGRA_IO_PAD_HSIC = 37,
	TEGRA_IO_PAD_HV = 38,
	TEGRA_IO_PAD_LVDS = 39,
	TEGRA_IO_PAD_MIPI_BIAS = 40,
	TEGRA_IO_PAD_NAND = 41,
	TEGRA_IO_PAD_PEX_BIAS = 42,
	TEGRA_IO_PAD_PEX_CLK_BIAS = 43,
	TEGRA_IO_PAD_PEX_CLK1 = 44,
	TEGRA_IO_PAD_PEX_CLK2 = 45,
	TEGRA_IO_PAD_PEX_CLK3 = 46,
	TEGRA_IO_PAD_PEX_CLK_2_BIAS = 47,
	TEGRA_IO_PAD_PEX_CLK_2 = 48,
	TEGRA_IO_PAD_PEX_CNTRL = 49,
	TEGRA_IO_PAD_PEX_CTL2 = 50,
	TEGRA_IO_PAD_PEX_L0_RST = 51,
	TEGRA_IO_PAD_PEX_L1_RST = 52,
	TEGRA_IO_PAD_PEX_L5_RST = 53,
	TEGRA_IO_PAD_PWR_CTL = 54,
	TEGRA_IO_PAD_SDMMC1 = 55,
	TEGRA_IO_PAD_SDMMC1_HV = 56,
	TEGRA_IO_PAD_SDMMC2 = 57,
	TEGRA_IO_PAD_SDMMC2_HV = 58,
	TEGRA_IO_PAD_SDMMC3 = 59,
	TEGRA_IO_PAD_SDMMC3_HV = 60,
	TEGRA_IO_PAD_SDMMC4 = 61,
	TEGRA_IO_PAD_SOC_GPIO10 = 62,
	TEGRA_IO_PAD_SOC_GPIO12 = 63,
	TEGRA_IO_PAD_SOC_GPIO13 = 64,
	TEGRA_IO_PAD_SOC_GPIO53 = 65,
	TEGRA_IO_PAD_SPI = 66,
	TEGRA_IO_PAD_SPI_HV = 67,
	TEGRA_IO_PAD_SYS_DDC = 68,
	TEGRA_IO_PAD_UART = 69,
	TEGRA_IO_PAD_UART4 = 70,
	TEGRA_IO_PAD_UART5 = 71,
	TEGRA_IO_PAD_UFS = 72,
	TEGRA_IO_PAD_USB0 = 73,
	TEGRA_IO_PAD_USB1 = 74,
	TEGRA_IO_PAD_USB2 = 75,
	TEGRA_IO_PAD_USB3 = 76,
	TEGRA_IO_PAD_USB_BIAS = 77,
	TEGRA_IO_PAD_AO_HV = 78,
};

enum tegra_ivc_state {
	TEGRA_IVC_STATE_ESTABLISHED = 0,
	TEGRA_IVC_STATE_SYNC = 1,
	TEGRA_IVC_STATE_ACK = 2,
};

enum tegra_mux {
	TEGRA_MUX_AUD = 0,
	TEGRA_MUX_BCL = 1,
	TEGRA_MUX_BLINK = 2,
	TEGRA_MUX_CCLA = 3,
	TEGRA_MUX_CEC = 4,
	TEGRA_MUX_CLDVFS = 5,
	TEGRA_MUX_CLK = 6,
	TEGRA_MUX_CORE = 7,
	TEGRA_MUX_CPU = 8,
	TEGRA_MUX_DISPLAYA = 9,
	TEGRA_MUX_DISPLAYB = 10,
	TEGRA_MUX_DMIC1 = 11,
	TEGRA_MUX_DMIC2 = 12,
	TEGRA_MUX_DMIC3 = 13,
	TEGRA_MUX_DP = 14,
	TEGRA_MUX_DTV = 15,
	TEGRA_MUX_EXTPERIPH3 = 16,
	TEGRA_MUX_I2C1 = 17,
	TEGRA_MUX_I2C2 = 18,
	TEGRA_MUX_I2C3 = 19,
	TEGRA_MUX_I2CPMU = 20,
	TEGRA_MUX_I2CVI = 21,
	TEGRA_MUX_I2S1 = 22,
	TEGRA_MUX_I2S2 = 23,
	TEGRA_MUX_I2S3 = 24,
	TEGRA_MUX_I2S4A = 25,
	TEGRA_MUX_I2S4B = 26,
	TEGRA_MUX_I2S5A = 27,
	TEGRA_MUX_I2S5B = 28,
	TEGRA_MUX_IQC0 = 29,
	TEGRA_MUX_IQC1 = 30,
	TEGRA_MUX_JTAG = 31,
	TEGRA_MUX_PE = 32,
	TEGRA_MUX_PE0 = 33,
	TEGRA_MUX_PE1 = 34,
	TEGRA_MUX_PMI = 35,
	TEGRA_MUX_PWM0 = 36,
	TEGRA_MUX_PWM1 = 37,
	TEGRA_MUX_PWM2 = 38,
	TEGRA_MUX_PWM3 = 39,
	TEGRA_MUX_QSPI = 40,
	TEGRA_MUX_RSVD0 = 41,
	TEGRA_MUX_RSVD1 = 42,
	TEGRA_MUX_RSVD2 = 43,
	TEGRA_MUX_RSVD3 = 44,
	TEGRA_MUX_SATA = 45,
	TEGRA_MUX_SDMMC1 = 46,
	TEGRA_MUX_SDMMC3 = 47,
	TEGRA_MUX_SHUTDOWN = 48,
	TEGRA_MUX_SOC = 49,
	TEGRA_MUX_SOR0 = 50,
	TEGRA_MUX_SOR1 = 51,
	TEGRA_MUX_SPDIF = 52,
	TEGRA_MUX_SPI1 = 53,
	TEGRA_MUX_SPI2 = 54,
	TEGRA_MUX_SPI3 = 55,
	TEGRA_MUX_SPI4 = 56,
	TEGRA_MUX_SYS = 57,
	TEGRA_MUX_TOUCH = 58,
	TEGRA_MUX_UART = 59,
	TEGRA_MUX_UARTA = 60,
	TEGRA_MUX_UARTB = 61,
	TEGRA_MUX_UARTC = 62,
	TEGRA_MUX_UARTD = 63,
	TEGRA_MUX_USB = 64,
	TEGRA_MUX_VGP1 = 65,
	TEGRA_MUX_VGP2 = 66,
	TEGRA_MUX_VGP3 = 67,
	TEGRA_MUX_VGP4 = 68,
	TEGRA_MUX_VGP5 = 69,
	TEGRA_MUX_VGP6 = 70,
	TEGRA_MUX_VIMCLK = 71,
	TEGRA_MUX_VIMCLK2 = 72,
};

enum tegra_mux___2 {
	TEGRA_MUX_BLINK___2 = 0,
	TEGRA_MUX_CCLA___2 = 1,
	TEGRA_MUX_CEC___2 = 2,
	TEGRA_MUX_CLDVFS___2 = 3,
	TEGRA_MUX_CLK___2 = 4,
	TEGRA_MUX_CLK12 = 5,
	TEGRA_MUX_CPU___2 = 6,
	TEGRA_MUX_CSI = 7,
	TEGRA_MUX_DAP = 8,
	TEGRA_MUX_DAP1 = 9,
	TEGRA_MUX_DAP2 = 10,
	TEGRA_MUX_DEV3 = 11,
	TEGRA_MUX_DISPLAYA___2 = 12,
	TEGRA_MUX_DISPLAYA_ALT = 13,
	TEGRA_MUX_DISPLAYB___2 = 14,
	TEGRA_MUX_DP___2 = 15,
	TEGRA_MUX_DSI_B = 16,
	TEGRA_MUX_DTV___2 = 17,
	TEGRA_MUX_EXTPERIPH1 = 18,
	TEGRA_MUX_EXTPERIPH2 = 19,
	TEGRA_MUX_EXTPERIPH3___2 = 20,
	TEGRA_MUX_GMI = 21,
	TEGRA_MUX_GMI_ALT = 22,
	TEGRA_MUX_HDA = 23,
	TEGRA_MUX_HSI = 24,
	TEGRA_MUX_I2C1___2 = 25,
	TEGRA_MUX_I2C2___2 = 26,
	TEGRA_MUX_I2C3___2 = 27,
	TEGRA_MUX_I2C4 = 28,
	TEGRA_MUX_I2CPWR = 29,
	TEGRA_MUX_I2S0 = 30,
	TEGRA_MUX_I2S1___2 = 31,
	TEGRA_MUX_I2S2___2 = 32,
	TEGRA_MUX_I2S3___2 = 33,
	TEGRA_MUX_I2S4 = 34,
	TEGRA_MUX_IRDA = 35,
	TEGRA_MUX_KBC = 36,
	TEGRA_MUX_OWR = 37,
	TEGRA_MUX_PE___2 = 38,
	TEGRA_MUX_PE0___2 = 39,
	TEGRA_MUX_PE1___2 = 40,
	TEGRA_MUX_PMI___2 = 41,
	TEGRA_MUX_PWM0___2 = 42,
	TEGRA_MUX_PWM1___2 = 43,
	TEGRA_MUX_PWM2___2 = 44,
	TEGRA_MUX_PWM3___2 = 45,
	TEGRA_MUX_PWRON = 46,
	TEGRA_MUX_RESET_OUT_N = 47,
	TEGRA_MUX_RSVD1___2 = 48,
	TEGRA_MUX_RSVD2___2 = 49,
	TEGRA_MUX_RSVD3___2 = 50,
	TEGRA_MUX_RSVD4 = 51,
	TEGRA_MUX_RTCK = 52,
	TEGRA_MUX_SATA___2 = 53,
	TEGRA_MUX_SDMMC1___2 = 54,
	TEGRA_MUX_SDMMC2 = 55,
	TEGRA_MUX_SDMMC3___2 = 56,
	TEGRA_MUX_SDMMC4 = 57,
	TEGRA_MUX_SOC___2 = 58,
	TEGRA_MUX_SPDIF___2 = 59,
	TEGRA_MUX_SPI1___2 = 60,
	TEGRA_MUX_SPI2___2 = 61,
	TEGRA_MUX_SPI3___2 = 62,
	TEGRA_MUX_SPI4___2 = 63,
	TEGRA_MUX_SPI5 = 64,
	TEGRA_MUX_SPI6 = 65,
	TEGRA_MUX_SYS___2 = 66,
	TEGRA_MUX_TMDS = 67,
	TEGRA_MUX_TRACE = 68,
	TEGRA_MUX_UARTA___2 = 69,
	TEGRA_MUX_UARTB___2 = 70,
	TEGRA_MUX_UARTC___2 = 71,
	TEGRA_MUX_UARTD___2 = 72,
	TEGRA_MUX_ULPI = 73,
	TEGRA_MUX_USB___2 = 74,
	TEGRA_MUX_VGP1___2 = 75,
	TEGRA_MUX_VGP2___2 = 76,
	TEGRA_MUX_VGP3___2 = 77,
	TEGRA_MUX_VGP4___2 = 78,
	TEGRA_MUX_VGP5___2 = 79,
	TEGRA_MUX_VGP6___2 = 80,
	TEGRA_MUX_VI = 81,
	TEGRA_MUX_VI_ALT1 = 82,
	TEGRA_MUX_VI_ALT3 = 83,
	TEGRA_MUX_VIMCLK2___2 = 84,
	TEGRA_MUX_VIMCLK2_ALT = 85,
};

enum tegra_pinconf_param {
	TEGRA_PINCONF_PARAM_PULL = 0,
	TEGRA_PINCONF_PARAM_TRISTATE = 1,
	TEGRA_PINCONF_PARAM_ENABLE_INPUT = 2,
	TEGRA_PINCONF_PARAM_OPEN_DRAIN = 3,
	TEGRA_PINCONF_PARAM_LOCK = 4,
	TEGRA_PINCONF_PARAM_IORESET = 5,
	TEGRA_PINCONF_PARAM_RCV_SEL = 6,
	TEGRA_PINCONF_PARAM_HIGH_SPEED_MODE = 7,
	TEGRA_PINCONF_PARAM_SCHMITT = 8,
	TEGRA_PINCONF_PARAM_LOW_POWER_MODE = 9,
	TEGRA_PINCONF_PARAM_DRIVE_DOWN_STRENGTH = 10,
	TEGRA_PINCONF_PARAM_DRIVE_UP_STRENGTH = 11,
	TEGRA_PINCONF_PARAM_SLEW_RATE_FALLING = 12,
	TEGRA_PINCONF_PARAM_SLEW_RATE_RISING = 13,
	TEGRA_PINCONF_PARAM_DRIVE_TYPE = 14,
};

enum tegra_platform {
	TEGRA_PLATFORM_SILICON = 0,
	TEGRA_PLATFORM_QT = 1,
	TEGRA_PLATFORM_SYSTEM_FPGA = 2,
	TEGRA_PLATFORM_UNIT_FPGA = 3,
	TEGRA_PLATFORM_ASIM_QT = 4,
	TEGRA_PLATFORM_ASIM_LINSIM = 5,
	TEGRA_PLATFORM_DSIM_ASIM_LINSIM = 6,
	TEGRA_PLATFORM_VERIFICATION_SIMULATION = 7,
	TEGRA_PLATFORM_VDK = 8,
	TEGRA_PLATFORM_VSP = 9,
	TEGRA_PLATFORM_MAX = 10,
};

enum tegra_revision {
	TEGRA_REVISION_UNKNOWN = 0,
	TEGRA_REVISION_A01 = 1,
	TEGRA_REVISION_A02 = 2,
	TEGRA_REVISION_A03 = 3,
	TEGRA_REVISION_A03p = 4,
	TEGRA_REVISION_A04 = 5,
	TEGRA_REVISION_MAX = 6,
};

enum tegra_super_gen {
	gen4 = 4,
	gen5 = 5,
};

enum tegra_suspend_mode {
	TEGRA_SUSPEND_NONE = 0,
	TEGRA_SUSPEND_LP2 = 1,
	TEGRA_SUSPEND_LP1 = 2,
	TEGRA_SUSPEND_LP0 = 3,
	TEGRA_MAX_SUSPEND_MODE = 4,
	TEGRA_SUSPEND_NOT_READY = 5,
};

enum tegra_xusb_padctl_param {
	TEGRA_XUSB_PADCTL_IDDQ = 0,
};

enum tg_state_flags {
	THROTL_TG_PENDING = 1,
	THROTL_TG_WAS_EMPTY = 2,
	THROTL_TG_CANCELING = 4,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_genl_attr {
	THERMAL_GENL_ATTR_UNSPEC = 0,
	THERMAL_GENL_ATTR_TZ = 1,
	THERMAL_GENL_ATTR_TZ_ID = 2,
	THERMAL_GENL_ATTR_TZ_TEMP = 3,
	THERMAL_GENL_ATTR_TZ_PREV_TEMP = 4,
	THERMAL_GENL_ATTR_TZ_TRIP = 5,
	THERMAL_GENL_ATTR_TZ_TRIP_ID = 6,
	THERMAL_GENL_ATTR_TZ_TRIP_TYPE = 7,
	THERMAL_GENL_ATTR_TZ_TRIP_TEMP = 8,
	THERMAL_GENL_ATTR_TZ_TRIP_HYST = 9,
	THERMAL_GENL_ATTR_TZ_MODE = 10,
	THERMAL_GENL_ATTR_TZ_NAME = 11,
	THERMAL_GENL_ATTR_TZ_CDEV_WEIGHT = 12,
	THERMAL_GENL_ATTR_TZ_GOV = 13,
	THERMAL_GENL_ATTR_TZ_GOV_NAME = 14,
	THERMAL_GENL_ATTR_CDEV = 15,
	THERMAL_GENL_ATTR_CDEV_ID = 16,
	THERMAL_GENL_ATTR_CDEV_CUR_STATE = 17,
	THERMAL_GENL_ATTR_CDEV_MAX_STATE = 18,
	THERMAL_GENL_ATTR_CDEV_NAME = 19,
	THERMAL_GENL_ATTR_GOV_NAME = 20,
	THERMAL_GENL_ATTR_CPU_CAPABILITY = 21,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_ID = 22,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_PERFORMANCE = 23,
	THERMAL_GENL_ATTR_CPU_CAPABILITY_EFFICIENCY = 24,
	THERMAL_GENL_ATTR_THRESHOLD = 25,
	THERMAL_GENL_ATTR_THRESHOLD_TEMP = 26,
	THERMAL_GENL_ATTR_THRESHOLD_DIRECTION = 27,
	__THERMAL_GENL_ATTR_MAX = 28,
};

enum thermal_genl_cmd {
	THERMAL_GENL_CMD_UNSPEC = 0,
	THERMAL_GENL_CMD_TZ_GET_ID = 1,
	THERMAL_GENL_CMD_TZ_GET_TRIP = 2,
	THERMAL_GENL_CMD_TZ_GET_TEMP = 3,
	THERMAL_GENL_CMD_TZ_GET_GOV = 4,
	THERMAL_GENL_CMD_TZ_GET_MODE = 5,
	THERMAL_GENL_CMD_CDEV_GET = 6,
	THERMAL_GENL_CMD_THRESHOLD_GET = 7,
	THERMAL_GENL_CMD_THRESHOLD_ADD = 8,
	THERMAL_GENL_CMD_THRESHOLD_DELETE = 9,
	THERMAL_GENL_CMD_THRESHOLD_FLUSH = 10,
	__THERMAL_GENL_CMD_MAX = 11,
};

enum thermal_genl_event {
	THERMAL_GENL_EVENT_UNSPEC = 0,
	THERMAL_GENL_EVENT_TZ_CREATE = 1,
	THERMAL_GENL_EVENT_TZ_DELETE = 2,
	THERMAL_GENL_EVENT_TZ_DISABLE = 3,
	THERMAL_GENL_EVENT_TZ_ENABLE = 4,
	THERMAL_GENL_EVENT_TZ_TRIP_UP = 5,
	THERMAL_GENL_EVENT_TZ_TRIP_DOWN = 6,
	THERMAL_GENL_EVENT_TZ_TRIP_CHANGE = 7,
	THERMAL_GENL_EVENT_TZ_TRIP_ADD = 8,
	THERMAL_GENL_EVENT_TZ_TRIP_DELETE = 9,
	THERMAL_GENL_EVENT_CDEV_ADD = 10,
	THERMAL_GENL_EVENT_CDEV_DELETE = 11,
	THERMAL_GENL_EVENT_CDEV_STATE_UPDATE = 12,
	THERMAL_GENL_EVENT_TZ_GOV_CHANGE = 13,
	THERMAL_GENL_EVENT_CPU_CAPABILITY_CHANGE = 14,
	THERMAL_GENL_EVENT_THRESHOLD_ADD = 15,
	THERMAL_GENL_EVENT_THRESHOLD_DELETE = 16,
	THERMAL_GENL_EVENT_THRESHOLD_FLUSH = 17,
	THERMAL_GENL_EVENT_THRESHOLD_UP = 18,
	THERMAL_GENL_EVENT_THRESHOLD_DOWN = 19,
	__THERMAL_GENL_EVENT_MAX = 20,
};

enum thermal_genl_multicast_groups {
	THERMAL_GENL_SAMPLING_GROUP = 0,
	THERMAL_GENL_EVENT_GROUP = 1,
	THERMAL_GENL_MAX_GROUP = 1,
};

enum thermal_genl_sampling {
	THERMAL_GENL_SAMPLING_TEMP = 0,
	__THERMAL_GENL_SAMPLING_MAX = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
	THERMAL_TZ_ADD_THRESHOLD = 13,
	THERMAL_TZ_DEL_THRESHOLD = 14,
	THERMAL_TZ_FLUSH_THRESHOLDS = 15,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tlb_flush_reason {
	TLB_FLUSH_ON_TASK_SWITCH = 0,
	TLB_REMOTE_SHOOTDOWN = 1,
	TLB_LOCAL_SHOOTDOWN = 2,
	TLB_LOCAL_MM_SHOOTDOWN = 3,
	TLB_REMOTE_SEND_IPI = 4,
	NR_TLB_FLUSH_REASONS = 5,
};

enum tls_offload_ctx_dir {
	TLS_OFFLOAD_CTX_DIR_RX = 0,
	TLS_OFFLOAD_CTX_DIR_TX = 1,
};

enum tp_func_state {
	TP_FUNC_0 = 0,
	TP_FUNC_1 = 1,
	TP_FUNC_2 = 2,
	TP_FUNC_N = 3,
};

enum tp_transition_sync {
	TP_TRANSITION_SYNC_1_0_1 = 0,
	TP_TRANSITION_SYNC_N_2_1 = 1,
	_NR_TP_TRANSITION_SYNC = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tpm2_capabilities {
	TPM2_CAP_HANDLES = 1,
	TPM2_CAP_COMMANDS = 2,
	TPM2_CAP_PCRS = 5,
	TPM2_CAP_TPM_PROPERTIES = 6,
};

enum tpm2_cc_attrs {
	TPM2_CC_ATTR_CHANDLES = 25,
	TPM2_CC_ATTR_RHANDLE = 28,
	TPM2_CC_ATTR_VENDOR = 29,
};

enum tpm2_command_codes {
	TPM2_CC_FIRST = 287,
	TPM2_CC_HIERARCHY_CONTROL = 289,
	TPM2_CC_HIERARCHY_CHANGE_AUTH = 297,
	TPM2_CC_CREATE_PRIMARY = 305,
	TPM2_CC_SEQUENCE_COMPLETE = 318,
	TPM2_CC_SELF_TEST = 323,
	TPM2_CC_STARTUP = 324,
	TPM2_CC_SHUTDOWN = 325,
	TPM2_CC_NV_READ = 334,
	TPM2_CC_CREATE = 339,
	TPM2_CC_LOAD = 343,
	TPM2_CC_SEQUENCE_UPDATE = 348,
	TPM2_CC_UNSEAL = 350,
	TPM2_CC_CONTEXT_LOAD = 353,
	TPM2_CC_CONTEXT_SAVE = 354,
	TPM2_CC_FLUSH_CONTEXT = 357,
	TPM2_CC_READ_PUBLIC = 371,
	TPM2_CC_START_AUTH_SESS = 374,
	TPM2_CC_VERIFY_SIGNATURE = 375,
	TPM2_CC_GET_CAPABILITY = 378,
	TPM2_CC_GET_RANDOM = 379,
	TPM2_CC_PCR_READ = 382,
	TPM2_CC_PCR_EXTEND = 386,
	TPM2_CC_EVENT_SEQUENCE_COMPLETE = 389,
	TPM2_CC_HASH_SEQUENCE_START = 390,
	TPM2_CC_CREATE_LOADED = 401,
	TPM2_CC_LAST = 403,
};

enum tpm2_const {
	TPM2_PLATFORM_PCR = 24,
	TPM2_PCR_SELECT_MIN = 3,
};

enum tpm2_handle_types {
	TPM2_HT_HMAC_SESSION = 33554432,
	TPM2_HT_POLICY_SESSION = 50331648,
	TPM2_HT_TRANSIENT = 2147483648,
};

enum tpm2_permanent_handles {
	TPM2_RH_NULL = 1073741831,
	TPM2_RS_PW = 1073741833,
};

enum tpm2_properties {
	TPM_PT_TOTAL_COMMANDS = 297,
};

enum tpm2_return_codes {
	TPM2_RC_SUCCESS = 0,
	TPM2_RC_HASH = 131,
	TPM2_RC_HANDLE = 139,
	TPM2_RC_INTEGRITY = 159,
	TPM2_RC_INITIALIZE = 256,
	TPM2_RC_FAILURE = 257,
	TPM2_RC_DISABLED = 288,
	TPM2_RC_UPGRADE = 301,
	TPM2_RC_COMMAND_CODE = 323,
	TPM2_RC_TESTING = 2314,
	TPM2_RC_REFERENCE_H0 = 2320,
	TPM2_RC_RETRY = 2338,
};

enum tpm2_session_attributes {
	TPM2_SA_CONTINUE_SESSION = 1,
	TPM2_SA_AUDIT_EXCLUSIVE = 2,
	TPM2_SA_AUDIT_RESET = 8,
	TPM2_SA_DECRYPT = 32,
	TPM2_SA_ENCRYPT = 64,
	TPM2_SA_AUDIT = 128,
};

enum tpm2_startup_types {
	TPM2_SU_CLEAR = 0,
	TPM2_SU_STATE = 1,
};

enum tpm2_structures {
	TPM2_ST_NO_SESSIONS = 32769,
	TPM2_ST_SESSIONS = 32770,
	TPM2_ST_CREATION = 32801,
};

enum tpm2_timeouts {
	TPM2_TIMEOUT_A = 750,
	TPM2_TIMEOUT_B = 2000,
	TPM2_TIMEOUT_C = 200,
	TPM2_TIMEOUT_D = 30,
	TPM2_DURATION_SHORT = 20,
	TPM2_DURATION_MEDIUM = 750,
	TPM2_DURATION_LONG = 2000,
	TPM2_DURATION_LONG_LONG = 300000,
	TPM2_DURATION_DEFAULT = 120000,
};

enum tpm_algorithms {
	TPM_ALG_ERROR = 0,
	TPM_ALG_SHA1 = 4,
	TPM_ALG_AES = 6,
	TPM_ALG_KEYEDHASH = 8,
	TPM_ALG_SHA256 = 11,
	TPM_ALG_SHA384 = 12,
	TPM_ALG_SHA512 = 13,
	TPM_ALG_NULL = 16,
	TPM_ALG_SM3_256 = 18,
	TPM_ALG_ECC = 35,
	TPM_ALG_CFB = 67,
};

enum tpm_buf_flags {
	TPM_BUF_OVERFLOW = 1,
	TPM_BUF_TPM2B = 2,
	TPM_BUF_BOUNDARY_ERROR = 4,
};

enum tpm_capabilities {
	TPM_CAP_FLAG = 4,
	TPM_CAP_PROP = 5,
	TPM_CAP_VERSION_1_1 = 6,
	TPM_CAP_VERSION_1_2 = 26,
};

enum tpm_chip_flags {
	TPM_CHIP_FLAG_BOOTSTRAPPED = 1,
	TPM_CHIP_FLAG_TPM2 = 2,
	TPM_CHIP_FLAG_IRQ = 4,
	TPM_CHIP_FLAG_VIRTUAL = 8,
	TPM_CHIP_FLAG_HAVE_TIMEOUTS = 16,
	TPM_CHIP_FLAG_ALWAYS_POWERED = 32,
	TPM_CHIP_FLAG_FIRMWARE_POWER_MANAGED = 64,
	TPM_CHIP_FLAG_FIRMWARE_UPGRADE = 128,
	TPM_CHIP_FLAG_SUSPENDED = 256,
	TPM_CHIP_FLAG_HWRNG_DISABLED = 512,
	TPM_CHIP_FLAG_DISABLE = 1024,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum tpm_pcrs {
	TPM_PCR0 = 0,
	TPM_PCR8 = 8,
	TPM_PCR10 = 10,
};

enum tpm_sub_capabilities {
	TPM_CAP_PROP_PCR = 257,
	TPM_CAP_PROP_MANUFACTURER = 259,
	TPM_CAP_FLAG_PERM = 264,
	TPM_CAP_FLAG_VOL = 265,
	TPM_CAP_PROP_OWNER = 273,
	TPM_CAP_PROP_TIS_TIMEOUT = 277,
	TPM_CAP_PROP_TIS_DURATION = 288,
};

enum tpm_timeout {
	TPM_TIMEOUT = 5,
	TPM_TIMEOUT_RETRY = 100,
	TPM_TIMEOUT_RANGE_US = 300,
	TPM_TIMEOUT_POLL = 1,
	TPM_TIMEOUT_USECS_MIN = 100,
	TPM_TIMEOUT_USECS_MAX = 500,
};

enum trace_flag_type {
	TRACE_FLAG_IRQS_OFF = 1,
	TRACE_FLAG_NEED_RESCHED_LAZY = 2,
	TRACE_FLAG_NEED_RESCHED = 4,
	TRACE_FLAG_HARDIRQ = 8,
	TRACE_FLAG_SOFTIRQ = 16,
	TRACE_FLAG_PREEMPT_RESCHED = 32,
	TRACE_FLAG_NMI = 64,
	TRACE_FLAG_BH_OFF = 128,
};

enum trace_iter_flags {
	TRACE_FILE_LAT_FMT = 1,
	TRACE_FILE_ANNOTATE = 2,
	TRACE_FILE_TIME_IN_NS = 4,
};

enum trace_iterator_bits {
	TRACE_ITER_PRINT_PARENT_BIT = 0,
	TRACE_ITER_SYM_OFFSET_BIT = 1,
	TRACE_ITER_SYM_ADDR_BIT = 2,
	TRACE_ITER_VERBOSE_BIT = 3,
	TRACE_ITER_RAW_BIT = 4,
	TRACE_ITER_HEX_BIT = 5,
	TRACE_ITER_BIN_BIT = 6,
	TRACE_ITER_BLOCK_BIT = 7,
	TRACE_ITER_FIELDS_BIT = 8,
	TRACE_ITER_PRINTK_BIT = 9,
	TRACE_ITER_ANNOTATE_BIT = 10,
	TRACE_ITER_USERSTACKTRACE_BIT = 11,
	TRACE_ITER_SYM_USEROBJ_BIT = 12,
	TRACE_ITER_PRINTK_MSGONLY_BIT = 13,
	TRACE_ITER_CONTEXT_INFO_BIT = 14,
	TRACE_ITER_LATENCY_FMT_BIT = 15,
	TRACE_ITER_RECORD_CMD_BIT = 16,
	TRACE_ITER_RECORD_TGID_BIT = 17,
	TRACE_ITER_OVERWRITE_BIT = 18,
	TRACE_ITER_STOP_ON_FREE_BIT = 19,
	TRACE_ITER_IRQ_INFO_BIT = 20,
	TRACE_ITER_MARKERS_BIT = 21,
	TRACE_ITER_EVENT_FORK_BIT = 22,
	TRACE_ITER_TRACE_PRINTK_BIT = 23,
	TRACE_ITER_PAUSE_ON_TRACE_BIT = 24,
	TRACE_ITER_HASH_PTR_BIT = 25,
	TRACE_ITER_FUNCTION_BIT = 26,
	TRACE_ITER_FUNC_FORK_BIT = 27,
	TRACE_ITER_DISPLAY_GRAPH_BIT = 28,
	TRACE_ITER_STACKTRACE_BIT = 29,
	TRACE_ITER_LAST_BIT = 30,
};

enum trace_iterator_flags {
	TRACE_ITER_PRINT_PARENT = 1,
	TRACE_ITER_SYM_OFFSET = 2,
	TRACE_ITER_SYM_ADDR = 4,
	TRACE_ITER_VERBOSE = 8,
	TRACE_ITER_RAW = 16,
	TRACE_ITER_HEX = 32,
	TRACE_ITER_BIN = 64,
	TRACE_ITER_BLOCK = 128,
	TRACE_ITER_FIELDS = 256,
	TRACE_ITER_PRINTK = 512,
	TRACE_ITER_ANNOTATE = 1024,
	TRACE_ITER_USERSTACKTRACE = 2048,
	TRACE_ITER_SYM_USEROBJ = 4096,
	TRACE_ITER_PRINTK_MSGONLY = 8192,
	TRACE_ITER_CONTEXT_INFO = 16384,
	TRACE_ITER_LATENCY_FMT = 32768,
	TRACE_ITER_RECORD_CMD = 65536,
	TRACE_ITER_RECORD_TGID = 131072,
	TRACE_ITER_OVERWRITE = 262144,
	TRACE_ITER_STOP_ON_FREE = 524288,
	TRACE_ITER_IRQ_INFO = 1048576,
	TRACE_ITER_MARKERS = 2097152,
	TRACE_ITER_EVENT_FORK = 4194304,
	TRACE_ITER_TRACE_PRINTK = 8388608,
	TRACE_ITER_PAUSE_ON_TRACE = 16777216,
	TRACE_ITER_HASH_PTR = 33554432,
	TRACE_ITER_FUNCTION = 67108864,
	TRACE_ITER_FUNC_FORK = 134217728,
	TRACE_ITER_DISPLAY_GRAPH = 268435456,
	TRACE_ITER_STACKTRACE = 536870912,
};

enum trace_reg {
	TRACE_REG_REGISTER = 0,
	TRACE_REG_UNREGISTER = 1,
	TRACE_REG_PERF_REGISTER = 2,
	TRACE_REG_PERF_UNREGISTER = 3,
	TRACE_REG_PERF_OPEN = 4,
	TRACE_REG_PERF_CLOSE = 5,
	TRACE_REG_PERF_ADD = 6,
	TRACE_REG_PERF_DEL = 7,
};

enum trace_type {
	__TRACE_FIRST_TYPE = 0,
	TRACE_FN = 1,
	TRACE_CTX = 2,
	TRACE_WAKE = 3,
	TRACE_STACK = 4,
	TRACE_PRINT = 5,
	TRACE_BPRINT = 6,
	TRACE_MMIO_RW = 7,
	TRACE_MMIO_MAP = 8,
	TRACE_BRANCH = 9,
	TRACE_GRAPH_RET = 10,
	TRACE_GRAPH_ENT = 11,
	TRACE_GRAPH_RETADDR_ENT = 12,
	TRACE_USER_STACK = 13,
	TRACE_BLK = 14,
	TRACE_BPUTS = 15,
	TRACE_HWLAT = 16,
	TRACE_OSNOISE = 17,
	TRACE_TIMERLAT = 18,
	TRACE_RAW_DATA = 19,
	TRACE_FUNC_REPEATS = 20,
	__TRACE_LAST_TYPE = 21,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum trans_regime {
	TR_EL10 = 0,
	TR_EL20 = 1,
	TR_EL2 = 2,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum transparent_hugepage_flag {
	TRANSPARENT_HUGEPAGE_UNSUPPORTED = 0,
	TRANSPARENT_HUGEPAGE_FLAG = 1,
	TRANSPARENT_HUGEPAGE_REQ_MADV_FLAG = 2,
	TRANSPARENT_HUGEPAGE_DEFRAG_DIRECT_FLAG = 3,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_FLAG = 4,
	TRANSPARENT_HUGEPAGE_DEFRAG_KSWAPD_OR_MADV_FLAG = 5,
	TRANSPARENT_HUGEPAGE_DEFRAG_REQ_MADV_FLAG = 6,
	TRANSPARENT_HUGEPAGE_DEFRAG_KHUGEPAGED_FLAG = 7,
	TRANSPARENT_HUGEPAGE_USE_ZERO_PAGE_FLAG = 8,
};

enum trap_behaviour {
	BEHAVE_HANDLE_LOCALLY = 0,
	BEHAVE_FORWARD_READ = 1,
	BEHAVE_FORWARD_WRITE = 2,
	BEHAVE_FORWARD_RW = 3,
	BEHAVE_FORWARD_IN_HOST_EL0 = 4,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_parsable_tunnel_type {
	UDP_TUNNEL_TYPE_VXLAN = 1,
	UDP_TUNNEL_TYPE_GENEVE = 2,
	UDP_TUNNEL_TYPE_VXLAN_GPE = 4,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_MAY_SLEEP = 1,
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 4,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 8,
};

enum uhci_rh_state {
	UHCI_RH_RESET = 0,
	UHCI_RH_SUSPENDED = 1,
	UHCI_RH_AUTO_STOPPED = 2,
	UHCI_RH_RESUMING = 3,
	UHCI_RH_SUSPENDING = 4,
	UHCI_RH_RUNNING = 5,
	UHCI_RH_RUNNING_NODEVS = 6,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum uniphier_clk_type {
	UNIPHIER_CLK_TYPE_CPUGEAR = 0,
	UNIPHIER_CLK_TYPE_FIXED_FACTOR = 1,
	UNIPHIER_CLK_TYPE_FIXED_RATE = 2,
	UNIPHIER_CLK_TYPE_GATE = 3,
	UNIPHIER_CLK_TYPE_MUX = 4,
};

enum uniphier_pin_drv_type {
	UNIPHIER_PIN_DRV_1BIT = 0,
	UNIPHIER_PIN_DRV_2BIT = 1,
	UNIPHIER_PIN_DRV_3BIT = 2,
	UNIPHIER_PIN_DRV_FIXED4 = 3,
	UNIPHIER_PIN_DRV_FIXED5 = 4,
	UNIPHIER_PIN_DRV_FIXED8 = 5,
	UNIPHIER_PIN_DRV_NONE = 6,
};

enum uniphier_pin_pull_dir {
	UNIPHIER_PIN_PULL_UP = 0,
	UNIPHIER_PIN_PULL_DOWN = 1,
	UNIPHIER_PIN_PULL_UP_FIXED = 2,
	UNIPHIER_PIN_PULL_DOWN_FIXED = 3,
	UNIPHIER_PIN_PULL_NONE = 4,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum uprobe_task_state {
	UTASK_RUNNING = 0,
	UTASK_SSTEP = 1,
	UTASK_SSTEP_ACK = 2,
	UTASK_SSTEP_TRAPPED = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_role {
	USB_ROLE_NONE = 0,
	USB_ROLE_HOST = 1,
	USB_ROLE_DEVICE = 2,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum v4l2_av1_segment_feature {
	V4L2_AV1_SEG_LVL_ALT_Q = 0,
	V4L2_AV1_SEG_LVL_ALT_LF_Y_V = 1,
	V4L2_AV1_SEG_LVL_REF_FRAME = 5,
	V4L2_AV1_SEG_LVL_REF_SKIP = 6,
	V4L2_AV1_SEG_LVL_REF_GLOBALMV = 7,
	V4L2_AV1_SEG_LVL_MAX = 8,
};

enum v4l2_fwnode_bus_type {
	V4L2_FWNODE_BUS_TYPE_GUESS = 0,
	V4L2_FWNODE_BUS_TYPE_CSI2_CPHY = 1,
	V4L2_FWNODE_BUS_TYPE_CSI1 = 2,
	V4L2_FWNODE_BUS_TYPE_CCP2 = 3,
	V4L2_FWNODE_BUS_TYPE_CSI2_DPHY = 4,
	V4L2_FWNODE_BUS_TYPE_PARALLEL = 5,
	V4L2_FWNODE_BUS_TYPE_BT656 = 6,
	V4L2_FWNODE_BUS_TYPE_DPI = 7,
	NR_OF_V4L2_FWNODE_BUS_TYPE = 8,
};

enum v4l2_preemphasis {
	V4L2_PREEMPHASIS_DISABLED = 0,
	V4L2_PREEMPHASIS_50_uS = 1,
	V4L2_PREEMPHASIS_75_uS = 2,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vco_freq_range {
	VCO_LOW = 700000000,
	VCO_MID = 1200000000,
	VCO_HIGH = 2200000000,
	VCO_HIGH_HIGH = 3100000000,
	VCO_MAX = 4000000000,
};

enum vcpu_sysreg {
	__INVALID_SYSREG__ = 0,
	MPIDR_EL1 = 1,
	CLIDR_EL1 = 2,
	CSSELR_EL1 = 3,
	TPIDR_EL0 = 4,
	TPIDRRO_EL0 = 5,
	TPIDR_EL1 = 6,
	CNTKCTL_EL1 = 7,
	PAR_EL1 = 8,
	MDCCINT_EL1 = 9,
	OSLSR_EL1 = 10,
	DISR_EL1 = 11,
	PMCR_EL0 = 12,
	PMSELR_EL0 = 13,
	PMEVCNTR0_EL0 = 14,
	PMEVCNTR30_EL0 = 44,
	PMCCNTR_EL0 = 45,
	PMEVTYPER0_EL0 = 46,
	PMEVTYPER30_EL0 = 76,
	PMCCFILTR_EL0 = 77,
	PMCNTENSET_EL0 = 78,
	PMINTENSET_EL1 = 79,
	PMOVSSET_EL0 = 80,
	PMUSERENR_EL0 = 81,
	APIAKEYLO_EL1 = 82,
	APIAKEYHI_EL1 = 83,
	APIBKEYLO_EL1 = 84,
	APIBKEYHI_EL1 = 85,
	APDAKEYLO_EL1 = 86,
	APDAKEYHI_EL1 = 87,
	APDBKEYLO_EL1 = 88,
	APDBKEYHI_EL1 = 89,
	APGAKEYLO_EL1 = 90,
	APGAKEYHI_EL1 = 91,
	RGSR_EL1 = 92,
	GCR_EL1 = 93,
	TFSRE0_EL1 = 94,
	POR_EL0 = 95,
	SVCR = 96,
	FPMR = 97,
	DACR32_EL2 = 98,
	IFSR32_EL2 = 99,
	FPEXC32_EL2 = 100,
	DBGVCR32_EL2 = 101,
	SCTLR_EL2 = 102,
	ACTLR_EL2 = 103,
	CPTR_EL2 = 104,
	HACR_EL2 = 105,
	ZCR_EL2 = 106,
	TTBR0_EL2 = 107,
	TTBR1_EL2 = 108,
	TCR_EL2 = 109,
	PIRE0_EL2 = 110,
	PIR_EL2 = 111,
	POR_EL2 = 112,
	SPSR_EL2 = 113,
	ELR_EL2 = 114,
	AFSR0_EL2 = 115,
	AFSR1_EL2 = 116,
	ESR_EL2 = 117,
	FAR_EL2 = 118,
	HPFAR_EL2 = 119,
	MAIR_EL2 = 120,
	AMAIR_EL2 = 121,
	VBAR_EL2 = 122,
	RVBAR_EL2 = 123,
	CONTEXTIDR_EL2 = 124,
	CNTHCTL_EL2 = 125,
	SP_EL2 = 126,
	CNTHP_CTL_EL2 = 127,
	CNTHP_CVAL_EL2 = 128,
	CNTHV_CTL_EL2 = 129,
	CNTHV_CVAL_EL2 = 130,
	__SANITISED_REG_START__ = 131,
	__after___SANITISED_REG_START__ = 130,
	TCR2_EL2 = 131,
	MDCR_EL2 = 132,
	__VNCR_START__ = 133,
	__after___VNCR_START__ = 132,
	__before_SCTLR_EL1 = 133,
	SCTLR_EL1 = 167,
	__after_SCTLR_EL1 = 167,
	__before_ACTLR_EL1 = 168,
	ACTLR_EL1 = 168,
	__after_ACTLR_EL1 = 168,
	__before_CPACR_EL1 = 169,
	CPACR_EL1 = 165,
	__after_CPACR_EL1 = 168,
	__before_ZCR_EL1 = 169,
	ZCR_EL1 = 193,
	__after_ZCR_EL1 = 193,
	__before_TTBR0_EL1 = 194,
	TTBR0_EL1 = 197,
	__after_TTBR0_EL1 = 197,
	__before_TTBR1_EL1 = 198,
	TTBR1_EL1 = 199,
	__after_TTBR1_EL1 = 199,
	__before_TCR_EL1 = 200,
	TCR_EL1 = 169,
	__after_TCR_EL1 = 199,
	__before_TCR2_EL1 = 200,
	TCR2_EL1 = 211,
	__after_TCR2_EL1 = 211,
	__before_ESR_EL1 = 212,
	ESR_EL1 = 172,
	__after_ESR_EL1 = 211,
	__before_AFSR0_EL1 = 212,
	AFSR0_EL1 = 170,
	__after_AFSR0_EL1 = 211,
	__before_AFSR1_EL1 = 212,
	AFSR1_EL1 = 171,
	__after_AFSR1_EL1 = 211,
	__before_FAR_EL1 = 212,
	FAR_EL1 = 201,
	__after_FAR_EL1 = 211,
	__before_MAIR_EL1 = 212,
	MAIR_EL1 = 173,
	__after_MAIR_EL1 = 211,
	__before_VBAR_EL1 = 212,
	VBAR_EL1 = 207,
	__after_VBAR_EL1 = 211,
	__before_CONTEXTIDR_EL1 = 212,
	CONTEXTIDR_EL1 = 166,
	__after_CONTEXTIDR_EL1 = 211,
	__before_AMAIR_EL1 = 212,
	AMAIR_EL1 = 174,
	__after_AMAIR_EL1 = 211,
	__before_MDSCR_EL1 = 212,
	MDSCR_EL1 = 176,
	__after_MDSCR_EL1 = 211,
	__before_ELR_EL1 = 212,
	ELR_EL1 = 203,
	__after_ELR_EL1 = 211,
	__before_SP_EL1 = 212,
	SP_EL1 = 205,
	__after_SP_EL1 = 211,
	__before_SPSR_EL1 = 212,
	SPSR_EL1 = 177,
	__after_SPSR_EL1 = 211,
	__before_TFSR_EL1 = 212,
	TFSR_EL1 = 183,
	__after_TFSR_EL1 = 211,
	__before_VPIDR_EL2 = 212,
	VPIDR_EL2 = 150,
	__after_VPIDR_EL2 = 211,
	__before_VMPIDR_EL2 = 212,
	VMPIDR_EL2 = 143,
	__after_VMPIDR_EL2 = 211,
	__before_HCR_EL2 = 212,
	HCR_EL2 = 148,
	__after_HCR_EL2 = 211,
	__before_HSTR_EL2 = 212,
	HSTR_EL2 = 149,
	__after_HSTR_EL2 = 211,
	__before_VTTBR_EL2 = 212,
	VTTBR_EL2 = 137,
	__after_VTTBR_EL2 = 211,
	__before_VTCR_EL2 = 212,
	VTCR_EL2 = 141,
	__after_VTCR_EL2 = 211,
	__before_TPIDR_EL2 = 212,
	TPIDR_EL2 = 151,
	__after_TPIDR_EL2 = 211,
	__before_HCRX_EL2 = 212,
	HCRX_EL2 = 153,
	__after_HCRX_EL2 = 211,
	__before_PIR_EL1 = 212,
	PIR_EL1 = 217,
	__after_PIR_EL1 = 217,
	__before_PIRE0_EL1 = 218,
	PIRE0_EL1 = 215,
	__after_PIRE0_EL1 = 217,
	__before_POR_EL1 = 218,
	POR_EL1 = 218,
	__after_POR_EL1 = 218,
	__before_HFGRTR_EL2 = 219,
	HFGRTR_EL2 = 188,
	__after_HFGRTR_EL2 = 218,
	__before_HFGWTR_EL2 = 219,
	HFGWTR_EL2 = 189,
	__after_HFGWTR_EL2 = 218,
	__before_HFGITR_EL2 = 219,
	HFGITR_EL2 = 190,
	__after_HFGITR_EL2 = 218,
	__before_HDFGRTR_EL2 = 219,
	HDFGRTR_EL2 = 191,
	__after_HDFGRTR_EL2 = 218,
	__before_HDFGWTR_EL2 = 219,
	HDFGWTR_EL2 = 192,
	__after_HDFGWTR_EL2 = 218,
	__before_HAFGRTR_EL2 = 219,
	HAFGRTR_EL2 = 194,
	__after_HAFGRTR_EL2 = 218,
	__before_CNTVOFF_EL2 = 219,
	CNTVOFF_EL2 = 145,
	__after_CNTVOFF_EL2 = 218,
	__before_CNTV_CVAL_EL0 = 219,
	CNTV_CVAL_EL0 = 178,
	__after_CNTV_CVAL_EL0 = 218,
	__before_CNTV_CTL_EL0 = 219,
	CNTV_CTL_EL0 = 179,
	__after_CNTV_CTL_EL0 = 218,
	__before_CNTP_CVAL_EL0 = 219,
	CNTP_CVAL_EL0 = 180,
	__after_CNTP_CVAL_EL0 = 218,
	__before_CNTP_CTL_EL0 = 219,
	CNTP_CTL_EL0 = 181,
	__after_CNTP_CTL_EL0 = 218,
	__before_ICH_HCR_EL2 = 219,
	ICH_HCR_EL2 = 285,
	__after_ICH_HCR_EL2 = 285,
	NR_SYS_REGS = 286,
};

enum vdso_abi {
	VDSO_ABI_AA64 = 0,
	VDSO_ABI_AA32 = 1,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_ARCHTIMER = 1,
	VDSO_CLOCKMODE_ARCHTIMER_NOCOMPAT = 2,
	VDSO_CLOCKMODE_MAX = 3,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum vec_type {
	ARM64_VEC_SVE = 0,
	ARM64_VEC_SME = 1,
	ARM64_VEC_MAX = 2,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vexpress_reset_func {
	FUNC_RESET = 0,
	FUNC_SHUTDOWN = 1,
	FUNC_REBOOT = 2,
};

enum vfio_device_mig_state {
	VFIO_DEVICE_STATE_ERROR = 0,
	VFIO_DEVICE_STATE_STOP = 1,
	VFIO_DEVICE_STATE_RUNNING = 2,
	VFIO_DEVICE_STATE_STOP_COPY = 3,
	VFIO_DEVICE_STATE_RESUMING = 4,
	VFIO_DEVICE_STATE_RUNNING_P2P = 5,
	VFIO_DEVICE_STATE_PRE_COPY = 6,
	VFIO_DEVICE_STATE_PRE_COPY_P2P = 7,
	VFIO_DEVICE_STATE_NR = 8,
};

enum vfio_group_type {
	VFIO_IOMMU = 0,
	VFIO_EMULATED_IOMMU = 1,
	VFIO_NO_IOMMU = 2,
};

enum vgic_irq_config {
	VGIC_CONFIG_EDGE = 0,
	VGIC_CONFIG_LEVEL = 1,
};

enum vgic_type {
	VGIC_V2 = 0,
	VGIC_V3 = 1,
};

enum vhost_task_flags {
	VHOST_TASK_FLAGS_STOP = 0,
	VHOST_TASK_FLAGS_KILLED = 1,
};

enum virtio_mem_bbm_bb_state {
	VIRTIO_MEM_BBM_BB_UNUSED = 0,
	VIRTIO_MEM_BBM_BB_PLUGGED = 1,
	VIRTIO_MEM_BBM_BB_ADDED = 2,
	VIRTIO_MEM_BBM_BB_FAKE_OFFLINE = 3,
	VIRTIO_MEM_BBM_BB_COUNT = 4,
};

enum virtio_mem_sbm_mb_state {
	VIRTIO_MEM_SBM_MB_UNUSED = 0,
	VIRTIO_MEM_SBM_MB_PLUGGED = 1,
	VIRTIO_MEM_SBM_MB_OFFLINE = 2,
	VIRTIO_MEM_SBM_MB_OFFLINE_PARTIAL = 3,
	VIRTIO_MEM_SBM_MB_KERNEL = 4,
	VIRTIO_MEM_SBM_MB_KERNEL_PARTIAL = 5,
	VIRTIO_MEM_SBM_MB_MOVABLE = 6,
	VIRTIO_MEM_SBM_MB_MOVABLE_PARTIAL = 7,
	VIRTIO_MEM_SBM_MB_COUNT = 8,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA = 4,
	PGALLOC_DMA32 = 5,
	PGALLOC_NORMAL = 6,
	PGALLOC_MOVABLE = 7,
	PGALLOC_DEVICE = 8,
	ALLOCSTALL_DMA = 9,
	ALLOCSTALL_DMA32 = 10,
	ALLOCSTALL_NORMAL = 11,
	ALLOCSTALL_MOVABLE = 12,
	ALLOCSTALL_DEVICE = 13,
	PGSCAN_SKIP_DMA = 14,
	PGSCAN_SKIP_DMA32 = 15,
	PGSCAN_SKIP_NORMAL = 16,
	PGSCAN_SKIP_MOVABLE = 17,
	PGSCAN_SKIP_DEVICE = 18,
	PGFREE = 19,
	PGACTIVATE = 20,
	PGDEACTIVATE = 21,
	PGLAZYFREE = 22,
	PGFAULT = 23,
	PGMAJFAULT = 24,
	PGLAZYFREED = 25,
	PGREFILL = 26,
	PGREUSE = 27,
	PGSTEAL_KSWAPD = 28,
	PGSTEAL_DIRECT = 29,
	PGSTEAL_KHUGEPAGED = 30,
	PGSCAN_KSWAPD = 31,
	PGSCAN_DIRECT = 32,
	PGSCAN_KHUGEPAGED = 33,
	PGSCAN_DIRECT_THROTTLE = 34,
	PGSCAN_ANON = 35,
	PGSCAN_FILE = 36,
	PGSTEAL_ANON = 37,
	PGSTEAL_FILE = 38,
	PGSCAN_ZONE_RECLAIM_SUCCESS = 39,
	PGSCAN_ZONE_RECLAIM_FAILED = 40,
	PGINODESTEAL = 41,
	SLABS_SCANNED = 42,
	KSWAPD_INODESTEAL = 43,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 44,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 45,
	PAGEOUTRUN = 46,
	PGROTATED = 47,
	DROP_PAGECACHE = 48,
	DROP_SLAB = 49,
	OOM_KILL = 50,
	NUMA_PTE_UPDATES = 51,
	NUMA_HUGE_PTE_UPDATES = 52,
	NUMA_HINT_FAULTS = 53,
	NUMA_HINT_FAULTS_LOCAL = 54,
	NUMA_PAGE_MIGRATE = 55,
	PGMIGRATE_SUCCESS = 56,
	PGMIGRATE_FAIL = 57,
	THP_MIGRATION_SUCCESS = 58,
	THP_MIGRATION_FAIL = 59,
	THP_MIGRATION_SPLIT = 60,
	COMPACTMIGRATE_SCANNED = 61,
	COMPACTFREE_SCANNED = 62,
	COMPACTISOLATED = 63,
	COMPACTSTALL = 64,
	COMPACTFAIL = 65,
	COMPACTSUCCESS = 66,
	KCOMPACTD_WAKE = 67,
	KCOMPACTD_MIGRATE_SCANNED = 68,
	KCOMPACTD_FREE_SCANNED = 69,
	HTLB_BUDDY_PGALLOC = 70,
	HTLB_BUDDY_PGALLOC_FAIL = 71,
	CMA_ALLOC_SUCCESS = 72,
	CMA_ALLOC_FAIL = 73,
	UNEVICTABLE_PGCULLED = 74,
	UNEVICTABLE_PGSCANNED = 75,
	UNEVICTABLE_PGRESCUED = 76,
	UNEVICTABLE_PGMLOCKED = 77,
	UNEVICTABLE_PGMUNLOCKED = 78,
	UNEVICTABLE_PGCLEARED = 79,
	UNEVICTABLE_PGSTRANDED = 80,
	THP_FAULT_ALLOC = 81,
	THP_FAULT_FALLBACK = 82,
	THP_FAULT_FALLBACK_CHARGE = 83,
	THP_COLLAPSE_ALLOC = 84,
	THP_COLLAPSE_ALLOC_FAILED = 85,
	THP_FILE_ALLOC = 86,
	THP_FILE_FALLBACK = 87,
	THP_FILE_FALLBACK_CHARGE = 88,
	THP_FILE_MAPPED = 89,
	THP_SPLIT_PAGE = 90,
	THP_SPLIT_PAGE_FAILED = 91,
	THP_DEFERRED_SPLIT_PAGE = 92,
	THP_UNDERUSED_SPLIT_PAGE = 93,
	THP_SPLIT_PMD = 94,
	THP_SCAN_EXCEED_NONE_PTE = 95,
	THP_SCAN_EXCEED_SWAP_PTE = 96,
	THP_SCAN_EXCEED_SHARED_PTE = 97,
	THP_ZERO_PAGE_ALLOC = 98,
	THP_ZERO_PAGE_ALLOC_FAILED = 99,
	THP_SWPOUT = 100,
	THP_SWPOUT_FALLBACK = 101,
	BALLOON_INFLATE = 102,
	BALLOON_DEFLATE = 103,
	BALLOON_MIGRATE = 104,
	SWAP_RA = 105,
	SWAP_RA_HIT = 106,
	SWPIN_ZERO = 107,
	SWPOUT_ZERO = 108,
	KSM_SWPIN_COPY = 109,
	COW_KSM = 110,
	ZSWPIN = 111,
	ZSWPOUT = 112,
	ZSWPWB = 113,
	NR_VM_EVENT_ITEMS = 114,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_flags {
	VMG_FLAG_DEFAULT = 0,
	VMG_FLAG_JUST_EXPAND = 1,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vma_resv_mode {
	VMA_NEEDS_RESV = 0,
	VMA_COMMIT_RESV = 1,
	VMA_END_RESV = 2,
	VMA_ADD_RESV = 3,
	VMA_DEL_RESV = 4,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum vtime_state {
	VTIME_INACTIVE = 0,
	VTIME_IDLE = 1,
	VTIME_SYS = 2,
	VTIME_USER = 3,
	VTIME_GUEST = 4,
};

enum vvar_pages {
	VVAR_DATA_PAGE_OFFSET = 0,
	VVAR_TIMENS_PAGE_OFFSET = 1,
	VVAR_NR_PAGES = 2,
};

enum watch_meta_notification_subtype {
	WATCH_META_REMOVAL_NOTIFICATION = 0,
	WATCH_META_LOSS_NOTIFICATION = 1,
};

enum watch_notification_type {
	WATCH_TYPE_META = 0,
	WATCH_TYPE_KEY_NOTIFY = 1,
	WATCH_TYPE__NR = 2,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wbt_flags {
	WBT_TRACKED = 1,
	WBT_READ = 2,
	WBT_SWAP = 4,
	WBT_DISCARD = 8,
	WBT_NR_BITS = 4,
};

enum wiphy_flags {
	WIPHY_FLAG_SUPPORTS_EXT_KEK_KCK = 1,
	WIPHY_FLAG_SUPPORTS_MLO = 2,
	WIPHY_FLAG_SPLIT_SCAN_6GHZ = 4,
	WIPHY_FLAG_NETNS_OK = 8,
	WIPHY_FLAG_PS_ON_BY_DEFAULT = 16,
	WIPHY_FLAG_4ADDR_AP = 32,
	WIPHY_FLAG_4ADDR_STATION = 64,
	WIPHY_FLAG_CONTROL_PORT_PROTOCOL = 128,
	WIPHY_FLAG_IBSS_RSN = 256,
	WIPHY_FLAG_DISABLE_WEXT = 512,
	WIPHY_FLAG_MESH_AUTH = 1024,
	WIPHY_FLAG_SUPPORTS_EXT_KCK_32 = 2048,
	WIPHY_FLAG_SUPPORTS_NSTR_NONPRIMARY = 4096,
	WIPHY_FLAG_SUPPORTS_FW_ROAM = 8192,
	WIPHY_FLAG_AP_UAPSD = 16384,
	WIPHY_FLAG_SUPPORTS_TDLS = 32768,
	WIPHY_FLAG_TDLS_EXTERNAL_SETUP = 65536,
	WIPHY_FLAG_HAVE_AP_SME = 131072,
	WIPHY_FLAG_REPORTS_OBSS = 262144,
	WIPHY_FLAG_AP_PROBE_RESP_OFFLOAD = 524288,
	WIPHY_FLAG_OFFCHAN_TX = 1048576,
	WIPHY_FLAG_HAS_REMAIN_ON_CHANNEL = 2097152,
	WIPHY_FLAG_SUPPORTS_5_10_MHZ = 4194304,
	WIPHY_FLAG_HAS_CHANNEL_SWITCH = 8388608,
	WIPHY_FLAG_NOTIFY_REGDOM_BY_DRIVER = 16777216,
	WIPHY_FLAG_CHANNEL_CHANGE_ON_BEACON = 33554432,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 43,
	WORK_OFFQ_POOL_BITS = 31,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 2048,
	WQ_UNBOUND_MAX_ACTIVE = 2048,
	WQ_DFL_ACTIVE = 1024,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 75000,
	MAYDAY_INITIAL_TIMEOUT = 2,
	MAYDAY_INTERVAL = 25,
	CREATE_COOLDOWN = 250,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 4096,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum x509_actions {
	ACT_x509_extract_key_data = 0,
	ACT_x509_extract_name_segment = 1,
	ACT_x509_note_OID = 2,
	ACT_x509_note_issuer = 3,
	ACT_x509_note_not_after = 4,
	ACT_x509_note_not_before = 5,
	ACT_x509_note_params = 6,
	ACT_x509_note_serial = 7,
	ACT_x509_note_sig_algo = 8,
	ACT_x509_note_signature = 9,
	ACT_x509_note_subject = 10,
	ACT_x509_note_tbs_certificate = 11,
	ACT_x509_process_extension = 12,
	NR__x509_actions = 13,
};

enum x509_akid_actions {
	ACT_x509_akid_note_kid = 0,
	ACT_x509_akid_note_name = 1,
	ACT_x509_akid_note_serial = 2,
	ACT_x509_extract_name_segment___2 = 3,
	ACT_x509_note_OID___2 = 4,
	NR__x509_akid_actions = 5,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xfrm_ae_ftype_t {
	XFRM_AE_UNSPEC = 0,
	XFRM_AE_RTHR = 1,
	XFRM_AE_RVAL = 2,
	XFRM_AE_LVAL = 4,
	XFRM_AE_ETHR = 8,
	XFRM_AE_CR = 16,
	XFRM_AE_CE = 32,
	XFRM_AE_CU = 64,
	__XFRM_AE_MAX = 65,
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	XFRMA_SA_DIR = 33,
	XFRMA_NAT_KEEPALIVE_INTERVAL = 34,
	XFRMA_SA_PCPU = 35,
	__XFRMA_MAX = 36,
};

enum xfrm_nlgroups {
	XFRMNLGRP_NONE = 0,
	XFRMNLGRP_ACQUIRE = 1,
	XFRMNLGRP_EXPIRE = 2,
	XFRMNLGRP_SA = 3,
	XFRMNLGRP_POLICY = 4,
	XFRMNLGRP_AEVENTS = 5,
	XFRMNLGRP_REPORT = 6,
	XFRMNLGRP_MIGRATE = 7,
	XFRMNLGRP_MAPPING = 8,
	__XFRMNLGRP_MAX = 9,
};

enum xfrm_pol_inexact_candidate_type {
	XFRM_POL_CAND_BOTH = 0,
	XFRM_POL_CAND_SADDR = 1,
	XFRM_POL_CAND_DADDR = 2,
	XFRM_POL_CAND_ANY = 3,
	XFRM_POL_CAND_MAX = 4,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xfrm_sa_dir {
	XFRM_SA_DIR_IN = 1,
	XFRM_SA_DIR_OUT = 2,
};

enum xfrm_sadattr_type_t {
	XFRMA_SAD_UNSPEC = 0,
	XFRMA_SAD_CNT = 1,
	XFRMA_SAD_HINFO = 2,
	__XFRMA_SAD_MAX = 3,
};

enum xfrm_spdattr_type_t {
	XFRMA_SPD_UNSPEC = 0,
	XFRMA_SPD_INFO = 1,
	XFRMA_SPD_HINFO = 2,
	XFRMA_SPD_IPV4_HTHRESH = 3,
	XFRMA_SPD_IPV6_HTHRESH = 4,
	__XFRMA_SPD_MAX = 5,
};

enum xgene_phy_mode {
	MODE_SATA = 0,
	MODE_SGMII = 1,
	MODE_PCIE = 2,
	MODE_USB = 3,
	MODE_XFI = 4,
	MODE_MAX___2 = 5,
};

enum xgene_pll_type {
	PLL_TYPE_PCP = 0,
	PLL_TYPE_SOC = 1,
};

enum xgene_pmu_dev_type {
	PMU_TYPE_L3C = 0,
	PMU_TYPE_IOB = 1,
	PMU_TYPE_IOB_SLOW = 2,
	PMU_TYPE_MCB = 3,
	PMU_TYPE_MC = 4,
};

enum xgene_pmu_version {
	PCP_PMU_V1 = 1,
	PCP_PMU_V2 = 2,
	PCP_PMU_V3 = 3,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum zbc_zone_alignment_method {
	ZBC_CONSTANT_ZONE_LENGTH = 1,
	ZBC_CONSTANT_ZONE_START_OFFSET = 8,
};

enum zbc_zone_cond {
	ZBC_ZONE_COND_NO_WP = 0,
	ZBC_ZONE_COND_EMPTY = 1,
	ZBC_ZONE_COND_IMP_OPEN = 2,
	ZBC_ZONE_COND_EXP_OPEN = 3,
	ZBC_ZONE_COND_CLOSED = 4,
	ZBC_ZONE_COND_READONLY = 13,
	ZBC_ZONE_COND_FULL = 14,
	ZBC_ZONE_COND_OFFLINE = 15,
};

enum zbc_zone_type {
	ZBC_ZONE_TYPE_CONV = 1,
	ZBC_ZONE_TYPE_SEQWRITE_REQ = 2,
	ZBC_ZONE_TYPE_SEQWRITE_PREF = 3,
	ZBC_ZONE_TYPE_SEQ_OR_BEFORE_REQ = 4,
	ZBC_ZONE_TYPE_GAP = 5,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_ZONE_LRU_BASE = 1,
	NR_ZONE_INACTIVE_ANON = 1,
	NR_ZONE_ACTIVE_ANON = 2,
	NR_ZONE_INACTIVE_FILE = 3,
	NR_ZONE_ACTIVE_FILE = 4,
	NR_ZONE_UNEVICTABLE = 5,
	NR_ZONE_WRITE_PENDING = 6,
	NR_MLOCK = 7,
	NR_BOUNCE = 8,
	NR_ZSPAGES = 9,
	NR_FREE_CMA_PAGES = 10,
	NR_VM_ZONE_STAT_ITEMS = 11,
};

enum zone_type {
	ZONE_DMA = 0,
	ZONE_DMA32 = 1,
	ZONE_NORMAL = 2,
	ZONE_MOVABLE = 3,
	ZONE_DEVICE = 4,
	__MAX_NR_ZONES = 5,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zonefs_features {
	ZONEFS_F_AGGRCNV = 1,
	ZONEFS_F_UID = 2,
	ZONEFS_F_GID = 4,
	ZONEFS_F_PERM = 8,
};

enum zonefs_ztype {
	ZONEFS_ZTYPE_CNV = 0,
	ZONEFS_ZTYPE_SEQ = 1,
	ZONEFS_ZTYPE_MAX = 2,
};

enum zpool_mapmode {
	ZPOOL_MM_RW = 0,
	ZPOOL_MM_RO = 1,
	ZPOOL_MM_WO = 2,
	ZPOOL_MM_DEFAULT = 0,
};

enum zs_mapmode {
	ZS_MM_RW = 0,
	ZS_MM_RO = 1,
	ZS_MM_WO = 2,
};

enum zswap_init_type {
	ZSWAP_UNINIT = 0,
	ZSWAP_INIT_SUCCEED = 1,
	ZSWAP_INIT_FAILED = 2,
};

enum zynqmp_pm_request_ack {
	ZYNQMP_PM_REQUEST_ACK_NO = 1,
	ZYNQMP_PM_REQUEST_ACK_BLOCKING = 2,
	ZYNQMP_PM_REQUEST_ACK_NON_BLOCKING = 3,
};

enum zynqmp_pm_reset {
	ZYNQMP_PM_RESET_START = 1000,
	ZYNQMP_PM_RESET_PCIE_CFG = 1000,
	ZYNQMP_PM_RESET_PCIE_BRIDGE = 1001,
	ZYNQMP_PM_RESET_PCIE_CTRL = 1002,
	ZYNQMP_PM_RESET_DP = 1003,
	ZYNQMP_PM_RESET_SWDT_CRF = 1004,
	ZYNQMP_PM_RESET_AFI_FM5 = 1005,
	ZYNQMP_PM_RESET_AFI_FM4 = 1006,
	ZYNQMP_PM_RESET_AFI_FM3 = 1007,
	ZYNQMP_PM_RESET_AFI_FM2 = 1008,
	ZYNQMP_PM_RESET_AFI_FM1 = 1009,
	ZYNQMP_PM_RESET_AFI_FM0 = 1010,
	ZYNQMP_PM_RESET_GDMA = 1011,
	ZYNQMP_PM_RESET_GPU_PP1 = 1012,
	ZYNQMP_PM_RESET_GPU_PP0 = 1013,
	ZYNQMP_PM_RESET_GPU = 1014,
	ZYNQMP_PM_RESET_GT = 1015,
	ZYNQMP_PM_RESET_SATA = 1016,
	ZYNQMP_PM_RESET_ACPU3_PWRON = 1017,
	ZYNQMP_PM_RESET_ACPU2_PWRON = 1018,
	ZYNQMP_PM_RESET_ACPU1_PWRON = 1019,
	ZYNQMP_PM_RESET_ACPU0_PWRON = 1020,
	ZYNQMP_PM_RESET_APU_L2 = 1021,
	ZYNQMP_PM_RESET_ACPU3 = 1022,
	ZYNQMP_PM_RESET_ACPU2 = 1023,
	ZYNQMP_PM_RESET_ACPU1 = 1024,
	ZYNQMP_PM_RESET_ACPU0 = 1025,
	ZYNQMP_PM_RESET_DDR = 1026,
	ZYNQMP_PM_RESET_APM_FPD = 1027,
	ZYNQMP_PM_RESET_SOFT = 1028,
	ZYNQMP_PM_RESET_GEM0 = 1029,
	ZYNQMP_PM_RESET_GEM1 = 1030,
	ZYNQMP_PM_RESET_GEM2 = 1031,
	ZYNQMP_PM_RESET_GEM3 = 1032,
	ZYNQMP_PM_RESET_QSPI = 1033,
	ZYNQMP_PM_RESET_UART0 = 1034,
	ZYNQMP_PM_RESET_UART1 = 1035,
	ZYNQMP_PM_RESET_SPI0 = 1036,
	ZYNQMP_PM_RESET_SPI1 = 1037,
	ZYNQMP_PM_RESET_SDIO0 = 1038,
	ZYNQMP_PM_RESET_SDIO1 = 1039,
	ZYNQMP_PM_RESET_CAN0 = 1040,
	ZYNQMP_PM_RESET_CAN1 = 1041,
	ZYNQMP_PM_RESET_I2C0 = 1042,
	ZYNQMP_PM_RESET_I2C1 = 1043,
	ZYNQMP_PM_RESET_TTC0 = 1044,
	ZYNQMP_PM_RESET_TTC1 = 1045,
	ZYNQMP_PM_RESET_TTC2 = 1046,
	ZYNQMP_PM_RESET_TTC3 = 1047,
	ZYNQMP_PM_RESET_SWDT_CRL = 1048,
	ZYNQMP_PM_RESET_NAND = 1049,
	ZYNQMP_PM_RESET_ADMA = 1050,
	ZYNQMP_PM_RESET_GPIO = 1051,
	ZYNQMP_PM_RESET_IOU_CC = 1052,
	ZYNQMP_PM_RESET_TIMESTAMP = 1053,
	ZYNQMP_PM_RESET_RPU_R50 = 1054,
	ZYNQMP_PM_RESET_RPU_R51 = 1055,
	ZYNQMP_PM_RESET_RPU_AMBA = 1056,
	ZYNQMP_PM_RESET_OCM = 1057,
	ZYNQMP_PM_RESET_RPU_PGE = 1058,
	ZYNQMP_PM_RESET_USB0_CORERESET = 1059,
	ZYNQMP_PM_RESET_USB1_CORERESET = 1060,
	ZYNQMP_PM_RESET_USB0_HIBERRESET = 1061,
	ZYNQMP_PM_RESET_USB1_HIBERRESET = 1062,
	ZYNQMP_PM_RESET_USB0_APB = 1063,
	ZYNQMP_PM_RESET_USB1_APB = 1064,
	ZYNQMP_PM_RESET_IPI = 1065,
	ZYNQMP_PM_RESET_APM_LPD = 1066,
	ZYNQMP_PM_RESET_RTC = 1067,
	ZYNQMP_PM_RESET_SYSMON = 1068,
	ZYNQMP_PM_RESET_AFI_FM6 = 1069,
	ZYNQMP_PM_RESET_LPD_SWDT = 1070,
	ZYNQMP_PM_RESET_FPD = 1071,
	ZYNQMP_PM_RESET_RPU_DBG1 = 1072,
	ZYNQMP_PM_RESET_RPU_DBG0 = 1073,
	ZYNQMP_PM_RESET_DBG_LPD = 1074,
	ZYNQMP_PM_RESET_DBG_FPD = 1075,
	ZYNQMP_PM_RESET_APLL = 1076,
	ZYNQMP_PM_RESET_DPLL = 1077,
	ZYNQMP_PM_RESET_VPLL = 1078,
	ZYNQMP_PM_RESET_IOPLL = 1079,
	ZYNQMP_PM_RESET_RPLL = 1080,
	ZYNQMP_PM_RESET_GPO3_PL_0 = 1081,
	ZYNQMP_PM_RESET_GPO3_PL_1 = 1082,
	ZYNQMP_PM_RESET_GPO3_PL_2 = 1083,
	ZYNQMP_PM_RESET_GPO3_PL_3 = 1084,
	ZYNQMP_PM_RESET_GPO3_PL_4 = 1085,
	ZYNQMP_PM_RESET_GPO3_PL_5 = 1086,
	ZYNQMP_PM_RESET_GPO3_PL_6 = 1087,
	ZYNQMP_PM_RESET_GPO3_PL_7 = 1088,
	ZYNQMP_PM_RESET_GPO3_PL_8 = 1089,
	ZYNQMP_PM_RESET_GPO3_PL_9 = 1090,
	ZYNQMP_PM_RESET_GPO3_PL_10 = 1091,
	ZYNQMP_PM_RESET_GPO3_PL_11 = 1092,
	ZYNQMP_PM_RESET_GPO3_PL_12 = 1093,
	ZYNQMP_PM_RESET_GPO3_PL_13 = 1094,
	ZYNQMP_PM_RESET_GPO3_PL_14 = 1095,
	ZYNQMP_PM_RESET_GPO3_PL_15 = 1096,
	ZYNQMP_PM_RESET_GPO3_PL_16 = 1097,
	ZYNQMP_PM_RESET_GPO3_PL_17 = 1098,
	ZYNQMP_PM_RESET_GPO3_PL_18 = 1099,
	ZYNQMP_PM_RESET_GPO3_PL_19 = 1100,
	ZYNQMP_PM_RESET_GPO3_PL_20 = 1101,
	ZYNQMP_PM_RESET_GPO3_PL_21 = 1102,
	ZYNQMP_PM_RESET_GPO3_PL_22 = 1103,
	ZYNQMP_PM_RESET_GPO3_PL_23 = 1104,
	ZYNQMP_PM_RESET_GPO3_PL_24 = 1105,
	ZYNQMP_PM_RESET_GPO3_PL_25 = 1106,
	ZYNQMP_PM_RESET_GPO3_PL_26 = 1107,
	ZYNQMP_PM_RESET_GPO3_PL_27 = 1108,
	ZYNQMP_PM_RESET_GPO3_PL_28 = 1109,
	ZYNQMP_PM_RESET_GPO3_PL_29 = 1110,
	ZYNQMP_PM_RESET_GPO3_PL_30 = 1111,
	ZYNQMP_PM_RESET_GPO3_PL_31 = 1112,
	ZYNQMP_PM_RESET_RPU_LS = 1113,
	ZYNQMP_PM_RESET_PS_ONLY = 1114,
	ZYNQMP_PM_RESET_PL = 1115,
	ZYNQMP_PM_RESET_PS_PL0 = 1116,
	ZYNQMP_PM_RESET_PS_PL1 = 1117,
	ZYNQMP_PM_RESET_PS_PL2 = 1118,
	ZYNQMP_PM_RESET_PS_PL3 = 1119,
	ZYNQMP_PM_RESET_END = 1119,
};

enum zynqmp_pm_reset_action {
	PM_RESET_ACTION_RELEASE = 0,
	PM_RESET_ACTION_ASSERT = 1,
	PM_RESET_ACTION_PULSE = 2,
};

enum zynqmp_pm_shutdown_subtype {
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_SUBSYSTEM = 0,
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_PS_ONLY = 1,
	ZYNQMP_PM_SHUTDOWN_SUBTYPE_SYSTEM = 2,
};

enum zynqmp_pm_shutdown_type {
	ZYNQMP_PM_SHUTDOWN_TYPE_SHUTDOWN = 0,
	ZYNQMP_PM_SHUTDOWN_TYPE_RESET = 1,
	ZYNQMP_PM_SHUTDOWN_TYPE_SETSCOPE_ONLY = 2,
};

enum zynqmp_pm_suspend_reason {
	SUSPEND_POWER_REQUEST = 201,
	SUSPEND_ALERT = 202,
	SUSPEND_SYSTEM_SHUTDOWN = 203,
};

typedef _Bool bool;

typedef __int128 unsigned __u128;

typedef __u128 u128;

typedef u128 freelist_full_t;

typedef freelist_full_t pcp_op_T__;

typedef char acpi_bus_id[8];

typedef char acpi_device_class[20];

typedef char acpi_device_name[40];

typedef char *acpi_string;

typedef const char (* const ethnl_string_array_t)[32];

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_ipc_pid_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_rwf_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 codel_tdiff_t;

typedef s32 compat_clock_t;

typedef s32 compat_daddr_t;

typedef s32 compat_int_t;

typedef s32 compat_key_t;

typedef s32 compat_long_t;

typedef s32 compat_off_t;

typedef s32 compat_pid_t;

typedef s32 compat_ssize_t;

typedef s32 compat_timer_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext4_grpblk_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef int initcall_entry_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int mhp_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef __s32 sctp_assoc_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef const int tracepoint_ptr_t;

typedef long int __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_ptrdiff_t;

typedef __kernel_long_t __kernel_ssize_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long int intptr_t;

typedef long int mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef volatile long int prel64_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef __kernel_ssize_t ssize_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long long int __s64;

typedef __s64 Elf64_Sxword;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef __s64 s64;

typedef s64 compat_loff_t;

typedef s64 compat_s64;

typedef s64 int64_t;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long int qsize_t;

typedef __s64 time64_t;

typedef long long unsigned int __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __le64;

typedef __u64 __virtio64;

typedef u64 acpi_bus_address;

typedef u64 acpi_integer;

typedef u64 acpi_io_address;

typedef u64 acpi_physical_address;

typedef u64 acpi_size;

typedef u64 arm_lpae_iopte;

typedef u64 async_cookie_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef u64 compat_u64;

typedef u64 dma_addr_t;

typedef u64 efi_physical_addr_t;

typedef long long unsigned int ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 gfn_t;

typedef u64 gpa_t;

typedef u64 hfn_t;

typedef u64 hpa_t;

typedef u64 io_req_flags_t;

typedef hfn_t kvm_pfn_t;

typedef u64 kvm_pte_t;

typedef kvm_pte_t *kvm_pteref_t;

typedef u64 netdev_features_t;

typedef u64 p4dval_t;

typedef u64 pci_bus_addr_t;

typedef u64 pgdval_t;

typedef u64 phys_addr_t;

typedef u64 phys_cpuid_t;

typedef u64 pmdval_t;

typedef u64 pteval_t;

typedef u64 pudval_t;

typedef phys_addr_t resource_size_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef u64 u_int64_t;

typedef u64 upf_t;

typedef uint64_t vli_type;

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef long unsigned int __kernel_ulong_t;

typedef __kernel_ulong_t __kernel_size_t;

typedef __kernel_ulong_t aio_context_t;

typedef long unsigned int cycles_t;

typedef long unsigned int dax_entry_t;

typedef long unsigned int efi_status_t;

typedef long unsigned int elf_greg_t;

typedef elf_greg_t elf_gregset_t[34];

typedef long unsigned int hva_t;

typedef __kernel_ulong_t ino_t;

typedef long unsigned int irq_hw_number_t;

typedef long unsigned int kernel_ulong_t;

typedef long unsigned int kimage_entry_t;

typedef mpi_limb_t *mpi_ptr_t;

typedef long unsigned int netmem_ref;

typedef long unsigned int old_sigset_t;

typedef long unsigned int perf_trace_t[1024];

typedef long unsigned int pte_marker;

typedef __kernel_size_t size_t;

typedef long unsigned int uLong;

typedef long unsigned int uintptr_t;

typedef long unsigned int ulg;

typedef long unsigned int ulong;

typedef uintptr_t uptrval;

typedef long unsigned int vm_flags_t;

typedef short int __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef short unsigned int __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef short unsigned int ush;

typedef ush Pos;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16;

typedef __u16 __be16;

typedef u16 __compat_gid16_t;

typedef u16 __compat_gid_t;

typedef u16 __compat_uid16_t;

typedef u16 __compat_uid_t;

typedef __u16 __hc16;

typedef short unsigned int __kernel_gid16_t;

typedef short unsigned int __kernel_old_gid_t;

typedef short unsigned int __kernel_old_uid_t;

typedef short unsigned int __kernel_sa_family_t;

typedef short unsigned int __kernel_uid16_t;

typedef __u16 __le16;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef u16 access_mask_t;

typedef u16 acpi_owner_id;

typedef u16 acpi_rs_length;

typedef __u16 bitmap_counter_t;

typedef u16 blk_short_t;

typedef __u16 comp_t;

typedef u16 compat_ipc_pid_t;

typedef u16 compat_mode_t;

typedef u16 compat_ushort_t;

typedef u16 efi_char16_t;

typedef __kernel_gid16_t gid16_t;

typedef u16 layer_mask_t;

typedef short unsigned int mifi_t;

typedef __kernel_old_gid_t old_gid_t;

typedef __kernel_old_uid_t old_uid_t;

typedef short unsigned int pci_bus_flags_t;

typedef short unsigned int pci_dev_flags_t;

typedef __u16 port_id;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef short unsigned int u_short;

typedef u16 ucs2_char_t;

typedef __kernel_uid16_t uid16_t;

typedef short unsigned int umode_t;

typedef short unsigned int ushort;

typedef short unsigned int vifi_t;

typedef u16 wchar_t;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef uint8_t U8;

typedef u8 acpi_adr_space_type;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 dscp_t;

typedef __u8 dvd_challenge[10];

typedef __u8 dvd_key[5];

typedef u8 efi_bool_t;

typedef u8 rmap_age_t;

typedef unsigned char u8___2;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_DTable;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int UHWtype;

typedef __u32 __be32;

typedef u32 __compat_gid32_t;

typedef u32 __compat_uid32_t;

typedef __u32 __hc32;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_gid_t;

typedef unsigned int __kernel_mode_t;

typedef unsigned int __kernel_uid32_t;

typedef unsigned int __kernel_uid_t;

typedef __u32 __le32;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_event_status;

typedef u32 acpi_mutex_handle;

typedef u32 acpi_name;

typedef u32 acpi_object_type;

typedef u32 acpi_rsdesc_size;

typedef u32 acpi_status;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 codel_time_t;

typedef u32 compat_aio_context_t;

typedef u32 compat_caddr_t;

typedef u32 compat_dev_t;

typedef unsigned int compat_elf_greg_t;

typedef compat_elf_greg_t compat_elf_gregset_t[18];

typedef u32 compat_ino_t;

typedef u32 compat_old_sigset_t;

typedef u32 compat_sigset_word;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 depot_flags_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef uint32_t drbg_flag_t;

typedef u32 efi_cc_event_algorithm_bitmap_t;

typedef u32 efi_cc_event_log_bitmap_t;

typedef u32 efi_cc_event_log_format_t;

typedef u32 efi_cc_mr_index_t;

typedef u32 efi_tcg2_event_log_format;

typedef u32 errseq_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef __u32 if_mask;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef __le32 kprobe_opcode_t;

typedef unsigned int mmc_pm_flag_t;

typedef __kernel_mode_t mode_t;

typedef u32 nlink_t;

typedef u32 note_buf_t[106];

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef unsigned int pkvm_handle_t;

typedef __kernel_uid32_t projid_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef u32 rpc_authflavor_t;

typedef unsigned int sk_buff_data_t;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef u32 ssci_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef unsigned int uffd_flags_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unicode_t;

typedef __le32 uprobe_opcode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef struct {
	size_t bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} ATTR_PRESERVE_ACCESS_INDEX BIT_DStream_t;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} ATTR_PRESERVE_ACCESS_INDEX DTableDesc;

typedef struct {
	size_t state;
	const void *table;
} ATTR_PRESERVE_ACCESS_INDEX FSE_DState_t;

typedef struct {
	U16 tableLog;
	U16 fastMode;
} ATTR_PRESERVE_ACCESS_INDEX FSE_DTableHeader;

typedef struct {
	short int ncount[256];
	FSE_DTable dtable[0];
} ATTR_PRESERVE_ACCESS_INDEX FSE_DecompressWksp;

typedef struct {
	short unsigned int newState;
	unsigned char symbol;
	unsigned char nbBits;
} ATTR_PRESERVE_ACCESS_INDEX FSE_decode_t;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} ATTR_PRESERVE_ACCESS_INDEX HUF_DEltX1;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} ATTR_PRESERVE_ACCESS_INDEX HUF_DEltX2;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[218];
	BYTE symbols[256];
	BYTE huffWeight[256];
} ATTR_PRESERVE_ACCESS_INDEX HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} ATTR_PRESERVE_ACCESS_INDEX sortedSymbol_t;

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[218];
} ATTR_PRESERVE_ACCESS_INDEX HUF_ReadDTableX2_Workspace;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} ATTR_PRESERVE_ACCESS_INDEX Indirect;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} ATTR_PRESERVE_ACCESS_INDEX LZ4_streamDecode_t_internal;

typedef union {
	long long unsigned int table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} ATTR_PRESERVE_ACCESS_INDEX LZ4_streamDecode_t;

struct folio;

typedef struct {
	struct folio *v;
} ATTR_PRESERVE_ACCESS_INDEX Sector;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_DDictHashSet;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_bounds;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_customMem;

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_entropyDTables_t;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_frameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_frameHeader;

typedef struct {
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_fseState;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ATTR_PRESERVE_ACCESS_INDEX ZSTD_seqSymbol_header;

typedef struct {
	long unsigned int fds_bits[16];
} ATTR_PRESERVE_ACCESS_INDEX __kernel_fd_set;

typedef struct {
	int val[2];
} ATTR_PRESERVE_ACCESS_INDEX __kernel_fsid_t;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} ATTR_PRESERVE_ACCESS_INDEX algo_time_t;

typedef struct {
	s64 counter;
} ATTR_PRESERVE_ACCESS_INDEX atomic64_t;

typedef atomic64_t atomic_long_t;

typedef struct {
	int counter;
} ATTR_PRESERVE_ACCESS_INDEX atomic_t;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} ATTR_PRESERVE_ACCESS_INDEX blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void *user;
	} ATTR_PRESERVE_ACCESS_INDEX;
	bool is_kernel: 1;
} ATTR_PRESERVE_ACCESS_INDEX sockptr_t;

typedef sockptr_t bpfptr_t;

struct permanent_flags_t {
	__be16 tag;
	u8 disable;
	u8 ownership;
	u8 deactivated;
	u8 readPubek;
	u8 disableOwnerClear;
	u8 allowMaintenance;
	u8 physicalPresenceLifetimeLock;
	u8 physicalPresenceHWEnable;
	u8 physicalPresenceCMDEnable;
	u8 CEKPUsed;
	u8 TPMpost;
	u8 TPMpostLock;
	u8 FIPS;
	u8 operator;
	u8 enableRevokeEK;
	u8 nvLocked;
	u8 readSRKPub;
	u8 tpmEstablished;
	u8 maintenanceDone;
	u8 disableFullDALogicInfo;
} ATTR_PRESERVE_ACCESS_INDEX;

struct stclear_flags_t {
	__be16 tag;
	u8 deactivated;
	u8 disableForceClear;
	u8 physicalPresence;
	u8 physicalPresenceLock;
	u8 bGlobalLock;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct tpm1_version {
	u8 major;
	u8 minor;
	u8 rev_major;
	u8 rev_minor;
} ATTR_PRESERVE_ACCESS_INDEX;

struct tpm1_version2 {
	__be16 tag;
	struct tpm1_version version;
} ATTR_PRESERVE_ACCESS_INDEX;

struct timeout_t {
	__be32 a;
	__be32 b;
	__be32 c;
	__be32 d;
} ATTR_PRESERVE_ACCESS_INDEX;

struct duration_t {
	__be32 tpm_short;
	__be32 tpm_medium;
	__be32 tpm_long;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef union {
	struct permanent_flags_t perm_flags;
	struct stclear_flags_t stclear_flags;
	__u8 owned;
	__be32 num_pcrs;
	struct tpm1_version version1;
	struct tpm1_version2 version2;
	__be32 manufacturer_id;
	struct timeout_t timeout;
	struct duration_t duration;
} ATTR_PRESERVE_ACCESS_INDEX cap_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} ATTR_PRESERVE_ACCESS_INDEX cisco_proto;

typedef struct {
	int *lock;
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX class_core_lock_t;

typedef struct {
	void *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_cpus_read_lock_t;

struct raw_spinlock;

typedef struct raw_spinlock raw_spinlock_t;

typedef struct {
	raw_spinlock_t *lock;
	raw_spinlock_t *lock2;
} ATTR_PRESERVE_ACCESS_INDEX class_double_raw_spinlock_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} ATTR_PRESERVE_ACCESS_INDEX class_double_rq_lock_t;

typedef struct {
	void *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_irq_t;

typedef struct {
	void *lock;
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX class_irqsave_t;

typedef struct {
	void *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_preempt_notrace_t;

typedef struct {
	void *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_preempt_t;

typedef struct {
	raw_spinlock_t *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_raw_spinlock_t;

typedef struct {
	void *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_rcu_t;

typedef struct {
	void *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_rcu_tasks_trace_t;

struct qspinlock {
	union {
		atomic_t val;
		struct {
			u8 locked;
			u8 pending;
		} ATTR_PRESERVE_ACCESS_INDEX;
		struct {
			u16 locked_pending;
			u16 tail;
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct qspinlock arch_spinlock_t;

struct qrwlock {
	union {
		atomic_t cnts;
		struct {
			u8 wlocked;
			u8 __lstate[3];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
	arch_spinlock_t wait_lock;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct qrwlock arch_rwlock_t;

typedef struct {
	arch_rwlock_t raw_lock;
} ATTR_PRESERVE_ACCESS_INDEX rwlock_t;

typedef struct {
	rwlock_t *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_read_lock_t;

struct pin_cookie {} ATTR_PRESERVE_ACCESS_INDEX;

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} ATTR_PRESERVE_ACCESS_INDEX class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} ATTR_PRESERVE_ACCESS_INDEX class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} ATTR_PRESERVE_ACCESS_INDEX class_rq_lock_t;

struct spinlock;

typedef struct spinlock spinlock_t;

typedef struct {
	spinlock_t *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} ATTR_PRESERVE_ACCESS_INDEX class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} ATTR_PRESERVE_ACCESS_INDEX class_task_rq_lock_t;

typedef struct {
	rwlock_t *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_write_lock_irq_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX class_write_lock_irqsave_t;

typedef struct {
	rwlock_t *lock;
} ATTR_PRESERVE_ACCESS_INDEX class_write_lock_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	short unsigned int val;
} ATTR_PRESERVE_ACCESS_INDEX code;

typedef __kernel_fsid_t compat_fsid_t;

typedef struct {
	compat_sigset_word sig[2];
} ATTR_PRESERVE_ACCESS_INDEX compat_sigset_t;

typedef struct {
	__be16 disc_information_length;
	__u8 disc_status: 2;
	__u8 border_status: 2;
	__u8 erasable: 1;
	__u8 reserved1: 3;
	__u8 n_first_track;
	__u8 n_sessions_lsb;
	__u8 first_track_lsb;
	__u8 last_track_lsb;
	__u8 mrw_status: 2;
	__u8 dbit: 1;
	__u8 reserved2: 2;
	__u8 uru: 1;
	__u8 dbc_v: 1;
	__u8 did_v: 1;
	__u8 disc_type;
	__u8 n_sessions_msb;
	__u8 first_track_msb;
	__u8 last_track_msb;
	__u32 disc_id;
	__u32 lead_in;
	__u32 lead_out;
	__u8 disc_bar_code[8];
	__u8 reserved3;
	__u8 n_opc;
} ATTR_PRESERVE_ACCESS_INDEX disc_information;

typedef struct {
	long unsigned int bits[1];
} ATTR_PRESERVE_ACCESS_INDEX dma_cap_mask_t;

struct dvd_lu_send_agid {
	__u8 type;
	unsigned int agid: 2;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_host_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_send_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key key;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_lu_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_lu_send_title_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key title_key;
	int lba;
	unsigned int cpm: 1;
	unsigned int cp_sec: 1;
	unsigned int cgms: 2;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_lu_send_asf {
	__u8 type;
	unsigned int agid: 2;
	unsigned int asf: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_host_send_rpcstate {
	__u8 type;
	__u8 pdrc;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_lu_send_rpcstate {
	__u8 type: 2;
	__u8 vra: 3;
	__u8 ucca: 3;
	__u8 region_mask;
	__u8 rpc_scheme;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef union {
	__u8 type;
	struct dvd_lu_send_agid lsa;
	struct dvd_host_send_challenge hsc;
	struct dvd_send_key lsk;
	struct dvd_lu_send_challenge lsc;
	struct dvd_send_key hsk;
	struct dvd_lu_send_title_key lstk;
	struct dvd_lu_send_asf lsasf;
	struct dvd_host_send_rpcstate hrpcs;
	struct dvd_lu_send_rpcstate lrpcs;
} ATTR_PRESERVE_ACCESS_INDEX dvd_authinfo;

struct dvd_layer {
	__u8 book_version: 4;
	__u8 book_type: 4;
	__u8 min_rate: 4;
	__u8 disc_size: 4;
	__u8 layer_type: 4;
	__u8 track_path: 1;
	__u8 nlayers: 2;
	char: 1;
	__u8 track_density: 4;
	__u8 linear_density: 4;
	__u8 bca: 1;
	__u32 start_sector;
	__u32 end_sector;
	__u32 end_sector_l0;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_physical {
	__u8 type;
	__u8 layer_num;
	struct dvd_layer layer[4];
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_copyright {
	__u8 type;
	__u8 layer_num;
	__u8 cpst;
	__u8 rmi;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_disckey {
	__u8 type;
	unsigned int agid: 2;
	__u8 value[2048];
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_bca {
	__u8 type;
	int len;
	__u8 value[188];
} ATTR_PRESERVE_ACCESS_INDEX;

struct dvd_manufact {
	__u8 type;
	__u8 layer_num;
	int len;
	__u8 value[2048];
} ATTR_PRESERVE_ACCESS_INDEX;

typedef union {
	__u8 type;
	struct dvd_physical physical;
	struct dvd_copyright copyright;
	struct dvd_disckey disckey;
	struct dvd_bca bca;
	struct dvd_manufact manufact;
} ATTR_PRESERVE_ACCESS_INDEX dvd_struct;

typedef struct {
	u64 length;
	u64 data;
} ATTR_PRESERVE_ACCESS_INDEX efi_capsule_block_desc_t;

typedef struct {
	__u8 b[16];
} ATTR_PRESERVE_ACCESS_INDEX guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} ATTR_PRESERVE_ACCESS_INDEX efi_capsule_header_t;

typedef struct {
	u8 major;
	u8 minor;
} ATTR_PRESERVE_ACCESS_INDEX efi_cc_version_t;

typedef struct {
	u8 type;
	u8 sub_type;
} ATTR_PRESERVE_ACCESS_INDEX efi_cc_type_t;

typedef struct {
	u8 size;
	efi_cc_version_t structure_version;
	efi_cc_version_t protocol_version;
	efi_cc_event_algorithm_bitmap_t hash_algorithm_bitmap;
	efi_cc_event_log_bitmap_t supported_event_logs;
	efi_cc_type_t cc_type;
} ATTR_PRESERVE_ACCESS_INDEX efi_cc_boot_service_cap_t;

typedef struct {
	efi_guid_t guid;
	u32 table;
} ATTR_PRESERVE_ACCESS_INDEX efi_config_table_32_t;

typedef struct {
	efi_guid_t guid;
	u64 table;
} ATTR_PRESERVE_ACCESS_INDEX efi_config_table_64_t;

typedef union {
	struct {
		efi_guid_t guid;
		void *table;
	} ATTR_PRESERVE_ACCESS_INDEX;
	efi_config_table_32_t mixed_mode;
} ATTR_PRESERVE_ACCESS_INDEX efi_config_table_t;

typedef struct {
	efi_guid_t guid;
	long unsigned int *ptr;
	const char name[16];
} ATTR_PRESERVE_ACCESS_INDEX efi_config_table_type_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} ATTR_PRESERVE_ACCESS_INDEX efi_time_t;

typedef struct {
	u64 size;
	u64 file_size;
	u64 phys_size;
	efi_time_t create_time;
	efi_time_t last_access_time;
	efi_time_t modification_time;
	__u64 attribute;
	efi_char16_t filename[0];
} ATTR_PRESERVE_ACCESS_INDEX efi_file_info_t;

typedef struct {
	u32 red_mask;
	u32 green_mask;
	u32 blue_mask;
	u32 reserved_mask;
} ATTR_PRESERVE_ACCESS_INDEX efi_pixel_bitmask_t;

typedef struct {
	u32 version;
	u32 horizontal_resolution;
	u32 vertical_resolution;
	int pixel_format;
	efi_pixel_bitmask_t pixel_information;
	u32 pixels_per_scan_line;
} ATTR_PRESERVE_ACCESS_INDEX efi_graphics_output_mode_info_t;

typedef struct {
	u16 scan_code;
	efi_char16_t unicode_char;
} ATTR_PRESERVE_ACCESS_INDEX efi_input_key_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	u8 variable_data[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX efi_load_option_t;

struct efi_generic_dev_path;

typedef struct efi_generic_dev_path efi_device_path_protocol_t;

typedef struct {
	u32 attributes;
	u16 file_path_list_length;
	const efi_char16_t *description;
	const efi_device_path_protocol_t *file_path_list;
	u32 optional_data_size;
	const void *optional_data;
} ATTR_PRESERVE_ACCESS_INDEX efi_load_option_unpacked_t;

typedef void *efi_handle_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} ATTR_PRESERVE_ACCESS_INDEX efi_table_hdr_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} ATTR_PRESERVE_ACCESS_INDEX efi_time_cap_t;

typedef efi_status_t efi_get_time_t(efi_time_t *, efi_time_cap_t *);

typedef efi_status_t efi_set_time_t(efi_time_t *);

typedef efi_status_t efi_get_wakeup_time_t(efi_bool_t *, efi_bool_t *, efi_time_t *);

typedef efi_status_t efi_set_wakeup_time_t(efi_bool_t, efi_time_t *);

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} ATTR_PRESERVE_ACCESS_INDEX efi_memory_desc_t;

typedef efi_status_t efi_set_virtual_address_map_t(long unsigned int, long unsigned int, u32, efi_memory_desc_t *);

typedef efi_status_t efi_get_variable_t(efi_char16_t *, efi_guid_t *, u32 *, long unsigned int *, void *);

typedef efi_status_t efi_get_next_variable_t(long unsigned int *, efi_char16_t *, efi_guid_t *);

typedef efi_status_t efi_set_variable_t(efi_char16_t *, efi_guid_t *, u32, long unsigned int, void *);

typedef efi_status_t efi_get_next_high_mono_count_t(u32 *);

typedef void efi_reset_system_t(int, efi_status_t, long unsigned int, efi_char16_t *);

typedef efi_status_t efi_update_capsule_t(efi_capsule_header_t **, long unsigned int, long unsigned int);

typedef efi_status_t efi_query_capsule_caps_t(efi_capsule_header_t **, long unsigned int, u64 *, int *);

typedef efi_status_t efi_query_variable_info_t(u32, u64 *, u64 *, u64 *);

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} ATTR_PRESERVE_ACCESS_INDEX efi_runtime_services_32_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_get_time_t *get_time;
		efi_set_time_t *set_time;
		efi_get_wakeup_time_t *get_wakeup_time;
		efi_set_wakeup_time_t *set_wakeup_time;
		efi_set_virtual_address_map_t *set_virtual_address_map;
		void *convert_pointer;
		efi_get_variable_t *get_variable;
		efi_get_next_variable_t *get_next_variable;
		efi_set_variable_t *set_variable;
		efi_get_next_high_mono_count_t *get_next_high_mono_count;
		efi_reset_system_t *reset_system;
		efi_update_capsule_t *update_capsule;
		efi_query_capsule_caps_t *query_capsule_caps;
		efi_query_variable_info_t *query_variable_info;
	} ATTR_PRESERVE_ACCESS_INDEX;
	efi_runtime_services_32_t mixed_mode;
} ATTR_PRESERVE_ACCESS_INDEX efi_runtime_services_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 fw_vendor;
	u32 fw_revision;
	u32 con_in_handle;
	u32 con_in;
	u32 con_out_handle;
	u32 con_out;
	u32 stderr_handle;
	u32 stderr;
	u32 runtime;
	u32 boottime;
	u32 nr_tables;
	u32 tables;
} ATTR_PRESERVE_ACCESS_INDEX efi_system_table_32_t;

union efi_simple_text_input_protocol;

typedef union efi_simple_text_input_protocol efi_simple_text_input_protocol_t;

union efi_simple_text_output_protocol;

typedef union efi_simple_text_output_protocol efi_simple_text_output_protocol_t;

union efi_boot_services;

typedef union efi_boot_services efi_boot_services_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		long unsigned int fw_vendor;
		u32 fw_revision;
		long unsigned int con_in_handle;
		efi_simple_text_input_protocol_t *con_in;
		long unsigned int con_out_handle;
		efi_simple_text_output_protocol_t *con_out;
		long unsigned int stderr_handle;
		long unsigned int stderr;
		efi_runtime_services_t *runtime;
		efi_boot_services_t *boottime;
		long unsigned int nr_tables;
		long unsigned int tables;
	} ATTR_PRESERVE_ACCESS_INDEX;
	efi_system_table_32_t mixed_mode;
} ATTR_PRESERVE_ACCESS_INDEX efi_system_table_t;

typedef union {
	struct {
		u32 revision;
		efi_handle_t parent_handle;
		efi_system_table_t *system_table;
		efi_handle_t device_handle;
		void *file_path;
		void *reserved;
		u32 load_options_size;
		void *load_options;
		void *image_base;
		__u64 image_size;
		unsigned int image_code_type;
		unsigned int image_data_type;
		efi_status_t (*unload)(efi_handle_t);
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct {
		u32 revision;
		u32 parent_handle;
		u32 system_table;
		u32 device_handle;
		u32 file_path;
		u32 reserved;
		u32 load_options_size;
		u32 load_options;
		u32 image_base;
		__u64 image_size;
		u32 image_code_type;
		u32 image_data_type;
		u32 unload;
	} ATTR_PRESERVE_ACCESS_INDEX mixed_mode;
} ATTR_PRESERVE_ACCESS_INDEX efi_loaded_image_t;

typedef struct {
	u32 version;
	u32 num_entries;
	u32 desc_size;
	u32 flags;
	efi_memory_desc_t entry[0];
} ATTR_PRESERVE_ACCESS_INDEX efi_memory_attributes_table_t;

typedef struct {
	u32 read;
	u32 write;
} ATTR_PRESERVE_ACCESS_INDEX efi_pci_io_protocol_access_32_t;

typedef struct {
	void *read;
	void *write;
} ATTR_PRESERVE_ACCESS_INDEX efi_pci_io_protocol_access_t;

union efi_pci_io_protocol;

typedef union efi_pci_io_protocol efi_pci_io_protocol_t;

typedef efi_status_t (*efi_pci_io_protocol_cfg_t)(efi_pci_io_protocol_t *, EFI_PCI_IO_PROTOCOL_WIDTH, u32, long unsigned int, void *);

typedef struct {
	efi_pci_io_protocol_cfg_t read;
	efi_pci_io_protocol_cfg_t write;
} ATTR_PRESERVE_ACCESS_INDEX efi_pci_io_protocol_config_access_t;

typedef struct {
	u16 version;
	u16 length;
	u32 runtime_services_supported;
} ATTR_PRESERVE_ACCESS_INDEX efi_rt_properties_table_t;

typedef struct {
	efi_guid_t signature_owner;
	u8 signature_data[0];
} ATTR_PRESERVE_ACCESS_INDEX efi_signature_data_t;

typedef struct {
	efi_guid_t signature_type;
	u32 signature_list_size;
	u32 signature_header_size;
	u32 signature_size;
	u8 signature_header[0];
} ATTR_PRESERVE_ACCESS_INDEX efi_signature_list_t;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ATTR_PRESERVE_ACCESS_INDEX ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ATTR_PRESERVE_ACCESS_INDEX ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	long unsigned int *in;
	long unsigned int *out;
	long unsigned int *ex;
	long unsigned int *res_in;
	long unsigned int *res_out;
	long unsigned int *res_ex;
} ATTR_PRESERVE_ACCESS_INDEX fd_set_bits;

typedef struct {
	atomic64_t refcnt;
} ATTR_PRESERVE_ACCESS_INDEX file_ref_t;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} ATTR_PRESERVE_ACCESS_INDEX fr_proto;

typedef struct {
	unsigned int dlci;
} ATTR_PRESERVE_ACCESS_INDEX fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} ATTR_PRESERVE_ACCESS_INDEX fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		long unsigned int counter;
	} ATTR_PRESERVE_ACCESS_INDEX;
	freelist_full_t full;
} ATTR_PRESERVE_ACCESS_INDEX freelist_aba_t;

typedef struct {
	long unsigned int v;
} ATTR_PRESERVE_ACCESS_INDEX freeptr_t;

typedef struct {
	long unsigned int key[2];
} ATTR_PRESERVE_ACCESS_INDEX hsiphash_key_t;

typedef struct {
	unsigned int __softirq_pending;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX irq_cpustat_t;

typedef struct {
	u64 val;
} ATTR_PRESERVE_ACCESS_INDEX kernel_cap_t;

typedef struct {
	gid_t val;
} ATTR_PRESERVE_ACCESS_INDEX kgid_t;

typedef struct {
	projid_t val;
} ATTR_PRESERVE_ACCESS_INDEX kprojid_t;

typedef struct {
	uid_t val;
} ATTR_PRESERVE_ACCESS_INDEX kuid_t;

typedef struct {
	__le64 b;
	__le64 a;
} ATTR_PRESERVE_ACCESS_INDEX le128;

typedef struct {
	atomic_long_t a;
} ATTR_PRESERVE_ACCESS_INDEX local_t;

typedef struct {
	local_t a;
} ATTR_PRESERVE_ACCESS_INDEX local64_t;

typedef struct {} ATTR_PRESERVE_ACCESS_INDEX local_lock_t;

typedef struct {} ATTR_PRESERVE_ACCESS_INDEX lockdep_map_p;

struct refcount_struct {
	atomic_t refs;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct refcount_struct refcount_t;

typedef struct {
	atomic64_t id;
	void *sigpage;
	refcount_t pinned;
	void *vdso;
	long unsigned int flags;
	u8 pkey_allocation_map;
} ATTR_PRESERVE_ACCESS_INDEX mm_context_t;

typedef struct {} ATTR_PRESERVE_ACCESS_INDEX netdevice_tracker;

typedef struct {} ATTR_PRESERVE_ACCESS_INDEX netns_tracker;

typedef struct {
	char data[8];
} ATTR_PRESERVE_ACCESS_INDEX nfs4_verifier;

typedef struct {
	long unsigned int bits[1];
} ATTR_PRESERVE_ACCESS_INDEX nodemask_t;

typedef struct {
	pgdval_t pgd;
} ATTR_PRESERVE_ACCESS_INDEX pgd_t;

typedef struct {
	pgd_t pgd;
} ATTR_PRESERVE_ACCESS_INDEX p4d_t;

typedef struct {
	u64 pme;
} ATTR_PRESERVE_ACCESS_INDEX pagemap_entry_t;

typedef struct {
	u64 val;
} ATTR_PRESERVE_ACCESS_INDEX pfn_t;

typedef struct {
	pteval_t pgprot;
} ATTR_PRESERVE_ACCESS_INDEX pgprot_t;

typedef struct {
	pmdval_t pmd;
} ATTR_PRESERVE_ACCESS_INDEX pmd_t;

typedef struct {
	long unsigned int bits[4];
} ATTR_PRESERVE_ACCESS_INDEX pnp_irq_mask_t;

struct net;

typedef struct {
	struct net *net;
} ATTR_PRESERVE_ACCESS_INDEX possible_net_t;

typedef struct {
	pteval_t pte;
} ATTR_PRESERVE_ACCESS_INDEX pte_t;

typedef struct {
	pudval_t pud;
} ATTR_PRESERVE_ACCESS_INDEX pud_t;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} ATTR_PRESERVE_ACCESS_INDEX raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} ATTR_PRESERVE_ACCESS_INDEX rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} ATTR_PRESERVE_ACCESS_INDEX arg;
	int error;
} ATTR_PRESERVE_ACCESS_INDEX read_descriptor_t;

typedef union {
} ATTR_PRESERVE_ACCESS_INDEX release_pages_arg;

typedef struct {
	__u16 report_key_length;
	__u8 reserved1;
	__u8 reserved2;
	__u8 ucca: 3;
	__u8 vra: 3;
	__u8 type_code: 2;
	__u8 region_mask;
	__u8 rpc_scheme;
	__u8 reserved3;
} ATTR_PRESERVE_ACCESS_INDEX rpc_state_t;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} ATTR_PRESERVE_ACCESS_INDEX seqState_t;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} ATTR_PRESERVE_ACCESS_INDEX seq_t;

struct seqcount {
	unsigned int sequence;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} ATTR_PRESERVE_ACCESS_INDEX seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct seqcount_spinlock seqcount_spinlock_t;

struct raw_spinlock {
	arch_spinlock_t raw_lock;
} ATTR_PRESERVE_ACCESS_INDEX;

struct spinlock {
	union {
		struct raw_spinlock rlock;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} ATTR_PRESERVE_ACCESS_INDEX seqlock_t;

typedef struct {
	long unsigned int sig[1];
} ATTR_PRESERVE_ACCESS_INDEX sigset_t;

typedef struct {
	u64 key[2];
} ATTR_PRESERVE_ACCESS_INDEX siphash_key_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct wait_queue_head wait_queue_head_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} ATTR_PRESERVE_ACCESS_INDEX socket_lock_t;

typedef struct {
	char *from;
	char *to;
} ATTR_PRESERVE_ACCESS_INDEX substring_t;

typedef struct {
	long unsigned int val;
} ATTR_PRESERVE_ACCESS_INDEX swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} ATTR_PRESERVE_ACCESS_INDEX sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} ATTR_PRESERVE_ACCESS_INDEX te1_settings;

typedef struct {
	__be16 track_information_length;
	__u8 track_lsb;
	__u8 session_lsb;
	__u8 reserved1;
	__u8 track_mode: 4;
	__u8 copy: 1;
	__u8 damage: 1;
	__u8 reserved2: 2;
	__u8 data_mode: 4;
	__u8 fp: 1;
	__u8 packet: 1;
	__u8 blank: 1;
	__u8 rt: 1;
	__u8 nwa_v: 1;
	__u8 lra_v: 1;
	__u8 reserved3: 6;
	__be32 track_start;
	__be32 next_writable;
	__be32 free_blocks;
	__be32 fixed_packet_size;
	__be32 track_size;
	__be32 last_rec_address;
} ATTR_PRESERVE_ACCESS_INDEX track_information;

typedef struct {
	int data;
	int audio;
	int cdi;
	int xa;
	long int error;
} ATTR_PRESERVE_ACCESS_INDEX tracktype;

typedef struct {
	local64_t v;
} ATTR_PRESERVE_ACCESS_INDEX u64_stats_t;

typedef struct {
	u64 m_low;
	u64 m_high;
} ATTR_PRESERVE_ACCESS_INDEX uint128_t;

typedef struct {
	__u8 b[16];
} ATTR_PRESERVE_ACCESS_INDEX uuid_t;

typedef struct {
	gid_t val;
} ATTR_PRESERVE_ACCESS_INDEX vfsgid_t;

typedef struct {
	uid_t val;
} ATTR_PRESERVE_ACCESS_INDEX vfsuid_t;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} ATTR_PRESERVE_ACCESS_INDEX x25_hdlc_proto;

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} ATTR_PRESERVE_ACCESS_INDEX in6_u;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} ATTR_PRESERVE_ACCESS_INDEX xfrm_address_t;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_frameHeader zstd_frame_header;

struct PartitionBlock {
	__be32 pb_ID;
	__be32 pb_SummedLongs;
	__be32 pb_ChkSum;
	__be32 pb_HostID;
	__be32 pb_Next;
	__be32 pb_Flags;
	__be32 pb_Reserved1[2];
	__be32 pb_DevFlags;
	__u8 pb_DriveName[32];
	__be32 pb_Reserved2[15];
	__be32 pb_Environment[17];
	__be32 pb_EReserved[15];
} ATTR_PRESERVE_ACCESS_INDEX;

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		} ATTR_PRESERVE_ACCESS_INDEX;
		struct sk_buff_list list;
	} ATTR_PRESERVE_ACCESS_INDEX;
	__u32 qlen;
	spinlock_t lock;
} ATTR_PRESERVE_ACCESS_INDEX;

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
} ATTR_PRESERVE_ACCESS_INDEX;

struct u64_stats_sync {} ATTR_PRESERVE_ACCESS_INDEX;

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
} ATTR_PRESERVE_ACCESS_INDEX;

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
} ATTR_PRESERVE_ACCESS_INDEX;

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct lock_class_key {} ATTR_PRESERVE_ACCESS_INDEX;

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	long: 64;
	long: 64;
	long: 64;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long int privdata[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
} ATTR_PRESERVE_ACCESS_INDEX;

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
} ATTR_PRESERVE_ACCESS_INDEX;

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
} ATTR_PRESERVE_ACCESS_INDEX;

struct RigidDiskBlock {
	__be32 rdb_ID;
	__be32 rdb_SummedLongs;
	__be32 rdb_ChkSum;
	__be32 rdb_HostID;
	__be32 rdb_BlockBytes;
	__be32 rdb_Flags;
	__be32 rdb_BadBlockList;
	__be32 rdb_PartitionList;
	__be32 rdb_FileSysHeaderList;
	__be32 rdb_DriveInit;
	__be32 rdb_Reserved1[6];
	__be32 rdb_Cylinders;
	__be32 rdb_Sectors;
	__be32 rdb_Heads;
	__be32 rdb_Interleave;
	__be32 rdb_Park;
	__be32 rdb_Reserved2[3];
	__be32 rdb_WritePreComp;
	__be32 rdb_ReducedWrite;
	__be32 rdb_StepRate;
	__be32 rdb_Reserved3[5];
	__be32 rdb_RDBBlocksLo;
	__be32 rdb_RDBBlocksHi;
	__be32 rdb_LoCylinder;
	__be32 rdb_HiCylinder;
	__be32 rdb_CylBlocks;
	__be32 rdb_AutoParkSeconds;
	__be32 rdb_HighRDSKBlock;
	__be32 rdb_Reserved4;
	char rdb_DiskVendor[8];
	char rdb_DiskProduct[16];
	char rdb_DiskRevision[4];
	char rdb_ControllerVendor[8];
	char rdb_ControllerProduct[16];
	char rdb_ControllerRevision[4];
	__be32 rdb_Reserved5[10];
} ATTR_PRESERVE_ACCESS_INDEX;

struct optimistic_spin_queue {
	atomic_t tail;
} ATTR_PRESERVE_ACCESS_INDEX;

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct kref {
	refcount_t refcount;
} ATTR_PRESERVE_ACCESS_INDEX;

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
} ATTR_PRESERVE_ACCESS_INDEX;

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
} ATTR_PRESERVE_ACCESS_INDEX;

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pm_message {
	int event;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct pm_message pm_message_t;

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
} ATTR_PRESERVE_ACCESS_INDEX;

struct timerqueue_node {
	struct rb_node node;
	ktime_t expires;
} ATTR_PRESERVE_ACCESS_INDEX;

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
} ATTR_PRESERVE_ACCESS_INDEX;

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
} ATTR_PRESERVE_ACCESS_INDEX;

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct device;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool async_in_progress: 1;
	bool must_resume: 1;
	bool may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
} ATTR_PRESERVE_ACCESS_INDEX;

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dev_archdata {} ATTR_PRESERVE_ACCESS_INDEX;

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct dev_pin_info;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct cma;

struct io_tlb_mem;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	u64 *dma_mask;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct cma *cma_area;
	struct io_tlb_mem *dma_io_tlb_mem;
	struct list_head dma_io_tlb_pools;
	spinlock_t dma_io_tlb_lock;
	bool dma_uses_io_tlb;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	int numa_node;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_coherent: 1;
	bool dma_skip_sync: 1;
	bool dma_iommu: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct scsi_host_template;

struct scsi_transport_template;

struct workqueue_struct;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	unsigned int no_highmem: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	long unsigned int hostdata[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_frameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef ZSTD_DDict zstd_ddict;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

struct __aio_sigset {
	const sigset_t *sigmask;
	size_t sigsetsize;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __arch_ftrace_regs {
	long unsigned int regs[9];
	long unsigned int direct_tramp;
	long unsigned int fp;
	long unsigned int lr;
	long unsigned int sp;
	long unsigned int pc;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __bridge_info {
	__u64 designated_root;
	__u64 bridge_id;
	__u32 root_path_cost;
	__u32 max_age;
	__u32 hello_time;
	__u32 forward_delay;
	__u32 bridge_max_age;
	__u32 bridge_hello_time;
	__u32 bridge_forward_delay;
	__u8 topology_change;
	__u8 topology_change_detected;
	__u8 root_port;
	__u8 stp_enabled;
	__u32 ageing_time;
	__u32 gc_interval;
	__u32 hello_timer_value;
	__u32 tcn_timer_value;
	__u32 topology_change_timer_value;
	__u32 gc_timer_value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct llist_node {
	struct llist_node *next;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __call_single_node {
	struct llist_node llist;
	union {
		unsigned int u_flags;
		atomic_t a_flags;
	} ATTR_PRESERVE_ACCESS_INDEX;
	u16 src;
	u16 dst;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void (*smp_call_func_t)(void *);

struct __call_single_data {
	struct __call_single_node node;
	smp_call_func_t func;
	void *info;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct __call_single_data call_single_data_t;

struct cpumask;

struct __cmp_key {
	const struct cpumask *cpus;
	struct cpumask ***masks;
	int node;
	int cpu;
	int w;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __compat_aio_sigset {
	compat_uptr_t sigmask;
	compat_size_t sigsetsize;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __compat_iw_event {
	__u16 len;
	__u16 cmd;
	union {
		compat_caddr_t pointer;
		struct {
			struct {} ATTR_PRESERVE_ACCESS_INDEX __empty_ptr_bytes;
			__u8 ptr_bytes[0];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __extcon_info {
	unsigned int type;
	unsigned int id;
	const char *name;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __fb_timings {
	u32 dclk;
	u32 hfreq;
	u32 vfreq;
	u32 hactive;
	u32 vactive;
	u32 hblank;
	u32 vblank;
	u32 htotal;
	u32 vtotal;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __fdb_entry {
	__u8 mac_addr[6];
	__u8 port_no;
	__u8 is_local;
	__u32 ageing_timer_value;
	__u8 port_hi;
	__u8 pad0;
	__u16 unused;
} ATTR_PRESERVE_ACCESS_INDEX;

union __fpsimd_vreg {
	__int128 unsigned raw;
	struct {
		u64 lo;
		u64 hi;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_ftr_reg;

struct __ftr_reg_entry {
	u32 sys_id;
	struct arm64_ftr_reg *reg;
} ATTR_PRESERVE_ACCESS_INDEX;

struct genradix_root;

struct __genradix {
	struct genradix_root *root;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pmu;

struct cgroup;

struct __group_key {
	int cpu;
	struct pmu *pmu;
	struct cgroup *cgroup;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __ip6_tnl_parm {
	char name[16];
	int link;
	__u8 proto;
	__u8 encap_limit;
	__u8 hop_limit;
	bool collect_md;
	__be32 flowinfo;
	__u32 flags;
	struct in6_addr laddr;
	struct in6_addr raddr;
	long unsigned int i_flags[1];
	long unsigned int o_flags[1];
	__be32 i_key;
	__be32 o_key;
	__u32 fwmark;
	__u32 index;
	__u8 erspan_ver;
	__u8 dir;
	__u16 hwid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_timespec {
	__kernel_time64_t tv_sec;
	long long int tv_nsec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_itimerspec {
	struct __kernel_timespec it_interval;
	struct __kernel_timespec it_value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_old_timeval {
	__kernel_long_t tv_sec;
	__kernel_long_t tv_usec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_old_itimerval {
	struct __kernel_old_timeval it_interval;
	struct __kernel_old_timeval it_value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_old_timespec {
	__kernel_old_time_t tv_sec;
	long int tv_nsec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_sock_timeval {
	__s64 tv_sec;
	__s64 tv_usec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_sockaddr_storage {
	union {
		struct {
			__kernel_sa_family_t ss_family;
			char __data[126];
		} ATTR_PRESERVE_ACCESS_INDEX;
		void *__align;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_timex_timeval {
	__kernel_time64_t tv_sec;
	long long int tv_usec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kernel_timex {
	unsigned int modes;
	long long int offset;
	long long int freq;
	long long int maxerror;
	long long int esterror;
	int status;
	long long int constant;
	long long int precision;
	long long int tolerance;
	struct __kernel_timex_timeval time;
	long long int tick;
	long long int ppsfreq;
	long long int jitter;
	int shift;
	long long int stabil;
	long long int jitcnt;
	long long int calcnt;
	long long int errcnt;
	long long int stbcnt;
	int tai;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __kfifo {
	unsigned int in;
	unsigned int out;
	unsigned int mask;
	unsigned int esize;
	void *data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct nft_payload {
	enum nft_payload_bases base: 8;
	u8 offset;
	u8 len;
	u8 dreg;
} ATTR_PRESERVE_ACCESS_INDEX;

struct nft_meta {
	enum nft_meta_keys key: 8;
	u8 len;
	union {
		u8 dreg;
		u8 sreg;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct nft_expr_ops;

struct __nft_expr {
	const struct nft_expr_ops *ops;
	union {
		struct nft_payload payload;
		struct nft_meta meta;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __pldm_timestamp {
	u8 b[13];
} ATTR_PRESERVE_ACCESS_INDEX;

struct __pldm_header {
	uuid_t id;
	u8 revision;
	__le16 size;
	struct __pldm_timestamp release_date;
	__le16 component_bitmap_len;
	u8 version_type;
	u8 version_len;
	u8 version_string[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct __pldmfw_component_area {
	__le16 component_image_count;
	u8 components[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct __pldmfw_component_info {
	__le16 classification;
	__le16 identifier;
	__le32 comparison_stamp;
	__le16 options;
	__le16 activation_method;
	__le32 location_offset;
	__le32 size;
	u8 version_type;
	u8 version_len;
	u8 version_string[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct __pldmfw_desc_tlv {
	__le16 type;
	__le16 size;
	u8 data[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct __pldmfw_record_area {
	u8 record_count;
	u8 records[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct __pldmfw_record_info {
	__le16 record_len;
	u8 descriptor_count;
	__le32 device_update_flags;
	u8 version_type;
	u8 version_len;
	__le16 package_data_len;
	u8 variable_record_data[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct __port_info {
	__u64 designated_root;
	__u64 designated_bridge;
	__u16 port_id;
	__u16 designated_port;
	__u32 path_cost;
	__u32 designated_cost;
	__u8 state;
	__u8 top_change_ack;
	__u8 config_pending;
	__u8 unused0;
	__u32 message_age_timer_value;
	__u32 forward_delay_timer_value;
	__u32 hold_timer_value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct net_device;

struct __rt6_probe_work {
	struct work_struct work;
	struct in6_addr target;
	struct net_device *dev;
	netdevice_tracker dev_tracker;
} ATTR_PRESERVE_ACCESS_INDEX;

union sigval {
	int sival_int;
	void *sival_ptr;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef union sigval sigval_t;

union __sifields {
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
	} ATTR_PRESERVE_ACCESS_INDEX _kill;
	struct {
		__kernel_timer_t _tid;
		int _overrun;
		sigval_t _sigval;
		int _sys_private;
	} ATTR_PRESERVE_ACCESS_INDEX _timer;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		sigval_t _sigval;
	} ATTR_PRESERVE_ACCESS_INDEX _rt;
	struct {
		__kernel_pid_t _pid;
		__kernel_uid32_t _uid;
		int _status;
		__kernel_clock_t _utime;
		__kernel_clock_t _stime;
	} ATTR_PRESERVE_ACCESS_INDEX _sigchld;
	struct {
		void *_addr;
		union {
			int _trapno;
			short int _addr_lsb;
			struct {
				char _dummy_bnd[8];
				void *_lower;
				void *_upper;
			} ATTR_PRESERVE_ACCESS_INDEX _addr_bnd;
			struct {
				char _dummy_pkey[8];
				__u32 _pkey;
			} ATTR_PRESERVE_ACCESS_INDEX _addr_pkey;
			struct {
				long unsigned int _data;
				__u32 _type;
				__u32 _flags;
			} ATTR_PRESERVE_ACCESS_INDEX _perf;
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX _sigfault;
	struct {
		long int _band;
		int _fd;
	} ATTR_PRESERVE_ACCESS_INDEX _sigpoll;
	struct {
		void *_call_addr;
		int _syscall;
		unsigned int _arch;
	} ATTR_PRESERVE_ACCESS_INDEX _sigsys;
} ATTR_PRESERVE_ACCESS_INDEX;

struct bpf_flow_keys;

struct bpf_sock;

struct __sk_buff {
	__u32 len;
	__u32 pkt_type;
	__u32 mark;
	__u32 queue_mapping;
	__u32 protocol;
	__u32 vlan_present;
	__u32 vlan_tci;
	__u32 vlan_proto;
	__u32 priority;
	__u32 ingress_ifindex;
	__u32 ifindex;
	__u32 tc_index;
	__u32 cb[5];
	__u32 hash;
	__u32 tc_classid;
	__u32 data;
	__u32 data_end;
	__u32 napi_id;
	__u32 family;
	__u32 remote_ip4;
	__u32 local_ip4;
	__u32 remote_ip6[4];
	__u32 local_ip6[4];
	__u32 remote_port;
	__u32 local_port;
	__u32 data_meta;
	union {
		struct bpf_flow_keys *flow_keys;
	} ATTR_PRESERVE_ACCESS_INDEX;
	__u64 tstamp;
	__u32 wire_len;
	__u32 gso_segs;
	union {
		struct bpf_sock *sk;
	} ATTR_PRESERVE_ACCESS_INDEX;
	__u32 gso_size;
	__u8 tstamp_type;
	__u64 hwtstamp;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dentry;

struct __track_dentry_update_args {
	struct dentry *dentry;
	int op;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __track_range_args {
	ext4_lblk_t start;
	ext4_lblk_t end;
} ATTR_PRESERVE_ACCESS_INDEX;

union __u128_halves {
	u128 full;
	struct {
		u64 low;
		u64 high;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __una_u32 {
	u32 x;
} ATTR_PRESERVE_ACCESS_INDEX;

struct inode;

struct __uprobe_key {
	struct inode *inode;
	loff_t offset;
} ATTR_PRESERVE_ACCESS_INDEX;

struct __user_cap_data_struct {
	__u32 effective;
	__u32 permitted;
	__u32 inheritable;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct __user_cap_data_struct *cap_user_data_t;

struct __user_cap_header_struct {
	__u32 version;
	int pid;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct __user_cap_header_struct *cap_user_header_t;

struct __va_list {
	void *__stack;
	void *__gr_top;
	void *__vr_top;
	int __gr_offs;
	int __vr_offs;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct __va_list va_list;

struct _aarch64_ctx {
	__u32 magic;
	__u32 size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _bpf_dtab_netdev {
	struct net_device *dev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _ccu_mult {
	long unsigned int mult;
	long unsigned int min;
	long unsigned int max;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _ccu_nk {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int k;
	long unsigned int min_k;
	long unsigned int max_k;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _ccu_nkm {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int k;
	long unsigned int min_k;
	long unsigned int max_k;
	long unsigned int m;
	long unsigned int min_m;
	long unsigned int max_m;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _ccu_nkmp {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int k;
	long unsigned int min_k;
	long unsigned int max_k;
	long unsigned int m;
	long unsigned int min_m;
	long unsigned int max_m;
	long unsigned int p;
	long unsigned int min_p;
	long unsigned int max_p;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _ccu_nm {
	long unsigned int n;
	long unsigned int min_n;
	long unsigned int max_n;
	long unsigned int m;
	long unsigned int min_m;
	long unsigned int max_m;
} ATTR_PRESERVE_ACCESS_INDEX;

struct jump_entry;

struct static_key_mod;

struct static_key {
	atomic_t enabled;
	union {
		long unsigned int type;
		struct jump_entry *entries;
		struct static_key_mod *next;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct static_key_true {
	struct static_key key;
} ATTR_PRESERVE_ACCESS_INDEX;

struct static_key_false {
	struct static_key key;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _ddebug {
	const char *modname;
	const char *function;
	const char *filename;
	const char *format;
	unsigned int lineno: 18;
	unsigned int class_id: 6;
	unsigned int flags: 8;
	union {
		struct static_key_true dd_key_true;
		struct static_key_false dd_key_false;
	} ATTR_PRESERVE_ACCESS_INDEX key;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ddebug_class_map;

struct _ddebug_info {
	struct _ddebug *descs;
	struct ddebug_class_map *classes;
	unsigned int num_descs;
	unsigned int num_classes;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _flow_keys_digest_data {
	__be16 n_proto;
	u8 ip_proto;
	u8 padding;
	__be32 ports;
	__be32 src;
	__be32 dst;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _gpiochip_for_each_data {
	const char **label;
	unsigned int *i;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct _gpiochip_for_each_data class__gpiochip_for_each_data_t;

struct _gpt_entry_attributes {
	u64 required_to_function: 1;
	u64 reserved: 47;
	u64 type_guid_specific: 16;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct _gpt_entry_attributes gpt_entry_attributes;

struct _gpt_entry {
	efi_guid_t partition_type_guid;
	efi_guid_t unique_partition_guid;
	__le64 starting_lba;
	__le64 ending_lba;
	gpt_entry_attributes attributes;
	__le16 partition_name[36];
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct _gpt_entry gpt_entry;

struct _gpt_header {
	__le64 signature;
	__le32 revision;
	__le32 header_size;
	__le32 header_crc32;
	__le32 reserved1;
	__le64 my_lba;
	__le64 alternate_lba;
	__le64 first_usable_lba;
	__le64 last_usable_lba;
	efi_guid_t disk_guid;
	__le64 partition_entry_lba;
	__le32 num_partition_entries;
	__le32 sizeof_partition_entry;
	__le32 partition_entry_array_crc32;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

typedef struct _gpt_header gpt_header;

struct _gpt_mbr_record {
	u8 boot_indicator;
	u8 start_head;
	u8 start_sector;
	u8 start_track;
	u8 os_type;
	u8 end_head;
	u8 end_sector;
	u8 end_track;
	__le32 starting_lba;
	__le32 size_in_lba;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct _gpt_mbr_record gpt_mbr_record;

struct kvm_io_device_ops;

struct kvm_io_device {
	const struct kvm_io_device_ops *ops;
} ATTR_PRESERVE_ACCESS_INDEX;

struct eventfd_ctx;

struct _ioeventfd {
	struct list_head list;
	u64 addr;
	int length;
	struct eventfd_ctx *eventfd;
	u64 datamatch;
	struct kvm_io_device dev;
	u8 bus_idx;
	bool wildcard;
} ATTR_PRESERVE_ACCESS_INDEX;

struct kvm_stats_desc {
	__u32 flags;
	__s16 exponent;
	__u16 size;
	__u32 offset;
	__u32 bucket_size;
	char name[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct _kvm_stats_desc {
	struct kvm_stats_desc desc;
	char name[48];
} ATTR_PRESERVE_ACCESS_INDEX;

struct _legacy_mbr {
	u8 boot_code[440];
	__le32 unique_mbr_signature;
	__le16 unknown;
	gpt_mbr_record partition_record[4];
	__le16 signature;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

typedef struct _legacy_mbr legacy_mbr;

struct strp_msg {
	int full_len;
	int offset;
} ATTR_PRESERVE_ACCESS_INDEX;

struct _strp_msg {
	struct strp_msg strp;
	int accum_len;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aarch64_insn_patch {
	void **text_addrs;
	u32 *new_insns;
	int insn_cnt;
	atomic_t cpu_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct seq_net_private {
	struct net *net;
	netns_tracker ns_tracker;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ac6_iter_state {
	struct seq_net_private p;
	struct net_device *dev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct access_coordinate {
	unsigned int read_bandwidth;
	unsigned int write_bandwidth;
	unsigned int read_latency;
	unsigned int write_latency;
} ATTR_PRESERVE_ACCESS_INDEX;

struct access_masks {
	access_mask_t fs: 16;
	access_mask_t net: 2;
	access_mask_t scope: 2;
} ATTR_PRESERVE_ACCESS_INDEX;

union access_masks_all {
	struct access_masks masks;
	u32 all;
} ATTR_PRESERVE_ACCESS_INDEX;

struct access_report_info {
	struct callback_head work;
	const char *access;
	struct task_struct *target;
	struct task_struct *agent;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acct_v3 {
	char ac_flag;
	char ac_version;
	__u16 ac_tty;
	__u32 ac_exitcode;
	__u32 ac_uid;
	__u32 ac_gid;
	__u32 ac_pid;
	__u32 ac_ppid;
	__u32 ac_btime;
	__u32 ac_etime;
	comp_t ac_utime;
	comp_t ac_stime;
	comp_t ac_mem;
	comp_t ac_io;
	comp_t ac_rw;
	comp_t ac_minflt;
	comp_t ac_majflt;
	comp_t ac_swaps;
	char ac_comm[16];
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct acct_v3 acct_t;

struct ack_sample {
	u32 pkts_acked;
	s32 rtt_us;
	u32 in_flight;
} ATTR_PRESERVE_ACCESS_INDEX;

struct crypto_tfm;

struct cipher_alg {
	unsigned int cia_min_keysize;
	unsigned int cia_max_keysize;
	int (*cia_setkey)(struct crypto_tfm *, const u8 *, unsigned int);
	void (*cia_encrypt)(struct crypto_tfm *, u8 *, const u8 *);
	void (*cia_decrypt)(struct crypto_tfm *, u8 *, const u8 *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct compress_alg {
	int (*coa_compress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
	int (*coa_decompress)(struct crypto_tfm *, const u8 *, unsigned int, u8 *, unsigned int *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct crypto_type;

struct crypto_alg {
	struct list_head cra_list;
	struct list_head cra_users;
	u32 cra_flags;
	unsigned int cra_blocksize;
	unsigned int cra_ctxsize;
	unsigned int cra_alignmask;
	int cra_priority;
	refcount_t cra_refcnt;
	char cra_name[128];
	char cra_driver_name[128];
	const struct crypto_type *cra_type;
	union {
		struct cipher_alg cipher;
		struct compress_alg compress;
	} ATTR_PRESERVE_ACCESS_INDEX cra_u;
	int (*cra_init)(struct crypto_tfm *);
	void (*cra_exit)(struct crypto_tfm *);
	void (*cra_destroy)(struct crypto_alg *);
	struct module *cra_module;
} ATTR_PRESERVE_ACCESS_INDEX;

struct comp_alg_common {
	struct crypto_alg base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acomp_req;

struct scatterlist;

struct crypto_acomp;

struct acomp_alg {
	int (*compress)(struct acomp_req *);
	int (*decompress)(struct acomp_req *);
	void (*dst_free)(struct scatterlist *);
	int (*init)(struct crypto_acomp *);
	void (*exit)(struct crypto_acomp *);
	unsigned int reqsize;
	union {
		struct {
			struct crypto_alg base;
		} ATTR_PRESERVE_ACCESS_INDEX;
		struct comp_alg_common calg;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void (*crypto_completion_t)(void *, int);

struct crypto_async_request {
	struct list_head list;
	crypto_completion_t complete;
	void *data;
	struct crypto_tfm *tfm;
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acomp_req {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int slen;
	unsigned int dlen;
	u32 flags;
	void *__ctx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct power_supply;

union power_supply_propval;

struct power_supply_desc {
	const char *name;
	enum power_supply_type type;
	u8 charge_behaviours;
	u32 usb_types;
	const enum power_supply_property *properties;
	size_t num_properties;
	int (*get_property)(struct power_supply *, enum power_supply_property, union power_supply_propval *);
	int (*set_property)(struct power_supply *, enum power_supply_property, const union power_supply_propval *);
	int (*property_is_writeable)(struct power_supply *, enum power_supply_property);
	void (*external_power_changed)(struct power_supply *);
	void (*set_charged)(struct power_supply *);
	bool no_thermal;
	int use_for_apm;
} ATTR_PRESERVE_ACCESS_INDEX;

struct notifier_block;

typedef int (*notifier_fn_t)(struct notifier_block *, long unsigned int, void *);

struct notifier_block {
	notifier_fn_t notifier_call;
	struct notifier_block *next;
	int priority;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device;

struct acpi_ac {
	struct power_supply *charger;
	struct power_supply_desc charger_desc;
	struct acpi_device *device;
	long long unsigned int state;
	struct notifier_block battery_nb;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_address16_attribute {
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_address32_attribute {
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_address64_attribute {
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_namespace_node;

struct acpi_address_range {
	struct acpi_address_range *next;
	struct acpi_namespace_node *region_node;
	acpi_physical_address start_address;
	acpi_physical_address end_address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_apmt_node {
	u16 length;
	u8 flags;
	u8 type;
	u32 id;
	u64 inst_primary;
	u32 inst_secondary;
	u64 base_address0;
	u64 base_address1;
	u32 ovflw_irq;
	u32 reserved;
	u32 ovflw_irq_flags;
	u32 proc_affinity;
	u32 impl_id;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_battery {
	struct mutex lock;
	struct mutex sysfs_lock;
	struct power_supply *bat;
	struct power_supply_desc bat_desc;
	struct acpi_device *device;
	struct notifier_block pm_nb;
	struct list_head list;
	long unsigned int update_time;
	int revision;
	int rate_now;
	int capacity_now;
	int voltage_now;
	int design_capacity;
	int full_charge_capacity;
	int technology;
	int design_voltage;
	int design_capacity_warning;
	int design_capacity_low;
	int cycle_count;
	int measurement_accuracy;
	int max_sampling_time;
	int min_sampling_time;
	int max_averaging_interval;
	int min_averaging_interval;
	int capacity_granularity_1;
	int capacity_granularity_2;
	int alarm;
	char model_number[64];
	char serial_number[64];
	char type[64];
	char oem_info[64];
	int state;
	int power_unit;
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_battery_hook {
	const char *name;
	int (*add_battery)(struct power_supply *, struct acpi_battery_hook *);
	int (*remove_battery)(struct power_supply *, struct acpi_battery_hook *);
	struct list_head list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_bert_region {
	u32 block_status;
	u32 raw_data_offset;
	u32 raw_data_length;
	u32 data_length;
	u32 error_severity;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_buffer {
	acpi_size length;
	void *pointer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_bus_event {
	struct list_head node;
	acpi_device_class device_class;
	acpi_bus_id bus_id;
	u32 type;
	u32 data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_bus_type {
	struct list_head list;
	const char *name;
	bool (*match)(struct device *);
	struct acpi_device * (*find_companion)(struct device *);
	void (*setup)(struct device *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cdat_dslbis {
	u8 handle;
	u8 flags;
	u8 data_type;
	u8 reserved;
	u64 entry_base_unit;
	u16 entry[3];
	u16 reserved2;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cdat_dsmas {
	u8 dsmad_handle;
	u8 flags;
	u16 reserved;
	u64 dpa_base_address;
	u64 dpa_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cdat_header {
	u8 type;
	u8 reserved;
	u16 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cdat_sslbe {
	u16 portx_id;
	u16 porty_id;
	u16 latency_or_bandwidth;
	u16 reserved;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cdat_sslbis {
	u8 data_type;
	u8 reserved[3];
	u64 entry_base_unit;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cdat_sslbis_table {
	struct acpi_cdat_header header;
	struct acpi_cdat_sslbis sslbis_header;
	struct acpi_cdat_sslbe entries[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cedt_header {
	u8 type;
	u8 reserved;
	u16 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cedt_cfmws {
	struct acpi_cedt_header header;
	u32 reserved1;
	u64 base_hpa;
	u64 window_size;
	u8 interleave_ways;
	u8 interleave_arithmetic;
	u16 reserved2;
	u32 granularity;
	u16 restrictions;
	u16 qtg_id;
	u32 interleave_targets[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cedt_chbs {
	struct acpi_cedt_header header;
	u32 uid;
	u32 cxl_version;
	u32 reserved;
	u64 base;
	u64 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_cedt_cxims {
	struct acpi_cedt_header header;
	u16 reserved1;
	u8 hbig;
	u8 nr_xormaps;
	u64 xormap_list[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_comment_node {
	char *comment;
	struct acpi_comment_node *next;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_common_descriptor {
	void *common_pointer;
	u8 descriptor_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_common_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_connection_info {
	u8 *connection;
	u16 length;
	u8 access_length;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_parse_object;

struct acpi_control_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u16 opcode;
	union acpi_parse_object *predicate_op;
	u8 *aml_predicate_start;
	u8 *package_end;
	u64 loop_timeout;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_create_field_info {
	struct acpi_namespace_node *region_node;
	struct acpi_namespace_node *field_node;
	struct acpi_namespace_node *register_node;
	struct acpi_namespace_node *data_register_node;
	struct acpi_namespace_node *connection_node;
	u8 *resource_buffer;
	u32 bank_value;
	u32 field_bit_position;
	u32 field_bit_length;
	u16 resource_length;
	u16 pin_number_index;
	u8 field_flags;
	u8 attribute;
	u8 field_type;
	u8 access_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_csrt_group {
	u32 length;
	u32 vendor_id;
	u32 subvendor_id;
	u16 device_id;
	u16 subdevice_id;
	u16 revision;
	u16 reserved;
	u32 shared_info_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_csrt_shared_info {
	u16 major_version;
	u16 minor_version;
	u32 mmio_base_low;
	u32 mmio_base_high;
	u32 gsi_interrupt;
	u8 interrupt_polarity;
	u8 interrupt_mode;
	u8 num_channels;
	u8 dma_address_width;
	u16 base_request_line;
	u16 num_handshake_signals;
	u32 max_block_size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct attribute {
	const char *name;
	umode_t mode;
} ATTR_PRESERVE_ACCESS_INDEX;

struct address_space;

struct file;

struct vm_area_struct;

struct bin_attribute {
	struct attribute attr;
	size_t size;
	void *private;
	struct address_space * (*f_mapping)(void);
	ssize_t (*read)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*read_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write)(struct file *, struct kobject *, struct bin_attribute *, char *, loff_t, size_t);
	ssize_t (*write_new)(struct file *, struct kobject *, const struct bin_attribute *, char *, loff_t, size_t);
	loff_t (*llseek)(struct file *, struct kobject *, const struct bin_attribute *, loff_t, int);
	int (*mmap)(struct file *, struct kobject *, const struct bin_attribute *, struct vm_area_struct *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_data_attr {
	struct bin_attribute attr;
	u64 addr;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void *acpi_handle;

struct fwnode_operations;

struct fwnode_handle {
	struct fwnode_handle *secondary;
	const struct fwnode_operations *ops;
	struct device *dev;
	struct list_head suppliers;
	struct list_head consumers;
	u8 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_object;

struct acpi_device_data {
	const union acpi_object *pointer;
	struct list_head properties;
	const union acpi_object *of_compatible;
	struct list_head subnodes;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_data_node {
	struct list_head sibling;
	const char *name;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct fwnode_handle *parent;
	struct acpi_device_data data;
	struct kobject kobj;
	struct completion kobj_done;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_data_node_attr {
	struct attribute attr;
	ssize_t (*show)(struct acpi_data_node *, char *);
	ssize_t (*store)(struct acpi_data_node *, const char *, size_t);
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_data_obj {
	char *name;
	int (*fn)(void *, struct acpi_data_attr *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_data_table_mapping {
	void *pointer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_dep_data {
	struct list_head node;
	acpi_handle supplier;
	acpi_handle consumer;
	bool honor_dep;
	bool met;
	bool free_when_met;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_operand_object;

struct acpi_object_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_integer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 fill[3];
	u64 value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_string {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	char *pointer;
	u32 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_buffer {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 *pointer;
	u32 length;
	u32 aml_length;
	u8 *aml_start;
	struct acpi_namespace_node *node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_package {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	union acpi_operand_object **elements;
	u8 *aml_start;
	u32 aml_length;
	u32 count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_event {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	void *os_semaphore;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_walk_state;

typedef acpi_status (*acpi_internal_method)(struct acpi_walk_state *);

struct acpi_object_method {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 info_flags;
	u8 param_count;
	u8 sync_level;
	union acpi_operand_object *mutex;
	union acpi_operand_object *node;
	u8 *aml_start;
	union {
		acpi_internal_method implementation;
		union acpi_operand_object *handler;
	} ATTR_PRESERVE_ACCESS_INDEX dispatch;
	u32 aml_length;
	acpi_owner_id owner_id;
	u8 thread_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_thread_state;

struct acpi_object_mutex {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 sync_level;
	u16 acquisition_depth;
	void *os_mutex;
	u64 thread_id;
	struct acpi_thread_state *owner_thread;
	union acpi_operand_object *prev;
	union acpi_operand_object *next;
	struct acpi_namespace_node *node;
	u8 original_sync_level;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_region {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler;
	union acpi_operand_object *next;
	acpi_physical_address address;
	u32 length;
	void *pointer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_notify_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_block_info;

struct acpi_object_device {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	struct acpi_gpe_block_info *gpe_block;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_power_resource {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	u32 system_level;
	u32 resource_order;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_processor {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 proc_id;
	u8 length;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
	acpi_io_address address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_thermal_zone {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *notify_list[2];
	union acpi_operand_object *handler;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_field_common {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_region_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u16 resource_length;
	union acpi_operand_object *region_obj;
	u8 *resource_buffer;
	u16 pin_number_index;
	u8 *internal_pcc_buffer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_buffer_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	u8 is_create_field;
	union acpi_operand_object *buffer_obj;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_bank_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *region_obj;
	union acpi_operand_object *bank_obj;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_index_field {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 field_flags;
	u8 attribute;
	u8 access_byte_width;
	struct acpi_namespace_node *node;
	u32 bit_length;
	u32 base_byte_offset;
	u32 value;
	u8 start_field_bit_offset;
	u8 access_length;
	union acpi_operand_object *index_obj;
	union acpi_operand_object *data_obj;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void (*acpi_notify_handler)(acpi_handle, u32, void *);

struct acpi_object_notify_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *node;
	u32 handler_type;
	acpi_notify_handler handler;
	void *context;
	union acpi_operand_object *next[2];
} ATTR_PRESERVE_ACCESS_INDEX;

typedef acpi_status (*acpi_adr_space_handler)(u32, acpi_physical_address, u32, u64 *, void *, void *);

typedef acpi_status (*acpi_adr_space_setup)(acpi_handle, u32, void *, void **);

struct acpi_object_addr_handler {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 space_id;
	u8 handler_flags;
	acpi_adr_space_handler handler;
	struct acpi_namespace_node *node;
	void *context;
	void *context_mutex;
	acpi_adr_space_setup setup;
	union acpi_operand_object *region_list;
	union acpi_operand_object *next;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_reference {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	u8 class;
	u8 target_type;
	u8 resolved;
	void *object;
	struct acpi_namespace_node *node;
	union acpi_operand_object **where;
	u8 *index_pointer;
	u8 *aml;
	u32 value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_extra {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	struct acpi_namespace_node *method_REG;
	struct acpi_namespace_node *scope_node;
	void *region_context;
	u8 *aml_start;
	u32 aml_length;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void (*acpi_object_handler)(acpi_handle, void *);

struct acpi_object_data {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	acpi_object_handler handler;
	void *pointer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_cache_list {
	union acpi_operand_object *next_object;
	u8 descriptor_type;
	u8 type;
	u16 reference_count;
	u8 flags;
	union acpi_operand_object *next;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_name_union {
	u32 integer;
	char ascii[4];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_namespace_node {
	union acpi_operand_object *object;
	u8 descriptor_type;
	u8 type;
	u16 flags;
	union acpi_name_union name;
	struct acpi_namespace_node *parent;
	struct acpi_namespace_node *child;
	struct acpi_namespace_node *peer;
	acpi_owner_id owner_id;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_operand_object {
	struct acpi_object_common common;
	struct acpi_object_integer integer;
	struct acpi_object_string string;
	struct acpi_object_buffer buffer;
	struct acpi_object_package package;
	struct acpi_object_event event;
	struct acpi_object_method method;
	struct acpi_object_mutex mutex;
	struct acpi_object_region region;
	struct acpi_object_notify_common common_notify;
	struct acpi_object_device device;
	struct acpi_object_power_resource power_resource;
	struct acpi_object_processor processor;
	struct acpi_object_thermal_zone thermal_zone;
	struct acpi_object_field_common common_field;
	struct acpi_object_region_field field;
	struct acpi_object_buffer_field buffer_field;
	struct acpi_object_bank_field bank_field;
	struct acpi_object_index_field index_field;
	struct acpi_object_notify_handler notify;
	struct acpi_object_addr_handler address_space;
	struct acpi_object_reference reference;
	struct acpi_object_extra extra;
	struct acpi_object_data data;
	struct acpi_object_cache_list cache;
	struct acpi_namespace_node node;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_parse_value {
	u64 integer;
	u32 size;
	char *string;
	u8 *buffer;
	char *name;
	union acpi_parse_object *arg;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_parse_obj_common {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_parse_obj_named {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	char *path;
	u8 *data;
	u32 length;
	u32 name;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_parse_obj_asl {
	union acpi_parse_object *parent;
	u8 descriptor_type;
	u8 flags;
	u16 aml_opcode;
	u8 *aml;
	union acpi_parse_object *next;
	struct acpi_namespace_node *node;
	union acpi_parse_value value;
	u8 arg_list_length;
	union acpi_parse_object *child;
	union acpi_parse_object *parent_method;
	char *filename;
	u8 file_changed;
	char *parent_filename;
	char *external_name;
	char *namepath;
	char name_seg[4];
	u32 extra_value;
	u32 column;
	u32 line_number;
	u32 logical_line_number;
	u32 logical_byte_offset;
	u32 end_line;
	u32 end_logical_line;
	u32 acpi_btype;
	u32 aml_length;
	u32 aml_subtree_length;
	u32 final_aml_length;
	u32 final_aml_offset;
	u32 compile_flags;
	u16 parse_opcode;
	u8 aml_opcode_length;
	u8 aml_pkg_len_bytes;
	u8 extra;
	char parse_op_name[20];
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_parse_object {
	struct acpi_parse_obj_common common;
	struct acpi_parse_obj_named named;
	struct acpi_parse_obj_asl asl;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_descriptor {
	struct acpi_common_descriptor common;
	union acpi_operand_object object;
	struct acpi_namespace_node node;
	union acpi_parse_object op;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_id {
	__u8 id[16];
	kernel_ulong_t driver_data;
	__u32 cls;
	__u32 cls_msk;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_dev_match_info {
	struct acpi_device_id hid[2];
	const char *uid;
	s64 hrv;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_dev_walk_context {
	int (*fn)(struct acpi_device *, void *);
	void *data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_status {
	u32 present: 1;
	u32 enabled: 1;
	u32 show_in_ui: 1;
	u32 functional: 1;
	u32 battery_present: 1;
	u32 reserved: 27;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_flags {
	u32 dynamic_status: 1;
	u32 removable: 1;
	u32 ejectable: 1;
	u32 power_manageable: 1;
	u32 match_driver: 1;
	u32 initialized: 1;
	u32 visited: 1;
	u32 hotplug_notify: 1;
	u32 is_dock_station: 1;
	u32 of_compatible_ok: 1;
	u32 coherent_dma: 1;
	u32 cca_seen: 1;
	u32 enumeration_by_parent: 1;
	u32 honor_deps: 1;
	u32 reserved: 18;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pnp_type {
	u32 hardware_id: 1;
	u32 bus_address: 1;
	u32 platform_id: 1;
	u32 backlight: 1;
	u32 reserved: 28;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_pnp {
	acpi_bus_id bus_id;
	int instance_no;
	struct acpi_pnp_type type;
	acpi_bus_address bus_address;
	char *unique_id;
	struct list_head ids;
	acpi_device_name device_name;
	acpi_device_class device_class;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_power_flags {
	u32 explicit_get: 1;
	u32 power_resources: 1;
	u32 inrush_current: 1;
	u32 power_removed: 1;
	u32 ignore_parent: 1;
	u32 dsw_present: 1;
	u32 reserved: 26;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_power_state {
	struct list_head resources;
	struct {
		u8 valid: 1;
		u8 explicit_set: 1;
		u8 reserved: 6;
	} ATTR_PRESERVE_ACCESS_INDEX flags;
	int power;
	int latency;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_power {
	int state;
	struct acpi_device_power_flags flags;
	struct acpi_device_power_state states[5];
	u8 state_for_enumeration;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_wakeup_flags {
	u8 valid: 1;
	u8 notifier_present: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_wakeup_context {
	void (*func)(struct acpi_device_wakeup_context *);
	struct device *dev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_wakeup {
	acpi_handle gpe_device;
	u64 gpe_number;
	u64 sleep_state;
	struct list_head resources;
	struct acpi_device_wakeup_flags flags;
	struct acpi_device_wakeup_context context;
	struct wakeup_source *ws;
	int prepare_count;
	int enable_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_perf_flags {
	u8 reserved: 8;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_perf_state;

struct acpi_device_perf {
	int state;
	struct acpi_device_perf_flags flags;
	int state_count;
	struct acpi_device_perf_state *states;
} ATTR_PRESERVE_ACCESS_INDEX;

struct proc_dir_entry;

struct acpi_device_dir {
	struct proc_dir_entry *entry;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_scan_handler;

struct acpi_hotplug_context;

struct acpi_device_software_nodes;

struct acpi_gpio_mapping;

struct acpi_device {
	u32 pld_crc;
	int device_type;
	acpi_handle handle;
	struct fwnode_handle fwnode;
	struct list_head wakeup_list;
	struct list_head del_list;
	struct acpi_device_status status;
	struct acpi_device_flags flags;
	struct acpi_device_pnp pnp;
	struct acpi_device_power power;
	struct acpi_device_wakeup wakeup;
	struct acpi_device_perf performance;
	struct acpi_device_dir dir;
	struct acpi_device_data data;
	struct acpi_scan_handler *handler;
	struct acpi_hotplug_context *hp;
	struct acpi_device_software_nodes *swnodes;
	const struct acpi_gpio_mapping *driver_gpios;
	void *driver_data;
	struct device dev;
	unsigned int physical_node_count;
	unsigned int dep_unmet;
	struct list_head physical_node_list;
	struct mutex physical_node_lock;
	void (*remove)(struct acpi_device *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct xarray {
	spinlock_t xa_lock;
	gfp_t xa_flags;
	void *xa_head;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ida {
	struct xarray xa;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_bus_id {
	const char *bus_id;
	struct ida instance_ida;
	struct list_head node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pnp_device_id {
	u32 length;
	char *string;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pnp_device_id_list {
	u32 count;
	u32 list_size;
	struct acpi_pnp_device_id ids[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_info {
	u32 info_size;
	u32 name;
	acpi_object_type type;
	u8 param_count;
	u16 valid;
	u8 flags;
	u8 highest_dstates[4];
	u8 lowest_dstates[5];
	u64 address;
	struct acpi_pnp_device_id hardware_id;
	struct acpi_pnp_device_id unique_id;
	struct acpi_pnp_device_id class_code;
	struct acpi_pnp_device_id_list compatible_id_list;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int (*acpi_op_add)(struct acpi_device *);

typedef void (*acpi_op_remove)(struct acpi_device *);

typedef void (*acpi_op_notify)(struct acpi_device *, u32);

struct acpi_device_ops {
	acpi_op_add add;
	acpi_op_remove remove;
	acpi_op_notify notify;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_perf_state {
	struct {
		u8 valid: 1;
		u8 reserved: 7;
	} ATTR_PRESERVE_ACCESS_INDEX flags;
	u8 power;
	u8 performance;
	int latency;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_physical_node {
	struct list_head node;
	struct device *dev;
	unsigned int node_id;
	bool put_online: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_properties {
	struct list_head list;
	const guid_t *guid;
	union acpi_object *properties;
	void **bufs;
} ATTR_PRESERVE_ACCESS_INDEX;

struct property_entry {
	const char *name;
	size_t length;
	bool is_inline;
	enum dev_prop_type type;
	union {
		const void *pointer;
		union {
			u8 u8_data[8];
			u16 u16_data[4];
			u32 u32_data[2];
			u64 u64_data[1];
			const char *str[1];
		} ATTR_PRESERVE_ACCESS_INDEX value;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct software_node;

struct software_node_ref_args {
	const struct software_node *node;
	unsigned int nargs;
	u64 args[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_software_node_port {
	char port_name[9];
	u32 data_lanes[8];
	u32 lane_polarities[9];
	u64 link_frequencies[8];
	unsigned int port_nr;
	bool crs_csi2_local;
	struct property_entry port_props[2];
	struct property_entry ep_props[8];
	struct software_node_ref_args remote_ep[1];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_device_software_nodes {
	struct property_entry dev_props[6];
	struct software_node *nodes;
	const struct software_node **nodeptrs;
	struct acpi_device_software_node_port *ports;
	unsigned int num_ports;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_desc;

struct acpi_evaluate_info;

struct acpi_device_walk_info {
	struct acpi_table_desc *table_desc;
	struct acpi_evaluate_info *evaluate_info;
	u32 device_count;
	u32 num_STA;
	u32 num_INI;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dma_chan;

struct acpi_dma_spec;

struct acpi_dma {
	struct list_head dma_controllers;
	struct device *dev;
	struct dma_chan * (*acpi_dma_xlate)(struct acpi_dma_spec *, struct acpi_dma *);
	void *data;
	short unsigned int base_request_line;
	short unsigned int end_request_line;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef bool (*dma_filter_fn)(struct dma_chan *, void *);

struct acpi_dma_filter_info {
	dma_cap_mask_t dma_cap;
	dma_filter_fn filter_fn;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_dma_spec {
	int chan_id;
	int slave_id;
	struct device *dev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_dma_parser_data {
	struct acpi_dma_spec dma_spec;
	size_t index;
	size_t n;
} ATTR_PRESERVE_ACCESS_INDEX;

struct of_device_id;

struct dev_pm_ops;

struct driver_private;

struct device_driver {
	const char *name;
	const struct bus_type *bus;
	struct module *owner;
	const char *mod_name;
	bool suppress_bind_attrs;
	enum probe_type probe_type;
	const struct of_device_id *of_match_table;
	const struct acpi_device_id *acpi_match_table;
	int (*probe)(struct device *);
	void (*sync_state)(struct device *);
	int (*remove)(struct device *);
	void (*shutdown)(struct device *);
	int (*suspend)(struct device *, pm_message_t);
	int (*resume)(struct device *);
	const struct attribute_group **groups;
	const struct attribute_group **dev_groups;
	const struct dev_pm_ops *pm;
	void (*coredump)(struct device *);
	struct driver_private *p;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_driver {
	char name[80];
	char class[80];
	const struct acpi_device_id *ids;
	unsigned int flags;
	struct acpi_device_ops ops;
	struct device_driver drv;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_predefined_info;

struct acpi_evaluate_info {
	struct acpi_namespace_node *prefix_node;
	const char *relative_pathname;
	union acpi_operand_object **parameters;
	struct acpi_namespace_node *node;
	union acpi_operand_object *obj_desc;
	char *full_pathname;
	const union acpi_predefined_info *predefined;
	union acpi_operand_object *return_object;
	union acpi_operand_object *parent_package;
	u32 return_flags;
	u32 return_btype;
	u16 param_count;
	u16 node_flags;
	u8 pass_number;
	u8 return_object_type;
	u8 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_exception_info {
	char *name;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_fadt_info {
	const char *name;
	u16 address64;
	u16 address32;
	u16 length;
	u8 default_length;
	u8 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_generic_address;

struct acpi_fadt_pm_info {
	struct acpi_generic_address *target;
	u16 source;
	u8 register_num;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_ffh_info {
	u64 offset;
	u64 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_ged_device {
	struct device *dev;
	struct list_head event_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_ged_event {
	struct list_head node;
	struct device *dev;
	unsigned int gsi;
	unsigned int irq;
	acpi_handle handle;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_ged_handler_info {
	struct acpi_ged_handler_info *next;
	u32 int_id;
	struct acpi_namespace_node *evt_method;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_generic_address {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_width;
	u64 address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_update_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *object;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_scope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	struct acpi_namespace_node *node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pscope_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 arg_count;
	union acpi_parse_object *op;
	u8 *arg_end;
	u8 *pkg_end;
	u32 arg_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pkg_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u32 index;
	union acpi_operand_object *source_object;
	union acpi_operand_object *dest_object;
	struct acpi_walk_state *walk_state;
	void *this_target_obj;
	u32 num_packages;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_thread_state {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 current_sync_level;
	struct acpi_walk_state *walk_state_list;
	union acpi_operand_object *acquired_mutex_list;
	u64 thread_id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_result_values {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	union acpi_operand_object *obj_desc[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_global_notify_handler;

struct acpi_notify_info {
	void *next;
	u8 descriptor_type;
	u8 flags;
	u16 value;
	u16 state;
	u8 handler_list_id;
	struct acpi_namespace_node *node;
	union acpi_operand_object *handler_list_head;
	struct acpi_global_notify_handler *global;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_generic_state {
	struct acpi_common_state common;
	struct acpi_control_state control;
	struct acpi_update_state update;
	struct acpi_scope_state scope;
	struct acpi_pscope_state parse_scope;
	struct acpi_pkg_state pkg;
	struct acpi_thread_state thread;
	struct acpi_result_values results;
	struct acpi_notify_info notify;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_genl_event {
	acpi_device_class device_class;
	char bus_id[15];
	u32 type;
	u32 data;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef acpi_status (*acpi_walk_callback)(acpi_handle, u32, void *, void **);

struct acpi_get_devices_info {
	acpi_walk_callback user_function;
	void *context;
	const char *hid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_global_notify_handler {
	acpi_notify_handler handler;
	void *context;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_address {
	u8 space_id;
	u64 address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_xrupt_info;

struct acpi_gpe_register_info;

struct acpi_gpe_event_info;

struct acpi_gpe_block_info {
	struct acpi_namespace_node *node;
	struct acpi_gpe_block_info *previous;
	struct acpi_gpe_block_info *next;
	struct acpi_gpe_xrupt_info *xrupt_block;
	struct acpi_gpe_register_info *register_info;
	struct acpi_gpe_event_info *event_info;
	u64 address;
	u32 register_count;
	u16 gpe_count;
	u16 block_base_number;
	u8 space_id;
	u8 initialized;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_handler_info;

struct acpi_gpe_notify_info;

union acpi_gpe_dispatch_info {
	struct acpi_namespace_node *method_node;
	struct acpi_gpe_handler_info *handler;
	struct acpi_gpe_notify_info *notify_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_event_info {
	union acpi_gpe_dispatch_info dispatch;
	struct acpi_gpe_register_info *register_info;
	u8 flags;
	u8 gpe_number;
	u8 runtime_count;
	u8 disable_for_dispatch;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef u32 (*acpi_gpe_handler)(acpi_handle, u32, void *);

struct acpi_gpe_handler_info {
	acpi_gpe_handler address;
	void *context;
	struct acpi_namespace_node *method_node;
	u8 original_flags;
	u8 originally_enabled;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_notify_info {
	struct acpi_namespace_node *device_node;
	struct acpi_gpe_notify_info *next;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_register_info {
	struct acpi_gpe_address status_address;
	struct acpi_gpe_address enable_address;
	u16 base_gpe_number;
	u8 enable_for_wake;
	u8 enable_for_run;
	u8 mask_for_run;
	u8 enable_mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpe_xrupt_info {
	struct acpi_gpe_xrupt_info *previous;
	struct acpi_gpe_xrupt_info *next;
	struct acpi_gpe_block_info *gpe_block_list_head;
	u32 interrupt_number;
} ATTR_PRESERVE_ACCESS_INDEX;

struct gpio_chip;

struct acpi_gpio_chip {
	struct acpi_connection_info conn_info;
	struct list_head conns;
	struct mutex conn_lock;
	struct gpio_chip *chip;
	struct list_head events;
	struct list_head deferred_req_irqs_list_entry;
} ATTR_PRESERVE_ACCESS_INDEX;

struct gpio_desc;

struct acpi_gpio_connection {
	struct list_head node;
	unsigned int pin;
	struct gpio_desc *desc;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef irqreturn_t (*irq_handler_t)(int, void *);

struct acpi_gpio_event {
	struct list_head node;
	acpi_handle handle;
	irq_handler_t handler;
	unsigned int pin;
	unsigned int irq;
	long unsigned int irqflags;
	bool irq_is_wake;
	bool irq_requested;
	struct gpio_desc *desc;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpio_info {
	struct acpi_device *adev;
	enum gpiod_flags flags;
	bool gpioint;
	int pin_config;
	int polarity;
	int triggering;
	bool wake_capable;
	unsigned int debounce;
	unsigned int quirks;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpio_lookup {
	struct acpi_gpio_info info;
	int index;
	u16 pin_index;
	bool active_low;
	struct gpio_desc *desc;
	int n;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpio_params;

struct acpi_gpio_mapping {
	const char *name;
	const struct acpi_gpio_params *data;
	unsigned int size;
	unsigned int quirks;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpio_params {
	unsigned int crs_entry_index;
	unsigned int line_index;
	bool active_low;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gpiolib_dmi_quirk {
	bool no_edge_events_on_boot;
	char *ignore_wake;
	char *ignore_interrupt;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_gtdt;

struct acpi_gtdt_descriptor {
	struct acpi_table_gtdt *gtdt;
	void *gtdt_end;
	void *platform_timer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gtdt_header {
	u8 type;
	u16 length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gtdt_timer_block {
	struct acpi_gtdt_header header;
	u8 reserved;
	u64 block_address;
	u32 timer_count;
	u32 timer_offset;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gtdt_timer_entry {
	u8 frame_number;
	u8 reserved[3];
	u64 base_address;
	u64 el0_base_address;
	u32 timer_interrupt;
	u32 timer_flags;
	u32 virtual_timer_interrupt;
	u32 virtual_timer_flags;
	u32 common_flags;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_gtdt_watchdog {
	struct acpi_gtdt_header header;
	u8 reserved;
	u64 refresh_frame_address;
	u64 control_frame_address;
	u32 timer_interrupt;
	u32 timer_flags;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_handle_list {
	u32 count;
	acpi_handle *handles;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hardware_id {
	struct list_head list;
	const char *id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_header {
	u16 type;
	u16 source_id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_notify {
	u8 type;
	u8 length;
	u16 config_write_enable;
	u32 poll_interval;
	u32 vector;
	u32 polling_threshold_value;
	u32 polling_threshold_window;
	u32 error_threshold_value;
	u32 error_threshold_window;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_generic {
	struct acpi_hest_header header;
	u16 related_source_id;
	u8 reserved;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u32 max_raw_data_length;
	struct acpi_generic_address error_status_address;
	struct acpi_hest_notify notify;
	u32 error_block_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_generic_data {
	u8 section_type[16];
	u32 error_severity;
	u16 revision;
	u8 validation_bits;
	u8 flags;
	u32 error_data_length;
	u8 fru_id[16];
	u8 fru_text[20];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_generic_data_v300 {
	u8 section_type[16];
	u32 error_severity;
	u16 revision;
	u8 validation_bits;
	u8 flags;
	u32 error_data_length;
	u8 fru_id[16];
	u8 fru_text[20];
	u64 time_stamp;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_generic_status {
	u32 block_status;
	u32 raw_data_offset;
	u32 raw_data_length;
	u32 data_length;
	u32 error_severity;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_generic_v2 {
	struct acpi_hest_header header;
	u16 related_source_id;
	u8 reserved;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u32 max_raw_data_length;
	struct acpi_generic_address error_status_address;
	struct acpi_hest_notify notify;
	u32 error_block_length;
	struct acpi_generic_address read_ack_register;
	u64 read_ack_preserve;
	u64 read_ack_write;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_ia_corrected {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	struct acpi_hest_notify notify;
	u8 num_hardware_banks;
	u8 reserved2[3];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_ia_deferred_check {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	struct acpi_hest_notify notify;
	u8 num_hardware_banks;
	u8 reserved2[3];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hest_ia_machine_check {
	struct acpi_hest_header header;
	u16 reserved1;
	u8 flags;
	u8 enabled;
	u32 records_to_preallocate;
	u32 max_sections_per_record;
	u64 global_capability_data;
	u64 global_control_data;
	u8 num_hardware_banks;
	u8 reserved3[7];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hmat_structure {
	u16 type;
	u16 reserved;
	u32 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hmat_cache {
	struct acpi_hmat_structure header;
	u32 memory_PD;
	u32 reserved1;
	u64 cache_size;
	u32 cache_attributes;
	u16 address_mode;
	u16 number_of_SMBIOShandles;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hmat_locality {
	struct acpi_hmat_structure header;
	u8 flags;
	u8 data_type;
	u8 min_transfer_size;
	u8 reserved1;
	u32 number_of_initiator_Pds;
	u32 number_of_target_Pds;
	u32 reserved2;
	u64 entry_base_unit;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hmat_proximity_domain {
	struct acpi_hmat_structure header;
	u16 flags;
	u16 reserved1;
	u32 processor_PD;
	u32 memory_PD;
	u32 reserved2;
	u64 reserved3;
	u64 reserved4;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int (*acpi_hp_notify)(struct acpi_device *, u32);

typedef void (*acpi_hp_uevent)(struct acpi_device *, u32);

typedef void (*acpi_hp_fixup)(struct acpi_device *);

struct acpi_hotplug_context {
	struct acpi_device *self;
	acpi_hp_notify notify;
	acpi_hp_uevent uevent;
	acpi_hp_fixup fixup;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hotplug_profile {
	struct kobject kobj;
	int (*scan_dependent)(struct acpi_device *);
	void (*notify_online)(struct acpi_device *);
	bool enabled: 1;
	bool demand_offline: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_hp_work {
	struct work_struct work;
	struct acpi_device *adev;
	u32 src;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_init_walk_info {
	u32 table_index;
	u32 object_count;
	u32 method_count;
	u32 serial_method_count;
	u32 non_serial_method_count;
	u32 serialized_method_count;
	u32 device_count;
	u32 op_region_count;
	u32 field_count;
	u32 buffer_count;
	u32 package_count;
	u32 op_region_init;
	u32 field_init;
	u32 buffer_init;
	u32 package_init;
	acpi_owner_id owner_id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_interface_info {
	char *name;
	struct acpi_interface_info *next;
	u8 flags;
	u8 value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_io_attribute {
	u8 range_type;
	u8 translation;
	u8 translation_type;
	u8 reserved1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct rcu_work {
	struct work_struct work;
	struct callback_head rcu;
	struct workqueue_struct *wq;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_ioremap {
	struct list_head list;
	void *virt;
	acpi_physical_address phys;
	acpi_size size;
	union {
		long unsigned int refcount;
		struct rcu_work rwork;
	} ATTR_PRESERVE_ACCESS_INDEX track;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_id_mapping {
	u32 input_base;
	u32 id_count;
	u32 output_base;
	u32 output_reference;
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_its_group {
	u32 its_count;
	u32 identifiers[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_memory_access {
	u32 cache_coherency;
	u8 hints;
	u16 reserved;
	u8 memory_flags;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_named_component {
	u32 node_flags;
	u64 memory_properties;
	u8 memory_address_limit;
	char device_name[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_node {
	u8 type;
	u16 length;
	u8 revision;
	u32 identifier;
	u32 mapping_count;
	u32 mapping_offset;
	char node_data[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_pmcg {
	u64 page0_base_address;
	u32 overflow_gsiv;
	u32 node_reference;
	u64 page1_base_address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_rmr {
	u32 flags;
	u32 rmr_count;
	u32 rmr_offset;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_rmr_desc {
	u64 base_address;
	u64 length;
	u32 reserved;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_root_complex {
	u64 memory_properties;
	u32 ats_attribute;
	u32 pci_segment_number;
	u8 memory_address_limit;
	u16 pasid_capabilities;
	u8 reserved[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_smmu {
	u64 base_address;
	u64 span;
	u32 model;
	u32 flags;
	u32 global_interrupt_offset;
	u32 context_interrupt_count;
	u32 context_interrupt_offset;
	u32 pmu_interrupt_count;
	u32 pmu_interrupt_offset;
	u64 interrupts[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_iort_smmu_v3 {
	u64 base_address;
	u32 flags;
	u32 reserved;
	u64 vatos_address;
	u32 model;
	u32 event_gsiv;
	u32 pri_gsiv;
	u32 gerr_gsiv;
	u32 sync_gsiv;
	u32 pxm;
	u32 id_mapping_index;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct irq_fwspec;

struct acpi_irq_parse_one_ctx {
	int rc;
	unsigned int index;
	long unsigned int *res_flags;
	struct irq_fwspec *fwspec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_lpat {
	int temp;
	int raw;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_lpat_conversion_table {
	struct acpi_lpat *lpat;
	int lpat_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_lpi_state {
	u32 min_residency;
	u32 wake_latency;
	u32 flags;
	u32 arch_flags;
	u32 res_cnt_freq;
	u32 enable_parent_state;
	u64 address;
	u8 index;
	u8 entry_method;
	char desc[32];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_lpi_states_array {
	unsigned int size;
	unsigned int composite_states_size;
	struct acpi_lpi_state *entries;
	struct acpi_lpi_state *composite_states[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_subtable_header {
	u8 type;
	u8 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_core_pic {
	struct acpi_subtable_header header;
	u8 version;
	u32 processor_id;
	u32 core_id;
	u32 flags;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_generic_distributor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 gic_id;
	u64 base_address;
	u32 global_irq_base;
	u8 version;
	u8 reserved2[3];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_generic_interrupt {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 cpu_interface_number;
	u32 uid;
	u32 flags;
	u32 parking_version;
	u32 performance_interrupt;
	u64 parked_address;
	u64 base_address;
	u64 gicv_base_address;
	u64 gich_base_address;
	u32 vgic_interrupt;
	u64 gicr_base_address;
	u64 arm_mpidr;
	u8 efficiency_class;
	u8 reserved2[1];
	u16 spe_interrupt;
	u16 trbe_interrupt;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_generic_msi_frame {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 msi_frame_id;
	u64 base_address;
	u32 flags;
	u16 spi_count;
	u16 spi_base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_generic_redistributor {
	struct acpi_subtable_header header;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u32 length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_generic_translator {
	struct acpi_subtable_header header;
	u8 flags;
	u8 reserved;
	u32 translation_id;
	u64 base_address;
	u32 reserved2;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_interrupt_override {
	struct acpi_subtable_header header;
	u8 bus;
	u8 source_irq;
	u32 global_irq;
	u16 inti_flags;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_interrupt_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u8 type;
	u8 id;
	u8 eid;
	u8 io_sapic_vector;
	u32 global_irq;
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_io_apic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 address;
	u32 global_irq_base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_io_sapic {
	struct acpi_subtable_header header;
	u8 id;
	u8 reserved;
	u32 global_irq_base;
	u64 address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_local_apic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u32 lapic_flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_local_apic_nmi {
	struct acpi_subtable_header header;
	u8 processor_id;
	u16 inti_flags;
	u8 lint;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_local_apic_override {
	struct acpi_subtable_header header;
	u16 reserved;
	u64 address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_local_sapic {
	struct acpi_subtable_header header;
	u8 processor_id;
	u8 id;
	u8 eid;
	u8 reserved[3];
	u32 lapic_flags;
	u32 uid;
	char uid_string[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_local_x2apic {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 local_apic_id;
	u32 lapic_flags;
	u32 uid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_local_x2apic_nmi {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 uid;
	u8 lint;
	u8 reserved[3];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_multiproc_wakeup {
	struct acpi_subtable_header header;
	u16 version;
	u32 reserved;
	u64 mailbox_address;
	u64 reset_vector;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_nmi_source {
	struct acpi_subtable_header header;
	u16 inti_flags;
	u32 global_irq;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_madt_rintc {
	struct acpi_subtable_header header;
	u8 version;
	u8 reserved;
	u32 flags;
	u64 hart_id;
	u32 uid;
	u32 ext_intc_id;
	u64 imsic_addr;
	u32 imsic_size;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_mcfg_allocation {
	u64 address;
	u16 pci_segment;
	u8 start_bus_number;
	u8 end_bus_number;
	u32 reserved;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_mem_mapping {
	acpi_physical_address physical_address;
	u8 *logical_address;
	acpi_size length;
	struct acpi_mem_mapping *next_mm;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_mem_space_context {
	u32 length;
	acpi_physical_address address;
	struct acpi_mem_mapping *cur_mm;
	struct acpi_mem_mapping *first_mm;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_memory_attribute {
	u8 write_protect;
	u8 caching;
	u8 range_type;
	u8 translation;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_memory_device {
	struct acpi_device *device;
	struct list_head res_list;
	int mgid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_memory_info {
	struct list_head list;
	u64 start_addr;
	u64 length;
	short unsigned int caching;
	short unsigned int write_protect;
	unsigned int enabled: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_mutex_info {
	void *mutex;
	u32 use_count;
	u64 thread_id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_name_info {
	char name[4];
	u16 argument_list;
	u8 expected_btypes;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_namestring_info {
	const char *external_name;
	const char *next_external_char;
	char *internal_name;
	u32 length;
	u32 num_segments;
	u32 num_carats;
	u8 fully_qualified;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_config {
	u32 capabilities_size;
	u8 capabilities[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_gendevice_config {
	u8 virtual_slot;
	u8 config_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_vendor_mic_config {
	u8 type;
	u8 panel;
	u16 speaker_position_distance;
	u16 horizontal_offset;
	u16 vertical_offset;
	u8 frequency_low_band;
	u8 frequency_high_band;
	u16 direction_angle;
	u16 elevation_angle;
	u16 work_vertical_angle_begin;
	u16 work_vertical_angle_end;
	u16 work_horizontal_angle_begin;
	u16 work_horizontal_angle_end;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_vendor_micdevice_config {
	u8 virtual_slot;
	u8 config_type;
	u8 array_type;
	u8 mics_count;
	struct acpi_nhlt_vendor_mic_config mics[0];
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_nhlt_device_config {
	u8 virtual_slot;
	struct acpi_nhlt_gendevice_config gen;
	struct acpi_nhlt_micdevice_config mic;
	struct acpi_nhlt_vendor_micdevice_config vendor_mic;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_endpoint {
	u32 length;
	u8 link_type;
	u8 instance_id;
	u16 vendor_id;
	u16 device_id;
	u16 revision_id;
	u32 subsystem_id;
	u8 device_type;
	u8 direction;
	u8 virtual_bus_id;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_wave_formatext {
	u16 format_tag;
	u16 channel_count;
	u32 samples_per_sec;
	u32 avg_bytes_per_sec;
	u16 block_align;
	u16 bits_per_sample;
	u16 extra_format_size;
	u16 valid_bits_per_sample;
	u32 channel_mask;
	u8 subformat[16];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_format_config {
	struct acpi_nhlt_wave_formatext format;
	struct acpi_nhlt_config config;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_nhlt_formats_config {
	u8 formats_count;
	struct acpi_nhlt_format_config formats[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

union acpi_object {
	acpi_object_type type;
	struct {
		acpi_object_type type;
		u64 value;
	} ATTR_PRESERVE_ACCESS_INDEX integer;
	struct {
		acpi_object_type type;
		u32 length;
		char *pointer;
	} ATTR_PRESERVE_ACCESS_INDEX string;
	struct {
		acpi_object_type type;
		u32 length;
		u8 *pointer;
	} ATTR_PRESERVE_ACCESS_INDEX buffer;
	struct {
		acpi_object_type type;
		u32 count;
		union acpi_object *elements;
	} ATTR_PRESERVE_ACCESS_INDEX package;
	struct {
		acpi_object_type type;
		acpi_object_type actual_type;
		acpi_handle handle;
	} ATTR_PRESERVE_ACCESS_INDEX reference;
	struct {
		acpi_object_type type;
		u32 proc_id;
		acpi_io_address pblk_address;
		u32 pblk_length;
	} ATTR_PRESERVE_ACCESS_INDEX processor;
	struct {
		acpi_object_type type;
		u32 system_level;
		u32 resource_order;
	} ATTR_PRESERVE_ACCESS_INDEX power_resource;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_object_list {
	u32 count;
	union acpi_object *pointer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_offsets {
	size_t offset;
	u8 mode;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_opcode_info {
	u32 parse_args;
	u32 runtime_args;
	u16 flags;
	u8 object_type;
	u8 class;
	u8 type;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void (*acpi_osd_exec_callback)(void *);

struct acpi_os_dpc {
	acpi_osd_exec_callback function;
	void *context;
	struct work_struct work;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_osc_context {
	char *uuid_str;
	int rev;
	struct acpi_buffer cap;
	struct acpi_buffer ret;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_osi_config {
	u8 default_disabling;
	unsigned int linux_enable: 1;
	unsigned int linux_dmi: 1;
	unsigned int linux_cmdline: 1;
	unsigned int darwin_enable: 1;
	unsigned int darwin_dmi: 1;
	unsigned int darwin_cmdline: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_osi_entry {
	char string[64];
	bool enable;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_package_info {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 object_type2;
	u8 count2;
	u16 reserved;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_package_info2 {
	u8 type;
	u8 count;
	u8 object_type[4];
	u8 reserved;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_package_info3 {
	u8 type;
	u8 count;
	u8 object_type[2];
	u8 tail_object_type;
	u16 reserved;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_package_info4 {
	u8 type;
	u8 object_type1;
	u8 count1;
	u8 sub_object_types;
	u8 pkg_count;
	u16 reserved;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_parse_state {
	u8 *aml_start;
	u8 *aml;
	u8 *aml_end;
	u8 *pkg_start;
	u8 *pkg_end;
	union acpi_parse_object *start_op;
	struct acpi_namespace_node *start_node;
	union acpi_generic_state *scope;
	union acpi_parse_object *start_scope;
	u32 aml_size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pcc_info {
	u8 subspace_id;
	u16 length;
	u8 *internal_buffer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pcct_ext_pcc_master {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved1;
	u64 base_address;
	u32 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u32 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_set_mask;
	u64 reserved2;
	struct acpi_generic_address cmd_complete_register;
	u64 cmd_complete_mask;
	struct acpi_generic_address cmd_update_register;
	u64 cmd_update_preserve_mask;
	u64 cmd_update_set_mask;
	struct acpi_generic_address error_status_register;
	u64 error_status_mask;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pcct_ext_pcc_shared_memory {
	u32 signature;
	u32 flags;
	u32 length;
	u32 command;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pcct_hw_reduced {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pcct_hw_reduced_type2 {
	struct acpi_subtable_header header;
	u32 platform_interrupt;
	u8 flags;
	u8 reserved;
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
	struct acpi_generic_address platform_ack_register;
	u64 ack_preserve_mask;
	u64 ack_write_mask;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pcct_shared_memory {
	u32 signature;
	u16 command;
	u16 status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pcct_subspace {
	struct acpi_subtable_header header;
	u8 reserved[6];
	u64 base_address;
	u64 length;
	struct acpi_generic_address doorbell_register;
	u64 preserve_mask;
	u64 write_mask;
	u32 latency;
	u32 max_access_rate;
	u16 min_turnaround_time;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pci_device {
	acpi_handle device;
	struct acpi_pci_device *next;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pci_root;

struct acpi_pci_root_ops;

struct acpi_pci_root_info {
	struct acpi_pci_root *root;
	struct acpi_device *bridge;
	struct acpi_pci_root_ops *ops;
	struct list_head resources;
	char name[16];
} ATTR_PRESERVE_ACCESS_INDEX;

struct pci_config_window;

struct acpi_pci_generic_root_info {
	struct acpi_pci_root_info common;
	struct pci_config_window *cfg;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pci_id {
	u16 segment;
	u16 bus;
	u16 device;
	u16 function;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pci_link_irq {
	u32 active;
	u8 triggering;
	u8 polarity;
	u8 resource_type;
	u8 possible_count;
	u32 possible[16];
	u8 initialized: 1;
	u8 reserved: 7;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pci_link {
	struct list_head list;
	struct acpi_device *device;
	struct acpi_pci_link_irq irq;
	int refcnt;
} ATTR_PRESERVE_ACCESS_INDEX;

struct resource {
	resource_size_t start;
	resource_size_t end;
	const char *name;
	long unsigned int flags;
	long unsigned int desc;
	struct resource *parent;
	struct resource *sibling;
	struct resource *child;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pci_bus;

struct acpi_pci_root {
	struct acpi_device *device;
	struct pci_bus *bus;
	u16 segment;
	int bridge_type;
	struct resource secondary;
	u32 osc_support_set;
	u32 osc_control_set;
	u32 osc_ext_support_set;
	u32 osc_ext_control_set;
	phys_addr_t mcfg_addr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pci_ops;

struct acpi_pci_root_ops {
	struct pci_ops *pci_ops;
	int (*init_info)(struct acpi_pci_root_info *);
	void (*release_info)(struct acpi_pci_root_info *);
	int (*prepare_resources)(struct acpi_pci_root_info *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pci_routing_table {
	u32 length;
	u32 pin;
	u64 address;
	u32 source_index;
	union {
		char pad[4];
		struct {
			struct {} ATTR_PRESERVE_ACCESS_INDEX __Empty_source;
			char source[0];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pci_slot;

struct acpi_pci_slot {
	struct pci_slot *pci_slot;
	struct list_head list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pct_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 reserved;
	u64 address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pkg_info {
	u8 *free_space;
	acpi_size length;
	u32 object_space;
	u32 num_packages;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_platform_list {
	char oem_id[7];
	char oem_table_id[9];
	u32 oem_revision;
	char *table;
	enum acpi_predicate pred;
	char *reason;
	u32 data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pld_info {
	u8 revision;
	u8 ignore_color;
	u8 red;
	u8 green;
	u8 blue;
	u16 width;
	u16 height;
	u8 user_visible;
	u8 dock;
	u8 lid;
	u8 panel;
	u8 vertical_position;
	u8 horizontal_position;
	u8 shape;
	u8 group_orientation;
	u8 group_token;
	u8 group_position;
	u8 bay;
	u8 ejectable;
	u8 ospm_eject_required;
	u8 cabinet_number;
	u8 card_cage_number;
	u8 reference;
	u8 rotation;
	u8 order;
	u8 reserved;
	u16 vertical_offset;
	u16 horizontal_offset;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_port_info {
	char *name;
	u16 start;
	u16 end;
	u8 osi_dependency;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_power_dependent_device {
	struct device *dev;
	struct list_head node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_power_register {
	u8 descriptor;
	u16 length;
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_power_resource {
	struct acpi_device device;
	struct list_head list_node;
	u32 system_level;
	u32 order;
	unsigned int ref_count;
	u8 state;
	struct mutex resource_lock;
	struct list_head dependents;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_power_resource_entry {
	struct list_head node;
	struct acpi_power_resource *resource;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pptt_cache {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 flags;
	u32 next_level_of_cache;
	u32 size;
	u32 number_of_sets;
	u8 associativity;
	u8 attributes;
	u16 line_size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pptt_cache_v1 {
	u32 cache_id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_pptt_processor {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 flags;
	u32 parent;
	u32 acpi_processor_id;
	u32 number_of_priv_resources;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_predefined_info {
	struct acpi_name_info info;
	struct acpi_package_info ret_info;
	struct acpi_package_info2 ret_info2;
	struct acpi_package_info3 ret_info3;
	struct acpi_package_info4 ret_info4;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_predefined_names {
	const char *name;
	u8 type;
	char *val;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_prmt_handler_info {
	u16 revision;
	u16 length;
	u8 handler_guid[16];
	u64 handler_address;
	u64 static_data_buffer_address;
	u64 acpi_param_buffer_address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_prmt_module_header {
	u16 revision;
	u16 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_prmt_module_info {
	u16 revision;
	u16 length;
	u8 module_guid[16];
	u16 major_rev;
	u16 minor_rev;
	u16 handler_info_count;
	u32 handler_info_offset;
	u64 mmio_list_pointer;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_probe_entry;

typedef bool (*acpi_probe_entry_validate_subtbl)(struct acpi_subtable_header *, struct acpi_probe_entry *);

struct acpi_table_header;

typedef int (*acpi_tbl_table_handler)(struct acpi_table_header *);

union acpi_subtable_headers;

typedef int (*acpi_tbl_entry_handler)(union acpi_subtable_headers *, const long unsigned int);

struct acpi_probe_entry {
	__u8 id[5];
	__u8 type;
	acpi_probe_entry_validate_subtbl subtable_valid;
	union {
		acpi_tbl_table_handler probe_table;
		acpi_tbl_entry_handler probe_subtbl;
	} ATTR_PRESERVE_ACCESS_INDEX;
	kernel_ulong_t driver_data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_flags {
	u8 power: 1;
	u8 performance: 1;
	u8 throttling: 1;
	u8 limit: 1;
	u8 bm_control: 1;
	u8 bm_check: 1;
	u8 has_cst: 1;
	u8 has_lpi: 1;
	u8 power_setup_done: 1;
	u8 bm_rld_set: 1;
	u8 previously_online: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_cx {
	u8 valid;
	u8 type;
	u32 address;
	u8 entry_method;
	u8 index;
	u32 latency;
	u8 bm_sts_skip;
	char desc[32];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_power {
	int count;
	union {
		struct acpi_processor_cx states[8];
		struct acpi_lpi_state lpi_states[8];
	} ATTR_PRESERVE_ACCESS_INDEX;
	int timer_broadcast_on_state;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_tsd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct cpumask *cpumask_var_t;

struct acpi_processor_tx {
	u16 power;
	u16 performance;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_tx_tss;

struct acpi_processor;

struct acpi_processor_throttling {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_tx_tss *states_tss;
	struct acpi_tsd_package domain_info;
	cpumask_var_t shared_cpu_map;
	int (*acpi_processor_get_throttling)(struct acpi_processor *);
	int (*acpi_processor_set_throttling)(struct acpi_processor *, int, bool);
	u32 address;
	u8 duty_offset;
	u8 duty_width;
	u8 tsd_valid_flag;
	unsigned int shared_type;
	struct acpi_processor_tx states[16];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_lx {
	int px;
	int tx;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_limit {
	struct acpi_processor_lx state;
	struct acpi_processor_lx thermal;
	struct acpi_processor_lx user;
} ATTR_PRESERVE_ACCESS_INDEX;

struct plist_node {
	int prio;
	struct list_head prio_list;
	struct list_head node_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct freq_constraints;

struct freq_qos_request {
	enum freq_qos_req_type type;
	struct plist_node pnode;
	struct freq_constraints *qos;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_performance;

struct thermal_cooling_device;

struct acpi_processor {
	acpi_handle handle;
	u32 acpi_id;
	phys_cpuid_t phys_id;
	u32 id;
	u32 pblk;
	int performance_platform_limit;
	int throttling_platform_limit;
	struct acpi_processor_flags flags;
	struct acpi_processor_power power;
	struct acpi_processor_performance *performance;
	struct acpi_processor_throttling throttling;
	struct acpi_processor_limit limit;
	struct thermal_cooling_device *cdev;
	struct device *dev;
	struct freq_qos_request perflib_req;
	struct freq_qos_request thermal_req;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_errata {
	u8 smp;
	struct {
		u8 throttle: 1;
		u8 fdma: 1;
		u8 reserved: 6;
		u32 bmisx;
	} ATTR_PRESERVE_ACCESS_INDEX piix4;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_psd_package {
	u64 num_entries;
	u64 revision;
	u64 domain;
	u64 coord_type;
	u64 num_processors;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_px;

struct acpi_processor_performance {
	unsigned int state;
	unsigned int platform_limit;
	struct acpi_pct_register control_register;
	struct acpi_pct_register status_register;
	unsigned int state_count;
	struct acpi_processor_px *states;
	struct acpi_psd_package domain_info;
	cpumask_var_t shared_cpu_map;
	unsigned int shared_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_px {
	u64 core_frequency;
	u64 power;
	u64 transition_latency;
	u64 bus_master_latency;
	u64 control;
	u64 status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_processor_tx_tss {
	u64 freqpercentage;
	u64 power;
	u64 transition_latency;
	u64 control;
	u64 status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_prt_entry {
	struct acpi_pci_id id;
	u8 pin;
	acpi_handle link;
	u32 index;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_reg_walk_info {
	u32 function;
	u32 reg_run_count;
	acpi_adr_space_type space_id;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef acpi_status (*acpi_repair_function)(struct acpi_evaluate_info *, union acpi_operand_object **);

struct acpi_repair_info {
	char name[4];
	acpi_repair_function repair_function;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_irq {
	u8 descriptor_length;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	union {
		u8 interrupt;
		struct {
			struct {} ATTR_PRESERVE_ACCESS_INDEX __Empty_interrupts;
			u8 interrupts[0];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_dma {
	u8 type;
	u8 bus_master;
	u8 transfer;
	u8 channel_count;
	union {
		u8 channel;
		struct {
			struct {} ATTR_PRESERVE_ACCESS_INDEX __Empty_channels;
			u8 channels[0];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_start_dependent {
	u8 descriptor_length;
	u8 compatibility_priority;
	u8 performance_robustness;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_io {
	u8 io_decode;
	u8 alignment;
	u8 address_length;
	u16 minimum;
	u16 maximum;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_fixed_io {
	u16 address;
	u8 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_fixed_dma {
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_vendor {
	u16 byte_length;
	u8 byte_data[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_vendor_typed {
	u16 byte_length;
	u8 uuid_subtype;
	u8 uuid[16];
	u8 byte_data[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_end_tag {
	u8 checksum;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_memory24 {
	u8 write_protect;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_memory32 {
	u8 write_protect;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_fixed_memory32 {
	u8 write_protect;
	u32 address;
	u32 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

union acpi_resource_attribute {
	struct acpi_memory_attribute mem;
	struct acpi_io_attribute io;
	u8 type_specific;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_source {
	u8 index;
	u16 string_length;
	char *string_ptr;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_address16 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address16_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_address32 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address32_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	struct acpi_address64_attribute address;
	struct acpi_resource_source resource_source;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_extended_address64 {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
	u8 revision_ID;
	struct acpi_address64_attribute address;
	u64 type_specific;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_extended_irq {
	u8 producer_consumer;
	u8 triggering;
	u8 polarity;
	u8 shareable;
	u8 wake_capable;
	u8 interrupt_count;
	struct acpi_resource_source resource_source;
	union {
		u32 interrupt;
		struct {
			struct {} ATTR_PRESERVE_ACCESS_INDEX __Empty_interrupts;
			u32 interrupts[0];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_generic_register {
	u8 space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_gpio {
	u8 revision_id;
	u8 connection_type;
	u8 producer_consumer;
	u8 pin_config;
	u8 shareable;
	u8 wake_capable;
	u8 io_restriction;
	u8 triggering;
	u8 polarity;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_i2c_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 access_mode;
	u16 slave_address;
	u32 connection_speed;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_spi_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 wire_mode;
	u8 device_polarity;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
	u32 connection_speed;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_uart_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 endian;
	u8 data_bits;
	u8 stop_bits;
	u8 flow_control;
	u8 parity;
	u8 lines_enabled;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u32 default_baud_rate;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_csi2_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
	u8 local_port_instance;
	u8 phy_type;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_common_serialbus {
	u8 revision_id;
	u8 type;
	u8 producer_consumer;
	u8 slave_mode;
	u8 connection_sharing;
	u8 type_revision_id;
	u16 type_data_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u8 *vendor_data;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_pin_function {
	u8 revision_id;
	u8 pin_config;
	u8 shareable;
	u16 function_number;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_pin_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_length;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	u16 *pin_table;
	u8 *vendor_data;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_label {
	u16 string_length;
	char *string_ptr;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_pin_group {
	u8 revision_id;
	u8 producer_consumer;
	u16 pin_table_length;
	u16 vendor_length;
	u16 *pin_table;
	struct acpi_resource_label resource_label;
	u8 *vendor_data;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_pin_group_function {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u16 function_number;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_pin_group_config {
	u8 revision_id;
	u8 producer_consumer;
	u8 shareable;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 vendor_length;
	struct acpi_resource_source resource_source;
	struct acpi_resource_label resource_source_label;
	u8 *vendor_data;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_clock_input {
	u8 revision_id;
	u8 mode;
	u8 scale;
	u16 frequency_divisor;
	u32 frequency_numerator;
	struct acpi_resource_source resource_source;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource_address {
	u8 resource_type;
	u8 producer_consumer;
	u8 decode;
	u8 min_address_fixed;
	u8 max_address_fixed;
	union acpi_resource_attribute info;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_resource_data {
	struct acpi_resource_irq irq;
	struct acpi_resource_dma dma;
	struct acpi_resource_start_dependent start_dpf;
	struct acpi_resource_io io;
	struct acpi_resource_fixed_io fixed_io;
	struct acpi_resource_fixed_dma fixed_dma;
	struct acpi_resource_vendor vendor;
	struct acpi_resource_vendor_typed vendor_typed;
	struct acpi_resource_end_tag end_tag;
	struct acpi_resource_memory24 memory24;
	struct acpi_resource_memory32 memory32;
	struct acpi_resource_fixed_memory32 fixed_memory32;
	struct acpi_resource_address16 address16;
	struct acpi_resource_address32 address32;
	struct acpi_resource_address64 address64;
	struct acpi_resource_extended_address64 ext_address64;
	struct acpi_resource_extended_irq extended_irq;
	struct acpi_resource_generic_register generic_reg;
	struct acpi_resource_gpio gpio;
	struct acpi_resource_i2c_serialbus i2c_serial_bus;
	struct acpi_resource_spi_serialbus spi_serial_bus;
	struct acpi_resource_uart_serialbus uart_serial_bus;
	struct acpi_resource_csi2_serialbus csi2_serial_bus;
	struct acpi_resource_common_serialbus common_serial_bus;
	struct acpi_resource_pin_function pin_function;
	struct acpi_resource_pin_config pin_config;
	struct acpi_resource_pin_group pin_group;
	struct acpi_resource_pin_group_function pin_group_function;
	struct acpi_resource_pin_group_config pin_group_config;
	struct acpi_resource_clock_input clock_input;
	struct acpi_resource_address address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_resource {
	u32 type;
	u32 length;
	union acpi_resource_data data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_rsconvert_info {
	u8 opcode;
	u8 resource_offset;
	u8 aml_offset;
	u8 value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_rw_lock {
	void *writer_mutex;
	void *reader_mutex;
	u32 num_readers;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_scan_clear_dep_work {
	struct work_struct work;
	struct acpi_device *adev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_scan_handler {
	struct list_head list_node;
	const struct acpi_device_id *ids;
	bool (*match)(const char *, const struct acpi_device_id **);
	int (*attach)(struct acpi_device *, const struct acpi_device_id *);
	void (*detach)(struct acpi_device *);
	void (*post_eject)(struct acpi_device *);
	void (*bind)(struct device *);
	void (*unbind)(struct device *);
	struct acpi_hotplug_profile hotplug;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef u32 (*acpi_sci_handler)(void *);

struct acpi_sci_handler_info {
	struct acpi_sci_handler_info *next;
	acpi_sci_handler address;
	void *context;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_serdev_lookup {
	acpi_handle device_handle;
	acpi_handle controller_handle;
	int n;
	int index;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_signal_fatal_info {
	u32 type;
	u32 code;
	u32 argument;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef acpi_status (*acpi_object_converter)(struct acpi_namespace_node *, union acpi_operand_object *, union acpi_operand_object **);

struct acpi_simple_repair_info {
	char name[4];
	u32 unexpected_btypes;
	u32 package_index;
	acpi_object_converter object_converter;
} ATTR_PRESERVE_ACCESS_INDEX;

struct spi_controller;

struct acpi_spi_lookup {
	struct spi_controller *ctlr;
	u32 max_speed_hz;
	u32 mode;
	int irq;
	u8 bits_per_word;
	u8 chip_select;
	int n;
	int index;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_srat_cpu_affinity {
	struct acpi_subtable_header header;
	u8 proximity_domain_lo;
	u8 apic_id;
	u32 flags;
	u8 local_sapic_eid;
	u8 proximity_domain_hi[3];
	u32 clock_domain;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_srat_generic_affinity {
	struct acpi_subtable_header header;
	u8 reserved;
	u8 device_handle_type;
	u32 proximity_domain;
	u8 device_handle[16];
	u32 flags;
	u32 reserved1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_srat_gic_its_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u16 reserved;
	u32 its_id;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_srat_gicc_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_srat_mem_affinity {
	struct acpi_subtable_header header;
	u32 proximity_domain;
	u16 reserved;
	u64 base_address;
	u64 length;
	u32 reserved1;
	u32 flags;
	u64 reserved2;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_srat_rintc_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 acpi_processor_uid;
	u32 flags;
	u32 clock_domain;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_srat_x2apic_cpu_affinity {
	struct acpi_subtable_header header;
	u16 reserved;
	u32 proximity_domain;
	u32 apic_id;
	u32 flags;
	u32 clock_domain;
	u32 reserved2;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_subtable_entry {
	union acpi_subtable_headers *hdr;
	enum acpi_subtable_type type;
} ATTR_PRESERVE_ACCESS_INDEX;

union acpi_subtable_headers {
	struct acpi_subtable_header common;
	struct acpi_hmat_structure hmat;
	struct acpi_prmt_module_header prmt;
	struct acpi_cedt_header cedt;
	struct acpi_cdat_header cdat;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int (*acpi_tbl_entry_handler_arg)(union acpi_subtable_headers *, void *, const long unsigned int);

struct acpi_subtable_proc {
	int id;
	acpi_tbl_entry_handler handler;
	acpi_tbl_entry_handler_arg handler_arg;
	void *arg;
	int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_header {
	char signature[4];
	u32 length;
	u8 revision;
	u8 checksum;
	char oem_id[6];
	char oem_table_id[8];
	u32 oem_revision;
	char asl_compiler_id[4];
	u32 asl_compiler_revision;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_agdi {
	struct acpi_table_header header;
	u8 flags;
	u8 reserved[3];
	u32 sdei_event;
	u32 gsiv;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_apmt {
	struct acpi_table_header header;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_attr {
	struct bin_attribute attr;
	char name[4];
	int instance;
	char filename[8];
	struct list_head node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_bert {
	struct acpi_table_header header;
	u32 region_length;
	u64 address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_bgrt {
	struct acpi_table_header header;
	u16 version;
	u8 status;
	u8 image_type;
	u64 image_address;
	u32 image_offset_x;
	u32 image_offset_y;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_ccel {
	struct acpi_table_header header;
	u8 CCtype;
	u8 Ccsub_type;
	u16 reserved;
	u64 log_area_minimum_length;
	u64 log_area_start_address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_cdat {
	u32 length;
	u8 revision;
	u8 checksum;
	u8 reserved[6];
	u32 sequence;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_csrt {
	struct acpi_table_header header;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_desc {
	acpi_physical_address address;
	struct acpi_table_header *pointer;
	u32 length;
	union acpi_name_union signature;
	acpi_owner_id owner_id;
	u8 flags;
	u16 validation_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_erst {
	struct acpi_table_header header;
	u32 header_length;
	u32 reserved;
	u32 entries;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_facs {
	char signature[4];
	u32 length;
	u32 hardware_signature;
	u32 firmware_waking_vector;
	u32 global_lock;
	u32 flags;
	u64 xfirmware_waking_vector;
	u8 version;
	u8 reserved[3];
	u32 ospm_flags;
	u8 reserved1[24];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_fadt {
	struct acpi_table_header header;
	u32 facs;
	u32 dsdt;
	u8 model;
	u8 preferred_profile;
	u16 sci_interrupt;
	u32 smi_command;
	u8 acpi_enable;
	u8 acpi_disable;
	u8 s4_bios_request;
	u8 pstate_control;
	u32 pm1a_event_block;
	u32 pm1b_event_block;
	u32 pm1a_control_block;
	u32 pm1b_control_block;
	u32 pm2_control_block;
	u32 pm_timer_block;
	u32 gpe0_block;
	u32 gpe1_block;
	u8 pm1_event_length;
	u8 pm1_control_length;
	u8 pm2_control_length;
	u8 pm_timer_length;
	u8 gpe0_block_length;
	u8 gpe1_block_length;
	u8 gpe1_base;
	u8 cst_control;
	u16 c2_latency;
	u16 c3_latency;
	u16 flush_size;
	u16 flush_stride;
	u8 duty_offset;
	u8 duty_width;
	u8 day_alarm;
	u8 month_alarm;
	u8 century;
	u16 boot_flags;
	u8 reserved;
	u32 flags;
	struct acpi_generic_address reset_register;
	u8 reset_value;
	u16 arm_boot_flags;
	u8 minor_revision;
	u64 Xfacs;
	u64 Xdsdt;
	struct acpi_generic_address xpm1a_event_block;
	struct acpi_generic_address xpm1b_event_block;
	struct acpi_generic_address xpm1a_control_block;
	struct acpi_generic_address xpm1b_control_block;
	struct acpi_generic_address xpm2_control_block;
	struct acpi_generic_address xpm_timer_block;
	struct acpi_generic_address xgpe0_block;
	struct acpi_generic_address xgpe1_block;
	struct acpi_generic_address sleep_control;
	struct acpi_generic_address sleep_status;
	u64 hypervisor_id;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_gtdt {
	struct acpi_table_header header;
	u64 counter_block_addresss;
	u32 reserved;
	u32 secure_el1_interrupt;
	u32 secure_el1_flags;
	u32 non_secure_el1_interrupt;
	u32 non_secure_el1_flags;
	u32 virtual_timer_interrupt;
	u32 virtual_timer_flags;
	u32 non_secure_el2_interrupt;
	u32 non_secure_el2_flags;
	u64 counter_read_block_address;
	u32 platform_timer_count;
	u32 platform_timer_offset;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_hest {
	struct acpi_table_header header;
	u32 error_source_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_iort {
	struct acpi_table_header header;
	u32 node_count;
	u32 node_offset;
	u32 reserved;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_list {
	struct acpi_table_desc *tables;
	u32 current_table_count;
	u32 max_table_count;
	u8 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_madt {
	struct acpi_table_header header;
	u32 address;
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_mcfg {
	struct acpi_table_header header;
	u8 reserved[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_nhlt {
	struct acpi_table_header header;
	u8 endpoints_count;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_pcct {
	struct acpi_table_header header;
	u32 flags;
	u64 reserved;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_rsdp {
	char signature[8];
	u8 checksum;
	char oem_id[6];
	u8 revision;
	u32 rsdt_physical_address;
	u32 length;
	u64 xsdt_physical_address;
	u8 extended_checksum;
	u8 reserved[3];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_slit {
	struct acpi_table_header header;
	u64 locality_count;
	u8 entry[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_spcr {
	struct acpi_table_header header;
	u8 interface_type;
	u8 reserved[3];
	struct acpi_generic_address serial_port;
	u8 interrupt_type;
	u8 pc_interrupt;
	u32 interrupt;
	u8 baud_rate;
	u8 parity;
	u8 stop_bits;
	u8 flow_control;
	u8 terminal_type;
	u8 language;
	u16 pci_device_id;
	u16 pci_vendor_id;
	u8 pci_bus;
	u8 pci_device;
	u8 pci_function;
	u32 pci_flags;
	u8 pci_segment;
	u32 uart_clk_freq;
	u32 precise_baudrate;
	u16 name_space_string_length;
	u16 name_space_string_offset;
	char name_space_string[0];
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_srat {
	struct acpi_table_header header;
	u32 table_revision;
	u64 reserved;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_stao {
	struct acpi_table_header header;
	u8 ignore_uart;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_tpm2 {
	struct acpi_table_header header;
	u16 platform_class;
	u16 reserved;
	u64 control_address;
	u32 start_method;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_viot {
	struct acpi_table_header header;
	u16 node_count;
	u16 node_offset;
	u8 reserved[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_table_wdat {
	struct acpi_table_header header;
	u32 header_length;
	u16 pci_segment;
	u8 pci_bus;
	u8 pci_device;
	u8 pci_function;
	u8 reserved[3];
	u32 timer_period;
	u32 max_count;
	u32 min_count;
	u8 flags;
	u8 reserved2[3];
	u32 entries;
} ATTR_PRESERVE_ACCESS_INDEX;

struct client_hdr {
	u32 log_max_len;
	u64 log_start_addr;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct server_hdr {
	u16 reserved;
	u64 log_max_len;
	u64 log_start_addr;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_tcpa {
	struct acpi_table_header hdr;
	u16 platform_class;
	union {
		struct client_hdr client;
		struct server_hdr server;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_thermal_trip {
	long unsigned int temp_dk;
	struct acpi_handle_list devices;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_thermal_passive {
	struct acpi_thermal_trip trip;
	long unsigned int tc1;
	long unsigned int tc2;
	long unsigned int delay;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_thermal_active {
	struct acpi_thermal_trip trip;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_thermal_trips {
	struct acpi_thermal_passive passive;
	struct acpi_thermal_active active[10];
} ATTR_PRESERVE_ACCESS_INDEX;

struct thermal_zone_device;

struct acpi_thermal {
	struct acpi_device *device;
	acpi_bus_id name;
	long unsigned int temp_dk;
	long unsigned int last_temp_dk;
	long unsigned int polling_frequency;
	volatile u8 zombie;
	struct acpi_thermal_trips trips;
	struct thermal_zone_device *thermal_zone;
	int kelvin_offset;
	struct work_struct thermal_check_work;
	struct mutex thermal_check_lock;
	refcount_t thermal_check_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_tpm2_phy {
	u8 start_method_specific[12];
	u32 log_area_minimum_length;
	u64 log_area_start_address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_vendor_uuid {
	u8 subtype;
	u8 data[16];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_vendor_walk_info {
	struct acpi_vendor_uuid *uuid;
	struct acpi_buffer *buffer;
	acpi_status status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_viot_header {
	u8 type;
	u8 reserved;
	u16 length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_viot_mmio {
	struct acpi_viot_header header;
	u32 endpoint;
	u64 base_address;
	u16 output_node;
	u8 reserved[6];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_viot_pci_range {
	struct acpi_viot_header header;
	u32 endpoint_start;
	u16 segment_start;
	u16 segment_end;
	u16 bdf_start;
	u16 bdf_end;
	u16 output_node;
	u8 reserved[6];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_viot_virtio_iommu_mmio {
	struct acpi_viot_header header;
	u8 reserved[4];
	u64 base_address;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_viot_virtio_iommu_pci {
	struct acpi_viot_header header;
	u16 segment;
	u16 bdf;
	u8 reserved[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_wakeup_handler {
	struct list_head list_node;
	bool (*wakeup)(void *);
	void *context;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef acpi_status (*acpi_parse_downwards)(struct acpi_walk_state *, union acpi_parse_object **);

typedef acpi_status (*acpi_parse_upwards)(struct acpi_walk_state *);

struct acpi_walk_state {
	struct acpi_walk_state *next;
	u8 descriptor_type;
	u8 walk_type;
	u16 opcode;
	u8 next_op_info;
	u8 num_operands;
	u8 operand_index;
	acpi_owner_id owner_id;
	u8 last_predicate;
	u8 current_result;
	u8 return_used;
	u8 scope_depth;
	u8 pass_number;
	u8 namespace_override;
	u8 result_size;
	u8 result_count;
	u8 *aml;
	u32 arg_types;
	u32 method_breakpoint;
	u32 user_breakpoint;
	u32 parse_flags;
	struct acpi_parse_state parser_state;
	u32 prev_arg_types;
	u32 arg_count;
	u16 method_nesting_depth;
	u8 method_is_nested;
	struct acpi_namespace_node arguments[7];
	struct acpi_namespace_node local_variables[8];
	union acpi_operand_object *operands[9];
	union acpi_operand_object **params;
	u8 *aml_last_while;
	union acpi_operand_object **caller_return_desc;
	union acpi_generic_state *control_state;
	struct acpi_namespace_node *deferred_node;
	union acpi_operand_object *implicit_return_obj;
	struct acpi_namespace_node *method_call_node;
	union acpi_parse_object *method_call_op;
	union acpi_operand_object *method_desc;
	struct acpi_namespace_node *method_node;
	char *method_pathname;
	union acpi_parse_object *op;
	const struct acpi_opcode_info *op_info;
	union acpi_parse_object *origin;
	union acpi_operand_object *result_obj;
	union acpi_generic_state *results;
	union acpi_operand_object *return_desc;
	union acpi_generic_state *scope_info;
	union acpi_parse_object *prev_op;
	union acpi_parse_object *next_op;
	struct acpi_thread_state *thread;
	acpi_parse_downwards descending_callback;
	acpi_parse_upwards ascending_callback;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_wdat_entry {
	u8 action;
	u8 instruction;
	u16 reserved;
	struct acpi_generic_address register_region;
	u32 value;
	u32 mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpi_whea_header {
	u8 action;
	u8 instruction;
	u8 flags;
	u8 reserved;
	struct acpi_generic_address register_region;
	u64 value;
	u64 mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct hotplug_slot;

struct acpiphp_attention_info {
	int (*set_attn)(struct hotplug_slot *, u8);
	int (*get_attn)(struct hotplug_slot *, u8 *);
	struct module *owner;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpiphp_context;

struct pci_dev;

struct acpiphp_bridge {
	struct list_head list;
	struct list_head slots;
	struct kref ref;
	struct acpiphp_context *context;
	int nr_slots;
	struct pci_bus *pci_bus;
	struct pci_dev *pci_dev;
	bool is_going_away;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpiphp_slot;

struct acpiphp_func {
	struct acpiphp_bridge *parent;
	struct acpiphp_slot *slot;
	struct list_head sibling;
	u8 function;
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpiphp_context {
	struct acpi_hotplug_context hp;
	struct acpiphp_func func;
	struct acpiphp_bridge *bridge;
	unsigned int refcount;
} ATTR_PRESERVE_ACCESS_INDEX;

struct acpiphp_root_context {
	struct acpi_hotplug_context hp;
	struct acpiphp_bridge *root_bridge;
} ATTR_PRESERVE_ACCESS_INDEX;

struct slot;

struct acpiphp_slot {
	struct list_head node;
	struct pci_bus *bus;
	struct list_head funcs;
	struct slot *slot;
	u8 device;
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pnp_dev;

struct acpipnp_parse_option_s {
	struct pnp_dev *dev;
	unsigned int option_flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct action_cache {
	long unsigned int allow_native[8];
	long unsigned int allow_compat[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct hist_trigger_data;

struct tracing_map_elt;

struct trace_buffer;

struct ring_buffer_event;

struct action_data;

typedef void (*action_fn_t)(struct hist_trigger_data *, struct tracing_map_elt *, struct trace_buffer *, void *, struct ring_buffer_event *, void *, struct action_data *, u64 *);

typedef bool (*check_track_val_fn_t)(u64, u64);

struct synth_event;

struct hist_field;

struct action_data {
	enum handler_id handler;
	enum action_id action;
	char *action_name;
	action_fn_t fn;
	unsigned int n_params;
	char *params[64];
	unsigned int var_ref_idx[64];
	struct synth_event *synth_event;
	bool use_trace_keyword;
	char *synth_event_name;
	union {
		struct {
			char *event;
			char *event_system;
		} ATTR_PRESERVE_ACCESS_INDEX match_data;
		struct {
			char *var_str;
			struct hist_field *var_ref;
			struct hist_field *track_var;
			check_track_val_fn_t check_val;
			action_fn_t save_data;
		} ATTR_PRESERVE_ACCESS_INDEX track_data;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct action_devres {
	void *data;
	void (*action)(void *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct action_gate_entry {
	u8 gate_state;
	u32 interval;
	s32 ipv;
	s32 maxoctets;
} ATTR_PRESERVE_ACCESS_INDEX;

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct rb_root {
	struct rb_node *rb_node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct rb_root_cached {
	struct rb_root rb_root;
	struct rb_node *rb_leftmost;
} ATTR_PRESERVE_ACCESS_INDEX;

struct address_space_operations;

struct address_space {
	struct inode *host;
	struct xarray i_pages;
	struct rw_semaphore invalidate_lock;
	gfp_t gfp_mask;
	atomic_t i_mmap_writable;
	atomic_t nr_thps;
	struct rb_root_cached i_mmap;
	long unsigned int nrpages;
	long unsigned int writeback_index;
	const struct address_space_operations *a_ops;
	long unsigned int flags;
	errseq_t wb_err;
	spinlock_t i_private_lock;
	struct list_head i_private_list;
	struct rw_semaphore i_mmap_rwsem;
	void *i_private_data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct page;

struct writeback_control;

struct readahead_control;

struct kiocb;

struct iov_iter;

struct swap_info_struct;

struct address_space_operations {
	int (*writepage)(struct page *, struct writeback_control *);
	int (*read_folio)(struct file *, struct folio *);
	int (*writepages)(struct address_space *, struct writeback_control *);
	bool (*dirty_folio)(struct address_space *, struct folio *);
	void (*readahead)(struct readahead_control *);
	int (*write_begin)(struct file *, struct address_space *, loff_t, unsigned int, struct folio **, void **);
	int (*write_end)(struct file *, struct address_space *, loff_t, unsigned int, unsigned int, struct folio *, void *);
	sector_t (*bmap)(struct address_space *, sector_t);
	void (*invalidate_folio)(struct folio *, size_t, size_t);
	bool (*release_folio)(struct folio *, gfp_t);
	void (*free_folio)(struct folio *);
	ssize_t (*direct_IO)(struct kiocb *, struct iov_iter *);
	int (*migrate_folio)(struct address_space *, struct folio *, struct folio *, enum migrate_mode);
	int (*launder_folio)(struct folio *);
	bool (*is_partially_uptodate)(struct folio *, size_t, size_t);
	void (*is_dirty_writeback)(struct folio *, bool *, bool *);
	int (*error_remove_folio)(struct address_space *, struct folio *);
	int (*swap_activate)(struct swap_info_struct *, struct file *, sector_t *);
	void (*swap_deactivate)(struct file *);
	int (*swap_rw)(struct kiocb *, struct iov_iter *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct adjust_trip_data {
	struct acpi_thermal *tz;
	u32 event;
} ATTR_PRESERVE_ACCESS_INDEX;

struct adreno_smmu_fault_info {
	u64 far;
	u64 ttbr0;
	u32 contextidr;
	u32 fsr;
	u32 fsynr0;
	u32 fsynr1;
	u32 cbfrsynra;
} ATTR_PRESERVE_ACCESS_INDEX;

struct io_pgtable_cfg;

struct adreno_smmu_priv {
	const void *cookie;
	const struct io_pgtable_cfg * (*get_ttbr1_cfg)(const void *);
	int (*set_ttbr0_cfg)(const void *, const struct io_pgtable_cfg *);
	void (*get_fault_info)(const void *, struct adreno_smmu_fault_info *);
	void (*set_stall)(const void *, bool);
	void (*resume_translation)(const void *, bool);
} ATTR_PRESERVE_ACCESS_INDEX;

struct advisor_ctx {
	ktime_t start_scan;
	long unsigned int scan_time;
	long unsigned int change;
	long long unsigned int cpu_time;
} ATTR_PRESERVE_ACCESS_INDEX;

struct irq_data;

struct seq_file;

struct msi_msg;

struct irq_chip {
	const char *name;
	unsigned int (*irq_startup)(struct irq_data *);
	void (*irq_shutdown)(struct irq_data *);
	void (*irq_enable)(struct irq_data *);
	void (*irq_disable)(struct irq_data *);
	void (*irq_ack)(struct irq_data *);
	void (*irq_mask)(struct irq_data *);
	void (*irq_mask_ack)(struct irq_data *);
	void (*irq_unmask)(struct irq_data *);
	void (*irq_eoi)(struct irq_data *);
	int (*irq_set_affinity)(struct irq_data *, const struct cpumask *, bool);
	int (*irq_retrigger)(struct irq_data *);
	int (*irq_set_type)(struct irq_data *, unsigned int);
	int (*irq_set_wake)(struct irq_data *, unsigned int);
	void (*irq_bus_lock)(struct irq_data *);
	void (*irq_bus_sync_unlock)(struct irq_data *);
	void (*irq_suspend)(struct irq_data *);
	void (*irq_resume)(struct irq_data *);
	void (*irq_pm_shutdown)(struct irq_data *);
	void (*irq_calc_mask)(struct irq_data *);
	void (*irq_print_chip)(struct irq_data *, struct seq_file *);
	int (*irq_request_resources)(struct irq_data *);
	void (*irq_release_resources)(struct irq_data *);
	void (*irq_compose_msi_msg)(struct irq_data *, struct msi_msg *);
	void (*irq_write_msi_msg)(struct irq_data *, struct msi_msg *);
	int (*irq_get_irqchip_state)(struct irq_data *, enum irqchip_irq_state, bool *);
	int (*irq_set_irqchip_state)(struct irq_data *, enum irqchip_irq_state, bool);
	int (*irq_set_vcpu_affinity)(struct irq_data *, void *);
	void (*ipi_send_single)(struct irq_data *, unsigned int);
	void (*ipi_send_mask)(struct irq_data *, const struct cpumask *);
	int (*irq_nmi_setup)(struct irq_data *);
	void (*irq_nmi_teardown)(struct irq_data *);
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pci_bridge_emul_conf {
	__le16 vendor;
	__le16 device;
	__le16 command;
	__le16 status;
	__le32 class_revision;
	u8 cache_line_size;
	u8 latency_timer;
	u8 header_type;
	u8 bist;
	__le32 bar[2];
	u8 primary_bus;
	u8 secondary_bus;
	u8 subordinate_bus;
	u8 secondary_latency_timer;
	u8 iobase;
	u8 iolimit;
	__le16 secondary_status;
	__le16 membase;
	__le16 memlimit;
	__le16 pref_mem_base;
	__le16 pref_mem_limit;
	__le32 prefbaseupper;
	__le32 preflimitupper;
	__le16 iobaseupper;
	__le16 iolimitupper;
	u8 capabilities_pointer;
	u8 reserve[3];
	__le32 romaddr;
	u8 intline;
	u8 intpin;
	__le16 bridgectrl;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pci_bridge_emul_pcie_conf {
	u8 cap_id;
	u8 next;
	__le16 cap;
	__le32 devcap;
	__le16 devctl;
	__le16 devsta;
	__le32 lnkcap;
	__le16 lnkctl;
	__le16 lnksta;
	__le32 slotcap;
	__le16 slotctl;
	__le16 slotsta;
	__le16 rootctl;
	__le16 rootcap;
	__le32 rootsta;
	__le32 devcap2;
	__le16 devctl2;
	__le16 devsta2;
	__le32 lnkcap2;
	__le16 lnkctl2;
	__le16 lnksta2;
	__le32 slotcap2;
	__le16 slotctl2;
	__le16 slotsta2;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pci_bridge_emul_ops;

struct pci_bridge_reg_behavior;

struct pci_bridge_emul {
	struct pci_bridge_emul_conf conf;
	struct pci_bridge_emul_pcie_conf pcie_conf;
	const struct pci_bridge_emul_ops *ops;
	struct pci_bridge_reg_behavior *pci_regs_behavior;
	struct pci_bridge_reg_behavior *pcie_cap_regs_behavior;
	void *data;
	u8 pcie_start;
	u8 ssid_start;
	bool has_pcie;
	u16 subsystem_vendor_id;
	u16 subsystem_id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct platform_device;

struct phy;

struct advk_pcie {
	struct platform_device *pdev;
	void *base;
	struct {
		phys_addr_t match;
		phys_addr_t remap;
		phys_addr_t mask;
		u32 actions;
	} ATTR_PRESERVE_ACCESS_INDEX wins[8];
	u8 wins_count;
	struct irq_domain *rp_irq_domain;
	struct irq_domain *irq_domain;
	struct irq_chip irq_chip;
	raw_spinlock_t irq_lock;
	struct irq_domain *msi_domain;
	struct irq_domain *msi_inner_domain;
	raw_spinlock_t msi_irq_lock;
	long unsigned int msi_used[1];
	struct mutex msi_used_lock;
	int link_gen;
	struct pci_bridge_emul bridge;
	struct gpio_desc *reset_gpio;
	struct phy *phy;
} ATTR_PRESERVE_ACCESS_INDEX;

struct crypto_aead;

struct aead_request;

struct aead_alg {
	int (*setkey)(struct crypto_aead *, const u8 *, unsigned int);
	int (*setauthsize)(struct crypto_aead *, unsigned int);
	int (*encrypt)(struct aead_request *);
	int (*decrypt)(struct aead_request *);
	int (*init)(struct crypto_aead *);
	void (*exit)(struct crypto_aead *);
	unsigned int ivsize;
	unsigned int maxauthsize;
	unsigned int chunksize;
	struct crypto_alg base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct crypto_sync_skcipher;

struct aead_geniv_ctx {
	spinlock_t lock;
	struct crypto_aead *child;
	struct crypto_sync_skcipher *sknull;
	u8 salt[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct crypto_template;

struct crypto_spawn;

struct crypto_instance {
	struct crypto_alg alg;
	struct crypto_template *tmpl;
	union {
		struct hlist_node list;
		struct crypto_spawn *spawns;
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct work_struct free_work;
	void *__ctx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct aead_instance {
	void (*free)(struct aead_instance *);
	union {
		struct {
			char head[64];
			struct crypto_instance base;
		} ATTR_PRESERVE_ACCESS_INDEX s;
		struct aead_alg alg;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aead_request {
	struct crypto_async_request base;
	unsigned int assoclen;
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	void *__ctx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct aead_testvec;

struct aead_test_suite {
	const struct aead_testvec *vecs;
	unsigned int count;
	unsigned int einval_allowed: 1;
	unsigned int aad_iv: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aead_testvec {
	const char *key;
	const char *iv;
	const char *ptext;
	const char *assoc;
	const char *ctext;
	unsigned char novrfy;
	unsigned char wk;
	unsigned char klen;
	unsigned int plen;
	unsigned int clen;
	unsigned int alen;
	int setkey_error;
	int setauthsize_error;
	int crypt_error;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aead_tfm {
	struct crypto_aead *aead;
	struct crypto_sync_skcipher *null_tfm;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pcie_tlp_log {
	u32 dw[4];
} ATTR_PRESERVE_ACCESS_INDEX;

struct aer_capability_regs {
	u32 header;
	u32 uncor_status;
	u32 uncor_mask;
	u32 uncor_severity;
	u32 cor_status;
	u32 cor_mask;
	u32 cap_control;
	struct pcie_tlp_log header_log;
	u32 root_command;
	u32 root_status;
	u16 cor_err_source;
	u16 uncor_err_source;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aer_err_info {
	struct pci_dev *dev[5];
	int error_dev_num;
	unsigned int id: 16;
	unsigned int severity: 2;
	unsigned int __pad1: 5;
	unsigned int multi_error_valid: 1;
	unsigned int first_error: 5;
	unsigned int __pad2: 2;
	unsigned int tlp_header_valid: 1;
	unsigned int status;
	unsigned int mask;
	struct pcie_tlp_log tlp;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aer_err_source {
	u32 status;
	u32 id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aer_recover_entry {
	u8 bus;
	u8 devfn;
	u16 domain;
	int severity;
	struct aer_capability_regs *regs;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aer_rpc {
	struct pci_dev *rpd;
	struct {
		union {
			struct __kfifo kfifo;
			struct aer_err_source *type;
			const struct aer_err_source *const_type;
			char (*rectype)[0];
			struct aer_err_source *ptr;
			const struct aer_err_source *ptr_const;
		} ATTR_PRESERVE_ACCESS_INDEX;
		struct aer_err_source buf[128];
	} ATTR_PRESERVE_ACCESS_INDEX aer_fifo;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aer_stats {
	u64 dev_cor_errs[16];
	u64 dev_fatal_errs[27];
	u64 dev_nonfatal_errs[27];
	u64 dev_total_cor_errs;
	u64 dev_total_fatal_errs;
	u64 dev_total_nonfatal_errs;
	u64 rootport_total_cor_errs;
	u64 rootport_total_fatal_errs;
	u64 rootport_total_nonfatal_errs;
} ATTR_PRESERVE_ACCESS_INDEX;

struct sg_table {
	struct scatterlist *sgl;
	unsigned int nents;
	unsigned int orig_nents;
} ATTR_PRESERVE_ACCESS_INDEX;

struct scatterlist {
	long unsigned int page_link;
	unsigned int offset;
	unsigned int length;
	dma_addr_t dma_address;
	unsigned int dma_length;
	unsigned int dma_flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct af_alg_sgl {
	struct sg_table sgt;
	struct scatterlist sgl[17];
	bool need_unpin;
} ATTR_PRESERVE_ACCESS_INDEX;

struct af_alg_rsgl {
	struct af_alg_sgl sgl;
	struct list_head list;
	size_t sg_num_bytes;
} ATTR_PRESERVE_ACCESS_INDEX;

struct skcipher_request {
	unsigned int cryptlen;
	u8 *iv;
	struct scatterlist *src;
	struct scatterlist *dst;
	struct crypto_async_request base;
	void *__ctx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct sock;

struct af_alg_async_req {
	struct kiocb *iocb;
	struct sock *sk;
	struct af_alg_rsgl first_rsgl;
	struct af_alg_rsgl *last_rsgl;
	struct list_head rsgl_list;
	struct scatterlist *tsgl;
	unsigned int tsgl_entries;
	unsigned int outlen;
	unsigned int areqlen;
	union {
		struct aead_request aead_req;
		struct skcipher_request skcipher_req;
	} ATTR_PRESERVE_ACCESS_INDEX cra_u;
} ATTR_PRESERVE_ACCESS_INDEX;

struct af_alg_iv;

struct af_alg_control {
	struct af_alg_iv *iv;
	int op;
	unsigned int aead_assoclen;
} ATTR_PRESERVE_ACCESS_INDEX;

struct crypto_wait {
	struct completion completion;
	int err;
} ATTR_PRESERVE_ACCESS_INDEX;

struct af_alg_ctx {
	struct list_head tsgl_list;
	void *iv;
	void *state;
	size_t aead_assoclen;
	struct crypto_wait wait;
	size_t used;
	atomic_t rcvused;
	bool more;
	bool merge;
	bool enc;
	bool init;
	unsigned int len;
	unsigned int inflight;
} ATTR_PRESERVE_ACCESS_INDEX;

struct af_alg_iv {
	__u32 ivlen;
	__u8 iv[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct af_alg_tsgl {
	struct list_head list;
	unsigned int cur;
	struct scatterlist sg[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct proto_ops;

struct af_alg_type {
	void * (*bind)(const char *, u32, u32);
	void (*release)(void *);
	int (*setkey)(void *, const u8 *, unsigned int);
	int (*setentropy)(void *, sockptr_t, unsigned int);
	int (*accept)(void *, struct sock *);
	int (*accept_nokey)(void *, struct sock *);
	int (*setauthsize)(void *, unsigned int);
	struct proto_ops *ops;
	struct proto_ops *ops_nokey;
	struct module *owner;
	char name[14];
} ATTR_PRESERVE_ACCESS_INDEX;

struct affinity_context {
	const struct cpumask *new_mask;
	struct cpumask *user_mask;
	unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct agdi_data {
	int sdei_event;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void (*event_cb_func_t)(const u32 *, void *);

struct agent_cb {
	void *agent_data;
	event_cb_func_t eve_cb;
	struct list_head list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aggregate_control {
	long int *aggregate;
	long int *local;
	long int *pending;
	long int *ppending;
	long int *cstat;
	long int *cstat_prev;
	int size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct component_master_ops;

struct component_match;

struct aggregate_device {
	struct list_head node;
	bool bound;
	const struct component_master_ops *ops;
	struct device *parent;
	struct component_match *match;
} ATTR_PRESERVE_ACCESS_INDEX;

struct hash_alg_common {
	unsigned int digestsize;
	unsigned int statesize;
	struct crypto_alg base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ahash_request;

struct crypto_ahash;

struct ahash_alg {
	int (*init)(struct ahash_request *);
	int (*update)(struct ahash_request *);
	int (*final)(struct ahash_request *);
	int (*finup)(struct ahash_request *);
	int (*digest)(struct ahash_request *);
	int (*export)(struct ahash_request *, void *);
	int (*import)(struct ahash_request *, const void *);
	int (*setkey)(struct crypto_ahash *, const u8 *, unsigned int);
	int (*init_tfm)(struct crypto_ahash *);
	void (*exit_tfm)(struct crypto_ahash *);
	int (*clone_tfm)(struct crypto_ahash *, struct crypto_ahash *);
	struct hash_alg_common halg;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ahash_instance {
	void (*free)(struct ahash_instance *);
	union {
		struct {
			char head[96];
			struct crypto_instance base;
		} ATTR_PRESERVE_ACCESS_INDEX s;
		struct ahash_alg alg;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ahash_request {
	struct crypto_async_request base;
	unsigned int nbytes;
	struct scatterlist *src;
	u8 *result;
	void *priv;
	void *__ctx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct ahci_cmd_hdr {
	__le32 opts;
	__le32 status;
	__le32 tbl_addr;
	__le32 tbl_addr_hi;
	__le32 reserved[4];
} ATTR_PRESERVE_ACCESS_INDEX;

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_link;

struct ahci_em_priv {
	enum sw_activity blink_policy;
	struct timer_list timer;
	long unsigned int saved_activity;
	long unsigned int activity;
	long unsigned int led_state;
	struct ata_link *link;
} ATTR_PRESERVE_ACCESS_INDEX;

struct clk_bulk_data;

struct reset_control;

struct regulator;

struct ata_port;

struct ata_host;

struct ahci_host_priv {
	unsigned int flags;
	u32 mask_port_map;
	void *mmio;
	u32 cap;
	u32 cap2;
	u32 version;
	u32 port_map;
	u32 saved_cap;
	u32 saved_cap2;
	u32 saved_port_map;
	u32 saved_port_cap[32];
	u32 em_loc;
	u32 em_buf_sz;
	u32 em_msg_type;
	u32 remapped_nvme;
	bool got_runtime_pm;
	unsigned int n_clks;
	struct clk_bulk_data *clks;
	unsigned int f_rsts;
	struct reset_control *rsts;
	struct regulator **target_pwrs;
	struct regulator *ahci_regulator;
	struct regulator *phy_regulator;
	struct phy **phys;
	unsigned int nports;
	void *plat_data;
	unsigned int irq;
	void (*start_engine)(struct ata_port *);
	int (*stop_engine)(struct ata_port *);
	irqreturn_t (*irq_handler)(int, void *);
	int (*get_irq_vector)(struct ata_host *, int);
} ATTR_PRESERVE_ACCESS_INDEX;

struct ahci_port_priv {
	struct ata_link *active_link;
	struct ahci_cmd_hdr *cmd_slot;
	dma_addr_t cmd_slot_dma;
	void *cmd_tbl;
	dma_addr_t cmd_tbl_dma;
	void *rx_fis;
	dma_addr_t rx_fis_dma;
	unsigned int ncq_saw_d2h: 1;
	unsigned int ncq_saw_dmas: 1;
	unsigned int ncq_saw_sdb: 1;
	spinlock_t lock;
	u32 intr_mask;
	bool fbs_supported;
	bool fbs_enabled;
	int fbs_last_dev;
	struct ahci_em_priv em_priv[15];
	char *irq_desc;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ahci_sg {
	__le32 addr;
	__le32 addr_hi;
	__le32 reserved;
	__le32 flags_size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct wait_page_queue;

struct kiocb {
	struct file *ki_filp;
	loff_t ki_pos;
	void (*ki_complete)(struct kiocb *, long int);
	void *private;
	int ki_flags;
	u16 ki_ioprio;
	union {
		struct wait_page_queue *ki_waitq;
		ssize_t (*dio_complete)(void *);
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct cred;

struct fsync_iocb {
	struct file *file;
	struct work_struct work;
	bool datasync;
	struct cred *creds;
} ATTR_PRESERVE_ACCESS_INDEX;

struct wait_queue_entry;

typedef int (*wait_queue_func_t)(struct wait_queue_entry *, unsigned int, int, void *);

struct wait_queue_entry {
	unsigned int flags;
	void *private;
	wait_queue_func_t func;
	struct list_head entry;
} ATTR_PRESERVE_ACCESS_INDEX;

struct poll_iocb {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	bool cancelled;
	bool work_scheduled;
	bool work_need_resched;
	struct wait_queue_entry wait;
	struct work_struct work;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int kiocb_cancel_fn(struct kiocb *);

struct io_event {
	__u64 data;
	__u64 obj;
	__s64 res;
	__s64 res2;
} ATTR_PRESERVE_ACCESS_INDEX;

struct kioctx;

struct aio_kiocb {
	union {
		struct file *ki_filp;
		struct kiocb rw;
		struct fsync_iocb fsync;
		struct poll_iocb poll;
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct kioctx *ki_ctx;
	kiocb_cancel_fn *ki_cancel;
	struct io_event ki_res;
	struct list_head ki_list;
	refcount_t ki_refcnt;
	struct eventfd_ctx *ki_eventfd;
} ATTR_PRESERVE_ACCESS_INDEX;

struct poll_table_struct;

typedef void (*poll_queue_proc)(struct file *, wait_queue_head_t *, struct poll_table_struct *);

struct poll_table_struct {
	poll_queue_proc _qproc;
	__poll_t _key;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aio_poll_table {
	struct poll_table_struct pt;
	struct aio_kiocb *iocb;
	bool queued;
	int error;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aio_ring {
	unsigned int id;
	unsigned int nr;
	unsigned int head;
	unsigned int tail;
	unsigned int magic;
	unsigned int compat_features;
	unsigned int incompat_features;
	unsigned int header_length;
	struct io_event io_events[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct aio_waiter {
	struct wait_queue_entry w;
	size_t min_nr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct akcipher_request;

struct crypto_akcipher;

struct akcipher_alg {
	int (*encrypt)(struct akcipher_request *);
	int (*decrypt)(struct akcipher_request *);
	int (*set_pub_key)(struct crypto_akcipher *, const void *, unsigned int);
	int (*set_priv_key)(struct crypto_akcipher *, const void *, unsigned int);
	unsigned int (*max_size)(struct crypto_akcipher *);
	int (*init)(struct crypto_akcipher *);
	void (*exit)(struct crypto_akcipher *);
	struct crypto_alg base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct akcipher_instance {
	void (*free)(struct akcipher_instance *);
	union {
		struct {
			char head[56];
			struct crypto_instance base;
		} ATTR_PRESERVE_ACCESS_INDEX s;
		struct akcipher_alg alg;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct akcipher_request {
	struct crypto_async_request base;
	struct scatterlist *src;
	struct scatterlist *dst;
	unsigned int src_len;
	unsigned int dst_len;
	void *__ctx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct akcipher_testvec;

struct akcipher_test_suite {
	const struct akcipher_testvec *vecs;
	unsigned int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct akcipher_testvec {
	const unsigned char *key;
	const unsigned char *m;
	const unsigned char *c;
	unsigned int key_len;
	unsigned int m_size;
	unsigned int c_size;
	bool public_key_vec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct al_pcie_acpi {
	void *dbi_base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alarm {
	struct timerqueue_node node;
	struct hrtimer timer;
	void (*function)(struct alarm *, ktime_t);
	enum alarmtimer_type type;
	int state;
	void *data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct timerqueue_head {
	struct rb_root_cached rb_root;
} ATTR_PRESERVE_ACCESS_INDEX;

struct timespec64;

struct alarm_base {
	spinlock_t lock;
	struct timerqueue_head timerqueue;
	ktime_t (*get_ktime)(void);
	void (*get_timespec)(struct timespec64 *);
	clockid_t base_clockid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct hlist_nulls_node {
	struct hlist_nulls_node *next;
	struct hlist_nulls_node **pprev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct proto;

struct inet_timewait_death_row;

struct sock_common {
	union {
		__addrpair skc_addrpair;
		struct {
			__be32 skc_daddr;
			__be32 skc_rcv_saddr;
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
	union {
		unsigned int skc_hash;
		__u16 skc_u16hashes[2];
	} ATTR_PRESERVE_ACCESS_INDEX;
	union {
		__portpair skc_portpair;
		struct {
			__be16 skc_dport;
			__u16 skc_num;
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
	short unsigned int skc_family;
	volatile unsigned char skc_state;
	unsigned char skc_reuse: 4;
	unsigned char skc_reuseport: 1;
	unsigned char skc_ipv6only: 1;
	unsigned char skc_net_refcnt: 1;
	int skc_bound_dev_if;
	union {
		struct hlist_node skc_bind_node;
		struct hlist_node skc_portaddr_node;
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct proto *skc_prot;
	possible_net_t skc_net;
	struct in6_addr skc_v6_daddr;
	struct in6_addr skc_v6_rcv_saddr;
	atomic64_t skc_cookie;
	union {
		long unsigned int skc_flags;
		struct sock *skc_listener;
		struct inet_timewait_death_row *skc_tw_dr;
	} ATTR_PRESERVE_ACCESS_INDEX;
	int skc_dontcopy_begin[0];
	union {
		struct hlist_node skc_node;
		struct hlist_nulls_node skc_nulls_node;
	} ATTR_PRESERVE_ACCESS_INDEX;
	short unsigned int skc_tx_queue_mapping;
	short unsigned int skc_rx_queue_mapping;
	union {
		int skc_incoming_cpu;
		u32 skc_rcv_wnd;
		u32 skc_tw_rcv_nxt;
	} ATTR_PRESERVE_ACCESS_INDEX;
	refcount_t skc_refcnt;
	int skc_dontcopy_end[0];
	union {
		u32 skc_rxhash;
		u32 skc_window_clamp;
		u32 skc_tw_snd_nxt;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct page_frag {
	struct page *page;
	__u32 offset;
	__u32 size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct sock_cgroup_data {
	struct cgroup *cgroup;
	u32 classid;
	u16 prioidx;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dst_entry;

struct sk_filter;

struct socket_wq;

struct socket;

struct mem_cgroup;

struct xfrm_policy;

struct pid;

struct sock_reuseport;

struct bpf_local_storage;

struct sock {
	struct sock_common __sk_common;
	__u8 __cacheline_group_begin__sock_write_rx[0];
	atomic_t sk_drops;
	__s32 sk_peek_off;
	struct sk_buff_head sk_error_queue;
	struct sk_buff_head sk_receive_queue;
	struct {
		atomic_t rmem_alloc;
		int len;
		struct sk_buff *head;
		struct sk_buff *tail;
	} ATTR_PRESERVE_ACCESS_INDEX sk_backlog;
	__u8 __cacheline_group_end__sock_write_rx[0];
	__u8 __cacheline_group_begin__sock_read_rx[0];
	struct dst_entry *sk_rx_dst;
	int sk_rx_dst_ifindex;
	u32 sk_rx_dst_cookie;
	unsigned int sk_ll_usec;
	unsigned int sk_napi_id;
	u16 sk_busy_poll_budget;
	u8 sk_prefer_busy_poll;
	u8 sk_userlocks;
	int sk_rcvbuf;
	struct sk_filter *sk_filter;
	union {
		struct socket_wq *sk_wq;
		struct socket_wq *sk_wq_raw;
	} ATTR_PRESERVE_ACCESS_INDEX;
	void (*sk_data_ready)(struct sock *);
	long int sk_rcvtimeo;
	int sk_rcvlowat;
	__u8 __cacheline_group_end__sock_read_rx[0];
	__u8 __cacheline_group_begin__sock_read_rxtx[0];
	int sk_err;
	struct socket *sk_socket;
	struct mem_cgroup *sk_memcg;
	struct xfrm_policy *sk_policy[2];
	__u8 __cacheline_group_end__sock_read_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_rxtx[0];
	socket_lock_t sk_lock;
	u32 sk_reserved_mem;
	int sk_forward_alloc;
	u32 sk_tsflags;
	__u8 __cacheline_group_end__sock_write_rxtx[0];
	__u8 __cacheline_group_begin__sock_write_tx[0];
	int sk_write_pending;
	atomic_t sk_omem_alloc;
	int sk_sndbuf;
	int sk_wmem_queued;
	refcount_t sk_wmem_alloc;
	long unsigned int sk_tsq_flags;
	union {
		struct sk_buff *sk_send_head;
		struct rb_root tcp_rtx_queue;
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct sk_buff_head sk_write_queue;
	u32 sk_dst_pending_confirm;
	u32 sk_pacing_status;
	struct page_frag sk_frag;
	struct timer_list sk_timer;
	long unsigned int sk_pacing_rate;
	atomic_t sk_zckey;
	atomic_t sk_tskey;
	__u8 __cacheline_group_end__sock_write_tx[0];
	__u8 __cacheline_group_begin__sock_read_tx[0];
	long unsigned int sk_max_pacing_rate;
	long int sk_sndtimeo;
	u32 sk_priority;
	u32 sk_mark;
	struct dst_entry *sk_dst_cache;
	netdev_features_t sk_route_caps;
	struct sk_buff * (*sk_validate_xmit_skb)(struct sock *, struct net_device *, struct sk_buff *);
	u16 sk_gso_type;
	u16 sk_gso_max_segs;
	unsigned int sk_gso_max_size;
	gfp_t sk_allocation;
	u32 sk_txhash;
	u8 sk_pacing_shift;
	bool sk_use_task_frag;
	__u8 __cacheline_group_end__sock_read_tx[0];
	u8 sk_gso_disabled: 1;
	u8 sk_kern_sock: 1;
	u8 sk_no_check_tx: 1;
	u8 sk_no_check_rx: 1;
	u8 sk_shutdown;
	u16 sk_type;
	u16 sk_protocol;
	long unsigned int sk_lingertime;
	struct proto *sk_prot_creator;
	rwlock_t sk_callback_lock;
	int sk_err_soft;
	u32 sk_ack_backlog;
	u32 sk_max_ack_backlog;
	kuid_t sk_uid;
	spinlock_t sk_peer_lock;
	int sk_bind_phc;
	struct pid *sk_peer_pid;
	const struct cred *sk_peer_cred;
	ktime_t sk_stamp;
	int sk_disconnects;
	u8 sk_txrehash;
	u8 sk_clockid;
	u8 sk_txtime_deadline_mode: 1;
	u8 sk_txtime_report_errors: 1;
	u8 sk_txtime_unused: 6;
	void *sk_user_data;
	void *sk_security;
	struct sock_cgroup_data sk_cgrp_data;
	void (*sk_state_change)(struct sock *);
	void (*sk_write_space)(struct sock *);
	void (*sk_error_report)(struct sock *);
	int (*sk_backlog_rcv)(struct sock *, struct sk_buff *);
	void (*sk_destruct)(struct sock *);
	struct sock_reuseport *sk_reuseport_cb;
	struct bpf_local_storage *sk_bpf_storage;
	struct callback_head sk_rcu;
	netns_tracker ns_tracker;
	struct xarray sk_user_frags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alg_sock {
	struct sock sk;
	struct sock *parent;
	atomic_t refcnt;
	atomic_t nokey_refcnt;
	const struct af_alg_type *type;
	void *private;
} ATTR_PRESERVE_ACCESS_INDEX;

struct cipher_testvec;

struct cipher_test_suite {
	const struct cipher_testvec *vecs;
	unsigned int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct comp_testvec;

struct comp_test_suite {
	struct {
		const struct comp_testvec *vecs;
		unsigned int count;
	} ATTR_PRESERVE_ACCESS_INDEX comp;
	struct {
		const struct comp_testvec *vecs;
		unsigned int count;
	} ATTR_PRESERVE_ACCESS_INDEX decomp;
} ATTR_PRESERVE_ACCESS_INDEX;

struct hash_testvec;

struct hash_test_suite {
	const struct hash_testvec *vecs;
	unsigned int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct cprng_testvec;

struct cprng_test_suite {
	const struct cprng_testvec *vecs;
	unsigned int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct drbg_testvec;

struct drbg_test_suite {
	const struct drbg_testvec *vecs;
	unsigned int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct sig_testvec;

struct sig_test_suite {
	const struct sig_testvec *vecs;
	unsigned int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct kpp_testvec;

struct kpp_test_suite {
	const struct kpp_testvec *vecs;
	unsigned int count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alg_test_desc {
	const char *alg;
	const char *generic_driver;
	int (*test)(const struct alg_test_desc *, const char *, u32, u32);
	int fips_allowed;
	union {
		struct aead_test_suite aead;
		struct cipher_test_suite cipher;
		struct comp_test_suite comp;
		struct hash_test_suite hash;
		struct cprng_test_suite cprng;
		struct drbg_test_suite drbg;
		struct akcipher_test_suite akcipher;
		struct sig_test_suite sig;
		struct kpp_test_suite kpp;
	} ATTR_PRESERVE_ACCESS_INDEX suite;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alg_type_list {
	const struct af_alg_type *type;
	struct list_head list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alias_prop {
	struct list_head link;
	const char *alias;
	struct device_node *np;
	int id;
	char stem[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct zonelist;

struct zoneref;

struct alloc_context {
	struct zonelist *zonelist;
	nodemask_t *nodemask;
	struct zoneref *preferred_zoneref;
	int migratetype;
	enum zone_type highest_zoneidx;
	bool spread_dirty_pages;
} ATTR_PRESERVE_ACCESS_INDEX;

struct codetag {
	unsigned int flags;
	unsigned int lineno;
	const char *modname;
	const char *function;
	const char *filename;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alloc_tag_counters;

struct alloc_tag {
	struct codetag ct;
	struct alloc_tag_counters *counters;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alloc_tag_counters {
	u64 bytes;
	u64 calls;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alpine_msix_data {
	spinlock_t msi_map_lock;
	phys_addr_t addr;
	u32 spi_first;
	u32 num_spis;
	long unsigned int *msi_map;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alps_bitmap_point {
	int start_bit;
	int num_bits;
} ATTR_PRESERVE_ACCESS_INDEX;

struct delayed_work {
	struct work_struct work;
	struct timer_list timer;
	struct workqueue_struct *wq;
	int cpu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct input_mt_pos {
	s16 x;
	s16 y;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alps_fields {
	unsigned int x_map;
	unsigned int y_map;
	unsigned int fingers;
	int pressure;
	struct input_mt_pos st;
	struct input_mt_pos mt[4];
	unsigned int first_mp: 1;
	unsigned int is_mp: 1;
	unsigned int left: 1;
	unsigned int right: 1;
	unsigned int middle: 1;
	unsigned int ts_left: 1;
	unsigned int ts_right: 1;
	unsigned int ts_middle: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct psmouse;

struct input_dev;

struct alps_nibble_commands;

struct alps_data {
	struct psmouse *psmouse;
	struct input_dev *dev2;
	struct input_dev *dev3;
	char phys2[32];
	char phys3[32];
	struct delayed_work dev3_register_work;
	const struct alps_nibble_commands *nibble_commands;
	int addr_command;
	u16 proto_version;
	u8 byte0;
	u8 mask0;
	u8 dev_id[3];
	u8 fw_ver[3];
	int flags;
	int x_max;
	int y_max;
	int x_bits;
	int y_bits;
	unsigned int x_res;
	unsigned int y_res;
	int (*hw_init)(struct psmouse *);
	void (*process_packet)(struct psmouse *);
	int (*decode_fields)(struct alps_fields *, unsigned char *, struct psmouse *);
	void (*set_abs_params)(struct alps_data *, struct input_dev *);
	int prev_fin;
	int multi_packet;
	int second_touch;
	unsigned char multi_data[6];
	struct alps_fields f;
	u8 quirks;
	struct timer_list timer;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alps_protocol_info {
	u16 version;
	u8 byte0;
	u8 mask0;
	unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alps_model_info {
	u8 signature[3];
	struct alps_protocol_info protocol_info;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alps_nibble_commands {
	int command;
	unsigned char data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alt_instr {
	s32 orig_offset;
	s32 alt_offset;
	u16 cpucap;
	u8 orig_len;
	u8 alt_len;
} ATTR_PRESERVE_ACCESS_INDEX;

struct alt_region {
	struct alt_instr *begin;
	struct alt_instr *end;
} ATTR_PRESERVE_ACCESS_INDEX;

struct amba_cs_uci_id {
	unsigned int devarch;
	unsigned int devarch_mask;
	unsigned int devtype;
	void *data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct device_dma_parameters {
	unsigned int max_segment_size;
	unsigned int min_align_mask;
	long unsigned int segment_boundary_mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct clk;

struct amba_device {
	struct device dev;
	struct resource res;
	struct clk *pclk;
	struct device_dma_parameters dma_parms;
	unsigned int periphid;
	struct mutex periphid_lock;
	unsigned int cid;
	struct amba_cs_uci_id uci;
	unsigned int irq[9];
	const char *driver_override;
} ATTR_PRESERVE_ACCESS_INDEX;

struct amba_id;

struct amba_driver {
	struct device_driver drv;
	int (*probe)(struct amba_device *, const struct amba_id *);
	void (*remove)(struct amba_device *);
	void (*shutdown)(struct amba_device *);
	const struct amba_id *id_table;
	bool driver_managed_dma;
} ATTR_PRESERVE_ACCESS_INDEX;

struct amba_id {
	unsigned int id;
	unsigned int mask;
	void *data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct amba_pl011_data {
	bool (*dma_filter)(struct dma_chan *, void *);
	void *dma_rx_param;
	void *dma_tx_param;
	bool dma_rx_poll_enable;
	unsigned int dma_rx_poll_rate;
	unsigned int dma_rx_poll_timeout;
	void (*init)(void);
	void (*exit)(void);
} ATTR_PRESERVE_ACCESS_INDEX;

struct amd_function {
	const char *name;
	const char * const groups[4];
	unsigned int ngroups;
	int index;
} ATTR_PRESERVE_ACCESS_INDEX;

struct irq_domain_ops {
	int (*match)(struct irq_domain *, struct device_node *, enum irq_domain_bus_token);
	int (*select)(struct irq_domain *, struct irq_fwspec *, enum irq_domain_bus_token);
	int (*map)(struct irq_domain *, unsigned int, irq_hw_number_t);
	void (*unmap)(struct irq_domain *, unsigned int);
	int (*xlate)(struct irq_domain *, struct device_node *, const u32 *, unsigned int, long unsigned int *, unsigned int *);
	int (*alloc)(struct irq_domain *, unsigned int, unsigned int, void *);
	void (*free)(struct irq_domain *, unsigned int, unsigned int);
	int (*activate)(struct irq_domain *, struct irq_data *, bool);
	void (*deactivate)(struct irq_domain *, struct irq_data *);
	int (*translate)(struct irq_domain *, struct irq_fwspec *, long unsigned int *, unsigned int *);
	void (*debug_show)(struct seq_file *, struct irq_domain *, struct irq_data *, int);
} ATTR_PRESERVE_ACCESS_INDEX;

struct irq_desc;

typedef void (*irq_flow_handler_t)(struct irq_desc *);

union gpio_irq_fwspec;

struct gpio_irq_chip {
	struct irq_chip *chip;
	struct irq_domain *domain;
	struct fwnode_handle *fwnode;
	struct irq_domain *parent_domain;
	int (*child_to_parent_hwirq)(struct gpio_chip *, unsigned int, unsigned int, unsigned int *, unsigned int *);
	int (*populate_parent_alloc_arg)(struct gpio_chip *, union gpio_irq_fwspec *, unsigned int, unsigned int);
	unsigned int (*child_offset_to_irq)(struct gpio_chip *, unsigned int);
	struct irq_domain_ops child_irq_domain_ops;
	irq_flow_handler_t handler;
	unsigned int default_type;
	struct lock_class_key *lock_key;
	struct lock_class_key *request_key;
	irq_flow_handler_t parent_handler;
	union {
		void *parent_handler_data;
		void **parent_handler_data_array;
	} ATTR_PRESERVE_ACCESS_INDEX;
	unsigned int num_parents;
	unsigned int *parents;
	unsigned int *map;
	bool threaded;
	bool per_parent_data;
	bool initialized;
	bool domain_is_allocated_externally;
	int (*init_hw)(struct gpio_chip *);
	void (*init_valid_mask)(struct gpio_chip *, long unsigned int *, unsigned int);
	long unsigned int *valid_mask;
	unsigned int first;
	void (*irq_enable)(struct irq_data *);
	void (*irq_disable)(struct irq_data *);
	void (*irq_unmask)(struct irq_data *);
	void (*irq_mask)(struct irq_data *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct gpio_device;

struct of_phandle_args;

struct gpio_chip {
	const char *label;
	struct gpio_device *gpiodev;
	struct device *parent;
	struct fwnode_handle *fwnode;
	struct module *owner;
	int (*request)(struct gpio_chip *, unsigned int);
	void (*free)(struct gpio_chip *, unsigned int);
	int (*get_direction)(struct gpio_chip *, unsigned int);
	int (*direction_input)(struct gpio_chip *, unsigned int);
	int (*direction_output)(struct gpio_chip *, unsigned int, int);
	int (*get)(struct gpio_chip *, unsigned int);
	int (*get_multiple)(struct gpio_chip *, long unsigned int *, long unsigned int *);
	void (*set)(struct gpio_chip *, unsigned int, int);
	void (*set_multiple)(struct gpio_chip *, long unsigned int *, long unsigned int *);
	int (*set_config)(struct gpio_chip *, unsigned int, long unsigned int);
	int (*to_irq)(struct gpio_chip *, unsigned int);
	void (*dbg_show)(struct seq_file *, struct gpio_chip *);
	int (*init_valid_mask)(struct gpio_chip *, long unsigned int *, unsigned int);
	int (*add_pin_ranges)(struct gpio_chip *);
	int (*en_hw_timestamp)(struct gpio_chip *, u32, long unsigned int);
	int (*dis_hw_timestamp)(struct gpio_chip *, u32, long unsigned int);
	int base;
	u16 ngpio;
	u16 offset;
	const char * const *names;
	bool can_sleep;
	long unsigned int (*read_reg)(void *);
	void (*write_reg)(void *, long unsigned int);
	bool be_bits;
	void *reg_dat;
	void *reg_set;
	void *reg_clr;
	void *reg_dir_out;
	void *reg_dir_in;
	bool bgpio_dir_unreadable;
	int bgpio_bits;
	raw_spinlock_t bgpio_lock;
	long unsigned int bgpio_data;
	long unsigned int bgpio_dir;
	struct gpio_irq_chip irq;
	long unsigned int *valid_mask;
	unsigned int of_gpio_n_cells;
	int (*of_xlate)(struct gpio_chip *, const struct of_phandle_args *, u32 *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct pingroup;

struct pinctrl_dev;

struct amd_gpio {
	raw_spinlock_t lock;
	void *base;
	void *iomux_base;
	const struct pingroup *groups;
	u32 ngroups;
	struct pinctrl_dev *pctrl;
	struct gpio_chip gc;
	unsigned int hwbank_num;
	struct resource *res;
	struct platform_device *pdev;
	u32 *saved_regs;
	int irq;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_small_header {
	u8 descriptor_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_large_header {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_irq {
	u8 descriptor_type;
	u16 irq_mask;
	u8 flags;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_dma {
	u8 descriptor_type;
	u8 dma_channel_mask;
	u8 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_start_dependent {
	u8 descriptor_type;
	u8 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_end_dependent {
	u8 descriptor_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_io {
	u8 descriptor_type;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u8 alignment;
	u8 address_length;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_fixed_io {
	u8 descriptor_type;
	u16 address;
	u8 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_fixed_dma {
	u8 descriptor_type;
	u16 request_lines;
	u16 channels;
	u8 width;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_vendor_small {
	u8 descriptor_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_end_tag {
	u8 descriptor_type;
	u8 checksum;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_memory24 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u16 minimum;
	u16 maximum;
	u16 alignment;
	u16 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_generic_register {
	u8 descriptor_type;
	u16 resource_length;
	u8 address_space_id;
	u8 bit_width;
	u8 bit_offset;
	u8 access_size;
	u64 address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_vendor_large {
	u8 descriptor_type;
	u16 resource_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 minimum;
	u32 maximum;
	u32 alignment;
	u32 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_fixed_memory32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u32 address;
	u32 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_address16 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u16 granularity;
	u16 minimum;
	u16 maximum;
	u16 translation_offset;
	u16 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_address32 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u32 granularity;
	u32 minimum;
	u32 maximum;
	u32 translation_offset;
	u32 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_extended_address64 {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
	u8 revision_ID;
	u8 reserved;
	u64 granularity;
	u64 minimum;
	u64 maximum;
	u64 translation_offset;
	u64 address_length;
	u64 type_specific;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_extended_irq {
	u8 descriptor_type;
	u16 resource_length;
	u8 flags;
	u8 interrupt_count;
	union {
		u32 interrupt;
		struct {
			struct {} ATTR_PRESERVE_ACCESS_INDEX __Empty_interrupts;
			u32 interrupts[0];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_gpio {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 connection_type;
	u16 flags;
	u16 int_flags;
	u8 pin_config;
	u16 drive_strength;
	u16 debounce_timeout;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_i2c_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u16 slave_address;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_spi_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 connection_speed;
	u8 data_bit_length;
	u8 clock_phase;
	u8 clock_polarity;
	u16 device_selection;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_uart_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
	u32 default_baud_rate;
	u16 rx_fifo_size;
	u16 tx_fifo_size;
	u8 parity;
	u8 lines_enabled;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_csi2_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_common_serialbus {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u8 res_source_index;
	u8 type;
	u8 flags;
	u16 type_specific_flags;
	u8 type_revision_id;
	u16 type_data_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_pin_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config;
	u16 function_number;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_pin_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u16 pin_table_offset;
	u8 res_source_index;
	u16 res_source_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_pin_group {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 pin_table_offset;
	u16 label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_pin_group_function {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 function_number;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_pin_group_config {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u8 pin_config_type;
	u32 pin_config_value;
	u8 res_source_index;
	u16 res_source_offset;
	u16 res_source_label_offset;
	u16 vendor_offset;
	u16 vendor_length;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_clock_input {
	u8 descriptor_type;
	u16 resource_length;
	u8 revision_id;
	u16 flags;
	u16 frequency_divisor;
	u32 frequency_numerator;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

struct aml_resource_address {
	u8 descriptor_type;
	u16 resource_length;
	u8 resource_type;
	u8 flags;
	u8 specific_flags;
} __attribute__((packed)) ATTR_PRESERVE_ACCESS_INDEX;

union aml_resource {
	u8 descriptor_type;
	struct aml_resource_small_header small_header;
	struct aml_resource_large_header large_header;
	struct aml_resource_irq irq;
	struct aml_resource_dma dma;
	struct aml_resource_start_dependent start_dpf;
	struct aml_resource_end_dependent end_dpf;
	struct aml_resource_io io;
	struct aml_resource_fixed_io fixed_io;
	struct aml_resource_fixed_dma fixed_dma;
	struct aml_resource_vendor_small vendor_small;
	struct aml_resource_end_tag end_tag;
	struct aml_resource_memory24 memory24;
	struct aml_resource_generic_register generic_reg;
	struct aml_resource_vendor_large vendor_large;
	struct aml_resource_memory32 memory32;
	struct aml_resource_fixed_memory32 fixed_memory32;
	struct aml_resource_address16 address16;
	struct aml_resource_address32 address32;
	struct aml_resource_address64 address64;
	struct aml_resource_extended_address64 ext_address64;
	struct aml_resource_extended_irq extended_irq;
	struct aml_resource_gpio gpio;
	struct aml_resource_i2c_serialbus i2c_serial_bus;
	struct aml_resource_spi_serialbus spi_serial_bus;
	struct aml_resource_uart_serialbus uart_serial_bus;
	struct aml_resource_csi2_serialbus csi2_serial_bus;
	struct aml_resource_common_serialbus common_serial_bus;
	struct aml_resource_pin_function pin_function;
	struct aml_resource_pin_config pin_config;
	struct aml_resource_pin_group pin_group;
	struct aml_resource_pin_group_function pin_group_function;
	struct aml_resource_pin_group_config pin_group_config;
	struct aml_resource_clock_input clock_input;
	struct aml_resource_address address;
	u32 dword_item;
	u16 word_item;
	u8 byte_item;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aml_rtc_config {
	bool gray_stored;
} ATTR_PRESERVE_ACCESS_INDEX;

struct regmap;

struct rtc_device;

struct aml_rtc_data {
	struct regmap *map;
	struct rtc_device *rtc_dev;
	int irq;
	struct clk *rtc_clk;
	struct clk *sys_clk;
	int rtc_enabled;
	const struct aml_rtc_config *config;
} ATTR_PRESERVE_ACCESS_INDEX;

struct amlogic_thermal_data;

struct amlogic_thermal {
	struct platform_device *pdev;
	const struct amlogic_thermal_data *data;
	struct regmap *regmap;
	struct regmap *sec_ao_map;
	struct clk *clk;
	struct thermal_zone_device *tzd;
	u32 trim_info;
} ATTR_PRESERVE_ACCESS_INDEX;

struct amlogic_thermal_soc_calib_data;

struct regmap_config;

struct amlogic_thermal_data {
	int u_efuse_off;
	const struct amlogic_thermal_soc_calib_data *calibration_parameters;
	const struct regmap_config *regmap_config;
} ATTR_PRESERVE_ACCESS_INDEX;

struct amlogic_thermal_soc_calib_data {
	int A;
	int B;
	int m;
	int n;
} ATTR_PRESERVE_ACCESS_INDEX;

struct kobj_uevent_env;

struct kobj_ns_type_operations;

struct class {
	const char *name;
	const struct attribute_group **class_groups;
	const struct attribute_group **dev_groups;
	int (*dev_uevent)(const struct device *, struct kobj_uevent_env *);
	char * (*devnode)(const struct device *, umode_t *);
	void (*class_release)(const struct class *);
	void (*dev_release)(struct device *);
	int (*shutdown_pre)(struct device *);
	const struct kobj_ns_type_operations *ns_type;
	const void * (*namespace)(const struct device *);
	void (*get_ownership)(const struct device *, kuid_t *, kgid_t *);
	const struct dev_pm_ops *pm;
} ATTR_PRESERVE_ACCESS_INDEX;

struct transport_container;

struct transport_class {
	struct class class;
	int (*setup)(struct transport_container *, struct device *, struct device *);
	int (*configure)(struct transport_container *, struct device *, struct device *);
	int (*remove)(struct transport_container *, struct device *, struct device *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct klist_node;

struct klist {
	spinlock_t k_lock;
	struct list_head k_list;
	void (*get)(struct klist_node *);
	void (*put)(struct klist_node *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct device_attribute;

struct attribute_container {
	struct list_head node;
	struct klist containers;
	struct class *class;
	const struct attribute_group *grp;
	struct device_attribute **attrs;
	int (*match)(struct attribute_container *, struct device *);
	long unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct anon_transport_class {
	struct transport_class tclass;
	struct attribute_container container;
} ATTR_PRESERVE_ACCESS_INDEX;

struct anon_vma {
	struct anon_vma *root;
	struct rw_semaphore rwsem;
	atomic_t refcount;
	long unsigned int num_children;
	long unsigned int num_active_vmas;
	struct anon_vma *parent;
	struct rb_root_cached rb_root;
} ATTR_PRESERVE_ACCESS_INDEX;

struct anon_vma_chain {
	struct vm_area_struct *vma;
	struct anon_vma *anon_vma;
	struct list_head same_vma;
	struct rb_node rb;
	long unsigned int rb_subtree_last;
} ATTR_PRESERVE_ACCESS_INDEX;

struct anon_vma_name {
	struct kref kref;
	char name[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct apd_private_data;

struct apd_device_desc {
	unsigned int fixed_clk_rate;
	struct property_entry *properties;
	int (*setup)(struct apd_private_data *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct apd_private_data {
	struct clk *clk;
	struct acpi_device *adev;
	const struct apd_device_desc *dev_desc;
} ATTR_PRESERVE_ACCESS_INDEX;

struct apei_exec_ins_type;

struct apei_exec_context {
	u32 ip;
	u64 value;
	u64 var1;
	u64 var2;
	u64 src_base;
	u64 dst_base;
	struct apei_exec_ins_type *ins_table;
	u32 instructions;
	struct acpi_whea_header *action_table;
	u32 entries;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int (*apei_exec_ins_func_t)(struct apei_exec_context *, struct acpi_whea_header *);

struct apei_exec_ins_type {
	u32 flags;
	apei_exec_ins_func_t run;
} ATTR_PRESERVE_ACCESS_INDEX;

struct apei_res {
	struct list_head list;
	long unsigned int start;
	long unsigned int end;
} ATTR_PRESERVE_ACCESS_INDEX;

struct apei_resources {
	struct list_head iomem;
	struct list_head ioport;
} ATTR_PRESERVE_ACCESS_INDEX;

struct aperture_range {
	struct device *dev;
	resource_size_t base;
	resource_size_t size;
	struct list_head lh;
	void (*detach)(struct device *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct api_context {
	struct completion done;
	int status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct apid_data {
	u16 ppid;
	u8 write_ee;
	u8 irq_ee;
} ATTR_PRESERVE_ACCESS_INDEX;

struct workqueue_attrs;

struct pool_workqueue;

struct apply_wqattrs_ctx {
	struct workqueue_struct *wq;
	struct workqueue_attrs *attrs;
	struct list_head list;
	struct pool_workqueue *dfl_pwq;
	struct pool_workqueue *pwq_tbl[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_elf_state {
	int flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_hibernate_hdr_invariants {
	char uts_version[65];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_hibernate_hdr {
	struct arch_hibernate_hdr_invariants invariants;
	phys_addr_t ttbr1_el1;
	void (*reenter_kernel)(void);
	phys_addr_t __hyp_stub_vectors;
	u64 sleep_cpu_mpidr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_hw_breakpoint_ctrl {
	u32 __reserved: 19;
	u32 len: 8;
	u32 type: 2;
	u32 privilege: 2;
	u32 enabled: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_hw_breakpoint {
	u64 address;
	u64 trigger;
	struct arch_hw_breakpoint_ctrl ctrl;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_io_reserve_memtype_wc_devres {
	resource_size_t start;
	resource_size_t size;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_msi_msg_addr_hi {
	u32 address_hi;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct arch_msi_msg_addr_hi arch_msi_msg_addr_hi_t;

struct arch_msi_msg_addr_lo {
	u32 address_lo;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct arch_msi_msg_addr_lo arch_msi_msg_addr_lo_t;

struct arch_msi_msg_data {
	u32 data;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct arch_msi_msg_data arch_msi_msg_data_t;

struct pt_regs;

typedef void probes_handler_t(u32, long int, struct pt_regs *);

struct arch_probe_insn {
	probes_handler_t *handler;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_specific_insn {
	struct arch_probe_insn api;
	kprobe_opcode_t *xol_insn;
	long unsigned int xol_restore;
} ATTR_PRESERVE_ACCESS_INDEX;

struct clock_event_device {
	void (*event_handler)(struct clock_event_device *);
	int (*set_next_event)(long unsigned int, struct clock_event_device *);
	int (*set_next_ktime)(ktime_t, struct clock_event_device *);
	ktime_t next_event;
	u64 max_delta_ns;
	u64 min_delta_ns;
	u32 mult;
	u32 shift;
	enum clock_event_state state_use_accessors;
	unsigned int features;
	long unsigned int retries;
	int (*set_state_periodic)(struct clock_event_device *);
	int (*set_state_oneshot)(struct clock_event_device *);
	int (*set_state_oneshot_stopped)(struct clock_event_device *);
	int (*set_state_shutdown)(struct clock_event_device *);
	int (*tick_resume)(struct clock_event_device *);
	void (*broadcast)(const struct cpumask *);
	void (*suspend)(struct clock_event_device *);
	void (*resume)(struct clock_event_device *);
	long unsigned int min_delta_ticks;
	long unsigned int max_delta_ticks;
	const char *name;
	int rating;
	int irq;
	int bound_on;
	const struct cpumask *cpumask;
	struct list_head list;
	struct module *owner;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer {
	void *base;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct clock_event_device evt;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer_offset {
	u64 *vm_offset;
	u64 *vcpu_offset;
} ATTR_PRESERVE_ACCESS_INDEX;

struct kvm_vcpu;

struct arch_timer_context {
	struct kvm_vcpu *vcpu;
	struct hrtimer hrtimer;
	u64 ns_frac;
	struct arch_timer_offset offset;
	bool loaded;
	struct {
		bool level;
	} ATTR_PRESERVE_ACCESS_INDEX irq;
	u32 host_timer_irq;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer_cpu {
	struct arch_timer_context timers[4];
	struct hrtimer bg_timer;
	bool enabled;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer_erratum_workaround {
	enum arch_timer_erratum_match_type match_type;
	const void *id;
	const char *desc;
	u64 (*read_cntpct_el0)(void);
	u64 (*read_cntvct_el0)(void);
	int (*set_next_event_phys)(long unsigned int, struct clock_event_device *);
	int (*set_next_event_virt)(long unsigned int, struct clock_event_device *);
	bool disable_compat_vdso;
} ATTR_PRESERVE_ACCESS_INDEX;

struct cyclecounter;

struct timecounter {
	const struct cyclecounter *cc;
	u64 cycle_last;
	u64 nsec;
	u64 mask;
	u64 frac;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer_kvm_info {
	struct timecounter timecounter;
	int virtual_irq;
	int physical_irq;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer_mem_frame {
	bool valid;
	phys_addr_t cntbase;
	size_t size;
	int phys_irq;
	int virt_irq;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer_mem {
	phys_addr_t cntctlbase;
	size_t size;
	struct arch_timer_mem_frame frame[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_timer_vm_data {
	u64 voffset;
	u64 poffset;
	u8 ppi[4];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_tlbflush_unmap_batch {} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_uprobe {
	union {
		__le32 insn;
		__le32 ixol;
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct arch_probe_insn api;
	bool simulate;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_uprobe_task {} ATTR_PRESERVE_ACCESS_INDEX;

struct arch_vdso_time_data {} ATTR_PRESERVE_ACCESS_INDEX;

struct arg_dev_net_ip {
	struct net *net;
	struct in6_addr *addr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arg_netdev_event {
	const struct net_device *dev;
	union {
		unsigned char nh_flags;
		long unsigned int event;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_askumount {
	__u32 may_umount;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_expire {
	__u32 how;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_fail {
	__u32 token;
	__s32 status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_in {
	__u32 type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_out {
	__u32 devid;
	__u32 magic;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_ismountpoint {
	union {
		struct args_in in;
		struct args_out out;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_openmount {
	__u32 devid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_protosubver {
	__u32 sub_version;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_protover {
	__u32 version;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_ready {
	__u32 token;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_requester {
	__u32 uid;
	__u32 gid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_setpipefd {
	__s32 pipefd;
} ATTR_PRESERVE_ACCESS_INDEX;

struct args_timeout {
	__u64 timeout;
} ATTR_PRESERVE_ACCESS_INDEX;

struct midr_range {
	u32 model;
	u32 rv_min;
	u32 rv_max;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_midr_revidr;

struct arm64_cpu_capabilities {
	const char *desc;
	u16 capability;
	u16 type;
	bool (*matches)(const struct arm64_cpu_capabilities *, int);
	void (*cpu_enable)(const struct arm64_cpu_capabilities *);
	union {
		struct {
			struct midr_range midr_range;
			const struct arm64_midr_revidr * const fixed_revs;
		} ATTR_PRESERVE_ACCESS_INDEX;
		const struct midr_range *midr_range_list;
		struct {
			u32 sys_reg;
			u8 field_pos;
			u8 field_width;
			u8 min_field_value;
			u8 max_field_value;
			u8 hwcap_type;
			bool sign;
			long unsigned int hwcap;
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
	const struct arm64_cpu_capabilities *match_list;
	const struct cpumask *cpus;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_ftr_bits {
	bool sign;
	bool visible;
	bool strict;
	enum ftr_type type;
	u8 shift;
	u8 width;
	s64 safe_val;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_ftr_override {
	u64 val;
	u64 mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_ftr_reg {
	const char *name;
	u64 strict_mask;
	u64 user_mask;
	u64 sys_val;
	u64 user_val;
	struct arm64_ftr_override *override;
	const struct arm64_ftr_bits *ftr_bits;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_image_header {
	__le32 code0;
	__le32 code1;
	__le64 text_offset;
	__le64 image_size;
	__le64 flags;
	__le64 res2;
	__le64 res3;
	__le64 res4;
	__le32 magic;
	__le32 res5;
} ATTR_PRESERVE_ACCESS_INDEX;

struct bpf_prog;

struct jit_ctx {
	const struct bpf_prog *prog;
	int idx;
	int epilogue_offset;
	int *offset;
	int exentry_idx;
	int nr_used_callee_reg;
	u8 used_callee_reg[8];
	__le32 *image;
	__le32 *ro_image;
	u32 stack_size;
	u64 user_vm_start;
	u64 arena_vm_start;
	bool fp_used;
	bool write;
} ATTR_PRESERVE_ACCESS_INDEX;

struct bpf_binary_header;

struct arm64_jit_data {
	struct bpf_binary_header *header;
	u8 *ro_image;
	struct bpf_binary_header *ro_header;
	struct jit_ctx ctx;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_mem_crypt_ops {
	int (*encrypt)(long unsigned int, int);
	int (*decrypt)(long unsigned int, int);
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm64_midr_revidr {
	u32 midr_rv;
	u32 revidr_mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct perf_cpu_pmu_context;

struct perf_event;

struct mm_struct;

struct perf_event_pmu_context;

struct kmem_cache;

struct perf_output_handle;

struct pmu {
	struct list_head entry;
	struct module *module;
	struct device *dev;
	struct device *parent;
	const struct attribute_group **attr_groups;
	const struct attribute_group **attr_update;
	const char *name;
	int type;
	int capabilities;
	unsigned int scope;
	int *pmu_disable_count;
	struct perf_cpu_pmu_context *cpu_pmu_context;
	atomic_t exclusive_cnt;
	int task_ctx_nr;
	int hrtimer_interval_ms;
	unsigned int nr_addr_filters;
	void (*pmu_enable)(struct pmu *);
	void (*pmu_disable)(struct pmu *);
	int (*event_init)(struct perf_event *);
	void (*event_mapped)(struct perf_event *, struct mm_struct *);
	void (*event_unmapped)(struct perf_event *, struct mm_struct *);
	int (*add)(struct perf_event *, int);
	void (*del)(struct perf_event *, int);
	void (*start)(struct perf_event *, int);
	void (*stop)(struct perf_event *, int);
	void (*read)(struct perf_event *);
	void (*start_txn)(struct pmu *, unsigned int);
	int (*commit_txn)(struct pmu *);
	void (*cancel_txn)(struct pmu *);
	int (*event_idx)(struct perf_event *);
	void (*sched_task)(struct perf_event_pmu_context *, bool);
	struct kmem_cache *task_ctx_cache;
	void (*swap_task_ctx)(struct perf_event_pmu_context *, struct perf_event_pmu_context *);
	void * (*setup_aux)(struct perf_event *, void **, int, bool);
	void (*free_aux)(void *);
	long int (*snapshot_aux)(struct perf_event *, struct perf_output_handle *, long unsigned int);
	int (*addr_filters_validate)(struct list_head *);
	void (*addr_filters_sync)(struct perf_event *);
	int (*aux_output_match)(struct perf_event *);
	bool (*filter)(struct pmu *, int);
	int (*check_period)(struct perf_event *, u64);
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_ccn_component;

struct arm_ccn_dt {
	int id;
	void *base;
	spinlock_t config_lock;
	long unsigned int pmu_counters_mask[1];
	struct {
		struct arm_ccn_component *source;
		struct perf_event *event;
	} ATTR_PRESERVE_ACCESS_INDEX pmu_counters[9];
	struct {
		u64 l;
		u64 h;
	} ATTR_PRESERVE_ACCESS_INDEX cmp_mask[12];
	struct hrtimer hrtimer;
	unsigned int cpu;
	struct hlist_node node;
	struct pmu pmu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_ccn {
	struct device *dev;
	void *base;
	unsigned int irq;
	unsigned int sbas_present: 1;
	unsigned int sbsx_present: 1;
	int num_nodes;
	struct arm_ccn_component *node;
	int num_xps;
	struct arm_ccn_component *xp;
	struct arm_ccn_dt dt;
	int mn_id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_ccn_component {
	void *base;
	u32 type;
	long unsigned int pmu_events_mask[1];
	union {
		struct {
			long unsigned int dt_cmp_mask[1];
		} ATTR_PRESERVE_ACCESS_INDEX xp;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct device_attribute {
	struct attribute attr;
	ssize_t (*show)(struct device *, struct device_attribute *, char *);
	ssize_t (*store)(struct device *, struct device_attribute *, const char *, size_t);
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_ccn_pmu_event {
	struct device_attribute attr;
	u32 type;
	u32 event;
	int num_ports;
	int num_vcs;
	const char *def;
	int mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_node;

struct arm_cmn_dtm;

struct arm_cmn_dtc;

struct arm_cmn {
	struct device *dev;
	void *base;
	unsigned int state;
	enum cmn_revision rev;
	enum cmn_part part;
	u8 mesh_x;
	u8 mesh_y;
	u16 num_xps;
	u16 num_dns;
	bool multi_dtm;
	u8 ports_used;
	struct {
		unsigned int rsp_vc_num: 2;
		unsigned int dat_vc_num: 2;
		unsigned int snp_vc_num: 2;
		unsigned int req_vc_num: 2;
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct arm_cmn_node *xps;
	struct arm_cmn_node *dns;
	struct arm_cmn_dtm *dtms;
	struct arm_cmn_dtc *dtc;
	unsigned int num_dtcs;
	int cpu;
	struct hlist_node cpuhp_node;
	struct pmu pmu;
	struct dentry *debug;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_dtc {
	void *base;
	void *pmu_base;
	int irq;
	s8 irq_friend;
	bool cc_active;
	struct perf_event *counters[8];
	struct perf_event *cycles;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_dtm {
	void *base;
	u32 pmu_config_low;
	union {
		u8 input_sel[4];
		__le32 pmu_config_high;
	} ATTR_PRESERVE_ACCESS_INDEX;
	s8 wp_event[4];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_event_attr {
	struct device_attribute attr;
	enum cmn_model model;
	enum cmn_node_type type;
	enum cmn_filter_select fsel;
	u16 eventid;
	u8 occupid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_format_attr {
	struct device_attribute attr;
	u64 field;
	int config;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_hw_event {
	struct arm_cmn_node *dn;
	u64 dtm_idx[5];
	s8 dtc_idx[4];
	u8 num_dns;
	u8 dtm_offset;
	long unsigned int wp_idx[3];
	bool wide_sel;
	enum cmn_filter_select filter_sel;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_node {
	void *pmu_base;
	u16 id;
	u16 logid;
	enum cmn_node_type type;
	u8 dtm;
	s8 dtc;
	u8 portid_bits: 4;
	u8 deviceid_bits: 4;
	struct {
		u8 val: 4;
		u8 count: 4;
	} ATTR_PRESERVE_ACCESS_INDEX occupid[5];
	union {
		u8 event[4];
		__le32 event_sel;
		u16 event_w[4];
		__le64 event_sel_w;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_nodeid {
	u8 port;
	u8 dev;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cmn_val {
	u8 dtm_count[188];
	u8 occupid[940];
	u8 wp[752];
	u8 wp_combine[376];
	int dtc_count[4];
	bool cycles;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_cpuidle_irq_context {} ATTR_PRESERVE_ACCESS_INDEX;

struct iommu_flush_ops;

struct io_pgtable_cfg {
	long unsigned int quirks;
	long unsigned int pgsize_bitmap;
	unsigned int ias;
	unsigned int oas;
	bool coherent_walk;
	const struct iommu_flush_ops *tlb;
	struct device *iommu_dev;
	void * (*alloc)(void *, size_t, gfp_t);
	void (*free)(void *, void *, size_t);
	union {
		struct {
			u64 ttbr;
			struct {
				u32 ips: 3;
				u32 tg: 2;
				u32 sh: 2;
				u32 orgn: 2;
				u32 irgn: 2;
				u32 tsz: 6;
			} ATTR_PRESERVE_ACCESS_INDEX tcr;
			u64 mair;
		} ATTR_PRESERVE_ACCESS_INDEX arm_lpae_s1_cfg;
		struct {
			u64 vttbr;
			struct {
				u32 ps: 3;
				u32 tg: 2;
				u32 sh: 2;
				u32 orgn: 2;
				u32 irgn: 2;
				u32 sl: 2;
				u32 tsz: 6;
			} ATTR_PRESERVE_ACCESS_INDEX vtcr;
		} ATTR_PRESERVE_ACCESS_INDEX arm_lpae_s2_cfg;
		struct {
			u32 ttbr;
			u32 tcr;
			u32 nmrr;
			u32 prrr;
		} ATTR_PRESERVE_ACCESS_INDEX arm_v7s_cfg;
		struct {
			u64 transtab;
			u64 memattr;
		} ATTR_PRESERVE_ACCESS_INDEX arm_mali_lpae_cfg;
		struct {
			u64 ttbr[4];
			u32 n_ttbrs;
		} ATTR_PRESERVE_ACCESS_INDEX apple_dart_cfg;
		struct {
			int nid;
		} ATTR_PRESERVE_ACCESS_INDEX amd;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct iommu_iotlb_gather;

struct iommu_dirty_bitmap;

struct io_pgtable_ops {
	int (*map_pages)(struct io_pgtable_ops *, long unsigned int, phys_addr_t, size_t, size_t, int, gfp_t, size_t *);
	size_t (*unmap_pages)(struct io_pgtable_ops *, long unsigned int, size_t, size_t, struct iommu_iotlb_gather *);
	phys_addr_t (*iova_to_phys)(struct io_pgtable_ops *, long unsigned int);
	int (*read_and_clear_dirty)(struct io_pgtable_ops *, long unsigned int, size_t, long unsigned int, struct iommu_dirty_bitmap *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct io_pgtable {
	enum io_pgtable_fmt fmt;
	void *cookie;
	struct io_pgtable_cfg cfg;
	struct io_pgtable_ops ops;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_lpae_io_pgtable {
	struct io_pgtable iop;
	int pgd_bits;
	int start_level;
	int bits_per_level;
	void *pgd;
} ATTR_PRESERVE_ACCESS_INDEX;

struct cpumask {
	long unsigned int bits[64];
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct cpumask cpumask_t;

struct pmu_hw_events;

struct hw_perf_event;

struct perf_event_attr;

struct arm_pmu {
	struct pmu pmu;
	cpumask_t supported_cpus;
	char *name;
	int pmuver;
	irqreturn_t (*handle_irq)(struct arm_pmu *);
	void (*enable)(struct perf_event *);
	void (*disable)(struct perf_event *);
	int (*get_event_idx)(struct pmu_hw_events *, struct perf_event *);
	void (*clear_event_idx)(struct pmu_hw_events *, struct perf_event *);
	int (*set_event_filter)(struct hw_perf_event *, struct perf_event_attr *);
	u64 (*read_counter)(struct perf_event *);
	void (*write_counter)(struct perf_event *, u64);
	void (*start)(struct arm_pmu *);
	void (*stop)(struct arm_pmu *);
	void (*reset)(void *);
	int (*map_event)(struct perf_event *);
	long unsigned int cntr_mask[1];
	bool secure_access;
	long unsigned int pmceid_bitmap[1];
	long unsigned int pmceid_ext_bitmap[1];
	struct platform_device *plat_device;
	struct pmu_hw_events *hw_events;
	struct hlist_node node;
	struct notifier_block cpu_pm_nb;
	const struct attribute_group *attr_groups[5];
	u64 reg_pmmir;
	long unsigned int acpi_cpuid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_pmu_entry {
	struct list_head entry;
	struct arm_pmu *arm_pmu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smccc_1_2_regs {
	long unsigned int a0;
	long unsigned int a1;
	long unsigned int a2;
	long unsigned int a3;
	long unsigned int a4;
	long unsigned int a5;
	long unsigned int a6;
	long unsigned int a7;
	long unsigned int a8;
	long unsigned int a9;
	long unsigned int a10;
	long unsigned int a11;
	long unsigned int a12;
	long unsigned int a13;
	long unsigned int a14;
	long unsigned int a15;
	long unsigned int a16;
	long unsigned int a17;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smccc_args {
	long unsigned int args[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smccc_quirk {
	int id;
	union {
		long unsigned int a6;
	} ATTR_PRESERVE_ACCESS_INDEX state;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smccc_res {
	long unsigned int a0;
	long unsigned int a1;
	long unsigned int a2;
	long unsigned int a3;
} ATTR_PRESERVE_ACCESS_INDEX;

struct iommu_domain;

struct arm_smmu_master;

struct arm_smmu_attach_state {
	struct iommu_domain *old_domain;
	struct arm_smmu_master *master;
	bool cd_needs_ats;
	bool disable_ats;
	ioasid_t ssid;
	bool ats_enabled;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cfg;

struct arm_smmu_cb {
	u64 ttbr[2];
	u32 tcr[2];
	u32 mair[2];
	struct arm_smmu_cfg *cfg;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cd {
	__le64 data[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_entry_writer_ops;

struct arm_smmu_entry_writer {
	const struct arm_smmu_entry_writer_ops *ops;
	struct arm_smmu_master *master;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cd_writer {
	struct arm_smmu_entry_writer writer;
	unsigned int ssid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cdtab_l1 {
	__le64 l2ptr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cdtab_l2 {
	struct arm_smmu_cd cds[1024];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cfg {
	u8 cbndx;
	u8 irptndx;
	union {
		u16 asid;
		u16 vmid;
	} ATTR_PRESERVE_ACCESS_INDEX;
	enum arm_smmu_cbar_type cbar;
	enum arm_smmu_context_fmt fmt;
	bool flush_walk_prefer_tlbiasid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_ll_queue {
	union {
		u64 val;
		struct {
			u32 prod;
			u32 cons;
		} ATTR_PRESERVE_ACCESS_INDEX;
		struct {
			atomic_t prod;
			atomic_t cons;
		} ATTR_PRESERVE_ACCESS_INDEX atomic;
		u8 __pad[64];
	} ATTR_PRESERVE_ACCESS_INDEX;
	u32 max_n_shift;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_queue {
	struct arm_smmu_ll_queue llq;
	int irq;
	__le64 *base;
	dma_addr_t base_dma;
	u64 q_base;
	size_t ent_dwords;
	u32 *prod_reg;
	u32 *cons_reg;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cmdq_ent;

struct arm_smmu_cmdq {
	struct arm_smmu_queue q;
	atomic_long_t *valid_map;
	atomic_t owner_prod;
	atomic_t lock;
	bool (*supports_cmd)(struct arm_smmu_cmdq_ent *);
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cmdq_batch {
	u64 cmds[128];
	struct arm_smmu_cmdq *cmdq;
	int num;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_cmdq_ent {
	u8 opcode;
	bool substream_valid;
	union {
		struct {
			u32 sid;
		} ATTR_PRESERVE_ACCESS_INDEX prefetch;
		struct {
			u32 sid;
			u32 ssid;
			union {
				bool leaf;
				u8 span;
			} ATTR_PRESERVE_ACCESS_INDEX;
		} ATTR_PRESERVE_ACCESS_INDEX cfgi;
		struct {
			u8 num;
			u8 scale;
			u16 asid;
			u16 vmid;
			bool leaf;
			u8 ttl;
			u8 tg;
			u64 addr;
		} ATTR_PRESERVE_ACCESS_INDEX tlbi;
		struct {
			u32 sid;
			u32 ssid;
			u64 addr;
			u8 size;
			bool global;
		} ATTR_PRESERVE_ACCESS_INDEX atc;
		struct {
			u32 sid;
			u32 ssid;
			u16 grpid;
			enum pri_resp resp;
		} ATTR_PRESERVE_ACCESS_INDEX pri;
		struct {
			u32 sid;
			u16 stag;
			u8 resp;
		} ATTR_PRESERVE_ACCESS_INDEX resume;
		struct {
			u64 msiaddr;
		} ATTR_PRESERVE_ACCESS_INDEX sync;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_context_fault_info {
	long unsigned int iova;
	u32 fsr;
	u32 fsynr;
	u32 cbfrsynra;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_ctx_desc {
	u16 asid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_ctx_desc_cfg {
	union {
		struct {
			struct arm_smmu_cd *table;
			unsigned int num_ents;
		} ATTR_PRESERVE_ACCESS_INDEX linear;
		struct {
			struct arm_smmu_cdtab_l1 *l1tab;
			struct arm_smmu_cdtab_l2 **l2ptrs;
			unsigned int num_l1_ents;
		} ATTR_PRESERVE_ACCESS_INDEX l2;
	} ATTR_PRESERVE_ACCESS_INDEX;
	dma_addr_t cdtab_dma;
	unsigned int used_ssids;
	u8 in_ste;
	u8 s1fmt;
	u8 s1cdmax;
} ATTR_PRESERVE_ACCESS_INDEX;

struct iopf_queue;

struct arm_smmu_evtq {
	struct arm_smmu_queue q;
	struct iopf_queue *iopf;
	u32 max_stalls;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_priq {
	struct arm_smmu_queue q;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_ste;

struct arm_smmu_strtab_l1;

struct arm_smmu_strtab_l2;

struct arm_smmu_strtab_cfg {
	union {
		struct {
			struct arm_smmu_ste *table;
			dma_addr_t ste_dma;
			unsigned int num_ents;
		} ATTR_PRESERVE_ACCESS_INDEX linear;
		struct {
			struct arm_smmu_strtab_l1 *l1tab;
			struct arm_smmu_strtab_l2 **l2ptrs;
			dma_addr_t l1_dma;
			unsigned int num_l1_ents;
		} ATTR_PRESERVE_ACCESS_INDEX l2;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct iommu_ops;

struct iommu_device {
	struct list_head list;
	const struct iommu_ops *ops;
	struct fwnode_handle *fwnode;
	struct device *dev;
	struct iommu_group *singleton_group;
	u32 max_pasids;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_impl_ops;

struct arm_smmu_device {
	struct device *dev;
	struct device *impl_dev;
	const struct arm_smmu_impl_ops *impl_ops;
	void *base;
	void *page1;
	u32 features;
	u32 options;
	long: 64;
	long: 64;
	struct arm_smmu_cmdq cmdq;
	struct arm_smmu_evtq evtq;
	struct arm_smmu_priq priq;
	int gerr_irq;
	int combined_irq;
	long unsigned int ias;
	long unsigned int oas;
	long unsigned int pgsize_bitmap;
	unsigned int asid_bits;
	unsigned int vmid_bits;
	struct ida vmid_map;
	unsigned int ssid_bits;
	unsigned int sid_bits;
	struct arm_smmu_strtab_cfg strtab_cfg;
	struct iommu_device iommu;
	struct rb_root streams;
	struct mutex streams_mutex;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_impl;

struct arm_smmu_smr;

struct arm_smmu_s2cr;

struct arm_smmu_device___2 {
	struct device *dev;
	void *base;
	phys_addr_t ioaddr;
	unsigned int numpage;
	unsigned int pgshift;
	u32 features;
	enum arm_smmu_arch_version version;
	enum arm_smmu_implementation model;
	const struct arm_smmu_impl *impl;
	u32 num_context_banks;
	u32 num_s2_context_banks;
	long unsigned int context_map[2];
	struct arm_smmu_cb *cbs;
	atomic_t irptndx;
	u32 num_mapping_groups;
	u16 streamid_mask;
	u16 smr_mask_mask;
	struct arm_smmu_smr *smrs;
	struct arm_smmu_s2cr *s2crs;
	struct mutex stream_map_mutex;
	long unsigned int va_size;
	long unsigned int ipa_size;
	long unsigned int pa_size;
	long unsigned int pgsize_bitmap;
	int num_context_irqs;
	int num_clks;
	unsigned int *irqs;
	struct clk_bulk_data *clks;
	spinlock_t global_sync_lock;
	struct iommu_device iommu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct iommu_domain_geometry {
	dma_addr_t aperture_start;
	dma_addr_t aperture_end;
	bool force_aperture;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int (*iommu_fault_handler_t)(struct iommu_domain *, struct device *, long unsigned int, int, void *);

struct iommu_domain_ops;

struct iommu_dirty_ops;

struct iommu_dma_cookie;

struct iopf_group;

struct iommu_domain {
	unsigned int type;
	const struct iommu_domain_ops *ops;
	const struct iommu_dirty_ops *dirty_ops;
	const struct iommu_ops *owner;
	long unsigned int pgsize_bitmap;
	struct iommu_domain_geometry geometry;
	struct iommu_dma_cookie *iova_cookie;
	int (*iopf_handler)(struct iopf_group *);
	void *fault_data;
	union {
		struct {
			iommu_fault_handler_t handler;
			void *handler_token;
		} ATTR_PRESERVE_ACCESS_INDEX;
		struct {
			struct mm_struct *mm;
			int users;
			struct list_head next;
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_domain {
	struct arm_smmu_device___2 *smmu;
	struct io_pgtable_ops *pgtbl_ops;
	long unsigned int pgtbl_quirks;
	const struct iommu_flush_ops *flush_ops;
	struct arm_smmu_cfg cfg;
	enum arm_smmu_domain_stage___2 stage;
	struct mutex init_mutex;
	spinlock_t cb_lock;
	struct iommu_domain domain;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_s2_cfg {
	u16 vmid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct mmu_notifier_ops;

struct mmu_notifier {
	struct hlist_node hlist;
	const struct mmu_notifier_ops *ops;
	struct mm_struct *mm;
	struct callback_head rcu;
	unsigned int users;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_domain___2 {
	struct arm_smmu_device *smmu;
	struct mutex init_mutex;
	struct io_pgtable_ops *pgtbl_ops;
	atomic_t nr_ats_masters;
	enum arm_smmu_domain_stage stage;
	union {
		struct arm_smmu_ctx_desc cd;
		struct arm_smmu_s2_cfg s2_cfg;
	} ATTR_PRESERVE_ACCESS_INDEX;
	struct iommu_domain domain;
	struct list_head devices;
	spinlock_t devices_lock;
	bool enforce_cache_coherency: 1;
	bool nest_parent: 1;
	struct mmu_notifier mmu_notifier;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_entry_writer_ops {
	void (*get_used)(const __le64 *, __le64 *);
	void (*sync)(struct arm_smmu_entry_writer *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_impl {
	u32 (*read_reg)(struct arm_smmu_device___2 *, int, int);
	void (*write_reg)(struct arm_smmu_device___2 *, int, int, u32);
	u64 (*read_reg64)(struct arm_smmu_device___2 *, int, int);
	void (*write_reg64)(struct arm_smmu_device___2 *, int, int, u64);
	int (*cfg_probe)(struct arm_smmu_device___2 *);
	int (*reset)(struct arm_smmu_device___2 *);
	int (*init_context)(struct arm_smmu_domain *, struct io_pgtable_cfg *, struct device *);
	void (*tlb_sync)(struct arm_smmu_device___2 *, int, int, int);
	int (*def_domain_type)(struct device *);
	irqreturn_t (*global_fault)(int, void *);
	irqreturn_t (*context_fault)(int, void *);
	bool context_fault_needs_threaded_irq;
	int (*alloc_context_bank)(struct arm_smmu_domain *, struct arm_smmu_device___2 *, struct device *, int);
	void (*write_s2cr)(struct arm_smmu_device___2 *, int);
	void (*write_sctlr)(struct arm_smmu_device___2 *, int, u32);
	void (*probe_finalize)(struct arm_smmu_device___2 *, struct device *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_impl_ops {
	int (*device_reset)(struct arm_smmu_device *);
	void (*device_remove)(struct arm_smmu_device *);
	int (*init_structures)(struct arm_smmu_device *);
	struct arm_smmu_cmdq * (*get_secondary_cmdq)(struct arm_smmu_device *, struct arm_smmu_cmdq_ent *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_stream;

struct arm_smmu_master {
	struct arm_smmu_device *smmu;
	struct device *dev;
	struct arm_smmu_stream *streams;
	struct arm_smmu_ctx_desc_cfg cd_table;
	unsigned int num_streams;
	bool ats_enabled: 1;
	bool ste_ats_enabled: 1;
	bool stall_enabled;
	bool sva_enabled;
	bool iopf_enabled;
	unsigned int ssid_bits;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_master_cfg {
	struct arm_smmu_device___2 *smmu;
	s16 smendx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_master_domain {
	struct list_head devices_elm;
	struct arm_smmu_master *master;
	ioasid_t ssid;
	bool nested_ats_flush: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_match_data {
	enum arm_smmu_arch_version version;
	enum arm_smmu_implementation model;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_vsmmu;

struct arm_smmu_nested_domain {
	struct iommu_domain domain;
	struct arm_vsmmu *vsmmu;
	bool enable_ats: 1;
	__le64 ste[2];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_option_prop {
	u32 opt;
	const char *prop;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_queue_poll {
	ktime_t timeout;
	unsigned int delay;
	unsigned int spin_cnt;
	bool wfe;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_s2cr {
	struct iommu_group *group;
	int count;
	enum arm_smmu_s2cr_type type;
	enum arm_smmu_s2cr_privcfg privcfg;
	u8 cbndx;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_smr {
	u16 mask;
	u16 id;
	bool valid;
	bool pinned;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_ste {
	__le64 data[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_ste_writer {
	struct arm_smmu_entry_writer writer;
	u32 sid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_stream {
	u32 id;
	struct arm_smmu_master *master;
	struct rb_node node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_strtab_l1 {
	__le64 l2ptr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_smmu_strtab_l2 {
	struct arm_smmu_ste stes[256];
} ATTR_PRESERVE_ACCESS_INDEX;

struct iommufd_object {
	refcount_t shortterm_users;
	refcount_t users;
	enum iommufd_object_type type;
	unsigned int id;
} ATTR_PRESERVE_ACCESS_INDEX;

struct iommufd_ctx;

struct iommufd_hwpt_paging;

struct iommufd_viommu_ops;

struct iommufd_viommu {
	struct iommufd_object obj;
	struct iommufd_ctx *ictx;
	struct iommu_device *iommu_dev;
	struct iommufd_hwpt_paging *hwpt;
	const struct iommufd_viommu_ops *ops;
	struct xarray vdevs;
	unsigned int type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arm_vsmmu {
	struct iommufd_viommu core;
	struct arm_smmu_device *smmu;
	struct arm_smmu_domain___2 *s2_parent;
	u16 vmid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct dw_pcie;

struct armada8k_pcie {
	struct dw_pcie *pci;
	struct clk *clk;
	struct clk *clk_reg;
	struct phy *phy[4];
	unsigned int phy_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct armada_37xx_pin_group;

struct armada_37xx_pin_data {
	u8 nr_pins;
	char *name;
	struct armada_37xx_pin_group *groups;
	int ngroups;
} ATTR_PRESERVE_ACCESS_INDEX;

struct armada_37xx_pin_group {
	const char *name;
	unsigned int start_pin;
	unsigned int npins;
	u32 reg_mask;
	u32 val[3];
	unsigned int extra_pin;
	unsigned int extra_npins;
	const char *funcs[3];
	unsigned int *pins;
} ATTR_PRESERVE_ACCESS_INDEX;

struct pinctrl_pin_desc;

struct pinctrl_ops;

struct pinmux_ops;

struct pinconf_ops;

struct pinconf_generic_params;

struct pin_config_item;

struct pinctrl_desc {
	const char *name;
	const struct pinctrl_pin_desc *pins;
	unsigned int npins;
	const struct pinctrl_ops *pctlops;
	const struct pinmux_ops *pmxops;
	const struct pinconf_ops *confops;
	struct module *owner;
	unsigned int num_custom_params;
	const struct pinconf_generic_params *custom_params;
	const struct pin_config_item *custom_conf_items;
	bool link_consumers;
} ATTR_PRESERVE_ACCESS_INDEX;

struct armada_37xx_pm_state {
	u32 out_en_l;
	u32 out_en_h;
	u32 out_val_l;
	u32 out_val_h;
	u32 irq_en_l;
	u32 irq_en_h;
	u32 irq_pol_l;
	u32 irq_pol_h;
	u32 selection;
} ATTR_PRESERVE_ACCESS_INDEX;

struct armada_37xx_pmx_func;

struct armada_37xx_pinctrl {
	struct regmap *regmap;
	void *base;
	const struct armada_37xx_pin_data *data;
	struct device *dev;
	struct gpio_chip gpio_chip;
	raw_spinlock_t irq_lock;
	struct pinctrl_desc pctl;
	struct pinctrl_dev *pctl_dev;
	struct armada_37xx_pin_group *groups;
	unsigned int ngroups;
	struct armada_37xx_pmx_func *funcs;
	unsigned int nfuncs;
	struct armada_37xx_pm_state pm;
} ATTR_PRESERVE_ACCESS_INDEX;

struct armada_37xx_pmx_func {
	const char *name;
	const char **groups;
	unsigned int ngroups;
} ATTR_PRESERVE_ACCESS_INDEX;

struct armctrl_ic {
	void *base;
	void *pending[3];
	void *enable[3];
	void *disable[3];
	struct irq_domain *domain;
} ATTR_PRESERVE_ACCESS_INDEX;

struct armv8pmu_probe_info {
	struct arm_pmu *pmu;
	bool present;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arphdr {
	__be16 ar_hrd;
	__be16 ar_pro;
	unsigned char ar_hln;
	unsigned char ar_pln;
	__be16 ar_op;
} ATTR_PRESERVE_ACCESS_INDEX;

struct sockaddr {
	sa_family_t sa_family;
	union {
		char sa_data_min[14];
		struct {
			struct {} ATTR_PRESERVE_ACCESS_INDEX __empty_sa_data;
			char sa_data[0];
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct arpreq {
	struct sockaddr arp_pa;
	struct sockaddr arp_ha;
	int arp_flags;
	struct sockaddr arp_netmask;
	char arp_dev[16];
} ATTR_PRESERVE_ACCESS_INDEX;

struct trace_array;

struct trace_array_cpu;

struct array_buffer {
	struct trace_array *tr;
	struct trace_buffer *buffer;
	struct trace_array_cpu *data;
	u64 time_start;
	int cpu;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int (*asn1_action_t)(void *, size_t, unsigned char, const void *, size_t);

struct asn1_decoder {
	const unsigned char *machine;
	size_t machlen;
	const asn1_action_t *actions;
} ATTR_PRESERVE_ACCESS_INDEX;

struct assoc_array_ptr;

struct assoc_array {
	struct assoc_array_ptr *root;
	long unsigned int nr_leaves_on_tree;
} ATTR_PRESERVE_ACCESS_INDEX;

struct assoc_array_node;

struct assoc_array_delete_collapse_context {
	struct assoc_array_node *node;
	const void *skip_leaf;
	int slot;
} ATTR_PRESERVE_ACCESS_INDEX;

struct assoc_array_ops;

struct assoc_array_edit {
	struct callback_head rcu;
	struct assoc_array *array;
	const struct assoc_array_ops *ops;
	const struct assoc_array_ops *ops_for_excised_subtree;
	struct assoc_array_ptr *leaf;
	struct assoc_array_ptr **leaf_p;
	struct assoc_array_ptr *dead_leaf;
	struct assoc_array_ptr *new_meta[3];
	struct assoc_array_ptr *excised_meta[1];
	struct assoc_array_ptr *excised_subtree;
	struct assoc_array_ptr **set_backpointers[16];
	struct assoc_array_ptr *set_backpointers_to;
	struct assoc_array_node *adjust_count_on;
	long int adjust_count_by;
	struct {
		struct assoc_array_ptr **ptr;
		struct assoc_array_ptr *to;
	} ATTR_PRESERVE_ACCESS_INDEX set[2];
	struct {
		u8 *p;
		u8 to;
	} ATTR_PRESERVE_ACCESS_INDEX set_parent_slot[1];
	u8 segment_cache[17];
} ATTR_PRESERVE_ACCESS_INDEX;

struct assoc_array_node {
	struct assoc_array_ptr *back_pointer;
	u8 parent_slot;
	struct assoc_array_ptr *slots[16];
	long unsigned int nr_leaves_on_branch;
} ATTR_PRESERVE_ACCESS_INDEX;

struct assoc_array_ops {
	long unsigned int (*get_key_chunk)(const void *, int);
	long unsigned int (*get_object_key_chunk)(const void *, int);
	bool (*compare_object)(const void *, const void *);
	int (*diff_objects)(const void *, const void *);
	void (*free_object)(void *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct assoc_array_shortcut {
	struct assoc_array_ptr *back_pointer;
	int parent_slot;
	int skip_to_level;
	struct assoc_array_ptr *next_node;
	long unsigned int index_key[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct assoc_array_walk_result {
	struct {
		struct assoc_array_node *node;
		int level;
		int slot;
	} ATTR_PRESERVE_ACCESS_INDEX terminal_node;
	struct {
		struct assoc_array_shortcut *shortcut;
		int level;
		int sc_level;
		long unsigned int sc_segments;
		long unsigned int dissimilarity;
	} ATTR_PRESERVE_ACCESS_INDEX wrong_shortcut;
} ATTR_PRESERVE_ACCESS_INDEX;

struct asym_cap_data {
	struct list_head link;
	struct callback_head rcu;
	long unsigned int capacity;
	long unsigned int cpus[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct asymmetric_key_id {
	short unsigned int len;
	unsigned char data[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct asymmetric_key_ids {
	void *id[3];
} ATTR_PRESERVE_ACCESS_INDEX;

struct key_preparsed_payload;

struct asymmetric_key_parser {
	struct list_head link;
	struct module *owner;
	const char *name;
	int (*parse)(struct key_preparsed_payload *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct key;

struct kernel_pkey_params;

struct kernel_pkey_query;

struct public_key_signature;

struct asymmetric_key_subtype {
	struct module *owner;
	const char *name;
	short unsigned int name_len;
	void (*describe)(const struct key *, struct seq_file *);
	void (*destroy)(void *, void *);
	int (*query)(const struct kernel_pkey_params *, struct kernel_pkey_query *);
	int (*eds_op)(struct kernel_pkey_params *, const void *, void *);
	int (*verify_signature)(const struct key *, const struct public_key_signature *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct usb_dev_state;

struct urb;

struct usb_memory;

struct async {
	struct list_head asynclist;
	struct usb_dev_state *ps;
	struct pid *pid;
	const struct cred *cred;
	unsigned int signr;
	unsigned int ifnum;
	void *userbuffer;
	void *userurb;
	sigval_t userurb_sigval;
	struct urb *urb;
	struct usb_memory *usbm;
	unsigned int mem_usage;
	int status;
	u8 bulk_addr;
	u8 bulk_status;
} ATTR_PRESERVE_ACCESS_INDEX;

struct async_domain {
	struct list_head pending;
	unsigned int registered: 1;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef void (*async_func_t)(void *, async_cookie_t);

struct async_entry {
	struct list_head domain_list;
	struct list_head global_list;
	struct work_struct work;
	async_cookie_t cookie;
	async_func_t func;
	void *data;
	struct async_domain *domain;
} ATTR_PRESERVE_ACCESS_INDEX;

struct async_icount {
	__u32 cts;
	__u32 dsr;
	__u32 rng;
	__u32 dcd;
	__u32 tx;
	__u32 rx;
	__u32 frame;
	__u32 parity;
	__u32 overrun;
	__u32 brk;
	__u32 buf_overrun;
} ATTR_PRESERVE_ACCESS_INDEX;

struct io_poll {
	struct file *file;
	struct wait_queue_head *head;
	__poll_t events;
	int retries;
	struct wait_queue_entry wait;
} ATTR_PRESERVE_ACCESS_INDEX;

struct async_poll {
	struct io_poll poll;
	struct io_poll *double_poll;
} ATTR_PRESERVE_ACCESS_INDEX;

struct cache_sb;

struct cache_sb_disk;

struct async_reg_args {
	struct delayed_work reg_work;
	char *path;
	struct cache_sb *sb;
	struct cache_sb_disk *sb_disk;
	struct file *bdev_file;
	void *holder;
} ATTR_PRESERVE_ACCESS_INDEX;

struct async_scan_data {
	struct list_head list;
	struct Scsi_Host *shost;
	struct completion prev_finished;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_acpi_drive {
	u32 pio;
	u32 dma;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_acpi_gtf {
	u8 tf[7];
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_acpi_gtm {
	struct ata_acpi_drive drive[2];
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_device;

struct ata_acpi_hotplug_context {
	struct acpi_hotplug_context hp;
	union {
		struct ata_port *ap;
		struct ata_device *dev;
	} ATTR_PRESERVE_ACCESS_INDEX data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_bmdma_prd {
	__le32 addr;
	__le32 flags_len;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_cdl {
	u8 desc_log_buf[512];
	u8 ncq_sense_log_buf[1024];
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_cpr {
	u8 num;
	u8 num_storage_elements;
	u64 start_lba;
	u64 num_lbas;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_cpr_log {
	u8 nr_cpr;
	struct ata_cpr cpr[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_dev_quirks_entry {
	const char *model_num;
	const char *model_rev;
	unsigned int quirks;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_ering_entry {
	unsigned int eflags;
	unsigned int err_mask;
	u64 timestamp;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_ering {
	int cursor;
	struct ata_ering_entry ring[32];
} ATTR_PRESERVE_ACCESS_INDEX;

struct scsi_device;

struct ata_device {
	struct ata_link *link;
	unsigned int devno;
	unsigned int quirks;
	long unsigned int flags;
	struct scsi_device *sdev;
	void *private_data;
	union acpi_object *gtf_cache;
	unsigned int gtf_filter;
	struct device tdev;
	u64 n_sectors;
	u64 n_native_sectors;
	unsigned int class;
	long unsigned int unpark_deadline;
	u8 pio_mode;
	u8 dma_mode;
	u8 xfer_mode;
	unsigned int xfer_shift;
	unsigned int multi_count;
	unsigned int max_sectors;
	unsigned int cdb_len;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	u16 cylinders;
	u16 heads;
	u16 sectors;
	union {
		u16 id[256];
		u32 gscr[128];
	} ATTR_PRESERVE_ACCESS_INDEX;
	u8 devslp_timing[8];
	u8 ncq_send_recv_cmds[20];
	u8 ncq_non_data_cmds[64];
	u32 zac_zoned_cap;
	u32 zac_zones_optimal_open;
	u32 zac_zones_optimal_nonseq;
	u32 zac_zones_max_open;
	struct ata_cpr_log *cpr_log;
	struct ata_cdl *cdl;
	int spdn_cnt;
	struct ata_ering ering;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	u8 sector_buf[512];
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_eh_cmd_timeout_ent {
	const u8 *commands;
	const unsigned int *timeouts;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_eh_info {
	struct ata_device *dev;
	u32 serror;
	unsigned int err_mask;
	unsigned int action;
	unsigned int dev_action[2];
	unsigned int flags;
	unsigned int probe_mask;
	char desc[80];
	int desc_len;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_eh_context {
	struct ata_eh_info i;
	int tries[2];
	int cmd_timeout_idx[16];
	unsigned int classes[2];
	unsigned int did_probe_mask;
	unsigned int unloaded_mask;
	unsigned int saved_ncq_enabled;
	u8 saved_xfer_mode[2];
	long unsigned int last_reset;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_force_param {
	const char *name;
	u8 cbl;
	u8 spd_limit;
	unsigned int xfer_mask;
	unsigned int quirk_on;
	unsigned int quirk_off;
	u16 lflags_on;
	u16 lflags_off;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_force_ent {
	int port;
	int device;
	struct ata_force_param param;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_port_operations;

struct ata_host {
	spinlock_t lock;
	struct device *dev;
	void * const *iomap;
	unsigned int n_ports;
	unsigned int n_tags;
	void *private_data;
	struct ata_port_operations *ops;
	long unsigned int flags;
	struct kref kref;
	struct mutex eh_mutex;
	struct task_struct *eh_owner;
	struct ata_port *simplex_claimed;
	struct ata_port *ports[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct transport_container {
	struct attribute_container ac;
	const struct attribute_group *statistics;
} ATTR_PRESERVE_ACCESS_INDEX;

struct scsi_transport_template {
	struct transport_container host_attrs;
	struct transport_container target_attrs;
	struct transport_container device_attrs;
	int (*user_scan)(struct Scsi_Host *, uint, uint, u64);
	int device_size;
	int device_private_offset;
	int target_size;
	int target_private_offset;
	int host_size;
	unsigned int create_work_queue: 1;
	void (*eh_strategy_handler)(struct Scsi_Host *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_internal {
	struct scsi_transport_template t;
	struct device_attribute private_port_attrs[3];
	struct device_attribute private_link_attrs[3];
	struct device_attribute private_dev_attrs[9];
	struct transport_container link_attr_cont;
	struct transport_container dev_attr_cont;
	struct device_attribute *link_attrs[4];
	struct device_attribute *port_attrs[4];
	struct device_attribute *dev_attrs[10];
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_ioports {
	void *cmd_addr;
	void *data_addr;
	void *error_addr;
	void *feature_addr;
	void *nsect_addr;
	void *lbal_addr;
	void *lbam_addr;
	void *lbah_addr;
	void *device_addr;
	void *status_addr;
	void *command_addr;
	void *altstatus_addr;
	void *ctl_addr;
	void *bmdma_addr;
	void *scr_addr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_link {
	struct ata_port *ap;
	int pmp;
	struct device tdev;
	unsigned int active_tag;
	u32 sactive;
	unsigned int flags;
	u32 saved_scontrol;
	unsigned int hw_sata_spd_limit;
	unsigned int sata_spd_limit;
	unsigned int sata_spd;
	enum ata_lpm_policy lpm_policy;
	struct ata_eh_info eh_info;
	struct ata_eh_context eh_context;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	struct ata_device device[2];
	long unsigned int last_lpm_change;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_taskfile {
	long unsigned int flags;
	u8 protocol;
	u8 ctl;
	u8 hob_feature;
	u8 hob_nsect;
	u8 hob_lbal;
	u8 hob_lbam;
	u8 hob_lbah;
	union {
		u8 error;
		u8 feature;
	} ATTR_PRESERVE_ACCESS_INDEX;
	u8 nsect;
	u8 lbal;
	u8 lbam;
	u8 lbah;
	u8 device;
	union {
		u8 status;
		u8 command;
	} ATTR_PRESERVE_ACCESS_INDEX;
	u32 auxiliary;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_queued_cmd;

typedef void (*ata_qc_cb_t)(struct ata_queued_cmd *);

struct scsi_cmnd;

struct ata_queued_cmd {
	struct ata_port *ap;
	struct ata_device *dev;
	struct scsi_cmnd *scsicmd;
	void (*scsidone)(struct scsi_cmnd *);
	struct ata_taskfile tf;
	u8 cdb[16];
	long unsigned int flags;
	unsigned int tag;
	unsigned int hw_tag;
	unsigned int n_elem;
	unsigned int orig_n_elem;
	int dma_dir;
	unsigned int sect_size;
	unsigned int nbytes;
	unsigned int extrabytes;
	unsigned int curbytes;
	struct scatterlist sgent;
	struct scatterlist *sg;
	struct scatterlist *cursg;
	unsigned int cursg_ofs;
	unsigned int err_mask;
	struct ata_taskfile result_tf;
	ata_qc_cb_t complete_fn;
	void *private_data;
	void *lldd_task;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_port_stats {
	long unsigned int unhandled_irq;
	long unsigned int idle_irq;
	long unsigned int rw_reqbuf;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_port {
	struct Scsi_Host *scsi_host;
	struct ata_port_operations *ops;
	spinlock_t *lock;
	long unsigned int flags;
	unsigned int pflags;
	unsigned int print_id;
	unsigned int port_no;
	struct ata_ioports ioaddr;
	u8 ctl;
	u8 last_ctl;
	struct ata_link *sff_pio_task_link;
	struct delayed_work sff_pio_task;
	struct ata_bmdma_prd *bmdma_prd;
	dma_addr_t bmdma_prd_dma;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	unsigned int cbl;
	struct ata_queued_cmd qcmd[33];
	u64 qc_active;
	int nr_active_links;
	long: 64;
	long: 64;
	struct ata_link link;
	struct ata_link *slave_link;
	int nr_pmp_links;
	struct ata_link *pmp_link;
	struct ata_link *excl_link;
	struct ata_port_stats stats;
	struct ata_host *host;
	struct device *dev;
	struct device tdev;
	struct mutex scsi_scan_mutex;
	struct delayed_work hotplug_task;
	struct delayed_work scsi_rescan_task;
	unsigned int hsm_task_state;
	struct list_head eh_done_q;
	wait_queue_head_t eh_wait_q;
	int eh_tries;
	struct completion park_req_pending;
	pm_message_t pm_mesg;
	enum ata_lpm_policy target_lpm_policy;
	struct timer_list fastdrain_timer;
	unsigned int fastdrain_cnt;
	async_cookie_t cookie;
	int em_message_type;
	void *private_data;
	struct ata_acpi_gtm __acpi_init_gtm;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
	long: 64;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_port_info {
	long unsigned int flags;
	long unsigned int link_flags;
	unsigned int pio_mask;
	unsigned int mwdma_mask;
	unsigned int udma_mask;
	struct ata_port_operations *port_ops;
	void *private_data;
} ATTR_PRESERVE_ACCESS_INDEX;

typedef int (*ata_prereset_fn_t)(struct ata_link *, long unsigned int);

typedef int (*ata_reset_fn_t)(struct ata_link *, unsigned int *, long unsigned int);

typedef void (*ata_postreset_fn_t)(struct ata_link *, unsigned int *);

struct ata_port_operations {
	int (*qc_defer)(struct ata_queued_cmd *);
	int (*check_atapi_dma)(struct ata_queued_cmd *);
	enum ata_completion_errors (*qc_prep)(struct ata_queued_cmd *);
	unsigned int (*qc_issue)(struct ata_queued_cmd *);
	void (*qc_fill_rtf)(struct ata_queued_cmd *);
	void (*qc_ncq_fill_rtf)(struct ata_port *, u64);
	int (*cable_detect)(struct ata_port *);
	unsigned int (*mode_filter)(struct ata_device *, unsigned int);
	void (*set_piomode)(struct ata_port *, struct ata_device *);
	void (*set_dmamode)(struct ata_port *, struct ata_device *);
	int (*set_mode)(struct ata_link *, struct ata_device **);
	unsigned int (*read_id)(struct ata_device *, struct ata_taskfile *, __le16 *);
	void (*dev_config)(struct ata_device *);
	void (*freeze)(struct ata_port *);
	void (*thaw)(struct ata_port *);
	ata_prereset_fn_t prereset;
	ata_reset_fn_t softreset;
	ata_reset_fn_t hardreset;
	ata_postreset_fn_t postreset;
	ata_prereset_fn_t pmp_prereset;
	ata_reset_fn_t pmp_softreset;
	ata_reset_fn_t pmp_hardreset;
	ata_postreset_fn_t pmp_postreset;
	void (*error_handler)(struct ata_port *);
	void (*lost_interrupt)(struct ata_port *);
	void (*post_internal_cmd)(struct ata_queued_cmd *);
	void (*sched_eh)(struct ata_port *);
	void (*end_eh)(struct ata_port *);
	int (*scr_read)(struct ata_link *, unsigned int, u32 *);
	int (*scr_write)(struct ata_link *, unsigned int, u32);
	void (*pmp_attach)(struct ata_port *);
	void (*pmp_detach)(struct ata_port *);
	int (*set_lpm)(struct ata_link *, enum ata_lpm_policy, unsigned int);
	int (*port_suspend)(struct ata_port *, pm_message_t);
	int (*port_resume)(struct ata_port *);
	int (*port_start)(struct ata_port *);
	void (*port_stop)(struct ata_port *);
	void (*host_stop)(struct ata_host *);
	void (*sff_dev_select)(struct ata_port *, unsigned int);
	void (*sff_set_devctl)(struct ata_port *, u8);
	u8 (*sff_check_status)(struct ata_port *);
	u8 (*sff_check_altstatus)(struct ata_port *);
	void (*sff_tf_load)(struct ata_port *, const struct ata_taskfile *);
	void (*sff_tf_read)(struct ata_port *, struct ata_taskfile *);
	void (*sff_exec_command)(struct ata_port *, const struct ata_taskfile *);
	unsigned int (*sff_data_xfer)(struct ata_queued_cmd *, unsigned char *, unsigned int, int);
	void (*sff_irq_on)(struct ata_port *);
	bool (*sff_irq_check)(struct ata_port *);
	void (*sff_irq_clear)(struct ata_port *);
	void (*sff_drain_fifo)(struct ata_queued_cmd *);
	void (*bmdma_setup)(struct ata_queued_cmd *);
	void (*bmdma_start)(struct ata_queued_cmd *);
	void (*bmdma_stop)(struct ata_queued_cmd *);
	u8 (*bmdma_status)(struct ata_port *);
	ssize_t (*em_show)(struct ata_port *, char *);
	ssize_t (*em_store)(struct ata_port *, const char *, size_t);
	ssize_t (*sw_activity_show)(struct ata_device *, char *);
	ssize_t (*sw_activity_store)(struct ata_device *, enum sw_activity);
	ssize_t (*transmit_led_message)(struct ata_port *, u32, ssize_t);
	const struct ata_port_operations *inherits;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_show_ering_arg {
	char *buf;
	int written;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_timing {
	short unsigned int mode;
	short unsigned int setup;
	short unsigned int act8b;
	short unsigned int rec8b;
	short unsigned int cyc8b;
	short unsigned int active;
	short unsigned int recover;
	short unsigned int dmack_hold;
	short unsigned int cycle;
	short unsigned int udma;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ata_xfer_ent {
	int shift;
	int bits;
	u8 base;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ate_acpi_oem_info {
	char oem_id[7];
	char oem_table_id[9];
	u32 oem_revision;
} ATTR_PRESERVE_ACCESS_INDEX;

struct ps2dev;

typedef enum ps2_disposition (*ps2_pre_receive_handler_t)(struct ps2dev *, u8, unsigned int);

typedef void (*ps2_receive_handler_t)(struct ps2dev *, u8);

struct serio;

struct ps2dev {
	struct serio *serio;
	struct mutex cmd_mutex;
	wait_queue_head_t wait;
	long unsigned int flags;
	u8 cmdbuf[8];
	u8 cmdcnt;
	u8 nak;
	ps2_pre_receive_handler_t pre_receive_handler;
	ps2_receive_handler_t receive_handler;
} ATTR_PRESERVE_ACCESS_INDEX;

struct vivaldi_data {
	u32 function_row_physmap[24];
	unsigned int num_function_row_keys;
} ATTR_PRESERVE_ACCESS_INDEX;

struct atkbd {
	struct ps2dev ps2dev;
	struct input_dev *dev;
	char name[64];
	char phys[32];
	short unsigned int id;
	short unsigned int keycode[512];
	long unsigned int force_release_mask[8];
	unsigned char set;
	bool translated;
	bool extra;
	bool write;
	bool softrepeat;
	bool softraw;
	bool scroll;
	bool enabled;
	unsigned char emul;
	bool resend;
	bool release;
	long unsigned int xl_bit;
	unsigned int last;
	long unsigned int time;
	long unsigned int err_count;
	struct delayed_work event_work;
	long unsigned int event_jiffies;
	long unsigned int event_mask;
	struct mutex mutex;
	struct vivaldi_data vdata;
} ATTR_PRESERVE_ACCESS_INDEX;

struct atomic_notifier_head {
	spinlock_t lock;
	struct notifier_block *head;
} ATTR_PRESERVE_ACCESS_INDEX;

struct attribute_group {
	const char *name;
	umode_t (*is_visible)(struct kobject *, struct attribute *, int);
	umode_t (*is_bin_visible)(struct kobject *, const struct bin_attribute *, int);
	size_t (*bin_size)(struct kobject *, const struct bin_attribute *, int);
	struct attribute **attrs;
	union {
		struct bin_attribute **bin_attrs;
		const struct bin_attribute * const *bin_attrs_new;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_aux_data {
	struct audit_aux_data *next;
	int type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_cap_data {
	kernel_cap_t permitted;
	kernel_cap_t inheritable;
	union {
		unsigned int fE;
		kernel_cap_t effective;
	} ATTR_PRESERVE_ACCESS_INDEX;
	kernel_cap_t ambient;
	kuid_t rootid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_aux_data_bprm_fcaps {
	struct audit_aux_data d;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	struct audit_cap_data old_pcap;
	struct audit_cap_data new_pcap;
} ATTR_PRESERVE_ACCESS_INDEX;

struct lsm_prop_selinux {
	u32 secid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct lsm_prop_smack {} ATTR_PRESERVE_ACCESS_INDEX;

struct lsm_prop_apparmor {} ATTR_PRESERVE_ACCESS_INDEX;

struct lsm_prop_bpf {
	u32 secid;
} ATTR_PRESERVE_ACCESS_INDEX;

struct lsm_prop {
	struct lsm_prop_selinux selinux;
	struct lsm_prop_smack smack;
	struct lsm_prop_apparmor apparmor;
	struct lsm_prop_bpf bpf;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_aux_data_pids {
	struct audit_aux_data d;
	pid_t target_pid[16];
	kuid_t target_auid[16];
	kuid_t target_uid[16];
	unsigned int target_sessionid[16];
	struct lsm_prop target_ref[16];
	char target_comm[256];
	int pid_count;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_context;

struct audit_buffer {
	struct sk_buff *skb;
	struct audit_context *ctx;
	gfp_t gfp_mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_tree;

struct audit_node {
	struct list_head list;
	struct audit_tree *owner;
	unsigned int index;
} ATTR_PRESERVE_ACCESS_INDEX;

struct fsnotify_mark;

struct audit_chunk {
	struct list_head hash;
	long unsigned int key;
	struct fsnotify_mark *mark;
	struct list_head trees;
	int count;
	atomic_long_t refs;
	struct callback_head head;
	struct audit_node owners[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct timespec64 {
	time64_t tv_sec;
	long int tv_nsec;
} ATTR_PRESERVE_ACCESS_INDEX;

struct filename;

struct audit_names {
	struct list_head list;
	struct filename *name;
	int name_len;
	bool hidden;
	long unsigned int ino;
	dev_t dev;
	umode_t mode;
	kuid_t uid;
	kgid_t gid;
	dev_t rdev;
	struct lsm_prop oprop;
	struct audit_cap_data fcap;
	unsigned int fcap_ver;
	unsigned char type;
	bool should_free;
} ATTR_PRESERVE_ACCESS_INDEX;

struct vfsmount;

struct path {
	struct vfsmount *mnt;
	struct dentry *dentry;
} ATTR_PRESERVE_ACCESS_INDEX;

struct mq_attr {
	__kernel_long_t mq_flags;
	__kernel_long_t mq_maxmsg;
	__kernel_long_t mq_msgsize;
	__kernel_long_t mq_curmsgs;
	__kernel_long_t __reserved[4];
} ATTR_PRESERVE_ACCESS_INDEX;

struct open_how {
	__u64 flags;
	__u64 mode;
	__u64 resolve;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_ntp_val {
	long long int oldval;
	long long int newval;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_ntp_data {
	struct audit_ntp_val vals[6];
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_proctitle {
	int len;
	char *value;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_tree_refs;

struct audit_context {
	int dummy;
	enum {
		AUDIT_CTX_UNUSED = 0,
		AUDIT_CTX_SYSCALL = 1,
		AUDIT_CTX_URING = 2,
	} context;
	enum audit_state state;
	enum audit_state current_state;
	unsigned int serial;
	int major;
	int uring_op;
	struct timespec64 ctime;
	long unsigned int argv[4];
	long int return_code;
	u64 prio;
	int return_valid;
	struct audit_names preallocated_names[5];
	int name_count;
	struct list_head names_list;
	char *filterkey;
	struct path pwd;
	struct audit_aux_data *aux;
	struct audit_aux_data *aux_pids;
	struct __kernel_sockaddr_storage *sockaddr;
	size_t sockaddr_len;
	pid_t ppid;
	kuid_t uid;
	kuid_t euid;
	kuid_t suid;
	kuid_t fsuid;
	kgid_t gid;
	kgid_t egid;
	kgid_t sgid;
	kgid_t fsgid;
	long unsigned int personality;
	int arch;
	pid_t target_pid;
	kuid_t target_auid;
	kuid_t target_uid;
	unsigned int target_sessionid;
	struct lsm_prop target_ref;
	char target_comm[16];
	struct audit_tree_refs *trees;
	struct audit_tree_refs *first_trees;
	struct list_head killed_trees;
	int tree_count;
	int type;
	union {
		struct {
			int nargs;
			long int args[6];
		} ATTR_PRESERVE_ACCESS_INDEX socketcall;
		struct {
			kuid_t uid;
			kgid_t gid;
			umode_t mode;
			struct lsm_prop oprop;
			int has_perm;
			uid_t perm_uid;
			gid_t perm_gid;
			umode_t perm_mode;
			long unsigned int qbytes;
		} ATTR_PRESERVE_ACCESS_INDEX ipc;
		struct {
			mqd_t mqdes;
			struct mq_attr mqstat;
		} ATTR_PRESERVE_ACCESS_INDEX mq_getsetattr;
		struct {
			mqd_t mqdes;
			int sigev_signo;
		} ATTR_PRESERVE_ACCESS_INDEX mq_notify;
		struct {
			mqd_t mqdes;
			size_t msg_len;
			unsigned int msg_prio;
			struct timespec64 abs_timeout;
		} ATTR_PRESERVE_ACCESS_INDEX mq_sendrecv;
		struct {
			int oflag;
			umode_t mode;
			struct mq_attr attr;
		} ATTR_PRESERVE_ACCESS_INDEX mq_open;
		struct {
			pid_t pid;
			struct audit_cap_data cap;
		} ATTR_PRESERVE_ACCESS_INDEX capset;
		struct {
			int fd;
			int flags;
		} ATTR_PRESERVE_ACCESS_INDEX mmap;
		struct open_how openat2;
		struct {
			int argc;
		} ATTR_PRESERVE_ACCESS_INDEX execve;
		struct {
			char *name;
		} ATTR_PRESERVE_ACCESS_INDEX module;
		struct {
			struct audit_ntp_data ntp_data;
			struct timespec64 tk_injoffset;
		} ATTR_PRESERVE_ACCESS_INDEX time;
	} ATTR_PRESERVE_ACCESS_INDEX;
	int fds[2];
	struct audit_proctitle proctitle;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_ctl_mutex {
	struct mutex lock;
	void *owner;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_field;

struct audit_watch;

struct audit_fsnotify_mark;

struct audit_krule {
	u32 pflags;
	u32 flags;
	u32 listnr;
	u32 action;
	u32 mask[64];
	u32 buflen;
	u32 field_count;
	char *filterkey;
	struct audit_field *fields;
	struct audit_field *arch_f;
	struct audit_field *inode_f;
	struct audit_watch *watch;
	struct audit_tree *tree;
	struct audit_fsnotify_mark *exe;
	struct list_head rlist;
	struct list_head list;
	u64 prio;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_entry {
	struct list_head list;
	struct callback_head rcu;
	struct audit_krule rule;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_features {
	__u32 vers;
	__u32 mask;
	__u32 features;
	__u32 lock;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_field {
	u32 type;
	union {
		u32 val;
		kuid_t uid;
		kgid_t gid;
		struct {
			char *lsm_str;
			void *lsm_rule;
		} ATTR_PRESERVE_ACCESS_INDEX;
	} ATTR_PRESERVE_ACCESS_INDEX;
	u32 op;
} ATTR_PRESERVE_ACCESS_INDEX;

struct fsnotify_group;

struct fsnotify_mark_connector;

struct fsnotify_mark {
	__u32 mask;
	refcount_t refcnt;
	struct fsnotify_group *group;
	struct list_head g_list;
	spinlock_t lock;
	struct hlist_node obj_list;
	struct fsnotify_mark_connector *connector;
	__u32 ignore_mask;
	unsigned int flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_fsnotify_mark {
	dev_t dev;
	long unsigned int ino;
	char *path;
	struct fsnotify_mark mark;
	struct audit_krule *rule;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_net {
	struct sock *sk;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_netlink_list {
	__u32 portid;
	struct net *net;
	struct sk_buff_head q;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_nfcfgop_tab {
	enum audit_nfcfgop op;
	const char *s;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_parent {
	struct list_head watches;
	struct fsnotify_mark mark;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_reply {
	__u32 portid;
	struct net *net;
	struct sk_buff *skb;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_rule_data {
	__u32 flags;
	__u32 action;
	__u32 field_count;
	__u32 mask[64];
	__u32 fields[64];
	__u32 values[64];
	__u32 fieldflags[64];
	__u32 buflen;
	char buf[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_sig_info {
	uid_t uid;
	pid_t pid;
	char ctx[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_status {
	__u32 mask;
	__u32 enabled;
	__u32 failure;
	__u32 pid;
	__u32 rate_limit;
	__u32 backlog_limit;
	__u32 lost;
	__u32 backlog;
	union {
		__u32 version;
		__u32 feature_bitmap;
	} ATTR_PRESERVE_ACCESS_INDEX;
	__u32 backlog_wait_time;
	__u32 backlog_wait_time_actual;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_tree {
	refcount_t count;
	int goner;
	struct audit_chunk *root;
	struct list_head chunks;
	struct list_head rules;
	struct list_head list;
	struct list_head same_root;
	struct callback_head head;
	char pathname[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_tree_mark {
	struct fsnotify_mark mark;
	struct audit_chunk *chunk;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_tree_refs {
	struct audit_tree_refs *next;
	struct audit_chunk *c[31];
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_tty_status {
	__u32 enabled;
	__u32 log_passwd;
} ATTR_PRESERVE_ACCESS_INDEX;

struct audit_watch {
	refcount_t count;
	dev_t dev;
	char *path;
	long unsigned int ino;
	struct audit_parent *parent;
	struct list_head wlist;
	struct list_head rules;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auditd_connection {
	struct pid *pid;
	u32 portid;
	struct net *net;
	struct callback_head rcu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auth_cred {
	const struct cred *cred;
	const char *principal;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auth_ops;

struct auth_domain {
	struct kref ref;
	struct hlist_node hash;
	char *name;
	struct auth_ops *flavour;
	struct callback_head callback_head;
} ATTR_PRESERVE_ACCESS_INDEX;

struct svc_rqst;

struct auth_ops {
	char *name;
	struct module *owner;
	int flavour;
	enum svc_auth_status (*accept)(struct svc_rqst *);
	int (*release)(struct svc_rqst *);
	void (*domain_release)(struct auth_domain *);
	enum svc_auth_status (*set_client)(struct svc_rqst *);
	rpc_authflavor_t (*pseudoflavor)(struct svc_rqst *);
} ATTR_PRESERVE_ACCESS_INDEX;

struct auto_mode_param {
	int qp_type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auto_movable_group_stats {
	long unsigned int movable_pages;
	long unsigned int req_kernel_early_pages;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auto_movable_stats {
	long unsigned int kernel_early_pages;
	long unsigned int movable_pages;
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_dev_ioctl {
	__u32 ver_major;
	__u32 ver_minor;
	__u32 size;
	__s32 ioctlfd;
	union {
		struct args_protover protover;
		struct args_protosubver protosubver;
		struct args_openmount openmount;
		struct args_ready ready;
		struct args_fail fail;
		struct args_setpipefd setpipefd;
		struct args_timeout timeout;
		struct args_requester requester;
		struct args_expire expire;
		struct args_askumount askumount;
		struct args_ismountpoint ismountpoint;
	} ATTR_PRESERVE_ACCESS_INDEX;
	char path[0];
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_fs_context {
	kuid_t uid;
	kgid_t gid;
	int pgrp;
	bool pgrp_set;
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_sb_info;

struct autofs_info {
	struct dentry *dentry;
	int flags;
	struct completion expire_complete;
	struct list_head active;
	struct list_head expiring;
	struct autofs_sb_info *sbi;
	long unsigned int exp_timeout;
	long unsigned int last_used;
	int count;
	kuid_t uid;
	kgid_t gid;
	struct callback_head rcu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_packet_hdr {
	int proto_version;
	int type;
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_packet_expire {
	struct autofs_packet_hdr hdr;
	int len;
	char name[256];
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_packet_expire_multi {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_packet_missing {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	int len;
	char name[256];
} ATTR_PRESERVE_ACCESS_INDEX;

union autofs_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_packet_missing missing;
	struct autofs_packet_expire expire;
	struct autofs_packet_expire_multi expire_multi;
} ATTR_PRESERVE_ACCESS_INDEX;

struct super_block;

struct autofs_wait_queue;

struct autofs_sb_info {
	u32 magic;
	int pipefd;
	struct file *pipe;
	struct pid *oz_pgrp;
	int version;
	int sub_version;
	int min_proto;
	int max_proto;
	unsigned int flags;
	long unsigned int exp_timeout;
	unsigned int type;
	struct super_block *sb;
	struct mutex wq_mutex;
	struct mutex pipe_mutex;
	spinlock_t fs_lock;
	struct autofs_wait_queue *queues;
	spinlock_t lookup_lock;
	struct list_head active_list;
	struct list_head expiring_list;
	struct callback_head rcu;
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_v5_packet {
	struct autofs_packet_hdr hdr;
	autofs_wqt_t wait_queue_token;
	__u32 dev;
	__u64 ino;
	__u32 uid;
	__u32 gid;
	__u32 pid;
	__u32 tgid;
	__u32 len;
	char name[256];
} ATTR_PRESERVE_ACCESS_INDEX;

typedef struct autofs_v5_packet autofs_packet_expire_direct_t;

typedef struct autofs_v5_packet autofs_packet_expire_indirect_t;

typedef struct autofs_v5_packet autofs_packet_missing_direct_t;

typedef struct autofs_v5_packet autofs_packet_missing_indirect_t;

union autofs_v5_packet_union {
	struct autofs_packet_hdr hdr;
	struct autofs_v5_packet v5_packet;
	autofs_packet_missing_indirect_t missing_indirect;
	autofs_packet_expire_indirect_t expire_indirect;
	autofs_packet_missing_direct_t missing_direct;
	autofs_packet_expire_direct_t expire_direct;
} ATTR_PRESERVE_ACCESS_INDEX;

struct qstr {
	union {
		struct {
			u32 hash;
			u32 len;
		} ATTR_PRESERVE_ACCESS_INDEX;
		u64 hash_len;
	} ATTR_PRESERVE_ACCESS_INDEX;
	const unsigned char *name;
} ATTR_PRESERVE_ACCESS_INDEX;

struct autofs_wait_queue {
	wait_queue_head_t queue;
	struct autofs_wait_queue *next;
	autofs_wqt_t wait_queue_token;
	struct qstr name;
	u32 offset;
	u32 dev;
	u64 ino;
	kuid_t uid;
	kgid_t gid;
	pid_t pid;
	pid_t tgid;
	int status;
	unsigned int wait_ctr;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auxiliary_device {
	struct device dev;
	const char *name;
	u32 id;
	struct {
		struct xarray irqs;
		struct mutex lock;
		bool irq_dir_exists;
	} ATTR_PRESERVE_ACCESS_INDEX sysfs;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auxiliary_device_id {
	char name[32];
	kernel_ulong_t driver_data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auxiliary_driver {
	int (*probe)(struct auxiliary_device *, const struct auxiliary_device_id *);
	void (*remove)(struct auxiliary_device *);
	void (*shutdown)(struct auxiliary_device *);
	int (*suspend)(struct auxiliary_device *, pm_message_t);
	int (*resume)(struct auxiliary_device *);
	const char *name;
	struct device_driver driver;
	const struct auxiliary_device_id *id_table;
} ATTR_PRESERVE_ACCESS_INDEX;

struct auxiliary_irq_info {
	struct device_attribute sysfs_attr;
	char name[11];
} ATTR_PRESERVE_ACCESS_INDEX;

struct av_decision {
	u32 allowed;
	u32 auditallow;
	u32 auditdeny;
	u32 seqno;
	u32 flags;
} ATTR_PRESERVE_ACCESS_INDEX;

struct hlist_head {
	struct hlist_node *first;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avc_cache {
	struct hlist_head slots[512];
	spinlock_t slots_lock[512];
	atomic_t lru_hint;
	atomic_t active_nodes;
	u32 latest_notif;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avc_cache_stats {
	unsigned int lookups;
	unsigned int misses;
	unsigned int allocations;
	unsigned int reclaims;
	unsigned int frees;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avc_callback_node {
	int (*callback)(u32);
	u32 events;
	struct avc_callback_node *next;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avc_xperms_node;

struct avc_entry {
	u32 ssid;
	u32 tsid;
	u16 tclass;
	struct av_decision avd;
	struct avc_xperms_node *xp_node;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avc_node {
	struct avc_entry ae;
	struct hlist_node list;
	struct callback_head rhead;
} ATTR_PRESERVE_ACCESS_INDEX;

struct extended_perms_data;

struct extended_perms_decision {
	u8 used;
	u8 driver;
	struct extended_perms_data *allowed;
	struct extended_perms_data *auditallow;
	struct extended_perms_data *dontaudit;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avc_xperms_decision_node {
	struct extended_perms_decision xpd;
	struct list_head xpd_list;
} ATTR_PRESERVE_ACCESS_INDEX;

struct extended_perms_data {
	u32 p[8];
} ATTR_PRESERVE_ACCESS_INDEX;

struct extended_perms {
	u16 len;
	struct extended_perms_data drivers;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avc_xperms_node {
	struct extended_perms xp;
	struct list_head xpd_head;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avtab_node;

struct avtab {
	struct avtab_node **htable;
	u32 nel;
	u32 nslot;
	u32 mask;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avtab_extended_perms;

struct avtab_datum {
	union {
		u32 data;
		struct avtab_extended_perms *xperms;
	} ATTR_PRESERVE_ACCESS_INDEX u;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avtab_extended_perms {
	u8 specified;
	u8 driver;
	struct extended_perms_data perms;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avtab_key {
	u16 source_type;
	u16 target_type;
	u16 target_class;
	u16 specified;
} ATTR_PRESERVE_ACCESS_INDEX;

struct avtab_node {
	struct avtab_key key;
	struct avtab_datum datum;
	struct avtab_node *next;
} ATTR_PRESERVE_ACCESS_INDEX;

struct regmap_irq_chip_data;

struct mfd_cell;

struct regmap_irq_chip;

struct axp20x_dev {
	struct device *dev;
	int irq;
	long unsigned int irq_flags;
	struct regmap *regmap;
	struct regmap_irq_chip_data *regmap_irqc;
	enum axp20x_variants variant;
	int nr_cells;
	const struct mfd_cell *cells;
	const struct regmap_config *regmap_cfg;
	const struct regmap_irq_chip *regmap_irq_chip;
} ATTR_PRESERVE_ACCESS_INDEX;

struct backing_aio {
	struct kiocb iocb;
	refcount_t ref;
	struct kiocb *orig_iocb;
	void (*end_write)(struct kiocb *, ssize_t);
	struct work_struct work;
	long int res;
} ATTR_PRESERVE_ACCESS_INDEX;

struct percpu_counter {
	raw_spinlock_t lock;
	s64 count;
	struct list_head list;
	s32 *counters;
} ATTR_PRESERVE_ACCESS_INDEX;

struct fprop_local_percpu {
	struct percpu_counter events;
	unsigned int period;
	raw_spinlock_t lock;
} ATTR_PRESERVE_ACCESS_INDEX;

struct percpu_ref_data;

struct percpu_ref {
	long unsigned int percpu_count_ptr;
	struct percpu_ref_data *data;
} ATTR_PRESERVE_ACCESS_INDEX;

struct backing_dev_info;

struct cgroup_subsys_state;

struct bdi_writeback {
	struct backing_dev_info *bdi;
	long unsigned int state;
	long unsigned int last_old_flush;
	struct list_head b_dirty;
	struct list_head b_io;
	struct list_head b_more_io;
	struct list_head b_dirty_time;
	spinlock_t list_lock;
	atomic_t writeback_inodes;
	struct percpu_counter stat[4];
	long unsigned int bw_time_stamp;
	long unsigned int dirtied_stamp;
	long unsigned int written_stamp;
	long unsigned int write_bandwidth;
	long unsigned int avg_write_bandwidth;
	long unsigned int dirty_ratelimit;
	long unsigned int balanced_dirty_ratelimit;
	struct fprop_local_percpu completions;
	int dirty_exceeded;
	enum wb_reason start_all_reason;
	spinlock_t work_lock;
	struct list_head work_list;
	struct delayed_work dwork;
	struct delayed_work bw_dwork;
	struct list_head bdi_node;
	struct percpu_ref refcnt;
	struct fprop_local_percpu memcg_completions;
	struct cgroup_subsys_state *memcg_css;
	struct cgroup_subsys_state *blkcg_css;
	struct list_head memcg_node;
	struct list_head blkcg_node;
	struct list_head b_attached;
	struct list_head offline_node;
	union {
		struct work_struct release_work;
		struct callback_head rcu;
	} ATTR_PRESERVE_ACCESS_INDEX;
} ATTR_PRESERVE_ACCESS_INDEX;

struct backing_dev_info {
	u64 id;
	struct rb_node rb_node;
	struct list_head bdi_list;
	long unsigned int ra_pages;
	long unsigned int io_pages;
	struct kref refcnt;
	unsigned int capabilities;
	unsigned int min_ratio;
	unsigned int max_ratio;
	unsigned int max_prop_frac;
	atomic_long_t tot_write_bandwidth;
	long unsigned int last_bdp_sleep;
	struct bdi_writeback wb;
	struct list_head wb_list;
	struct xarray cgwb_tree;
	struct mutex cgwb_release_mutex;
	struct rw_semaphore wb_switch_rwsem;
	wait_queue_head_t wb_waitq;
	struct device *dev;
	char dev_name[64];
	struct device *owner;
	struct timer_list laptop_mode_wb_timer;
	struct dentry *debug_dir;
} ATTR_PRESERVE_ACCESS_INDEX;

struct file_ra_state {
	long unsigned int start;
	unsigned int size