% DBSPLIT(1) 1.0
%
% September 2015

# NAME

DBsplit - divide a Dazzler database into a series of blocks

# SYNOPSIS

**DBsplit** [**-a**] [**-x***int*] [**-s***int(200)*] *path:db|dam*

# DESCRIPTION

Divide the database *path*.db or *path*.dam conceptually into a series of blocks
referable to on the command line as *path*.1, *path*.2, ...  If the **-x** option is set
then all reads less than the given length are ignored, and if the **-a** option is not
set then secondary reads from a given well are also ignored.  The remaining reads,
constituting what we call the trimmed DB, are split amongst the blocks so that each
block is of size **-s** `* 1Mbp` except for the last which necessarily contains a smaller
residual.  The default value for **-s** is 200Mbp because blocks of this size can be
compared by our "overlapper" **daligner**(1) in roughly 16Gb of memory.  The blocks are very
space efficient in that their sub-index of the master .idx is computed on the fly
when loaded, and the .bps and .qvs files (if a .db) of base pairs and quality values,
respectively, is shared with the master DB.  Any relevant portions of tracks
associated with the DB are also computed on the fly when loading a database block.

# SEE ALSO

**daligner**(1)
