# Параметры Cookie

Вы можете задать параметры Cookie таким же способом, как `Query` и `Path` параметры.

## Импорт `Cookie`

Сначала импортируйте `Cookie`:

=== "Python 3.10+"

    ```Python hl_lines="1"
    {!> ../../../docs_src/cookie_params/tutorial001_py310.py!}
    ```

=== "Python 3.6+"

    ```Python hl_lines="3"
    {!> ../../../docs_src/cookie_params/tutorial001.py!}
    ```

## Объявление параметров `Cookie`

Затем объявляйте параметры cookie, используя ту же структуру, что и с `Path` и `Query`.

Первое значение - это значение по умолчанию, вы можете передать все дополнительные параметры проверки или аннотации:

=== "Python 3.10+"

    ```Python hl_lines="7"
    {!> ../../../docs_src/cookie_params/tutorial001_py310.py!}
    ```

=== "Python 3.6+"

    ```Python hl_lines="9"
    {!> ../../../docs_src/cookie_params/tutorial001.py!}
    ```

!!! note "Технические детали"
    `Cookie` - это класс, родственный `Path` и `Query`. Он также наследуется от общего класса `Param`.

    Но помните, что когда вы импортируете `Query`, `Path`, `Cookie` и другое из `fastapi`, это фактически функции, которые возвращают специальные классы.

!!! info "Дополнительная информация"
    Для объявления cookies, вам нужно использовать `Cookie`, иначе параметры будут интерпретированы как параметры запроса.

## Резюме

Объявляйте cookies с помощью `Cookie`, используя тот же общий шаблон, что и `Query`, и `Path`.
