!** Copyright (c) 1989, NVIDIA CORPORATION.  All rights reserved.
!**
!** Licensed under the Apache License, Version 2.0 (the "License");
!** you may not use this file except in compliance with the License.
!** You may obtain a copy of the License at
!**
!**     http://www.apache.org/licenses/LICENSE-2.0
!**
!** Unless required by applicable law or agreed to in writing, software
!** distributed under the License is distributed on an "AS IS" BASIS,
!** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!** See the License for the specific language governing permissions and
!** limitations under the License.

!* Tests for runtime library MATMUL routines

program p

  parameter(NbrTests=1382)
  
  complex*8, dimension(3) :: arr1
  complex*8, dimension(3,4) :: arr2
  complex*8, dimension(4) :: arr3
  complex*8, dimension(4,4) :: arr4
  complex*8, dimension(0:3,-1:1) :: arr5
  complex*8, dimension(-3:-1) :: arr6
  complex*8, dimension(-1:2,0:3) :: arr7
  complex*8, dimension(2:4) :: arr8
  complex*8, dimension(2:4,2:5) :: arr9
  complex*8, dimension(2:5) :: arr10
  complex*8, dimension(1:4) :: arr11
  complex*8, dimension(11) :: arr12
  complex*8, dimension(11) :: arr13
  complex*8, dimension(11,11) :: arr14
  complex*8, dimension(2,11) :: arr15
  complex*8, dimension(389) :: arr16
  complex*8, dimension(389,387) :: arr17
  complex*8, dimension(387) :: arr18
  complex*8, dimension(2,387) :: arr19
  
  data arr1 /(0,2),(1,3),(2,1)/
  data arr2 /(0,1),(1,2),(2,3),(3,4), &
             (4,3),(5,4),(6,5),(7,6), &
             (8,8),(9,9),(10,10),(11,11)/
  data arr3 /(0,4),(1,3),(2,2),(3,1)/
  data arr4 /(0,1),(1,2),(2,3),(3,4), &
             (4,3),(5,2),(6,1),(7,0), &
             (8,0),(9,10),(10,11),(11,12), &
             (12,11),(13,10),(14,9),(15,8)/
  data arr5 /(0,-1),(1,-2),(2,-3),(3,-4), &
             (4,-3),(5,-2),(6,-1),(7,0), &
             (8,-7),(9,-8),(10,-9),(11,11)/
  data arr6 /(0,5),(1,4),(2,3)/
  data arr7 /(0,1),(1,2),(2,3),(3,4), &
             (4,-7),(5,-6),(6,-5),(7,-4), &
             (8,11),(9,10),(10,9),(11,10), &
             (12,-15),(13,-14),(14,-13),(15,-12)/
  data arr8 /(0,2),(1,3),(2,1)/
  data arr9 /(0,1),(1,2),(2,3),(3,4), &
             (4,3),(5,4),(6,5),(7,6), &
             (8,8),(9,9),(10,10),(11,11)/
  data arr10 /(0,4),(1,3),(2,2),(3,1)/

  
  complex*8 :: expect(NbrTests)
  complex*8 :: results(NbrTests)
  
  data expect / &
  !test 1,8
  (-6.0,13.0), (-7.0,34.0), (-13.0,63.0), (-27.0,91.0), &
  !test 9,16
  (0.0,0.0), (-7.0,34.0), (-13.0,63.0), (-27.0,91.0), &
  !test 17,24
  (-7.0,34.0), (-13.0,63.0), (-27.0,91.0), (0.0,0.0), &
  !test 25,32
  (0.0,0.0), (-6.0,13.0), (-7.0,34.0), (-13.0,63.0), &
  !test 33,40
  (0.0,0.0), (-13.0,21.0), (-21.0,39.0), (-38.0,58.0), &
  !test 41,48
  (-11.0,11.0), (-13.0,27.0), (-28.0,46.0), (-42.0,64.0), &
  !test 49,56
  (-3.0,6.0), (-4.0,23.0), (-1.0,42.0), (-8.0,66.0), &
  !test 57,64
  (0.0,0.0), (-3.0,6.0), (-4.0,23.0), (-1.0,42.0), &
  !test 65,72
  (-13.0,27.0), (-28.0,46.0), (-42.0,64.0), (0.0,0.0), &
  !test 73,80
  (-2.0,19.0), (-2.0,36.0), (-7.0,51.0), (0.0,0.0), &
  !test 81,88
  (0.0,0.0), (-3.0,6.0), (0.0,0.0), (-1.0,42.0), &
  !test 89,96
  (-13.0,27.0), (0.0,0.0), (-42.0,64.0), (0.0,0.0), &
  !test 97,128
  (0.0,0.0), (-13.0,27.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (-42.0,64.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 129,160
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (-13.0,27.0), (0.0,0.0), (-42.0,64.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 161,192
  (0.0,0.0), (17.0,53.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (7.0,100.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 193,224
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (27.0,39.0), (0.0,0.0), (30.0,83.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 225,232
  (-13.0,49.0), (-9.0,32.0), (-6.0,21.0), (0.0,0.0), &
  !test 233,240
  (0.0,0.0), (-6.0,7.0), (0.0,0.0), (-4.0,43.0), &
  !test 241,272
  (0.0,0.0), (-13.0,25.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (-42.0,62.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 273,304
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (-42.0,64.0), (0.0,0.0), (-13.0,27.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 305,336
  (0.0,0.0), (7.0,100.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (17.0,53.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 337,368
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (30.0,83.0), (0.0,0.0), (27.0,39.0), (0.0,0.0), &
  (0.0,0.0), (0.0,0.0), (0.0,0.0), (0.0,0.0), &
  !test 369,376
  (-6.0,13.0), (-7.0,34.0), (-13.0,63.0), (-27.0,91.0), &
  !test 377-401
  (36.0,0.0), (72.0,0.0), &
  (108.0,0.0), (144.0,0.0), &
  (180.0,0.0), (216.0,0.0), &
  (252.0,0.0), (288.0,0.0), &
  (324.0,0.0), (360.0,0.0), &
  (396.0,0.0), &
  !test 402,444
  (36.0,0.0), (0.0,0.0), &
  (72.0,0.0), (0.0,0.0), &
  (108.0,0.0), (0.0,0.0), &
  (144.0,0.0), (0.0,0.0), &
  (180.0,0.0), (0.0,0.0), &
  (216.0,0.0), (0.0,0.0), &
  (252.0,0.0), (0.0,0.0), &
  (288.0,0.0), (0.0,0.0), &
  (324.0,0.0), (0.0,0.0), &
  (360.0,0.0), (0.0,0.0), &
  (396.0,0.0), (0.0,0.0), &
  !test 446,719
  (38025.0,0.0), (76050.0,0.0), &
  (114075.0,0.0), (152100.0,0.0), &
  (190125.0,0.0), (228150.0,0.0), &
  (266175.0,0.0), (304200.0,0.0), &
  (342225.0,0.0), (380250.0,0.0), &
  (418275.0,0.0), (456300.0,0.0), &
  (494325.0,0.0), (532350.0,0.0), &
  (570375.0,0.0), (608400.0,0.0), &
  (646425.0,0.0), (684450.0,0.0), &
  (722475.0,0.0), (760500.0,0.0), &
  (798525.0,0.0), (836550.0,0.0), &
  (874575.0,0.0), (912600.0,0.0), &
  (950625.0,0.0), (988650.0,0.0), &
  (1026675.0,0.0), (1064700.0,0.0), &
  (1102725.0,0.0), (1140750.0,0.0), &
  (1178775.0,0.0), (1216800.0,0.0), &
  (1254825.0,0.0), (1292850.0,0.0), &
  (1330875.0,0.0), (1368900.0,0.0), &
  (1406925.0,0.0), (1444950.0,0.0), &
  (1482975.0,0.0), (1521000.0,0.0), &
  (1559025.0,0.0), (1597050.0,0.0), &
  (1635075.0,0.0), (1673100.0,0.0), &
  (1711125.0,0.0), (1749150.0,0.0), &
  (1787175.0,0.0), (1825200.0,0.0), &
  (1863225.0,0.0), (1901250.0,0.0), &
  (1939275.0,0.0), (1977300.0,0.0), &
  (2015325.0,0.0), (2053350.0,0.0), &
  (2091375.0,0.0), (2129400.0,0.0), &
  (2167425.0,0.0), (2205450.0,0.0), &
  (2243475.0,0.0), (2281500.0,0.0), &
  (2319525.0,0.0), (2357550.0,0.0), &
  (2395575.0,0.0), (2433600.0,0.0), &
  (2471625.0,0.0), (2509650.0,0.0), &
  (2547675.0,0.0), (2585700.0,0.0), &
  (2623725.0,0.0), (2661750.0,0.0), &
  (2699775.0,0.0), (2737800.0,0.0), &
  (2775825.0,0.0), (2813850.0,0.0), &
  (2851875.0,0.0), (2889900.0,0.0), &
  (2927925.0,0.0), (2965950.0,0.0), &
  (3003975.0,0.0), (3042000.0,0.0), &
  (3080025.0,0.0), (3118050.0,0.0), &
  (3156075.0,0.0), (3194100.0,0.0), &
  (3232125.0,0.0), (3270150.0,0.0), &
  (3308175.0,0.0), (3346200.0,0.0), &
  (3384225.0,0.0), (3422250.0,0.0), &
  (3460275.0,0.0), (3498300.0,0.0), &
  (3536325.0,0.0), (3574350.0,0.0), &
  (3612375.0,0.0), (3650400.0,0.0), &
  (3688425.0,0.0), (3726450.0,0.0), &
  (3764475.0,0.0), (3802500.0,0.0), &
  (3840525.0,0.0), (3878550.0,0.0), &
  (3916575.0,0.0), (3954600.0,0.0), &
  (3992625.0,0.0), (4030650.0,0.0), &
  (4068675.0,0.0), (4106700.0,0.0), &
  (4144725.0,0.0), (4182750.0,0.0), &
  (4220775.0,0.0), (4258800.0,0.0), &
  (4296825.0,0.0), (4334850.0,0.0), &
  (4372875.0,0.0), (4410900.0,0.0), &
  (4448925.0,0.0), (4486950.0,0.0), &
  (4524975.0,0.0), (4563000.0,0.0), &
  (4601025.0,0.0), (4639050.0,0.0), &
  (4677075.0,0.0), (4715100.0,0.0), &
  (4753125.0,0.0), (4791150.0,0.0), &
  (4829175.0,0.0), (4867200.0,0.0), &
  (4905225.0,0.0), (4943250.0,0.0), &
  (4981275.0,0.0), (5019300.0,0.0), &
  (5057325.0,0.0), (5095350.0,0.0), &
  (5133375.0,0.0), (5171400.0,0.0), &
  (5209425.0,0.0), (5247450.0,0.0), &
  (5285475.0,0.0), (5323500.0,0.0), &
  (5361525.0,0.0), (5399550.0,0.0), &
  (5437575.0,0.0), (5475600.0,0.0), &
  (5513625.0,0.0), (5551650.0,0.0), &
  (5589675.0,0.0), (5627700.0,0.0), &
  (5665725.0,0.0), (5703750.0,0.0), &
  (5741775.0,0.0), (5779800.0,0.0), &
  (5817825.0,0.0), (5855850.0,0.0), &
  (5893875.0,0.0), (5931900.0,0.0), &
  (5969925.0,0.0), (6007950.0,0.0), &
  (6045975.0,0.0), (6084000.0,0.0), &
  (6122025.0,0.0), (6160050.0,0.0), &
  (6198075.0,0.0), (6236100.0,0.0), &
  (6274125.0,0.0), (6312150.0,0.0), &
  (6350175.0,0.0), (6388200.0,0.0), &
  (6426225.0,0.0), (6464250.0,0.0), &
  (6502275.0,0.0), (6540300.0,0.0), &
  (6578325.0,0.0), (6616350.0,0.0), &
  (6654375.0,0.0), (6692400.0,0.0), &
  (6730425.0,0.0), (6768450.0,0.0), &
  (6806475.0,0.0), (6844500.0,0.0), &
  (6882525.0,0.0), (6920550.0,0.0), &
  (6958575.0,0.0), (6996600.0,0.0), &
  (7034625.0,0.0), (7072650.0,0.0), &
  (7110675.0,0.0), (7148700.0,0.0), &
  (7186725.0,0.0), (7224750.0,0.0), &
  (7262775.0,0.0), (7300800.0,0.0), &
  (7338825.0,0.0), (7376850.0,0.0), &
  (7414875.0,0.0), (7452900.0,0.0), &
  (7490925.0,0.0), (7528950.0,0.0), &
  (7566975.0,0.0), (7605000.0,0.0), &
  (7643025.0,0.0), (7681050.0,0.0), &
  (7719075.0,0.0), (7757100.0,0.0), &
  (7795125.0,0.0), (7833150.0,0.0), &
  (7871175.0,0.0), (7909200.0,0.0), &
  (7947225.0,0.0), (7985250.0,0.0), &
  (8023275.0,0.0), (8061300.0,0.0), &
  (8099325.0,0.0), (8137350.0,0.0), &
  (8175375.0,0.0), (8213400.0,0.0), &
  (8251425.0,0.0), (8289450.0,0.0), &
  (8327475.0,0.0), (8365500.0,0.0), &
  (8403525.0,0.0), (8441550.0,0.0), &
  (8479575.0,0.0), (8517600.0,0.0), &
  (8555625.0,0.0), (8593650.0,0.0), &
  (8631675.0,0.0), (8669700.0,0.0), &
  (8707725.0,0.0), (8745750.0,0.0), &
  (8783775.0,0.0), (8821800.0,0.0), &
  (8859825.0,0.0), (8897850.0,0.0), &
  (8935875.0,0.0), (8973900.0,0.0), &
  (9011925.0,0.0), (9049950.0,0.0), &
  (9087975.0,0.0), (9126000.0,0.0), &
  (9164025.0,0.0), (9202050.0,0.0), &
  (9240075.0,0.0), (9278100.0,0.0), &
  (9316125.0,0.0), (9354150.0,0.0), &
  (9392175.0,0.0), (9430200.0,0.0), &
  (9468225.0,0.0), (9506250.0,0.0), &
  (9544275.0,0.0), (9582300.0,0.0), &
  (9620325.0,0.0), (9658350.0,0.0), &
  (9696375.0,0.0), (9734400.0,0.0), &
  (9772425.0,0.0), (9810450.0,0.0), &
  (9848475.0,0.0), (9886500.0,0.0), &
  (9924525.0,0.0), (9962550.0,0.0), &
  (10000575.0,0.0), (10038600.0,0.0), &
  (10076625.0,0.0), (10114650.0,0.0), &
  (10152675.0,0.0), (10190700.0,0.0), &
  (10228725.0,0.0), (10266750.0,0.0), &
  (10304775.0,0.0), (10342800.0,0.0), &
  (10380825.0,0.0), (10418850.0,0.0), &
  (10456875.0,0.0), (10494900.0,0.0), &
  (10532925.0,0.0), (10570950.0,0.0), &
  (10608975.0,0.0), (10647000.0,0.0), &
  (10685025.0,0.0), (10723050.0,0.0), &
  (10761075.0,0.0), (10799100.0,0.0), &
  (10837125.0,0.0), (10875150.0,0.0), &
  (10913175.0,0.0), (10951200.0,0.0), &
  (10989225.0,0.0), (11027250.0,0.0), &
  (11065275.0,0.0), (11103300.0,0.0), &
  (11141325.0,0.0), (11179350.0,0.0), &
  (11217375.0,0.0), (11255400.0,0.0), &
  (11293425.0,0.0), (11331450.0,0.0), &
  (11369475.0,0.0), (11407500.0,0.0), &
  (11445525.0,0.0), (11483550.0,0.0), &
  (11521575.0,0.0), (11559600.0,0.0), &
  (11597625.0,0.0), (11635650.0,0.0), &
  (11673675.0,0.0), (11711700.0,0.0), &
  (11749725.0,0.0), (11787750.0,0.0), &
  (11825775.0,0.0), (11863800.0,0.0), &
  (11901825.0,0.0), (11939850.0,0.0), &
  (11977875.0,0.0), (12015900.0,0.0), &
  (12053925.0,0.0), (12091950.0,0.0), &
  (12129975.0,0.0), (12168000.0,0.0), &
  (12206025.0,0.0), (12244050.0,0.0), &
  (12282075.0,0.0), (12320100.0,0.0), &
  (12358125.0,0.0), (12396150.0,0.0), &
  (12434175.0,0.0), (12472200.0,0.0), &
  (12510225.0,0.0), (12548250.0,0.0), &
  (12586275.0,0.0), (12624300.0,0.0), &
  (12662325.0,0.0), (12700350.0,0.0), &
  (12738375.0,0.0), (12776400.0,0.0), &
  (12814425.0,0.0), (12852450.0,0.0), &
  (12890475.0,0.0), (12928500.0,0.0), &
  (12966525.0,0.0), (13004550.0,0.0), &
  (13042575.0,0.0), (13080600.0,0.0), &
  (13118625.0,0.0), (13156650.0,0.0), &
  (13194675.0,0.0), (13232700.0,0.0), &
  (13270725.0,0.0), (13308750.0,0.0), &
  (13346775.0,0.0), (13384800.0,0.0), &
  (13422825.0,0.0), (13460850.0,0.0), &
  (13498875.0,0.0), (13536900.0,0.0), &
  (13574925.0,0.0), (13612950.0,0.0), &
  (13650975.0,0.0), (13689000.0,0.0), &
  (13727025.0,0.0), (13765050.0,0.0), &
  (13803075.0,0.0), (13841100.0,0.0), &
  (13879125.0,0.0), (13917150.0,0.0), &
  (13955175.0,0.0), (13993200.0,0.0), &
  (14031225.0,0.0), (14069250.0,0.0), &
  (14107275.0,0.0), (14145300.0,0.0), &
  (14183325.0,0.0), (14221350.0,0.0), &
  (14259375.0,0.0), (14297400.0,0.0), &
  (14335425.0,0.0), (14373450.0,0.0), &
  (14411475.0,0.0), (14449500.0,0.0), &
  (14487525.0,0.0), (14525550.0,0.0), &
  (14563575.0,0.0), (14601600.0,0.0), &
  (14639625.0,0.0), (14677650.0,0.0), &
  (14715675.0,0.0), &
  !test 720,1267
  (38025.0,0.0), (0.0,0.0), &
  (76050.0,0.0), (0.0,0.0), &
  (114075.0,0.0), (0.0,0.0), &
  (152100.0,0.0), (0.0,0.0), &
  (190125.0,0.0), (0.0,0.0), &
  (228150.0,0.0), (0.0,0.0), &
  (266175.0,0.0), (0.0,0.0), &
  (304200.0,0.0), (0.0,0.0), &
  (342225.0,0.0), (0.0,0.0), &
  (380250.0,0.0), (0.0,0.0), &
  (418275.0,0.0), (0.0,0.0), &
  (456300.0,0.0), (0.0,0.0), &
  (494325.0,0.0), (0.0,0.0), &
  (532350.0,0.0), (0.0,0.0), &
  (570375.0,0.0), (0.0,0.0), &
  (608400.0,0.0), (0.0,0.0), &
  (646425.0,0.0), (0.0,0.0), &
  (684450.0,0.0), (0.0,0.0), &
  (722475.0,0.0), (0.0,0.0), &
  (760500.0,0.0), (0.0,0.0), &
  (798525.0,0.0), (0.0,0.0), &
  (836550.0,0.0), (0.0,0.0), &
  (874575.0,0.0), (0.0,0.0), &
  (912600.0,0.0), (0.0,0.0), &
  (950625.0,0.0), (0.0,0.0), &
  (988650.0,0.0), (0.0,0.0), &
  (1026675.0,0.0), (0.0,0.0), &
  (1064700.0,0.0), (0.0,0.0), &
  (1102725.0,0.0), (0.0,0.0), &
  (1140750.0,0.0), (0.0,0.0), &
  (1178775.0,0.0), (0.0,0.0), &
  (1216800.0,0.0), (0.0,0.0), &
  (1254825.0,0.0), (0.0,0.0), &
  (1292850.0,0.0), (0.0,0.0), &
  (1330875.0,0.0), (0.0,0.0), &
  (1368900.0,0.0), (0.0,0.0), &
  (1406925.0,0.0), (0.0,0.0), &
  (1444950.0,0.0), (0.0,0.0), &
  (1482975.0,0.0), (0.0,0.0), &
  (1521000.0,0.0), (0.0,0.0), &
  (1559025.0,0.0), (0.0,0.0), &
  (1597050.0,0.0), (0.0,0.0), &
  (1635075.0,0.0), (0.0,0.0), &
  (1673100.0,0.0), (0.0,0.0), &
  (1711125.0,0.0), (0.0,0.0), &
  (1749150.0,0.0), (0.0,0.0), &
  (1787175.0,0.0), (0.0,0.0), &
  (1825200.0,0.0), (0.0,0.0), &
  (1863225.0,0.0), (0.0,0.0), &
  (1901250.0,0.0), (0.0,0.0), &
  (1939275.0,0.0), (0.0,0.0), &
  (1977300.0,0.0), (0.0,0.0), &
  (2015325.0,0.0), (0.0,0.0), &
  (2053350.0,0.0), (0.0,0.0), &
  (2091375.0,0.0), (0.0,0.0), &
  (2129400.0,0.0), (0.0,0.0), &
  (2167425.0,0.0), (0.0,0.0), &
  (2205450.0,0.0), (0.0,0.0), &
  (2243475.0,0.0), (0.0,0.0), &
  (2281500.0,0.0), (0.0,0.0), &
  (2319525.0,0.0), (0.0,0.0), &
  (2357550.0,0.0), (0.0,0.0), &
  (2395575.0,0.0), (0.0,0.0), &
  (2433600.0,0.0), (0.0,0.0), &
  (2471625.0,0.0), (0.0,0.0), &
  (2509650.0,0.0), (0.0,0.0), &
  (2547675.0,0.0), (0.0,0.0), &
  (2585700.0,0.0), (0.0,0.0), &
  (2623725.0,0.0), (0.0,0.0), &
  (2661750.0,0.0), (0.0,0.0), &
  (2699775.0,0.0), (0.0,0.0), &
  (2737800.0,0.0), (0.0,0.0), &
  (2775825.0,0.0), (0.0,0.0), &
  (2813850.0,0.0), (0.0,0.0), &
  (2851875.0,0.0), (0.0,0.0), &
  (2889900.0,0.0), (0.0,0.0), &
  (2927925.0,0.0), (0.0,0.0), &
  (2965950.0,0.0), (0.0,0.0), &
  (3003975.0,0.0), (0.0,0.0), &
  (3042000.0,0.0), (0.0,0.0), &
  (3080025.0,0.0), (0.0,0.0), &
  (3118050.0,0.0), (0.0,0.0), &
  (3156075.0,0.0), (0.0,0.0), &
  (3194100.0,0.0), (0.0,0.0), &
  (3232125.0,0.0), (0.0,0.0), &
  (3270150.0,0.0), (0.0,0.0), &
  (3308175.0,0.0), (0.0,0.0), &
  (3346200.0,0.0), (0.0,0.0), &
  (3384225.0,0.0), (0.0,0.0), &
  (3422250.0,0.0), (0.0,0.0), &
  (3460275.0,0.0), (0.0,0.0), &
  (3498300.0,0.0), (0.0,0.0), &
  (3536325.0,0.0), (0.0,0.0), &
  (3574350.0,0.0), (0.0,0.0), &
  (3612375.0,0.0), (0.0,0.0), &
  (3650400.0,0.0), (0.0,0.0), &
  (3688425.0,0.0), (0.0,0.0), &
  (3726450.0,0.0), (0.0,0.0), &
  (3764475.0,0.0), (0.0,0.0), &
  (3802500.0,0.0), (0.0,0.0), &
  (3840525.0,0.0), (0.0,0.0), &
  (3878550.0,0.0), (0.0,0.0), &
  (3916575.0,0.0), (0.0,0.0), &
  (3954600.0,0.0), (0.0,0.0), &
  (3992625.0,0.0), (0.0,0.0), &
  (4030650.0,0.0), (0.0,0.0), &
  (4068675.0,0.0), (0.0,0.0), &
  (4106700.0,0.0), (0.0,0.0), &
  (4144725.0,0.0), (0.0,0.0), &
  (4182750.0,0.0), (0.0,0.0), &
  (4220775.0,0.0), (0.0,0.0), &
  (4258800.0,0.0), (0.0,0.0), &
  (4296825.0,0.0), (0.0,0.0), &
  (4334850.0,0.0), (0.0,0.0), &
  (4372875.0,0.0), (0.0,0.0), &
  (4410900.0,0.0), (0.0,0.0), &
  (4448925.0,0.0), (0.0,0.0), &
  (4486950.0,0.0), (0.0,0.0), &
  (4524975.0,0.0), (0.0,0.0), &
  (4563000.0,0.0), (0.0,0.0), &
  (4601025.0,0.0), (0.0,0.0), &
  (4639050.0,0.0), (0.0,0.0), &
  (4677075.0,0.0), (0.0,0.0), &
  (4715100.0,0.0), (0.0,0.0), &
  (4753125.0,0.0), (0.0,0.0), &
  (4791150.0,0.0), (0.0,0.0), &
  (4829175.0,0.0), (0.0,0.0), &
  (4867200.0,0.0), (0.0,0.0), &
  (4905225.0,0.0), (0.0,0.0), &
  (4943250.0,0.0), (0.0,0.0), &
  (4981275.0,0.0), (0.0,0.0), &
  (5019300.0,0.0), (0.0,0.0), &
  (5057325.0,0.0), (0.0,0.0), &
  (5095350.0,0.0), (0.0,0.0), &
  (5133375.0,0.0), (0.0,0.0), &
  (5171400.0,0.0), (0.0,0.0), &
  (5209425.0,0.0), (0.0,0.0), &
  (5247450.0,0.0), (0.0,0.0), &
  (5285475.0,0.0), (0.0,0.0), &
  (5323500.0,0.0), (0.0,0.0), &
  (5361525.0,0.0), (0.0,0.0), &
  (5399550.0,0.0), (0.0,0.0), &
  (5437575.0,0.0), (0.0,0.0), &
  (5475600.0,0.0), (0.0,0.0), &
  (5513625.0,0.0), (0.0,0.0), &
  (5551650.0,0.0), (0.0,0.0), &
  (5589675.0,0.0), (0.0,0.0), &
  (5627700.0,0.0), (0.0,0.0), &
  (5665725.0,0.0), (0.0,0.0), &
  (5703750.0,0.0), (0.0,0.0), &
  (5741775.0,0.0), (0.0,0.0), &
  (5779800.0,0.0), (0.0,0.0), &
  (5817825.0,0.0), (0.0,0.0), &
  (5855850.0,0.0), (0.0,0.0), &
  (5893875.0,0.0), (0.0,0.0), &
  (5931900.0,0.0), (0.0,0.0), &
  (5969925.0,0.0), (0.0,0.0), &
  (6007950.0,0.0), (0.0,0.0), &
  (6045975.0,0.0), (0.0,0.0), &
  (6084000.0,0.0), (0.0,0.0), &
  (6122025.0,0.0), (0.0,0.0), &
  (6160050.0,0.0), (0.0,0.0), &
  (6198075.0,0.0), (0.0,0.0), &
  (6236100.0,0.0), (0.0,0.0), &
  (6274125.0,0.0), (0.0,0.0), &
  (6312150.0,0.0), (0.0,0.0), &
  (6350175.0,0.0), (0.0,0.0), &
  (6388200.0,0.0), (0.0,0.0), &
  (6426225.0,0.0), (0.0,0.0), &
  (6464250.0,0.0), (0.0,0.0), &
  (6502275.0,0.0), (0.0,0.0), &
  (6540300.0,0.0), (0.0,0.0), &
  (6578325.0,0.0), (0.0,0.0), &
  (6616350.0,0.0), (0.0,0.0), &
  (6654375.0,0.0), (0.0,0.0), &
  (6692400.0,0.0), (0.0,0.0), &
  (6730425.0,0.0), (0.0,0.0), &
  (6768450.0,0.0), (0.0,0.0), &
  (6806475.0,0.0), (0.0,0.0), &
  (6844500.0,0.0), (0.0,0.0), &
  (6882525.0,0.0), (0.0,0.0), &
  (6920550.0,0.0), (0.0,0.0), &
  (6958575.0,0.0), (0.0,0.0), &
  (6996600.0,0.0), (0.0,0.0), &
  (7034625.0,0.0), (0.0,0.0), &
  (7072650.0,0.0), (0.0,0.0), &
  (7110675.0,0.0), (0.0,0.0), &
  (7148700.0,0.0), (0.0,0.0), &
  (7186725.0,0.0), (0.0,0.0), &
  (7224750.0,0.0), (0.0,0.0), &
  (7262775.0,0.0), (0.0,0.0), &
  (7300800.0,0.0), (0.0,0.0), &
  (7338825.0,0.0), (0.0,0.0), &
  (7376850.0,0.0), (0.0,0.0), &
  (7414875.0,0.0), (0.0,0.0), &
  (7452900.0,0.0), (0.0,0.0), &
  (7490925.0,0.0), (0.0,0.0), &
  (7528950.0,0.0), (0.0,0.0), &
  (7566975.0,0.0), (0.0,0.0), &
  (7605000.0,0.0), (0.0,0.0), &
  (7643025.0,0.0), (0.0,0.0), &
  (7681050.0,0.0), (0.0,0.0), &
  (7719075.0,0.0), (0.0,0.0), &
  (7757100.0,0.0), (0.0,0.0), &
  (7795125.0,0.0), (0.0,0.0), &
  (7833150.0,0.0), (0.0,0.0), &
  (7871175.0,0.0), (0.0,0.0), &
  (7909200.0,0.0), (0.0,0.0), &
  (7947225.0,0.0), (0.0,0.0), &
  (7985250.0,0.0), (0.0,0.0), &
  (8023275.0,0.0), (0.0,0.0), &
  (8061300.0,0.0), (0.0,0.0), &
  (8099325.0,0.0), (0.0,0.0), &
  (8137350.0,0.0), (0.0,0.0), &
  (8175375.0,0.0), (0.0,0.0), &
  (8213400.0,0.0), (0.0,0.0), &
  (8251425.0,0.0), (0.0,0.0), &
  (8289450.0,0.0), (0.0,0.0), &
  (8327475.0,0.0), (0.0,0.0), &
  (8365500.0,0.0), (0.0,0.0), &
  (8403525.0,0.0), (0.0,0.0), &
  (8441550.0,0.0), (0.0,0.0), &
  (8479575.0,0.0), (0.0,0.0), &
  (8517600.0,0.0), (0.0,0.0), &
  (8555625.0,0.0), (0.0,0.0), &
  (8593650.0,0.0), (0.0,0.0), &
  (8631675.0,0.0), (0.0,0.0), &
  (8669700.0,0.0), (0.0,0.0), &
  (8707725.0,0.0), (0.0,0.0), &
  (8745750.0,0.0), (0.0,0.0), &
  (8783775.0,0.0), (0.0,0.0), &
  (8821800.0,0.0), (0.0,0.0), &
  (8859825.0,0.0), (0.0,0.0), &
  (8897850.0,0.0), (0.0,0.0), &
  (8935875.0,0.0), (0.0,0.0), &
  (8973900.0,0.0), (0.0,0.0), &
  (9011925.0,0.0), (0.0,0.0), &
  (9049950.0,0.0), (0.0,0.0), &
  (9087975.0,0.0), (0.0,0.0), &
  (9126000.0,0.0), (0.0,0.0), &
  (9164025.0,0.0), (0.0,0.0), &
  (9202050.0,0.0), (0.0,0.0), &
  (9240075.0,0.0), (0.0,0.0), &
  (9278100.0,0.0), (0.0,0.0), &
  (9316125.0,0.0), (0.0,0.0), &
  (9354150.0,0.0), (0.0,0.0), &
  (9392175.0,0.0), (0.0,0.0), &
  (9430200.0,0.0), (0.0,0.0), &
  (9468225.0,0.0), (0.0,0.0), &
  (9506250.0,0.0), (0.0,0.0), &
  (9544275.0,0.0), (0.0,0.0), &
  (9582300.0,0.0), (0.0,0.0), &
  (9620325.0,0.0), (0.0,0.0), &
  (9658350.0,0.0), (0.0,0.0), &
  (9696375.0,0.0), (0.0,0.0), &
  (9734400.0,0.0), (0.0,0.0), &
  (9772425.0,0.0), (0.0,0.0), &
  (9810450.0,0.0), (0.0,0.0), &
  (9848475.0,0.0), (0.0,0.0), &
  (9886500.0,0.0), (0.0,0.0), &
  (9924525.0,0.0), (0.0,0.0), &
  (9962550.0,0.0), (0.0,0.0), &
  (10000575.0,0.0), (0.0,0.0), &
  (10038600.0,0.0), (0.0,0.0), &
  (10076625.0,0.0), (0.0,0.0), &
  (10114650.0,0.0), (0.0,0.0), &
  (10152675.0,0.0), (0.0,0.0), &
  (10190700.0,0.0), (0.0,0.0), &
  (10228725.0,0.0), (0.0,0.0), &
  (10266750.0,0.0), (0.0,0.0), &
  (10304775.0,0.0), (0.0,0.0), &
  (10342800.0,0.0), (0.0,0.0), &
  (10380825.0,0.0), (0.0,0.0), &
  (10418850.0,0.0), (0.0,0.0), &
  (10456875.0,0.0), (0.0,0.0), &
  (10494900.0,0.0), (0.0,0.0), &
  (10532925.0,0.0), (0.0,0.0), &
  (10570950.0,0.0), (0.0,0.0), &
  (10608975.0,0.0), (0.0,0.0), &
  (10647000.0,0.0), (0.0,0.0), &
  (10685025.0,0.0), (0.0,0.0), &
  (10723050.0,0.0), (0.0,0.0), &
  (10761075.0,0.0), (0.0,0.0), &
  (10799100.0,0.0), (0.0,0.0), &
  (10837125.0,0.0), (0.0,0.0), &
  (10875150.0,0.0), (0.0,0.0), &
  (10913175.0,0.0), (0.0,0.0), &
  (10951200.0,0.0), (0.0,0.0), &
  (10989225.0,0.0), (0.0,0.0), &
  (11027250.0,0.0), (0.0,0.0), &
  (11065275.0,0.0), (0.0,0.0), &
  (11103300.0,0.0), (0.0,0.0), &
  (11141325.0,0.0), (0.0,0.0), &
  (11179350.0,0.0), (0.0,0.0), &
  (11217375.0,0.0), (0.0,0.0), &
  (11255400.0,0.0), (0.0,0.0), &
  (11293425.0,0.0), (0.0,0.0), &
  (11331450.0,0.0), (0.0,0.0), &
  (11369475.0,0.0), (0.0,0.0), &
  (11407500.0,0.0), (0.0,0.0), &
  (11445525.0,0.0), (0.0,0.0), &
  (11483550.0,0.0), (0.0,0.0), &
  (11521575.0,0.0), (0.0,0.0), &
  (11559600.0,0.0), (0.0,0.0), &
  (11597625.0,0.0), (0.0,0.0), &
  (11635650.0,0.0), (0.0,0.0), &
  (11673675.0,0.0), (0.0,0.0), &
  (11711700.0,0.0), (0.0,0.0), &
  (11749725.0,0.0), (0.0,0.0), &
  (11787750.0,0.0), (0.0,0.0), &
  (11825775.0,0.0), (0.0,0.0), &
  (11863800.0,0.0), (0.0,0.0), &
  (11901825.0,0.0), (0.0,0.0), &
  (11939850.0,0.0), (0.0,0.0), &
  (11977875.0,0.0), (0.0,0.0), &
  (12015900.0,0.0), (0.0,0.0), &
  (12053925.0,0.0), (0.0,0.0), &
  (12091950.0,0.0), (0.0,0.0), &
  (12129975.0,0.0), (0.0,0.0), &
  (12168000.0,0.0), (0.0,0.0), &
  (12206025.0,0.0), (0.0,0.0), &
  (12244050.0,0.0), (0.0,0.0), &
  (12282075.0,0.0), (0.0,0.0), &
  (12320100.0,0.0), (0.0,0.0), &
  (12358125.0,0.0), (0.0,0.0), &
  (12396150.0,0.0), (0.0,0.0), &
  (12434175.0,0.0), (0.0,0.0), &
  (12472200.0,0.0), (0.0,0.0), &
  (12510225.0,0.0), (0.0,0.0), &
  (12548250.0,0.0), (0.0,0.0), &
  (12586275.0,0.0), (0.0,0.0), &
  (12624300.0,0.0), (0.0,0.0), &
  (12662325.0,0.0), (0.0,0.0), &
  (12700350.0,0.0), (0.0,0.0), &
  (12738375.0,0.0), (0.0,0.0), &
  (12776400.0,0.0), (0.0,0.0), &
  (12814425.0,0.0), (0.0,0.0), &
  (12852450.0,0.0), (0.0,0.0), &
  (12890475.0,0.0), (0.0,0.0), &
  (12928500.0,0.0), (0.0,0.0), &
  (12966525.0,0.0), (0.0,0.0), &
  (13004550.0,0.0), (0.0,0.0), &
  (13042575.0,0.0), (0.0,0.0), &
  (13080600.0,0.0), (0.0,0.0), &
  (13118625.0,0.0), (0.0,0.0), &
  (13156650.0,0.0), (0.0,0.0), &
  (13194675.0,0.0), (0.0,0.0), &
  (13232700.0,0.0), (0.0,0.0), &
  (13270725.0,0.0), (0.0,0.0), &
  (13308750.0,0.0), (0.0,0.0), &
  (13346775.0,0.0), (0.0,0.0), &
  (13384800.0,0.0), (0.0,0.0), &
  (13422825.0,0.0), (0.0,0.0), &
  (13460850.0,0.0), (0.0,0.0), &
  (13498875.0,0.0), (0.0,0.0), &
  (13536900.0,0.0), (0.0,0.0), &
  (13574925.0,0.0), (0.0,0.0), &
  (13612950.0,0.0), (0.0,0.0), &
  (13650975.0,0.0), (0.0,0.0), &
  (13689000.0,0.0), (0.0,0.0), &
  (13727025.0,0.0), (0.0,0.0), &
  (13765050.0,0.0), (0.0,0.0), &
  (13803075.0,0.0), (0.0,0.0), &
  (13841100.0,0.0), (0.0,0.0), &
  (13879125.0,0.0), (0.0,0.0), &
  (13917150.0,0.0), (0.0,0.0), &
  (13955175.0,0.0), (0.0,0.0), &
  (13993200.0,0.0), (0.0,0.0), &
  (14031225.0,0.0), (0.0,0.0), &
  (14069250.0,0.0), (0.0,0.0), &
  (14107275.0,0.0), (0.0,0.0), &
  (14145300.0,0.0), (0.0,0.0), &
  (14183325.0,0.0), (0.0,0.0), &
  (14221350.0,0.0), (0.0,0.0), &
  (14259375.0,0.0), (0.0,0.0), &
  (14297400.0,0.0), (0.0,0.0), &
  (14335425.0,0.0), (0.0,0.0), &
  (14373450.0,0.0), (0.0,0.0), &
  (14411475.0,0.0), (0.0,0.0), &
  (14449500.0,0.0), (0.0,0.0), &
  (14487525.0,0.0), (0.0,0.0), &
  (14525550.0,0.0), (0.0,0.0), &
  (14563575.0,0.0), (0.0,0.0), &
  (14601600.0,0.0), (0.0,0.0), &
  (14639625.0,0.0), (0.0,0.0), &
  (14677650.0,0.0), (0.0,0.0), &
  (14715675.0,0.0), (0.0,0.0) /
  
  ! tests 1-8
  arr3=0
  arr3 = matmul(arr1,arr2)
  call assign_result(1,4,arr3,results)
  !print *,"test 1,8"
  !print *,arr3
  
  ! tests 9-16
  arr3=0
  arr3(2:4) = matmul(arr1,arr2(:, 2:4))
  call assign_result(5,8,arr3,results)
  !print *,"test 9,16"
  !print *,arr3
  
  ! tests 17-24
  arr3=0
  arr3(1:3) = matmul(arr1,arr2(:,2:4))
  call assign_result(9,12,arr3,results)
  !print *,"test 17,24"
  !print *,arr3
  
  !tests 25-32
  arr3=0
  arr3(2:4) = matmul(arr1,arr2(:, 1:3))
  call assign_result(13,16,arr3,results)
  !print *,"test 25,32"
  !print *,arr3
  
  !tests 33-40
  arr3=0
  arr3(2:4) = matmul(arr1(1:2),arr2(1:2,2:4))
  call assign_result(17,20,arr3,results)
  !print *,"test 33,40"
  !print *,arr3
  
  !tests 41-48
  arr3=0
  arr3 = matmul(arr1(1:2),arr2(2:3,:))
  call assign_result(21,24,arr3,results)
  !print *,"test 41,48"
  !print *,arr3
  
  !tests 49-56
  arr3=0
  arr3 = matmul(arr1(2:3),arr2(1:2,:))
  call assign_result(25,28,arr3,results)
  !print *,"test 49,56"
  !print *,arr3
  
  !tests 57-64
  arr3=0
  arr3(2:4)  = matmul(arr1(2:3),arr2(1:2,1:3))
  call assign_result(29,32,arr3,results)
  !print *,"test 57,64"
  !print *,arr3
  
  !tests 65-72
  arr3=0
  arr3(1:3)  = matmul(arr1(1:2),arr2(2:3,2:4))
  call assign_result(33,36,arr3,results)
  !print *,"test 65,72"
  !print *,arr3
  
  !tests 73-80
  arr3=0
  arr3(1:3) = matmul(arr1(1:3:2),arr2(1:3:2,2:4))
  call assign_result(37,40,arr3,results)
  !print *,"test 73,80"
  !print *,arr3
  
  !tests 81-88
  arr3=0
  arr3(2:4:2)  = matmul(arr1(2:3),arr2(1:2,1:3:2))
  call assign_result(41,44,arr3,results)
  !print *,"test 81,88"
  !print *,arr3
  
  !tests 89-96
  arr3=0
  arr3(1:3:2)  = matmul(arr1(1:2),arr2(2:3,2:4:2))
  call assign_result(45,48,arr3,results)
  !print *,"test 89,96"
  !print *,arr3
  
  !tests 97-124
  arr4=0
  arr4(2,1:3:2)  = matmul(arr1(1:2),arr2(2:3,2:4:2))
  call assign_result(49,64,arr4,results)
  !print *,"test 97,124"
  !print *,arr4
  
  !tests 125-160
  arr4=0
  arr4(1:3:2,3)  = matmul(arr1(1:2),arr2(2:3,2:4:2))
  call assign_result(65,80,arr4,results)
  !print *,"test 125,160"
  !print *,arr4
  
  !tests 161-192
  arr7=0
  arr7(0,0:2:2)  = matmul(arr6(-3:-2),arr5(1:3:2,0:1))
  call assign_result(81,96,arr7,results)
  !print *,"test  1,192"
  !print *,arr7
  
  !tests 193-224
  arr7=0
  arr7(-1:1:2,2)  = matmul(arr6(-2:-1),arr5(1:3:2,0:1))
  call assign_result(97,112,arr7,results)
  !print *,"test 193,224"
  !print *,arr7
  
  !tests 225-232
  arr3=0
  arr3(3:1:-1) = matmul(arr1(3:1:-2),arr2(1:3:2,2:4))
  call assign_result(113,116,arr3,results)
  !print *,"test 225,232"
  !print *,arr3
  
  !tests 233-240
  arr3=0
  arr3(4:2:-2)  = matmul(arr1(3:2:-1),arr2(1:2,3:1:-2))
  call assign_result(117,120,arr3,results)
  !print *,"test 233,240"
  !print *,arr3
  
  !tests 241-272
  arr4=0
  arr4(2,3:1:-2)  = matmul(arr1(1:2),arr2(3:2:-1,4:2:-2))
  call assign_result(121,136,arr4,results)
  !print *,"test 241,272"
  !print *,arr4
  
  !tests 273-304
  arr4=0
  arr4(3:1:-2,3)  = matmul(arr1(2:1:-1),arr2(3:2:-1,2:4:2))
  call assign_result(137,152,arr4,results)
  !print *,"test 273,304"
  !print *,arr4
  
  !tests 305-336
  arr7=0
  arr7(0,2:0:-2)  = matmul(arr6(-3:-2),arr5(1:3:2,0:1))
  call assign_result(153,168,arr7,results)
  !print *,"test 305,336"
  !print *,arr7
  
  !tests 337-368
  arr7=0
  arr7(1:-1:-2,2)  = matmul(arr6(-1:-2:-1),arr5(3:1:-2,0:1))
  call assign_result(169,184,arr7,results)
  !print *,"test 337,336"
  !print *,arr7
  
  arr11 = 0

  ! tests 369-376
  arr10=0
  arr10 = arr11 + matmul(arr8,arr9)
  call assign_result(185,188,arr10,results)
  ! print *,"test 369,376"
  ! print *,arr10

  ! tests 369-376
  arr10=0
  arr10 = arr11 + matmul(arr8,arr9)
  call assign_result(185,188,arr10,results)
  !print *,"test 369,376"
  !print *,arr10

   do i = 1,11
     m2 = mod(i,2)
     if (m2 .eq. 0 ) then
         arr13(i) = cmplx(0,0)
     else
         arr13(i) = cmplx(i,0)
     endif
     do j = 1,11
         arr14(i,j) = cmplx(j,0);
     enddo
  enddo

  ! tests 377-398
  arr12=0
  arr12 = matmul(arr13,arr14)
  call assign_result(189,199,arr12,results)
  !print *,"test 377-401"
  !print *,arr12

  ! tests 402-444
  arr15=0
  arr15(1,:) = matmul(arr13,arr14)
  call assign_result(200,221,arr15,results)
  !print *,"test 402,444"
  !print *,arr15

   do i = 1,389
     m2 = mod(i,2)
     if (m2 .eq. 0 ) then
         arr16(i) = cmplx(0,0)
     else
         arr16(i) = cmplx(i,0)
     endif
     do j = 1,387
         arr17(i,j) = cmplx(j,0);
     enddo
  enddo

  ! tests 445-1216
  arr18=0
  arr18 = matmul(arr16,arr17)
  call assign_result(222,608,arr18,results)
  !print *,"test 446,719"
  !print *,arr18

  ! tests 1217-2764
  arr19=0
  arr19(1,:) = matmul(arr16,arr17)
  call assign_result(609,1382,arr19,results)
  !print *,"test 720,1267"
  !print *,arr19

  call check(results, expect, NbrTests*2)

end program

subroutine assign_result(s_idx, e_idx , arr, rslt)
  complex*8, dimension(1:e_idx-s_idx+1) :: arr
  complex*8, dimension(e_idx) :: rslt
  integer:: s_idx, e_idx

  rslt(s_idx:e_idx) = arr

end subroutine

