/***************************************************************************
                          splitter.h  -  description
                             -------------------
    copyright            : (C) 2003 by Csaba Karai
    e-mail               : krusader@users.sourceforge.net
    web site             : http://krusader.sourceforge.net
 ---------------------------------------------------------------------------
  Description
 ***************************************************************************

  A

     db   dD d8888b. db    db .d8888.  .d8b.  d8888b. d88888b d8888b.
     88 ,8P' 88  `8D 88    88 88'  YP d8' `8b 88  `8D 88'     88  `8D
     88,8P   88oobY' 88    88 `8bo.   88ooo88 88   88 88ooooo 88oobY'
     88`8b   88`8b   88    88   `Y8b. 88~~~88 88   88 88~~~~~ 88`8b
     88 `88. 88 `88. 88b  d88 db   8D 88   88 88  .8D 88.     88 `88.
     YP   YD 88   YD ~Y8888P' `8888Y' YP   YP Y8888D' Y88888P 88   YD

                                                     H e a d e r    F i l e

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPLITTER_H
#define SPLITTER_H

// QtCore
#include <QString>
#include <QUrl>
// QtWidgets
#include <QProgressDialog>

#include <KIO/Job>

#include "crc32.h"

class Splitter : public QProgressDialog
{
    Q_OBJECT

public:
    Splitter(QWidget* parent,  QUrl fileNameIn, QUrl destinationDirIn, bool overWriteIn);
    ~Splitter();

    void split(KIO::filesize_t splitSizeIn);

private slots:
    void splitDataReceived(KIO::Job *, const QByteArray &);
    void splitDataSend(KIO::Job *, QByteArray &);
    void splitSendFinished(KJob *);
    void splitReceiveFinished(KJob *);
    void splitReceivePercent(KJob *, unsigned long);
    void splitFileSend(KIO::Job *, QByteArray &);
    void splitFileFinished(KJob *);
    void statOutputFileResult(KJob* job);

private:
    void splitAbortJobs();
    void nextOutputFile();
    void openOutputFile();


    // parameters
    QUrl            fileName;
    QUrl            destinationDir;
    KIO::filesize_t splitSize;
    int             permissions;
    bool            overwrite;

    // current split file stuff
    int             fileNumber;
    QUrl            writeURL;
    // how much can still be written to the current output file
    KIO::filesize_t outputFileRemaining;

    QByteArray      transferArray;
    KIO::filesize_t receivedSize;
    QString         splitInfoFileContent;
    CRC32          *crcContext;
    KIO::Job         *statJob;
    KIO::TransferJob *splitReadJob;
    KIO::TransferJob *splitWriteJob;
};

#endif /* __SPLITTER_H__ */
