; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test high-part vector multiply-and-add.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

; Test a v16i8 unsigned high-part multiply-and-add.
define <16 x i8> @f1(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %zext1 = zext <16 x i8> %val1 to <16 x i16>
  %zext2 = zext <16 x i8> %val2 to <16 x i16>
  %zext3 = zext <16 x i8> %val3 to <16 x i16>
  %mulx = mul <16 x i16> %zext1, %zext2
  %addx = add <16 x i16> %mulx, %zext3
  %highx = lshr <16 x i16> %addx, splat(i16 8)
  %high = trunc <16 x i16> %highx to <16 x i8>
  ret <16 x i8> %high
}

; Test a v16i8 signed high-part multiply-and-add.
define <16 x i8> @f2(<16 x i8> %val1, <16 x i8> %val2, <16 x i8> %val3) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %sext1 = sext <16 x i8> %val1 to <16 x i16>
  %sext2 = sext <16 x i8> %val2 to <16 x i16>
  %sext3 = sext <16 x i8> %val3 to <16 x i16>
  %mulx = mul <16 x i16> %sext1, %sext2
  %addx = add <16 x i16> %mulx, %sext3
  %highx = lshr <16 x i16> %addx, splat(i16 8)
  %high = trunc <16 x i16> %highx to <16 x i8>
  ret <16 x i8> %high
}

; Test a v8i16 unsigned high-part multiply-and-add.
define <8 x i16> @f3(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %zext1 = zext <8 x i16> %val1 to <8 x i32>
  %zext2 = zext <8 x i16> %val2 to <8 x i32>
  %zext3 = zext <8 x i16> %val3 to <8 x i32>
  %mulx = mul <8 x i32> %zext1, %zext2
  %addx = add <8 x i32> %mulx, %zext3
  %highx = lshr <8 x i32> %addx, splat(i32 16)
  %high = trunc <8 x i32> %highx to <8 x i16>
  ret <8 x i16> %high
}

; Test a v8i16 signed high-part multiply-and-add.
define <8 x i16> @f4(<8 x i16> %val1, <8 x i16> %val2, <8 x i16> %val3) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %sext1 = sext <8 x i16> %val1 to <8 x i32>
  %sext2 = sext <8 x i16> %val2 to <8 x i32>
  %sext3 = sext <8 x i16> %val3 to <8 x i32>
  %mulx = mul <8 x i32> %sext1, %sext2
  %addx = add <8 x i32> %mulx, %sext3
  %highx = lshr <8 x i32> %addx, splat(i32 16)
  %high = trunc <8 x i32> %highx to <8 x i16>
  ret <8 x i16> %high
}

; Test a v4i32 unsigned high-part multiply-and-add.
define <4 x i32> @f5(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhf %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %zext1 = zext <4 x i32> %val1 to <4 x i64>
  %zext2 = zext <4 x i32> %val2 to <4 x i64>
  %zext3 = zext <4 x i32> %val3 to <4 x i64>
  %mulx = mul <4 x i64> %zext1, %zext2
  %addx = add <4 x i64> %mulx, %zext3
  %highx = lshr <4 x i64> %addx, splat(i64 32)
  %high = trunc <4 x i64> %highx to <4 x i32>
  ret <4 x i32> %high
}

; Test a v4i32 signed high-part multiply-and-add.
define <4 x i32> @f6(<4 x i32> %val1, <4 x i32> %val2, <4 x i32> %val3) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahf %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %sext1 = sext <4 x i32> %val1 to <4 x i64>
  %sext2 = sext <4 x i32> %val2 to <4 x i64>
  %sext3 = sext <4 x i32> %val3 to <4 x i64>
  %mulx = mul <4 x i64> %sext1, %sext2
  %addx = add <4 x i64> %mulx, %sext3
  %highx = lshr <4 x i64> %addx, splat(i64 32)
  %high = trunc <4 x i64> %highx to <4 x i32>
  ret <4 x i32> %high
}
