
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotBoxBorderAttributes.h
    \\brief Definition of BoxPlotBoxBorder Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "BoxPlotBoxBorderAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

BoxPlotBoxBorderAttributes::BoxPlotBoxBorderAttributes():
	thickness_(ParameterManager::getInt("boxplot_box_border_thickness"))
	,
	colour_(MagTranslator<string, Colour>().magics("boxplot_box_border_colour")),
	style_(MagTranslator<string, LineStyle>().magics("boxplot_box_border_line_style"))
	
{
}


BoxPlotBoxBorderAttributes::~BoxPlotBoxBorderAttributes()
{

}


void BoxPlotBoxBorderAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "boxplot";
	prefix[i++] = "boxplot_box_border";
	
	setAttribute(prefix, "boxplot_box_border_thickness", thickness_, params);
	
	setMember(prefix, "boxplot_box_border_colour", colour_, params);
	setAttribute(prefix, "boxplot_box_border_line_style", style_, params);
	
}

void BoxPlotBoxBorderAttributes::copy(const BoxPlotBoxBorderAttributes& other)
{
	thickness_ = other.thickness_;
	colour_ = unique_ptr<Colour>(other.colour_->clone());
	style_ = other.style_;
	
}


bool BoxPlotBoxBorderAttributes::accept(const string& node)
{

	if ( magCompare(node, "box_border")  )
		return true;
	
	return false;
}

void BoxPlotBoxBorderAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "box_border")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void BoxPlotBoxBorderAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " thickness = " <<  thickness_;
	out << " colour = " <<  *colour_;
	out << " style = " <<  style_;
	
	out << "]" << "\n";
}

void BoxPlotBoxBorderAttributes::toxml(ostream& out)  const
{
	out <<  "\"box_border\"";
	out << ", \"boxplot_box_border_thickness\":";
	niceprint(out,thickness_);
	out << ", \"boxplot_box_border_colour\":";
	niceprint(out, *colour_);
	out << ", \"boxplot_box_border_line_style\":";
	niceprint(out, style_);
	
}

static MagicsParameter<int> boxplot_box_border_thickness("boxplot_box_border_thickness", 1);
static MagicsParameter<string> boxplot_box_border_colour("boxplot_box_border_colour", "navy");
static MagicsParameter<string> boxplot_box_border_line_style("boxplot_box_border_line_style", "solid");
