% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmlPart.R
\name{multiphyDat2pmlPart}
\alias{multiphyDat2pmlPart}
\alias{pmlPart2multiPhylo}
\alias{pmlPart}
\title{Partition model.}
\usage{
multiphyDat2pmlPart(x, method = "unrooted", tip.dates = NULL, ...)

pmlPart2multiPhylo(x)

pmlPart(formula, object, control = pml.control(epsilon = 1e-08, maxit = 10,
  trace = 1), model = NULL, method = "unrooted", ...)
}
\arguments{
\item{x}{an object of class \code{pmlPart}}

\item{method}{One of "unrooted", "ultrametric" or "tiplabeled". Only unrooted
is properly supported right now.}

\item{tip.dates}{A named vector of sampling times associated to the
tips/sequences. Leave empty if not estimating tip dated phylogenies.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{formula}{a formula object (see details).}

\item{object}{an object of class \code{pml} or a list of objects of class
\code{pml} .}

\item{control}{A list of parameters for controlling the fitting process.}

\item{model}{A vector containing the models containing a model for each
partition.}
}
\value{
\code{kcluster} returns a list with elements
\item{logLik}{log-likelihood of the fit} \item{trees}{a list of all trees
during the optimization.} \item{object}{an object of class \code{"pml"} or
\code{"pmlPart"}}
}
\description{
Model to estimate phylogenies for partitioned data.
}
\details{
The \code{formula} object allows to specify which parameter get optimized.
The formula is generally of the form \code{edge + bf + Q ~ rate + shape +
\dots{}}, on the left side are the parameters which get optimized over all
partitions, on the right the parameter which are optimized specific to each
partition. The parameters available are \code{"nni", "bf", "Q", "inv",
"shape", "edge", "rate"}.  Each parameters can be used only once in the
formula.  \code{"rate"} is only available for the right side of the formula.

For partitions with different edge weights, but same topology, \code{pmlPen}
can try to find more parsimonious models (see example).

\code{pmlPart2multiPhylo} is a convenience function to extract the trees out
of a \code{pmlPart} object.
}
\examples{

data(yeast)
dm <- dist.logDet(yeast)
tree <- NJ(dm)
fit <- pml(tree,yeast)
fits <- optim.pml(fit)

weight=xtabs(~ index+genes,attr(yeast, "index"))[,1:10]

sp <- pmlPart(edge ~ rate + inv, fits, weight=weight)
sp

\dontrun{
sp2 <- pmlPart(~ edge + inv, fits, weight=weight)
sp2
AIC(sp2)

sp3 <- pmlPen(sp2, lambda = 2)
AIC(sp3)
}

}
\seealso{
\code{\link{pml}},\code{\link{pmlCluster}},\code{\link{pmlMix}},
\code{\link{SH.test}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
