// Copyright © 2015-2017 winapi-rs developers
// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Defines property types and keys for the Plug and Play Device Property API
use shared::guiddef::{GUID, IsEqualGUID};
use shared::minwindef::ULONG;
use um::winnt::{CHAR, PCWSTR, PVOID};
pub type DEVPROPTYPE = ULONG;
pub type PDEVPROPTYPE = *mut ULONG;
pub const DEVPROP_TYPEMOD_ARRAY: DEVPROPTYPE = 0x00001000;
pub const DEVPROP_TYPEMOD_LIST: DEVPROPTYPE = 0x00002000;
pub const DEVPROP_TYPE_EMPTY: DEVPROPTYPE = 0x00000000;
pub const DEVPROP_TYPE_NULL: DEVPROPTYPE = 0x00000001;
pub const DEVPROP_TYPE_SBYTE: DEVPROPTYPE = 0x00000002;
pub const DEVPROP_TYPE_BYTE: DEVPROPTYPE = 0x00000003;
pub const DEVPROP_TYPE_INT16: DEVPROPTYPE = 0x00000004;
pub const DEVPROP_TYPE_UINT16: DEVPROPTYPE = 0x00000005;
pub const DEVPROP_TYPE_INT32: DEVPROPTYPE = 0x00000006;
pub const DEVPROP_TYPE_UINT32: DEVPROPTYPE = 0x00000007;
pub const DEVPROP_TYPE_INT64: DEVPROPTYPE = 0x00000008;
pub const DEVPROP_TYPE_UINT64: DEVPROPTYPE = 0x00000009;
pub const DEVPROP_TYPE_FLOAT: DEVPROPTYPE = 0x0000000A;
pub const DEVPROP_TYPE_DOUBLE: DEVPROPTYPE = 0x0000000B;
pub const DEVPROP_TYPE_DECIMAL: DEVPROPTYPE = 0x0000000C;
pub const DEVPROP_TYPE_GUID: DEVPROPTYPE = 0x0000000D;
pub const DEVPROP_TYPE_CURRENCY: DEVPROPTYPE = 0x0000000E;
pub const DEVPROP_TYPE_DATE: DEVPROPTYPE = 0x0000000F;
pub const DEVPROP_TYPE_FILETIME: DEVPROPTYPE = 0x00000010;
pub const DEVPROP_TYPE_BOOLEAN: DEVPROPTYPE = 0x00000011;
pub const DEVPROP_TYPE_STRING: DEVPROPTYPE = 0x00000012;
pub const DEVPROP_TYPE_STRING_LIST: DEVPROPTYPE = DEVPROP_TYPE_STRING | DEVPROP_TYPEMOD_LIST;
pub const DEVPROP_TYPE_SECURITY_DESCRIPTOR: DEVPROPTYPE = 0x00000013;
pub const DEVPROP_TYPE_SECURITY_DESCRIPTOR_STRING: DEVPROPTYPE = 0x00000014;
pub const DEVPROP_TYPE_DEVPROPKEY: DEVPROPTYPE = 0x00000015;
pub const DEVPROP_TYPE_DEVPROPTYPE: DEVPROPTYPE = 0x00000016;
pub const DEVPROP_TYPE_BINARY: DEVPROPTYPE = DEVPROP_TYPE_BYTE | DEVPROP_TYPEMOD_ARRAY;
pub const DEVPROP_TYPE_ERROR: DEVPROPTYPE = 0x00000017;
pub const DEVPROP_TYPE_NTSTATUS: DEVPROPTYPE = 0x00000018;
pub const DEVPROP_TYPE_STRING_INDIRECT: DEVPROPTYPE = 0x00000019;
pub const MAX_DEVPROP_TYPE: DEVPROPTYPE = 0x00000019;
pub const MAX_DEVPROP_TYPEMOD: DEVPROPTYPE = 0x00002000;
pub const DEVPROP_MASK_TYPE: DEVPROPTYPE = 0x00000FFF;
pub const DEVPROP_MASK_TYPEMOD: DEVPROPTYPE = 0x0000F000;
pub type DEVPROP_BOOLEAN = CHAR;
pub type PDEVPROP_BOOLEAN = *mut CHAR;
pub const DEVPROP_TRUE: DEVPROP_BOOLEAN = -1;
pub const DEVPROP_FALSE: DEVPROP_BOOLEAN = 0;
pub type DEVPROPGUID = GUID;
pub type PDEVPROPGUID = *mut GUID;
pub type DEVPROPID = ULONG;
pub type PDEVPROPID = *mut ULONG;
STRUCT!{struct DEVPROPKEY {
    fmtid: DEVPROPGUID,
    pid: DEVPROPID,
}}
pub type PDEVPROPKEY = *mut DEVPROPKEY;
#[inline]
pub fn IsEqualDevPropKey(a: &DEVPROPKEY, b: &DEVPROPKEY) -> bool {
    (a.pid == b.pid) && IsEqualGUID(&a.fmtid, &b.fmtid)
}
ENUM!{enum DEVPROPSTORE {
    DEVPROP_STORE_SYSTEM,
    DEVPROP_STORE_USER,
}}
pub type PDEVPROPSTORE = *mut DEVPROPSTORE;
STRUCT!{struct DEVPROPCOMPKEY {
    Key: DEVPROPKEY,
    Store: DEVPROPSTORE,
    LocaleName: PCWSTR,
}}
pub type PDEVPROPCOMPKEY = *mut DEVPROPCOMPKEY;
// IsEqualLocaleName
// IsEqualDevPropCompKey
STRUCT!{struct DEVPROPERTY {
    CompKey: DEVPROPCOMPKEY,
    Type: DEVPROPTYPE,
    BufferSize: ULONG,
    Buffer: PVOID,
}}
pub type PDEVPROPERTY = *mut DEVPROPERTY;
pub const DEVPROPID_FIRST_USABLE: DEVPROPID = 2;
