## TFSA-2021-199: Crash in `max_pool3d` when size argument is 0 or negative

### CVE Number
CVE-2021-41196

### Impact
The Keras pooling layers can trigger a segfault if the size of the pool is 0 or if a dimension is negative:

```python
import tensorflow as tf

pool_size = [2, 2, 0]
layer = tf.keras.layers.MaxPooling3D(strides=1, pool_size=pool_size)
input_tensor = tf.random.uniform([3, 4, 10, 11, 12], dtype=tf.float32)
res = layer(input_tensor)
```

This is due to the TensorFlow's implementation of pooling operations where the values in the sliding window are not checked to be strictly positive.

### Patches
We have patched the issue in GitHub commit [12b1ff82b3f26ff8de17e58703231d5a02ef1b8b](https://github.com/tensorflow/tensorflow/commit/12b1ff82b3f26ff8de17e58703231d5a02ef1b8b) (merging [#51975](https://github.com/tensorflow/tensorflow/pull/51975)).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported externally via a [GitHub issue](https://github.com/tensorflow/tensorflow/issues/51936).
