/* tracker-query.c generated by valac 0.22.1, the Vala compiler
 * generated from tracker-query.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_QUERY, TrackerQueryClass))
#define TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_QUERY))
#define TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
typedef struct _TrackerQueryPrivate TrackerQueryPrivate;

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (tracker_query_unref (var), NULL)))
typedef struct _TrackerQueryGetCountAsyncData TrackerQueryGetCountAsyncData;
typedef struct _TrackerQueryPerformAsyncData TrackerQueryPerformAsyncData;
typedef struct _TrackerParamSpecQuery TrackerParamSpecQuery;

struct _TrackerQuery {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerQueryPrivate * priv;
};

struct _TrackerQueryClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerQuery *self);
};

struct _TrackerQueryPrivate {
	gchar** match_clauses;
	gint match_clauses_length1;
	gint _match_clauses_size_;
	gchar** where_clauses;
	gint where_clauses_length1;
	gint _where_clauses_size_;
	gchar** sort_clauses;
	gint sort_clauses_length1;
	gint _sort_clauses_size_;
	gchar* _criteria;
	guint _offset;
	guint _limit;
	gchar* _query;
	GPtrArray* _tags;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT,
	TRACKER_QUERY_MATCH_TAGS_ONLY,
	TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT
} TrackerQueryMatch;

struct _TrackerQueryGetCountAsyncData {
	int _state_;
	GObject* _dummy_object_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerQuery* self;
	TrackerQueryType query_type;
	TrackerQueryMatch match_type;
	GCancellable* cancellable;
	guint result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* cursor;
	TrackerQueryType _tmp1_;
	TrackerQueryMatch _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	TrackerQueryMatch _tmp11_;
	TrackerQueryMatch _tmp12_;
	gboolean _tmp13_;
	TrackerQueryMatch _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	TrackerQueryMatch _tmp18_;
	TrackerQueryMatch _tmp19_;
	gboolean _tmp20_;
	TrackerQueryMatch _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	gchar* match;
	gboolean _tmp30_;
	TrackerQueryMatch _tmp31_;
	TrackerQueryMatch _tmp32_;
	gboolean _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	TrackerQueryMatch _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* criteria_escaped;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	TrackerQueryMatch _tmp43_;
	TrackerQueryMatch _tmp44_;
	gboolean _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	TrackerQueryMatch _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	TrackerQueryMatch _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gint _tmp57__length1;
	TrackerQueryType _tmp58_;
	const gchar* _tmp59_;
	gint _tmp60_;
	gint _tmp61_;
	const gchar* _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	TrackerQueryType _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	TrackerQueryType _tmp74_;
	const gchar* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	const gchar* _tmp78_;
	gchar** _tmp79_;
	gint _tmp79__length1;
	TrackerQueryType _tmp80_;
	const gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	TrackerSparqlCursor* _tmp86_;
	TrackerSparqlConnection* _tmp87_;
	const gchar* _tmp88_;
	TrackerSparqlCursor* _tmp89_;
	TrackerSparqlCursor* _tmp90_;
	GError* e;
	GError* _tmp91_;
	const gchar* _tmp92_;
	TrackerSparqlCursor* _tmp93_;
	gint64 _tmp94_;
	GError * _inner_error_;
};

struct _TrackerQueryPerformAsyncData {
	int _state_;
	GObject* _dummy_object_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerQuery* self;
	TrackerQueryType query_type;
	TrackerQueryMatch match_type;
	gchar** args;
	gint args_length1;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	TrackerSparqlConnection* _tmp0_;
	TrackerSparqlCursor* cursor;
	TrackerQueryType _tmp1_;
	TrackerQueryMatch _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GPtrArray* _tmp5_;
	GPtrArray* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	TrackerQueryMatch _tmp11_;
	TrackerQueryMatch _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	TrackerQueryMatch _tmp17_;
	TrackerQueryMatch _tmp18_;
	gboolean _tmp19_;
	TrackerQueryMatch _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	guint _tmp29_;
	gchar* match;
	gboolean _tmp30_;
	TrackerQueryMatch _tmp31_;
	TrackerQueryMatch _tmp32_;
	gboolean _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	TrackerQueryMatch _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* criteria_escaped;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	TrackerQueryMatch _tmp43_;
	TrackerQueryMatch _tmp44_;
	gboolean _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	TrackerQueryMatch _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	TrackerQueryMatch _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gint _tmp57__length1;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	TrackerQueryType _tmp63_;
	const gchar* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	const gchar* _tmp67_;
	gchar** _tmp68_;
	gint _tmp68__length1;
	TrackerQueryType _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar** _tmp78_;
	gint _tmp78__length1;
	TrackerQueryType _tmp79_;
	const gchar* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	const gchar* _tmp83_;
	gchar** _tmp84_;
	gint _tmp84__length1;
	TrackerQueryType _tmp85_;
	const gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	const gchar* _tmp91_;
	guint _tmp92_;
	guint _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	const gchar* _tmp98_;
	TrackerSparqlCursor* _tmp99_;
	TrackerSparqlConnection* _tmp100_;
	const gchar* _tmp101_;
	TrackerSparqlCursor* _tmp102_;
	GError* e;
	GError* _tmp103_;
	const gchar* _tmp104_;
	GError * _inner_error_;
};

struct _TrackerParamSpecQuery {
	GParamSpec parent_instance;
};


static gpointer tracker_query_parent_class = NULL;
static TrackerSparqlConnection* tracker_query_connection;
static TrackerSparqlConnection* tracker_query_connection = NULL;

gpointer tracker_query_ref (gpointer instance);
void tracker_query_unref (gpointer instance);
GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_query (GValue* value, gpointer v_object);
void tracker_value_take_query (GValue* value, gpointer v_object);
gpointer tracker_value_get_query (const GValue* value);
GType tracker_query_get_type (void) G_GNUC_CONST;
#define TRACKER_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_QUERY, TrackerQueryPrivate))
enum  {
	TRACKER_QUERY_DUMMY_PROPERTY
};
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
void tracker_query_set_tags (TrackerQuery* self, GPtrArray* value);
static gchar* tracker_query_get_tags_filter (TrackerQuery* self);
GPtrArray* tracker_query_get_tags (TrackerQuery* self);
static gboolean tracker_query_check_query_and_match_type (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type);
static void tracker_query_get_count_async_data_free (gpointer _data);
void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_query_get_count_async_co (TrackerQueryGetCountAsyncData* _data_);
const gchar* tracker_query_get_criteria (TrackerQuery* self);
static void tracker_query_set_query (TrackerQuery* self, const gchar* value);
const gchar* tracker_query_get_query (TrackerQuery* self);
static void tracker_query_get_count_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_query_perform_async_data_free (gpointer _data);
void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_query_perform_async_co (TrackerQueryPerformAsyncData* _data_);
guint tracker_query_get_limit (TrackerQuery* self);
guint tracker_query_get_offset (TrackerQuery* self);
static void tracker_query_perform_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_query_set_criteria (TrackerQuery* self, const gchar* value);
void tracker_query_set_offset (TrackerQuery* self, guint value);
void tracker_query_set_limit (TrackerQuery* self, guint value);
static void tracker_query_finalize (TrackerQuery* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType tracker_query_type_get_type (void) {
	static volatile gsize tracker_query_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_QUERY_TYPE_ALL, "TRACKER_QUERY_TYPE_ALL", "all"}, {TRACKER_QUERY_TYPE_CONTACTS, "TRACKER_QUERY_TYPE_CONTACTS", "contacts"}, {TRACKER_QUERY_TYPE_APPLICATIONS, "TRACKER_QUERY_TYPE_APPLICATIONS", "applications"}, {TRACKER_QUERY_TYPE_MUSIC, "TRACKER_QUERY_TYPE_MUSIC", "music"}, {TRACKER_QUERY_TYPE_IMAGES, "TRACKER_QUERY_TYPE_IMAGES", "images"}, {TRACKER_QUERY_TYPE_VIDEOS, "TRACKER_QUERY_TYPE_VIDEOS", "videos"}, {TRACKER_QUERY_TYPE_DOCUMENTS, "TRACKER_QUERY_TYPE_DOCUMENTS", "documents"}, {TRACKER_QUERY_TYPE_MAIL, "TRACKER_QUERY_TYPE_MAIL", "mail"}, {TRACKER_QUERY_TYPE_CALENDAR, "TRACKER_QUERY_TYPE_CALENDAR", "calendar"}, {TRACKER_QUERY_TYPE_FOLDERS, "TRACKER_QUERY_TYPE_FOLDERS", "folders"}, {TRACKER_QUERY_TYPE_BOOKMARKS, "TRACKER_QUERY_TYPE_BOOKMARKS", "bookmarks"}, {0, NULL, NULL}};
		GType tracker_query_type_type_id;
		tracker_query_type_type_id = g_enum_register_static ("TrackerQueryType", values);
		g_once_init_leave (&tracker_query_type_type_id__volatile, tracker_query_type_type_id);
	}
	return tracker_query_type_type_id__volatile;
}


GType tracker_query_match_get_type (void) {
	static volatile gsize tracker_query_match_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_match_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_QUERY_MATCH_NONE, "TRACKER_QUERY_MATCH_NONE", "none"}, {TRACKER_QUERY_MATCH_FTS, "TRACKER_QUERY_MATCH_FTS", "fts"}, {TRACKER_QUERY_MATCH_FTS_INDIRECT, "TRACKER_QUERY_MATCH_FTS_INDIRECT", "fts-indirect"}, {TRACKER_QUERY_MATCH_TITLES, "TRACKER_QUERY_MATCH_TITLES", "titles"}, {TRACKER_QUERY_MATCH_TITLES_INDIRECT, "TRACKER_QUERY_MATCH_TITLES_INDIRECT", "titles-indirect"}, {TRACKER_QUERY_MATCH_TAGS_ONLY, "TRACKER_QUERY_MATCH_TAGS_ONLY", "tags-only"}, {TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT, "TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT", "tags-only-indirect"}, {0, NULL, NULL}};
		GType tracker_query_match_type_id;
		tracker_query_match_type_id = g_enum_register_static ("TrackerQueryMatch", values);
		g_once_init_leave (&tracker_query_match_type_id__volatile, tracker_query_match_type_id);
	}
	return tracker_query_match_type_id__volatile;
}


TrackerQuery* tracker_query_construct (GType object_type) {
	TrackerQuery* self = NULL;
	GError * _inner_error_ = NULL;
	self = (TrackerQuery*) g_type_create_instance (object_type);
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_ = NULL;
		_tmp1_ = tracker_sparql_connection_get (NULL, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_g_object_unref0 (tracker_query_connection);
		tracker_query_connection = _tmp0_;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("tracker-query.vala:228: Could not get Sparql connection: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	tracker_query_set_tags (self, NULL);
	return self;
}


TrackerQuery* tracker_query_new (void) {
	return tracker_query_construct (TRACKER_TYPE_QUERY);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gchar* tracker_query_get_tags_filter (TrackerQuery* self) {
	gchar* result = NULL;
	gchar* filter = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GPtrArray* _tmp2_ = NULL;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	filter = _tmp0_;
	_tmp2_ = self->priv->_tags;
	if (_tmp2_ != NULL) {
		GPtrArray* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = self->priv->_tags;
		_tmp4_ = g_ptr_array_get_length (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					gboolean _tmp8_ = FALSE;
					gint _tmp10_ = 0;
					GPtrArray* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					gchar* escaped = NULL;
					GPtrArray* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gconstpointer _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					const gchar* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					_tmp8_ = _tmp7_;
					if (!_tmp8_) {
						gint _tmp9_ = 0;
						_tmp9_ = i;
						i = _tmp9_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp10_ = i;
					_tmp11_ = self->priv->_tags;
					_tmp12_ = g_ptr_array_get_length (_tmp11_);
					_tmp13_ = _tmp12_;
					if (!(_tmp10_ < _tmp13_)) {
						break;
					}
					_tmp14_ = self->priv->_tags;
					_tmp15_ = i;
					_tmp16_ = g_ptr_array_index (_tmp14_, (guint) _tmp15_);
					_tmp17_ = tracker_sparql_escape_string ((const gchar*) _tmp16_);
					escaped = _tmp17_;
					_tmp18_ = filter;
					_tmp19_ = strlen (_tmp18_);
					_tmp20_ = _tmp19_;
					if (_tmp20_ > 1) {
						const gchar* _tmp21_ = NULL;
						gchar* _tmp22_ = NULL;
						_tmp21_ = filter;
						_tmp22_ = g_strconcat (_tmp21_, ", ", NULL);
						_g_free0 (filter);
						filter = _tmp22_;
					}
					_tmp23_ = filter;
					_tmp24_ = escaped;
					_tmp25_ = g_strdup_printf ("\"%s\"", _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp23_, _tmp26_, NULL);
					_g_free0 (filter);
					filter = _tmp27_;
					_g_free0 (_tmp26_);
					_g_free0 (escaped);
				}
			}
		}
	}
	result = filter;
	return result;
}


static gboolean tracker_query_check_query_and_match_type (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerQueryType _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	TrackerQueryType _tmp6_ = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	TrackerQueryType _tmp14_ = 0;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp24_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = query_type;
	if (_tmp1_ != TRACKER_QUERY_TYPE_IMAGES) {
		TrackerQueryMatch _tmp2_ = 0;
		_tmp2_ = match_type;
		_tmp0_ = _tmp2_ == TRACKER_QUERY_MATCH_NONE;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		TrackerQueryType _tmp4_ = 0;
		_tmp4_ = query_type;
		g_critical ("tracker-query.vala:253: You can not use a non-IMAGES query (%d) with N" \
"ONE matching", (gint) _tmp4_);
		result = FALSE;
		return result;
	}
	_tmp6_ = query_type;
	if (_tmp6_ == TRACKER_QUERY_TYPE_MUSIC) {
		gboolean _tmp7_ = FALSE;
		TrackerQueryMatch _tmp8_ = 0;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = match_type;
		if (_tmp8_ == TRACKER_QUERY_MATCH_FTS_INDIRECT) {
			_tmp7_ = TRUE;
		} else {
			TrackerQueryMatch _tmp9_ = 0;
			_tmp9_ = match_type;
			_tmp7_ = _tmp9_ == TRACKER_QUERY_MATCH_TITLES_INDIRECT;
		}
		_tmp10_ = _tmp7_;
		_tmp5_ = !_tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp11_ = _tmp5_;
	if (_tmp11_) {
		g_critical ("tracker-query.vala:259: You can not use a MUSIC query with match TITLE" \
"S or FTS, INDIRECT required");
		result = FALSE;
		return result;
	}
	_tmp14_ = query_type;
	if (_tmp14_ != TRACKER_QUERY_TYPE_MUSIC) {
		TrackerQueryType _tmp15_ = 0;
		_tmp15_ = query_type;
		_tmp13_ = _tmp15_ != TRACKER_QUERY_TYPE_DOCUMENTS;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp16_ = _tmp13_;
	if (_tmp16_) {
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		TrackerQueryMatch _tmp19_ = 0;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp19_ = match_type;
		if (_tmp19_ == TRACKER_QUERY_MATCH_NONE) {
			_tmp18_ = TRUE;
		} else {
			TrackerQueryMatch _tmp20_ = 0;
			_tmp20_ = match_type;
			_tmp18_ = _tmp20_ == TRACKER_QUERY_MATCH_FTS;
		}
		_tmp21_ = _tmp18_;
		if (_tmp21_) {
			_tmp17_ = TRUE;
		} else {
			TrackerQueryMatch _tmp22_ = 0;
			_tmp22_ = match_type;
			_tmp17_ = _tmp22_ == TRACKER_QUERY_MATCH_TITLES;
		}
		_tmp23_ = _tmp17_;
		_tmp12_ = !_tmp23_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp24_ = _tmp12_;
	if (_tmp24_) {
		TrackerQueryType _tmp25_ = 0;
		TrackerQueryMatch _tmp26_ = 0;
		_tmp25_ = query_type;
		_tmp26_ = match_type;
		g_critical ("tracker-query.vala:267: You can not use a non-MUSIC or non-DOCUMENTS q" \
"uery (%d) with INDIRECT matching (%d)", (gint) _tmp25_, (gint) _tmp26_);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void tracker_query_get_count_async_data_free (gpointer _data) {
	TrackerQueryGetCountAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_tracker_query_unref0 (_data_->self);
	g_object_unref (_data_->_dummy_object_);
	g_slice_free (TrackerQueryGetCountAsyncData, _data_);
}


static gpointer _tracker_query_ref0 (gpointer self) {
	return self ? tracker_query_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerQueryGetCountAsyncData* _data_;
	TrackerQuery* _tmp0_ = NULL;
	TrackerQueryType _tmp1_ = 0;
	TrackerQueryMatch _tmp2_ = 0;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (TrackerQueryGetCountAsyncData);
	_data_->_dummy_object_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_data_->_async_result = g_simple_async_result_new (_data_->_dummy_object_, _callback_, _user_data_, tracker_query_get_count_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_query_get_count_async_data_free);
	_tmp0_ = _tracker_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_type;
	_data_->query_type = _tmp1_;
	_tmp2_ = match_type;
	_data_->match_type = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	tracker_query_get_count_async_co (_data_);
}


guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error) {
	guint result;
	TrackerQueryGetCountAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0U;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void tracker_query_get_count_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerQueryGetCountAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_query_get_count_async_co (_data_);
}


static gboolean tracker_query_get_count_async_co (TrackerQueryGetCountAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = tracker_query_connection;
	g_return_val_if_fail (_data_->_tmp0_ != NULL, FALSE);
	_data_->cursor = NULL;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->query_type;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->match_type;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = tracker_query_check_query_and_match_type (_data_->self, _data_->_tmp1_, _data_->_tmp2_);
	if (!_data_->_tmp3_) {
		_data_->result = (guint) 0;
		_g_object_unref0 (_data_->cursor);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->priv->_tags;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->_tags;
		_data_->_tmp7_ = 0;
		_data_->_tmp7_ = g_ptr_array_get_length (_data_->_tmp6_);
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp4_ = _data_->_tmp8_ > 0;
	} else {
		_data_->_tmp4_ = FALSE;
	}
	_data_->_tmp9_ = FALSE;
	_data_->_tmp9_ = _data_->_tmp4_;
	if (_data_->_tmp9_) {
		_data_->_tmp11_ = 0;
		_data_->_tmp11_ = _data_->match_type;
		if (_data_->_tmp11_ == TRACKER_QUERY_MATCH_FTS_INDIRECT) {
			_data_->_tmp10_ = TRUE;
		} else {
			_data_->_tmp12_ = 0;
			_data_->_tmp12_ = _data_->match_type;
			_data_->_tmp10_ = _data_->_tmp12_ == TRACKER_QUERY_MATCH_TITLES_INDIRECT;
		}
		_data_->_tmp13_ = FALSE;
		_data_->_tmp13_ = _data_->_tmp10_;
		if (_data_->_tmp13_) {
			_data_->match_type = TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT;
		} else {
			_data_->match_type = TRACKER_QUERY_MATCH_TAGS_ONLY;
		}
	}
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = _data_->match_type;
	g_debug ("tracker-query.vala:291: match_type:%d", (gint) _data_->_tmp14_);
	_data_->_tmp18_ = 0;
	_data_->_tmp18_ = _data_->match_type;
	if (_data_->_tmp18_ != TRACKER_QUERY_MATCH_NONE) {
		_data_->_tmp19_ = 0;
		_data_->_tmp19_ = _data_->match_type;
		_data_->_tmp17_ = _data_->_tmp19_ != TRACKER_QUERY_MATCH_TAGS_ONLY;
	} else {
		_data_->_tmp17_ = FALSE;
	}
	_data_->_tmp20_ = FALSE;
	_data_->_tmp20_ = _data_->_tmp17_;
	if (_data_->_tmp20_) {
		_data_->_tmp21_ = 0;
		_data_->_tmp21_ = _data_->match_type;
		_data_->_tmp16_ = _data_->_tmp21_ != TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT;
	} else {
		_data_->_tmp16_ = FALSE;
	}
	_data_->_tmp22_ = FALSE;
	_data_->_tmp22_ = _data_->_tmp16_;
	if (_data_->_tmp22_) {
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->self->priv->_criteria;
		if (_data_->_tmp24_ == NULL) {
			_data_->_tmp23_ = TRUE;
		} else {
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->self->priv->_criteria;
			_data_->_tmp26_ = 0;
			_data_->_tmp26_ = strlen (_data_->_tmp25_);
			_data_->_tmp27_ = 0;
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp23_ = _data_->_tmp27_ < 1;
		}
		_data_->_tmp28_ = FALSE;
		_data_->_tmp28_ = _data_->_tmp23_;
		_data_->_tmp15_ = _data_->_tmp28_;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	_data_->_tmp29_ = FALSE;
	_data_->_tmp29_ = _data_->_tmp15_;
	if (_data_->_tmp29_) {
		g_warning ("tracker-query.vala:296: Criteria was NULL or an empty string no query " \
"performed");
		_data_->result = (guint) 0;
		_g_object_unref0 (_data_->cursor);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = 0;
	_data_->_tmp31_ = _data_->match_type;
	if (_data_->_tmp31_ == TRACKER_QUERY_MATCH_TAGS_ONLY) {
		_data_->_tmp30_ = TRUE;
	} else {
		_data_->_tmp32_ = 0;
		_data_->_tmp32_ = _data_->match_type;
		_data_->_tmp30_ = _data_->_tmp32_ == TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT;
	}
	_data_->_tmp33_ = FALSE;
	_data_->_tmp33_ = _data_->_tmp30_;
	if (_data_->_tmp33_) {
		_data_->_tmp34_ = NULL;
		_data_->_tmp34__length1 = 0;
		_data_->_tmp34_ = _data_->self->priv->match_clauses;
		_data_->_tmp34__length1 = _data_->self->priv->match_clauses_length1;
		_data_->_tmp35_ = 0;
		_data_->_tmp35_ = _data_->match_type;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_tmp34_[_data_->_tmp35_];
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = tracker_query_get_tags_filter (_data_->self);
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->_tmp37_;
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = g_strdup_printf (_data_->_tmp36_, _data_->_tmp38_);
		_g_free0 (_data_->match);
		_data_->match = _data_->_tmp39_;
		_g_free0 (_data_->_tmp38_);
	} else {
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = _data_->self->priv->_criteria;
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = tracker_sparql_escape_string (_data_->_tmp40_);
		_data_->criteria_escaped = _data_->_tmp41_;
		_data_->_tmp43_ = 0;
		_data_->_tmp43_ = _data_->match_type;
		if (_data_->_tmp43_ == TRACKER_QUERY_MATCH_FTS) {
			_data_->_tmp42_ = TRUE;
		} else {
			_data_->_tmp44_ = 0;
			_data_->_tmp44_ = _data_->match_type;
			_data_->_tmp42_ = _data_->_tmp44_ == TRACKER_QUERY_MATCH_FTS_INDIRECT;
		}
		_data_->_tmp45_ = FALSE;
		_data_->_tmp45_ = _data_->_tmp42_;
		if (_data_->_tmp45_) {
			_data_->_tmp46_ = NULL;
			_data_->_tmp46__length1 = 0;
			_data_->_tmp46_ = _data_->self->priv->match_clauses;
			_data_->_tmp46__length1 = _data_->self->priv->match_clauses_length1;
			_data_->_tmp47_ = 0;
			_data_->_tmp47_ = _data_->match_type;
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->_tmp46_[_data_->_tmp47_];
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = _data_->criteria_escaped;
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = _data_->criteria_escaped;
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = g_strdup_printf (_data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_);
			_g_free0 (_data_->match);
			_data_->match = _data_->_tmp51_;
		} else {
			_data_->_tmp52_ = NULL;
			_data_->_tmp52__length1 = 0;
			_data_->_tmp52_ = _data_->self->priv->match_clauses;
			_data_->_tmp52__length1 = _data_->self->priv->match_clauses_length1;
			_data_->_tmp53_ = 0;
			_data_->_tmp53_ = _data_->match_type;
			_data_->_tmp54_ = NULL;
			_data_->_tmp54_ = _data_->_tmp52_[_data_->_tmp53_];
			_data_->_tmp55_ = NULL;
			_data_->_tmp55_ = _data_->criteria_escaped;
			_data_->_tmp56_ = NULL;
			_data_->_tmp56_ = g_strdup_printf (_data_->_tmp54_, _data_->_tmp55_);
			_g_free0 (_data_->match);
			_data_->match = _data_->_tmp56_;
		}
		_g_free0 (_data_->criteria_escaped);
	}
	tracker_query_set_query (_data_->self, "SELECT count(?urn)");
	_data_->_tmp57_ = NULL;
	_data_->_tmp57__length1 = 0;
	_data_->_tmp57_ = _data_->self->priv->where_clauses;
	_data_->_tmp57__length1 = _data_->self->priv->where_clauses_length1;
	_data_->_tmp58_ = 0;
	_data_->_tmp58_ = _data_->query_type;
	_data_->_tmp59_ = NULL;
	_data_->_tmp59_ = _data_->_tmp57_[_data_->_tmp58_];
	_data_->_tmp60_ = 0;
	_data_->_tmp60_ = strlen (_data_->_tmp59_);
	_data_->_tmp61_ = 0;
	_data_->_tmp61_ = _data_->_tmp60_;
	if (_data_->_tmp61_ > 0) {
		_data_->_tmp62_ = NULL;
		_data_->_tmp62_ = _data_->self->priv->_query;
		_data_->_tmp63_ = NULL;
		_data_->_tmp63__length1 = 0;
		_data_->_tmp63_ = _data_->self->priv->where_clauses;
		_data_->_tmp63__length1 = _data_->self->priv->where_clauses_length1;
		_data_->_tmp64_ = 0;
		_data_->_tmp64_ = _data_->query_type;
		_data_->_tmp65_ = NULL;
		_data_->_tmp65_ = _data_->_tmp63_[_data_->_tmp64_];
		_data_->_tmp66_ = NULL;
		_data_->_tmp66_ = _data_->match;
		_data_->_tmp67_ = NULL;
		_data_->_tmp67_ = g_strdup_printf (_data_->_tmp65_, _data_->_tmp66_);
		_data_->_tmp68_ = NULL;
		_data_->_tmp68_ = _data_->_tmp67_;
		_data_->_tmp69_ = NULL;
		_data_->_tmp69_ = g_strconcat (" ", _data_->_tmp68_, NULL);
		_data_->_tmp70_ = NULL;
		_data_->_tmp70_ = _data_->_tmp69_;
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = g_strconcat (_data_->_tmp62_, _data_->_tmp70_, NULL);
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = _data_->_tmp71_;
		tracker_query_set_query (_data_->self, _data_->_tmp72_);
		_g_free0 (_data_->_tmp72_);
		_g_free0 (_data_->_tmp70_);
		_g_free0 (_data_->_tmp68_);
	}
	_data_->_tmp73_ = NULL;
	_data_->_tmp73__length1 = 0;
	_data_->_tmp73_ = _data_->self->priv->sort_clauses;
	_data_->_tmp73__length1 = _data_->self->priv->sort_clauses_length1;
	_data_->_tmp74_ = 0;
	_data_->_tmp74_ = _data_->query_type;
	_data_->_tmp75_ = NULL;
	_data_->_tmp75_ = _data_->_tmp73_[_data_->_tmp74_];
	_data_->_tmp76_ = 0;
	_data_->_tmp76_ = strlen (_data_->_tmp75_);
	_data_->_tmp77_ = 0;
	_data_->_tmp77_ = _data_->_tmp76_;
	if (_data_->_tmp77_ > 0) {
		_data_->_tmp78_ = NULL;
		_data_->_tmp78_ = _data_->self->priv->_query;
		_data_->_tmp79_ = NULL;
		_data_->_tmp79__length1 = 0;
		_data_->_tmp79_ = _data_->self->priv->sort_clauses;
		_data_->_tmp79__length1 = _data_->self->priv->sort_clauses_length1;
		_data_->_tmp80_ = 0;
		_data_->_tmp80_ = _data_->query_type;
		_data_->_tmp81_ = NULL;
		_data_->_tmp81_ = _data_->_tmp79_[_data_->_tmp80_];
		_data_->_tmp82_ = NULL;
		_data_->_tmp82_ = g_strconcat (" ORDER BY ", _data_->_tmp81_, NULL);
		_data_->_tmp83_ = NULL;
		_data_->_tmp83_ = _data_->_tmp82_;
		_data_->_tmp84_ = NULL;
		_data_->_tmp84_ = g_strconcat (_data_->_tmp78_, _data_->_tmp83_, NULL);
		_data_->_tmp85_ = NULL;
		_data_->_tmp85_ = _data_->_tmp84_;
		tracker_query_set_query (_data_->self, _data_->_tmp85_);
		_g_free0 (_data_->_tmp85_);
		_g_free0 (_data_->_tmp83_);
	}
	{
		_data_->_tmp87_ = NULL;
		_data_->_tmp87_ = tracker_query_connection;
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = _data_->self->priv->_query;
		_data_->_state_ = 1;
		tracker_sparql_connection_query_async (_data_->_tmp87_, _data_->_tmp88_, NULL, tracker_query_get_count_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = tracker_sparql_connection_query_finish (_data_->_tmp87_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp86_ = _data_->_tmp89_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_g_object_unref0 (_data_->cursor);
		_data_->cursor = _data_->_tmp86_;
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = _data_->cursor;
		_data_->_state_ = 2;
		tracker_sparql_cursor_next_async (_data_->_tmp90_, NULL, tracker_query_get_count_async_ready, _data_);
		return FALSE;
		_state_2:
		tracker_sparql_cursor_next_finish (_data_->_tmp90_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp91_ = NULL;
		_data_->_tmp91_ = _data_->e;
		_data_->_tmp92_ = NULL;
		_data_->_tmp92_ = _data_->_tmp91_->message;
		g_warning ("tracker-query.vala:331: Could not run Sparql count query: %s", _data_->_tmp92_);
		_g_error_free0 (_data_->e);
	}
	__finally4:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->match);
			_g_object_unref0 (_data_->cursor);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->match);
			_g_object_unref0 (_data_->cursor);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp93_ = NULL;
	_data_->_tmp93_ = _data_->cursor;
	_data_->_tmp94_ = 0LL;
	_data_->_tmp94_ = tracker_sparql_cursor_get_integer (_data_->_tmp93_, 0);
	_data_->result = (guint) _data_->_tmp94_;
	_g_free0 (_data_->match);
	_g_object_unref0 (_data_->cursor);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->match);
	_g_object_unref0 (_data_->cursor);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tracker_query_perform_async_data_free (gpointer _data) {
	TrackerQueryPerformAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_tracker_query_unref0 (_data_->self);
	g_object_unref (_data_->_dummy_object_);
	g_slice_free (TrackerQueryPerformAsyncData, _data_);
}


void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerQueryPerformAsyncData* _data_;
	TrackerQuery* _tmp0_ = NULL;
	TrackerQueryType _tmp1_ = 0;
	TrackerQueryMatch _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GCancellable* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	_data_ = g_slice_new0 (TrackerQueryPerformAsyncData);
	_data_->_dummy_object_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_data_->_async_result = g_simple_async_result_new (_data_->_dummy_object_, _callback_, _user_data_, tracker_query_perform_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_query_perform_async_data_free);
	_tmp0_ = _tracker_query_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_type;
	_data_->query_type = _tmp1_;
	_tmp2_ = match_type;
	_data_->match_type = _tmp2_;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_data_->args = _tmp3_;
	_data_->args_length1 = _tmp3__length1;
	_tmp4_ = cancellable;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp5_;
	tracker_query_perform_async_co (_data_);
}


TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerQueryPerformAsyncData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void tracker_query_perform_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerQueryPerformAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_query_perform_async_co (_data_);
}


static gboolean tracker_query_perform_async_co (TrackerQueryPerformAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = tracker_query_connection;
	g_return_val_if_fail (_data_->_tmp0_ != NULL, FALSE);
	_data_->cursor = NULL;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->query_type;
	_data_->_tmp2_ = 0;
	_data_->_tmp2_ = _data_->match_type;
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = tracker_query_check_query_and_match_type (_data_->self, _data_->_tmp1_, _data_->_tmp2_);
	if (!_data_->_tmp3_) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->cursor);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->priv->_tags;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->self->priv->_tags;
		_data_->_tmp7_ = 0;
		_data_->_tmp7_ = g_ptr_array_get_length (_data_->_tmp6_);
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp4_ = _data_->_tmp8_ > 0;
	} else {
		_data_->_tmp4_ = FALSE;
	}
	_data_->_tmp9_ = FALSE;
	_data_->_tmp9_ = _data_->_tmp4_;
	if (_data_->_tmp9_) {
		_data_->_tmp11_ = 0;
		_data_->_tmp11_ = _data_->match_type;
		if (_data_->_tmp11_ == TRACKER_QUERY_MATCH_FTS_INDIRECT) {
			_data_->_tmp10_ = TRUE;
		} else {
			_data_->_tmp12_ = 0;
			_data_->_tmp12_ = _data_->match_type;
			_data_->_tmp10_ = _data_->_tmp12_ == TRACKER_QUERY_MATCH_TITLES_INDIRECT;
		}
		_data_->_tmp13_ = FALSE;
		_data_->_tmp13_ = _data_->_tmp10_;
		if (_data_->_tmp13_) {
			_data_->match_type = TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT;
		} else {
			_data_->match_type = TRACKER_QUERY_MATCH_TAGS_ONLY;
		}
	}
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = _data_->match_type;
	if (_data_->_tmp17_ != TRACKER_QUERY_MATCH_NONE) {
		_data_->_tmp18_ = 0;
		_data_->_tmp18_ = _data_->match_type;
		_data_->_tmp16_ = _data_->_tmp18_ != TRACKER_QUERY_MATCH_TAGS_ONLY;
	} else {
		_data_->_tmp16_ = FALSE;
	}
	_data_->_tmp19_ = FALSE;
	_data_->_tmp19_ = _data_->_tmp16_;
	if (_data_->_tmp19_) {
		_data_->_tmp20_ = 0;
		_data_->_tmp20_ = _data_->match_type;
		_data_->_tmp15_ = _data_->_tmp20_ != TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	_data_->_tmp21_ = FALSE;
	_data_->_tmp21_ = _data_->_tmp15_;
	if (_data_->_tmp21_) {
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->self->priv->_criteria;
		if (_data_->_tmp23_ == NULL) {
			_data_->_tmp22_ = TRUE;
		} else {
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->self->priv->_criteria;
			_data_->_tmp25_ = 0;
			_data_->_tmp25_ = strlen (_data_->_tmp24_);
			_data_->_tmp26_ = 0;
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp22_ = _data_->_tmp26_ < 1;
		}
		_data_->_tmp27_ = FALSE;
		_data_->_tmp27_ = _data_->_tmp22_;
		_data_->_tmp14_ = _data_->_tmp27_;
	} else {
		_data_->_tmp14_ = FALSE;
	}
	_data_->_tmp28_ = FALSE;
	_data_->_tmp28_ = _data_->_tmp14_;
	if (_data_->_tmp28_) {
		g_warning ("tracker-query.vala:359: Criteria was NULL or an empty string no query " \
"performed");
		_data_->result = NULL;
		_g_object_unref0 (_data_->cursor);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = 0U;
	_data_->_tmp29_ = _data_->self->priv->_limit;
	if (_data_->_tmp29_ < ((guint) 1)) {
		g_warning ("tracker-query.vala:364: Limit was < 1, no query performed");
		_data_->result = NULL;
		_g_object_unref0 (_data_->cursor);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp31_ = 0;
	_data_->_tmp31_ = _data_->match_type;
	if (_data_->_tmp31_ == TRACKER_QUERY_MATCH_TAGS_ONLY) {
		_data_->_tmp30_ = TRUE;
	} else {
		_data_->_tmp32_ = 0;
		_data_->_tmp32_ = _data_->match_type;
		_data_->_tmp30_ = _data_->_tmp32_ == TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT;
	}
	_data_->_tmp33_ = FALSE;
	_data_->_tmp33_ = _data_->_tmp30_;
	if (_data_->_tmp33_) {
		_data_->_tmp34_ = NULL;
		_data_->_tmp34__length1 = 0;
		_data_->_tmp34_ = _data_->self->priv->match_clauses;
		_data_->_tmp34__length1 = _data_->self->priv->match_clauses_length1;
		_data_->_tmp35_ = 0;
		_data_->_tmp35_ = _data_->match_type;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_tmp34_[_data_->_tmp35_];
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = tracker_query_get_tags_filter (_data_->self);
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->_tmp37_;
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = g_strdup_printf (_data_->_tmp36_, _data_->_tmp38_);
		_g_free0 (_data_->match);
		_data_->match = _data_->_tmp39_;
		_g_free0 (_data_->_tmp38_);
	} else {
		_data_->_tmp40_ = NULL;
		_data_->_tmp40_ = _data_->self->priv->_criteria;
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = tracker_sparql_escape_string (_data_->_tmp40_);
		_data_->criteria_escaped = _data_->_tmp41_;
		_data_->_tmp43_ = 0;
		_data_->_tmp43_ = _data_->match_type;
		if (_data_->_tmp43_ == TRACKER_QUERY_MATCH_FTS) {
			_data_->_tmp42_ = TRUE;
		} else {
			_data_->_tmp44_ = 0;
			_data_->_tmp44_ = _data_->match_type;
			_data_->_tmp42_ = _data_->_tmp44_ == TRACKER_QUERY_MATCH_FTS_INDIRECT;
		}
		_data_->_tmp45_ = FALSE;
		_data_->_tmp45_ = _data_->_tmp42_;
		if (_data_->_tmp45_) {
			_data_->_tmp46_ = NULL;
			_data_->_tmp46__length1 = 0;
			_data_->_tmp46_ = _data_->self->priv->match_clauses;
			_data_->_tmp46__length1 = _data_->self->priv->match_clauses_length1;
			_data_->_tmp47_ = 0;
			_data_->_tmp47_ = _data_->match_type;
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->_tmp46_[_data_->_tmp47_];
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = _data_->criteria_escaped;
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = _data_->criteria_escaped;
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = g_strdup_printf (_data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_);
			_g_free0 (_data_->match);
			_data_->match = _data_->_tmp51_;
		} else {
			_data_->_tmp52_ = NULL;
			_data_->_tmp52__length1 = 0;
			_data_->_tmp52_ = _data_->self->priv->match_clauses;
			_data_->_tmp52__length1 = _data_->self->priv->match_clauses_length1;
			_data_->_tmp53_ = 0;
			_data_->_tmp53_ = _data_->match_type;
			_data_->_tmp54_ = NULL;
			_data_->_tmp54_ = _data_->_tmp52_[_data_->_tmp53_];
			_data_->_tmp55_ = NULL;
			_data_->_tmp55_ = _data_->criteria_escaped;
			_data_->_tmp56_ = NULL;
			_data_->_tmp56_ = g_strdup_printf (_data_->_tmp54_, _data_->_tmp55_);
			_g_free0 (_data_->match);
			_data_->match = _data_->_tmp56_;
		}
		_g_free0 (_data_->criteria_escaped);
	}
	_data_->_tmp57_ = NULL;
	_data_->_tmp57__length1 = 0;
	_data_->_tmp57_ = _data_->args;
	_data_->_tmp57__length1 = _data_->args_length1;
	_data_->_tmp58_ = NULL;
	_data_->_tmp58_ = g_strjoinv (" ", _data_->_tmp57_);
	_data_->_tmp59_ = NULL;
	_data_->_tmp59_ = _data_->_tmp58_;
	_data_->_tmp60_ = NULL;
	_data_->_tmp60_ = g_strconcat ("SELECT ", _data_->_tmp59_, NULL);
	_data_->_tmp61_ = NULL;
	_data_->_tmp61_ = _data_->_tmp60_;
	tracker_query_set_query (_data_->self, _data_->_tmp61_);
	_g_free0 (_data_->_tmp61_);
	_g_free0 (_data_->_tmp59_);
	_data_->_tmp62_ = NULL;
	_data_->_tmp62__length1 = 0;
	_data_->_tmp62_ = _data_->self->priv->where_clauses;
	_data_->_tmp62__length1 = _data_->self->priv->where_clauses_length1;
	_data_->_tmp63_ = 0;
	_data_->_tmp63_ = _data_->query_type;
	_data_->_tmp64_ = NULL;
	_data_->_tmp64_ = _data_->_tmp62_[_data_->_tmp63_];
	_data_->_tmp65_ = 0;
	_data_->_tmp65_ = strlen (_data_->_tmp64_);
	_data_->_tmp66_ = 0;
	_data_->_tmp66_ = _data_->_tmp65_;
	if (_data_->_tmp66_ > 0) {
		_data_->_tmp67_ = NULL;
		_data_->_tmp67_ = _data_->self->priv->_query;
		_data_->_tmp68_ = NULL;
		_data_->_tmp68__length1 = 0;
		_data_->_tmp68_ = _data_->self->priv->where_clauses;
		_data_->_tmp68__length1 = _data_->self->priv->where_clauses_length1;
		_data_->_tmp69_ = 0;
		_data_->_tmp69_ = _data_->query_type;
		_data_->_tmp70_ = NULL;
		_data_->_tmp70_ = _data_->_tmp68_[_data_->_tmp69_];
		_data_->_tmp71_ = NULL;
		_data_->_tmp71_ = _data_->match;
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = g_strdup_printf (_data_->_tmp70_, _data_->_tmp71_);
		_data_->_tmp73_ = NULL;
		_data_->_tmp73_ = _data_->_tmp72_;
		_data_->_tmp74_ = NULL;
		_data_->_tmp74_ = g_strconcat (" ", _data_->_tmp73_, NULL);
		_data_->_tmp75_ = NULL;
		_data_->_tmp75_ = _data_->_tmp74_;
		_data_->_tmp76_ = NULL;
		_data_->_tmp76_ = g_strconcat (_data_->_tmp67_, _data_->_tmp75_, NULL);
		_data_->_tmp77_ = NULL;
		_data_->_tmp77_ = _data_->_tmp76_;
		tracker_query_set_query (_data_->self, _data_->_tmp77_);
		_g_free0 (_data_->_tmp77_);
		_g_free0 (_data_->_tmp75_);
		_g_free0 (_data_->_tmp73_);
	}
	_data_->_tmp78_ = NULL;
	_data_->_tmp78__length1 = 0;
	_data_->_tmp78_ = _data_->self->priv->sort_clauses;
	_data_->_tmp78__length1 = _data_->self->priv->sort_clauses_length1;
	_data_->_tmp79_ = 0;
	_data_->_tmp79_ = _data_->query_type;
	_data_->_tmp80_ = NULL;
	_data_->_tmp80_ = _data_->_tmp78_[_data_->_tmp79_];
	_data_->_tmp81_ = 0;
	_data_->_tmp81_ = strlen (_data_->_tmp80_);
	_data_->_tmp82_ = 0;
	_data_->_tmp82_ = _data_->_tmp81_;
	if (_data_->_tmp82_ > 0) {
		_data_->_tmp83_ = NULL;
		_data_->_tmp83_ = _data_->self->priv->_query;
		_data_->_tmp84_ = NULL;
		_data_->_tmp84__length1 = 0;
		_data_->_tmp84_ = _data_->self->priv->sort_clauses;
		_data_->_tmp84__length1 = _data_->self->priv->sort_clauses_length1;
		_data_->_tmp85_ = 0;
		_data_->_tmp85_ = _data_->query_type;
		_data_->_tmp86_ = NULL;
		_data_->_tmp86_ = _data_->_tmp84_[_data_->_tmp85_];
		_data_->_tmp87_ = NULL;
		_data_->_tmp87_ = g_strconcat (" ORDER BY ", _data_->_tmp86_, NULL);
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = _data_->_tmp87_;
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = g_strconcat (_data_->_tmp83_, _data_->_tmp88_, NULL);
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = _data_->_tmp89_;
		tracker_query_set_query (_data_->self, _data_->_tmp90_);
		_g_free0 (_data_->_tmp90_);
		_g_free0 (_data_->_tmp88_);
	}
	_data_->_tmp91_ = NULL;
	_data_->_tmp91_ = _data_->self->priv->_query;
	_data_->_tmp92_ = 0U;
	_data_->_tmp92_ = _data_->self->priv->_offset;
	_data_->_tmp93_ = 0U;
	_data_->_tmp93_ = _data_->self->priv->_limit;
	_data_->_tmp94_ = NULL;
	_data_->_tmp94_ = g_strdup_printf (" OFFSET %u LIMIT %u", _data_->_tmp92_, _data_->_tmp93_);
	_data_->_tmp95_ = NULL;
	_data_->_tmp95_ = _data_->_tmp94_;
	_data_->_tmp96_ = NULL;
	_data_->_tmp96_ = g_strconcat (_data_->_tmp91_, _data_->_tmp95_, NULL);
	_data_->_tmp97_ = NULL;
	_data_->_tmp97_ = _data_->_tmp96_;
	tracker_query_set_query (_data_->self, _data_->_tmp97_);
	_g_free0 (_data_->_tmp97_);
	_g_free0 (_data_->_tmp95_);
	_data_->_tmp98_ = NULL;
	_data_->_tmp98_ = _data_->self->priv->_query;
	g_debug ("tracker-query.vala:396: Running query: '%s'", _data_->_tmp98_);
	{
		_data_->_tmp100_ = NULL;
		_data_->_tmp100_ = tracker_query_connection;
		_data_->_tmp101_ = NULL;
		_data_->_tmp101_ = _data_->self->priv->_query;
		_data_->_state_ = 1;
		tracker_sparql_connection_query_async (_data_->_tmp100_, _data_->_tmp101_, NULL, tracker_query_perform_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp102_ = NULL;
		_data_->_tmp102_ = tracker_sparql_connection_query_finish (_data_->_tmp100_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp99_ = _data_->_tmp102_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_g_object_unref0 (_data_->cursor);
		_data_->cursor = _data_->_tmp99_;
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp103_ = NULL;
		_data_->_tmp103_ = _data_->e;
		_data_->_tmp104_ = NULL;
		_data_->_tmp104_ = _data_->_tmp103_->message;
		g_warning ("tracker-query.vala:401: Could not run Sparql query: %s", _data_->_tmp104_);
		_g_error_free0 (_data_->e);
	}
	__finally5:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->match);
			_g_object_unref0 (_data_->cursor);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->match);
			_g_object_unref0 (_data_->cursor);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	g_debug ("tracker-query.vala:404: Done");
	_data_->result = _data_->cursor;
	_g_free0 (_data_->match);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->match);
	_g_object_unref0 (_data_->cursor);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


const gchar* tracker_query_get_criteria (TrackerQuery* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_criteria;
	result = _tmp0_;
	return result;
}


void tracker_query_set_criteria (TrackerQuery* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_criteria);
	self->priv->_criteria = _tmp1_;
}


guint tracker_query_get_offset (TrackerQuery* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_offset;
	result = _tmp0_;
	return result;
}


void tracker_query_set_offset (TrackerQuery* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_offset = _tmp0_;
}


guint tracker_query_get_limit (TrackerQuery* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_limit;
	result = _tmp0_;
	return result;
}


void tracker_query_set_limit (TrackerQuery* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_limit = _tmp0_;
}


const gchar* tracker_query_get_query (TrackerQuery* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query;
	result = _tmp0_;
	return result;
}


static void tracker_query_set_query (TrackerQuery* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_query);
	self->priv->_query = _tmp1_;
}


GPtrArray* tracker_query_get_tags (TrackerQuery* self) {
	GPtrArray* result;
	GPtrArray* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tags;
	result = _tmp0_;
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void tracker_query_set_tags (TrackerQuery* self, GPtrArray* value) {
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
	_g_ptr_array_unref0 (self->priv->_tags);
	self->priv->_tags = _tmp1_;
}


static void tracker_value_query_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_value_query_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_query_unref (value->data[0].v_pointer);
	}
}


static void tracker_value_query_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_query_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_value_query_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_value_query_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerQuery* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_query_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_value_query_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerQuery** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_query_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerParamSpecQuery* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_QUERY), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer tracker_value_get_query (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY), NULL);
	return value->data[0].v_pointer;
}


void tracker_value_set_query (GValue* value, gpointer v_object) {
	TrackerQuery* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_QUERY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_query_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_query_unref (old);
	}
}


void tracker_value_take_query (GValue* value, gpointer v_object) {
	TrackerQuery* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_QUERY));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_QUERY));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_query_unref (old);
	}
}


static void tracker_query_class_init (TrackerQueryClass * klass) {
	tracker_query_parent_class = g_type_class_peek_parent (klass);
	TRACKER_QUERY_CLASS (klass)->finalize = tracker_query_finalize;
	g_type_class_add_private (klass, sizeof (TrackerQueryPrivate));
}


static void tracker_query_instance_init (TrackerQuery * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	self->priv = TRACKER_QUERY_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	_tmp1_ = g_strdup ("{\n" \
"		   ?urn fts:match \"%s\"\n" \
"		 } UNION {\n" \
"		   ?urn nao:hasTag ?tag .\n" \
"                   FILTER (fn:contains (fn:lower-case (nao:prefLabel(?" \
"tag)), \"%s\"))\n" \
"		 }");
	_tmp2_ = g_strdup ("{\n" \
"		   ?match fts:match \"%s\"\n" \
"		 } UNION {\n" \
"		   ?match nao:hasTag ?tag .\n" \
"                   FILTER (fn:contains (fn:lower-case (nao:prefLabel(?" \
"tag)), \"%s\"))\n" \
"		 }");
	_tmp3_ = g_strdup ("FILTER (fn:contains (fn:lower-case (nfo:fileName(?urn)), \"%s\"))");
	_tmp4_ = g_strdup ("FILTER (fn:contains (fn:lower-case (nie:title(?match)), \"%s\"))");
	_tmp5_ = g_strdup ("?urn nao:hasTag ?tag .\n		 FILTER (nao:prefLabel(?tag) IN (%s))");
	_tmp6_ = g_strdup ("?match nao:hasTag ?tag .\n		 FILTER (nao:prefLabel(?tag) IN (%s))");
	_tmp7_ = g_new0 (gchar*, 7 + 1);
	_tmp7_[0] = _tmp0_;
	_tmp7_[1] = _tmp1_;
	_tmp7_[2] = _tmp2_;
	_tmp7_[3] = _tmp3_;
	_tmp7_[4] = _tmp4_;
	_tmp7_[5] = _tmp5_;
	_tmp7_[6] = _tmp6_;
	self->priv->match_clauses = _tmp7_;
	self->priv->match_clauses_length1 = 7;
	self->priv->_match_clauses_size_ = self->priv->match_clauses_length1;
	_tmp8_ = g_strdup ("WHERE {\n" \
"		  %s .\n" \
"		  ?urn nfo:belongsToContainer ?parent ;\n" \
"		  tracker:available true .\n" \
"		}");
	_tmp9_ = g_strdup ("");
	_tmp10_ = g_strdup ("WHERE {\n		  ?urn a nfo:Software .\n		  %s\n		}");
	_tmp11_ = g_strdup ("WHERE {\n" \
"		  {\n" \
"		    ?urn nmm:musicAlbum ?match\n" \
"		  } UNION {\n" \
"		    ?urn nmm:performer ?match\n" \
"		  } UNION {\n" \
"		    ?urn a nfo:Audio .\n" \
"		    ?match a nfo:Audio\n" \
"		    FILTER (?urn = ?match)\n" \
"		  }\n" \
"		  %s .\n" \
"		  ?urn nmm:performer [ nmm:artistName ?performer ] ;\n" \
"		       nmm:musicAlbum [ nie:title ?album ] ;\n" \
"		       nie:url ?tooltip .\n" \
"		}");
	_tmp12_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Image ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		}");
	_tmp13_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Video ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		}");
	_tmp14_ = g_strdup ("WHERE {\n" \
"		  {\n" \
"		    ?urn nco:creator ?match\n" \
"		  } UNION {\n" \
"		    ?urn nco:publisher ?match\n" \
"		  } UNION {\n" \
"		    ?urn a nfo:Document .\n" \
"		    ?match a nfo:Document\n" \
"		    FILTER (?urn = ?match)\n" \
"		  }\n" \
"		  %s .\n" \
"		  ?urn nie:url ?tooltip .\n" \
"		  OPTIONAL {\n" \
"		    ?urn nco:creator ?creator .\n" \
"		  }\n" \
"		  OPTIONAL {\n" \
"		    ?urn nco:publisher ?publisher .\n" \
"		  }\n" \
"		}");
	_tmp15_ = g_strdup ("WHERE {\n" \
"		  ?urn a nmo:Email ;\n" \
"		         nmo:from ?sender ;\n" \
"		         nmo:to ?to .\n" \
"		  %s\n" \
"		}");
	_tmp16_ = g_strdup ("");
	_tmp17_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Folder ;\n" \
"		         nie:url ?tooltip .\n" \
"		  %s\n" \
"		  OPTIONAL {\n" \
"		    ?urn nfo:belongsToContainer ?parent .\n" \
"		  }\n" \
"		}");
	_tmp18_ = g_strdup ("WHERE {\n" \
"		  ?urn a nfo:Bookmark ;\n" \
"                         nfo:bookmarks ?bookmark .\n" \
"		  %s\n" \
"		}");
	_tmp19_ = g_new0 (gchar*, 11 + 1);
	_tmp19_[0] = _tmp8_;
	_tmp19_[1] = _tmp9_;
	_tmp19_[2] = _tmp10_;
	_tmp19_[3] = _tmp11_;
	_tmp19_[4] = _tmp12_;
	_tmp19_[5] = _tmp13_;
	_tmp19_[6] = _tmp14_;
	_tmp19_[7] = _tmp15_;
	_tmp19_[8] = _tmp16_;
	_tmp19_[9] = _tmp17_;
	_tmp19_[10] = _tmp18_;
	self->priv->where_clauses = _tmp19_;
	self->priv->where_clauses_length1 = 11;
	self->priv->_where_clauses_size_ = self->priv->where_clauses_length1;
	_tmp20_ = g_strdup ("DESC(nfo:fileLastModified(?urn)) DESC(nie:contentCreated(?urn)) ASC(ni" \
"e:title(?urn))");
	_tmp21_ = g_strdup ("ASC(nco:fullname(?urn))");
	_tmp22_ = g_strdup ("ASC(nie:title(?urn)) ASC(nie:comment(?urn))");
	_tmp23_ = g_strdup ("DESC(nfo:fileLastModified(?urn)) ASC(nie:title(?urn))");
	_tmp24_ = g_strdup ("DESC(nfo:fileLastModified(?urn)) ASC(nie:title(?urn))");
	_tmp25_ = g_strdup ("DESC(nfo:fileLastModified(?urn)) ASC(nie:title(?urn))");
	_tmp26_ = g_strdup ("DESC(nfo:fileLastModified(?urn)) ASC(nie:title(?urn))");
	_tmp27_ = g_strdup ("DESC(nmo:receivedDate(?urn)) ASC(nmo:messageSubject(?urn))");
	_tmp28_ = g_strdup ("DESC(nie:contentCreated(?urn))");
	_tmp29_ = g_strdup ("DESC(nfo:fileLastModified(?urn)) ASC(nie:title(?urn))");
	_tmp30_ = g_strdup ("DESC(nie:contentLastModified(?urn)) ASC(nie:title(?urn))");
	_tmp31_ = g_new0 (gchar*, 11 + 1);
	_tmp31_[0] = _tmp20_;
	_tmp31_[1] = _tmp21_;
	_tmp31_[2] = _tmp22_;
	_tmp31_[3] = _tmp23_;
	_tmp31_[4] = _tmp24_;
	_tmp31_[5] = _tmp25_;
	_tmp31_[6] = _tmp26_;
	_tmp31_[7] = _tmp27_;
	_tmp31_[8] = _tmp28_;
	_tmp31_[9] = _tmp29_;
	_tmp31_[10] = _tmp30_;
	self->priv->sort_clauses = _tmp31_;
	self->priv->sort_clauses_length1 = 11;
	self->priv->_sort_clauses_size_ = self->priv->sort_clauses_length1;
	self->ref_count = 1;
}


static void tracker_query_finalize (TrackerQuery* obj) {
	TrackerQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_QUERY, TrackerQuery);
	self->priv->match_clauses = (_vala_array_free (self->priv->match_clauses, self->priv->match_clauses_length1, (GDestroyNotify) g_free), NULL);
	self->priv->where_clauses = (_vala_array_free (self->priv->where_clauses, self->priv->where_clauses_length1, (GDestroyNotify) g_free), NULL);
	self->priv->sort_clauses = (_vala_array_free (self->priv->sort_clauses, self->priv->sort_clauses_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_criteria);
	_g_free0 (self->priv->_query);
	_g_ptr_array_unref0 (self->priv->_tags);
}


GType tracker_query_get_type (void) {
	static volatile gsize tracker_query_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_query_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_query_init, tracker_value_query_free_value, tracker_value_query_copy_value, tracker_value_query_peek_pointer, "p", tracker_value_query_collect_value, "p", tracker_value_query_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerQuery), 0, (GInstanceInitFunc) tracker_query_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_query_type_id;
		tracker_query_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerQuery", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_query_type_id__volatile, tracker_query_type_id);
	}
	return tracker_query_type_id__volatile;
}


gpointer tracker_query_ref (gpointer instance) {
	TrackerQuery* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tracker_query_unref (gpointer instance) {
	TrackerQuery* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_QUERY_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



